/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt;

import com.kingdee.eas.fi.rpt.RptBalanceFullHint;
import com.kingdee.eas.fi.rpt.RptCheckExpTank;
import com.kingdee.eas.fi.rpt.RptConvertFullHint;
import com.kingdee.eas.fi.rpt.SheetEditObserverable;
import com.kingdee.eas.fi.rpt.util.IObjectIterator;
import com.kingdee.eas.fi.rpt.util.UserObjectTrans;
import java.io.Serializable;

public class RptOperationSchemaComp
implements Serializable {
    private static final String EXPTANK = "ExpTank";
    private static final String BALANCEHINTS = "BALANCEHINTS";
    private static final String CONVERTHINTS = "CONVERTHINTS";
    private static final long serialVersionUID = 20041129105333L;
    private RptConvertFullHint cvHints = null;
    private RptBalanceFullHint blHints = null;
    private RptCheckExpTank expTank = null;
    private transient SheetEditObserverable sheetEditObservable = new SheetEditObserverable();
    private boolean notifyOnSheetChanged = true;

    public RptOperationSchemaComp() {
        this.init();
    }

    public RptBalanceFullHint getBlHints() {
        return this.blHints;
    }

    public void setBlHints(RptBalanceFullHint hints) {
        this.blHints = hints;
        if (this.sheetEditObservable == null) {
            this.sheetEditObservable = new SheetEditObserverable();
        }
        this.sheetEditObservable.addObserver(BALANCEHINTS, this.blHints);
    }

    public RptConvertFullHint getCvHints() {
        return this.cvHints;
    }

    public void setCvHints(RptConvertFullHint hints) {
        this.cvHints = hints;
        if (this.sheetEditObservable == null) {
            this.sheetEditObservable = new SheetEditObserverable();
        }
        this.sheetEditObservable.addObserver(CONVERTHINTS, this.cvHints);
    }

    public RptCheckExpTank getExpTank() {
        return this.expTank;
    }

    public void setExpTank(RptCheckExpTank tank) {
        this.expTank = tank;
        if (this.sheetEditObservable == null) {
            this.sheetEditObservable = new SheetEditObserverable();
        }
        this.sheetEditObservable.addObserver(EXPTANK, this.expTank);
    }

    public void notifyAddNewSheet(String sheet) {
        if (this.notifyOnSheetChanged) {
            if (this.sheetEditObservable == null) {
                this.sheetEditObservable = new SheetEditObserverable();
            }
            this.sheetEditObservable.notifyAddNewSheet(sheet);
        }
    }

    public void notifyDeleteSheet(String sheet) {
        if (this.notifyOnSheetChanged && this.sheetEditObservable != null) {
            this.sheetEditObservable.notifyDeleteSheet(sheet);
        }
    }

    public void notifyRenameSheet(String oldName, String newName) {
        if (this.notifyOnSheetChanged) {
            this.sheetEditObservable.notifyRenameSheet(oldName, newName);
        }
    }

    public void init() {
        if (this.sheetEditObservable == null) {
            this.sheetEditObservable = new SheetEditObserverable();
        }
        this.sheetEditObservable.addObserver(BALANCEHINTS, this.blHints);
        this.sheetEditObservable.addObserver(CONVERTHINTS, this.cvHints);
        this.sheetEditObservable.addObserver(EXPTANK, this.expTank);
    }

    public void mergeSchema(RptOperationSchemaComp schema) {
        if (schema == null) {
            return;
        }
        if (this.cvHints == null) {
            this.cvHints = new RptConvertFullHint();
        }
        if (schema.cvHints != null) {
            this.cvHints.mergeConvertHints(schema.getCvHints().cvHint);
            this.cvHints.mergeBalanceHints(schema.getCvHints().baHint);
        }
        if (this.blHints == null) {
            this.blHints = new RptBalanceFullHint();
        }
        if (schema.blHints != null) {
            this.blHints.mergeConvertHints(schema.getBlHints().cvHint);
            this.blHints.mergeBalanceHints(schema.getBlHints().baHint);
        }
        if (this.expTank == null) {
            this.expTank = new RptCheckExpTank();
        }
        if (schema.expTank != null) {
            this.expTank.mergeExpressions(schema.getExpTank());
        }
    }

    public void clearSchema() {
        this.setBlHints(null);
        this.setCvHints(null);
        this.setExpTank(null);
    }

    public boolean isEmpty() {
        return this.cvHints == null && this.blHints == null && this.expTank == null;
    }

    public void fromSerialString(String s) throws Exception {
        IObjectIterator it = UserObjectTrans.createObjectIterator((String)s);
        if (it.hasNext()) {
            this.setCvHints((RptConvertFullHint)it.nextObject());
        }
        if (it.hasNext()) {
            this.setBlHints((RptBalanceFullHint)it.nextObject());
        }
        if (it.hasNext()) {
            this.setExpTank((RptCheckExpTank)it.nextObject());
        }
        this.init();
    }

    public String toSerialString() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(UserObjectTrans.getSerialString((Object)this.cvHints));
        sb.append(UserObjectTrans.getSerialString((Object)this.blHints));
        sb.append(UserObjectTrans.getSerialString((Object)this.expTank));
        return sb.toString();
    }

    public boolean isNotifyOnSheetChanged() {
        return this.notifyOnSheetChanged;
    }

    public void setNotifyOnSheetChanged(boolean notifyOnSheetChanged) {
        this.notifyOnSheetChanged = notifyOnSheetChanged;
    }

    public boolean isCheckExpEmpty() {
        return this.getExpTank() == null || this.getExpTank().getExpressions() == null || this.getExpTank().getExpressions().size() <= 0;
    }

    public class OperType {
        public static final int CONVERT = 1;
        public static final int BALANCE = 2;
    }
}

