/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt;

import com.kingdee.eas.fi.rpt.ISheetEditObserver;
import java.util.HashMap;
import java.util.Map;

public class SheetEditObserverable {
    private Map obs = new HashMap();

    public void notifyDeleteSheet(String sheet) {
        for (Map.Entry obj : this.obs.entrySet()) {
            ISheetEditObserver edt;
            if (obj == null || (edt = (ISheetEditObserver)obj.getValue()) == null) continue;
            edt.onDeleteSheet(sheet);
        }
    }

    public void notifyRenameSheet(String oldName, String newName) {
        Object[] arrLocal = this.obs.entrySet().toArray();
        for (int i = arrLocal.length - 1; i >= 0; --i) {
            ISheetEditObserver edt;
            if (arrLocal[i] == null || (edt = (ISheetEditObserver)((Map.Entry)arrLocal[i]).getValue()) == null) continue;
            edt.onRenameSheet(oldName, newName);
        }
    }

    public void notifyAddNewSheet(String sheet) {
        Object[] arrLocal = this.obs.entrySet().toArray();
        for (int i = arrLocal.length - 1; i >= 0; --i) {
            ISheetEditObserver edt;
            if (arrLocal[i] == null || (edt = (ISheetEditObserver)((Map.Entry)arrLocal[i]).getValue()) == null) continue;
            edt.onAddNewSheet(sheet);
        }
    }

    public void addObserver(String observerName, ISheetEditObserver o) {
        this.obs.put(observerName, o);
    }

    public void deleteObserver(String observerName) {
        this.obs.remove(observerName);
    }

    public void deleteObservers() {
        this.obs.clear();
    }

    public int countObservers() {
        return this.obs.size();
    }
}

