/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.app.Account;
import com.kingdee.eas.fi.rpt.app.AssistantItem;
import com.kingdee.eas.fi.rpt.app.AsstActType;
import com.kingdee.eas.fi.rpt.app.GroupTreeNode;
import com.kingdee.eas.fi.rpt.app.RptCalculaterDAO;
import com.kingdee.eas.fi.rpt.util.AcctountAsstItemParser;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class AccountItem
implements Serializable {
    public Account startAccount;
    public Account endAccount;
    public Account[][] discreteAccount = null;
    private Map items;
    private Context ctx;
    private CompanyOrgUnitInfo company;
    private AcctountAsstItemParser.AccountAsstItem acctitem;

    public AccountItem(Context ctx, String accountItem, CompanyOrgUnitInfo company) throws ReportException, BOSException {
        this.ctx = ctx;
        this.company = company;
        this.items = new HashMap(2);
        try {
            this.parseDiscreteAcctItem(accountItem);
        }
        catch (Exception e) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{e.getMessage()});
        }
    }

    public AccountItem(Context ctx, AcctountAsstItemParser.AccountAsstItem parsedAcctItem, CompanyOrgUnitInfo company) throws ReportException, BOSException {
        this.ctx = ctx;
        this.company = company;
        this.items = new HashMap(2);
        this.acctitem = parsedAcctItem;
    }

    public AccountItem(AcctountAsstItemParser.AccountAsstItem parsedAcctItem) {
        this.items = new HashMap(2);
        this.acctitem = parsedAcctItem;
    }

    public AccountItem(Account _startAccount, Account _endAccount, Map _items) {
        this.startAccount = _startAccount;
        this.endAccount = _endAccount;
        this.items = _items;
    }

    public boolean isSingleAccount() {
        return this.startAccount != null && this.endAccount != null && this.startAccount.number.equals(this.endAccount.number);
    }

    public boolean isDetailAccount() {
        return this.startAccount != null && this.startAccount.isLeaf;
    }

    public int itemSize() {
        return this.items.size();
    }

    public Map getItemTypes() {
        return this.items;
    }

    public void setItemTypes(Map items) {
        this.items = items;
    }

    public boolean hasItem() {
        return this.items.size() > 0;
    }

    public AssistantItem getItem(String itemTypeNumber) {
        return (AssistantItem)this.items.get(itemTypeNumber);
    }

    public AsstActType getItemType(String itemTypeNumber) {
        return this.getItem((String)itemTypeNumber).itemType;
    }

    public Set itemSet() {
        return this.items.keySet();
    }

    public boolean isSameLevel() {
        return this.startAccount != null && this.endAccount != null && this.startAccount.level == this.endAccount.level;
    }

    private void parseAcctItem(String strAcctItem) throws BOSException, ReportException {
        if (strAcctItem == null || strAcctItem.length() < 1) {
            throw new ReportException(ReportException.PARAM_IS_NOT_INTEGRATED);
        }
        while (strAcctItem.indexOf("||") > 0) {
            strAcctItem = strAcctItem.replaceAll("\\|\\|", "| |");
        }
        String strItemType = null;
        String strItem = null;
        StringTokenizer arrAcctItem = new StringTokenizer(strAcctItem.toUpperCase(), "|");
        int i = 1;
        AssistantItem item = new AssistantItem();
        RptCalculaterDAO calcDAO = new RptCalculaterDAO(this.ctx);
        while (arrAcctItem.hasMoreTokens()) {
            int iPos;
            if (1 == i) {
                String strAcct = null;
                strAcct = arrAcctItem.nextToken().trim();
                iPos = strAcct.indexOf(":");
                if (iPos >= 0) {
                    this.startAccount = calcDAO.getAccountByNumber(strAcct.substring(0, iPos).trim(), this.company);
                    this.endAccount = calcDAO.getAccountByNumber(strAcct.substring(iPos + 1).trim(), this.company);
                } else {
                    this.endAccount = this.startAccount = calcDAO.getAccountByNumber(strAcct, this.company.getNumber());
                }
            } else if (i % 2 == 0) {
                strItemType = arrAcctItem.nextToken().trim();
                if (strItemType != null && strItemType.length() < 1) continue;
                item = new AssistantItem();
                item.itemType = calcDAO.getAsstActTypeByNumber(strItemType);
                this.items.put(strItemType, item);
            } else {
                if (strItemType != null && strItemType.length() < 1) continue;
                strItem = arrAcctItem.nextToken().trim();
                if (!(!StringUtils.isEmpty((String)strItem) && strItem.length() < 1 || strItem.equals("*") && strItemType != null || StringUtils.isEmpty((String)strItem) || strItem.length() <= 0 || strItemType == null || strItemType.length() <= 0)) {
                    iPos = strItem.indexOf(":");
                    if (item.startItem == null) {
                        item.startItem = new GroupTreeNode();
                    }
                    if (item.endItem == null) {
                        item.endItem = new GroupTreeNode();
                    }
                    if (iPos >= 0) {
                        item.startItem.number = strItem.substring(0, iPos).trim();
                        item.endItem.number = strItem.substring(iPos + 1).trim();
                    } else {
                        item.startItem.number = item.endItem.number = strItem;
                    }
                }
                if (item.itemType.realtionDataObject != null && item.itemType.realtionDataObject.equalsIgnoreCase("t_bd_generalasstacttype")) {
                    item.startItem.number = item.startItem.number == null ? null : item.startItem.number.replaceAll("\\.", "\\!");
                    String string = item.endItem.number = item.endItem.number == null ? null : item.endItem.number.replaceAll("\\.", "\\!");
                    if (item.endItem.number != null && item.startItem.number != null && item.startItem.number != item.endItem.number && item.startItem.number.split("\\!").length != item.endItem.number.split("\\!").length) {
                        throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"AssistantItemMustbeTheSameLevel", (Locale)this.ctx.getOriginLocale())});
                    }
                } else if (item.itemType.realtionDataObject != null && (item.itemType.realtionDataObject.equalsIgnoreCase("T_ORG_Admin") || item.itemType.realtionDataObject.equalsIgnoreCase("T_BD_CashFlowItem"))) {
                    this.createAssistantInfo(calcDAO, item, false);
                    if (!item.isSameLevel()) {
                        throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"AssistantItemMustbeTheSameLevel", (Locale)this.ctx.getOriginLocale())});
                    }
                }
            }
            ++i;
        }
    }

    public AcctountAsstItemParser.AccountAsstItem getAccountAsstItem() {
        return this.acctitem;
    }

    private void parseDiscreteAcctItem(String strAcctItem) throws BOSException, ReportException, ParseException {
        int i;
        if (strAcctItem == null || strAcctItem.length() < 1) {
            throw new ReportException(ReportException.PARAM_IS_NOT_INTEGRATED);
        }
        this.acctitem = AcctountAsstItemParser.parse(strAcctItem);
        RptCalculaterDAO calcDAO = new RptCalculaterDAO(this.ctx);
        for (i = 0; this.acctitem.accounts != null && i < this.acctitem.accounts.length; ++i) {
            if (this.discreteAccount == null) {
                this.discreteAccount = new Account[this.acctitem.accounts.length][2];
            }
            try {
                this.discreteAccount[i][0] = calcDAO.getAccountByNumber(this.acctitem.accounts[i].startNumber, this.company);
                this.discreteAccount[i][1] = calcDAO.getAccountByNumber(this.acctitem.accounts[i].endNumber, this.company);
            }
            catch (Exception e) {
                continue;
            }
            if (i != 0) continue;
            this.startAccount = this.discreteAccount[0][0];
            this.endAccount = this.discreteAccount[0][1];
        }
        for (i = 0; this.acctitem.asstItems != null && i < this.acctitem.asstItems.length; ++i) {
            AssistantItem item = new AssistantItem();
            item.itemType = calcDAO.getAsstActTypeByNumber(this.acctitem.asstItems[i].asstTypeNumber);
            if (item.startItem == null) {
                item.startItem = new GroupTreeNode();
            }
            if (item.endItem == null) {
                item.endItem = new GroupTreeNode();
            }
            this.items.put(item.itemType.number, item);
            item.startItem.number = this.acctitem.asstItems[i].startNumber;
            item.endItem.number = this.acctitem.asstItems[i].endNumber;
            if (item.itemType.realtionDataObject != null && item.itemType.realtionDataObject.equalsIgnoreCase("t_bd_generalasstacttype")) {
                item.startItem.number = item.startItem.number == null ? null : item.startItem.number.replaceAll("\\.", "\\!");
                item.startItem.longNumber = item.startItem.number;
                item.endItem.number = item.endItem.number == null ? null : item.endItem.number.replaceAll("\\.", "\\!");
                item.endItem.longNumber = item.endItem.number;
                if (item.startItem.number == null || item.endItem.number == null || item.startItem.number == item.endItem.number || item.startItem.number.split("\\!").length == item.endItem.number.split("\\!").length) continue;
                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"AssistantItemMustbeTheSameLevel", (Locale)this.ctx.getOriginLocale())});
            }
            if (item.itemType.realtionDataObject == null || !item.itemType.realtionDataObject.equalsIgnoreCase("T_ORG_Admin") && !item.itemType.realtionDataObject.equalsIgnoreCase("T_BD_CashFlowItem") && !item.itemType.realtionDataObject.equalsIgnoreCase("T_ORG_CostCenter")) continue;
            this.createAssistantInfo(calcDAO, item, false);
            if (item.isSameLevel()) continue;
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"AssistantItemMustbeTheSameLevel", (Locale)this.ctx.getOriginLocale())});
        }
    }

    private void createAssistantInfo(RptCalculaterDAO calcDAO, AssistantItem item, boolean fillGroupNumber) throws ReportException, BOSException {
        Map map = null;
        GroupTreeNode node = null;
        if (!fillGroupNumber) {
            map = calcDAO.getGroupLongNumber(new String[]{item.startItem.number, item.endItem.number}, item.itemType.realtionDataObject);
            node = (GroupTreeNode)map.get(item.startItem.number);
            if (node == null) {
                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"1_AccountItem", (Locale)this.ctx.getOriginLocale()) + "\"" + item.startItem.number + "\""});
            }
            item.startItem.longNumber = node.longNumber;
            node = (GroupTreeNode)map.get(item.endItem.number);
            if (node == null) {
                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"1_AccountItem", (Locale)this.ctx.getOriginLocale()) + "\"" + item.endItem.number + "\""});
            }
            item.endItem.longNumber = node.longNumber;
        }
    }

    public boolean isEmpty() {
        if (this.startAccount == null && this.endAccount == null) {
            return true;
        }
        if (this.startAccount != null && this.endAccount != null && this.startAccount.number == null && this.endAccount.number == null) {
            return true;
        }
        if (this.startAccount != null && this.startAccount.number == null) {
            return true;
        }
        return this.endAccount != null && this.endAccount.number == null;
    }

    public AcctountAsstItemParser.AccountAsstItem getAcctitem() {
        return this.acctitem;
    }
}

