/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.app;

import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.app.AccountExt;
import com.kingdee.eas.fi.rpt.app.AccountItem;
import com.kingdee.eas.fi.rpt.app.AssistantGroup;
import com.kingdee.eas.fi.rpt.app.AssistantItem;
import com.kingdee.eas.fi.rpt.app.AssistantItemExt;
import com.kingdee.eas.fi.rpt.app.AsstActType;
import com.kingdee.eas.fi.rpt.app.GroupTreeNode;
import com.kingdee.eas.fi.rpt.util.AcctountAsstItemParser;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class AccountItemExt {
    public AccountExt startAccount;
    public AccountExt endAccount;
    private Map items;
    private ArrayList itemNumbers = new ArrayList();
    private List leafAccountIDs;
    private AcctountAsstItemParser.AccountAsstItem accountAsstItem;
    private CompanyOrgUnitInfo company;
    private boolean bItemHasRange = false;
    private boolean hasGroup = false;
    private boolean isSyned;
    private List synedDetailAsstActTypes;

    public AccountItemExt(String accountItem, CompanyOrgUnitInfo _company) throws ReportException, ParseException {
        this.company = _company;
        this.items = new HashMap(2);
        this.parseAcctItem(accountItem);
    }

    public AccountItemExt(String accountItem) throws ReportException, ParseException {
        this.items = new HashMap(2);
        this.parseAcctItem(accountItem);
    }

    public boolean isItemHasRange() {
        return this.bItemHasRange;
    }

    public boolean isUnsupportedItem() {
        if (this.isItemHasRange()) {
            return true;
        }
        if (this.hasGroup()) {
            return true;
        }
        if (this.items == null) {
            return false;
        }
        Iterator it = this.items.entrySet().iterator();
        while (it.hasNext()) {
            AssistantItemExt item = (AssistantItemExt)it.next().getValue();
            if (item.startItem == null || item.startItem.number == null || item.endItem == null || item.endItem.number == null) {
                return true;
            }
            if (item.itemType == null || !item.itemType.useLongNumber && !item.itemType.realtionDataObject.equalsIgnoreCase("T_BD_GeneralAsstActType") && !item.itemType.realtionDataObject.equalsIgnoreCase("T_ORG_Admin") && !item.itemType.realtionDataObject.equalsIgnoreCase("T_BD_CashFlowItem")) continue;
            return true;
        }
        return false;
    }

    public ArrayList getItemNumbers() {
        return this.itemNumbers;
    }

    public AccountItem toAccountItem() {
        AccountItem accountItem = new AccountItem(this.startAccount.account, this.endAccount.account, this.items);
        return accountItem;
    }

    public void setCompany(CompanyOrgUnitInfo company) {
        this.company = company;
        if (this.startAccount != null) {
            this.startAccount.setCompany(this.company);
        }
        if (this.endAccount != null) {
            this.endAccount.setCompany(this.company);
        }
    }

    public boolean isSingleAccount() {
        return this.startAccount != null && this.endAccount != null && this.startAccount.account != null && this.endAccount.account != null && this.startAccount.account.number != null && this.startAccount.account.number.equals(this.endAccount.account.number);
    }

    public boolean isDetailAccount() {
        return this.startAccount != null && this.startAccount.account != null && this.startAccount.account.isLeaf;
    }

    public int getAccountLevel() {
        if (this.startAccount != null && this.startAccount.account != null) {
            return this.startAccount.account.level;
        }
        return -1;
    }

    public int itemSize() {
        return this.items.size();
    }

    public boolean hasItem() {
        return this.items.size() > 0;
    }

    public AssistantItem getItem(String itemTypeNumber) {
        return (AssistantItem)this.items.get(itemTypeNumber);
    }

    public AsstActType getItemType(String itemTypeNumber) {
        return this.getItem((String)itemTypeNumber).itemType;
    }

    public void setItemType(AsstActType asstActType) {
        this.getItem((String)asstActType.number).itemType = asstActType;
    }

    public Map getItemTypes() {
        return this.items;
    }

    public void setItemTypes(Map items) {
        this.items = items;
    }

    public void synItems(boolean force) {
        List itemTypes = this.startAccount.getItemTypes();
        if (itemTypes == null) {
            return;
        }
        for (int i = 0; i < itemTypes.size(); ++i) {
            AsstActType asstActType = (AsstActType)itemTypes.get(i);
            AssistantItem object = (AssistantItem)this.items.get(asstActType.number);
            if (object != null) {
                object.itemType = asstActType;
                this.isSyned = false;
                continue;
            }
            if (!force) continue;
            object = new AssistantItemExt(asstActType.number);
            object.itemType = asstActType;
            this.items.put(asstActType.number, object);
            this.isSyned = true;
        }
    }

    public boolean isDetailItem() {
        if (this.startAccount.getItemTypes() == null) {
            return true;
        }
        if (this.itemNumbers.size() != this.startAccount.getItemTypes().size()) {
            return false;
        }
        Set set = this.items.entrySet();
        for (Map.Entry e : set) {
            AssistantItem value = (AssistantItem)e.getValue();
            if (value.startItem != null || value.endItem != null) continue;
            return false;
        }
        return true;
    }

    public Set itemSet() {
        return this.items.keySet();
    }

    public Collection itemValues() {
        return this.items.values();
    }

    public boolean isSameLevel() throws Exception {
        if (this.startAccount != null && this.endAccount != null) {
            if (this.startAccount.account == null) {
                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"AccountNumberNoExists", (Locale)SysContext.getSysContext().getLocale()) + "\"" + this.startAccount.getAccountNumber() + "\""});
            }
            if (this.endAccount.account == null) {
                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"AccountNumberNoExists", (Locale)SysContext.getSysContext().getLocale()) + "\"" + this.endAccount.getAccountNumber() + "\""});
            }
            if (this.startAccount.account.level == this.endAccount.account.level) {
                return true;
            }
        }
        return false;
    }

    protected boolean hasGroup() {
        return this.hasGroup;
    }

    public void parseAcctItem(String strAcctItem) throws ReportException, ParseException {
        if (strAcctItem == null || strAcctItem.length() < 1) {
            throw new ReportException(ReportException.PARAM_IS_NOT_INTEGRATED);
        }
        this.accountAsstItem = AcctountAsstItemParser.parse(strAcctItem, false);
        this.startAccount = new AccountExt(this.accountAsstItem.startNumber);
        this.endAccount = this.accountAsstItem.startNumber.equals(this.accountAsstItem.endNumber) ? this.startAccount : new AccountExt(this.accountAsstItem.endNumber);
        for (int i = 0; this.accountAsstItem.asstItems != null && i < this.accountAsstItem.asstItems.length; ++i) {
            AssistantItemExt item = new AssistantItemExt(this.accountAsstItem.asstItems[i].asstTypeNumber);
            this.itemNumbers.add(this.accountAsstItem.asstItems[i].asstTypeNumber);
            if (!StringUtils.isEmpty((String)this.accountAsstItem.asstItems[i].startNumber)) {
                item.startItem = new GroupTreeNode();
                item.startItem.number = this.accountAsstItem.asstItems[i].startNumber;
                if (this.isItemHasWildcar(item.startItem.number)) {
                    item.startItem.isHasWildcar = true;
                }
            }
            if (!StringUtils.isEmpty((String)this.accountAsstItem.asstItems[i].endNumber)) {
                if (!StringUtils.isEmpty((String)this.accountAsstItem.asstItems[i].startNumber) && this.accountAsstItem.asstItems[i].startNumber.equals(this.accountAsstItem.asstItems[i].endNumber)) {
                    item.endItem = item.startItem;
                } else {
                    item.endItem = new GroupTreeNode();
                    item.endItem.number = this.accountAsstItem.asstItems[i].endNumber;
                    if (this.isItemHasWildcar(item.endItem.number)) {
                        item.endItem.isHasWildcar = true;
                    }
                }
            }
            item.itemType = new AsstActType();
            item.itemType.number = this.accountAsstItem.asstItems[i].asstTypeNumber;
            this.items.put(item.itemType.number, item);
            if (this.accountAsstItem.asstItems[i].group != null) {
                item.groups = new AssistantGroup[this.accountAsstItem.asstItems[i].group.length];
                for (int j = 0; this.accountAsstItem.asstItems[i].group != null && j < this.accountAsstItem.asstItems[i].group.length; ++j) {
                    AssistantGroup group;
                    if (j == 0) {
                        this.hasGroup = true;
                    }
                    AcctountAsstItemParser.Group g = this.accountAsstItem.asstItems[i].group[j];
                    item.groups[j] = group = new AssistantGroup();
                    if (g.startNumber.equals(g.endNumber)) {
                        if (!StringUtils.isEmpty((String)g.startNumber)) {
                            group.startGroup = group.endGroup = new GroupTreeNode();
                            group.startGroup.number = g.startNumber;
                        }
                    } else {
                        if (!StringUtils.isEmpty((String)g.startNumber)) {
                            group.startGroup = new GroupTreeNode();
                            group.startGroup.number = g.startNumber;
                        }
                        if (!StringUtils.isEmpty((String)g.endNumber)) {
                            group.endGroup = new GroupTreeNode();
                            group.endGroup.number = g.endNumber;
                        }
                    }
                    group.standardNumber = g.standardNumber;
                }
            }
            if (item.startItem == null || item.endItem == null || item.startItem.number.equals(item.endItem.number)) continue;
            this.bItemHasRange = true;
        }
    }

    private boolean isItemHasWildcar(String itemNumber) {
        return itemNumber.indexOf("*") != -1;
    }

    public boolean isSyned() {
        return this.isSyned;
    }

    public List getLeafAccountIDs() {
        return this.leafAccountIDs;
    }

    public void setLeafAccountIDs(List leafAccountIDs) {
        this.leafAccountIDs = leafAccountIDs;
    }

    public List getSynedDetailAsstActTypes() {
        return this.synedDetailAsstActTypes;
    }

    public void setSynedDetailAsstActTypes(List synedDetailAsstActTypes) {
        this.synedDetailAsstActTypes = synedDetailAsstActTypes;
    }

    public AcctountAsstItemParser.AccountAsstItem getAccountAsstItem() {
        return this.accountAsstItem;
    }

    public void setAccountAssItem(AcctountAsstItemParser.AccountAsstItem accountAsstItem) {
        this.accountAsstItem = accountAsstItem;
    }
}

