/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.app;

import com.kingdee.eas.fi.rpt.app.Account;
import com.kingdee.eas.fi.rpt.app.AccountExt;
import com.kingdee.eas.fi.rpt.app.IResultHolderListener;
import com.kingdee.eas.fi.rpt.app.QueryCommand;
import com.kingdee.eas.fi.rpt.app.QuerySolution;
import com.kingdee.eas.fi.rpt.app.ResultHolder;
import com.kingdee.eas.fi.rpt.app.WhereItem;

public class AccountSubQuery
extends QuerySolution {
    private String FCompanyID;
    private String FAccountTableID;
    private boolean flag = true;

    public AccountSubQuery(QueryCommand qc) {
        super(qc);
    }

    @Override
    protected void initSolutionConfig() {
        String[] groupConditionField = new String[]{"FNumber"};
        this.resultHolderSetConfig.setGroupConditionField(groupConditionField);
        this.queryParamer.setStaticFromPart("T_Bd_AccountView");
        this.queryParamer.setStaticSelectField("FID, FDc ,FIsLeaf, FLevel ,FNumber");
        this.queryParamer.setStaticWherePart("FCompanyID='" + this.FCompanyID + "' and FAccountTableID='" + this.FAccountTableID + "'");
    }

    public void add(AccountExt account) {
        ResultHolder rh = ResultHolder.createCommonAndShareModeResultHolder();
        rh.addIResultHolderListener(new ResultHolderListener(account));
        this.resultHolderSetConfig.addResultHolder(account.getAccountNumber(), rh);
        if (this.flag) {
            this.flag = false;
            this.FCompanyID = account.getCompany().isIsProfitOrgUnit() && account.getCompany().get("DELEGATED_COMPANY_ID") instanceof String ? (String)account.getCompany().get("DELEGATED_COMPANY_ID") : account.getCompany().getId().toString();
            this.FAccountTableID = account.getCompany().getAccountTable().getId().toString();
        }
    }

    private class ResultHolderListener
    extends IResultHolderListener {
        private AccountExt accountEx;

        public ResultHolderListener(AccountExt _accountEx) {
            this.accountEx = _accountEx;
        }

        @Override
        public String[] getResultHolderOrderedSelectFields() {
            return new String[]{"FID", "FDc", "FIsLeaf", "FLevel"};
        }

        @Override
        public Object setResultHolderOrderedSelectFieldsValueObjects(Object[] value) {
            Account account;
            this.accountEx.account = account = new Account();
            account.id = value[0].toString();
            account.dc = Integer.parseInt(value[1].toString());
            account.isLeaf = value[2].toString().equals("1");
            account.level = Integer.parseInt(value[3].toString());
            account.number = this.accountEx.getAccountNumber();
            return account;
        }

        @Override
        public WhereItem generateWhereItem() {
            WhereItem whereItem = WhereItem.createModeOneWhereItem();
            whereItem.addItem("FNumber", this.accountEx.getAccountNumber());
            return whereItem;
        }

        @Override
        public void setResultHolderOrderedSharedObject(Object obj) {
            this.accountEx.account = (Account)obj;
        }
    }
}

