/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.app;

import com.kingdee.eas.fi.rpt.app.AcctCalculaterExt;
import com.kingdee.eas.fi.rpt.app.AcctSubQuery;
import com.kingdee.eas.fi.rpt.app.IResultHolderListener;
import com.kingdee.eas.fi.rpt.app.QueryCommand;
import com.kingdee.eas.fi.rpt.app.ResourceMaping;
import com.kingdee.eas.fi.rpt.app.ResultHolder;
import com.kingdee.eas.fi.rpt.app.WhereItem;
import com.kingdee.eas.fi.rpt.util.RptUtil;

public class AcctAASubQuery
extends AcctSubQuery {
    private String BalTableName = null;
    private String FOrgUnitID = null;
    private String FCurrencyID = null;
    private String FCurrencyNumber = null;
    private String FPeriodID = null;
    private int iStartYear = 0;
    private int iStartPeriod = 0;
    private int iEndYear = 0;
    private int iEndPeriod = 0;
    private int FBalType = 0;
    private boolean flag = true;

    public AcctAASubQuery(QueryCommand qc) {
        super(qc);
    }

    @Override
    protected void initSolutionConfig() {
        String[] groupConditionField = new String[]{"FAccountID"};
        this.resultHolderSetConfig.setGroupConditionField(groupConditionField);
        this.resultHolderSetConfig.setResourceMaping(ResourceMaping.createDetailModeMap());
        String period = RptUtil.getYearPeriod(this.iStartYear, this.iStartPeriod, this.iEndYear, this.iEndPeriod);
        this.queryParamer.setStaticFromPart(this.BalTableName + " A_Bal");
        this.queryParamer.setStaticSelectField("A_Bal.FAccountID");
        if ("GRC".equalsIgnoreCase(this.FCurrencyNumber) || "GLC".equalsIgnoreCase(this.FCurrencyNumber)) {
            this.queryParamer.setStaticWherePart("A_Bal.FOrgUnitID='" + this.FOrgUnitID + "' and  A_Bal.FPeriod in ('" + period + "')");
        } else {
            this.queryParamer.setStaticWherePart("A_Bal.FOrgUnitID='" + this.FOrgUnitID + "' and A_Bal.FCurrencyID='" + this.FCurrencyID + "' and A_Bal.FPeriod in ('" + period + "')");
        }
        this.queryParamer.setGroupbyPart("A_Bal.FAccountID");
    }

    @Override
    public void add(AcctCalculaterExt _acct) {
        if (this.flag) {
            this.flag = false;
            this.BalTableName = _acct.getBalTableName();
            this.FOrgUnitID = _acct.getCompany().getId().toString();
            this.FCurrencyID = _acct.getCurrency().getId().toString();
            this.FCurrencyNumber = _acct.getCurrency().getNumber();
            this.iStartYear = _acct.getIStartYear();
            this.iStartPeriod = _acct.getIStartPeriod();
            this.iEndYear = _acct.getIEndYear();
            this.iEndPeriod = _acct.getIEndPeriod();
            this.FBalType = _acct.getIBalType();
            this.defaultValue = _acct.getCurrency().get("_DPV");
        }
        _acct.setDefaultACCTValue(this.defaultValue);
        ResultHolder rh = ResultHolder.createSingleAndNoShareModeResultHolder();
        rh.addIResultHolderListener(new ResultHolderListener(_acct));
        this.resultHolderSetConfig.addResultHolder(_acct.getAccountItem().startAccount.account.id, rh);
    }

    private class ResultHolderListener
    extends IResultHolderListener {
        private AcctCalculaterExt acct;

        public ResultHolderListener(AcctCalculaterExt _acct) {
            this.acct = _acct;
        }

        @Override
        public String[] getResultHolderOrderedSelectFields() {
            return new String[]{this.acct.getBalanceType().getName()};
        }

        @Override
        public Object setResultHolderOrderedSelectFieldsValueObjects(Object[] value) {
            this.acct.setACCTValue(value[0]);
            return null;
        }

        @Override
        public WhereItem generateWhereItem() {
            WhereItem whereItem = WhereItem.createModeOneWhereItem();
            whereItem.addItem("A_Bal.FAccountID", this.acct.getAccountItem().startAccount.account.id);
            return whereItem;
        }

        @Override
        public Object getHouderObject() {
            return this.acct;
        }
    }
}

