/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.app;

import com.kingdee.eas.fi.rpt.app.AcctCalculaterExt;
import com.kingdee.eas.fi.rpt.app.AcctSubQuery;
import com.kingdee.eas.fi.rpt.app.IResultHolderListener;
import com.kingdee.eas.fi.rpt.app.QueryCommand;
import com.kingdee.eas.fi.rpt.app.ResourceMaping;
import com.kingdee.eas.fi.rpt.app.ResultHolder;
import com.kingdee.eas.fi.rpt.app.WhereItem;
import com.kingdee.eas.fi.rpt.util.RptUtil;

public class AcctBBSubQuery
extends AcctSubQuery {
    private String BalTableName = null;
    private String FOrgUnitID = null;
    private String FCurrencyID = null;
    private String FPeriodID = null;
    private int FBalType = 0;
    private boolean flag = true;
    private String FCurrencyNumber = null;
    private int iStartYear = 0;
    private int iStartPeriod = 0;
    private int iEndYear = 0;
    private int iEndPeriod = 0;

    public AcctBBSubQuery(QueryCommand qc) {
        super(qc);
    }

    @Override
    protected void initSolutionConfig() {
        String[] groupConditionField = new String[]{"Fnumber"};
        this.resultHolderSetConfig.setGroupConditionField(groupConditionField);
        this.resultHolderSetConfig.setResourceMaping(ResourceMaping.createNoDetailModeMap());
        String period = RptUtil.getYearPeriod(this.iStartYear, this.iStartPeriod, this.iEndYear, this.iEndPeriod);
        this.queryParamer.setStaticFromPart(this.BalTableName + " A_Bal inner join T_BD_AccountView A_Acct on A_Bal.FAccountID=A_Acct.FID  ");
        this.queryParamer.setStaticSelectField("t.fnmb Fnumber");
        if ("GRC".equalsIgnoreCase(this.FCurrencyNumber) || "GLC".equalsIgnoreCase(this.FCurrencyNumber)) {
            this.queryParamer.setStaticWherePart("A_Bal.FOrgUnitID='" + this.FOrgUnitID + "' and A_Bal.FPeriod='" + period + "' and A_Acct.FIsLeaf=1 and (charindex(t.fnmb , A_Acct.FNumber)=1)");
        } else {
            this.queryParamer.setStaticWherePart("A_Bal.FOrgUnitID='" + this.FOrgUnitID + "' and A_Bal.FCurrencyID='" + this.FCurrencyID + "' and A_Bal.FPeriod='" + period + "' and A_Acct.FIsLeaf=1 and (charindex(t.fnmb , A_Acct.FNumber)=1)");
        }
        this.queryParamer.setGroupbyPart("t.fnmb");
    }

    @Override
    public void add(AcctCalculaterExt _acct) {
        if (this.flag) {
            this.flag = false;
            this.BalTableName = _acct.getBalTableName();
            this.FOrgUnitID = _acct.getCompany().getId().toString();
            this.FCurrencyID = _acct.getCurrency().getId().toString();
            this.FCurrencyNumber = _acct.getCurrency().getNumber();
            this.iStartYear = _acct.getIStartYear();
            this.iStartPeriod = _acct.getIStartPeriod();
            this.iEndYear = _acct.getIEndYear();
            this.iEndPeriod = _acct.getIEndPeriod();
            this.FBalType = _acct.getIBalType();
            this.defaultValue = _acct.getCurrency().get("_DPV");
        }
        _acct.setDefaultACCTValue(this.defaultValue);
        ResultHolder rh = ResultHolder.createSingleAndNoShareModeResultHolder();
        rh.addIResultHolderListener(new ResultHolderListener(_acct));
        this.resultHolderSetConfig.addResultHolder(_acct.getAccountItem().startAccount.account.number, rh);
    }

    private class ResultHolderListener
    extends IResultHolderListener {
        private AcctCalculaterExt acct;

        public ResultHolderListener(AcctCalculaterExt _acct) {
            this.acct = _acct;
        }

        @Override
        public String[] getResultHolderOrderedSelectFields() {
            return new String[]{this.acct.getBalanceType().getName()};
        }

        @Override
        public Object setResultHolderOrderedSelectFieldsValueObjects(Object[] value) {
            this.acct.setACCTValue(value[0]);
            return null;
        }

        @Override
        public WhereItem generateWhereItem() {
            WhereItem whereItem = WhereItem.createModeToweWhereItem();
            whereItem.addMode2DymaticItem("Fnumber", this.acct.getAccountItem().startAccount.account.number);
            return whereItem;
        }
    }
}

