/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ColumnInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.TableInfo;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.BalanceTypeEnum;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.app.AccountExt;
import com.kingdee.eas.fi.rpt.app.AccountItemExt;
import com.kingdee.eas.fi.rpt.app.AcctCalculaterExt;
import com.kingdee.eas.fi.rpt.app.AssistantGroup;
import com.kingdee.eas.fi.rpt.app.AssistantItemExt;
import com.kingdee.eas.fi.rpt.app.GroupTreeNode;
import com.kingdee.eas.fi.rpt.batch.AcctBatchCalculaterNew;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.AcctQuerySolution;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.comm.AccountQuerySolution;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.comm.AccountTableQuery;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.comm.AccountWildcarQuery;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.comm.AccrualPermissionQuerySolution;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.comm.AssistantBasicStandardQuerySolution;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.comm.AssistantGroupQuerySolution;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.comm.AssistantItemStandardQuerySolution;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.comm.CompanyQuerySorter;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.comm.CurrencyQuerySolution;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.comm.DetailItemQueryByAccount;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.comm.ItemQueryByAccount;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.comm.ItemQuerySolution;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.comm.MaterialGroupQuerySolution;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.comm.MaterialGroupStandardQuery;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.comm.PeriodQuerySolution;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.comm.TailAccountQuerySolution;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.comm.TreeNodeBatchQuerySolution;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fi.rpt.batch.BatchSQLSorterRegister;
import com.kingdee.eas.fi.rpt.batch.FormulaValueBackfill;
import com.kingdee.eas.fi.rpt.batch.acct.AcctBatchProcessor;
import com.kingdee.eas.fi.rpt.batch.acct.AcctSortStateFactory;
import com.kingdee.eas.fi.rpt.batch.acct.AcctUtils;
import com.kingdee.eas.fi.rpt.batch.acct.IAcctSortState;
import com.kingdee.eas.fi.rpt.util.CachingMap;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AcctBatchQueryServiceNew {
    private static Logger logger = Logger.getLogger(AcctBatchQueryServiceNew.class);
    private Connection conn = null;
    private Context serverCtx;
    private AcctBatchCalculaterNew acctBatchCalculaterNew = null;
    private ItemQueryByAccount itemQueryByAccount = null;
    private CurrencyQuerySolution currencyBatchProcesser = null;
    private CompanyQuerySorter orgUnitBatchProcesser = null;
    private AccountQuerySolution accountBatchProcesser = null;
    private TailAccountQuerySolution tailAccountProcesser = null;
    private ItemQuerySolution ItemBatchProcesser = null;
    private DetailItemQueryByAccount detailtemQueryByAccount = null;
    private AccountWildcarQuery accountWildcarQuery = null;
    private PeriodQuerySolution periodBatchProcesser = null;
    private AcctQuerySolution acctQuery = null;
    private AssistantItemStandardQuerySolution standardProcesser = null;
    private AssistantGroupQuerySolution groupProcesser = null;
    private MaterialGroupQuerySolution materialGroupQuery = null;
    private Map asstItemProcesser = null;
    private MaterialGroupStandardQuery materialGroupStandardQuery = null;
    private AccrualPermissionQuerySolution accrualPermissionQuery = null;
    private AssistantBasicStandardQuerySolution basicStandardProcesser = null;
    private AccountTableQuery accountTableQuery;
    ArrayList unSupportAcct = new ArrayList();
    private Set companyNumberSet = new HashSet();
    private boolean isUseNewBatchLogic;
    private boolean isSupportVirtualOrgMultiUnPosted;
    private Map currentPeriodCache = new CachingMap();
    private Map prePeriodCache = new CachingMap();
    private Map nextPeriodCache = new CachingMap();
    private int whereSize = 200;
    private boolean isGroupByAccount;
    private BatchSQLSorterRegister newRegister = null;

    public AcctBatchQueryServiceNew(Context ctx, AcctBatchCalculaterNew acctBatchCalculaterNew) {
        this.serverCtx = ctx;
        this.acctBatchCalculaterNew = acctBatchCalculaterNew;
    }

    public void initResource() throws SQLException {
        try {
            this.conn = EJBFactory.getConnection((Context)this.serverCtx);
        }
        catch (SQLException e) {
            logger.debug((Object)"", (Throwable)e);
            throw e;
        }
    }

    public void clearnupResource() throws SQLException {
        if (this.conn != null) {
            this.conn.close();
            this.conn = null;
        }
    }

    public void submitRequireBatchFitchCurrencyInfoService(String currencyNumber, AcctCalculaterExt acct) {
        if (this.currencyBatchProcesser == null) {
            this.currencyBatchProcesser = new CurrencyQuerySolution(this.conn);
            this.currencyBatchProcesser.setCurrencyCache(this.acctBatchCalculaterNew.getCurrencyCache());
        }
        try {
            this.currencyBatchProcesser.add(currencyNumber, acct);
        }
        catch (Exception e) {
            logger.debug((Object)"", (Throwable)e);
        }
    }

    public void excBatchCurrencyInfoService() throws Exception {
        if (this.currencyBatchProcesser != null) {
            this.currencyBatchProcesser.exec();
        }
    }

    public void submitRequireBatchFitchCompanyInfoService(String compNumber, AcctCalculaterExt acct) {
        acct.setContext(this.serverCtx);
        if (this.orgUnitBatchProcesser == null) {
            this.orgUnitBatchProcesser = new CompanyQuerySorter(this.serverCtx, this.conn);
            this.orgUnitBatchProcesser.setOrgCache(this.acctBatchCalculaterNew.getCompanyCache());
        }
        try {
            this.companyNumberSet.add(compNumber);
            this.orgUnitBatchProcesser.add(compNumber, acct);
        }
        catch (Exception e) {
            logger.debug((Object)"", (Throwable)e);
        }
    }

    public void excBatchCompanyInfoService() throws Exception {
        if (this.orgUnitBatchProcesser != null) {
            this.orgUnitBatchProcesser.exec();
        }
    }

    public void submitRequireBatchFitchAccountInfoService(AccountExt account) {
        if (this.accountBatchProcesser == null) {
            this.accountBatchProcesser = new AccountQuerySolution(this.conn);
            this.accountBatchProcesser.setAccountCache(this.acctBatchCalculaterNew.getAccountCache());
        }
        try {
            this.accountBatchProcesser.add(account);
        }
        catch (Exception e) {
            logger.debug((Object)"", (Throwable)e);
        }
    }

    public void submitTailRequireBatchFitchAccountInfoService(AccountExt account) {
        if (this.tailAccountProcesser == null) {
            this.tailAccountProcesser = new TailAccountQuerySolution(this.conn);
            this.accountBatchProcesser.setAccountCache(this.acctBatchCalculaterNew.getAccountCache());
        }
        try {
            this.tailAccountProcesser.add(account);
        }
        catch (Exception e) {
            logger.debug((Object)"", (Throwable)e);
        }
    }

    public void execTailAccountQuery() throws Exception {
        if (this.tailAccountProcesser != null) {
            this.tailAccountProcesser.exec();
        }
    }

    private void excBatchAccountInfoService() throws Exception {
        if (this.accountBatchProcesser != null) {
            this.accountBatchProcesser.exec();
        }
    }

    public void submitRequireBatchFitchItemInfoService(AssistantItemExt item) {
        if (this.ItemBatchProcesser == null) {
            this.ItemBatchProcesser = new ItemQuerySolution(this.conn);
            this.ItemBatchProcesser.setItemCache(this.acctBatchCalculaterNew.getItemCache());
        }
        try {
            this.ItemBatchProcesser.add(item);
        }
        catch (Exception e) {
            logger.debug((Object)"", (Throwable)e);
        }
    }

    public void excBatchItemInfoService() throws Exception {
        if (this.ItemBatchProcesser != null) {
            this.ItemBatchProcesser.exec();
        }
    }

    public void excBatchAccountAndItemInfoService() throws Exception {
        this.excBatchAccountInfoService();
    }

    public void submitRequireBatchFitchPeriodIDService(AcctCalculaterExt acct) {
        if (this.periodBatchProcesser == null) {
            this.periodBatchProcesser = new PeriodQuerySolution(this.conn);
        }
        try {
            this.periodBatchProcesser.add(acct);
        }
        catch (Exception e) {
            logger.debug((Object)"", (Throwable)e);
        }
    }

    public void excBatchPeriodIDService() throws Exception {
        if (this.periodBatchProcesser != null) {
            this.periodBatchProcesser.exec();
        }
    }

    public void submitRequireBatchFitchReportDataService(AcctCalculaterExt acct) {
        if (acct.getIsSinglePeriod() && acct.getStrPeriodID() == null) {
            logger.error((Object)"acct's period not be found!");
            acct.setACCTValue(new BigDecimal("0"));
            return;
        }
        if (this.isUseNewBatchLogic()) {
            this.unSupportAcct.add(acct);
        } else if (!acct.getAccountItem().isSingleAccount() || !acct.getIsSinglePeriod() || acct.getAccountItem().isUnsupportedItem()) {
            this.unSupportAcct.add(acct);
        } else if (acct.getAccountItem().hasItem() && !acct.getAccountItem().isDetailItem()) {
            this.unSupportAcct.add(acct);
        } else {
            if (this.acctQuery == null) {
                this.acctQuery = new AcctQuerySolution(this.conn);
                this.acctQuery.setWhereSize(this.getWhereSize());
            }
            try {
                this.acctQuery.add(acct);
            }
            catch (Exception e) {
                logger.debug((Object)"", (Throwable)e);
            }
        }
    }

    public void excBatchReportDataService() throws Exception {
        if (this.isUseNewBatchLogic()) {
            AcctCalculaterExt acct2;
            long currentTimeMillis = System.currentTimeMillis();
            Iterator it = this.unSupportAcct.iterator();
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("isGroupByAccount", new Boolean(this.isGroupByAccount));
            context.put("COMPANYIDSET", this.companyNumberSet);
            BatchSQLSorterRegister register = new BatchSQLSorterRegister(context);
            AcctSortStateFactory stateFactory = AcctSortStateFactory.getInstance();
            ArrayList<AcctCalculaterExt> isOnlyUnionList = new ArrayList<AcctCalculaterExt>();
            String companyLongNUmber = null;
            if (this.unSupportAcct != null && this.unSupportAcct.size() > 0) {
                boolean isFirst = true;
                for (int i = 0; i < this.unSupportAcct.size(); ++i) {
                    acct2 = (AcctCalculaterExt)this.unSupportAcct.get(i);
                    if (!acct2.getCompany().isIsOnlyUnion()) continue;
                    if (isFirst) {
                        isOnlyUnionList.add(acct2);
                        companyLongNUmber = acct2.getCompany().getLongNumber();
                        isFirst = false;
                        continue;
                    }
                    boolean difAcct = true;
                    for (int j = 0; j < isOnlyUnionList.size(); ++j) {
                        AcctCalculaterExt acctExt = (AcctCalculaterExt)isOnlyUnionList.get(j);
                        if (!acct2.getAccountItem().startAccount.getAccountNumber().equals(acctExt.getAccountItem().startAccount.getAccountNumber())) continue;
                        difAcct = false;
                    }
                    if (!difAcct) continue;
                    isOnlyUnionList.add(acct2);
                }
            }
            BatchHelper batchHelper = null;
            batchHelper = this.acctBatchCalculaterNew.isProfitCenter() ? new BatchHelper(this.serverCtx) : new BatchHelper(this.acctBatchCalculaterNew.getCalcCtx(), this.serverCtx);
            Map acctMap = this.isLeafOrNot(companyLongNUmber, isOnlyUnionList, this.serverCtx);
            while (it.hasNext()) {
                String accountNumber;
                acct2 = (AcctCalculaterExt)it.next();
                if (acct2.getCompany().isIsOnlyUnion() && acctMap.get(accountNumber = acct2.getAccountItem().startAccount.getAccountNumber()) != null && ((Boolean)acctMap.get(accountNumber)).booleanValue()) {
                    acct2.getAccountItem().startAccount.account.isLeaf = false;
                }
                this.registerAcct(context, register, stateFactory, acct2, acct2.getStruct().getOrgType());
            }
            if (this.detailtemQueryByAccount != null && this.detailtemQueryByAccount.getAddedFormulas() != null && this.detailtemQueryByAccount.getAddedFormulas().size() > 0) {
                for (AcctCalculaterExt acct2 : this.detailtemQueryByAccount.getAddedFormulas()) {
                    this.registerAcct(context, register, stateFactory, acct2, acct2.getStruct().getOrgType());
                }
            }
            boolean isDebugSheet = batchHelper.isDebugSheetOnCurCalcSheet();
            batchHelper.setTempTableSchemeDebug(this.acctBatchCalculaterNew.isTempTableSchemeDebug() || isDebugSheet);
            if (this.acctBatchCalculaterNew.isProfitCenter()) {
                batchHelper.setBatchSize(100);
            } else {
                batchHelper.setBatchSize(this.acctBatchCalculaterNew.getWhereSize());
            }
            AcctBatchProcessor sqlBuilder = new AcctBatchProcessor(batchHelper.getBatchSize(), this.acctBatchCalculaterNew.isUseTempTableScheme());
            if (this.newRegister != null) {
                batchHelper.batchCalculateBigDecimalBySorter(sqlBuilder, this.newRegister);
                this.newRegister = null;
            } else {
                batchHelper.batchCalculateBigDecimalBySorter(sqlBuilder, register);
            }
            for (AcctCalculaterExt formula : this.unSupportAcct) {
                if (formula.isException()) {
                    FormulaValueBackfill err = new FormulaValueBackfill(formula.getParameter());
                    err.setException((Throwable)formula.getException());
                    continue;
                }
                if (formula.getParameter().getValue() != null) continue;
                formula.getParameter().setValue((Object)CslConstant.BGZERO);
            }
            long time = System.currentTimeMillis() - currentTimeMillis;
            logger.info((Object)("acct time: " + time + "ms"));
        } else {
            if (this.acctQuery != null) {
                this.acctQuery.exec();
            }
            for (AcctCalculaterExt acct : this.unSupportAcct) {
                acct.calculate(this.serverCtx);
            }
        }
    }

    private void registerAcct(Map context, BatchSQLSorterRegister register, AcctSortStateFactory stateFactory, AcctCalculaterExt acct, OrgType rptOrgType) throws EASBizException, BOSException {
        IAcctSortState sortState = stateFactory.getSortState(acct);
        this.setSortState(context, register, acct, rptOrgType, sortState);
        if (sortState.isMultiUnPosted() && (acct.getBalanceType().equals((Object)BalanceTypeEnum.B) || acct.getBalanceType().equals((Object)BalanceTypeEnum.TB) || acct.getBalanceType().equals((Object)BalanceTypeEnum.RB) || acct.getBalanceType().equals((Object)BalanceTypeEnum.QB))) {
            if (this.newRegister == null) {
                this.newRegister = register;
            }
            if (acct.getBalanceType().equals((Object)BalanceTypeEnum.B)) {
                acct.setBalanceType(BalanceTypeEnum.Y);
            } else if (acct.getBalanceType().equals((Object)BalanceTypeEnum.TB)) {
                acct.setBalanceType(BalanceTypeEnum.TY);
            } else if (acct.getBalanceType().equals((Object)BalanceTypeEnum.RB)) {
                acct.setBalanceType(BalanceTypeEnum.RY);
            } else {
                acct.setBalanceType(BalanceTypeEnum.QY);
            }
            this.setSortState(context, register, acct, rptOrgType, sortState);
            this.newRegister.register(acct);
            if (acct.getBalanceType().equals((Object)BalanceTypeEnum.Y)) {
                acct.setBalanceType(BalanceTypeEnum.B);
            } else if (acct.getBalanceType().equals((Object)BalanceTypeEnum.TY)) {
                acct.setBalanceType(BalanceTypeEnum.TB);
            } else if (acct.getBalanceType().equals((Object)BalanceTypeEnum.RY)) {
                acct.setBalanceType(BalanceTypeEnum.RB);
            } else {
                acct.setBalanceType(BalanceTypeEnum.QB);
            }
            this.setSortState(context, register, acct, rptOrgType, sortState);
            this.newRegister.register(acct);
        } else {
            register.register(acct);
        }
    }

    private void setSortState(Map context, BatchSQLSorterRegister register, AcctCalculaterExt acct, OrgType rptOrgType, IAcctSortState sortState) throws BOSException {
        sortState.setRptOrgType(rptOrgType);
        sortState.setMultiUnPosted(false);
        int periodType = AcctUtils.getPeriodType(acct.getBalanceType().getName());
        if (!(AcctUtils.isAccrualType(acct.getBalanceType().getName()) || periodType != 2 && periodType != 3)) {
            int endPeriodNumber = -99;
            int endPeriodYear = -99;
            if (periodType == 2) {
                endPeriodNumber = acct.getStruct().getStartPeriod();
                endPeriodYear = acct.getStruct().getStartYear();
            } else if (periodType == 3) {
                endPeriodNumber = acct.getStruct().getEndPeriod();
                endPeriodYear = acct.getStruct().getEndYear();
            }
            try {
                PeriodInfo currentPeriod = this.getCurrentPeriodInfo(acct.getCompany());
                if (this.isMultiUnPosted(acct, currentPeriod, endPeriodYear, endPeriodNumber)) {
                    this.setMultiUnPostedPeriod(acct, periodType, currentPeriod, endPeriodYear, endPeriodNumber);
                    sortState.setMultiUnPosted(true);
                }
            }
            catch (EASBizException ex) {
                logger.error((Object)"", (Throwable)ex);
                acct.setACCTValue((Object)ex);
                return;
            }
        }
        sortState.setContext(context);
        register.setSortState(sortState);
    }

    private void setMultiUnPostedPeriod(AcctCalculaterExt acct, int periodType, PeriodInfo currentPeriod, int endPeriodYear, int endPeriodNumber) throws EASBizException, BOSException {
        if (periodType == 2) {
            String endPeriodID = acct.getStrPeriodID();
            PeriodInfo prePeriod = this.getPrePeriodInfo(endPeriodID);
            acct.setIEndPeriod(prePeriod.getPeriodNumber());
            acct.setIEndYear(prePeriod.getPeriodYear());
            acct.setNextCurrentPeriodYear(currentPeriod.getPeriodYear());
            acct.setNextCurrentPeriodNumber(currentPeriod.getPeriodNumber());
        } else if (AcctUtils.isAccumulateType(acct.getBalanceType().getName()) && endPeriodYear > currentPeriod.getPeriodYear()) {
            acct.setNextCurrentPeriodYear(endPeriodYear);
            acct.setNextCurrentPeriodNumber(1);
        } else {
            PeriodInfo nextPeriod = this.getNextPeriodInfo(currentPeriod.getId().toString());
            acct.setNextCurrentPeriodYear(nextPeriod.getPeriodYear());
            acct.setNextCurrentPeriodNumber(nextPeriod.getPeriodNumber());
        }
        acct.setCurrentPeriod(currentPeriod);
        acct.setStrPeriodID(currentPeriod.getId().toString());
    }

    public boolean isMultiUnPosted(AcctCalculaterExt acct, PeriodInfo currentPeriod, int endPeriodYear, int endPeriodNumber) {
        return (acct.getCompany().isIsBizUnit() || !acct.getCompany().isIsBizUnit() && this.isSupportVirtualOrgMultiUnPosted) && (endPeriodYear > currentPeriod.getPeriodYear() || endPeriodYear == currentPeriod.getPeriodYear() && endPeriodNumber > currentPeriod.getPeriodNumber());
    }

    public PeriodInfo getCurrentPeriodInfo(CompanyOrgUnitInfo companyOrgUnitInfo) throws EASBizException, BOSException {
        String companyID = companyOrgUnitInfo.getId().toString();
        PeriodInfo period = (PeriodInfo)this.currentPeriodCache.get(companyID);
        if (period == null) {
            boolean isBizUnit = companyOrgUnitInfo.isIsBizUnit();
            period = companyOrgUnitInfo.isIsProfitOrgUnit() && companyOrgUnitInfo.get("DELEGATED_COMPANY_ID") instanceof String ? (isBizUnit ? PcaUtils.getCurrentPeriod((Context)this.serverCtx, (String)companyID) : AcctUtils.getSubCompanyMinCurrentPeriod(this.serverCtx, companyOrgUnitInfo)) : (isBizUnit ? GlUtils.getCurrentPeriod((Context)this.serverCtx, (String)companyID) : AcctUtils.getSubCompanyMinCurrentPeriod(this.serverCtx, companyOrgUnitInfo));
            this.currentPeriodCache.put(companyID, period);
        }
        return period;
    }

    private PeriodInfo getPrePeriodInfo(String periodID) throws EASBizException, BOSException {
        PeriodInfo period = (PeriodInfo)this.prePeriodCache.get(periodID);
        if (period == null) {
            period = PeriodUtils.getPrePeriodInfo((Context)this.serverCtx, (IObjectPK)new ObjectStringPK(periodID));
            this.prePeriodCache.put(periodID, period);
        }
        return period;
    }

    private PeriodInfo getNextPeriodInfo(String periodID) throws EASBizException, BOSException {
        PeriodInfo period = (PeriodInfo)this.nextPeriodCache.get(periodID);
        if (period == null) {
            period = PeriodUtils.getNextPeriodInfo((Context)this.serverCtx, (IObjectPK)new ObjectStringPK(periodID));
            this.nextPeriodCache.put(periodID, period);
        }
        return period;
    }

    public void submitStandard(AssistantGroup group) {
        if (this.standardProcesser == null) {
            this.standardProcesser = new AssistantItemStandardQuerySolution(this.conn);
        }
        try {
            this.standardProcesser.add(group);
        }
        catch (Exception e) {
            logger.debug((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void submitGroup(GroupTreeNode node, int type, String stdid) {
        if (this.groupProcesser == null) {
            this.groupProcesser = new AssistantGroupQuerySolution(this.conn);
        }
        try {
            this.groupProcesser.add(node, type, stdid);
        }
        catch (Exception e) {
            logger.debug((Object)"", (Throwable)e);
        }
    }

    public void submitMaterialGroup(GroupTreeNode g, String standard) {
        if (this.materialGroupQuery == null) {
            this.materialGroupQuery = new MaterialGroupQuerySolution(this.conn);
        }
        this.materialGroupQuery.add(g, standard);
    }

    public void submitMaterialStandard(AssistantGroup g) {
        if (this.materialGroupStandardQuery == null) {
            this.materialGroupStandardQuery = new MaterialGroupStandardQuery(this.conn);
            this.materialGroupStandardQuery.setContext(this.serverCtx);
        }
        this.materialGroupStandardQuery.add(g);
    }

    public void submitAsstItem(String tableName, GroupTreeNode node) {
        if (this.asstItemProcesser == null) {
            this.asstItemProcesser = new HashMap(1);
        }
        TreeNodeBatchQuerySolution query = null;
        if (this.asstItemProcesser.containsKey(tableName)) {
            query = (TreeNodeBatchQuerySolution)this.asstItemProcesser.get(tableName);
        } else {
            query = new TreeNodeBatchQuerySolution(this.conn, tableName);
            this.asstItemProcesser.put(tableName, query);
        }
        try {
            query.add(node);
        }
        catch (Exception e) {
            logger.debug((Object)"", (Throwable)e);
        }
    }

    public void submitAccountTableQuery(AcctCalculaterExt acct) {
        if (this.accountTableQuery == null) {
            this.accountTableQuery = new AccountTableQuery(this.serverCtx);
            this.accountTableQuery.setAccountTableCache(this.acctBatchCalculaterNew.getAccountTableCache());
        }
        this.accountTableQuery.registerFormula(acct);
    }

    public void executeAccountTableQuery() {
        if (this.accountTableQuery != null) {
            this.accountTableQuery.executeAccountTableQuery();
        }
    }

    public void submitBasicStandard(AssistantItemExt item, AssistantGroup group) {
        if (this.basicStandardProcesser == null) {
            this.basicStandardProcesser = new AssistantBasicStandardQuerySolution(this.conn);
        }
        try {
            this.basicStandardProcesser.add(item, group);
        }
        catch (Exception e) {
            logger.debug((Object)"", (Throwable)e);
        }
    }

    public void submitAssistantItemQuery(AcctCalculaterExt acct) throws Exception {
        Collection coll = acct.getAccountItem().itemValues();
        for (AssistantItemExt assitem : coll) {
            AssistantGroup[] groups = assitem.getGroups();
            for (int i = 0; groups != null && i < groups.length; ++i) {
                AssistantGroup g = groups[i];
                int type = -1;
                if ("T_BD_CUSTOMER".equalsIgnoreCase(assitem.itemType.realtionDataObject)) {
                    type = 1;
                } else if ("T_BD_SUPPLIER".equalsIgnoreCase(assitem.itemType.realtionDataObject)) {
                    type = 2;
                }
                if (type > 0) {
                    if (StringUtils.isEmpty((String)g.standardID)) {
                        throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"GroupStandardNoExists", (Locale)this.serverCtx.getOriginLocale()) + "\"" + g.standardNumber + "\""});
                    }
                    this.submitGroup(g.startGroup, type, g.standardID);
                    if (g.startGroup == g.endGroup) continue;
                    this.submitGroup(g.endGroup, type, g.standardID);
                    continue;
                }
                if (StringUtils.isEmpty((String)g.standardID)) continue;
                this.submitMaterialGroup(g.startGroup, g.standardID);
                if (g.startGroup == g.endGroup) continue;
                this.submitMaterialGroup(g.endGroup, g.standardID);
            }
            if (assitem.itemType.useLongNumber || "T_BD_GeneralAsstActType".equalsIgnoreCase(assitem.itemType.realtionDataObject)) {
                if (assitem.startItem != null && assitem.startItem.number != null) {
                    assitem.startItem.longNumber = assitem.startItem.number = assitem.startItem.number.replaceAll("\\.", "\\!");
                }
                if (assitem.endItem == null || assitem.endItem.number == null) continue;
                assitem.endItem.longNumber = assitem.endItem.number = assitem.endItem.number.replaceAll("\\.", "\\!");
                continue;
            }
            if (!"T_ORG_Admin".equalsIgnoreCase(assitem.itemType.realtionDataObject) && !"T_BD_CashFlowItem".equalsIgnoreCase(assitem.itemType.realtionDataObject) && !"T_ORG_CostCenter".equalsIgnoreCase(assitem.itemType.realtionDataObject) || assitem.startItem == null || assitem.startItem.number == null) continue;
            this.submitAsstItem(assitem.itemType.realtionDataObject, assitem.startItem);
            if (assitem.startItem == assitem.endItem || assitem.endItem == null || assitem.endItem.number == null) continue;
            this.submitAsstItem(assitem.itemType.realtionDataObject, assitem.endItem);
        }
    }

    public void execAssistantStandard() throws Exception {
        if (this.standardProcesser != null) {
            this.standardProcesser.exec();
        }
        if (this.basicStandardProcesser != null) {
            this.basicStandardProcesser.exec();
        }
        if (this.materialGroupStandardQuery != null) {
            this.materialGroupStandardQuery.exec();
        }
    }

    public void execAssistantItemQuery() throws Exception {
        if (this.groupProcesser != null) {
            this.groupProcesser.exec();
        }
        if (this.asstItemProcesser != null) {
            Iterator it = this.asstItemProcesser.entrySet().iterator();
            while (it.hasNext()) {
                ((TreeNodeBatchQuerySolution)it.next().getValue()).exec();
            }
        }
        if (this.materialGroupQuery != null) {
            this.materialGroupQuery.exec();
        }
    }

    public void submitAssistantStandardQuery(AcctCalculaterExt acct) {
        Collection coll = acct.getAccountItem().itemValues();
        for (AssistantItemExt assitem : coll) {
            AssistantGroup[] groups = assitem.getGroups();
            for (int i = 0; groups != null && i < groups.length; ++i) {
                AssistantGroup g = groups[i];
                int type = -1;
                type = "T_BD_CUSTOMER".equalsIgnoreCase(assitem.itemType.realtionDataObject) ? 1 : ("T_BD_SUPPLIER".equalsIgnoreCase(assitem.itemType.realtionDataObject) ? 2 : 3);
                g.standardType = type;
                if (type == 1 || type == 2) {
                    if (!(!StringUtils.isEmpty((String)g.getStandardNumber()) || StringUtils.isEmpty((String)g.getStartGroup().getNumber()) && StringUtils.isEmpty((String)g.getEndGroup().getNumber()))) {
                        if (type <= 0) continue;
                        this.submitBasicStandard(assitem, g);
                        continue;
                    }
                    this.submitStandard(g);
                    continue;
                }
                if (type != 3) continue;
                if (!(!StringUtils.isEmpty((String)g.getStandardNumber()) || StringUtils.isEmpty((String)g.getStartGroup().getNumber()) && StringUtils.isEmpty((String)g.getEndGroup().getNumber()))) {
                    if (type <= 0) continue;
                    g.standardType = 1;
                    this.submitMaterialStandard(g);
                    continue;
                }
                g.standardType = 0;
                this.submitMaterialStandard(g);
            }
        }
    }

    public Context getServerContext() {
        return this.serverCtx;
    }

    public void submitRequireItemInfoByAccount(AccountItemExt acct) {
        if (this.itemQueryByAccount == null) {
            this.itemQueryByAccount = new ItemQueryByAccount(this.conn);
        }
        this.itemQueryByAccount.add(acct);
    }

    public void executeItemQueryByAccount() throws Exception {
        if (this.itemQueryByAccount != null) {
            this.itemQueryByAccount.execute();
        }
    }

    public int getWhereSize() {
        return this.whereSize;
    }

    public void setWhereSize(int whereSize) {
        this.whereSize = whereSize;
    }

    public boolean isGroupByAccount() {
        return this.isGroupByAccount;
    }

    public void setGroupByAccount(boolean isGroupByAccount) {
        this.isGroupByAccount = isGroupByAccount;
    }

    public boolean isUseNewBatchLogic() {
        return this.isUseNewBatchLogic;
    }

    public void setUseNewBatchLogic(boolean isUseNewBatchLogic) {
        this.isUseNewBatchLogic = isUseNewBatchLogic;
    }

    public boolean isSupportVirtualOrgMultiUnPosted() {
        return this.isSupportVirtualOrgMultiUnPosted;
    }

    public void setSupportVirtualOrgMultiUnPosted(boolean isSupportVirtualOrgMultiUnPosted) {
        this.isSupportVirtualOrgMultiUnPosted = isSupportVirtualOrgMultiUnPosted;
    }

    public void submitDetailAsstActTypeQuery(AcctCalculaterExt acct) {
        if (this.detailtemQueryByAccount == null) {
            this.detailtemQueryByAccount = new DetailItemQueryByAccount(this.conn, this.serverCtx);
        }
        if (acct.getIsIncludeLeafAsstItem()) {
            this.detailtemQueryByAccount.add(acct, 101);
        } else if (acct.getIsIncludeSubAsstItem()) {
            this.detailtemQueryByAccount.add(acct, 102);
        }
    }

    public void submitAccountWildcarQuery(AcctCalculaterExt acct) {
        if (this.accountWildcarQuery == null) {
            this.accountWildcarQuery = new AccountWildcarQuery(this.serverCtx);
        }
        this.accountWildcarQuery.addFormula(acct);
    }

    public int executeAccountWildcarQuery() throws Exception {
        int expandFormulaSize = 0;
        if (this.accountWildcarQuery != null) {
            this.accountWildcarQuery.executeWildcarQuery();
            List formulaList = this.acctBatchCalculaterNew.getFormulas();
            formulaList.addAll(this.accountWildcarQuery.getExpandFormulaList());
            expandFormulaSize = this.accountWildcarQuery.getExpandFormulaList().size();
            this.accountWildcarQuery.getExpandFormulaList().clear();
        }
        return expandFormulaSize;
    }

    public void executeDetailAsstActTypeQuery() throws Exception {
        if (this.detailtemQueryByAccount != null) {
            this.detailtemQueryByAccount.execute();
        }
    }

    public void submitAccrualPermissionQuery(AcctCalculaterExt acctCalc) {
        if (this.accrualPermissionQuery == null) {
            this.accrualPermissionQuery = new AccrualPermissionQuerySolution(this.conn);
        }
        this.accrualPermissionQuery.add(acctCalc);
    }

    public void executeAccrualPermissionQueryService(Map userPermissionOrgsMap, List formulas) throws Exception {
        if (this.accrualPermissionQuery != null) {
            this.accrualPermissionQuery.executeCheckPermissionService(userPermissionOrgsMap);
            formulas.addAll(this.accrualPermissionQuery.getAcctCalcList());
        }
    }

    public void setCurrentPeriodCache(Map currentPeriodCache) {
        this.currentPeriodCache = currentPeriodCache;
    }

    public void setPrePeriodCache(Map prePeriodCache) {
        this.prePeriodCache = prePeriodCache;
    }

    public void setNextPeriodCache(Map nextPeriodCache) {
        this.nextPeriodCache = nextPeriodCache;
    }

    private Map isLeafOrNot(String companyLongNumber, List acctList, Context ctx) throws BOSException, SQLException {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        StringBuffer sql = new StringBuffer();
        StringBuffer likeBuffer = new StringBuffer();
        StringBuffer executeSQL = new StringBuffer();
        ArrayList<AcctCalculaterExt> formulaList = new ArrayList<AcctCalculaterExt>();
        IRowSet resultSet = null;
        int batchSize = 200;
        sql.append(" select distinct A_AcctLeaf.flongnumber longnumber \r\n").append(" from T_BD_AccountView A_AcctLeaf \r\n").append(" inner join T_ORG_Company company on A_AcctLeaf.fcompanyid = company.FID \r\n").append(" where ").append(" A_AcctLeaf.fisleaf =1 and A_AcctLeaf.flevel >1 \r\n").append(" and company.FLongNumber like ('").append(companyLongNumber).append("!%").append("') ").append(" and company.FIsbizunit = 1 \r\n");
        Object tmp = null;
        if (acctList != null && acctList.size() > 0) {
            Iterator acctit = acctList.iterator();
            while (acctit.hasNext()) {
                AcctCalculaterExt acct = (AcctCalculaterExt)acctit.next();
                formulaList.add(acct);
                if (likeBuffer.length() <= 0) {
                    likeBuffer.append(" and ((A_AcctLeaf.flongnumber like ('").append(acct.getAccountItem().startAccount.getAccountNumber()).append("%").append("')) \r\n");
                } else {
                    likeBuffer.append(" or (A_AcctLeaf.flongnumber like ('").append(acct.getAccountItem().startAccount.getAccountNumber()).append("%").append("')) \r\n");
                }
                if (formulaList.size() <= batchSize && acctit.hasNext()) continue;
                likeBuffer.append(")");
                executeSQL.append(sql.toString()).append(likeBuffer.toString()).append(" \r\n");
                resultSet = DbUtil.executeQuery((Context)ctx, (String)executeSQL.toString());
                while (resultSet.next()) {
                    String longnumber = resultSet.getString("longnumber");
                    map.put(longnumber.substring(0, longnumber.indexOf("!")), Boolean.TRUE);
                }
                formulaList.clear();
                likeBuffer.setLength(0);
                executeSQL.setLength(0);
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fixVirtualCompanyLeafAccount(List formulas) throws Exception {
        boolean isUserTempTable = formulas.size() > 10;
        StringBuffer sql = new StringBuffer("select acct.FNumber acctNumber , comp.FLongNumber compLongNumber , acct.FAccountTableID accountTableID \n");
        sql.append(" from T_Bd_AccountView acct inner join T_ORG_Company comp on comp.fid = acct.fcompanyid \n");
        HashMap<String, AccountExt> accountTemp = new HashMap<String, AccountExt>();
        HashSet<List<String>> accountTempTblParams = new HashSet<List<String>>();
        StringBuffer sqlWhere = new StringBuffer();
        for (AcctCalculaterExt tempAcct : formulas) {
            if (tempAcct.isException() || tempAcct.getCompany().isIsBizUnit()) continue;
            if (tempAcct.getAccountItem().startAccount.account != null && tempAcct.getAccountItem().startAccount.account.isLeaf) {
                this.setAccount2Param(tempAcct.getAccountItem().startAccount, isUserTempTable, accountTempTblParams, sqlWhere, accountTemp);
            }
            if (tempAcct.getAccountItem().endAccount.account == null || !tempAcct.getAccountItem().endAccount.account.isLeaf) continue;
            this.setAccount2Param(tempAcct.getAccountItem().endAccount, isUserTempTable, accountTempTblParams, sqlWhere, accountTemp);
        }
        ParamTempTblService tempService = null;
        try {
            boolean hasAccount = false;
            if (accountTempTblParams.size() > 0) {
                hasAccount = true;
                TableInfo table = new TableInfo("t_temp_account");
                table.addColumn(new ColumnInfo("fOrgNum", "varchar(200)"));
                table.addColumn(new ColumnInfo("faccountNum", "varchar(200)"));
                table.addColumn(new ColumnInfo("FAccountTableID", "varchar(80)"));
                tempService = ParamTempTblService.getInstance((Context)this.serverCtx, (TableInfo)table, accountTempTblParams, null);
                String tblName = tempService.getTmpTableName();
                sql.append(" join ").append(tblName).append(" tempTable on acct.FNumber like concat(tempTable.faccountNum,'_%') \n");
                sql.append(" and comp.FLongNumber like concat(tempTable.fOrgNum,'!%') \n");
                sql.append(" and acct.FAccountTableID = tempTable.FAccountTableID  \n");
            } else if (sqlWhere.length() > 0) {
                hasAccount = true;
                sqlWhere = sqlWhere.delete(0, 3);
                sql = sql.append(" where ").append(sqlWhere);
            }
            if (!hasAccount) {
                return;
            }
            IRowSet rs = DbUtil.executeQuery((Context)this.serverCtx, (String)sql.toString());
            String accountKey = null;
            AccountExt account = null;
            while (rs.next()) {
                accountKey = rs.getString("compLongNumber") + rs.getString("acctNumber") + rs.getString("accountTableID");
                account = (AccountExt)accountTemp.get(accountKey);
                if (account == null) continue;
                account.account.isLeaf = false;
            }
        }
        finally {
            if (tempService != null && !DebugLogger.isDebug) {
                tempService.release();
            }
        }
    }

    private void setAccount2Param(AccountExt account, boolean isUserTempTable, Set<List<String>> accountTempTblParams, StringBuffer sqlWhere, Map<String, AccountExt> accountTemp) {
        String companyLongNumber = null;
        companyLongNumber = account.getCompany().isIsProfitOrgUnit() && account.getCompany().get("DELEGATED_COMPANY_LONG_NUMBER") instanceof String ? (String)account.getCompany().get("DELEGATED_COMPANY_LONG_NUMBER") : account.getCompany().getLongNumber();
        String accountNumber = account.getAccountNumber();
        String accountTable = account.getAccountTable().getId().toString();
        String accountKey = companyLongNumber + accountNumber + accountTable;
        if (accountTemp.containsKey(accountKey)) {
            return;
        }
        accountTemp.put(accountKey, account);
        if (isUserTempTable) {
            ArrayList<String> accountTempTblParam = new ArrayList<String>();
            accountTempTblParam.add(companyLongNumber);
            accountTempTblParam.add(accountNumber);
            accountTempTblParam.add(accountTable);
            accountTempTblParams.add(accountTempTblParam);
        } else {
            sqlWhere.append(" or ( acct.FNumber like '").append(accountNumber).append("!%");
            sqlWhere.append("' and comp.FLongNumber like '").append(companyLongNumber).append("_%");
            sqlWhere.append("' and acct.FAccountTableID ='").append(accountTable).append("') \n");
        }
    }
}

