/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.IIndexItem;
import com.kingdee.eas.fi.rpt.IndexDataFactory;
import com.kingdee.eas.fi.rpt.IndexItemCollection;
import com.kingdee.eas.fi.rpt.IndexItemFactory;
import com.kingdee.eas.fi.rpt.IndexItemInfo;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.app.AbstractIndexItemControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Locale;

public class IndexItemControllerBean
extends AbstractIndexItemControllerBean {
    private static final long serialVersionUID = -3458230581770789648L;

    public void _checkNumberDup(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        IndexItemInfo indexItemInfo = (IndexItemInfo)model;
        if (StringUtils.isEmpty((String)indexItemInfo.getNumber())) {
            return;
        }
        String companyId = indexItemInfo.getCompany().getId().toString();
        String getTemplateSql = "SELECT FVERSIONNUMBER ,FTEMPLATETYPE,FNUMBER FROM T_RPT_TEMPLATE WHERE FID ='" + indexItemInfo.getTemplateId() + "'";
        boolean isDuplicate = false;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)getTemplateSql);
            if (!rs.next()) {
                throw new SQLDataException(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"CannotFindMatchedTemplate", (Locale)ctx.getOriginLocale()) + " FID = " + indexItemInfo.getTemplateId());
            }
            String versionNum = rs.getString(1);
            String templateType = rs.getString(2);
            String templateNum = rs.getString(3);
            String _sql = "SELECT FVERSIONNUMBER,FNUMBER FROM T_RPT_TEMPLATE WHERE FTEMPLATETYPE = ? AND FID IN (SELECT DISTINCT FTEMPLATEID FROM T_RPT_INDEXITEM WHERE FNUMBER = ? AND FCOMPANYID = ? ";
            if (indexItemInfo.getId() != null) {
                _sql = _sql + " AND FID != ? )";
                rs = DbUtil.executeQuery((Context)ctx, (String)_sql, (Object[])new Object[]{templateType, indexItemInfo.getNumber(), companyId, indexItemInfo.getId().toString()});
            } else {
                _sql = _sql + " )";
                rs = DbUtil.executeQuery((Context)ctx, (String)_sql, (Object[])new Object[]{templateType, indexItemInfo.getNumber(), companyId});
            }
            while (rs.next()) {
                if ((!versionNum.equals(rs.getString(1)) || !templateNum.equals(rs.getString(2))) && templateNum.equals(rs.getString(2))) continue;
                isDuplicate = true;
                break;
            }
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("group"));
            TemplateInfo tInfo = TemplateFactory.getLocalInstance(ctx).getTemplateInfo((IObjectPK)new ObjectUuidPK(indexItemInfo.getTemplateId()), selector);
            StringBuffer sql = new StringBuffer();
            sql.append(" select top 1 item.fid from t_rpt_indexitem item  \n").append(" join t_rpt_template t on item.ftemplateid = t.fid \n").append(" where item.fnumber = ? and t.fgroup <> ? \n");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{indexItemInfo.getNumber(), tInfo.getGroup()});
            if (rs != null && rs.next()) {
                isDuplicate = true;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (isDuplicate) {
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"ItemNumber", (Locale)ctx.getOriginLocale()) + indexItemInfo.getNumber() + " "});
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("indexItem", (Object)pk.toString()));
        IndexDataFactory.getLocalInstance(ctx).delete(filterInfo);
        this.recycleNumber(ctx, this.getIndexItemInfo(ctx, pk));
        super._delete(ctx, pk);
    }

    @Override
    protected void _update(Context ctx, IndexItemCollection indexItems) throws BOSException, EASBizException {
        IIndexItem iIndexItem = IndexItemFactory.getLocalInstance(ctx);
        int size = indexItems.size();
        for (int i = 0; i < size; ++i) {
            ObjectUuidPK pk = new ObjectUuidPK(indexItems.get(i).getId());
            iIndexItem.update((IObjectPK)pk, (CoreBaseInfo)indexItems.get(i));
        }
    }

    private void recycleNumber(Context ctx, IndexItemInfo caller) throws EASBizException, BOSException {
        if (caller == null) {
            return;
        }
        String companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.getCodingRule((IObjectValue)caller, companyId) != null && iCodingRuleManager.isUseIntermitNumber((IObjectValue)caller, companyId)) {
            iCodingRuleManager.recycleNumber((IObjectValue)caller, companyId, caller.getNumber());
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        IIndexItem iIndexItem = IndexItemFactory.getLocalInstance(ctx);
        IndexItemInfo caller = (IndexItemInfo)model;
        String companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        if (caller.getNumber() == null || caller.getNumber().length() <= 0) {
            if (iCodingRuleManager.getCodingRule((IObjectValue)caller, companyId) != null) {
                String number = iCodingRuleManager.getNumber((IObjectValue)caller, companyId);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
                while (iIndexItem.exists(filter)) {
                    number = iCodingRuleManager.getNumber((IObjectValue)caller, companyId);
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
                    filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
                }
                caller.setNumber(number);
            } else {
                throw new EASBizException(EASBizException.CHECKNUMBLANK);
            }
        }
        return super._addnew(ctx, (IObjectValue)caller);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, model);
        super._update(ctx, pk, model);
    }
}

