/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.extendcontrols.QueryAgent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.ContextUtils;
import com.kingdee.eas.base.permission.app.config.ConfigurationLoader;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.basedata.master.account.AccountException;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGCollection;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.newrpt.MultOrgUnitHelper;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.InitDataFacadaFactory;
import com.kingdee.eas.fi.rpt.ItemInfo;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.app.AbstractInitDataFacadaControllerBean;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectBaseCollection;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Base64Encoder;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.UuidException;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class InitDataFacadaControllerBean
extends AbstractInitDataFacadaControllerBean {
    private static final Logger log = Logger.getLogger((String)InitDataFacadaControllerBean.class.getName());

    @Override
    protected HashMap _initAcctBatchFill(Context ctx) throws BOSException, EASBizException {
        HashMap<String, Object> initData = new HashMap<String, Object>();
        initData.put("0", this.getAcctType(ctx));
        initData.put("1", this.getCurrency(ctx));
        initData.put("2", this.getFiscal(ctx));
        initData.put("3", this.getCurrentFiscal(ctx));
        return initData;
    }

    @Override
    protected AccountViewCollection _getAcctUseItem(Context ctx, IObjectPK itemTypePK) throws BOSException, EASBizException {
        return this.getAcctUseItem(ctx, itemTypePK, null, null);
    }

    @Override
    protected AssistantHGCollection _getItem(Context ctx, AsstActTypeInfo asstActTypeInfo, IObjectPK AsstAcctPK) throws BOSException, EASBizException {
        String actTypeField = asstActTypeInfo.getAsstHGAttribute();
        if (actTypeField == null || actTypeField.trim().length() == 0) {
            return null;
        }
        IAssistantHG iAssistantHG = AssistantHGFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewAsst = new EntityViewInfo();
        SelectorItemCollection sicAsst = viewAsst.getSelector();
        sicAsst.add(new SelectorItemInfo("id"));
        sicAsst.add(new SelectorItemInfo(actTypeField + ".id"));
        sicAsst.add(new SelectorItemInfo(actTypeField + ".number"));
        sicAsst.add(new SelectorItemInfo(actTypeField + ".name"));
        FilterInfo filterAsst = new FilterInfo();
        FilterItemInfo filterItemAcct = new FilterItemInfo("asstAccount.id", (Object)AsstAcctPK.toString());
        filterAsst.getFilterItems().add(filterItemAcct);
        return iAssistantHG.getAssistantHGCollection(viewAsst);
    }

    @Override
    protected List _getItemUseType(Context ctx, AsstActTypeInfo asstActTypeInfo) throws BOSException, EASBizException {
        if (asstActTypeInfo == null) {
            return null;
        }
        String query = asstActTypeInfo.getDefaultQueryName();
        if (query == null || query.trim().length() == 0) {
            return null;
        }
        MetaDataPK queryPK = new MetaDataPK(query);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        if (asstActTypeInfo.isIsForCompany()) {
            String companyid = ContextUtils.getCurrentCompany((Context)ctx);
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            SelectorItemCollection sc = entityViewInfo.getSelector();
            sc.add(new SelectorItemInfo("id"));
            sc.add(new SelectorItemInfo("number"));
            sc.add(new SelectorItemInfo("name"));
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo filterItemInfo = new FilterItemInfo("company.id", (Object)companyid);
            FilterItemInfo filterItemInfo1 = new FilterItemInfo("company.id", null);
            filterInfo.getFilterItems().add(filterItemInfo);
            filterInfo.getFilterItems().add(filterItemInfo1);
            filterInfo.setMaskString("#0 or #1");
            entityViewInfo.setFilter(filterInfo);
            exec.setObjectView(entityViewInfo);
        }
        exec.option().isAutoIgnoreDuplicatedRow = false;
        IRowSet rowset = exec.executeQuery();
        ArrayList<String[]> arrayItem = new ArrayList<String[]>();
        try {
            while (rowset.next()) {
                String[] valueObject = new String[]{rowset.getString("id"), rowset.getString("number"), rowset.getString("name")};
                arrayItem.add(valueObject);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return arrayItem;
    }

    @Override
    protected AsstActTypeCollection _getAcctType(Context ctx) throws BOSException, EASBizException {
        return this.getAcctType(ctx, null);
    }

    @Override
    protected CurrencyCollection _getCurrency(Context ctx) throws BOSException {
        ICurrency initICurrcny = CurrencyFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewCurrency = new EntityViewInfo();
        SelectorItemCollection sicCurrency = viewCurrency.getSelector();
        sicCurrency.add(new SelectorItemInfo("id"));
        sicCurrency.add(new SelectorItemInfo("number"));
        sicCurrency.add(new SelectorItemInfo("name"));
        sicCurrency.add(new SelectorItemInfo("precision"));
        CurrencyCollection initCurrencyCollection = initICurrcny.getCurrencyCollection(viewCurrency);
        return initCurrencyCollection;
    }

    @Override
    protected CurrencyCollection _getCurrencyNoGLC(Context ctx) throws BOSException {
        ICurrency initICurrcny = CurrencyFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewCurrency = new EntityViewInfo();
        SelectorItemCollection sicCurrency = viewCurrency.getSelector();
        sicCurrency.add(new SelectorItemInfo("id"));
        sicCurrency.add(new SelectorItemInfo("number"));
        sicCurrency.add(new SelectorItemInfo("name"));
        sicCurrency.add(new SelectorItemInfo("precision"));
        FilterInfo filterCurrency = new FilterInfo();
        filterCurrency.getFilterItems().add(new FilterItemInfo("number", (Object)"GLC", CompareType.NOTEQUALS));
        filterCurrency.getFilterItems().add(new FilterItemInfo("number", (Object)"GRC", CompareType.NOTEQUALS));
        viewCurrency.setFilter(filterCurrency);
        CurrencyCollection initCurrencyCollection = initICurrcny.getCurrencyCollection(viewCurrency);
        return initCurrencyCollection;
    }

    @Override
    protected PeriodCollection _getFiscal(Context ctx) throws BOSException, EASBizException {
        return this.getFiscal(ctx, null);
    }

    @Override
    protected PeriodInfo _getCurrentFiscal(Context ctx) throws BOSException, EASBizException {
        return this.getCurrentFiscal(ctx, null);
    }

    @Override
    protected AsstActTypeCollection _getAcctType(Context ctx, IObjectPK cuid) throws BOSException, EASBizException {
        String cu = null;
        String cuLongNumber = null;
        if (cuid == null) {
            cu = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
            cuLongNumber = ContextUtil.getCurrentCtrlUnit((Context)ctx).getLongNumber();
        } else {
            cu = cuid.toString();
            cuLongNumber = FullOrgUnitFactory.getLocalInstance((Context)ctx).getOrgUnitInfo(cuid).getLongNumber();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT ASSTACTTYPE.FID AS ID                                       ");
        sb.append(" FROM T_BD_AsstActType AS ASSTACTTYPE                               ");
        sb.append(" INNER JOIN T_ORG_CtrlUnit AS CU                                    ");
        sb.append(" ON ASSTACTTYPE.FControlUnitID = CU.FID                             ");
        sb.append(" LEFT OUTER JOIN T_BD_GeneralAsstActTypeGroup AS GLASSTACTTYPEGRP   ");
        sb.append(" ON ASSTACTTYPE.FGlAsstActTypeGrpID = GLASSTACTTYPEGRP.FID          ");
        sb.append(" WHERE (CU.FID = ?     ");
        sb.append(" OR ((CU.FID = '00000000-0000-0000-0000-000000000000CCE7AED4'      ");
        sb.append(" AND (ASSTACTTYPE.FGlAsstActTypeGrpID IS NOT NULL))                 ");
        sb.append(" AND (GLASSTACTTYPEGRP.FShareTactic <> 3))                         ");
        if (cuLongNumber != null) {
            String[] split = cuLongNumber.split("!");
            StringBuffer s = new StringBuffer();
            String l = null;
            for (int i = 0; i < split.length; ++i) {
                if (l != null) {
                    l = l + "!" + split[i];
                    s.append(", '" + l + "' ");
                    continue;
                }
                l = split[i];
                s.append(" '" + l + "' ");
            }
            sb.append(" OR (CU.FLongNumber IN (" + s.toString() + ") ");
            sb.append(" AND (ASSTACTTYPE.FGlAsstActTypeGrpID IS NULL)) ");
        }
        sb.append(") union SELECT  T0.FASSTACTTYPEID AS ID                              ");
        sb.append(" FROM T_BD_ASSTACTTYPEREFERENCE t0 \t\t\t\t\t");
        sb.append(" WHERE T0.FASSIGNCUID = ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new String[]{cu, cu});
        HashSet<String> ids = new HashSet<String>();
        try {
            while (rs.next()) {
                ids.add(rs.getString(1));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        EntityViewInfo viewAcct = new EntityViewInfo();
        SelectorItemCollection sicAcct = viewAcct.getSelector();
        sicAcct.add(new SelectorItemInfo("id"));
        sicAcct.add(new SelectorItemInfo("name"));
        sicAcct.add(new SelectorItemInfo("number"));
        sicAcct.add(new SelectorItemInfo("defaultQueryName"));
        sicAcct.add(new SelectorItemInfo("isForCompany"));
        sicAcct.add(new SelectorItemInfo("glAsstActTypeGrp"));
        sicAcct.add(new SelectorItemInfo("isSystemAsstActItem"));
        sicAcct.add(new SelectorItemInfo("isSelfAsstActaiatem"));
        sicAcct.add(new SelectorItemInfo("asstHGAttribute"));
        sicAcct.add(new SelectorItemInfo("RealtionDataObject"));
        sicAcct.add(new SelectorItemInfo("useLongNumber"));
        FilterInfo filterAcct = new FilterInfo();
        FilterItemCollection filterItems = filterAcct.getFilterItems();
        filterItems.add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        SorterItemCollection sorter = viewAcct.getSorter();
        sorter.add(new SorterItemInfo("number"));
        viewAcct.setFilter(filterAcct);
        IAsstActType iAsstActType = AsstActTypeFactory.getLocalInstance((Context)ctx);
        AsstActTypeCollection asstActTypeCollection = iAsstActType.getAsstActTypeCollection(viewAcct);
        return asstActTypeCollection;
    }

    @Override
    protected AccountViewCollection _getAcctUseItem(Context ctx, IObjectPK itemTypePK, IObjectPK companyPK, String accountTableID) throws BOSException, EASBizException {
        String companyid = null;
        companyid = companyPK == null ? ContextUtils.getCurrentCompany((Context)ctx) : companyPK.toString();
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid));
        if (accountTableID == null && company.getAccountTable() != null) {
            accountTableID = company.getAccountTable().getId().toString();
        }
        if (accountTableID == null) {
            throw new AccountException(AccountException.CURRENTCOMPANYHASNOSTARTACCOUNTTABLE);
        }
        AccountViewCollection accountViewCollection = new AccountViewCollection();
        if (itemTypePK != null) {
            MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.fi.rpt.app", "itemTypeAcctQuery");
            IQueryExecutor queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
            if (itemTypePK != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("asstActType.id", (Object)itemTypePK.toString()));
                filterInfo.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTableID));
            }
            SorterItemCollection sorter = view.getSorter();
            sorter.add(new SorterItemInfo("number"));
            view.setFilter(filterInfo);
            queryExecutor.setObjectView(view);
            queryExecutor.option().isAutoIgnoreDuplicatedRow = true;
            IRowSet rs = queryExecutor.executeQuery();
            try {
                while (rs.next()) {
                    AccountViewInfo temp = new AccountViewInfo();
                    String id = rs.getString(1);
                    String name = rs.getString(2);
                    String number = rs.getString(3);
                    String caa = rs.getString(4);
                    int level = rs.getInt(5);
                    String longName = rs.getString(6);
                    temp.setId(BOSUuid.read((String)id));
                    temp.setName(name);
                    temp.setNumber(number);
                    if (caa != null) {
                        AsstAccountInfo asstAccountInfo = new AsstAccountInfo();
                        asstAccountInfo.setId(BOSUuid.read((String)caa));
                        temp.setCAA(asstAccountInfo);
                    }
                    temp.setLevel(level);
                    temp.setLongName(longName);
                    accountViewCollection.add(temp);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        } else {
            EntityViewInfo viewAcct = new EntityViewInfo();
            SelectorItemCollection sicAcct = viewAcct.getSelector();
            sicAcct.add(new SelectorItemInfo("id"));
            sicAcct.add(new SelectorItemInfo("name"));
            sicAcct.add(new SelectorItemInfo("number"));
            sicAcct.add(new SelectorItemInfo("CAA.id"));
            sicAcct.add(new SelectorItemInfo("parent.id"));
            sicAcct.add(new SelectorItemInfo("level"));
            sicAcct.add(new SelectorItemInfo("longName"));
            FilterInfo filterAcct = new FilterInfo();
            FilterItemInfo filterItemCompany = new FilterItemInfo("companyID.id", (Object)company.getId().toString());
            filterAcct.getFilterItems().add(filterItemCompany);
            filterAcct.getFilterItems().add(new FilterItemInfo("AccountTableID", (Object)accountTableID));
            viewAcct.setFilter(filterAcct);
            SorterItemCollection sorter = viewAcct.getSorter();
            sorter.add(new SorterItemInfo("number"));
            IAccountView iAccountView = AccountViewFactory.getLocalInstance((Context)ctx);
            accountViewCollection = iAccountView.getAccountViewCollection(viewAcct);
        }
        return accountViewCollection;
    }

    @Override
    protected List _getItemUseType(Context ctx, AsstActTypeInfo asstActTypeInfo, IObjectPK companyPK) throws BOSException, EASBizException {
        if (asstActTypeInfo == null) {
            return null;
        }
        String query = asstActTypeInfo.getDefaultQueryName();
        if (query == null || query.trim().length() == 0) {
            return null;
        }
        MetaDataPK queryPK = new MetaDataPK(query);
        String companyid = null;
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        companyid = companyPK == null ? ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString() : companyPK.toString();
        if (companyid != null) {
            ICompanyOrgUnit icompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            companyOrgUnitInfo = icompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyid)));
        }
        if (companyOrgUnitInfo == null) {
            throw new BOSException("companyOrgUnitInfo is null");
        }
        boolean paramIsTrue = RptUtil.isTrue(ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(companyid), (String)"fi_rp_004"));
        String mappingTableName = asstActTypeInfo.getRealtionDataObject();
        String mappingFieldName = asstActTypeInfo.getAsstHGAttribute();
        if (mappingFieldName.equals("person") && paramIsTrue) {
            queryPK = new MetaDataPK("com.kingdee.eas.fi.gr.dynamic.app", "AllPositionPersonQuery");
        }
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection sc = entityViewInfo.getSelector();
        sc.add(new SelectorItemInfo("id"));
        sc.add(new SelectorItemInfo("number"));
        sc.add(new SelectorItemInfo("name"));
        if (asstActTypeInfo.isUseLongNumber()) {
            sc.add(new SelectorItemInfo("longNumber"));
        }
        QueryAgent qa = new QueryAgent();
        FilterInfo ff = new FilterInfo();
        IRowSet rowset = null;
        ArrayList<String[]> arrayItem = new ArrayList<String[]>();
        if (mappingTableName.equalsIgnoreCase("T_BD_GeneralAsstActType")) {
            String groupId = asstActTypeInfo.getGlAsstActTypeGrp().getId().toString();
            FilterInfo filterInfo = DynamicTemplateUtility.getFilterForGeneral((Context)ctx, (String)groupId, (CompanyOrgUnitInfo)companyOrgUnitInfo);
            entityViewInfo.setFilter(filterInfo);
            exec.setObjectView(entityViewInfo);
            rowset = exec.executeQuery();
            try {
                while (rowset.next()) {
                    String longnumber;
                    String[] valueObject = new String[]{rowset.getString("id"), (longnumber = rowset.getString("longnumber")) == null ? null : longnumber.replaceAll("\\!", "\\."), rowset.getString("name")};
                    arrayItem.add(valueObject);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        if (mappingFieldName.equals("customer")) {
            entityViewInfo.setIngorePreOrders(true);
            if (paramIsTrue) {
                String glAsstActTypeGrpID;
                qa.setHasCUDefaultFilter(false);
                String string = glAsstActTypeGrpID = asstActTypeInfo.getGlAsstActTypeGrp() == null ? null : asstActTypeInfo.getGlAsstActTypeGrp().getId().toString();
                if (asstActTypeInfo.getRealtionDataObject().equals("T_BD_Customer")) {
                    ff = RptUtil.buildCustomerFilter(ctx, (OrgUnitInfo)companyOrgUnitInfo, false);
                }
            }
            qa.setHasCUDefaultFilter(false);
        } else if (mappingFieldName.equals("provider")) {
            try {
                ff = SupplierFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(companyOrgUnitInfo.getCU().getId()), "id", "adminCU.id");
            }
            catch (Exception glAsstActTypeGrpID) {
                // empty catch block
            }
            qa.setHasCUDefaultFilter(false);
        } else if (mappingFieldName.equals("material")) {
            try {
                ff = MaterialFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(companyOrgUnitInfo.getCU().getId()), "id", "adminCU.id");
            }
            catch (Exception glAsstActTypeGrpID) {
                // empty catch block
            }
            qa.setHasCUDefaultFilter(false);
        } else if (mappingFieldName.equals("person")) {
            if (paramIsTrue && !StringUtils.isEmpty((String)companyid)) {
                String adminOrgFilterSql = CslRptUtil.getAdminOrgUnitFilterSql((Context)ctx, (String)companyid);
                if (!StringUtils.isEmpty((String)adminOrgFilterSql)) {
                    ff.getFilterItems().add(new FilterItemInfo("ADMINORGUNIT.id", (Object)adminOrgFilterSql, CompareType.INNER));
                    ff.getFilterItems().add(new FilterItemInfo("PM2.id", null, CompareType.IS));
                    ff.getFilterItems().add(new FilterItemInfo("ADMINORGUNIT2.id", (Object)adminOrgFilterSql, CompareType.INNER));
                    ff.setMaskString("( (#0 and #1) or #2 )");
                } else {
                    log.error((Object)"adminOrgFilterSql is null");
                }
            }
        } else if ("bankAccount".equalsIgnoreCase(mappingFieldName)) {
            if (paramIsTrue) {
                FilterItemCollection fic = ff.getFilterItems();
                fic.add(new FilterItemInfo("company.id", (Object)companyid));
                fic.add(new FilterItemInfo("company.id", null));
                ff.setMaskString("#0 OR #1");
            }
            qa.setHasCUDefaultFilter(false);
        } else if ("project".equalsIgnoreCase(mappingFieldName)) {
            if (paramIsTrue) {
                String longNumber = CtrlUnitFactory.getLocalInstance((Context)ctx).getOrgUnitInfo("select * where id = '" + companyOrgUnitInfo.getCU().getId().toString() + "'").getLongNumber();
                String[] numbers = longNumber.split("!");
                HashSet<String> lnUps = new HashSet<String>();
                for (int i = 0; i < numbers.length; ++i) {
                    lnUps.add(numbers[i]);
                }
                ff.getFilterItems().add(new FilterItemInfo("cu.number", lnUps, CompareType.INCLUDE));
                ff.setMaskString("#0");
            }
            qa.setHasCUDefaultFilter(false);
        } else if ("costObject".equalsIgnoreCase(mappingFieldName)) {
            if (paramIsTrue) {
                FilterItemCollection fic = ff.getFilterItems();
                fic.add(new FilterItemInfo("company.id", (Object)companyOrgUnitInfo.getId()));
            }
        } else if ("costOrg".equalsIgnoreCase(mappingFieldName)) {
            if (paramIsTrue) {
                boolean isBizUnit = companyOrgUnitInfo.isIsBizUnit();
                String curOrgCU = null;
                String longNumber = null;
                if (isBizUnit) {
                    curOrgCU = companyOrgUnitInfo.getId().toString();
                    longNumber = companyOrgUnitInfo.getLongNumber();
                } else {
                    curOrgCU = companyOrgUnitInfo.getCU().getId().toString();
                    longNumber = companyOrgUnitInfo.getCU().getLongNumber();
                }
                ArrayList<String> CostOrgIds = new ArrayList<String>();
                if (isBizUnit) {
                    CostOrgIds.add(curOrgCU);
                } else {
                    this.getCurCUCostOrgs(ctx, curOrgCU, CostOrgIds);
                }
                this.getFromCostOrgs(ctx, curOrgCU, CostOrgIds);
                if (CostOrgIds.size() <= 0) {
                    CostOrgIds.add(ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString());
                }
                ff.getFilterItems().add(new FilterItemInfo("id", new HashSet(CostOrgIds), CompareType.INCLUDE));
                ff.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber + "!%"), CompareType.LIKE));
                ff.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)new Integer(0)));
                ff.setMaskString("( #0 OR #1 ) AND #2");
            } else {
                ff.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)new Integer(0)));
            }
        } else if (paramIsTrue) {
            ff.getFilterItems().add(new FilterItemInfo("cu.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
            ff.getFilterItems().add(new FilterItemInfo("cu.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
            ff.getFilterItems().add(new FilterItemInfo("cu.id", (Object)companyOrgUnitInfo.getCU().getId(), CompareType.EQUALS));
            ff.setMaskString(" #0 or #1 or #2 ");
        }
        entityViewInfo.setFilter(ff);
        SorterItemCollection sorter = entityViewInfo.getSorter();
        sorter.clear();
        sorter.add(new SorterItemInfo("number"));
        exec.setObjectView(entityViewInfo);
        rowset = exec.executeQuery();
        try {
            while (rowset.next()) {
                String[] valueObject = new String[]{rowset.getString("id"), asstActTypeInfo.isUseLongNumber() ? rowset.getString("longNumber") : rowset.getString("number"), rowset.getString("name")};
                arrayItem.add(valueObject);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        HashMap<String, String> filterMap = new HashMap<String, String>();
        ArrayList<String[]> list = new ArrayList<String[]>();
        for (int i = 0; i < arrayItem.size(); ++i) {
            String[] valueObject = (String[])arrayItem.get(i);
            if (filterMap.get(valueObject[1]) != null) continue;
            filterMap.put(valueObject[1], valueObject[1]);
            list.add(valueObject);
        }
        return list;
    }

    @Override
    protected PeriodCollection _getFiscal(Context ctx, IObjectPK companyPK) throws BOSException, EASBizException {
        String companyid = null;
        companyid = companyPK == null ? ContextUtils.getCurrentCompany((Context)ctx) : companyPK.toString();
        if (companyid == null || companyid.length() == 0) {
            return null;
        }
        IPeriod initIPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewPeriod = new EntityViewInfo();
        FilterInfo filterPeriod = new FilterInfo();
        viewPeriod.setFilter(filterPeriod);
        FilterItemCollection ficPeriod = filterPeriod.getFilterItems();
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyid)));
        if (companyInfo == null) {
            OrgType orgType = OrgType.ProfitCenter;
            companyInfo = MultOrgUnitHelper.getInstance().getDelegateCompany(orgType, companyid, ctx);
        }
        PeriodTypeInfo periodTypeInfo = companyInfo.getAccountPeriodType();
        ficPeriod.add(new FilterItemInfo("periodType.id", (Object)periodTypeInfo.getId().toString()));
        SorterItemCollection sorter = viewPeriod.getSorter();
        SorterItemInfo year = new SorterItemInfo("periodYear");
        year.setSortType(SortType.ASCEND);
        sorter.add(year);
        sorter.add(new SorterItemInfo("periodNumber"));
        PeriodCollection periodCollection = initIPeriod.getPeriodCollection(viewPeriod);
        return periodCollection;
    }

    @Override
    protected HashMap _initAcctBatchFill(Context ctx, IObjectPK companyPK) throws BOSException, EASBizException {
        HashMap<String, Object> initData = new HashMap<String, Object>();
        initData.put("0", this.getAcctType(ctx, companyPK));
        initData.put("1", this.getCurrency(ctx));
        try {
            initData.put("2", this.getFiscal(ctx, companyPK));
            initData.put("3", this.getCurrentFiscal(ctx, companyPK));
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
        return initData;
    }

    @Override
    protected PeriodInfo _getCurrentFiscal(Context ctx, IObjectPK companyPK) throws BOSException, EASBizException {
        String companyid = null;
        companyid = companyPK == null ? ContextUtils.getCurrentCompany((Context)ctx) : companyPK.toString();
        if (companyid == null || companyid.length() == 0) {
            return null;
        }
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyid)));
        if (companyInfo.isIsOnlyUnion()) {
            return this.getUnionCurrenctFiscal(ctx, companyInfo.getLongNumber());
        }
        PeriodInfo periodInfo = GlUtils.getCurrentPeriod((Context)ctx, (String)companyid);
        return periodInfo;
    }

    private PeriodInfo getUnionCurrenctFiscal(Context ctx, String unionNumber) throws BOSException, EASBizException {
        PeriodInfo periodInfo = null;
        IRowSet tempids = null;
        StringBuffer _sql = new StringBuffer("select top 1 period.fid from T_BD_SystemStatusCtrol ssc,t_bd_period period ,t_org_company company,T_BD_SystemStatus systemStatus");
        _sql.append(" where ssc.fcurrentperiodid = period.fid and ssc.fcompanyid = company.fid and ssc.fsystemstatusid = systemStatus.fid");
        _sql.append(" and systemStatus.fname = 6 and (company.flongnumber = ? or company.flongnumber like ?)");
        _sql.append(" and company.fisonlyunion = 0 order by fperiodyear asc,fperiodQuarter asc,fperiodnumber asc");
        Object[] params = new Object[]{new String(unionNumber), new String(unionNumber + "!%")};
        try {
            tempids = DbUtil.executeQuery((Context)ctx, (String)_sql.toString(), (Object[])params);
            while (tempids.next()) {
                periodInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(tempids.getString(1)));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (periodInfo == null) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getReportResource("GL_NOCURPERIOD", ctx.getOriginLocale())});
        }
        return periodInfo;
    }

    @Override
    protected IObjectCollection _getAllAsstActType(Context ctx) throws BOSException {
        EntityViewInfo entityView = new EntityViewInfo();
        entityView.getSelector().add(new SelectorItemInfo("*"));
        return AsstActTypeFactory.getLocalInstance((Context)ctx).getCollection(entityView);
    }

    @Override
    protected IObjectCollection _getSortedItem(Context ctx, IObjectCollection paramList) throws BOSException {
        String language = "_" + ctx.getLocale().getLanguage().toUpperCase();
        CSSPGroupInfo csspGroupInfo = (CSSPGroupInfo)paramList.getObject(1);
        AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)paramList.getObject(0);
        IObjectPK companyPK = (IObjectPK)asstActTypeInfo.get("CompanyUuid");
        String ctrlUnitPK = null;
        String SOSObjectType = null;
        String likeNumber = null;
        String companyid = null;
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        companyid = companyPK == null ? ContextUtils.getCurrentCompany((Context)ctx) : companyPK.toString();
        if (companyPK != null) {
            ICompanyOrgUnit icompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            try {
                companyOrgUnitInfo = icompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyid)));
            }
            catch (EASBizException e) {
                log.debug((Object)e.getMessage());
            }
            catch (BOSException e) {
                log.debug((Object)e.getMessage());
            }
            catch (UuidException e) {
                log.debug((Object)e.getMessage());
            }
        }
        if (companyOrgUnitInfo != null && companyOrgUnitInfo.getCU() != null && companyOrgUnitInfo.getCU().getId() != null) {
            ctrlUnitPK = companyOrgUnitInfo.getCU().getId().toString();
        }
        SOSObjectType = "36F80EBE";
        likeNumber = csspGroupInfo.getLongNumber().toString();
        String sql = null;
        if (asstActTypeInfo.getRealtionDataObject().equalsIgnoreCase("T_BD_Supplier")) {
            sql = this.generateSQL(ctx, likeNumber, SOSObjectType, companyOrgUnitInfo, "T_BD_Supplier", "FSupplierID", "FSupplierGroupID");
        }
        if (asstActTypeInfo.getRealtionDataObject().equalsIgnoreCase("T_BD_Customer")) {
            sql = this.generateSQL(ctx, likeNumber, SOSObjectType, companyOrgUnitInfo, "T_BD_Customer", "FCustomerID", "FCustomerGroupID");
        }
        ObjectBaseCollection c = new ObjectBaseCollection();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                ItemInfo item = new ItemInfo();
                item.put("FID", rs.getString("FID"));
                item.put("FNAME", rs.getString("FNAME" + language + ""));
                item.put("FNUMBER", rs.getString("FNUMBER"));
                item.put("AsstActType_ID", asstActTypeInfo.getId().toString());
                c.add((ObjectBaseInfo)item);
            }
        }
        catch (SQLException e) {
            log.debug((Object)e.getMessage());
        }
        return c;
    }

    protected IObjectCollection _getItems(Context ctx, IObjectCollection paramList) throws BOSException {
        String language = "_" + ctx.getLocale().getLanguage().toUpperCase();
        AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)paramList.getObject(0);
        String currentCUID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        String sql = "SELECT FID ,FNAME" + language + ",FNUMBER FROM  " + asstActTypeInfo.getRealtionDataObject() + " WHERE " + asstActTypeInfo.getRealtionDataObject() + ".FControlUnitID='" + currentCUID + "'";
        ObjectBaseCollection c = new ObjectBaseCollection();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                ItemInfo item = new ItemInfo();
                item.put("FID", rs.getString("FID"));
                item.put("FNAME", rs.getString("FNAME" + language + ""));
                item.put("FNUMBER", rs.getString("FNUMBER"));
                item.put("AsstActType_ID", asstActTypeInfo.getId().toString());
                c.add((ObjectBaseInfo)item);
            }
        }
        catch (SQLException e) {
            log.debug((Object)e.getMessage());
        }
        return c;
    }

    @Override
    protected IObjectCollection _queryItems(Context ctx, boolean isSorted, ArrayList params) throws BOSException, EASBizException {
        ObjectBaseCollection c = new ObjectBaseCollection();
        if (isSorted) {
            ArrayList line = params;
            ArrayList<Object[]> customer = new ArrayList<Object[]>();
            ArrayList<Object[]> suplier = new ArrayList<Object[]>();
            for (int i = 0; i < line.size(); ++i) {
                Object[] data = (Object[])line.get(i);
                if (((AsstActTypeInfo)data[0]).getRealtionDataObject().equalsIgnoreCase("T_BD_Supplier")) {
                    suplier.add(data);
                    line.set(i, null);
                    continue;
                }
                if (!((AsstActTypeInfo)data[0]).getRealtionDataObject().equalsIgnoreCase("T_BD_Customer")) continue;
                customer.add(data);
                line.set(i, null);
            }
            IObjectCollection cc1 = null;
            IObjectCollection cc2 = null;
            try {
                cc1 = this._getCustomerItems(ctx, customer);
                cc2 = this._getSupperItems(ctx, suplier);
            }
            catch (SQLException e) {
                return null;
            }
            IObjectCollection cc3 = this.getOtherItems(ctx, line);
            if (cc1 != null) {
                c.addObjectCollection(cc1);
            }
            if (cc2 != null) {
                c.addObjectCollection(cc2);
            }
            if (cc3 != null) {
                c.addObjectCollection(cc3);
            }
            return c;
        }
        return this.getOtherItems(ctx, params);
    }

    private IObjectCollection _getSupperItems(Context ctx, ArrayList p) throws BOSException, SQLException, EASBizException, UuidException {
        HashMap<Object, ItemInfo> resultSet = null;
        if (p.size() == 0) {
            return null;
        }
        Object[] tempData = (Object[])p.get(0);
        AsstActTypeInfo tempAsstActTypeInfo = (AsstActTypeInfo)tempData[0];
        IObjectPK companyPK = (IObjectPK)tempAsstActTypeInfo.get("CompanyUuid");
        String ctrlUnitPK = null;
        String companyid = null;
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        companyid = companyPK == null ? ContextUtils.getCurrentCompany((Context)ctx) : companyPK.toString();
        if (companyPK != null) {
            ICompanyOrgUnit icompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            try {
                companyOrgUnitInfo = icompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyid)));
            }
            catch (EASBizException e) {
                log.debug((Object)e.getMessage());
            }
            catch (BOSException e) {
                log.debug((Object)e.getMessage());
            }
            catch (UuidException e) {
                log.debug((Object)e.getMessage());
            }
        }
        if (companyOrgUnitInfo != null && companyOrgUnitInfo.getCU() != null && companyOrgUnitInfo.getCU().getId() != null) {
            ctrlUnitPK = companyOrgUnitInfo.getCU().getId().toString();
        }
        for (int i = 0; i < p.size(); ++i) {
            Object[] data = (Object[])p.get(i);
            AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)data[0];
            CSSPGroupStandardInfo stand = (CSSPGroupStandardInfo)data[1];
            CSSPGroupInfo csspGroupInfo = (CSSPGroupInfo)data[2];
            HashMap map = this.getSuppers(ctx, asstActTypeInfo, stand, csspGroupInfo, ctrlUnitPK);
            if (i == 0) {
                resultSet = map;
                continue;
            }
            HashMap<Object, ItemInfo> newMap = new HashMap<Object, ItemInfo>();
            for (ItemInfo item : resultSet.values()) {
                if (map.get(item.get("FID")) == null) continue;
                newMap.put(item.get("FID"), item);
            }
            resultSet = newMap;
        }
        ObjectBaseCollection c = new ObjectBaseCollection();
        if (resultSet != null) {
            Iterator it = resultSet.values().iterator();
            while (it.hasNext()) {
                c.add((ObjectBaseInfo)((ItemInfo)((Object)it.next())));
            }
        }
        return c;
    }

    private HashMap getSuppers(Context ctx, AsstActTypeInfo type, CSSPGroupStandardInfo stand, CSSPGroupInfo group, String cuid) throws BOSException, SQLException, EASBizException, UuidException {
        HashMap<Object, ItemInfo> map = new HashMap<Object, ItemInfo>();
        MetaDataPK metaDataPK = new MetaDataPK("com.kingdee.eas.basedata.master.cssp.app", "F7SupplierQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metaDataPK);
        EntityViewInfo mainQuery = new EntityViewInfo();
        mainQuery.getSelector().add(new SelectorItemInfo("id"));
        mainQuery.getSelector().add(new SelectorItemInfo("number"));
        mainQuery.getSelector().add(new SelectorItemInfo("name"));
        FilterInfo filter = SupplierFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)cuid)), "id", "adminCU.id");
        mainQuery.setFilter(filter);
        int oldsize = filter.getFilterItems().size();
        String mask = filter.getMaskString();
        filter.getFilterItems().add(new FilterItemInfo("supplierGroupDetails.supplierGroupStandard.id", (Object)stand.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("supplierGroupDetails.supplierGroup.id", (Object)group.getId().toString()));
        if (!StringUtils.isEmpty((String)mask)) {
            StringBuffer buf = new StringBuffer();
            buf.append("(" + mask + ")");
            buf.append(" AND #" + oldsize);
            buf.append(" AND #" + (oldsize + 1));
            filter.setMaskString(buf.toString());
        }
        exec.setObjectView(mainQuery);
        IRowSet rowSet = exec.executeQuery();
        while (rowSet.next()) {
            ItemInfo item = new ItemInfo();
            item.put("FID", rowSet.getString("id"));
            item.put("FNAME", rowSet.getString("name"));
            item.put("FNUMBER", rowSet.getString("number"));
            item.put("AsstActType_ID", type.getId().toString());
            map.put(item.get("FID"), item);
        }
        return map;
    }

    private IObjectCollection _getCustomerItems(Context ctx, ArrayList p) throws BOSException, SQLException, EASBizException, UuidException {
        HashMap<Object, ItemInfo> resultSet = null;
        if (p.size() == 0) {
            return null;
        }
        Object[] tempData = (Object[])p.get(0);
        AsstActTypeInfo tempAsstActTypeInfo = (AsstActTypeInfo)tempData[0];
        IObjectPK companyPK = (IObjectPK)tempAsstActTypeInfo.get("CompanyUuid");
        String ctrlUnitPK = null;
        String companyid = null;
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        companyid = companyPK == null ? ContextUtils.getCurrentCompany((Context)ctx) : companyPK.toString();
        if (companyPK != null) {
            ICompanyOrgUnit icompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            try {
                companyOrgUnitInfo = icompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyid)));
            }
            catch (EASBizException e) {
                log.debug((Object)e.getMessage());
            }
            catch (BOSException e) {
                log.debug((Object)e.getMessage());
            }
            catch (UuidException e) {
                log.debug((Object)e.getMessage());
            }
        }
        if (companyOrgUnitInfo != null && companyOrgUnitInfo.getCU() != null && companyOrgUnitInfo.getCU().getId() != null) {
            ctrlUnitPK = companyOrgUnitInfo.getCU().getId().toString();
        }
        for (int i = 0; i < p.size(); ++i) {
            Object[] data = (Object[])p.get(i);
            AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)data[0];
            CSSPGroupStandardInfo stand = (CSSPGroupStandardInfo)data[1];
            CSSPGroupInfo csspGroupInfo = (CSSPGroupInfo)data[2];
            HashMap map = this.getCustomers(ctx, asstActTypeInfo, stand, csspGroupInfo, ctrlUnitPK);
            if (i == 0) {
                resultSet = map;
                continue;
            }
            if (resultSet == null) continue;
            HashMap<Object, ItemInfo> newMap = new HashMap<Object, ItemInfo>();
            for (ItemInfo item : resultSet.values()) {
                if (map.get(item.get("FID")) == null) continue;
                newMap.put(item.get("FID"), item);
            }
            resultSet = newMap;
        }
        ObjectBaseCollection c = new ObjectBaseCollection();
        if (resultSet != null) {
            Iterator it = resultSet.values().iterator();
            while (it.hasNext()) {
                c.add((ObjectBaseInfo)((ItemInfo)((Object)it.next())));
            }
        }
        return c;
    }

    private HashMap getCustomers(Context ctx, AsstActTypeInfo type, CSSPGroupStandardInfo stand, CSSPGroupInfo group, String cuid) throws BOSException, SQLException, EASBizException, UuidException {
        HashMap<Object, ItemInfo> map = new HashMap<Object, ItemInfo>();
        MetaDataPK metaDataPK = new MetaDataPK("com.kingdee.eas.basedata.master.cssp.app", "F7CustomerQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metaDataPK);
        EntityViewInfo mainQuery = new EntityViewInfo();
        mainQuery.getSelector().add(new SelectorItemInfo("id"));
        mainQuery.getSelector().add(new SelectorItemInfo("number"));
        mainQuery.getSelector().add(new SelectorItemInfo("name"));
        FilterInfo filter = CustomerFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)cuid)), "id", "adminCU.id");
        mainQuery.setFilter(filter);
        int oldsize = filter.getFilterItems().size();
        String mask = filter.getMaskString();
        filter.getFilterItems().add(new FilterItemInfo("customerGroupDetails.customerGroupStandard.id", (Object)stand.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("customerGroupDetails.customerGroup.id", (Object)group.getId().toString()));
        if (!StringUtils.isEmpty((String)mask)) {
            StringBuffer buf = new StringBuffer();
            buf.append("(" + mask + ")");
            buf.append(" AND #" + oldsize);
            buf.append(" AND #" + (oldsize + 1));
            filter.setMaskString(buf.toString());
        }
        exec.setObjectView(mainQuery);
        IRowSet rowSet = exec.executeQuery();
        while (rowSet.next()) {
            ItemInfo item = new ItemInfo();
            item.put("FID", rowSet.getString("id"));
            item.put("FNAME", rowSet.getString("name"));
            item.put("FNUMBER", rowSet.getString("number"));
            item.put("AsstActType_ID", type.getId().toString());
            map.put(item.get("FID"), item);
        }
        return map;
    }

    private IObjectCollection getCustomerItems(Context ctx, ArrayList p) throws BOSException {
        int i;
        String language = "_" + ctx.getLocale().getLanguage().toUpperCase();
        if (p.size() == 0) {
            return null;
        }
        if (p.size() == 1) {
            Object[] data = (Object[])p.get(0);
            ObjectBaseCollection cc1 = new ObjectBaseCollection();
            cc1.add((ObjectBaseInfo)((AsstActTypeInfo)data[0]));
            cc1.add((ObjectBaseInfo)((CSSPGroupInfo)data[2]));
            return InitDataFacadaFactory.getLocalInstance(ctx).getSortedItem((IObjectCollection)cc1);
        }
        ArrayList<String> sqlList = new ArrayList<String>();
        Object[] tempData = (Object[])p.get(0);
        AsstActTypeInfo tempAsstActTypeInfo = (AsstActTypeInfo)tempData[0];
        IObjectPK companyPK = (IObjectPK)tempAsstActTypeInfo.get("CompanyUuid");
        String SOSObjectType = null;
        String likeNumber = null;
        String companyid = null;
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        companyid = companyPK == null ? ContextUtils.getCurrentCompany((Context)ctx) : companyPK.toString();
        if (companyPK != null) {
            ICompanyOrgUnit icompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            try {
                companyOrgUnitInfo = icompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyid)));
            }
            catch (EASBizException e) {
                log.debug((Object)e.getMessage());
            }
            catch (BOSException e) {
                log.debug((Object)e.getMessage());
            }
            catch (UuidException e) {
                log.debug((Object)e.getMessage());
            }
        }
        SOSObjectType = "36F80EBE";
        for (int i2 = 0; i2 < p.size(); ++i2) {
            Object[] data = (Object[])p.get(i2);
            CSSPGroupInfo csspGroupInfo = (CSSPGroupInfo)data[2];
            likeNumber = csspGroupInfo.getLongNumber().toString();
            String sqlLine = "(" + this.generateSQL(ctx, likeNumber, SOSObjectType, companyOrgUnitInfo, "T_BD_Customer", "FCustomerID", "FCustomerGroupID") + ")";
            sqlList.add(sqlLine);
        }
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("SELECT t0.FID ,t0.FNAME" + language + ",t0.FNUMBER  FROM   ");
        for (i = 0; i < p.size(); ++i) {
            if (i > 0) {
                sqlBuf.append(" , ");
            }
            sqlBuf.append(sqlList.get(0).toString() + " AS t" + i);
        }
        sqlBuf.append(" WHERE ");
        for (i = 1; i < p.size(); ++i) {
            if (i > 1) {
                sqlBuf.append(" AND ");
            }
            sqlBuf.append(" t" + (i - 1) + ".FID=t" + i + ".FID");
        }
        ObjectBaseCollection c = new ObjectBaseCollection();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuf.toString());
        Object[] data = (Object[])p.get(0);
        AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)data[0];
        try {
            while (rs.next()) {
                ItemInfo item = new ItemInfo();
                item.put("FID", rs.getString("FID"));
                item.put("FNAME", rs.getString("FNAME" + language));
                item.put("FNUMBER", rs.getString("FNUMBER"));
                item.put("AsstActType_ID", asstActTypeInfo.getId().toString());
                c.add((ObjectBaseInfo)item);
            }
        }
        catch (SQLException e) {
            log.debug((Object)e.getMessage());
        }
        return c;
    }

    private IObjectCollection getSuplierItems(Context ctx, ArrayList p) throws BOSException {
        int i;
        String language = "_" + ctx.getLocale().getLanguage().toUpperCase();
        if (p.size() == 0) {
            return null;
        }
        if (p.size() == 1) {
            Object[] data = (Object[])p.get(0);
            ObjectBaseCollection cc1 = new ObjectBaseCollection();
            cc1.add((ObjectBaseInfo)((AsstActTypeInfo)data[0]));
            cc1.add((ObjectBaseInfo)((CSSPGroupInfo)data[2]));
            return InitDataFacadaFactory.getLocalInstance(ctx).getSortedItem((IObjectCollection)cc1);
        }
        ArrayList<String> sqlList = new ArrayList<String>();
        Object[] tempData = (Object[])p.get(0);
        AsstActTypeInfo tempAsstActTypeInfo = (AsstActTypeInfo)tempData[0];
        IObjectPK companyPK = (IObjectPK)tempAsstActTypeInfo.get("CompanyUuid");
        String SOSObjectType = null;
        String likeNumber = null;
        String companyid = null;
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        companyid = companyPK == null ? ContextUtils.getCurrentCompany((Context)ctx) : companyPK.toString();
        if (companyPK != null) {
            ICompanyOrgUnit icompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            try {
                companyOrgUnitInfo = icompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyid)));
            }
            catch (EASBizException e) {
                log.debug((Object)e.getMessage());
            }
            catch (BOSException e) {
                log.debug((Object)e.getMessage());
            }
            catch (UuidException e) {
                log.debug((Object)e.getMessage());
            }
        }
        SOSObjectType = "36F80EBE";
        for (int i2 = 0; i2 < p.size(); ++i2) {
            Object[] data = (Object[])p.get(i2);
            CSSPGroupInfo csspGroupInfo = (CSSPGroupInfo)data[2];
            likeNumber = csspGroupInfo.getLongNumber().toString();
            String sqlLine = "(" + this.generateSQL(ctx, likeNumber, SOSObjectType, companyOrgUnitInfo, "T_BD_Supplier", "FSupplierID", "FSupplierGroupID") + ")";
            sqlList.add(sqlLine);
        }
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("SELECT t0.FID ,t0.FNAME" + language + ",t0.FNUMBER  FROM   ");
        for (i = 0; i < p.size(); ++i) {
            if (i > 0) {
                sqlBuf.append(" , ");
            }
            sqlBuf.append(sqlList.get(0).toString() + " AS t" + i);
        }
        sqlBuf.append(" WHERE ");
        for (i = 1; i < p.size(); ++i) {
            if (i > 1) {
                sqlBuf.append(" AND ");
            }
            sqlBuf.append(" t" + (i - 1) + ".FID=t" + i + ".FID");
        }
        ObjectBaseCollection c = new ObjectBaseCollection();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuf.toString());
        Object[] data = (Object[])p.get(0);
        AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)data[0];
        try {
            while (rs.next()) {
                ItemInfo item = new ItemInfo();
                item.put("FID", rs.getString("FID"));
                item.put("FNAME", rs.getString("FNAME" + language + ""));
                item.put("FNUMBER", rs.getString("FNUMBER"));
                item.put("AsstActType_ID", asstActTypeInfo.getId().toString());
                c.add((ObjectBaseInfo)item);
            }
        }
        catch (SQLException e) {
            log.debug((Object)e.getMessage());
        }
        return c;
    }

    private String generateSQL(Context ctx, String likeNumber, String SOSObjectType, CompanyOrgUnitInfo companyOrgUnitInfo, String tableName, String FCustomerID, String FCustomerGroupID) {
        String language = "_" + ctx.getLocale().getLanguage().toUpperCase();
        StringBuffer buf = new StringBuffer();
        buf.append("SELECT " + tableName + ".FID , " + tableName + ".FNAME" + language + " , " + tableName + ".FNUMBER FROM " + tableName + " , " + tableName + "GroupDetail ,T_BD_CSSPGroup ");
        buf.append(" WHERE ");
        buf.append("(");
        buf.append(" " + tableName + ".FID=" + tableName + "GroupDetail." + FCustomerID + " AND " + tableName + "GroupDetail." + FCustomerGroupID + "=T_BD_CSSPGroup.FID AND ");
        buf.append("T_BD_CSSPGroup.FLongNumber like  ");
        buf.append("'" + likeNumber + "%'");
        buf.append(") ");
        buf.append(" AND ");
        buf.append("(");
        buf.append("" + tableName + ".FUsedStatus = 1 ");
        buf.append(" AND ");
        buf.append("(");
        buf.append("" + tableName + ".FAdminCUID = ");
        buf.append("'" + companyOrgUnitInfo.getCU().getId().toString() + "' ");
        buf.append(" OR ");
        buf.append("" + tableName + ".FID IN (SELECT FDataBaseDID FROM T_BD_DataBaseDAssign WHERE ");
        buf.append("(FBOSObjectType = '" + SOSObjectType + "' AND FAssignCUID = '" + companyOrgUnitInfo.getCU().getId().toString() + "')))");
        try {
            Set set = this.getVisibleOrgIDs(ctx, new BOSObjectType(SOSObjectType), (IObjectPK)new ObjectUuidPK(companyOrgUnitInfo.getCU().getId()));
            if (set != null && set.size() != 0) {
                buf.append(" OR ");
                buf.append("" + tableName + ".FAdminCUID IN (");
                Iterator it = set.iterator();
                int index = 0;
                while (it.hasNext()) {
                    if (index >= 1) {
                        buf.append(" , ");
                    }
                    buf.append("'");
                    buf.append(it.next().toString());
                    buf.append("'");
                    ++index;
                }
                buf.append(")");
            }
        }
        catch (EASBizException e) {
            log.debug((Object)e.getMessage());
        }
        catch (BOSException e) {
            log.debug((Object)e.getMessage());
        }
        buf.append(")");
        return buf.toString();
    }

    private IObjectCollection getOtherItems(Context ctx, ArrayList p) throws BOSException, EASBizException {
        ObjectBaseCollection c = new ObjectBaseCollection();
        for (int i = 0; i < p.size(); ++i) {
            Object[] data;
            AsstActTypeInfo asstActTypeInfo;
            List list;
            if (p.get(i) == null || (list = this._getItemUseType(ctx, asstActTypeInfo = (AsstActTypeInfo)(data = (Object[])p.get(i))[0], (IObjectPK)((ObjectUuidPK)asstActTypeInfo.get("CompanyUuid")))) == null) continue;
            for (String[] valueObject : list) {
                ItemInfo item = new ItemInfo();
                item.put("FID", valueObject[0]);
                item.put("FNUMBER", valueObject[1]);
                item.put("FNAME", valueObject[2]);
                item.put("AsstActType_ID", asstActTypeInfo.getId().toString());
                c.add((ObjectBaseInfo)item);
            }
        }
        return c;
    }

    private Set getVisibleOrgIDs(Context ctx, BOSObjectType objectType, IObjectPK ctrlUnitPK) throws EASBizException, BOSException {
        HashSet<String> set = new HashSet<String>();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("level"));
        CtrlUnitInfo cui = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo(ctrlUnitPK, sic);
        String longNumber = cui.getLongNumber();
        int level = cui.getLevel();
        StringBuffer sql = new StringBuffer(500);
        sql.append("select cu.FID,cu.FLevel,cu.FParentID from T_ORG_CtrlUnit cu inner join T_ORG_CUBDControl bd ").append("on bd.FControlUnitID=cu.FID ").append("where bd.FIsSuperiorViewable=1 and cu.FLongNumber like ? and bd.FBDBOSType=? ").append("order by cu.FLevel asc");
        Object[] params = new String[]{longNumber + "!%", objectType.toString()};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        int baselevel = -1;
        int currentlevel = -1;
        String ctrlUnitID = "";
        String parentCtrlUnitID = "";
        try {
            while (rs.next()) {
                currentlevel = rs.getInt("FLevel");
                ctrlUnitID = rs.getString("FID").trim();
                parentCtrlUnitID = rs.getString("FParentID");
                if (baselevel == -1) {
                    if (currentlevel != level + 1) break;
                    baselevel = currentlevel;
                }
                if (currentlevel == baselevel) {
                    set.add(ctrlUnitID);
                    continue;
                }
                if (StringUtils.isEmpty((String)parentCtrlUnitID) || !set.contains(parentCtrlUnitID.trim())) continue;
                set.add(ctrlUnitID);
            }
        }
        catch (SQLException e) {
            throw new DataBaseDException(DataBaseDException.GET_FILTER_FAIL, (Throwable)e);
        }
        StringBuffer debuginfo = new StringBuffer();
        Object[] array = set.toArray();
        int size = array.length;
        for (int i = 0; i < size; ++i) {
            debuginfo.append(array[i].toString() + ",");
        }
        return set;
    }

    @Override
    protected boolean _isDiscretePermItem(Context ctx, String bosType) throws BOSException {
        Set permItems = (Set)ConfigurationLoader.getInstance().getConfigurationInfo().getDiscretEntityPermItems().get(bosType);
        return permItems != null;
    }

    @Override
    protected ArrayList _getAcctType(Context ctx, CompanyOrgUnitInfo company, AccountViewInfo account) throws BOSException, EASBizException {
        String language = "_" + ctx.getLocale().getLanguage().toUpperCase();
        StringBuffer sql = new StringBuffer();
        ArrayList<AsstActTypeInfo> list = new ArrayList<AsstActTypeInfo>();
        list.add(null);
        sql.append(" SELECT  ASSTACTTYPE.* ");
        sql.append(" FROM T_BD_AccountView AS ACCOUNTVIEW ");
        sql.append(" INNER JOIN T_BD_AsstAccount AS CAA ON ACCOUNTVIEW.FCAA = CAA.FID ");
        sql.append(" INNER JOIN T_BD_AsstActGroupDetail AS ASSTACTGROUPDETAIL ON CAA.FID = ASSTACTGROUPDETAIL.FAsstAccountID  ");
        sql.append(" INNER JOIN T_BD_AsstActType AS ASSTACTTYPE ON ASSTACTGROUPDETAIL.FAsstActTypeID = ASSTACTTYPE.FID ");
        sql.append(" WHERE ACCOUNTVIEW.FID=?");
        Object[] params = new String[]{account.getId().toString()};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        try {
            while (rs.next()) {
                AsstActTypeInfo info = new AsstActTypeInfo();
                info.setId(BOSUuid.read((String)rs.getString("FID")));
                info.setNumber(rs.getString("FNUMBER"));
                info.setName(rs.getString("FNAME" + language));
                info.setDefaultQueryName(rs.getString("fdefaultqueryname"));
                info.setAsstHGAttribute(rs.getString("fassthgattribute"));
                info.setGroupMappingFieldName(rs.getString("FGroupMappingFieldName"));
                info.setRealtionDataObject(rs.getString("frealtiondataobject"));
                info.setIsForCompany(rs.getBoolean("fisforcompany"));
                String gid = rs.getString("FGLAsstActTypeGrpID");
                if (gid == null) {
                    info.setGlAsstActTypeGrp(null);
                } else {
                    GeneralAsstActTypeGroupInfo g = new GeneralAsstActTypeGroupInfo();
                    g.setId(BOSUuid.read((String)gid));
                    info.setGlAsstActTypeGrp(g);
                }
                info.setGroupTableName(rs.getString("FGroupTableName"));
                info.setGroupMappingFieldName(rs.getString("FGroupMappingFieldName"));
                info.setDefaultF7UI(rs.getString("FDefaultF7UI"));
                list.add(info);
            }
        }
        catch (SQLException e) {
            log.debug((Object)e.getMessage());
            throw new ReportException(ReportException.FITCHDATA_ERROR);
        }
        return list;
    }

    @Override
    protected void _kdf2kdsUpgrade(Context ctx, List idlist) throws BOSException, EASBizException {
        for (int i = 0; i < idlist.size(); ++i) {
            String id = idlist.get(i).toString();
            BOSObjectType bostype = BOSUuid.getBOSObjectType((String)id, (boolean)true);
            ICoreBase ibiz = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bostype);
            CoreBaseInfo value = ibiz.getValue("select data where id='" + id + "'");
            byte[] bin = (byte[])value.get("data");
            if (bin == null || bin.length <= 17) continue;
            try {
                String magic_str = new String(bin, 0, 17);
                if (!magic_str.equalsIgnoreCase("###PACKER4.0.1###")) continue;
                this.backup(bin, id);
                Book book = IOHelper.unpackBook(bin, "rpt_trans");
                bin = IOHelper.packBook(book);
                value.setBytes("data", bin);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("data");
                ibiz.updatePartial(value, sic);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backup(byte[] data, String id) {
        File path = new File("Report_Upgrade_Backup");
        if (path.exists() && !path.isDirectory()) {
            path.delete();
        }
        if (!path.exists()) {
            path.mkdir();
        }
        File f = new File(path.getAbsolutePath() + File.separator + this.formatUuid(id) + ".bin");
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(f, false);
            out.write(data);
            out.flush();
        }
        catch (Exception exception) {
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String formatUuid(String id) {
        if (id == null || id.length() == 0) {
            return id;
        }
        if (id.length() == 44 || id.length() == 40) {
            Uuid uuid = Uuid.read((String)id.substring(0, 36));
            String type = id.substring(36).intern();
            return uuid.toString() + type;
        }
        if (id.length() == 28) {
            byte[] array = Base64Encoder.base64ToByteArray((String)id);
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(array));
            try {
                Uuid uuid = Uuid.read((DataInput)in);
                BOSObjectType type = BOSObjectType.read((DataInput)in);
                return uuid.toString() + type;
            }
            catch (IOException ioe) {
                throw new UuidException((Throwable)ioe);
            }
        }
        throw new IllegalArgumentException("the arguemtn 'id' is invalid. '" + id + "'");
    }

    @Override
    protected ArrayList _getItemDateBaseInfo(Context ctx, String table, String from_to) throws BOSException, EASBizException {
        ArrayList list = new ArrayList();
        HashMap<String, CustomerInfo> map = new HashMap<String, CustomerInfo>();
        String from = null;
        String to = null;
        if (from_to.indexOf(":") != -1) {
            StringTokenizer st = new StringTokenizer(from_to, ":");
            from = st.nextToken();
            to = st.nextToken();
        } else {
            from = from_to;
            to = from_to;
        }
        String sql = "select * from " + table + " where fnumber='" + from + "' or fnumber='" + to + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            boolean hasLongnumber = false;
            for (int i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
                if (!rs.getMetaData().getColumnLabel(i + 1).equalsIgnoreCase("flongnumber")) continue;
                hasLongnumber = true;
                break;
            }
            while (rs.next()) {
                CustomerInfo info = new CustomerInfo();
                info.setId(BOSUuid.read((String)rs.getString("fid")));
                info.setNumber(rs.getString("fnumber"));
                if (hasLongnumber) {
                    info.put("longnumber", (Object)rs.getString("flongnumber"));
                }
                map.put(rs.getString("fnumber"), info);
            }
        }
        catch (SQLException e) {
            log.debug((Object)e.getMessage());
        }
        list.add(map.get(from));
        list.add(map.get(to));
        return list;
    }

    @Override
    protected Map _initReportList(Context ctx, Map params) throws BOSException, EASBizException {
        boolean isNotLinkGL;
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        result.put("CurrencyNoGLC", this.getCurrencyNoGLC(ctx));
        result.put("Fiscal", this.getFiscal(ctx));
        boolean bl = params == null ? false : (isNotLinkGL = params.containsKey("NOT_LINK_GL"));
        if (!isNotLinkGL) {
            result.put("CurrentFiscal", this.getCurrentFiscal(ctx));
        } else {
            PeriodInfo periodInfo = null;
            try {
                periodInfo = this.getCurrentFiscal(ctx);
            }
            catch (Exception e) {
                periodInfo = new PeriodInfo();
                int[] yearperiod = RPTDateUtil.getPeriod((Date)new Date(), (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY);
                periodInfo.setPeriodYear(yearperiod[0]);
                periodInfo.setPeriodNumber(yearperiod[1]);
            }
            result.put("CurrentFiscal", periodInfo);
        }
        return result;
    }

    private void getCurCUCostOrgs(Context ctx, String curOrgCU, ArrayList CostOrgIds) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer maskString = new StringBuffer("#0");
        filter.getFilterItems().add(new FilterItemInfo("cu", (Object)curOrgCU));
        filter.getFilterItems().add(new FilterItemInfo("iscostOrgUnit", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("isOUSealUp", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isAssistantOrg", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("partCostCenter.isSealUp", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isAdminOrgUnit", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("partAdmin.isVirtual", (Object)new Integer(0)));
        maskString.append(" and #1 and #2 and #3 and #4 and (#5 or #6)");
        filter.setMaskString(maskString.toString());
        ev.setSelector(sic);
        ev.setFilter(filter);
        FullOrgUnitCollection FullOrgUnitIds = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection(ev);
        String orgUnitId = null;
        for (int i = 0; i < FullOrgUnitIds.size(); ++i) {
            orgUnitId = FullOrgUnitIds.get(i).getId().toString();
            if (CostOrgIds.contains(orgUnitId)) continue;
            CostOrgIds.add(orgUnitId);
        }
    }

    private void getFromCostOrgs(Context ctx, String curOrgCU, ArrayList CostOrgIds) throws EASBizException, BOSException {
        OrgUnitCollection orgUnitRelationCollection = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getFromUnit(curOrgCU, 1, 5);
        if (orgUnitRelationCollection != null && orgUnitRelationCollection.size() > 0) {
            String orgUnitId = null;
            for (int i = 0; i < orgUnitRelationCollection.size(); ++i) {
                orgUnitId = orgUnitRelationCollection.get(i).getId().toString();
                if (CostOrgIds.contains(orgUnitId)) continue;
                CostOrgIds.add(orgUnitId);
            }
        }
    }
}

