/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ConvertStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.CyConvtSchmEntryFactory;
import com.kingdee.eas.fi.gr.cslrpt.CyConvtSchmEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.DebitOrCreditEnum;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.SysDataElementEnum;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.rpt.InitDataFacadaFactory;
import com.kingdee.eas.fi.rpt.ItemDataYearInitFactory;
import com.kingdee.eas.fi.rpt.ItemDataYearInitInfo;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.app.AbstractItemDataYearInitControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ItemDataYearInitControllerBean
extends AbstractItemDataYearInitControllerBean {
    @Override
    protected void _saveAll(Context ctx, ArrayList list) throws BOSException, EASBizException {
        for (ItemDataYearInitInfo info : list) {
            CslRptUtil.checkBigDecimalLength((BigDecimal)info.getCredit());
            CslRptUtil.checkBigDecimalLength((BigDecimal)info.getDebit());
            if (info.getId() == null) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("year", (Object)new Integer(info.getYear())));
                filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)info.getCurrency().getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("sourceCurrency.id", (Object)info.getSourceCurrency().getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("dataElement", (Object)new Integer(info.getDataElement().getValue())));
                filter.getFilterItems().add(new FilterItemInfo("item.id", (Object)info.getItem().getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("dataCollectNumber", (Object)info.getDataCollectNumber()));
                ItemDataYearInitFactory.getLocalInstance(ctx).delete(filter);
                ItemDataYearInitFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)info);
                continue;
            }
            if (info.getDebit() == null && info.getCredit() == null) {
                ItemDataYearInitFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(info.getId()));
                continue;
            }
            ItemDataYearInitFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
        }
    }

    HashMap getAllAllowedItem(Context ctx) throws BOSException {
        HashMap<String, CyConvtSchmEntryInfo> filtetMap = new HashMap<String, CyConvtSchmEntryInfo>();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getSelector().add(new SelectorItemInfo("item.*"));
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("convertMode", (Object)new Integer(3)));
        CoreBaseCollection collection = CyConvtSchmEntryFactory.getLocalInstance((Context)ctx).getCollection(view);
        if (collection != null && collection.size() > 0) {
            for (CyConvtSchmEntryInfo temp : collection) {
                if (filtetMap.get(temp.getItem().getId().toString()) != null) continue;
                filtetMap.put(temp.getItem().getNumber(), temp);
            }
        }
        return filtetMap;
    }

    @Override
    protected ArrayList _GetItemDataFromReport(Context ctx, String reportId) throws BOSException, EASBizException {
        ArrayList<Object> list = new ArrayList<Object>();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getSelector().add(new SelectorItemInfo("sourceCurrency.*"));
        view.getSelector().add(new SelectorItemInfo("company.*"));
        view.getSelector().add(new SelectorItemInfo("currency.*"));
        view.getSelector().add(new SelectorItemInfo("dataCollectNumber"));
        view.getSelector().add(new SelectorItemInfo("dataCollect.*"));
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)reportId));
        CoreBaseCollection c = ReportFactory.getLocalInstance(ctx).getCollection(view);
        if (c == null || c.size() == 0) {
            list.add(new Boolean(false));
            list.add(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"notEixt", (Locale)ctx.getLocale()));
            return list;
        }
        ReportInfo info = (ReportInfo)c.get(0);
        boolean isMergeByFiscalPeriod = FiscalPeriodHelper.isMergeByFiscalPeriod((Context)ctx);
        if (FiscalPeriodHelper.isMergeByFiscalPeriod((boolean)isMergeByFiscalPeriod, (RptPeriodTypeEnum)info.getPeriodType())) {
            boolean isGeneratePeriod = FiscalPeriodHelper.isGeneratePeriod((PeriodCollection)InitDataFacadaFactory.getLocalInstance(ctx).getFiscal(), (int)info.getYear(), (int)info.getPeriod(), (RptPeriodTypeEnum)info.getPeriodType(), (boolean)isMergeByFiscalPeriod);
            if (!isGeneratePeriod) {
                list.add(new Boolean(false));
                list.add(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"noLastPeriod", (Locale)ctx.getLocale()));
                return list;
            }
        } else {
            int period = 0;
            if (!info.getPeriodType().equals((Object)RptPeriodTypeEnum.MONTHLY)) {
                Date periodLastDate = RPTDateUtil.getPeriodLastDate((int)info.getYear(), (int)info.getPeriod(), (RptPeriodTypeEnum)info.getPeriodType());
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(periodLastDate);
                period = calendar.get(2) + 1;
            } else {
                period = info.getPeriod();
            }
            if (period < 12) {
                list.add(new Boolean(false));
                list.add(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"noLastPeriod", (Locale)ctx.getLocale()));
                return list;
            }
        }
        if (!ConvertStatusEnum.Converted.equals((Object)info.getConvertStatus())) {
            list.add(new Boolean(false));
            list.add(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"noCoverReport", (Locale)ctx.getLocale()));
            return list;
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("year", new Integer(info.getYear() + 1));
        map.put("currency", (Serializable)info.getCurrency());
        map.put("sourceCurrency", (Serializable)info.getSourceCurrency());
        map.put("rptPeriod", new Integer(info.getPeriod()));
        ArrayList<ItemDataYearInitInfo> infos = new ArrayList<ItemDataYearInitInfo>();
        map.put("infos", infos);
        try {
            HashMap allMap = this.getAllAllowedItem(ctx);
            Book book = info.getBook();
            for (int i = 0; i < book.getSheetCount(); ++i) {
                Sheet sheet = book.getSheet(i);
                Sheet.ICellsIterator it = sheet.getCellsIterator(0, 0, sheet.getMaxRowIndex(), sheet.getMaxColIndex(), true, true);
                while (it.hasNext()) {
                    Cell cell = it.next();
                    ItemFormula curFormula = (ItemFormula)sheet.getRange(cell).getUserObject("ITEM");
                    if (curFormula == null || curFormula.isDItem() || allMap.get(curFormula.getItemNumber()) == null || curFormula.getValueType() != 1 || !curFormula.getDataElementNumber().equals("ENDBALANCE") || curFormula.getYear() != info.getYear() || curFormula.getPeriod() != info.getPeriod()) continue;
                    ItemDataYearInitInfo itemDataIfo = new ItemDataYearInitInfo();
                    infos.add(itemDataIfo);
                    itemDataIfo.setCompany(info.getCompany());
                    itemDataIfo.setYear(info.getYear() + 1);
                    itemDataIfo.setCurrency(info.getCurrency());
                    itemDataIfo.setSourceCurrency(info.getSourceCurrency());
                    itemDataIfo.setDataElement(SysDataElementEnum.YTBEGIN);
                    itemDataIfo.setConvertStatus(ConvertStatusEnum.Converted);
                    itemDataIfo.setDataCollect(info.getDataCollect());
                    itemDataIfo.setDataCollectNumber(info.getDataCollectNumber());
                    itemDataIfo.setPeriod(info.getPeriod());
                    Variant v = cell.getValue();
                    EntityViewInfo itemView = new EntityViewInfo();
                    itemView.getSelector().add(new SelectorItemInfo("*"));
                    itemView.setFilter(new FilterInfo());
                    itemView.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)curFormula.getItemNumber()));
                    RPTItemCollection rptItem = RPTItemFactory.getLocalInstance((Context)ctx).getRPTItemCollection(itemView);
                    if (rptItem != null && rptItem.size() > 0) {
                        itemDataIfo.setItem(rptItem.get(0));
                    }
                    if (v == null || v.toString().trim().length() <= 0) continue;
                    try {
                        BigDecimal bd = new BigDecimal(v.toString());
                        if (itemDataIfo.getItem().getDc().equals((Object)DebitOrCreditEnum.CREDIT)) {
                            itemDataIfo.setCredit(bd);
                            continue;
                        }
                        itemDataIfo.setDebit(bd);
                    }
                    catch (Throwable throwable) {}
                }
            }
            Collections.sort(infos, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    if (arg0 == null && arg1 == null) {
                        return 0;
                    }
                    if (arg0 == null) {
                        return -1;
                    }
                    if (arg1 == null) {
                        return 1;
                    }
                    if (!(arg0 instanceof ItemDataYearInitInfo)) {
                        return -1;
                    }
                    if (!(arg1 instanceof ItemDataYearInitInfo)) {
                        return 1;
                    }
                    ItemDataYearInitInfo item1 = (ItemDataYearInitInfo)arg0;
                    ItemDataYearInitInfo item2 = (ItemDataYearInitInfo)arg1;
                    if (item1.getItem() == null) {
                        return -1;
                    }
                    if (item2.getItem() == null) {
                        return 1;
                    }
                    return item1.getItem().getNumber().compareTo(item2.getItem().getNumber());
                }
            });
        }
        catch (Exception e) {
            list.add(new Boolean(false));
            list.add(e.getMessage());
            return list;
        }
        list.add(new Boolean(true));
        list.add(map);
        return list;
    }

    @Override
    protected List _getTemplateByQuery(Context ctx, Map param) throws BOSException {
        if (param == null) {
            return null;
        }
        ArrayList<TemplateInfo> templateList = new ArrayList<TemplateInfo>();
        String queryText = (String)param.get("queryText");
        String entryViewIds = (String)param.get("entryViewIds");
        SQLBuilder sb = new SQLBuilder();
        sb.append("SELECT FID,FNumber,FName,FTemplateType,FPeriodType,FVersionNumber,FOrgType \n");
        sb.append("FROM T_RPT_Template \n");
        sb.append("WHERE FTemplateType IN (2, 6)  AND ");
        sb.append("F" + entryViewIds + " \n");
        sb.append(" AND (FName LIKE '%" + queryText + "%' OR FNumber LIKE '%" + queryText + "%') \n");
        sb.append("ORDER BY FTemplateType ASC,FPeriodType ASC,FNumber ASC, FVersionNumber ASC  \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.getSQL(), (Object[])sb.getParams());
        try {
            while (rs.next()) {
                TemplateInfo tmp = new TemplateInfo();
                tmp.setId(BOSUuid.read((String)rs.getString("FId")));
                tmp.setNumber(rs.getString("FNumber"));
                tmp.setName(rs.getString("FName"));
                tmp.setTemplateType(RptTmpTypeEnum.getEnum(rs.getInt("FTemplateType")));
                tmp.setPeriodType(RptPeriodTypeEnum.getEnum((int)rs.getInt("FPeriodtype")));
                tmp.setVersionNumber(rs.getString("FversionNumber"));
                tmp.setOrgType(OrgType.getEnum((int)rs.getInt("FOrgType")));
                templateList.add(tmp);
            }
        }
        catch (UuidException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (templateList.size() == 0) {
            return null;
        }
        return templateList;
    }
}

