/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorResultProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CashFlowDirection;
import com.kingdee.eas.basedata.assistant.CashFlowItemFactory;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountException;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.AcctStruct;
import com.kingdee.eas.fi.rpt.BalanceTypeEnum;
import com.kingdee.eas.fi.rpt.CashTypeEnum;
import com.kingdee.eas.fi.rpt.IBackfillHandler;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.ReportCaclProxy;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptAndTempException;
import com.kingdee.eas.fi.rpt.RptOrgRelaCollection;
import com.kingdee.eas.fi.rpt.RptOrgRelaInfo;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.VoucherGetTypeEnum;
import com.kingdee.eas.fi.rpt.app.AbstractReportCaclControllerBean;
import com.kingdee.eas.fi.rpt.app.AccountItem;
import com.kingdee.eas.fi.rpt.app.AcctCalculaterExt;
import com.kingdee.eas.fi.rpt.app.AcctExtCalculater;
import com.kingdee.eas.fi.rpt.app.GroupTreeNode;
import com.kingdee.eas.fi.rpt.app.RptCalculaterDAO;
import com.kingdee.eas.fi.rpt.app.RptContainer;
import com.kingdee.eas.fi.rpt.app.SheetContainer;
import com.kingdee.eas.fi.rpt.batch.AcctBatchCalculaterNew;
import com.kingdee.eas.fi.rpt.batch.FormulaValueBackfill;
import com.kingdee.eas.fi.rpt.util.AcctountAsstItemParser;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.RptUtilForServer;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class ReportCaclControllerBean
extends AbstractReportCaclControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.rpt.app.ReportCaclControllerBean");
    private static String accountTableID = null;
    static int index = 0;
    public static final String BASE_CURRENCY = "baseCurrency";
    public static final String REPORT_CURRENCY = "reportCurrency";

    @Override
    protected BigDecimal _acct(Context ctx, String fiOrgUnit, String acctItem, BalanceTypeEnum balanceType, int startYear, int startPeriod, int endYear, int endPeriod, String currency, boolean isInternalCompany, boolean isincludingUnPosted, boolean checkDataRight) throws BOSException, EASBizException {
        AcctStruct acct = new AcctStruct(fiOrgUnit, acctItem, balanceType, startYear, startPeriod, endYear, endPeriod, currency);
        acct.setIncludeVoucher(isincludingUnPosted);
        acct.setCheckDataRight(checkDataRight);
        AcctBatchCalculaterNew batcher = new AcctBatchCalculaterNew(ctx);
        try {
            batcher.init();
            batcher.initPermission(new ICalculateContextProvider(){

                public IErrorProvider getErrorProvider() {
                    return null;
                }

                public IErrorResultProvider getErrorResultProvider() {
                    return null;
                }

                public IReportPropertyAdapter getReportAdapter() {
                    return null;
                }

                public ReportVariables getReportVariables() {
                    ReportVariables rptVar = new ReportVariables();
                    rptVar.add(new VariableEntry("Check_Permissioin", null, 1, "false", false));
                    return rptVar;
                }

                public Context getServerContext() {
                    return null;
                }
            });
            Parameter param = new Parameter(null, null, false);
            FormulaValueBackfill var = new FormulaValueBackfill(param);
            AcctCalculaterExt acctext = new AcctCalculaterExt(acct, (IBackfillHandler)var);
            acctext.setContext(ctx);
            batcher.addFormula(acctext);
            batcher.isUseNewBatchLogic = true;
            DebugLogger.isDebug = false;
            batcher.setWhereSize(100);
            batcher.execute();
            if (var.getException() != null) {
                if (var.getException() instanceof ReportException) {
                    throw (ReportException)var.getException();
                }
                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{var.getException().getMessage()});
            }
            Object obj = var.getValue();
            if (obj instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)obj;
                return bigDecimal;
            }
            try {
                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{obj == null ? "ACCT" + ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"FetchDataError", (Locale)ctx.getOriginLocale()) : obj.toString()});
            }
            catch (SQLException e) {
                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{e.getMessage()});
            }
        }
        finally {
            try {
                batcher.clearUp();
            }
            catch (SQLException sQLException) {}
        }
    }

    private String getFormula(String strOldFormula) {
        if (StringUtils.isEmpty((String)strOldFormula)) {
            return null;
        }
        strOldFormula = strOldFormula.trim();
        String strNewFormula = "";
        String[] arrAcctItem = StringUtils.split((String)strOldFormula, (String)"|");
        for (int i = 0; i < arrAcctItem.length; ++i) {
            String strTmp = arrAcctItem[i].trim();
            if (!StringUtils.isEmpty((String)strTmp)) {
                strNewFormula = strNewFormula + strTmp + "|";
            }
            if (i != 2) continue;
            return strNewFormula;
        }
        return strOldFormula;
    }

    private void constructAcctItem(Context ctx, StringBuffer strSqlFromWhere, StringBuffer sqlWhere, StringBuffer strItemFilter, HashMap hmAcctItem, ArrayList alParams, boolean isOtherAccount) throws BOSException, EASBizException {
        strSqlFromWhere = strSqlFromWhere.append(",T_BD_AssistantHG A_Hg,T_GL_VoucherAssistRecord A_Record ");
        if (isOtherAccount) {
            sqlWhere.append(" and veB.fid = A_Record.FEntryID ");
        } else {
            sqlWhere.append(" and voucherEntry.fid = A_Record.FEntryID ");
        }
        strItemFilter.append(" and A_Record.FAssGrpID = A_Hg.fid ");
        ArrayList alParamsTmp = new ArrayList();
        StringBuffer strTmpSql = new StringBuffer("Select FNumber, FrealtionDataObject FtableName, FmappingFieldName FfieldName from T_BD_AsstActType where ");
        int i = 1;
        Set set = hmAcctItem.keySet();
        for (String strItemType : set) {
            if (i > 1) {
                strTmpSql = strTmpSql.append(" or ");
            }
            strTmpSql = strTmpSql.append(" upper(Fnumber) = '" + strItemType + "' ");
            ++i;
        }
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strTmpSql.toString(), (Object[])alParamsTmp.toArray());
            alParamsTmp.clear();
            int iRow = 0;
            while (rowSet.next()) {
                String strEnd;
                String[] hmTmp;
                String strStart;
                String strTableName = rowSet.getString("FtableName").toUpperCase();
                String strTableAlias = "A_AsstType" + ++iRow;
                String strFieldName = rowSet.getString("FfieldName");
                String strNumber = rowSet.getString("FNumber");
                strSqlFromWhere = strSqlFromWhere.append("," + strTableName + " " + strTableAlias);
                strItemFilter = strItemFilter.append(" and A_Hg." + strFieldName + "=" + strTableAlias + ".FID ");
                if (strNumber != null) {
                    strNumber = strNumber.toUpperCase();
                }
                if ((strStart = (hmTmp = (String[])hmAcctItem.get(strNumber))[0]).equals(strEnd = hmTmp[1])) {
                    strItemFilter = strItemFilter.append(" and upper(" + strTableAlias + ".FNumber) = '" + strStart + "' ");
                    continue;
                }
                if (strStart.length() > 0) {
                    strItemFilter = strItemFilter.append(" and upper(" + strTableAlias + ".FNumber) >= '" + strStart + "' ");
                }
                if (strEnd == null || strEnd.length() <= 0) continue;
                strItemFilter = strItemFilter.append(" and upper(" + strTableAlias + ".FNumber) <= '" + strEnd + "' ");
            }
            if (iRow == 0) {
                throw new ReportException(ReportException.ACCTITEMTYPE_NOT_FOUND);
            }
        }
        catch (SQLException e) {
            throw new ReportException(ReportException.CALC_ERROR, (Throwable)e);
        }
    }

    private HashMap parseAcctItem(String strAcctItem) {
        HashMap<String, String[]> hmResult = new HashMap<String, String[]>();
        String strItemType = null;
        String strItem = null;
        String strAcct = null;
        String strStartItem = null;
        String strEndItem = null;
        StringTokenizer arrAcctItem = new StringTokenizer(strAcctItem, "|");
        int i = 1;
        while (arrAcctItem.hasMoreTokens()) {
            String[] hmTmp;
            int iPos;
            if (1 == i) {
                strAcct = arrAcctItem.nextToken().trim();
                iPos = strAcct.indexOf(":");
                if (iPos >= 0) {
                    strStartItem = strAcct.substring(0, iPos).trim();
                    strEndItem = strAcct.substring(iPos + 1).trim();
                } else {
                    strStartItem = strAcct;
                    strEndItem = strAcct;
                }
                hmTmp = new String[]{strStartItem, strEndItem};
                hmResult.put("Account", hmTmp);
            } else if (i % 2 == 0) {
                strItemType = arrAcctItem.nextToken().trim();
                hmResult.put(strItemType, null);
            } else {
                strItem = arrAcctItem.nextToken().trim();
                if (strItem != null && strItem.length() > 0 && strItemType != null && strItemType.length() > 0) {
                    iPos = strItem.indexOf(":");
                    if (iPos >= 0) {
                        strStartItem = strItem.substring(0, iPos).trim();
                        strEndItem = strItem.substring(iPos + 1).trim();
                    } else {
                        strStartItem = strItem;
                        strEndItem = strItem;
                    }
                    hmTmp = new String[]{strStartItem, strEndItem};
                    hmResult.put(strItemType, hmTmp);
                }
            }
            ++i;
        }
        return hmResult;
    }

    @Override
    protected String _getCompany(Context ctx) throws BOSException {
        return "kingdee";
    }

    @Override
    protected String _getCurrency(Context ctx, String rptID) throws BOSException, EASBizException {
        IReport report = ReportFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = new ObjectUuidPK(rptID);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("currency"));
        sic.add(new SelectorItemInfo("currency.name"));
        ReportInfo reportInfo = report.getReportInfo((IObjectPK)pk, sic);
        if (reportInfo != null && reportInfo.getCurrency() != null) {
            return reportInfo.getCurrency().getName();
        }
        return null;
    }

    @Override
    protected String _getKeyword(Context ctx, String rptNumber, String SheetName, String keyword) throws BOSException {
        return "Key";
    }

    @Override
    protected String _getOrgName(Context ctx, String rptID, OrgType orgType) throws BOSException, EASBizException {
        IReport report = ReportFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = new ObjectUuidPK(rptID);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("orgRela.id"));
        sic.add(new SelectorItemInfo("orgRela.orgType"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.name"));
        logger.debug((Object)"our test  ");
        ReportInfo reportInfo = report.getReportInfo((IObjectPK)pk, sic);
        RptOrgRelaCollection orgColl = reportInfo.getOrgRela();
        Iterator iter = orgColl.iterator();
        RptOrgRelaInfo rptOrg = null;
        while (iter.hasNext()) {
            rptOrg = (RptOrgRelaInfo)iter.next();
            if (rptOrg.getOrgType() != orgType) continue;
            return rptOrg.getOrgUnit().getName();
        }
        return null;
    }

    @Override
    protected Date _getRptDate(Context ctx, String rptID) throws BOSException, EASBizException {
        ObjectUuidPK pk;
        IReport report = ReportFactory.getLocalInstance(ctx);
        ReportInfo reportInfo = report.getReportInfo((IObjectPK)(pk = new ObjectUuidPK(rptID)));
        if (reportInfo != null) {
            return reportInfo.getStartDate();
        }
        return null;
    }

    @Override
    protected String _getRptName(Context ctx, String rptID) throws BOSException, EASBizException {
        ObjectUuidPK pk;
        IReport report = ReportFactory.getLocalInstance(ctx);
        ReportInfo reportInfo = report.getReportInfo((IObjectPK)(pk = new ObjectUuidPK(rptID)));
        if (reportInfo != null) {
            return reportInfo.getName();
        }
        return null;
    }

    @Override
    protected BigDecimal _cacl(Context ctx, String caclFormular) throws BOSException, EASBizException {
        KDTable table = new KDTable();
        table.getScriptManager().addFunctionProvider((Object)new ReportCaclProxy(ctx));
        table.addRow();
        table.addColumn();
        table.getRow(0).getCell(0).setExpressions("=" + caclFormular);
        BigDecimal value = null;
        try {
            value = new BigDecimal(table.getRow(0).getCell(0).getValue().toString());
        }
        catch (ClassCastException e) {
            value = new BigDecimal("0");
        }
        return value;
    }

    @Override
    protected String _getStdCurrency(Context ctx, String rptID, String orgNumber) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)orgNumber)) {
            ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)orgNumber));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filter);
            viewInfo.getSelector().add(new SelectorItemInfo("id"));
            viewInfo.getSelector().add(new SelectorItemInfo("name"));
            viewInfo.getSelector().add(new SelectorItemInfo(BASE_CURRENCY));
            viewInfo.getSelector().add(new SelectorItemInfo("baseCurrency.name"));
            CompanyOrgUnitCollection companyColl = iCompany.getCompanyOrgUnitCollection(viewInfo);
            Iterator iterator = companyColl.iterator();
            if (iterator.hasNext()) {
                return ((CompanyOrgUnitInfo)iterator.next()).getBaseCurrency().getName();
            }
        }
        throw new ReportException(ReportException.FIND_COMPANY_ERROR);
    }

    @Override
    protected CurrencyInfo _getStdCurrency(Context ctx, String orgNumber) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)orgNumber)) {
            ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)orgNumber));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filter);
            viewInfo.getSelector().add(new SelectorItemInfo("id"));
            viewInfo.getSelector().add(new SelectorItemInfo("name"));
            viewInfo.getSelector().add(new SelectorItemInfo(BASE_CURRENCY));
            viewInfo.getSelector().add(new SelectorItemInfo("baseCurrency.name"));
            viewInfo.getSelector().add(new SelectorItemInfo("baseCurrency.number"));
            CompanyOrgUnitCollection companyColl = iCompany.getCompanyOrgUnitCollection(viewInfo);
            Iterator iterator = companyColl.iterator();
            if (iterator.hasNext()) {
                return ((CompanyOrgUnitInfo)iterator.next()).getBaseCurrency();
            }
        }
        throw new ReportException(ReportException.FIND_COMPANY_ERROR);
    }

    @Override
    protected BigDecimal _acctCash(Context ctx, String fiOrgUnit, CashTypeEnum cashTypeEnum, String currency, int intYear, int intYear2, int startPeriod, int endPeriod, String _strProjCode, boolean isincludingUnPosted) throws BOSException, EASBizException {
        return this._acctCash(ctx, fiOrgUnit, cashTypeEnum, currency, intYear, intYear2, startPeriod, endPeriod, _strProjCode, isincludingUnPosted, null);
    }

    protected BigDecimal _acctCash(Context ctx, String fiOrgUnit, CashTypeEnum cashTypeEnum, String currency, int intYear, int intYear2, int startPeriod, int endPeriod, String _strProjCode, boolean isincludingUnPosted, String acctItem) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)currency)) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"NeedCurrency", (Locale)ctx.getOriginLocale())});
        }
        if (StringUtils.isEmpty((String)_strProjCode)) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"NeedCashFlowItem", (Locale)ctx.getOriginLocale())});
        }
        if ((currency.equalsIgnoreCase("GLC") || currency.equalsIgnoreCase("GRC")) && (cashTypeEnum.equals((Object)CashTypeEnum.S) || cashTypeEnum.equals((Object)CashTypeEnum.Y) || cashTypeEnum.equals((Object)CashTypeEnum.Z))) {
            throw new ReportException(ReportException.CANNOT_CURRENCY);
        }
        if (cashTypeEnum.equals((Object)CashTypeEnum.AS) && !currency.equalsIgnoreCase("GRC")) {
            throw new ReportException(ReportException.ONLY_GRC);
        }
        if (cashTypeEnum.equals((Object)CashTypeEnum.AZ) && !currency.equalsIgnoreCase("GLC")) {
            throw new ReportException(ReportException.ONLY_GLC);
        }
        Project peoject = null;
        try {
            peoject = new Project(_strProjCode, ctx);
        }
        catch (Exception e1) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{e1.getMessage()});
        }
        CompanyOrgUnitInfo company = null;
        try {
            company = RptUtilForServer.getCompanyOrgUnitInfoByNumber(ctx, fiOrgUnit);
        }
        catch (BOSException e) {
            throw new ReportException(ReportException.FIND_COMPANY_ERROR, (Throwable)e);
        }
        RptCalculaterDAO dao = new RptCalculaterDAO(ctx);
        Map longNumber = dao.getGroupLongNumber(new String[]{peoject.projectCode}, "T_BD_CashFlowItem");
        if (longNumber.size() < 1 || longNumber.get(peoject.projectCode) == null) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"NotExistsCashFlowItem", (Locale)ctx.getOriginLocale()) + "\"" + peoject.projectCode + "\""});
        }
        GroupTreeNode node = (GroupTreeNode)longNumber.get(peoject.projectCode);
        BigDecimal retBigdec = new BigDecimal("0");
        StringBuffer sqlLast = new StringBuffer("");
        ArrayList<Object> aParml = new ArrayList<Object>();
        try {
            EntityViewInfo ev = new EntityViewInfo();
            ev.getSelector().add(new SelectorItemInfo("type"));
            ev.getSelector().add(new SelectorItemInfo("isLeaf"));
            ev.getSelector().add(new SelectorItemInfo("direction"));
            ev.getSelector().add(new SelectorItemInfo("isProfit"));
            ev.getSelector().add(new SelectorItemInfo("number"));
            ev.getSelector().add(new SelectorItemInfo("id"));
            ev.getSelector().add(new SelectorItemInfo("isEnable"));
            ev.setFilter(new FilterInfo());
            ev.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)peoject.projectCode));
            CoreBaseCollection c = CashFlowItemFactory.getLocalInstance((Context)ctx).getCollection(ev);
            boolean isLeaf = false;
            CashFlowDirection direction = null;
            int masterItem = -1;
            boolean isProfit = false;
            if (c == null || c.size() == 0) {
                throw new RptAndTempException(RptAndTempException.ITEMISNULL);
            }
            masterItem = ((CashFlowItemInfo)c.get(0)).getType().getValue();
            isLeaf = ((CashFlowItemInfo)c.get(0)).isIsLeaf();
            direction = ((CashFlowItemInfo)c.get(0)).getDirection();
            isProfit = ((CashFlowItemInfo)c.get(0)).isIsProfit();
            if (!company.isIsBizUnit() && masterItem != 0) {
                throw new RptAndTempException(RptAndTempException.NOTSUPPORTORG);
            }
            if (isProfit) {
                return this.getRetainedProfits(ctx, company, cashTypeEnum, currency, intYear, startPeriod, endPeriod, isincludingUnPosted);
            }
            sqlLast.append("select ").append(this.sqlSelProjId(masterItem, cashTypeEnum, currency, isLeaf, direction)).append(this.sqlFrom(masterItem, peoject)).append(" where Cash.FVoucherID = voucher.FID and voucher.FBizStatus <>0 and  voucher.FBizStatus <>2 ");
            if (!isincludingUnPosted) {
                sqlLast.append(" and voucher.FBizStatus=5");
            }
            if (intYear == intYear2) {
                sqlLast.append(" and period.FPeriodYear = ? ");
                aParml.add(new Integer(intYear));
                sqlLast.append(" and period.FPeriodNumber >=  ? ");
                aParml.add(new Integer(startPeriod));
                sqlLast.append(" and period.FPeriodNumber <=  ? ");
                aParml.add(new Integer(endPeriod));
            } else if (intYear < intYear2) {
                sqlLast.append(" and (  (period.FPeriodYear = ? and period.FPeriodNumber >=  ? )  or ");
                aParml.add(new Integer(intYear));
                aParml.add(new Integer(startPeriod));
                sqlLast.append("   ( period.FPeriodYear > ?  and period.FPeriodYear < ?  ) or ");
                aParml.add(new Integer(intYear));
                aParml.add(new Integer(intYear2));
                sqlLast.append(" (period.FPeriodYear = ? and period.FPeriodNumber <=  ? ) )");
                aParml.add(new Integer(intYear2));
                aParml.add(new Integer(endPeriod));
            } else {
                return new BigDecimal("0");
            }
            sqlLast.append(" and( UPPER(OrgUnit.FLongNumber) = ? ");
            aParml.add(company.getLongNumber().toUpperCase());
            sqlLast.append(" or UPPER(OrgUnit.FLongNumber) like ? )");
            aParml.add(company.getLongNumber().toUpperCase() + "!%");
            sqlLast.append(" and (CashItem.FLongNumber = ? ");
            aParml.add(node.longNumber);
            sqlLast.append(" or CashItem.FLongNumber like ?) ");
            aParml.add(node.longNumber + "!%");
            sqlLast.append(" and CashItem.FIsLeaf=1  ");
            if (!cashTypeEnum.equals((Object)CashTypeEnum.AS) && !cashTypeEnum.equals((Object)CashTypeEnum.AZ)) {
                sqlLast.append(" and UPPER(Currency.FNumber) = ? ");
                aParml.add(currency.toUpperCase());
            }
            if (peoject.items != null && peoject.items.size() > 0) {
                for (int i = 0; i < peoject.items.size(); ++i) {
                    Item item = (Item)peoject.items.get(i);
                    sqlLast.append(" and " + item.getWheteItem(aParml) + " ");
                }
            }
            IRowSet rowSetCashFlow = DbUtil.executeQuery((Context)ctx, (String)sqlLast.toString(), (Object[])aParml.toArray());
            while (rowSetCashFlow.next()) {
                retBigdec = rowSetCashFlow.getBigDecimal("cashValue");
            }
        }
        catch (SQLException se) {
            throw new ReportException(ReportException.CALC_ERROR, (Throwable)se);
        }
        if (retBigdec == null) {
            retBigdec = new BigDecimal("0.00000");
        }
        return retBigdec.setScale(RptUtil.getScaleByCyNumAtServer(ctx, currency), 4);
    }

    private BigDecimal getRetainedProfits(Context ctx, CompanyOrgUnitInfo company, CashTypeEnum cashTypeEnum, String currency, int intYear, int startPeriod, int endPeriod, boolean isincludingUnPosted) throws BOSException, EASBizException {
        BigDecimal bdReturn = null;
        StringBuffer sbSql = new StringBuffer("select ");
        if (cashTypeEnum.equals((Object)CashTypeEnum.Z) || cashTypeEnum.equals((Object)CashTypeEnum.AZ)) {
            sbSql.append(" sum(case ve.FEntryDC when 0 then ve.FLocalAmount else (-1) * FLocalAmount end) FAmount");
        } else if (cashTypeEnum.equals((Object)CashTypeEnum.S) || cashTypeEnum.equals((Object)CashTypeEnum.AS)) {
            sbSql.append(" sum(case ve.FEntryDC when 0 then ve.FReportingAmount else (-1) * FReportingAmount end) FAmount");
        } else {
            sbSql.append(" sum(case ve.FEntryDC when 0 then ve.FOriginalAmount else (-1) * FOriginalAmount end) FAmount");
        }
        sbSql.append(" from T_GL_Voucher voucher join T_GL_VoucherEntry ve on voucher.FID = ve.FBillID join T_BD_AccountView account on ve.FAccountID = account.FID left join t_bd_cashflowaccountdiff on fdiffaccountid=account.FID ").append(" inner join T_BD_Currency Currency on Currency.FID = ve.FCurrencyID");
        sbSql.append(" ,T_BD_Period period");
        sbSql.append(" where voucher.FCompanyID = ?");
        sbSql.append(" and fdiffaccountid is null");
        sbSql.append(" and account.FPLType <> ?");
        sbSql.append(" and voucher.FPeriodID = period.FID");
        sbSql.append(" and period.FPeriodYear >= ?");
        sbSql.append(" and period.FPeriodNumber >= ?");
        sbSql.append(" and period.FPeriodYear <= ?");
        sbSql.append(" and period.FPeriodNumber <= ?");
        if (!cashTypeEnum.equals((Object)CashTypeEnum.AS) && !cashTypeEnum.equals((Object)CashTypeEnum.AZ)) {
            sbSql.append(" and UPPER(Currency.FNumber) = ?  ");
        }
        sbSql.append(" and voucher.FSourceType<>1 ");
        sbSql.append(" and voucher.FBizStatus in(");
        sbSql.append(5);
        if (isincludingUnPosted) {
            sbSql.append(",");
            sbSql.append(1);
            sbSql.append(",");
            sbSql.append(3);
        }
        sbSql.append(")");
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sbSql.toString());
            int index = 1;
            ps.setString(index++, company.getId().toString());
            ps.setInt(index++, 0);
            ps.setInt(index++, intYear);
            ps.setInt(index++, startPeriod);
            ps.setInt(index++, intYear);
            ps.setInt(index++, endPeriod);
            if (!cashTypeEnum.equals((Object)CashTypeEnum.AS) && !cashTypeEnum.equals((Object)CashTypeEnum.AZ)) {
                ps.setString(index++, currency);
            }
            rs = ps.executeQuery();
            rs.next();
            bdReturn = rs.getBigDecimal("FAmount");
        }
        catch (SQLException se) {
            try {
                throw new BOSException((Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return bdReturn == null ? new BigDecimal(0.0) : bdReturn;
    }

    private String sqlSelProjId(int isPrimary, CashTypeEnum cashTypeEnum, String currency, boolean isLeaf, CashFlowDirection direction) throws ReportException {
        StringBuffer sqlSel = new StringBuffer("");
        if (isPrimary == 0) {
            if (isLeaf || !isLeaf && direction != CashFlowDirection.IN_OR_OUT) {
                sqlSel.append(" sum( " + this.getAmountPart(isPrimary, cashTypeEnum, currency) + ") cashValue");
            } else {
                sqlSel.append(" sum( " + this.getAmountPart(isPrimary, cashTypeEnum, currency) + " *(3-2*CashItem.FDirection)) cashValue");
            }
        } else {
            sqlSel.append(" sum( " + this.getAmountPart(isPrimary, cashTypeEnum, currency) + ") cashValue");
        }
        return sqlSel.toString();
    }

    private String getAmountPart(int isPrimary, CashTypeEnum cashTypeEnum, String currency) throws ReportException {
        String coeffient = "";
        if (isPrimary == 0) {
            coeffient = " Cash.FPrimaryCoeffient * ";
        } else if (isPrimary == 1) {
            coeffient = " Cash.FSupplementaryCoeffient * ";
        }
        if (cashTypeEnum.getValue() == 2) {
            return coeffient + "Cash.FOriginalAmount ";
        }
        if (cashTypeEnum.getValue() == 1 || cashTypeEnum.getValue() == 4) {
            return coeffient + "Cash.FLocalAmount ";
        }
        if (cashTypeEnum.getValue() == 3 || cashTypeEnum.getValue() == 5) {
            return coeffient + "Cash.FReportingAmount";
        }
        throw new ReportException(ReportException.EXECP_ACCTEXT_VOUTYPE_INVALID);
    }

    private String sqlFrom(int primary, Project project) {
        StringBuffer sql = new StringBuffer("");
        sql.append(" From T_GL_CashflowRecord Cash ").append(" inner join T_BD_CashFlowItem CashItem on CashItem.FID=");
        if (primary == 0) {
            sql.append(" Cash.FPrimaryItemID ");
        } else if (primary == 1) {
            sql.append(" Cash.FSupplementaryItemID ");
        } else {
            sql.append(" Cash.FFullInfoItemID ");
        }
        sql.append(" inner join T_GL_VoucherEntry ve on Cash.FEntryId = ve.FID").append(" inner join T_GL_Voucher voucher on voucher.FID = ve.FBillID").append(" inner join T_BD_Period period on period.FID = voucher.FPeriodID").append(" inner join T_Org_Company OrgUnit on OrgUnit.FID = voucher.FCompanyID").append(" inner join T_BD_Currency Currency on Currency.FID = ve.FCurrencyID");
        if (project.items != null && project.items.size() > 0) {
            sql.append(" left join t_bd_assistanthg c on Cash.fassgrpid=c.fid  ");
            for (int i = 0; i < project.items.size(); ++i) {
                Item item = (Item)project.items.get(i);
                sql.append(" left join " + item.table + " " + item.tableAis + " on " + item.tableAis + ".fid=c." + item.mapfield + " ");
            }
        }
        return sql.toString();
    }

    protected Boolean _acctExtCheck(Context ctx, String fiOrgUnit, String account, String opposingAccount, String userDefineFiter, VoucherGetTypeEnum vchGetType, String currency, String startDate, String endDate, boolean isincludingUnPosted, boolean checkDataRight) throws BOSException, EASBizException {
        Boolean isRight = false;
        if (vchGetType == null) {
            return isRight;
        }
        String vchGetTypeName = vchGetType.getName();
        if (vchGetTypeName.equalsIgnoreCase("JF") || vchGetTypeName.equalsIgnoreCase("DF") || vchGetTypeName.equalsIgnoreCase("TJF") || vchGetTypeName.equalsIgnoreCase("TDF") || vchGetTypeName.equalsIgnoreCase("ZJF") || vchGetTypeName.equalsIgnoreCase("ZDF") || vchGetTypeName.equalsIgnoreCase("AY") || vchGetTypeName.equalsIgnoreCase("TAY") || vchGetTypeName.equalsIgnoreCase("ZAY")) {
            if (!this.isRightDate(startDate)) {
                return isRight;
            }
            if (!this.isRightDate(endDate)) {
                return isRight;
            }
        }
        return isRight;
    }

    protected boolean isDate(String binDate, String endDate, String vchGetTypeName) {
        if (vchGetTypeName.equalsIgnoreCase("JF") || vchGetTypeName.equalsIgnoreCase("DF") || vchGetTypeName.equalsIgnoreCase("TJF") || vchGetTypeName.equalsIgnoreCase("TDF") || vchGetTypeName.equalsIgnoreCase("ZJF") || vchGetTypeName.equalsIgnoreCase("ZDF") || vchGetTypeName.equalsIgnoreCase("AY") || vchGetTypeName.equalsIgnoreCase("TAY") || vchGetTypeName.equalsIgnoreCase("ZAY")) {
            if (binDate == null || endDate == null || !this.isRightDate(binDate) || !this.isRightDate(endDate)) {
                return false;
            }
        } else if (vchGetTypeName.equalsIgnoreCase("C") || vchGetTypeName.equalsIgnoreCase("Y") || vchGetTypeName.equalsIgnoreCase("TC") || vchGetTypeName.equalsIgnoreCase("TY") || vchGetTypeName.equalsIgnoreCase("ZTC") || vchGetTypeName.equalsIgnoreCase("ZTY")) {
            if (endDate == null || !this.isRightDate(endDate)) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    protected boolean isRightDate(String thisDate) {
        if (thisDate == null) {
            return false;
        }
        if (thisDate.indexOf("-") != 4) {
            return false;
        }
        if (thisDate.indexOf("-", 5) != 7) {
            return false;
        }
        return thisDate.trim().length() == 10;
    }

    protected boolean isRightDate(String vchGetTypeName, String Cur) {
        return true;
    }

    @Override
    protected BigDecimal _acctExt(Context ctx, String fiOrgUnit, String account, String opposingAccount, String userDefineFiter, VoucherGetTypeEnum vchGetType, String currency, String sStartDate, String sEndDate, boolean isincludingUnPosted, boolean checkDataRight) throws BOSException, EASBizException {
        AcctExtCalculater calc = new AcctExtCalculater(ctx, fiOrgUnit, account, opposingAccount, userDefineFiter, vchGetType, currency, sStartDate, sEndDate, isincludingUnPosted, checkDataRight);
        return calc.calculate();
    }

    protected BigDecimal __acctExt(Context ctx, String fiOrgUnit, String account, String opposingAccount, String userDefineFiter, VoucherGetTypeEnum vchGetType, String currency, String sStartDate, String sEndDate, boolean isincludingUnPosted, boolean checkDataRight) throws BOSException, EASBizException {
        IRowSet rowSetFirst;
        CompanyOrgUnitInfo companyInfo;
        BigDecimal bdRetBalance = new BigDecimal("0");
        ArrayList alParams = new ArrayList();
        boolean isDouble = false;
        StringBuffer sqllast = new StringBuffer();
        String vchGetTypeName = vchGetType.getName();
        Date tmpDate = null;
        SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        GregorianCalendar endDate = new GregorianCalendar();
        GregorianCalendar startDate = new GregorianCalendar();
        if (StringUtils.isEmpty((String)account)) {
            throw new ReportException(ReportException.NOT_FOUND_ACCOUNT);
        }
        if (account != null) {
            account = account.toUpperCase();
        }
        if (opposingAccount != null) {
            opposingAccount = opposingAccount.toUpperCase();
        }
        if ((companyInfo = RptUtilForServer.getCompanyOrgUnitInfoByNumber(ctx, fiOrgUnit)) == null) {
            throw new EASBizException(ReportException.FIND_COMPANY_ERROR);
        }
        String companyID = companyInfo.getId().toString();
        AccountItem accountItem = new AccountItem(ctx, account, companyInfo);
        if (!accountItem.isSameLevel()) {
            throw new ReportException(ReportException.ACCTEXT_FORMULA_ERROR);
        }
        if (accountItem.itemSize() > 1) {
            throw new ReportException(ReportException.NOT_SUPPORT_FORMULA_PARAMETER);
        }
        if (StringUtils.isEmpty((String)sStartDate) || StringUtils.isEmpty((String)sEndDate)) {
            throw new ReportException(ReportException.EXECP_ACCTEXT_DATEERROR);
        }
        try {
            tmpDate = sDateFormat.parse(sStartDate);
            startDate.setTime(tmpDate);
            tmpDate = sDateFormat.parse(sEndDate);
            endDate.setTime(tmpDate);
        }
        catch (ParseException e) {
            throw new ReportException(ReportException.EXECP_ACCTEXT_DATEERROR, (Throwable)e);
        }
        if (RptUtil.findString(vchGetTypeName, ",JF,DF,TJF,TDF,ZJF,ZDF,QDF,QJF,")) {
            boolean bl = isDouble = !StringUtils.isEmpty((String)opposingAccount);
        }
        if (RptUtil.findString(vchGetTypeName, ",C,TC,ZTC,") && startDate != null) {
            startDate.add(5, -1);
            endDate = startDate;
        }
        if (RptUtil.findString(vchGetTypeName, ",C,Y,TC,TY,ZTC,ZTY,AY,TAY,ZAY,")) {
            PeriodCollection perColl = null;
            perColl = RptUtil.findString(vchGetTypeName, ",AY,TAY,ZAY,") ? RptUtilForServer.getPeriodByDateAtServer(ctx, startDate.getTime(), startDate.getTime(), companyInfo) : RptUtilForServer.getPeriodByDateAtServer(ctx, endDate.getTime(), endDate.getTime(), companyInfo);
            if (perColl == null) {
                throw new ReportException(ReportException.NOT_FOUND_PERIOD);
            }
            Iterator itPeriod = perColl.iterator();
            if (itPeriod.hasNext()) {
                BigDecimal bTemp = new BigDecimal("0");
                PeriodInfo periodInfo = (PeriodInfo)itPeriod.next();
                int prePeriod = periodInfo.getPeriodNumber();
                int preYear = periodInfo.getPeriodYear();
                if (RptUtil.findString(vchGetTypeName, ",C,TC,ZTC,")) {
                    PeriodInfo startPeriod = RptUtilForServer.getStartPeriodByCompany(ctx, companyID);
                    if (startPeriod == null) {
                        throw new ReportException(ReportException.NOT_FOUND_PERIOD);
                    }
                    int iStartPeriod = startPeriod.getPeriodNumber();
                    int iStartYear = startPeriod.getPeriodYear();
                    bTemp = preYear == iStartYear && prePeriod < iStartPeriod || preYear < iStartYear ? this.getBalanceByAcct(ctx, fiOrgUnit, account, vchGetType, iStartYear, iStartPeriod, iStartYear, iStartPeriod, currency, isincludingUnPosted, checkDataRight) : this.getBalanceByAcct(ctx, fiOrgUnit, account, vchGetType, startDate.get(1), prePeriod, startDate.get(1), prePeriod, currency, isincludingUnPosted, checkDataRight);
                } else {
                    bTemp = RptUtil.findString(vchGetTypeName, ",AY,TAY,ZAY,") && periodInfo.getBeginDate().before(startDate.getTime()) ? (RptUtil.findString(vchGetTypeName, ",AY,") ? this._acctExt(ctx, fiOrgUnit, account, "", "", VoucherGetTypeEnum.C, currency, sDateFormat.format(startDate.getTime()), sDateFormat.format(startDate.getTime()), isincludingUnPosted, checkDataRight) : (RptUtil.findString(vchGetTypeName, ",TAY,") ? this._acctExt(ctx, fiOrgUnit, account, "", "", VoucherGetTypeEnum.TC, currency, sDateFormat.format(startDate.getTime()), sDateFormat.format(startDate.getTime()), isincludingUnPosted, checkDataRight) : this._acctExt(ctx, fiOrgUnit, account, "", "", VoucherGetTypeEnum.ZTC, currency, sDateFormat.format(startDate.getTime()), sDateFormat.format(startDate.getTime()), isincludingUnPosted, checkDataRight))) : this.getBalanceByAcct(ctx, fiOrgUnit, account, vchGetType, startDate.get(1), prePeriod, startDate.get(1), prePeriod, currency, isincludingUnPosted, checkDataRight);
                }
                bdRetBalance = bdRetBalance.add(bTemp);
            }
        }
        StringBuffer sqlselect = this.constructSelect(account, opposingAccount, startDate, endDate, vchGetTypeName, currency, isDouble);
        StringBuffer sqlfrom = this.constructFrom(vchGetTypeName, isDouble);
        StringBuffer sqlWhere = this.constructWhere(fiOrgUnit, userDefineFiter, vchGetTypeName, currency, isDouble);
        StringBuffer sqlOtherWhere = this.constructOtherWhere(ctx, companyInfo, account, opposingAccount, startDate, endDate, vchGetTypeName, isDouble, isincludingUnPosted, sqlfrom, sqlWhere, alParams);
        sqllast.append(sqlselect);
        sqllast.append(sqlfrom);
        sqllast.append(sqlWhere);
        sqllast.append(sqlOtherWhere);
        if (RptUtil.findString(vchGetTypeName, ",AY,TAY,ZAY,")) {
            try {
                logger.debug((Object)sqllast);
                rowSetFirst = DbUtil.executeQuery((Context)ctx, (String)sqllast.toString(), (Object[])alParams.toArray());
                int i = 0;
                BigDecimal bdDayBalance = new BigDecimal("0");
                while (rowSetFirst.next()) {
                    BigDecimal bdRetVal = rowSetFirst.getBigDecimal("Value");
                    if (bdRetVal != null) {
                        bdDayBalance = bdDayBalance.add(bdRetVal);
                    }
                    ++i;
                }
                long dayNums = DateTimeUtils.dateDiff((String)"d", (Date)startDate.getTime(), (Date)endDate.getTime());
                bdDayBalance = bdDayBalance.divide(new BigDecimal(Long.toString(dayNums + 1L)), 10, 4);
                bdRetBalance = bdRetBalance.add(bdDayBalance);
            }
            catch (SQLException avgExec) {
                throw new ReportException(ReportException.CALC_ERROR, (Throwable)avgExec);
            }
        }
        if (RptUtil.findString(vchGetTypeName, ",JF,DF,TJF,TDF,ZJF,ZDF,C,Y,TC,TY,ZTC,ZTY,QDF,QJF,")) {
            try {
                logger.debug((Object)("[SQL:]" + sqllast.toString()));
                rowSetFirst = DbUtil.executeQuery((Context)ctx, (String)sqllast.toString(), (Object[])alParams.toArray());
                BigDecimal bdRetVal = new BigDecimal("0");
                BigDecimal bdSumVal = new BigDecimal("0");
                while (rowSetFirst.next()) {
                    bdRetVal = rowSetFirst.getBigDecimal("Value");
                    if (bdRetVal == null) {
                        bdRetVal = new BigDecimal("0");
                    }
                    bdSumVal = bdSumVal.add(bdRetVal);
                }
                bdRetBalance = RptUtil.findString(vchGetTypeName, ",C,Y,TC,TY,ZTC,ZTY,") ? bdRetBalance.add(bdSumVal) : bdSumVal;
            }
            catch (Exception balExec) {
                throw new ReportException(ReportException.CALC_ERROR, (Throwable)balExec);
            }
        }
        return bdRetBalance.setScale(RptUtil.getScaleByCyNumAtServer(ctx, currency), 4);
    }

    private void acctExt_ZTY(Context ctx, String fiOrgUnit, String account, String opposingAccount, String userDefineFiter, VoucherGetTypeEnum vchGetType, String currency, String sStartDate, String sEndDate, boolean isincludingUnPosted, boolean checkDataRight) {
        StringBuffer _sql = new StringBuffer("Select Out_Account.FDc*(Select");
        _sql.append("sum((case when voucherEntry.FLocalAmount < veB.FLocalAmount then voucherEntry.FLocalAmount*(voucherEntry.FEntryDC * 2 -1) else veB.FLocalAmount*(veB.FEntryDC * 2 -1) end ) ");
    }

    private StringBuffer constructSelect(String account, String opposingAccount, GregorianCalendar startDate, GregorianCalendar endDate, String vchGetTypeName, String currency, boolean isDoubleItem) throws EASBizException {
        SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        boolean isHaseAcctType = false;
        if (account != null && account.indexOf("|") > 0) {
            isHaseAcctType = true;
        }
        if (opposingAccount != null && opposingAccount.indexOf("|") > 0) {
            isHaseAcctType = true;
        }
        StringBuffer sqlSelInit = null;
        sqlSelInit = RptUtil.findString(vchGetTypeName, ",JF,DF,TJF,TDF,ZJF,ZDF,QJF,QDF,") ? new StringBuffer("Select ") : new StringBuffer("Select Out_Account.FDc*(Select ");
        if (RptUtil.findString(vchGetTypeName, ",QJF,QDF,")) {
            if (isDoubleItem) {
                if (isHaseAcctType) {
                    sqlSelInit.append(" sum(A_Record.FStandardQuantity) value");
                } else {
                    sqlSelInit.append(" sum(case when voucherEntry.FOriginalAmount <= veB.FOriginalAmount");
                    sqlSelInit.append(" then voucherEntry.FStandardQuantity");
                    sqlSelInit.append(" else veB.FOriginalAmount/voucherEntry.FOriginalAmount*voucherEntry.FStandardQuantity");
                    sqlSelInit.append(" end ) value");
                }
            } else if (isHaseAcctType) {
                sqlSelInit.append("sum(A_Record.FStandardQuantity) value ");
            } else {
                sqlSelInit.append("sum(voucherEntry.FStandardQuantity) value ");
            }
            return sqlSelInit;
        }
        if (RptUtil.findString(currency, ",GLC,GRC,")) {
            if (currency.equals("GLC")) {
                if (isDoubleItem) {
                    if (RptUtil.findString(vchGetTypeName, ",JF,DF,TJF,TDF,ZJF,ZDF,")) {
                        sqlSelInit.append("sum((case when voucherEntry.FLocalAmount < veB.FLocalAmount then voucherEntry.FLocalAmount else veB.FLocalAmount end ) ");
                    } else {
                        sqlSelInit.append("sum((case when voucherEntry.FLocalAmount < veB.FLocalAmount then voucherEntry.FLocalAmount*(voucherEntry.FEntryDC * 2 -1) else veB.FLocalAmount*(veB.FEntryDC * 2 -1) end ) ");
                    }
                } else if (isHaseAcctType) {
                    if (RptUtil.findString(vchGetTypeName, ",JF,DF,TJF,TDF,ZJF,ZDF,")) {
                        sqlSelInit.append("sum(A_Record.FLocalAmount ");
                    } else {
                        sqlSelInit.append("sum(A_Record.FLocalAmount*(voucherEntry.FEntryDC * 2 -1) ");
                    }
                } else if (RptUtil.findString(vchGetTypeName, ",JF,DF,TJF,TDF,ZJF,ZDF,")) {
                    sqlSelInit.append("sum(voucherEntry.FLocalAmount ");
                } else {
                    sqlSelInit.append("sum(voucherEntry.FLocalAmount*(voucherEntry.FEntryDC * 2 -1) ");
                }
            }
            if (currency.equals("GRC")) {
                if (isDoubleItem) {
                    if (RptUtil.findString(vchGetTypeName, ",JF,DF,TJF,TDF,ZJF,ZDF,")) {
                        sqlSelInit.append("sum((case when voucherEntry.FReportingAmount < veB.FReportingAmount then voucherEntry.FReportingAmount else veB.FReportingAmount end ) ");
                    } else {
                        sqlSelInit.append("sum((case when voucherEntry.FReportingAmount < veB.FReportingAmount then voucherEntry.FReportingAmount*(voucherEntry.FEntryDC * 2 -1) else veB.FReportingAmount*(veB.FEntryDC * 2 -1) end ) ");
                    }
                } else if (isHaseAcctType) {
                    if (RptUtil.findString(vchGetTypeName, ",JF,DF,TJF,TDF,ZJF,ZDF,")) {
                        sqlSelInit.append("sum(A_Record.FReportingAmount ");
                    } else {
                        sqlSelInit.append("sum(A_Record.FReportingAmount*(voucherEntry.FEntryDC * 2 -1) ");
                    }
                } else if (RptUtil.findString(vchGetTypeName, ",JF,DF,TJF,TDF,ZJF,ZDF,")) {
                    sqlSelInit.append("sum(voucherEntry.FReportingAmount ");
                } else {
                    sqlSelInit.append("sum(voucherEntry.FReportingAmount*(voucherEntry.FEntryDC * 2 -1) ");
                }
            }
            if (RptUtil.findString(vchGetTypeName, ",AY,TAY,ZAY,")) {
                if (isHaseAcctType) {
                    sqlSelInit.append(" * (1 + Datediff(dd,voucher.FBookedDate,{" + sDateFormat.format(endDate.getTime()) + "}))) value ");
                } else {
                    sqlSelInit.append(" * (1 + Datediff(dd,voucher.FBookedDate,{" + sDateFormat.format(endDate.getTime()) + "}))) value ");
                }
            } else {
                sqlSelInit.append(" ) value ");
            }
        } else {
            if (RptUtil.findString(vchGetTypeName, ",C,Y,")) {
                if (isHaseAcctType) {
                    sqlSelInit.append("sum(A_Record.FOriginalAmount * (voucherEntry.FEntryDC * 2 -1)) value ");
                } else {
                    sqlSelInit.append("sum(voucherEntry.FOriginalAmount * (voucherEntry.FEntryDC * 2 -1)) value ");
                }
            }
            if (RptUtil.findString(vchGetTypeName, ",TC,TY,")) {
                if (isHaseAcctType) {
                    sqlSelInit.append("sum(A_Record.FlocalAmount * (voucherEntry.FEntryDC * 2 -1)) value ");
                } else {
                    sqlSelInit.append("sum(voucherEntry.FlocalAmount * (voucherEntry.FEntryDC * 2 -1)) value ");
                }
            }
            if (RptUtil.findString(vchGetTypeName, ",ZTC,ZTY,")) {
                if (isHaseAcctType) {
                    sqlSelInit.append("sum(A_Record.FReportingAmount * (voucherEntry.FEntryDC * 2 -1)) value ");
                } else {
                    sqlSelInit.append("sum(voucherEntry.FReportingAmount * (voucherEntry.FEntryDC * 2 -1)) value ");
                }
            }
            if (RptUtil.findString(vchGetTypeName, ",AY,TAY,ZAY,")) {
                if (RptUtil.findString(vchGetTypeName, ",AY,")) {
                    if (isHaseAcctType) {
                        sqlSelInit.append("sum(A_Record.FOriginalAmount ");
                    } else {
                        sqlSelInit.append("sum(voucherEntry.FOriginalAmount ");
                    }
                }
                if (RptUtil.findString(vchGetTypeName, ",TAY,")) {
                    if (isHaseAcctType) {
                        sqlSelInit.append("sum(A_Record.FlocalAmount ");
                    } else {
                        sqlSelInit.append("sum(voucherEntry.FlocalAmount ");
                    }
                }
                if (RptUtil.findString(vchGetTypeName, ",ZAY,")) {
                    if (isHaseAcctType) {
                        sqlSelInit.append("sum(A_Record.FReportingAmount ");
                    } else {
                        sqlSelInit.append("sum(voucherEntry.FReportingAmount ");
                    }
                }
                if (isHaseAcctType) {
                    sqlSelInit.append("*( voucherEntry.FEntryDC * 2 -1) * (1 + Datediff(dd,voucher.FBookedDate,{" + sDateFormat.format(endDate.getTime()) + "}))) value ");
                } else {
                    sqlSelInit.append("*( voucherEntry.FEntryDC * 2 -1) * (1 + Datediff(dd,voucher.FBookedDate,{" + sDateFormat.format(endDate.getTime()) + "}))) value ");
                }
            }
            if (RptUtil.findString(vchGetTypeName, ",JF,DF,")) {
                if (isDoubleItem) {
                    if (isHaseAcctType) {
                        sqlSelInit.append("sum((case when A_Record.FOriginalAmount < veB.FOriginalAmount then voucherEntry.FOriginalAmount*A_Record.FOriginalAmount/veB.FOriginalAmount  else veB.FOriginalAmount end )) value ");
                    } else {
                        sqlSelInit.append("sum((case when voucherEntry.FOriginalAmount < veB.FOriginalAmount then voucherEntry.FOriginalAmount else veB.FOriginalAmount end )) value ");
                    }
                } else if (isHaseAcctType) {
                    sqlSelInit.append("sum(A_Record.FOriginalAmount) value ");
                } else {
                    sqlSelInit.append("sum(voucherEntry.FOriginalAmount) value ");
                }
            }
            if (RptUtil.findString(vchGetTypeName, ",TJF,TDF,")) {
                if (isDoubleItem) {
                    if (isHaseAcctType) {
                        sqlSelInit.append("sum((case when A_Record.FlocalAmount < veB.FlocalAmount then voucherEntry.FlocalAmount*A_Record.FlocalAmount/veB.FlocalAmount else veB.FlocalAmount end )) value ");
                    } else {
                        sqlSelInit.append("sum((case when voucherEntry.FlocalAmount < veB.FlocalAmount then voucherEntry.FlocalAmount else veB.FlocalAmount end )) value ");
                    }
                } else if (isHaseAcctType) {
                    sqlSelInit.append("sum(A_Record.FlocalAmount) value ");
                } else {
                    sqlSelInit.append("sum(voucherEntry.FlocalAmount) value ");
                }
            }
            if (RptUtil.findString(vchGetTypeName, ",ZJF,ZDF,")) {
                if (isDoubleItem) {
                    if (isHaseAcctType) {
                        sqlSelInit.append("sum((case when A_Record.FReportingAmount < veB.FReportingAmount then voucherEntry.FReportingAmount*A_Record.FReportingAmount/veB.FReportingAmount else veB.FReportingAmount end )) value ");
                    } else {
                        sqlSelInit.append("sum((case when voucherEntry.FReportingAmount < veB.FReportingAmount then voucherEntry.FReportingAmount else veB.FReportingAmount end )) value ");
                    }
                } else if (isHaseAcctType) {
                    sqlSelInit.append("sum(A_Record.FReportingAmount) value ");
                } else {
                    sqlSelInit.append("sum(voucherEntry.FReportingAmount) value ");
                }
            }
        }
        return sqlSelInit;
    }

    private StringBuffer constructFrom(String vchGetTypeName, boolean isDoubleItem) throws EASBizException {
        StringBuffer sqlFrom = new StringBuffer(" From T_BD_Currency Currency ,T_BD_AccountView A_Account ,T_GL_Voucher voucher ,T_GL_VoucherEntry voucherEntry ,T_Org_BaseUnit Company ");
        if (RptUtil.findString(vchGetTypeName, ",JF,DF,TJF,TDF,ZJF,ZDF,QDF,QJF,") && isDoubleItem) {
            sqlFrom.append(" ,T_GL_VoucherEntry veB ,T_BD_AccountView B_Account ");
        }
        return sqlFrom;
    }

    private StringBuffer constructWhere(String fiOrgUnit, String userDefineFilter, String vchGetTypeName, String currency, boolean isDoubleItem) throws EASBizException {
        StringBuffer sqlWhere = new StringBuffer(" where voucher.FCompanyID = company.fid and Company.Fnumber = '" + fiOrgUnit + "' and voucher.FID = voucherEntry.FBillID and voucherEntry.FCurrencyID = Currency.FID and voucherEntry.FAccountID = A_Account.Fid  and voucher.FBizStatus <>0 and voucher.FBizStatus <>2 ");
        if (!StringUtils.isEmpty((String)currency) && !RptUtil.findString(currency, ",GLC,GRC,")) {
            sqlWhere.append("and Currency.Fnumber='" + currency + "' ");
        }
        if (RptUtil.findString(vchGetTypeName, ",JF,DF,TJF,TDF,ZJF,ZDF,QDF,QJF,")) {
            if (!StringUtils.isEmpty((String)userDefineFilter)) {
                sqlWhere.append("and (" + userDefineFilter + ")");
            }
            if (RptUtil.findString(vchGetTypeName, ",JF,TJF,ZJF,")) {
                sqlWhere.append(" and voucherEntry.FEntryDC=1 ");
            }
            if (RptUtil.findString(vchGetTypeName, ",DF,TDF,ZDF,")) {
                sqlWhere.append(" and voucherEntry.FEntryDC=0 ");
            }
            if (RptUtil.findString(vchGetTypeName, ",QJF,")) {
                sqlWhere.append(" and voucherEntry.FEntryDC*2-1=A_Account.fdc ");
            }
            if (RptUtil.findString(vchGetTypeName, ",QDF,")) {
                sqlWhere.append(" and voucherEntry.FEntryDC*2-1!=A_Account.fdc ");
            }
            if (isDoubleItem) {
                sqlWhere.append("and veB.FAccountID = B_Account.Fid and veB.FBillId = voucherEntry.FBillId and veB.FCurrencyID = Currency.Fid and veB.FEntryDc <> voucherEntry.FEntryDc ");
            }
        }
        return sqlWhere;
    }

    private StringBuffer constructOtherWhere(Context ctx, CompanyOrgUnitInfo company, String acctItem, String anotherAcctItem, GregorianCalendar startDate, GregorianCalendar endDate, String vchGetTypeName, boolean isDoubleItem, boolean isincludingUnPosted, StringBuffer sqlFrom, StringBuffer sqlWhere, ArrayList alParams) throws BOSException, EASBizException {
        StringBuffer sqlWhereOther = new StringBuffer();
        Date startDate1 = startDate.getTime();
        Date endDate1 = endDate.getTime();
        SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (endDate != null && startDate != null) {
            try {
                if (RptUtil.findString(vchGetTypeName, ",JF,DF,TJF,TDF,ZJF,ZDF,QDF,QJF,")) {
                    sqlWhereOther.append(" and voucher.FBookedDate>={" + sDateFormat.format(startDate1) + "} ");
                }
                if (RptUtil.findString(vchGetTypeName, ",C,Y,TC,TY,ZTC,ZTY,")) {
                    PeriodCollection perColl = PeriodUtils.getPeriodCollection((Context)ctx, (Date)endDate.getTime(), (Date)endDate.getTime(), (CompanyOrgUnitInfo)company);
                    Iterator perCollIter = perColl.iterator();
                    if (perCollIter.hasNext()) {
                        PeriodInfo periodInfo = (PeriodInfo)perCollIter.next();
                        sqlWhereOther.append(" and voucher.FBookedDate >={" + periodInfo.getBeginDate().toString() + "}");
                    } else {
                        throw new ReportException(ReportException.ACCTEXT_NULL_PERIOD);
                    }
                }
                if (RptUtil.findString(vchGetTypeName, ",AY,TAY,ZAY,")) {
                    sqlWhereOther.append(" and voucher.FBookedDate >= {" + sDateFormat.format(startDate1) + "}");
                }
                sqlWhereOther.append(" and voucher.FBookedDate <= {" + sDateFormat.format(endDate1) + "}");
            }
            catch (Exception exc) {
                throw new ReportException(ReportException.EXECP_ACCTEXT_NOPERIOD, (Throwable)exc);
            }
        }
        if (RptUtil.findString(vchGetTypeName, ",JF,DF,TJF,TDF,ZJF,ZDF,QDF,QJF,")) {
            this.retItemCodeSqlNew(ctx, vchGetTypeName, "A_Account.Fnumber", acctItem, true, sqlFrom, sqlWhere, sqlWhere, alParams, false);
        } else {
            sqlWhereOther.append(" and charIndex(Out_Account.Fnumber,A_Account.Fnumber)=1 ");
        }
        if (RptUtil.findString(vchGetTypeName, ",JF,DF,TJF,TDF,ZJF,ZDF,QDF,QJF,") && isDoubleItem && !StringUtils.isEmpty((String)anotherAcctItem)) {
            this.retItemCodeSqlNew(ctx, vchGetTypeName, "B_Account.Fnumber", anotherAcctItem, true, sqlFrom, sqlWhere, sqlWhere, alParams, true);
        }
        if (!isincludingUnPosted) {
            sqlWhereOther.append(" and voucher.FBizStatus=5 ");
        }
        sqlWhereOther.append(" and A_Account.FIsLeaf = 1");
        if (RptUtil.findString(vchGetTypeName, ",JF,DF,TJF,TDF,ZJF,ZDF,QDF,QJF,") && isDoubleItem) {
            sqlWhereOther.append(" and B_Account.FIsLeaf = 1");
        }
        if (!RptUtil.findString(vchGetTypeName, ",JF,DF,TJF,TDF,ZJF,ZDF,QDF,QJF,")) {
            sqlWhereOther.append(") value From T_BD_AccountView Out_Account, T_Org_BaseUnit Out_Company");
            StringBuffer tempWhere = new StringBuffer(" Where Out_Account.FCompanyID = Out_Company.FID");
            this.retItemCodeSqlNew(ctx, vchGetTypeName, "Out_Account.Fnumber", acctItem, false, sqlFrom, sqlWhere, tempWhere, alParams, false);
            sqlWhereOther.append(tempWhere);
            sqlWhereOther.append(" and Out_Company.Fnumber = '" + company.getNumber() + "' ");
        }
        return sqlWhereOther;
    }

    private String retItemCodeSql(String strColName, String itemCodeS, boolean isLike) {
        StringBuffer sbSqlWhereItems = new StringBuffer();
        String[] assArrayTemp = new String[]{itemCodeS};
        if (itemCodeS.indexOf("|") > 0) {
            assArrayTemp = StringUtils.split((String)itemCodeS, (String)"|");
        }
        for (int i = 0; assArrayTemp.length > i; ++i) {
            sbSqlWhereItems.append(this.getBinEndSql(strColName, assArrayTemp[i], isLike));
        }
        return sbSqlWhereItems.toString();
    }

    private void retItemCodeSqlNew(Context ctx, String vchGetTypeName, String strColName, String itemCodes, boolean isLike, StringBuffer sqlfrom, StringBuffer sqlWhere, StringBuffer sqlOtherWhere, ArrayList alParams, boolean isOtherAccount) throws BOSException, EASBizException {
        String endAcctNumber;
        HashMap hmAcctItem = this.parseAcctItem(itemCodes);
        String[] strAcct = (String[])hmAcctItem.get("Account");
        String startAcctNumber = strAcct[0];
        if (startAcctNumber.equals(endAcctNumber = strAcct[1])) {
            if (isLike) {
                sqlOtherWhere.append(" and " + strColName + " like ?");
                alParams.add(startAcctNumber + "%");
            } else {
                sqlOtherWhere.append(" and " + strColName + " = ? ");
                alParams.add(startAcctNumber);
            }
        } else {
            if (startAcctNumber.length() > 0) {
                sqlOtherWhere.append(" and " + strColName + " >= ? ");
                alParams.add(startAcctNumber);
            }
            if (endAcctNumber != null && endAcctNumber.length() > 0) {
                sqlOtherWhere.append(" and " + strColName + " <= ? ");
                alParams.add(endAcctNumber + "z");
            }
        }
        hmAcctItem.remove("Account");
        if (hmAcctItem.size() > 0) {
            if (!RptUtil.findString(vchGetTypeName, ",JF,DF,TJF,TDF,ZJF,ZDF,QJF,QDF,")) {
                this.constructAcctItem(ctx, sqlfrom, sqlWhere, sqlWhere, hmAcctItem, alParams, isOtherAccount);
            } else {
                this.constructAcctItem(ctx, sqlfrom, sqlWhere, sqlOtherWhere, hmAcctItem, alParams, isOtherAccount);
            }
        }
    }

    private String getBinEndSql(String strCol, String itemStr, boolean isLike) {
        int i = itemStr.indexOf(":");
        int j = itemStr.length() - 1;
        StringBuffer sbBinEnd = new StringBuffer();
        if (i < 0) {
            if (isLike) {
                sbBinEnd.append(strCol + " like '" + itemStr + "%' ");
            } else {
                sbBinEnd.append(strCol + " = '" + itemStr + "' ");
            }
            return sbBinEnd.toString();
        }
        if (i == 0) {
            sbBinEnd.append(strCol + "<='" + itemStr.substring(1) + "'");
            return sbBinEnd.toString();
        }
        if (i == j) {
            sbBinEnd.append(strCol + ">='" + itemStr.substring(0, i) + "' ");
            return sbBinEnd.toString();
        }
        sbBinEnd.append(strCol + ">='" + itemStr.substring(0, i) + "' ");
        sbBinEnd.append(" and ");
        sbBinEnd.append(strCol + "<='" + itemStr.substring(i + 1) + "' ");
        return sbBinEnd.toString();
    }

    private BigDecimal getBalanceByAcct(Context ctx, String fiOrgUnit, String acctItem, VoucherGetTypeEnum vchGetType, int startYear, int startPeriod, int endYear, int endPeriod, String currency, boolean isincludingUnPosted, boolean checkDataRight) throws BOSException, EASBizException {
        BalanceTypeEnum balanceType = BalanceTypeEnum.C;
        String vchGetTypeName = vchGetType.getName();
        if (RptUtil.findString(vchGetTypeName, ",C,Y,AY,")) {
            balanceType = BalanceTypeEnum.C;
        }
        if (RptUtil.findString(vchGetTypeName, ",TC,TY,TAY,")) {
            balanceType = BalanceTypeEnum.TC;
        }
        if (RptUtil.findString(vchGetTypeName, ",ZTC,ZTY,ZAY,")) {
            balanceType = BalanceTypeEnum.RC;
        }
        return this._acct(ctx, fiOrgUnit, acctItem, balanceType, startYear, startPeriod, endYear, endPeriod, currency, false, isincludingUnPosted, checkDataRight);
    }

    @Override
    protected Object _ref(Context ctx, String rptCode, String orgCode, String sheetName, String cellName) throws BOSException, EASBizException {
        SheetContainer rpt = RptContainer.getInstance().getReport(ctx, rptCode, orgCode);
        if (rpt == null) {
            return null;
        }
        Object val = rpt.getCellValue(sheetName, cellName);
        return val;
    }

    @Override
    protected String _refm(Context ctx, String fiOrgUnit, int year, int period, String currency, String tempType, String tempCode, String groupTempType, String sheetName, String cellName, int periodType) throws BOSException, EASBizException {
        SheetContainer rpt = RptContainer.getInstance().getReportCollection(ctx, fiOrgUnit, year, period, currency, tempType, tempCode, groupTempType, periodType);
        if (rpt == null) {
            return null;
        }
        Object val = rpt.getSumCellValue(sheetName, cellName);
        return val == null ? null : val.toString();
    }

    @Override
    protected ArrayList _getAsstItems(Context ctx, String project) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("select distinct item.fid id,item.fnumber fnumber,item.fdefaultqueryname queryname, ").append("item.FDefaultF7UI queryui,item.frealtiondataobject tablename, item.FUseLongNumber useLongNumber, item.fassthgattribute propname, ").append("item.fmappingfieldname fieldname, item.FGLAsstActTypeGrpID groupID ,").append("item.fisforcompany isforcompany, item.FGroupTableName groupTable, ").append("item.FGroupMappingFieldName groupMappingField, item.fname_").append(loc).append(" name from T_BD_CashFlowItem account").append(" inner join T_BD_AsstAccount book on account.FAsstAccountID = book.fid").append(" inner join T_BD_AsstActGroupDetail rel on book.fid = rel.fasstaccountid").append(" inner join T_BD_AsstActType item on item.fid = rel.fasstacttypeid").append(" and account.fnumber=? ");
            ps = con.prepareStatement(sql.toString());
            ps.setString(1, project);
            rs = ps.executeQuery();
            while (rs.next()) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                String id = rs.getString("id");
                item.put("id", id);
                item.put("number", rs.getString("fnumber"));
                item.put("name", rs.getString("name"));
                item.put("queryname", rs.getString("queryname"));
                item.put("propname", rs.getString("propname"));
                item.put("fieldname", rs.getString("fieldname"));
                item.put("tablename", rs.getString("tablename"));
                item.put("useLongNumber", rs.getBoolean("useLongNumber"));
                item.put("isforcompany", rs.getString("isforcompany"));
                item.put("asstGroupID", rs.getString("groupID"));
                item.put("groupTable", rs.getString("groupTable"));
                item.put("groupMappingField", rs.getString("groupMappingField"));
                item.put("queryui", rs.getString("queryui"));
                result.add(item);
            }
        }
        catch (SQLException sqle) {
            try {
                throw new SQLAccessException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return result;
    }

    @Override
    protected HashMap _getAcctAsstItems(Context ctx, String accountFrom, String accountTo, String companyId) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        AccountViewCollection accounts = new AccountViewCollection();
        HashMap acctUnionItems = new HashMap();
        ArrayList acctUnionItemsList = new ArrayList();
        ArrayList allItem = new ArrayList();
        ObjectStringPK companyPK = new ObjectStringPK(companyId);
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)companyPK);
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        StringBuffer sql = null;
        try {
            con = this.getConnection(ctx);
            StringBuffer getAllAccountSql = new StringBuffer("select fid id,fnumber fnumber,fname_").append(loc).append(" name from T_bd_accountview account where fcaa is not null");
            getAllAccountSql.append(" and fcompanyid=? ");
            if (accountFrom != null && !accountFrom.equals("")) {
                getAllAccountSql.append(" and fnumber>= ? ");
            }
            if (accountTo != null && !accountTo.equals("")) {
                getAllAccountSql.append(" and (fnumber<= ? ");
                getAllAccountSql.append(" or fnumber like ? )");
            }
            getAllAccountSql.append(" and FAccountTableID = ? ");
            ps = con.prepareStatement(getAllAccountSql.toString());
            int index = 1;
            ps.setString(index++, companyId);
            if (accountFrom != null && !accountFrom.equals("")) {
                ps.setString(index++, accountFrom);
            }
            if (accountTo != null && !accountTo.equals("")) {
                ps.setString(index++, accountTo);
                ps.setString(index++, accountTo + "%");
            }
            if (!StringUtils.isEmpty((String)accountTableID)) {
                ps.setString(index++, accountTableID);
            } else {
                if (company.getAccountTable() == null) {
                    throw new AccountException(AccountException.CURRENTCOMPANYHASNOSTARTACCOUNTTABLE);
                }
                ps.setString(index++, company.getAccountTable().getId().toString());
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                AccountViewInfo account = new AccountViewInfo();
                account.put("id", (Object)rs.getString("id"));
                account.put("number", (Object)rs.getString("fnumber"));
                account.put("name", (Object)rs.getString("name"));
                accounts.add(account);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
            sql = new StringBuffer();
            sql.append("select distinct item.fid id,item.fnumber fnumber,item.fdefaultqueryname queryname, ").append("item.FDefaultF7UI queryui,item.frealtiondataobject tablename,item.FUseLongNumber useLongNumber, item.fassthgattribute propname, ").append("item.fmappingfieldname fieldname, item.FGLAsstActTypeGrpID groupID ,").append("item.fisforcompany isforcompany, item.FGroupTableName groupTable,item.FisMultiLevel isMultiLevel, ").append("item.FGroupMappingFieldName groupMappingField, item.fname_").append(loc).append(" name from ").append(" T_BD_AccountView account ").append(" inner join T_BD_AsstAccount book on account.fcaa = book.fid").append(" inner join T_BD_AsstActGroupDetail rel on book.fid = rel.fasstaccountid").append(" inner join T_BD_AsstActType item on item.fid = rel.fasstacttypeid").append(" and account.fid=? ");
            ps = con.prepareStatement(sql.toString());
            Iterator iter = accounts.iterator();
            int count = 0;
            while (iter.hasNext()) {
                ++count;
                AccountViewInfo account = (AccountViewInfo)iter.next();
                ps.setString(1, (String)account.get("id"));
                rs = ps.executeQuery();
                while (rs.next()) {
                    HashMap<String, Object> item = new HashMap<String, Object>();
                    String id = rs.getString("id");
                    item.put("id", id);
                    item.put("number", rs.getString("fnumber"));
                    item.put("name", rs.getString("name"));
                    item.put("queryname", rs.getString("queryname"));
                    item.put("propname", rs.getString("propname"));
                    item.put("fieldname", rs.getString("fieldname"));
                    item.put("tablename", rs.getString("tablename"));
                    item.put("useLongNumber", rs.getBoolean("useLongNumber"));
                    item.put("isforcompany", rs.getString("isforcompany"));
                    item.put("asstGroupID", rs.getString("groupID"));
                    item.put("groupTable", rs.getString("groupTable"));
                    item.put("groupMappingField", rs.getString("groupMappingField"));
                    item.put("isMultiLevel", rs.getString("isMultiLevel"));
                    item.put("queryui", rs.getString("queryui"));
                    if (acctUnionItems.containsKey(id)) continue;
                    acctUnionItems.put(id, item);
                    acctUnionItemsList.add(item);
                }
            }
        }
        catch (SQLException sqle) {
            try {
                throw new SQLAccessException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        sql = new StringBuffer();
        sql.append("select item.fid id,item.fnumber fnumber,item.fdefaultqueryname queryname, ").append("item.FDefaultF7UI queryui,item.frealtiondataobject tablename,item.FUseLongNumber useLongNumber, item.fassthgattribute propname, ").append("item.fmappingfieldname fieldname, item.FGLAsstActTypeGrpID groupID ,").append("item.fisforcompany isforcompany, item.FGroupTableName groupTable,item.FisMultiLevel isMultiLevel, ").append("item.FGroupMappingFieldName groupMappingField, item.fname_").append(loc).append(" name from T_BD_AsstActType item");
        String getAllItemSql = sql.toString();
        allItem = this.getAllItems(ctx, getAllItemSql);
        result.put("accounts", accounts);
        result.put("items", acctUnionItemsList);
        result.put("allItems", allItem);
        return result;
    }

    @Override
    protected HashMap _getAsstItems(Context ctx, String accountFrom, String accountTo, String companyId) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ObjectStringPK companyPK = new ObjectStringPK(companyId);
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)companyPK);
        if (company.getAccountTable() == null) {
            throw new AccountException(AccountException.CURRENTCOMPANYHASNOSTARTACCOUNTTABLE);
        }
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer("select fid id,fnumber fnumber,fname_").append(loc).append(" name from T_bd_accountview account where fcaa is not null");
        sql.append(" and fcompanyid=? ");
        if (accountFrom != null && !accountFrom.equals("")) {
            sql.append(" and fnumber>=? ");
        }
        if (accountTo != null && !accountTo.equals("")) {
            sql.append(" and fnumber<=? ");
        }
        sql.append(" and FAccountTableID = ? ");
        AccountViewCollection accounts = new AccountViewCollection();
        ArrayList crossItems = new ArrayList();
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            int index = 1;
            ps = con.prepareStatement(sql.toString());
            ps.setString(index++, companyId);
            if (accountFrom != null && !accountFrom.equals("")) {
                ps.setString(index++, accountFrom);
            }
            if (accountTo != null && !accountTo.equals("")) {
                ps.setString(index++, accountTo);
            }
            if (!StringUtils.isEmpty((String)accountTableID)) {
                ps.setString(index++, accountTableID);
            } else {
                ps.setString(index++, company.getAccountTable().getId().toString());
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                AccountViewInfo account = new AccountViewInfo();
                account.put("id", (Object)rs.getString("id"));
                account.put("number", (Object)rs.getString("fnumber"));
                account.put("name", (Object)rs.getString("name"));
                accounts.add(account);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
            sql = new StringBuffer();
            sql.append("select distinct item.fid id,item.fnumber fnumber,item.fdefaultqueryname queryname,item.FisMultiLevel isMultiLevel, ").append("item.FDefaultF7UI queryui,item.frealtiondataobject tablename,item.FUseLongNumber useLongNumber, item.fassthgattribute propname, ").append("item.fmappingfieldname fieldname, item.FGLAsstActTypeGrpID groupID ,").append("item.fisforcompany isforcompany, item.FGroupTableName groupTable, ").append("item.FGroupMappingFieldName groupMappingField, item.fname_").append(loc).append(" name from T_BD_AccountView account").append(" inner join T_BD_AsstAccount book on account.fcaa = book.fid").append(" inner join T_BD_AsstActGroupDetail rel on book.fid = rel.fasstaccountid").append(" inner join T_BD_AsstActType item on item.fid = rel.fasstacttypeid").append(" and account.fid=? ");
            HashMap allItems = new HashMap();
            HashMap<String, Integer> hmCount = new HashMap<String, Integer>();
            ps = con.prepareStatement(sql.toString());
            Iterator iter = accounts.iterator();
            int count = 0;
            while (iter.hasNext()) {
                ++count;
                AccountViewInfo account = (AccountViewInfo)iter.next();
                ps.setString(1, (String)account.get("id"));
                rs = ps.executeQuery();
                while (rs.next()) {
                    HashMap<String, Object> item = new HashMap<String, Object>();
                    String id = rs.getString("id");
                    item.put("id", id);
                    item.put("number", rs.getString("fnumber"));
                    item.put("name", rs.getString("name"));
                    item.put("queryname", rs.getString("queryname"));
                    item.put("propname", rs.getString("propname"));
                    item.put("fieldname", rs.getString("fieldname"));
                    item.put("tablename", rs.getString("tablename"));
                    item.put("useLongNumber", rs.getBoolean("useLongNumber"));
                    item.put("isforcompany", rs.getString("isforcompany"));
                    item.put("asstGroupID", rs.getString("groupID"));
                    item.put("groupTable", rs.getString("groupTable"));
                    item.put("groupMappingField", rs.getString("groupMappingField"));
                    item.put("queryui", rs.getString("queryui"));
                    item.put("isMultiLevel", rs.getString("isMultiLevel"));
                    if (hmCount.containsKey(id)) {
                        Integer i = (Integer)hmCount.get(id);
                        Integer i2 = new Integer(i + 1);
                        hmCount.put(id, i2);
                        continue;
                    }
                    hmCount.put(id, new Integer(1));
                    allItems.put(id, item);
                }
            }
            for (String key : hmCount.keySet()) {
                Integer i = (Integer)hmCount.get(key);
                if (i != count) continue;
                crossItems.add(allItems.get(key));
            }
        }
        catch (SQLException sqle) {
            try {
                throw new SQLAccessException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        result.put("accounts", accounts);
        result.put("items", crossItems);
        ArrayList allItem = new ArrayList();
        sql = new StringBuffer();
        sql.append("select item.fid id,item.fnumber fnumber,item.fdefaultqueryname queryname, ").append("item.FDefaultF7UI queryui,item.frealtiondataobject tablename,item.FUseLongNumber useLongNumber, item.fassthgattribute propname, ").append("item.fmappingfieldname fieldname, item.FGLAsstActTypeGrpID groupID ,").append("item.fisforcompany isforcompany, item.FGroupTableName groupTable, item.FisMultiLevel isMultiLevel,").append("item.FGroupMappingFieldName groupMappingField, item.fname_").append(loc).append(" name from T_BD_AsstActType item");
        String getAllItemSql = sql.toString();
        allItem = this.getAllItems(ctx, getAllItemSql);
        result.put("allItems", allItem);
        return result;
    }

    public ArrayList getAllItems(Context ctx, String sql) throws BOSException, EASBizException {
        ArrayList allItem = new ArrayList();
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            ps = con.prepareStatement(sql);
            rs = ps.executeQuery();
            HashMap<String, Integer> hmCount = new HashMap<String, Integer>();
            while (rs.next()) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                String id = rs.getString("id");
                item.put("id", id);
                item.put("number", rs.getString("fnumber"));
                item.put("name", rs.getString("name"));
                item.put("queryname", rs.getString("queryname"));
                item.put("propname", rs.getString("propname"));
                item.put("fieldname", rs.getString("fieldname"));
                item.put("tablename", rs.getString("tablename"));
                item.put("isforcompany", rs.getString("isforcompany"));
                item.put("asstGroupID", rs.getString("groupID"));
                item.put("groupTable", rs.getString("groupTable"));
                item.put("groupMappingField", rs.getString("groupMappingField"));
                item.put("useLongNumber", rs.getBoolean("useLongNumber"));
                item.put("isMultiLevel", rs.getString("isMultiLevel"));
                item.put("queryui", rs.getString("queryui"));
                if (hmCount.containsKey(id)) {
                    Integer i = (Integer)hmCount.get(id);
                    Integer i2 = new Integer(i + 1);
                    hmCount.put(id, i2);
                    continue;
                }
                hmCount.put(id, new Integer(1));
                allItem.add(item);
            }
        }
        catch (SQLException sqle) {
            try {
                throw new SQLAccessException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return allItem;
    }

    private boolean acctIsLeaf(Context ctx, String acctNumber, String companyNumber) throws BOSException, EASBizException {
        StringBuffer _sql = new StringBuffer("select acct.fisleaf from T_BD_AccountView acct,T_Org_BaseUnit baseu ");
        _sql.append(" where acct.fcompanyid = baseu.fid");
        _sql.append(" and acct.fnumber = ?");
        _sql.append(" and baseu.fnumber = ?");
        Object[] param = new Object[]{acctNumber, companyNumber};
        try {
            int isLeaf;
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)_sql.toString(), (Object[])param);
            if (rowSet.next() && (isLeaf = rowSet.getInt(1)) > 0) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new ReportException(ReportException.CALC_ERROR, (Throwable)e);
        }
        return false;
    }

    private Object[] getAccountIDForDetail(Context ctx, String strNumber, String strCompanyID) throws BOSException, EASBizException {
        String strSql = "Select FID, FDc ,FIsLeaf from T_BD_AccountView where FNumber = ? and FCompanyID = ? ";
        Object[] params = new Object[]{strNumber, strCompanyID};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSql, (Object[])params);
        try {
            if (rs.next() && rs.getInt("FIsLeaf") == 1) {
                Object[] obj = new Object[]{rs.getString("FID"), new Integer(rs.getInt("FDc"))};
                return obj;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return null;
    }

    public static void main(String[] args) {
        String items = "5501.30:5501.40|001|J0201:J0202|002|CW05:CW10";
        String items2 = "|002|aaa:bbb|003|x11:x22";
        ReportCaclControllerBean acct = new ReportCaclControllerBean();
        HashMap result = acct.parseAcctItem(items);
        Set set = result.keySet();
        for (Object obj : set) {
            logger.debug((Object)(obj.toString() + "->"));
            String[] s = (String[])result.get(obj);
            logger.debug((Object)(s[0] + "," + s[1]));
        }
    }

    @Override
    protected BigDecimal _exchangeRate(Context ctx, String sourceCurrency, String targetCurrency, Date date, String exchangeTableId) throws BOSException, EASBizException {
        String language = ctx.getLocale().toString();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = "{" + format.format(date) + "}";
        String dateSel = "'" + format.format(date) + "'";
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FIsReversible isReversible, sc.FNumber sourceCurr,sc.FName_" + language + " sourceCurrName, tc.FNumber targetCurr,tc.FName_" + language + " targetCurrName, r.FConvertRate convertRate, a.FPrecision fprecision ").append(" ,   YEAR(r.FAvailTime) as AvailYear ,  YEAR(to_date(" + dateSel + ")) as armAvailYear, DAYOFYEAR(r.FAvailTime) as AvailDay  ,DAYOFYEAR(to_date(" + dateSel + ")) as armAvailDay                                             ").append("from T_BD_Exchangetable t ").append("inner join T_BD_ExchangeAux a  on t.FID = a.FExchangeTableID ").append("inner join T_BD_ExchangeRate r on r.FExchangeAuxID = a.FID ").append("inner join T_BD_Currency sc on sc.FID = a.FSourceCurrencyID ").append("inner join T_BD_Currency tc on tc.FID = a.FTargetCurrencyID ").append("where t.FID = '" + exchangeTableId + "' and (((sc.FNumber = '" + sourceCurrency + "' or sc.FName_" + language + "='" + sourceCurrency + "')  and (tc.FNumber = '" + targetCurrency + "' or tc.FName_" + language + " = '" + targetCurrency + "')) or ((tc.FNumber = '" + sourceCurrency + "' or tc.FName_" + language + "='" + sourceCurrency + "' )and (sc.FNumber = '" + targetCurrency + "' or sc.FName_" + language + "='" + targetCurrency + "' ) and t.FIsReversible=1)) ").append("and r.FAvailTime <= " + dateStr + " and r.FInvalidTime >= " + dateStr + " ");
        BigDecimal reversedRate = null;
        try {
            StringBuffer buf = new StringBuffer();
            buf.append(" select isReversible,sourceCurr,sourceCurrName,targetCurr,targetCurrName,convertRate,fprecision, abs(armAvailYear-AvailYear)as detYear, abs(armAvailDay-AvailDay)as detDay from ( (").append(sql).append(")AS tempTable )").append("  order by detYear,detDay");
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)buf.toString());
            while (result.next()) {
                String sourceCurr = result.getString("sourceCurr");
                String sourceName = result.getString("sourceCurrName");
                String targetCurr = result.getString("targetCurr");
                String targetName = result.getString("targetCurrName");
                BigDecimal convertRate = result.getBigDecimal("convertRate");
                int precision = result.getInt("fprecision");
                if ((sourceCurr.trim().equals(sourceCurrency) || sourceCurrency.equals(sourceName.trim())) && (targetCurr.trim().equals(targetCurrency) || targetCurrency.equals(targetName.trim()))) {
                    convertRate = convertRate.setScale(precision, 4);
                    return convertRate;
                }
                if (!sourceCurr.trim().equals(targetCurrency) || !targetCurr.trim().equals(sourceCurrency)) continue;
                BigDecimal one = new BigDecimal("1");
                reversedRate = one.divide(convertRate, precision, 4);
            }
        }
        catch (SQLException e) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Throwable)e);
        }
        if (reversedRate != null) {
            return reversedRate;
        }
        throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"NoExistsExchangeRate", (Locale)ctx.getOriginLocale())});
    }

    @Override
    protected BigDecimal _Dholding(Context ctx, String shareHolderNumber, String investeeCompanyNumber, Date changeDate) throws BOSException, EASBizException {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append(" select fsharescale \r\n ");
        sbSQL.append(" from t_csl_sharerela t1, t_org_baseunit t2, t_org_baseunit t3 \r\n ");
        sbSQL.append("  where t1.FShareHolderId = t2.FId \r\n ");
        sbSQL.append("  And t1.FInvesteeCompanyId = t3.FId \r\n");
        sbSQL.append("  And t2.FNumber = ? \r\n");
        sbSQL.append("  And t3.FNumber = ? \r\n");
        sbSQL.append("  And FChangeDate IN \r\n");
        sbSQL.append("  (select max(fchangedate) \r\n");
        sbSQL.append("  From t_csl_shareRela t1, t_org_baseunit t2, t_org_baseunit t3 \r\n");
        sbSQL.append("  where t1.FShareHolderId = t2.FId \r\n");
        sbSQL.append("   And t1.FInvesteeCompanyId = t3.FId \r\n");
        sbSQL.append("  And t2.FNumber = ? \r\n");
        sbSQL.append("  And t3.FNumber = ? \r\n");
        sbSQL.append("  And t1.FChangeDate <= ? \r\n");
        sbSQL.append("  Group by FInvesteeCompanyId) \r\n");
        java.sql.Date sqldate = new java.sql.Date(changeDate.getTime());
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString(), (Object[])new Object[]{shareHolderNumber, investeeCompanyNumber, shareHolderNumber, investeeCompanyNumber, sqldate});
        BigDecimal shareScale = new BigDecimal("0");
        try {
            if (rs.next()) {
                shareScale = rs.getBigDecimal("fsharescale").divide(new BigDecimal("100.0"), 15, 4);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return shareScale;
    }

    @Override
    protected void _clearServerCache(Context ctx) throws BOSException {
        RptCalculaterDAO.clearServerCache(ctx);
    }

    @Override
    protected BigDecimal _age(Context ctx, String fiOrgUnit, String acctItem, String currency, Date endData, String from, String to, String balType, boolean includeUnPosted) throws BOSException, EASBizException {
        boolean calcAll;
        Map map;
        boolean isInTimeVerify;
        int actItemType = 1;
        if (from != null && from.trim().length() > 0 && to != null && to.trim().length() > 0) {
            int f = Integer.parseInt(from);
            int t = Integer.parseInt(to);
            if (t < f) {
                String temp = from;
                from = to;
                to = temp;
            }
        }
        if (acctItem == null || acctItem.length() < 1) {
            throw new ReportException(ReportException.PARAM_IS_NOT_INTEGRATED);
        }
        if (balType == null || balType.trim().length() == 0) {
            balType = "E";
        }
        if (!balType.equalsIgnoreCase("E") && !balType.equalsIgnoreCase("B")) {
            throw new ReportException(ReportException.TYPEERROR);
        }
        AcctountAsstItemParser.AccountAsstItem asstitem = null;
        String accountFromNumber = "";
        String accountToNumber = "";
        ArrayList asstActTypes = new ArrayList();
        try {
            asstitem = AcctountAsstItemParser.parse(acctItem);
            accountFromNumber = asstitem.startNumber;
            accountToNumber = asstitem.endNumber;
            if (accountFromNumber != null && accountFromNumber.trim().length() == 0) {
                accountFromNumber = null;
            }
            if (accountToNumber != null && accountToNumber.trim().length() == 0) {
                accountToNumber = null;
            }
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            HashMap<String, AcctountAsstItemParser.AsstItem> map2 = new HashMap<String, AcctountAsstItemParser.AsstItem>();
            if (asstitem.asstItems != null && asstitem.asstItems.length >= 1) {
                actItemType = 2;
                for (int i = 0; i < asstitem.asstItems.length; ++i) {
                    set.add(asstitem.asstItems[i].asstTypeNumber);
                    map2.put(asstitem.asstItems[i].asstTypeNumber, asstitem.asstItems[i]);
                }
                EntityViewInfo info = new EntityViewInfo();
                info.getSelector().add(new SelectorItemInfo("mappingFieldName"));
                info.getSelector().add(new SelectorItemInfo("realtionDataObject"));
                info.getSelector().add(new SelectorItemInfo("number"));
                info.setFilter(new FilterInfo());
                info.getFilter().getFilterItems().add(new FilterItemInfo("number", set, CompareType.INCLUDE));
                AsstActTypeCollection c = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeCollection(info);
                for (int i = 0; i < c.size(); ++i) {
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put("table", c.get(i).getRealtionDataObject());
                    temp.put("mapingFieldName", c.get(i).getMappingFieldName());
                    temp.put("typeNumber", c.get(i).getNumber());
                    AcctountAsstItemParser.AsstItem item = (AcctountAsstItemParser.AsstItem)map2.get(c.get(i).getNumber());
                    if (item.startNumber == null || item.startNumber.trim().length() == 0) {
                        temp.put("from", null);
                    } else {
                        temp.put("from", item.startNumber.trim());
                        actItemType = 3;
                    }
                    if (item.endNumber == null || item.endNumber.trim().length() == 0) {
                        temp.put("to", null);
                    } else {
                        temp.put("to", item.endNumber.trim());
                        actItemType = 3;
                    }
                    asstActTypes.add(temp);
                }
            }
        }
        catch (ParseException e) {
            throw new ReportException(ReportException.PRERROR);
        }
        String strDateType = "fenddate";
        if (balType.equalsIgnoreCase("B")) {
            strDateType = "fbizdate";
        }
        Date endDate = DateTimeUtils.truncateDate((Date)endData);
        String amountField = null;
        boolean general = true;
        String companyid = null;
        EntityViewInfo ev = new EntityViewInfo();
        ev.getSelector().add(new SelectorItemInfo("id"));
        ev.setFilter(new FilterInfo());
        ev.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)fiOrgUnit));
        CompanyOrgUnitCollection c = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(ev);
        if (c == null || c.size() == 0) {
            throw new ReportException(ReportException.CMPNULL);
        }
        CompanyOrgUnitInfo cpyInfo = c.get(0);
        companyid = cpyInfo.getId().toString();
        String currencyid = null;
        EntityViewInfo evc = new EntityViewInfo();
        evc.getSelector().add(new SelectorItemInfo("id"));
        evc.setFilter(new FilterInfo());
        evc.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)currency));
        CurrencyCollection cny = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(evc);
        if (cny == null || cny.size() == 0) {
            throw new ReportException(ReportException.CRYNULL);
        }
        CurrencyInfo cnyInfo = cny.get(0);
        currencyid = cnyInfo.getId().toString();
        int verifyMode = GlUtils.getVerifyMode((Context)ctx, (String)companyid);
        boolean bl = isInTimeVerify = verifyMode == 0;
        if (verifyMode == 2) {
            includeUnPosted = true;
        }
        if (includeUnPosted && isInTimeVerify) {
            amountField = "cussent.funholdedAmtFor";
            if (CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(currencyid)) {
                amountField = "cussent.funholdedAmtLocal";
            } else if (CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(currencyid)) {
                amountField = "cussent.funholdedAmtRpt";
            } else {
                general = false;
            }
        } else {
            amountField = "cussent.funVerifiedAmtFor";
            if (CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(currencyid)) {
                amountField = "cussent.funVerifiedAmtLocal";
            } else if (CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(currencyid)) {
                amountField = "cussent.funVerifiedAmtRpt";
            } else {
                general = false;
            }
        }
        StringBuffer initSql = new StringBuffer();
        ArrayList<Object> initParam = new ArrayList<Object>();
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> sqlParam = new ArrayList<Object>();
        sql.append("select sum((entry.fentrydc*2-1)*account.fdc*").append(amountField).append(") as sumall");
        initSql.append("select sum(").append(amountField).append(") as sumall");
        sql.append(" from t_gl_voucherassistrecord assist \r\n inner join t_gl_acctcussent cussent on cussent.fvchassistrecordid=assist.fid \r\n inner join t_gl_voucherentry entry on assist.fentryid=entry.fid");
        sql.append("  \r\n inner join t_gl_voucher voucher on entry.fbillid=voucher.fid \r\n inner join t_bd_accountview account on entry.faccountid=account.fid ");
        sql.append(" \r\n inner join t_bd_Currency currency on entry.fcurrencyid=currency.fid");
        initSql.append(" \r\n from t_gl_voucherassistrecord assist \r\n inner join t_gl_acctcussent cussent on cussent.fvchassistrecordid = assist.fid ");
        initSql.append(" \r\n inner join t_bd_accountview account on cussent.FAccountID=account.fid ");
        initSql.append(" \r\n inner join t_bd_Currency currency on cussent.fcurrencyid = currency.fid");
        switch (actItemType) {
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                sql.append(" \r\n inner join t_bd_assistanthg hg on assist.fassgrpid=hg.fid ");
                initSql.append(" \r\n inner join t_bd_assistanthg hg on assist.fassgrpid = hg.fid ");
                for (int i = 0; i < asstActTypes.size(); ++i) {
                    map = (Map)asstActTypes.get(i);
                    sql.append("\r\n inner JOIN " + map.get("table") + " AS T" + i + " ON hg." + map.get("mapingFieldName") + " = T" + i + ".FID    ");
                    initSql.append("\r\n inner JOIN " + map.get("table") + " AS T" + i + " ON hg." + map.get("mapingFieldName") + " = T" + i + ".FID    ");
                }
                break;
            }
        }
        switch (actItemType) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                for (int k = 0; k < asstActTypes.size(); ++k) {
                    map = (HashMap)asstActTypes.get(k);
                    if (((HashMap)map).get("from") == null && ((HashMap)map).get("to") == null) continue;
                    if (((HashMap)map).get("from") != null && ((HashMap)map).get("to") != null) {
                        sql.append(" and ").append(" T" + k).append(".fnumber>=? ");
                        sqlParam.add(((HashMap)map).get("from"));
                        sql.append(" and ").append(" T" + k).append(".fnumber<=? ");
                        sqlParam.add(((HashMap)map).get("to"));
                    } else if (((HashMap)map).get("from") != null) {
                        sql.append(" and ").append(" T" + k).append(".fnumber=? ");
                        sqlParam.add(((HashMap)map).get("from"));
                    } else if (((HashMap)map).get("to") != null) {
                        sql.append(" and ").append(" T" + k).append(".fnumber=? ");
                        sqlParam.add(((HashMap)map).get("to"));
                    }
                    if (((HashMap)map).get("from") != null && ((HashMap)map).get("to") != null) {
                        initSql.append(" and ").append(" T" + k).append(".fnumber>=? ");
                        initParam.add(((HashMap)map).get("from"));
                        initSql.append(" and ").append(" T" + k).append(".fnumber<=? ");
                        initParam.add(((HashMap)map).get("to"));
                        continue;
                    }
                    if (((HashMap)map).get("from") != null) {
                        initSql.append(" and ").append(" T" + k).append(".fnumber=? ");
                        initParam.add(((HashMap)map).get("from"));
                        continue;
                    }
                    if (((HashMap)map).get("to") == null) continue;
                    initSql.append(" and ").append(" T" + k).append(".fnumber=? ");
                    initParam.add(((HashMap)map).get("to"));
                }
                break;
            }
        }
        sql.append(" WHERE ");
        initSql.append(" WHERE ");
        sql.append("( ");
        initSql.append("(");
        if (accountFromNumber != null && accountToNumber != null) {
            sql.append(" ( account.fnumber>=? AND account.fnumber<=? )");
            sqlParam.add(accountFromNumber);
            sqlParam.add(accountToNumber);
            initSql.append(" ( account.fnumber>=? AND account.fnumber<=? )");
            initParam.add(accountFromNumber);
            initParam.add(accountToNumber);
        } else if (accountFromNumber != null) {
            sql.append(" ( account.fnumber=? )");
            sqlParam.add(accountFromNumber);
            initSql.append(" ( account.fnumber=? )");
            initParam.add(accountFromNumber);
        } else if (accountToNumber != null) {
            sql.append(" ( account.fnumber=? )");
            sqlParam.add(accountToNumber);
            initSql.append(" ( account.fnumber=? )");
            initParam.add(accountToNumber);
        } else {
            throw new ReportException(ReportException.NULLACOUNT);
        }
        sql.append(")");
        initSql.append(")");
        sql.append("AND(  cussent.fcompanyid=?)");
        sqlParam.add(companyid);
        initSql.append("AND(cussent.fcompanyid=?)");
        initParam.add(companyid);
        if (!general) {
            sql.append("AND(cussent.fcurrencyid=?)");
            sqlParam.add(currencyid);
            initSql.append("AND(cussent.fcurrencyid=?)");
            initParam.add(currencyid);
        }
        boolean bl2 = calcAll = from != null && (from.equals("0") || from.trim().length() == 0) && to != null && to.equals("0");
        if (!calcAll) {
            java.sql.Date sqlfromDate = null;
            if (from != null && from.trim().length() != 0) {
                int fromv = Integer.parseInt(from);
                Calendar cal = Calendar.getInstance();
                cal.setTime(endDate);
                cal.add(14, -1);
                cal.add(5, -1 * (fromv - 1));
                sqlfromDate = new java.sql.Date(cal.getTimeInMillis());
            } else {
                Calendar cal = Calendar.getInstance();
                cal.setTime(endDate);
                cal.add(14, -1);
                sqlfromDate = new java.sql.Date(cal.getTimeInMillis());
            }
            sql.append("AND ( assist." + strDateType + "<=?)");
            sqlParam.add(sqlfromDate);
            initSql.append("AND ( assist." + strDateType + "<=?)");
            initParam.add(sqlfromDate);
            java.sql.Date sqltoDate = null;
            if (to != null && to.trim().length() != 0) {
                int tov = Integer.parseInt(to);
                Calendar cal = Calendar.getInstance();
                cal.setTime(endDate);
                cal.add(14, -1);
                cal.add(5, -1 * tov);
                sqltoDate = new java.sql.Date(cal.getTimeInMillis());
                sql.append("AND ( assist." + strDateType + ">?)");
                sqlParam.add(sqltoDate);
                initSql.append("AND ( assist." + strDateType + ">?)");
                initParam.add(sqltoDate);
            }
        } else {
            Calendar cal = Calendar.getInstance();
            cal.setTime(endDate);
            sql.append("AND ( assist." + strDateType + ">=?)");
            sqlParam.add(new java.sql.Date(cal.getTimeInMillis()));
            initSql.append("AND ( assist." + strDateType + ">=?)");
            initParam.add(new java.sql.Date(cal.getTimeInMillis()));
        }
        sql.append(" and cussent.fisinit<>1 and cussent.fvchassistrecordid=assist.fid ");
        initSql.append(" and cussent.fvchassistrecordid=assist.fid ");
        if (!includeUnPosted) {
            sql.append(" and voucher.FBizStatus=? ");
            sqlParam.add(new Integer(5));
        } else {
            sql.append(" and voucher.fbizstatus <> ? and voucher.fbizstatus<>? ");
            sqlParam.add(new Integer(0));
            sqlParam.add(new Integer(2));
        }
        initSql.append(" and assist.fentryid is null and cussent.fisinit=1 and cussent.fisinitclosed=1 ");
        BigDecimal initV = null;
        BigDecimal sqlV = null;
        try {
            IRowSet rsetSql = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])sqlParam.toArray());
            while (rsetSql.next()) {
                sqlV = rsetSql.getBigDecimal("sumall");
            }
            IRowSet rsetInit = DbUtil.executeQuery((Context)ctx, (String)initSql.toString(), (Object[])initParam.toArray());
            while (rsetInit.next()) {
                initV = rsetInit.getBigDecimal("sumall");
            }
            BigDecimal allV = new BigDecimal("0");
            if (sqlV != null) {
                allV = allV.add(sqlV);
            }
            if (initV != null) {
                allV = allV.add(initV);
            }
            return allV.setScale(RptUtil.getScaleByCyNumAtServer(ctx, currency), 4);
        }
        catch (SQLException e) {
            logger.debug((Object)e.getMessage());
            return null;
        }
    }

    @Override
    protected String _csRef(Context ctx, String orgUnit, String tempCode, String groupTempType, int rptYear, int rptPeriod, String sheetName, String cellName, String currency, String sourceCurrency, boolean isAdjusted) throws BOSException, EASBizException {
        SheetContainer rpt = new SheetContainer(this.getReportCollection(ctx, orgUnit, rptYear, rptPeriod, currency, sourceCurrency, tempCode, groupTempType, isAdjusted), ctx);
        if (rpt == null) {
            return null;
        }
        Object val = rpt.getSumCellValue(sheetName, cellName);
        return val == null ? null : val.toString();
    }

    private IObjectCollection getReportCollection(Context ctx, String orgUnitNumber, int iYear, int iPeriod, String currencyNumber, String sourceCurrencyNumber, String templateNumber, String groupTempType, boolean isAdjusted) throws BOSException, EASBizException {
        ICslReport cslReport = CslReportFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)new Integer(iYear)));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(iPeriod)));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.number", (Object)orgUnitNumber));
        filter.getFilterItems().add(new FilterItemInfo("currency.number", (Object)currencyNumber));
        filter.getFilterItems().add(new FilterItemInfo("sourceCurrency.number", (Object)sourceCurrencyNumber));
        filter.getFilterItems().add(new FilterItemInfo("template.number", (Object)templateNumber));
        Integer rptTmpType = new Integer(RptTmpTypeEnum.getEnum(groupTempType).getValue());
        filter.getFilterItems().add(new FilterItemInfo("template.templateType", (Object)rptTmpType));
        if (rptTmpType == 6) {
            filter.getFilterItems().add(new FilterItemInfo("template.templateType", (Object)new Integer(2)));
        }
        String maskString = rptTmpType == 6 ? "#0 and #1 and #2 and #3 and #4 and #5 and (#6 or #7) and #8" : "#0 and #1 and #2 and #3 and #4 and #5 and #6 and #7";
        filter.setMaskString(maskString);
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("data"));
        Integer adjustType = new Integer(1);
        FilterItemInfo filterItem = new FilterItemInfo("adjustStatus", (Object)adjustType);
        filter.getFilterItems().add(filterItem);
        if (isAdjusted && cslReport.exists(filter)) {
            CslReportCollection objCL = cslReport.getCslReportCollection(view);
            return objCL;
        }
        adjustType = new Integer(0);
        filterItem.setCompareValue((Object)adjustType);
        if (cslReport.exists(filter)) {
            CslReportCollection objCL = cslReport.getCslReportCollection(view);
            return objCL;
        }
        return null;
    }

    @Override
    protected List _getAcctAccountsByFormula(Context ctx, HashMap valueMap, String formula) throws BOSException {
        ArrayList<String> formulaStructureList;
        block15: {
            formulaStructureList = null;
            CompanyOrgUnitInfo companyOrgUnit = null;
            if (valueMap.containsKey("CompanyOrgUnit")) {
                companyOrgUnit = (CompanyOrgUnitInfo)valueMap.get("CompanyOrgUnit");
            }
            if (formula == null || companyOrgUnit == null) break block15;
            formulaStructureList = new ArrayList<String>();
            String sql = "SELECT account.fid FAccountID,account.fcompanyid,account.fnumber AccountNumber,account.FAccountTableID,item.fnumber FNumber,item.frealtiondataobject FTableName, item.fmappingfieldname FFieldName,item.FGLAsstActTypeGrpID FGlAsstActTypeGrpID ,item.fisforcompany isforcompany, item.FGroupTableName FGroupTableName,item.FGroupMappingFieldName FGroupMappingFieldName FROM T_BD_AccountView account INNER JOIN T_BD_AsstAccount book ON account.fcaa = book.fid INNER JOIN T_BD_AsstActGroupDetail rel ON book.fid = rel.fasstaccountid INNER JOIN T_BD_AsstActType item ON item.fid = rel.fasstacttypeid WHERE account.fcompanyid=? and account.fnumber>=? and (account.fnumber<=? or account.fnumber like ?)  and account.FAccountTableID = ? ";
            String startNumber = null;
            String endNumber = null;
            AcctountAsstItemParser.AsstItem[] asstItem = null;
            try {
                AcctountAsstItemParser.AccountAsstItem accountAsstItem = AcctountAsstItemParser.parse(formula);
                startNumber = accountAsstItem.startNumber;
                endNumber = accountAsstItem.endNumber;
                asstItem = accountAsstItem.asstItems;
            }
            catch (ParseException e1) {
                logger.debug((Object)e1.getMessage());
            }
            Connection con = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            HashMap map = new HashMap();
            try {
                con = this.getConnection(ctx);
                ps = con.prepareStatement(sql);
                int number = 1;
                ps.setString(number++, companyOrgUnit.getId().toString());
                if (startNumber != null && !startNumber.equals("")) {
                    ps.setString(number++, startNumber);
                }
                if (endNumber != null && !endNumber.equals("")) {
                    ps.setString(number++, endNumber);
                    ps.setString(number++, endNumber + ".%");
                }
                ps.setString(number++, companyOrgUnit.getAccountTable().getId().toString());
                rs = ps.executeQuery();
                while (rs.next()) {
                    List<String> list;
                    String accountNumber = rs.getString("AccountNumber");
                    String fNumber = rs.getString("FNumber");
                    if (!map.containsKey(accountNumber)) {
                        list = new ArrayList<String>();
                        list.add(fNumber);
                        map.put(accountNumber, list);
                        continue;
                    }
                    list = (List)map.get(accountNumber);
                    list.add(fNumber);
                    map.put(accountNumber, list);
                }
            }
            catch (SQLException sqle) {
                try {
                    throw new SQLAccessException(sqle);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, ps, (Connection)con);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
            if (map != null && map.size() > 0) {
                for (String accountNumber : map.keySet()) {
                    List list = (List)map.get(accountNumber);
                    boolean isAllContain = true;
                    if (asstItem != null) {
                        for (int k = 0; k < asstItem.length; ++k) {
                            if (list.contains(asstItem[k].asstTypeNumber)) continue;
                            isAllContain = false;
                        }
                    }
                    if (!isAllContain) continue;
                    formulaStructureList.add(accountNumber);
                }
            }
        }
        return formulaStructureList;
    }

    @Override
    protected CurrencyInfo _getBaseOrReportCurrency(Context ctx, String orgNumber, int rptSrcType, String orgUnitId, String companyNumber, String currencyType) throws BOSException, EASBizException {
        return this._getBaseOrReportCurrency(ctx, orgNumber, rptSrcType, orgUnitId, companyNumber, currencyType, null);
    }

    @Override
    protected CurrencyInfo _getBaseOrReportCurrency(Context ctx, String orgNumber, int rptSrcType, String orgUnitId, String companyNumber, String currencyType, OrgType orgType) throws BOSException, EASBizException {
        CurrencyInfo currencyInfo = null;
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        if (orgNumber == null || orgNumber.length() == 0) {
            if (this.isCSLReport(rptSrcType) && orgUnitId != null) {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("partUnionGroup.stockControlCompany.name"));
                selector.add(new SelectorItemInfo("partUnionGroup.stockControlCompany.number"));
                if (BASE_CURRENCY.equals(currencyType)) {
                    selector.add(new SelectorItemInfo("partUnionGroup.stockControlCompany.baseCurrency.name"));
                    selector.add(new SelectorItemInfo("partUnionGroup.stockControlCompany.baseCurrency.number"));
                } else if (REPORT_CURRENCY.equals(currencyType)) {
                    selector.add(new SelectorItemInfo("partUnionGroup.stockControlCompany.reportCurrency.name"));
                    selector.add(new SelectorItemInfo("partUnionGroup.stockControlCompany.reportCurrency.number"));
                }
                FullOrgUnitInfo orgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitId), selector);
                companyOrgUnitInfo = orgUnit.getPartUnionGroup().getStockControlCompany();
                if (companyOrgUnitInfo == null) {
                    companyOrgUnitInfo = this.getCompany(orgType, ctx, currencyType, companyNumber);
                }
            } else {
                companyOrgUnitInfo = this.getCompany(orgType, ctx, currencyType, companyNumber);
            }
        } else {
            companyOrgUnitInfo = this.getCompany(orgType, ctx, currencyType, orgNumber);
        }
        if (companyOrgUnitInfo != null) {
            if (BASE_CURRENCY.equals(currencyType)) {
                currencyInfo = companyOrgUnitInfo.getBaseCurrency();
            } else if (REPORT_CURRENCY.equals(currencyType)) {
                currencyInfo = companyOrgUnitInfo.getReportCurrency();
            }
        } else {
            throw new ReportException(ReportException.FIND_COMPANY_ERROR);
        }
        return currencyInfo;
    }

    private CompanyOrgUnitInfo getCompany(OrgType orgType, Context ctx, String currencyType, String companyNumber) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)companyNumber));
        if (BASE_CURRENCY.equals(currencyType)) {
            viewInfo.getSelector().add(new SelectorItemInfo("baseCurrency.name"));
            viewInfo.getSelector().add(new SelectorItemInfo("baseCurrency.number"));
        } else if (REPORT_CURRENCY.equals(currencyType)) {
            viewInfo.getSelector().add(new SelectorItemInfo("reportCurrency.name"));
            viewInfo.getSelector().add(new SelectorItemInfo("reportCurrency.number"));
        }
        if (OrgType.Company.equals((Object)orgType) || null == orgType) {
            CompanyOrgUnitCollection companyColl = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(viewInfo);
            if (companyColl.size() > 0) {
                companyOrgUnitInfo = companyColl.get(0);
            }
        } else {
            companyOrgUnitInfo = RptNewUIUtil.getDelegateCompanyByNumber((Context)ctx, (OrgType)orgType, (String)companyNumber, (SelectorItemCollection)viewInfo.getSelector());
        }
        return companyOrgUnitInfo;
    }

    private boolean isCSLReport(int type) {
        return type == 2 || type == 3 || type == 4 || type == 11 || type == 12 || type == 14 || type == 15 || type == 16;
    }

    @Override
    protected BigDecimal _acct_profit(Context ctx, String fiOrgUnit, String acctItem, BalanceTypeEnum balanceType, int startYear, int startPeriod, int endYear, int endPeriod, String currency, boolean isInternalCompany, boolean isincludingUnPosted, boolean checkDataRight, OrgType orgType) throws BOSException, EASBizException {
        AcctStruct acct = new AcctStruct(fiOrgUnit, acctItem, balanceType, startYear, startPeriod, endYear, endPeriod, currency, orgType);
        acct.setIncludeVoucher(isincludingUnPosted);
        acct.setCheckDataRight(checkDataRight);
        AcctBatchCalculaterNew batcher = new AcctBatchCalculaterNew(ctx);
        try {
            batcher.init();
            batcher.initPermission(new ICalculateContextProvider(){

                public IErrorProvider getErrorProvider() {
                    return null;
                }

                public IErrorResultProvider getErrorResultProvider() {
                    return null;
                }

                public IReportPropertyAdapter getReportAdapter() {
                    return null;
                }

                public ReportVariables getReportVariables() {
                    ReportVariables rptVar = new ReportVariables();
                    rptVar.add(new VariableEntry("Check_Permissioin", null, 1, "false", false));
                    return rptVar;
                }

                public Context getServerContext() {
                    return null;
                }
            });
            Parameter param = new Parameter(null, null, false);
            FormulaValueBackfill var = new FormulaValueBackfill(param);
            AcctCalculaterExt acctext = new AcctCalculaterExt(acct, (IBackfillHandler)var);
            acctext.setContext(ctx);
            batcher.addFormula(acctext);
            batcher.isUseNewBatchLogic = true;
            DebugLogger.isDebug = false;
            batcher.execute();
            if (var.getException() != null) {
                if (var.getException() instanceof ReportException) {
                    throw (ReportException)var.getException();
                }
                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{var.getException().getMessage()});
            }
            Object obj = var.getValue();
            if (obj instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)obj;
                return bigDecimal;
            }
            try {
                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{obj == null ? "ACCT" + ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"FetchDataError", (Locale)ctx.getOriginLocale()) : obj.toString()});
            }
            catch (SQLException e) {
                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{e.getMessage()});
            }
        }
        finally {
            try {
                batcher.clearUp();
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    protected HashMap _getAsstItems(Context ctx, String accountFrom, String accountTo, String companyId, String accountTableId) throws BOSException, EASBizException {
        accountTableID = accountTableId;
        HashMap map = this.getAsstItems(ctx, accountFrom, accountTo, companyId);
        accountTableID = null;
        return map;
    }

    @Override
    protected HashMap _getAcctAsstItems(Context ctx, String accountFrom, String accountTo, String companyID, String accountTableId) throws BOSException, EASBizException {
        accountTableID = accountTableId;
        HashMap map = this.getAcctAsstItems(ctx, accountFrom, accountTo, companyID);
        accountTableID = null;
        return map;
    }

    @Override
    protected String _getLongNumberByOrgType(Context ctx, OrgType orgType, String orgId) throws BOSException, EASBizException {
        String longNumber = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT s.FLongnumber longNumber \n");
        sql.append(" FROM t_org_structure s \n");
        sql.append(" INNER JOIN t_org_tree t ON t.fid = s.FTreeId \n");
        sql.append(" INNER JOIN t_org_baseunit u ON u.fid = s.FUnitId \n");
        sql.append(" WHERE t.ftype = " + orgType.getValue() + " AND u.fid = '" + orgId + "' \n");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet.next()) {
                longNumber = rowSet.getString("longNumber");
            }
        }
        catch (SQLException e) {
            logger.debug((Object)e.getMessage());
        }
        return longNumber;
    }

    class Item {
        String type;
        String from = null;
        String to = null;
        String table;
        String mapfield;
        String tableAis = "table" + ++index;
        boolean useLongNumber;

        void setFrom(String f) {
            if (f == null || f.trim().length() == 0) {
                return;
            }
            this.from = f.trim();
        }

        void setTo(String f) {
            if (f == null || f.trim().length() == 0) {
                return;
            }
            this.to = f.trim();
        }

        boolean hasFromTo() {
            return this.from != null || this.to != null;
        }

        String getWheteItem(ArrayList list) {
            if (this.useLongNumber) {
                this.from = this.from.replaceAll("\\.", "!");
                this.to = this.to.replaceAll("\\.", "!");
            }
            if (this.from == null && this.to == null) {
                if (this.useLongNumber) {
                    return "( " + this.tableAis + ".flongnumber IS NOT  NULL )";
                }
                return "( " + this.tableAis + ".fnumber IS NOT  NULL )";
            }
            if (this.from != null && this.to != null) {
                if (!this.from.equals(this.to)) {
                    list.add(this.from);
                    list.add(this.to);
                    if (this.useLongNumber) {
                        return "( " + this.tableAis + ".flongnumber>=? and  " + this.tableAis + ".flongnumber<=?)";
                    }
                    return "( " + this.tableAis + ".fnumber>=? and  " + this.tableAis + ".fnumber<=?)";
                }
                list.add(this.from);
                if (this.useLongNumber) {
                    return " " + this.tableAis + ".flongnumber=? ";
                }
                return " " + this.tableAis + ".fnumber=? ";
            }
            list.add(this.from);
            if (this.useLongNumber) {
                return " " + this.tableAis + ".flongnumber=? ";
            }
            return " " + this.tableAis + ".fnumber=? ";
        }
    }

    class Project {
        boolean hasItem = false;
        String projectCode = "";
        ArrayList items = new ArrayList();

        Project(String param, Context ctx) throws Exception {
            if (param.indexOf("|") < 0) {
                this.projectCode = param;
            } else {
                this.hasItem = true;
                ArrayList<String> list = new ArrayList<String>();
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < param.length(); ++i) {
                    if (param.charAt(i) == '|') {
                        list.add(buf.toString());
                        buf = new StringBuffer();
                    } else {
                        buf.append(param.charAt(i));
                    }
                    if (i != param.length() - 1) continue;
                    list.add(buf.toString());
                }
                if (list.size() % 2 == 1) {
                    String type = null;
                    for (int i = 0; i < list.size(); ++i) {
                        String str = (String)list.get(i);
                        if (i == 0) {
                            this.projectCode = str;
                            continue;
                        }
                        if (i % 2 == 0) {
                            Item item;
                            if (type == null || type.trim().length() == 0) {
                                throw new Exception("type is null");
                            }
                            if (str == null || str.trim().length() == 0) {
                                item = new Item();
                                item.type = type.trim();
                                this.items.add(item);
                                continue;
                            }
                            item = new Item();
                            item.type = type.trim();
                            if (str.indexOf(":") >= 0) {
                                item.setFrom(str.substring(0, str.indexOf(":")));
                                item.setTo(str.substring(str.indexOf(":") + 1));
                            } else {
                                item.setFrom(str);
                            }
                            this.items.add(item);
                            continue;
                        }
                        type = str;
                    }
                } else {
                    throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"2_ReportCaclControllerBean", (Locale)ctx.getOriginLocale()));
                }
            }
            this.queryTableAndMapField(ctx);
        }

        void queryTableAndMapField(Context ctx) throws Exception {
            IAsstActType local = AsstActTypeFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("id"));
            view.getSelector().add(new SelectorItemInfo("mappingFieldName"));
            view.getSelector().add(new SelectorItemInfo("realtionDataObject"));
            view.getSelector().add(new SelectorItemInfo("useLongNumber"));
            for (int i = 0; i < this.items.size(); ++i) {
                Item item = (Item)this.items.get(i);
                view.setFilter(new FilterInfo());
                view.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)item.type));
                AsstActTypeCollection c = local.getAsstActTypeCollection(view);
                if (c == null || c.size() == 0) {
                    throw new Exception("type number error");
                }
                item.mapfield = c.get(0).getMappingFieldName();
                item.table = c.get(0).getRealtionDataObject();
            }
        }
    }
}

