/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.io.BookIOController;
import com.kingdee.bos.ctrl.excel.io.IBookFieldFlags;
import com.kingdee.bos.ctrl.excel.io.table.BookToKdf;
import com.kingdee.bos.ctrl.excel.io.table.KdfToBook;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.BookFormulaHelper;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Dependents;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.KDTDataRequestManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.file.ZipKDF;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.QueryExecuteOption;
import com.kingdee.bos.dao.query.server.QueryDataAccess;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.base.permission.app.service.DataPermissionService;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IUnionVersionControllerFacade;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.UnionVersionControllerFacadeFactory;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.dao.ReferenceDAO;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gr.cslrpt.ConvertStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptCommitException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.CyConvtFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.IDataCollect;
import com.kingdee.eas.fi.gr.cslrpt.ISumRptRela;
import com.kingdee.eas.fi.gr.cslrpt.ITempletDispense;
import com.kingdee.eas.fi.gr.cslrpt.MaintainYearInitDataFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDataServiceFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.ServerException;
import com.kingdee.eas.fi.gr.cslrpt.SumRptRelaCollection;
import com.kingdee.eas.fi.gr.cslrpt.SumRptRelaFactory;
import com.kingdee.eas.fi.gr.cslrpt.SumRptRelaInfo;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseCollection;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseFactory;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseInfo;
import com.kingdee.eas.fi.gr.cslrpt.UnionVersionUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.rptintegration.util.CslRptReceiveOperate;
import com.kingdee.eas.fi.newrpt.MultOrgUnitHelper;
import com.kingdee.eas.fi.newrpt.OrgUnitConvtHelper;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.ReportBatchCalculatorImpl;
import com.kingdee.eas.fi.newrpt.formula.ReportCalculateContext;
import com.kingdee.eas.fi.newrpt.formula.ReportCalculatorProvider;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluCalcHelp;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluInfo;
import com.kingdee.eas.fi.newrpt.report.VariablesHelper;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import com.kingdee.eas.fi.newrpt.util.TemplateDispenseNewUtil;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CheckedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.DefaultContextHandler;
import com.kingdee.eas.fi.rpt.IContextHandler;
import com.kingdee.eas.fi.rpt.IIndexData;
import com.kingdee.eas.fi.rpt.IIndexItem;
import com.kingdee.eas.fi.rpt.IPostil;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.IRptHistory;
import com.kingdee.eas.fi.rpt.IRptOrgRela;
import com.kingdee.eas.fi.rpt.IRptSheetParam;
import com.kingdee.eas.fi.rpt.IRptTypeRela;
import com.kingdee.eas.fi.rpt.ITemplate;
import com.kingdee.eas.fi.rpt.IndexDataCollection;
import com.kingdee.eas.fi.rpt.IndexDataFactory;
import com.kingdee.eas.fi.rpt.IndexDataInfo;
import com.kingdee.eas.fi.rpt.IndexItemCollection;
import com.kingdee.eas.fi.rpt.IndexItemFactory;
import com.kingdee.eas.fi.rpt.IndexItemInfo;
import com.kingdee.eas.fi.rpt.IsSupportGroupReportEnum;
import com.kingdee.eas.fi.rpt.PostilCollection;
import com.kingdee.eas.fi.rpt.PostilFactory;
import com.kingdee.eas.fi.rpt.PostilInfo;
import com.kingdee.eas.fi.rpt.PostilTypeEnum;
import com.kingdee.eas.fi.rpt.PublicStatusEnum;
import com.kingdee.eas.fi.rpt.PublishedStatusEnum;
import com.kingdee.eas.fi.rpt.Rect;
import com.kingdee.eas.fi.rpt.ReportBaseCollection;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportBatchCalculateProvider;
import com.kingdee.eas.fi.rpt.ReportCaclProxy;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.ReportCollection;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.ReportTypeCollection;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.ReportTypeFactory;
import com.kingdee.eas.fi.rpt.ReportTypeInfo;
import com.kingdee.eas.fi.rpt.RptAndTempException;
import com.kingdee.eas.fi.rpt.RptCheckExpTank;
import com.kingdee.eas.fi.rpt.RptCheckExpression;
import com.kingdee.eas.fi.rpt.RptDataInfo;
import com.kingdee.eas.fi.rpt.RptHistoryFactory;
import com.kingdee.eas.fi.rpt.RptHistoryInfo;
import com.kingdee.eas.fi.rpt.RptOperationSchemaComp;
import com.kingdee.eas.fi.rpt.RptOrgRelaCollection;
import com.kingdee.eas.fi.rpt.RptOrgRelaFactory;
import com.kingdee.eas.fi.rpt.RptOrgRelaInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamFactory;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.RptTypeRelaCollection;
import com.kingdee.eas.fi.rpt.RptTypeRelaFactory;
import com.kingdee.eas.fi.rpt.RptTypeRelaInfo;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.TemplateReportSavePointCollection;
import com.kingdee.eas.fi.rpt.TemplateReportSavePointFactory;
import com.kingdee.eas.fi.rpt.TemplateReportSavePointInfo;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.fi.rpt.app.AbstractReportControllerBean;
import com.kingdee.eas.fi.rpt.app.ReportToGroupHelper;
import com.kingdee.eas.fi.rpt.app.RptCalculaterDAO;
import com.kingdee.eas.fi.rpt.batch.ChecFmlParamPermissionUtil;
import com.kingdee.eas.fi.rpt.batch.OneToManyMap;
import com.kingdee.eas.fi.rpt.check.ReportCheck;
import com.kingdee.eas.fi.rpt.rptdata.RptDataTogether;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.CheckReport;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.RptUtilForServer;
import com.kingdee.eas.fi.rpt.util.SumcalcRange;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgActualRecordInfo;
import com.kingdee.eas.ma.budget.BgActualRecordPropertyAdapter;
import com.kingdee.eas.ma.budget.BgBatchCalculatorImpl;
import com.kingdee.eas.ma.budget.BgRptReportPropertyAdapter;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.util.BizReference;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ReportControllerBean
extends AbstractReportControllerBean {
    private static final long serialVersionUID = -6733209874306361689L;
    private static Logger logger = Logger.getLogger(ReportControllerBean.class);
    protected HashMap tables = null;
    int currencyScale = 0;

    @Override
    protected String _getMasterTable(Context ctx) throws BOSException {
        return "T_rpt_Report";
    }

    @Override
    protected void _backCacl(Context ctx, IObjectPK reportPK) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo;
        OrgUnitInfo orgUnit;
        GlUtils.updateBalance();
        ReportInfo reportInfo = this.getReportInfo(ctx, reportPK, this.getSelectors());
        Book book = null;
        try {
            book = reportInfo.getBook();
            book = this.reportCalculate(ctx, (IObjectValue)reportInfo, null, book, null);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            RptCalculaterDAO.clearServerCache(ctx);
        }
        boolean isVersion = false;
        IParamControl param = ParamControlFactory.getLocalInstance((Context)ctx);
        if (param.getParamByNumber("fi_rp_001") != null && (orgUnit = ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)OrgType.Company)) != null && (companyInfo = MultOrgUnitHelper.getInstance().getDelegateCompanyNoOrgType(orgUnit, ctx)) != null && companyInfo.getId() != null) {
            String companyid = companyInfo.getId().toString();
            isVersion = Boolean.valueOf(param.getParamValue((IObjectPK)new ObjectUuidPK(companyid), "fi_rp_001"));
        }
        try {
            reportInfo.setBook(book);
            book = null;
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        if (isVersion) {
            boolean isSupportGroup;
            boolean bl = isSupportGroup = reportInfo.getIsSupportGroup().getValue() == 1;
            if (!isSupportGroup) {
                this._reportVersion(ctx, reportInfo);
            }
        }
        ReportFactory.getLocalInstance(ctx).update(reportPK, (CoreBaseInfo)reportInfo);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcReport", (Object)pk.toString()));
        if (ReportFactory.getLocalInstance(ctx).exists(filter)) {
            throw new ReportException(ReportException.CAN_NOT_DELETE);
        }
        ReportInfo reportInfo = this.getReportInfo(ctx, pk);
        if ((reportInfo.getSourceType() == RptSrcTypeEnum.DYNAMICNORMALREPORT || reportInfo.getSourceType() == RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT || RptSrcTypeEnum.COMMITREPORT == reportInfo.getSourceType() || RptSrcTypeEnum.SINGLEEXTRACTDATA == reportInfo.getSourceType()) && reportInfo.getIsSupportGroup() == IsSupportGroupReportEnum.SUPPORT && reportInfo.getCslReport() != null && reportInfo.getCslReport().getId() != null && reportInfo.getCslReport().getId().toString() != null) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select fid from t_csl_cslreport where fid=?", (Object[])new String[]{reportInfo.getCslReport().getId().toString()});
            try {
                if (rs.next()) {
                    CslReportFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(reportInfo.getCslReport().getId()), true);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (reportInfo.getPublicStatus().equals((Object)PublicStatusEnum.UNPUBLIC)) {
            ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
        }
        this.deleteWithPermission(ctx, reportInfo);
        CslRptReceiveOperate.deleteParentDataReport((Context)ctx, (String)pk.toString(), (boolean)true);
    }

    @Override
    protected void _forceDelete(Context ctx, IObjectPK pk, Boolean force) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcReport", (Object)pk.toString()));
        if (ReportFactory.getLocalInstance(ctx).exists(filter)) {
            throw new ReportException(ReportException.CAN_NOT_DELETE);
        }
        ReportInfo reportInfo = this.getReportInfo(ctx, pk);
        if ((reportInfo.getSourceType() == RptSrcTypeEnum.DYNAMICNORMALREPORT || reportInfo.getSourceType() == RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT || RptSrcTypeEnum.COMMITREPORT == reportInfo.getSourceType() || RptSrcTypeEnum.SINGLEEXTRACTDATA == reportInfo.getSourceType()) && reportInfo.getIsSupportGroup() == IsSupportGroupReportEnum.SUPPORT && reportInfo.getCslReport() != null && reportInfo.getCslReport().getId() != null && reportInfo.getCslReport().getId().toString() != null) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select fid from t_csl_cslreport where fid=?", (Object[])new String[]{reportInfo.getCslReport().getId().toString()});
            try {
                if (rs.next()) {
                    CslReportFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(reportInfo.getCslReport().getId()), true);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        this.delIndexData(ctx, pk);
        this.recycleNumberByOrg(ctx, pk);
        super._delete(ctx, pk, force);
        AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
        asm.deleteAttachemtsByBoID(pk.toString());
        CslRptReceiveOperate.deleteParentDataReport((Context)ctx, (String)pk.toString(), (boolean)true);
    }

    private void checkHasCovertedReport(Context ctx, ReportInfo sicReport) throws BOSException, EASBizException {
        boolean exists;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)sicReport.getCompany().getId().toString()));
        if (sicReport.getTemplate() != null) {
            filter.getFilterItems().add(new FilterItemInfo("template.group", (Object)sicReport.getTemplate().getGroup()));
        }
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)new Integer(sicReport.getYear())));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(sicReport.getPeriod())));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)sicReport.getPeriodType()));
        filter.getFilterItems().add(new FilterItemInfo("sourceCurrency", (Object)sicReport.getCurrency().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("currency", (Object)sicReport.getCurrency().getId().toString(), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("convertStatus", (Object)new Integer(ConvertStatusEnum.Converted.getValue())));
        String dataCollectNumber = sicReport.getDataCollectNumber();
        if (!StringUtils.isEmpty((String)dataCollectNumber)) {
            filter.getFilterItems().add(new FilterItemInfo("dataCollectNumber", (Object)dataCollectNumber));
        }
        if (exists = ReportFactory.getLocalInstance(ctx).exists(filter)) {
            throw new EASBizException(new NumericExceptionSubItem("004", ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"3_ReportControllerBean", (Locale)ctx.getOriginLocale()) + sicReport.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"4_ReportControllerBean", (Locale)ctx.getOriginLocale())));
        }
    }

    private void deleteSumRelation(Context ctx, IObjectPK pk) throws BOSException {
        String _sql = "delete from T_CSL_SumRptRela where FSumReportID = ?";
        DbUtil.execute((Context)ctx, (String)_sql, (Object[])new Object[]{pk.toString()});
    }

    private void delIndexData(Context ctx, IObjectPK pk) throws BOSException {
        String _sql = "delete from t_rpt_indexdata where freportid = ?";
        Object[] params = new Object[]{pk.toString()};
        DbUtil.execute((Context)ctx, (String)_sql, (Object[])params);
    }

    private void delReportCheck(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        boolean isExists = SumRptRelaFactory.getLocalInstance((Context)ctx).exists(" where reportID = '" + pk.toString() + "'");
        if (isExists) {
            throw new ReportException(ReportException.ALREADY_BE_REFERENCE);
        }
    }

    @Override
    protected ICodingRuleManager getCodingRuleCtrl(Context ctx) throws BOSException {
        return CodingRuleManagerFactory.getLocalInstance((Context)ctx);
    }

    @Override
    protected byte[] _backCacl(Context ctx, IObjectValue reportInfo, byte[] data) throws BOSException {
        Book book = null;
        try {
            book = reportInfo instanceof CslReportInfo || reportInfo instanceof ReportInfo ? IOHelper.unpackBook(data, "rpt_trans") : IOHelper.unpackBook(data);
            book = this.reportCalculate(ctx, reportInfo, null, book, null);
            byte[] byArray = IOHelper.packBook(book);
            return byArray;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            RptCalculaterDAO.clearServerCache(ctx);
        }
    }

    @Override
    protected byte[] _backCacl(Context ctx, String sheetID, IObjectValue reportInfo, byte[] data) throws BOSException, EASBizException {
        return this.reportCalculate(ctx, sheetID, reportInfo, data);
    }

    private byte[] reportCalculate(Context ctx, String sheetID, IObjectValue reportInfo, byte[] data) {
        try {
            KDF kdf = ZipKDF.unpack((byte[])data);
            Collection collection = kdf.getAllTable();
            if (collection == null || collection.size() == 0) {
                return data;
            }
            int[] index = new int[collection.size()];
            for (int i = 0; i < collection.size(); ++i) {
                KDTable tempTable = (KDTable)kdf.getTableByIndex(i);
                this.tables.put(tempTable.getName().toLowerCase(), tempTable);
                index[i] = sheetID != null && tempTable.getID().equals(sheetID) ? 1 : -1;
            }
            if (sheetID == null) {
                index = null;
            }
            Book book = this.reportCalculate(ctx, reportInfo, kdf, null, index);
            return ZipKDF.pack((KDF)new BookToKdf().getKDF(book));
        }
        catch (Exception e) {
            logger.debug((Object)e.getMessage());
            return data;
        }
    }

    public void updateData(Context ctx, byte[] data, IObjectPK reportPK) throws BOSException {
        StringBuffer _sql = new StringBuffer("update t_rpt_Report set");
        _sql.append(" fdata = ? where fid = ?");
        Object[] params = new Object[]{data, reportPK.toString()};
        DbUtil.execute((Context)ctx, (String)_sql.toString(), (Object[])params);
    }

    @Override
    protected boolean _isUseTemplate(Context ctx, IObjectPK templatePK) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("template", (Object)templatePK.toString());
        filter.getFilterItems().add(filterItem);
        boolean isExist = this.exists(ctx, filter);
        return isExist;
    }

    @Override
    protected void _reportVersion(Context ctx, ReportInfo editData) throws BOSException, EASBizException {
        this.creatHisReport(ctx, editData);
    }

    private void creatHisReport(Context ctx, ReportInfo newReportInfo) throws BOSException, EASBizException {
        ObjectUuidPK oldPK = new ObjectUuidPK(newReportInfo.getId());
        if (!ReportFactory.getLocalInstance(ctx).exists((IObjectPK)oldPK)) {
            throw new ReportException(ReportException.SAVEREPORT);
        }
        ReportInfo reportInfo = this.getReportInfo(ctx, (IObjectPK)oldPK);
        IRptHistory iRptHistory = RptHistoryFactory.getLocalInstance(ctx);
        RptHistoryInfo rptHistoryInfo = this.reportInfoToHisReportInfo(reportInfo);
        rptHistoryInfo.setReport(newReportInfo);
        rptHistoryInfo.setId(BOSUuid.create((BOSObjectType)rptHistoryInfo.getBOSType()));
        rptHistoryInfo.setCreateTime(null);
        IObjectPK newPK = iRptHistory.addnew((CoreBaseInfo)rptHistoryInfo);
        IRptSheetParam iRptSheetParam = RptSheetParamFactory.getLocalInstance(ctx);
        iRptSheetParam.cloneSheetPara(newPK, (IObjectPK)oldPK);
        IRptTypeRela iRptTypeRela = RptTypeRelaFactory.getLocalInstance(ctx);
        iRptTypeRela.cloneTypeRela(newPK, (IObjectPK)oldPK);
        IPostil iPostil = PostilFactory.getLocalInstance(ctx);
        iPostil.clonePostil(newPK, (IObjectPK)oldPK);
        IRptOrgRela iRptOrgRela = RptOrgRelaFactory.getLocalInstance(ctx);
        iRptOrgRela.cloneOrgRela(newPK, (IObjectPK)oldPK);
    }

    @Override
    protected void _reportRollBack(Context ctx, IObjectPK rollBackRptPK, IObjectPK reportPK) throws BOSException, EASBizException {
        ReportInfo reportInfo = this.getReportInfo(ctx, reportPK);
        this.creatHisReport(ctx, reportInfo);
        IRptHistory iRptHistory = RptHistoryFactory.getLocalInstance(ctx);
        RptHistoryInfo reportHistoryInfo = iRptHistory.getRptHistoryInfo(rollBackRptPK);
        reportHistoryInfo.setId(BOSUuid.read((String)reportPK.toString()));
        ReportInfo newReportInfo = this.hisReportInfoToReportInfo(reportHistoryInfo);
        this.update(ctx, reportPK, newReportInfo, false);
        IRptSheetParam iRptSheetParam = RptSheetParamFactory.getLocalInstance(ctx);
        iRptSheetParam.cloneSheetPara(reportPK, rollBackRptPK);
        IRptTypeRela iRptTypeRela = RptTypeRelaFactory.getLocalInstance(ctx);
        iRptTypeRela.cloneTypeRela(reportPK, rollBackRptPK);
        IPostil iPostil = PostilFactory.getLocalInstance(ctx);
        iPostil.clonePostil(reportPK, rollBackRptPK);
        IRptOrgRela iRptOrgRela = RptOrgRelaFactory.getLocalInstance(ctx);
        iRptOrgRela.cloneOrgRela(reportPK, rollBackRptPK);
    }

    private RptHistoryInfo reportInfoToHisReportInfo(ReportInfo reportInfo) {
        RptHistoryInfo rptHistoryInfo = new RptHistoryInfo();
        Enumeration en = reportInfo.keys();
        while (en.hasMoreElements()) {
            String k = (String)en.nextElement();
            rptHistoryInfo.put(k, reportInfo.get(k));
        }
        return rptHistoryInfo;
    }

    private ReportInfo hisReportInfoToReportInfo(RptHistoryInfo reportHistoryInfo) {
        ReportInfo reportInfo = new ReportInfo();
        return reportInfo;
    }

    @Override
    public void checktempCodeDump(Context ctx, ReportBaseInfo reportBaseInfo) throws BOSException, RptAndTempException, EASBizException {
        boolean isExist;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("orgType"));
        FilterInfo filter = new FilterInfo();
        FilterItemInfo numberFilter = new FilterItemInfo("number", (Object)reportBaseInfo.getNumber());
        FilterItemInfo companyFilter = new FilterItemInfo("company", (Object)reportBaseInfo.getCompany().getId().toString());
        if (reportBaseInfo.getId() != null) {
            FilterItemInfo filterItem5 = new FilterItemInfo("id", (Object)reportBaseInfo.getId().toString(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem5);
        }
        FilterItemInfo sourceTypeFilter = new FilterItemInfo("sourceType", (Object)new Integer(reportBaseInfo.getSourceType().getValue()));
        filter.getFilterItems().add(numberFilter);
        filter.getFilterItems().add(companyFilter);
        filter.getFilterItems().add(sourceTypeFilter);
        if (reportBaseInfo.getSourceType().equals((Object)RptSrcTypeEnum.COMMITREPORT) || reportBaseInfo.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICNORMALREPORT)) {
            FilterItemInfo filterItem3 = new FilterItemInfo("dataCollectNumber", (Object)((ReportInfo)reportBaseInfo).getDataCollectNumber());
            filter.getFilterItems().add(filterItem3);
        }
        view.setFilter(filter);
        ReportCollection col = this.getReportCollection(ctx, view);
        boolean bl = isExist = col.size() > 0;
        if (isExist) {
            Object[] params = new Object[]{col.get(0).getOrgType().getAlias(), reportBaseInfo.getNumber(), ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"checkCodingRule", (Locale)ctx.getOriginLocale())};
            throw new RptAndTempException(RptAndTempException.RPT_DUP, params);
        }
    }

    private SelectorItemCollection getSelectors2() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("template.id"));
        sic.add(new SelectorItemInfo("template.number"));
        sic.add(new SelectorItemInfo("template.templateType"));
        sic.add(new SelectorItemInfo("template.group"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("sourceCurrency.name"));
        sic.add(new SelectorItemInfo("sourceCurrency.number"));
        sic.add(new SelectorItemInfo("sourceCurrency.precision"));
        return sic;
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("dataCollect.*"));
        sic.add(new SelectorItemInfo("dataCollectNumber"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("sourceCurrency.name"));
        sic.add(new SelectorItemInfo("sourceCurrency.number"));
        sic.add(new SelectorItemInfo("sourceCurrency.precision"));
        sic.add(new SelectorItemInfo("orgRela.id"));
        sic.add(new SelectorItemInfo("orgRela.orgType"));
        sic.add(new SelectorItemInfo("orgRela.relaType"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.report.id"));
        sic.add(new SelectorItemInfo("postils.sheet.id"));
        sic.add(new SelectorItemInfo("postils.creator.id"));
        sic.add(new SelectorItemInfo("postils.creator.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.number"));
        sic.add(new SelectorItemInfo("savePoint.relaType"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.number"));
        sic.add(new SelectorItemInfo("savePoint.rptType.rptTypeStd"));
        sic.add(new SelectorItemInfo("sheetParam.*"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgType"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.id"));
        sic.add(new SelectorItemInfo("sheetParam.currency.number"));
        sic.add(new SelectorItemInfo("sheetParam.currency.name"));
        sic.add(new SelectorItemInfo("sheetParam.postils.*"));
        sic.add(new SelectorItemInfo("sheetParam.postils.report.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.sheet.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.name"));
        sic.add(new SelectorItemInfo("template.id"));
        sic.add(new SelectorItemInfo("template.name"));
        sic.add(new SelectorItemInfo("template.number"));
        sic.add(new SelectorItemInfo("template.templateType"));
        sic.add(new SelectorItemInfo("template.group"));
        return sic;
    }

    @Override
    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        boolean isSupport13Period;
        ReportInfo reportInfo = (ReportInfo)model;
        boolean[] params = this.batchgetParam(ctx);
        boolean isMergeByFiscalPeriod = params[0];
        if (this.isNotSupportGroup(isMergeByFiscalPeriod, isSupport13Period = params[1], reportInfo)) {
            reportInfo.setIsSupportGroup(IsSupportGroupReportEnum.NOTSUPPORT);
        }
        super._addnew(ctx, pk, (IObjectValue)reportInfo);
        this.addPeerCSLReport(ctx, reportInfo, isSupport13Period, isMergeByFiscalPeriod);
        ReportBaseCollection subReport = reportInfo.getSubReport();
        this.addSubReport(ctx, pk, subReport);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean isSupport13Period;
        ReportInfo reportInfo = (ReportInfo)model;
        boolean[] params = this.batchgetParam(ctx);
        boolean isMergeByFiscalPeriod = params[0];
        if (this.isNotSupportGroup(isMergeByFiscalPeriod, isSupport13Period = params[1], reportInfo)) {
            reportInfo.setIsSupportGroup(IsSupportGroupReportEnum.NOTSUPPORT);
        }
        if (reportInfo.getSourceCurrency() == null || ConvertStatusEnum.BeforeConvert.equals((Object)reportInfo.getConvertStatus())) {
            reportInfo.setSourceCurrency(reportInfo.getCurrency());
        }
        IObjectPK pk = super._addnew(ctx, (IObjectValue)reportInfo);
        reportInfo.setId(BOSUuid.read((String)pk.toString()));
        this.addPeerCSLReport(ctx, reportInfo, isSupport13Period, isMergeByFiscalPeriod);
        ReportBaseCollection subReport = reportInfo.getSubReport();
        this.addSubReport(ctx, pk, subReport);
        return pk;
    }

    private boolean isNotSupportGroup(boolean isMergeByFiscalPeriod, boolean isSupport13Period, ReportInfo reportInfo) {
        return !isSupport13Period && !isMergeByFiscalPeriod && reportInfo.getPeriodType().equals((Object)RptPeriodTypeEnum.MONTHLY) && reportInfo.getPeriod() == 13;
    }

    private boolean[] batchgetParam(Context ctx) {
        return CSLParamUtil.batchGetParam((Context)ctx, (String[])new String[]{"GR_CSL_MergeByFiscalPeriod", "GR_CSL_Support13Period"});
    }

    private IObjectPK addnew(Context ctx, ReportInfo reportInfo, boolean isSupport13Period, boolean isMergeByFiscalPeriod, FormulaSoluInfo formulaSoluInfo) throws EASBizException, BOSException {
        if (this.isNotSupportGroup(isMergeByFiscalPeriod, isSupport13Period, reportInfo)) {
            reportInfo.setIsSupportGroup(IsSupportGroupReportEnum.NOTSUPPORT);
        }
        if (reportInfo.getSourceCurrency() == null) {
            reportInfo.setSourceCurrency(reportInfo.getCurrency());
        }
        this.addPeerCSLReport(ctx, reportInfo, isSupport13Period, isMergeByFiscalPeriod);
        IObjectPK pk = super._addnew(ctx, (IObjectValue)reportInfo);
        reportInfo.setId(BOSUuid.read((String)pk.toString()));
        ReportBaseCollection subReport = reportInfo.getSubReport();
        this.addSubReport(ctx, pk, subReport);
        if (formulaSoluInfo.getId() != null) {
            FormulaSoluCalcHelp.getInstance().saveReportUseFormula(pk.toString(), formulaSoluInfo.getId().toString(), formulaSoluInfo.getData());
        }
        return pk;
    }

    private void addPeerCSLReport(Context ctx, ReportInfo reportInfo, boolean isSupport13Period, boolean isMergeByFiscalPeriod) throws ReportException, EASBizException, BOSException {
        if (reportInfo.getSourceType() == RptSrcTypeEnum.DYNAMICNORMALREPORT || reportInfo.getSourceType() == RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT || RptSrcTypeEnum.COMMITREPORT == reportInfo.getSourceType() || RptSrcTypeEnum.SINGLEEXTRACTDATA == reportInfo.getSourceType()) {
            Object obj = reportInfo.get("rptautoweave_isfromgeextractdataf");
            if (this.canSaveGroupReport(ctx, reportInfo, isSupport13Period, isMergeByFiscalPeriod) || obj != null && Boolean.parseBoolean(obj.toString())) {
                CslReportInfo csl = this.copyReportInfoToGroup(ctx, reportInfo);
                reportInfo.setCslReport(csl);
                reportInfo.setIsSupportGroup(IsSupportGroupReportEnum.SUPPORT);
                if (RptSrcTypeEnum.SINGLEEXTRACTDATA == reportInfo.getSourceType()) {
                    ctx.put((Object)"rptautoweave_isfromgeextractdataf", (Object)"1");
                }
                this.updateCommittedStatus(ctx, reportInfo.getId().toString(), csl.getId().toString(), false);
            }
        }
    }

    private void addSubReport(Context ctx, IObjectPK sumReportPK, ReportBaseCollection subReport) throws BOSException, EASBizException {
        if (subReport != null && subReport.size() > 0) {
            ISumRptRela iSumRptRela = SumRptRelaFactory.getLocalInstance((Context)ctx);
            SumRptRelaInfo tempSumRptRelaInfo = null;
            int size = subReport.size();
            for (int i = 0; i < size; ++i) {
                tempSumRptRelaInfo = new SumRptRelaInfo();
                tempSumRptRelaInfo.setSumReportID(sumReportPK.toString());
                tempSumRptRelaInfo.setReportID(subReport.get(i).getId().toString());
                iSumRptRela.addnew((CoreBaseInfo)tempSumRptRelaInfo);
            }
        }
    }

    private void checkParamChange(ReportInfo info, Context ctx) throws EASBizException, BOSException {
        if (info.getId() != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("srcReport", (Object)info.getId().toString()));
            if (ReportFactory.getLocalInstance(ctx).exists(filter) || ConvertStatusEnum.Converted.equals((Object)info.getConvertStatus())) {
                SelectorItemCollection sc = new SelectorItemCollection();
                sc.add(new SelectorItemInfo("year"));
                sc.add(new SelectorItemInfo("period"));
                sc.add(new SelectorItemInfo("currency"));
                sc.add(new SelectorItemInfo("number"));
                sc.add(new SelectorItemInfo("name"));
                sc.add(new SelectorItemInfo("periodType"));
                ReportInfo oldInfo = ReportFactory.getLocalInstance(ctx).getReportInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)info.getId().toString())), sc);
                if (!(oldInfo.getCurrency().getId().equals((Object)info.getCurrency().getId()) && oldInfo.getYear() == info.getYear() && oldInfo.getPeriod() == info.getPeriod() && oldInfo.getPeriodType().equals((Object)info.getPeriodType()) && oldInfo.getNumber().equals(info.getNumber()) && oldInfo.getName().equals(info.getName()))) {
                    if (ConvertStatusEnum.Converted.equals((Object)info.getConvertStatus())) {
                        throw new ReportException(ReportException.CNOT_CG_PAM2);
                    }
                    throw new ReportException(ReportException.CNOT_CG_PAM);
                }
            }
        }
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        boolean isSupport13Period;
        ReportInfo reportInfo = (ReportInfo)model;
        boolean[] params = this.batchgetParam(ctx);
        boolean isMergeByFiscalPeriod = params[0];
        if (this.isNotSupportGroup(isMergeByFiscalPeriod, isSupport13Period = params[1], reportInfo)) {
            reportInfo.setIsSupportGroup(IsSupportGroupReportEnum.NOTSUPPORT);
        }
        this.checkParamChange(reportInfo, ctx);
        if (reportInfo.getConvertStatus().equals((Object)ConvertStatusEnum.BeforeConvert)) {
            reportInfo.setSourceCurrency(reportInfo.getCurrency());
        }
        if ((reportInfo.getSourceType() == RptSrcTypeEnum.DYNAMICNORMALREPORT || RptSrcTypeEnum.COMMITREPORT == reportInfo.getSourceType() || RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT == reportInfo.getSourceType()) && reportInfo.getIsSupportGroup() == IsSupportGroupReportEnum.SUPPORT) {
            if (!this.canSaveGroupReport(ctx, reportInfo, isSupport13Period, isMergeByFiscalPeriod)) {
                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getReportResource("CANNOT_SAVE_SAME_CONDITION_REPORT", ctx.getOriginLocale())});
            }
            CslReportInfo csl = this.copyReportInfoToGroup(ctx, reportInfo);
            this.updateCommittedStatus(ctx, reportInfo.getId().toString(), csl.getId().toString(), false);
            reportInfo.setCslReport(csl);
        }
        if (reportInfo.getPublicStatus().equals((Object)PublicStatusEnum.UNPUBLIC)) {
            ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
        }
        this.updateWithPermission(ctx, pk, model);
    }

    public void delSubReport(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StringBuffer _sql = new StringBuffer("delete from T_CSL_SumRptRela where");
        _sql.append(" FSumReportID= ?");
        Object[] params = new Object[]{pk.toString()};
        DbUtil.execute((Context)ctx, (String)_sql.toString(), (Object[])params);
    }

    @Override
    protected ReportBaseCollection _getSubReport(Context ctx, BOSUuid Id) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("reportID"));
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("sumReportID", (Object)Id.toString());
        filter.getFilterItems().add(filterItem);
        view.setFilter(filter);
        SumRptRelaCollection sumRptRelaCollection = SumRptRelaFactory.getLocalInstance((Context)ctx).getSumRptRelaCollection(view);
        HashSet<String> set = new HashSet<String>();
        ReportBaseCollection reportBaseCollection = new ReportBaseCollection();
        if (sumRptRelaCollection.size() > 0) {
            int size = sumRptRelaCollection.size();
            for (int i = 0; i < size; ++i) {
                set.add(sumRptRelaCollection.get(i).getReportID());
            }
            EntityViewInfo reportView = new EntityViewInfo();
            SelectorItemCollection reportsic = reportView.getSelector();
            reportsic.add(new SelectorItemInfo("id"));
            reportsic.add(new SelectorItemInfo("number"));
            reportsic.add(new SelectorItemInfo("name"));
            reportsic.add(new SelectorItemInfo("startDate"));
            reportsic.add(new SelectorItemInfo("year"));
            reportsic.add(new SelectorItemInfo("period"));
            reportsic.add(new SelectorItemInfo("periodType"));
            reportsic.add(new SelectorItemInfo("sourceType"));
            reportsic.add(new SelectorItemInfo("auditedStatus"));
            FilterInfo reportFilter = new FilterInfo();
            reportFilter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            reportView.setFilter(reportFilter);
            reportBaseCollection = ReportFactory.getLocalInstance(ctx).getReportBaseCollection(reportView);
        }
        return reportBaseCollection;
    }

    @Override
    protected void _submitWorkflow(Context ctx, BOSUuid id) throws BOSException {
    }

    @Override
    protected void _unSubmit(Context ctx, BOSUuid id) throws BOSException {
        String sql = "Update T_RPT_Report set FCommitTime=NULL where FID= ? ";
        Object[] param = new Object[]{id.toString()};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])param);
    }

    @Override
    protected void _submitUnAudite(Context ctx, BOSUuid id) throws BOSException {
    }

    @Override
    protected String _commitReport(Context ctx, String reportId) throws BOSException, EASBizException {
        ReportInfo report = this.getReportInfo(ctx, (IObjectPK)new ObjectStringPK(reportId), this.getSelectors());
        if (report.getCommittedStatus().getValue() == 2) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"report_commit_committed", (Locale)ctx.getOriginLocale())});
        }
        ICslReport csl = CslReportFactory.getLocalInstance((Context)ctx);
        String result = csl.commitReport((IObjectValue)report);
        return result;
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("committedStatus"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("sourceType"));
        sic.add(new SelectorItemInfo("cslReport"));
        ReportInfo report = this.getReportInfo(ctx, pk, sic);
        if (report.getCommittedStatus().equals((Object)CommittedStatusEnum.COMMITTED)) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"report_audit_committed", (Locale)ctx.getOriginLocale())});
        }
        super._audit(ctx, pk);
        if (report.getCslReport() != null) {
            ObjectStringPK cslpk = new ObjectStringPK(report.getCslReport().getId().toString());
            CslReportFactory.getLocalInstance((Context)ctx).audit((IObjectPK)cslpk);
        }
        this.updateCslReportAuditStatus(ctx, report);
    }

    private void updateCslReportAuditStatus(Context ctx, ReportInfo report) throws BOSException, SQLDataException {
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append("Select FAuditorId,FAuditedTime,FAuditedStatus,FCslReportID From T_Rpt_Report where fid = ? and FCslReportID is not null\n");
        params.add(report.getId().toString());
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        try {
            while (rs.next()) {
                sql = new StringBuffer();
                params.clear();
                if (rs.getString(1) != null) {
                    sql.append(" update T_Csl_CslReport set FauditorID = ?,FAuditedTime = ?,FAuditedStatus=? where FID = ?");
                    params.add(rs.getString(1));
                    params.add(rs.getDate(2));
                    params.add(new Integer(rs.getInt(3)));
                    params.add(rs.getString(4));
                } else {
                    sql.append(" update T_Csl_CslReport set FauditorID = null ,FAuditedTime = null,FAuditedStatus=?  where FID = ?");
                    params.add(new Integer(rs.getInt(3)));
                    params.add(rs.getString(4));
                }
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("committedStatus"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("sourceType"));
        sic.add(new SelectorItemInfo("cslReport"));
        ReportInfo report = this.getReportInfo(ctx, pk, sic);
        if (report.getCommittedStatus().equals((Object)CommittedStatusEnum.COMMITTED)) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"report_audit_committed", (Locale)ctx.getOriginLocale())});
        }
        this.updateCslReportAuditStatus(ctx, report);
        super._unAudit(ctx, pk);
        if (report.getCslReport() != null) {
            ObjectStringPK cslpk = new ObjectStringPK(report.getCslReport().getId().toString());
            CslReportFactory.getLocalInstance((Context)ctx).unAudit((IObjectPK)cslpk);
        }
    }

    protected OrgTreeInfo construstDispenseTemplate(Context ctx, CslReportInfo editData) throws EASBizException, BOSException {
        String currCompanyID = RptUtilForServer.getCurrentCompany(ctx).getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("orgBound.id"));
        sic.add(new SelectorItemInfo("sourceType"));
        sic.add(new SelectorItemInfo("dispenseSrcID"));
        sic.add(new SelectorItemInfo("isAllowChgTemplet"));
        sic.add(new SelectorItemInfo("isCoverTmpFormula"));
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("company.id", (Object)currCompanyID);
        FilterItemInfo filterItem2 = new FilterItemInfo("sourceType", (Object)Integer.valueOf("1"));
        FilterItemInfo filterItem3 = new FilterItemInfo("dispenseSrcID", (Object)editData.getTemplate().getId().toString());
        filter.getFilterItems().add(filterItem);
        filter.getFilterItems().add(filterItem2);
        filter.getFilterItems().add(filterItem3);
        view.setFilter(filter);
        TempletDispenseInfo templetDispenseInfo = null;
        TempletDispenseCollection templetDispenseCollection = TempletDispenseFactory.getLocalInstance((Context)ctx).getTempletDispenseCollection(view);
        if (templetDispenseCollection.size() > 0) {
            templetDispenseInfo = templetDispenseCollection.get(0);
            return templetDispenseInfo.getOrgBound();
        }
        return null;
    }

    @Override
    protected void _antiCommitReport(Context ctx, String cslReportID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append(" UPDATE T_RPT_Report\t\t\n");
        sql.append(" SET   \n");
        sql.append("\t FCommittedStatus = ?,\t\n");
        params.add(new Integer(1));
        sql.append("     fcommittime = ? ,\t\t\n");
        params.add(null);
        sql.append("\t FCheckedStatus = ?,\t\n");
        params.add(new Integer(1));
        sql.append("\t FAuditedStatus = ?,\t\n");
        params.add(new Integer(1));
        sql.append("     FAUDITEDTIME = ?\t,\t\n");
        params.add(null);
        sql.append("\t FPublishedStatus = ?\t\n");
        params.add(new Integer(1));
        sql.append(" WHERE FCslReportID = ? \t\n");
        params.add(cslReportID);
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
    }

    @Override
    protected void _calcIndex(Context ctx, String[] reportIds) throws BOSException, EASBizException {
        if (reportIds == null || reportIds.length == 0) {
            return;
        }
        IIndexData iIndexData = IndexDataFactory.getLocalInstance(ctx);
        IIndexItem iIndexItem = IndexItemFactory.getLocalInstance(ctx);
        ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        CtrlUnitInfo ctrlUnitInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        HashMap<String, CurrencyInfo> currencyMap = new HashMap<String, CurrencyInfo>();
        CurrencyCollection currencys = iCurrency.getCurrencyCollection();
        int size = currencys.size();
        for (int i = 0; i < size; ++i) {
            CurrencyInfo currency = currencys.get(i);
            currencyMap.put(currency.getIsoCode(), currency);
        }
        boolean isExistIndexItem = false;
        int rptSize = reportIds.length;
        for (int rptI = 0; rptI < rptSize; ++rptI) {
            BOSUuid templateId;
            IndexItemCollection indexItems;
            ReportInfo reportInfo = this.getReportInfo(ctx, (IObjectPK)new ObjectUuidPK(reportIds[rptI]), this.getSelectors());
            CurrencyInfo currency = reportInfo.getCurrency();
            if (reportInfo.getTemplate() == null || (indexItems = this.getIndexItems(iIndexItem, templateId = reportInfo.getTemplate().getId(), ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString())).size() == 0) continue;
            isExistIndexItem = true;
            Book book = null;
            try {
                book = reportInfo.getBook();
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            if (book == null || book.getSheetCount() == 0) continue;
            this.saveIndexData(iIndexData, ctrlUnitInfo, company, currencyMap, reportInfo, currency, indexItems, book, ctx);
        }
        if (!isExistIndexItem) {
            throw new ReportException(ReportException.TEMPLATE_NOT_EXIS_INDEXITEM);
        }
    }

    @Override
    protected void _calcIndex(Context ctx, byte[] data, String reportId) throws BOSException, EASBizException {
        IIndexData iIndexData = IndexDataFactory.getLocalInstance(ctx);
        IIndexItem iIndexItem = IndexItemFactory.getLocalInstance(ctx);
        ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        CtrlUnitInfo ctrlUnitInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        HashMap<String, CurrencyInfo> currencyMap = new HashMap<String, CurrencyInfo>();
        CurrencyCollection currencys = iCurrency.getCurrencyCollection();
        int size = currencys.size();
        for (int i = 0; i < size; ++i) {
            CurrencyInfo currency = currencys.get(i);
            currencyMap.put(currency.getIsoCode(), currency);
        }
        ReportInfo reportInfo = this.getReportInfo(ctx, (IObjectPK)new ObjectUuidPK(reportId), this.getSelectors());
        CurrencyInfo currency = reportInfo.getCurrency();
        if (reportInfo.getTemplate() == null) {
            return;
        }
        BOSUuid templateId = reportInfo.getTemplate().getId();
        IndexItemCollection indexItems = this.getIndexItems(iIndexItem, templateId, ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
        if (indexItems.size() == 0) {
            return;
        }
        reportInfo.setData(data);
        Book book = null;
        try {
            int flag = BookIOController.FLAG_VALU_AND_FORMULA | BookIOController.FLAG_SHEET_NAMES | BookIOController.FLAG_BOOK_NAMES;
            book = IOHelper.unpackBook(data, flag, "rpt_trans");
        }
        catch (Exception e) {
            logger.debug((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        this.saveIndexData(iIndexData, ctrlUnitInfo, company, currencyMap, reportInfo, currency, indexItems, book, ctx);
    }

    private IndexItemCollection getIndexItems(IIndexItem iIndexItem, BOSUuid templateId, String cu) throws BOSException {
        EntityViewInfo indexViewInfo = new EntityViewInfo();
        FilterInfo indexFilter = new FilterInfo();
        indexFilter.getFilterItems().add(new FilterItemInfo("templateId", (Object)templateId));
        indexFilter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(1)));
        SelectorItemCollection indexSelector = indexViewInfo.getSelector();
        indexSelector.add(new SelectorItemInfo("*"));
        indexSelector.add(new SelectorItemInfo("sheetParam.sheetID"));
        indexViewInfo.setFilter(indexFilter);
        IndexItemCollection indexItems = iIndexItem.getIndexItemCollection(indexViewInfo);
        RptUtil.checkIndexRefList(indexItems);
        return indexItems;
    }

    private void saveIndexData(IIndexData iIndexData, CtrlUnitInfo ctrlUnitInfo, CompanyOrgUnitInfo company, Map currencyMap, ReportInfo reportInfo, CurrencyInfo currency, IndexItemCollection indexItems, Book book, Context ctx) throws EASBizException, BOSException {
        if (book == null || book.getSheetCount() == 0) {
            return;
        }
        HashMap<String, Sheet> tableMap = new HashMap<String, Sheet>();
        HashMap<String, RptSheetParamInfo> sheetMap = new HashMap<String, RptSheetParamInfo>();
        int size = book.getSheetCount();
        for (int i = 0; i < size; ++i) {
            Sheet tempTable = book.getSheet(i);
            for (int j = 0; j < reportInfo.getSheetParam().size(); ++j) {
                if (!reportInfo.getSheetParam().get(j).getSheetID().equalsIgnoreCase(tempTable.getID())) continue;
                tableMap.put(tempTable.getID(), tempTable);
                sheetMap.put(tempTable.getID(), reportInfo.getSheetParam().get(j));
            }
        }
        ArrayList<String> cellValues = new ArrayList<String>();
        int size2 = indexItems.size();
        for (int i = 0; i < size2; ++i) {
            String cellValue;
            IndexItemInfo indexItem = indexItems.get(i);
            Rect rect = null;
            rect = indexItem.getCell().indexOf("!") >= 0 ? TableToolkit.range2xy(indexItem.getCell().substring(indexItem.getCell().indexOf("!") + 1)) : TableToolkit.range2xy(indexItem.getCell());
            RptSheetParamInfo sheetParams = (RptSheetParamInfo)sheetMap.get(indexItem.getSheetParam().getSheetID());
            Sheet table = (Sheet)tableMap.get(indexItem.getSheetParam().getSheetID());
            if (sheetParams == null || table == null) {
                cellValues.add(null);
                continue;
            }
            Cell cell = table.getCell(rect.getYBase(), rect.getXBase(), false);
            String string = cellValue = cell == null || cell.getValue() == null || cell.getValue().toString().length() == 0 ? " " : cell.getValue().toString();
            if (cellValue instanceof GregorianCalendar) {
                GregorianCalendar date = (GregorianCalendar)((Object)cellValue);
                String formula = cell.getFormula();
                if (formula != null && formula.indexOf("\"") > 0) {
                    try {
                        int first = formula.indexOf("\"");
                        int last = formula.indexOf("\"", first + 1);
                        String formats = formula.substring(first + 1, last).toLowerCase();
                        SimpleDateFormat format = new SimpleDateFormat(formats);
                        cellValue = format.format(date.getTime());
                    }
                    catch (Throwable a) {
                        String formats = "yyyy-MM-dd";
                        SimpleDateFormat format = new SimpleDateFormat(formats.toLowerCase());
                        cellValue = format.format(date.getTime());
                    }
                } else {
                    String formats = "yyyy-MM-dd";
                    SimpleDateFormat format = new SimpleDateFormat(formats.toLowerCase());
                    cellValue = format.format(date.getTime());
                }
            }
            cellValues.add(cellValue.toString());
        }
        int indexItemSize = indexItems.size();
        IndexDataCollection indexDataInfos = new IndexDataCollection();
        int j = 0;
        for (int i = 0; i < indexItemSize; ++i) {
            if (cellValues.get(j) == null) continue;
            IndexDataInfo indexDataInfo = new IndexDataInfo();
            IndexItemInfo indexItem = indexItems.get(i);
            currency = reportInfo.getCurrency();
            indexDataInfo.setCU(reportInfo.getCU());
            indexDataInfo.setIndexValue((String)cellValues.get(j));
            indexDataInfo.setIndexItem(indexItem);
            indexDataInfo.setStartYear(reportInfo.getYear());
            indexDataInfo.setEndYear(reportInfo.getYear());
            indexDataInfo.setStartPeriod(reportInfo.getPeriod());
            indexDataInfo.setEndPeriod(reportInfo.getPeriod());
            indexDataInfo.setSourceType(reportInfo.getSourceType());
            indexDataInfo.setCurrency(currency);
            indexDataInfo.setCompany(OrgUnitConvtHelper.convtFullToCompanyNotRemote((FullOrgUnitInfo)reportInfo.getCompany()));
            indexDataInfo.setReportID(reportInfo.getId().toString());
            indexDataInfos.add(indexDataInfo);
            ++j;
        }
        iIndexData.save(indexDataInfos, reportInfo.getId().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ArrayList _backCalcEx(Context ctx, IObjectValue reportInfo, byte[] data, int[] index) throws BOSException, EASBizException {
        try {
            Book b = null;
            b = reportInfo instanceof CslReportInfo || reportInfo instanceof ReportInfo ? IOHelper.unpackBook(data, "rpt_trans") : IOHelper.unpackBook(data);
            Book book = this.reportCalculate(ctx, reportInfo, null, b, index);
            ArrayList result = new ArrayList(book.getSheetCount());
            for (int i = 0; i < book.getSheetCount(); ++i) {
                if (index != null && index[i] < 0) {
                    result.add(null);
                    continue;
                }
                Sheet sheet = book.getSheet(i);
                if (sheet == null) {
                    result.add(null);
                    continue;
                }
                int rowcount = sheet.getMaxRowIndex();
                if (rowcount < 0) {
                    result.add(null);
                    continue;
                }
                ArrayList myBody = new ArrayList(rowcount);
                result.add(myBody);
                for (int j = 0; j <= rowcount; ++j) {
                    Row row = sheet.getRow(j, false);
                    if (row == null) {
                        myBody.add(null);
                        continue;
                    }
                    int colcount = row.getMaxIntMark();
                    if (colcount < 1) {
                        myBody.add(null);
                        continue;
                    }
                    ArrayList<Object> myRow = new ArrayList<Object>(colcount);
                    myBody.add(myRow);
                    for (int k = 0; k <= colcount; ++k) {
                        Cell cell = row.getCell(k, false);
                        if (cell == null) {
                            myRow.add(null);
                            continue;
                        }
                        Variant value = cell.getValue2();
                        Object obj = value.getValue();
                        if (obj instanceof BigDecimal) {
                            BigDecimal tmpCellValue = (BigDecimal)value.getValue();
                            if (tmpCellValue != null && tmpCellValue.scale() < 0) {
                                tmpCellValue = tmpCellValue.setScale(20, 0);
                            }
                            obj = tmpCellValue;
                        }
                        myRow.add(obj);
                    }
                }
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        catch (Exception ex) {
            logger.debug((Object)ex.getStackTrace(), (Throwable)ex);
        }
        finally {
            ReportCalculateErrorProvider.clear();
            RptCalculaterDAO.clearServerCache(ctx);
        }
        return null;
    }

    private void getBookFromKDF(KDF kdf, Book book) {
        int ii = 0;
        Iterator iter = kdf.getAllTable().iterator();
        int size = kdf.getAllTable().size();
        KDTable[] tbls = new KDTable[size];
        while (iter.hasNext()) {
            KDTable table = (KDTable)iter.next();
            table.getScriptManager().setAutoRun(false);
            table.setFormulaMode(1);
            tbls[ii] = table;
            ++ii;
        }
        new KdfToBook().getBook(book, tbls);
    }

    private Book reportCalculate(Context ctx, IObjectValue reportInfo, KDF kdf, Book book, int[] index) throws Exception {
        Book book2 = this.prepareCalculate(ctx, reportInfo, kdf, book, index);
        RptDataTogether rptDataTogether = null;
        if (reportInfo instanceof ReportBaseInfo) {
            rptDataTogether = this.startRecordRptData(ctx, (ReportBaseInfo)reportInfo, book2);
        }
        this.beforCaclFillYearInitData(ctx, reportInfo, book2);
        book2.calc();
        CslRptUtil.handleError((Book)book2);
        if (reportInfo instanceof ReportBaseInfo) {
            NewRptUtil.fillDItem((Context)ctx, (ReportBaseInfo)((ReportBaseInfo)reportInfo), (Book)book);
        }
        this.endRecordRptData(rptDataTogether);
        return book2;
    }

    private void beforCaclFillYearInitData(Context ctx, IObjectValue report, Book book) {
        try {
            ReportInfo reportInfo = (ReportInfo)report;
            if (reportInfo.getCslReport() == null) {
                return;
            }
            String cslrptid = reportInfo.getCslReport().getId().toString();
            CslReportInfo cslReportInfo = CslReportFactory.getLocalInstance((Context)ctx).getCslReportInfo((IObjectPK)new ObjectUuidPK(cslrptid));
            if ((cslReportInfo.getSourceType() == RptSrcTypeEnum.NORMAL || cslReportInfo.getSourceType() == RptSrcTypeEnum.DYNAMICNORMALREPORT || cslReportInfo.getSourceType() == RptSrcTypeEnum.COMMITREPORT) && cslReportInfo.getAdjustStatus().getValue() != 1) {
                boolean isAutoCalculate = book.isAutoCalculate();
                book.setAutoCalculate(false);
                this.fillYearInitData(ctx, cslReportInfo.getId().toString(), book);
                book.setAutoCalculate(isAutoCalculate);
            }
        }
        catch (Exception e) {
            logger.error((Object)"beforCaclFillYearInitData error", (Throwable)e);
        }
    }

    private void fillYearInitData(Context ctx, String reportId, Book book) throws Exception {
        List valueList = MaintainYearInitDataFacadeFactory.getLocalInstance((Context)ctx).getCellValueFromYearInitDataByReportID(reportId);
        if (valueList != null) {
            Iterator valueIt = valueList.iterator();
            HashMap valueMap = null;
            BigDecimal zero = new BigDecimal("0");
            while (valueIt.hasNext()) {
                Cell cell;
                String formula;
                valueMap = (HashMap)valueIt.next();
                BigDecimal value = null;
                int dc = (Integer)valueMap.get("RptItemDC");
                if (valueMap.get("Debit") != null && ((BigDecimal)valueMap.get("Debit")).compareTo(zero) != 0) {
                    value = ((BigDecimal)valueMap.get("Debit")).multiply(new BigDecimal(dc == 1 ? "1" : "-1"));
                }
                if (valueMap.get("Credit") != null && ((BigDecimal)valueMap.get("Credit")).compareTo(zero) != 0) {
                    value = ((BigDecimal)valueMap.get("Credit")).multiply(new BigDecimal(dc == 1 ? "-1" : "1"));
                }
                if (value == null || !StringUtils.isEmpty((String)(formula = (cell = book.getSheetByID((String)valueMap.get("RptItemSheetID")).getCell(((Integer)valueMap.get("RptItemPosY")).intValue(), ((Integer)valueMap.get("RptItemPosX")).intValue(), true)).getFormula())) && (formula.length() <= 0 || formula.charAt(0) == '=')) continue;
                int currencyScale = (Integer)valueMap.get("CurrencyPrecision");
                value = value.setScale(currencyScale, 4);
                cell.setValue(new Variant((Object)value));
            }
        }
    }

    private RptDataTogether startRecordRptData(Context ctx, ReportBaseInfo cslReportInfo, Book book) {
        logger.info((Object)"[rptData]start backCalc-normal rpt");
        RptDataTogether instance = null;
        boolean isRecord = false;
        try {
            isRecord = CslRptUtil.getCslParam((Context)ctx, (String)"IsRecordRptData");
            if (isRecord) {
                Timestamp currTime = new Timestamp(System.currentTimeMillis());
                instance = new RptDataTogether(ctx);
                RptDataInfo rptDataInfo = new RptDataInfo(ctx, cslReportInfo, this.getAllMethods(book));
                rptDataInfo.setId(BOSUuid.create((BOSObjectType)rptDataInfo.getBOSType()));
                rptDataInfo.setCalcStartTime(currTime);
                if (rptDataInfo.getUserId() != null) {
                    IUser userDB = UserFactory.getLocalInstance((Context)ctx);
                    UserInfo userInfo = userDB.getUserInfo("select number,name where id = '" + rptDataInfo.getUserId().toString() + "'");
                    rptDataInfo.setUserNumber(userInfo.getNumber());
                    rptDataInfo.setUserName(userInfo.getName());
                }
                if (isRecord = instance.register(rptDataInfo)) {
                    instance.startRecordForServer(currTime);
                } else {
                    instance = null;
                }
            }
        }
        catch (Exception e1) {
            logger.error((Object)"", (Throwable)e1);
            instance = null;
        }
        return instance;
    }

    private Map<String, Integer> getAllMethods(Book book) {
        return BookFormulaHelper.statBook((Book)book).getFunctionMap();
    }

    private void endRecordRptData(RptDataTogether instance) {
        if (instance == null) {
            return;
        }
        try {
            instance.endRecordForAll();
            logger.info((Object)"[rptData]end backCalc-normal rpt");
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private Book prepareCalculate(Context ctx, IObjectValue reportInfo, KDF kdf, Book book, int[] index) throws Exception {
        if (book == null) {
            book = Book.Manager.getNewBook(null, (int)0);
        }
        BookProperties p = BookProperties.loadFromBook(book);
        ReportCalculateContext calcContext = new ReportCalculateContext(ctx);
        if (reportInfo instanceof com.kingdee.eas.ma.budget.BgFormInfo) {
            calcContext.setErrorProvider((IErrorProvider)p.getErrorProvider());
            calcContext.setReportVariables(p.getVariables());
            calcContext.setReportAdapter((IReportPropertyAdapter)new BgRptReportPropertyAdapter((com.kingdee.eas.ma.budget.BgFormInfo)reportInfo));
        } else if (reportInfo instanceof BgFormInfo) {
            calcContext.setErrorProvider((IErrorProvider)p.getErrorProvider());
            calcContext.setReportVariables(p.getVariables());
            calcContext.setReportAdapter((IReportPropertyAdapter)new com.kingdee.eas.ma.mbg.utils.BgRptReportPropertyAdapter((BgFormInfo)reportInfo));
        } else if (reportInfo instanceof BgActualRecordInfo) {
            calcContext.setErrorProvider((IErrorProvider)p.getErrorProvider());
            calcContext.setReportVariables(p.getVariables());
            calcContext.setReportAdapter((IReportPropertyAdapter)new BgActualRecordPropertyAdapter((BgActualRecordInfo)reportInfo));
        } else if (reportInfo instanceof com.kingdee.eas.ma.mbg.BgActualRecordInfo) {
            calcContext.setErrorProvider((IErrorProvider)p.getErrorProvider());
            calcContext.setReportVariables(p.getVariables());
            calcContext.setReportAdapter((IReportPropertyAdapter)new com.kingdee.eas.ma.mbg.utils.BgActualRecordPropertyAdapter((com.kingdee.eas.ma.mbg.BgActualRecordInfo)reportInfo));
        } else if (reportInfo instanceof ReportInfo) {
            ReportInfo report = (ReportInfo)reportInfo;
            if (report.getPeriodType() == null) {
                report.setPeriodType(RptPeriodTypeEnum.MONTHLY);
            }
            ReportCalculateErrorProvider errorhandler = null;
            errorhandler = (ReportCalculateErrorProvider)reportInfo.get("RPT_ERRORHANDLER");
            if (errorhandler != null) {
                calcContext.setErrorProvider((IErrorProvider)errorhandler);
            } else {
                calcContext.setErrorProvider((IErrorProvider)p.getErrorProvider());
            }
            BookProperties bookProperties = BookProperties.loadFromBook(book);
            calcContext.setReportVariables(bookProperties.getVariables());
            calcContext.setReportAdapter((IReportPropertyAdapter)new RptReportPropertyAdapter(report));
        }
        FormulaDefinition.registerFormulaToBook((Book)book, (ICalculateContextProvider)calcContext);
        book.getUndoManager().enable(false);
        book.setCalculate(false);
        int ii = 0;
        if (kdf != null) {
            this.getBookFromKDF(kdf, book);
        } else {
            List tbls = (List)reportInfo.get("FORMULA_DATA");
            if (tbls != null) {
                List sheetKeys = (List)reportInfo.get("keys");
                List names = (List)tbls.remove(0);
                int size = tbls.size();
                for (ii = 0; kdf == null && ii < size; ++ii) {
                    List tbl;
                    Sheet sheet = book.getSheet((String)names.get(ii));
                    if (sheet == null) {
                        sheet = new Sheet(book, (String)names.get(ii));
                        book.insertSheet(ii, sheet);
                    }
                    if (sheetKeys != null) {
                        sheet.setUserObject("keys", sheetKeys.get(ii));
                    }
                    if (index != null && index[ii] < 0) {
                        sheet.setEnableCalculation(false);
                    }
                    if ((tbl = (List)tbls.get(ii)) == null) continue;
                    for (int j = 0; j < tbl.size(); ++j) {
                        List row = (List)tbl.get(j);
                        Row row2 = sheet.getRow(j, true);
                        if (row == null) continue;
                        for (int k = 0; k < row.size(); ++k) {
                            Cell cell = row2.getCell(k, true);
                            Object obj = row.get(k);
                            if (obj instanceof String) {
                                String s = (String)obj;
                                if (StringUtils.isEmpty((String)s)) continue;
                                cell.setFormula(s);
                                continue;
                            }
                            cell.setValue(new Variant(obj));
                        }
                    }
                }
            }
        }
        book.getUndoManager().enable(false);
        return book;
    }

    private void registerFunctionProviders(Context ctx, IObjectValue reportInfo, Book book) throws BOSException {
        Dependents deps = book.getDeps();
        ReportCalculateErrorProvider errorhandler = null;
        errorhandler = (ReportCalculateErrorProvider)reportInfo.get("RPT_ERRORHANDLER");
        deps.getFunctionManager().setErrorProvider(EASBizException.class, (IErrorProvider)errorhandler);
        ReportCalculateErrorProvider.clear();
        ReportCalculateErrorProvider.addErrorProvider(EASBizException.class, (IErrorProvider)errorhandler);
        ReportCalculatorProvider provider = new ReportCalculatorProvider(ctx);
        ReportCalculateContext calcContext = new ReportCalculateContext(ctx);
        provider.initCalculateContext((ICalculateContextProvider)calcContext);
        deps.getFunctionManager().addFunctionProvider((Object)provider, true);
        ReportBatchCalculateProvider rptBatchCalc = new ReportBatchCalculateProvider(ctx, (ReportBaseInfo)reportInfo);
        deps.getFunctionManager().addFunctionProvider((Object)rptBatchCalc, true);
        ReportBatchCalculatorImpl batchCalculatorImpl = new ReportBatchCalculatorImpl();
        ReportInfo report = (ReportInfo)reportInfo.cast(ReportInfo.class);
        if (report.getPeriodType() == null) {
            report.setPeriodType(RptPeriodTypeEnum.MONTHLY);
        }
        if (reportInfo instanceof com.kingdee.eas.ma.budget.BgFormInfo) {
            calcContext.setReportAdapter((IReportPropertyAdapter)new BgRptReportPropertyAdapter((com.kingdee.eas.ma.budget.BgFormInfo)reportInfo));
        } else {
            calcContext.setReportAdapter((IReportPropertyAdapter)new RptReportPropertyAdapter(report));
        }
        calcContext.setErrorProvider((IErrorProvider)errorhandler);
        calcContext.setReportVariables(VariablesHelper.sheetParams2Variables((ReportInfo)report));
        batchCalculatorImpl.initCalculateContext((ICalculateContextProvider)calcContext);
        deps.getFunctionManager().addFunctionProvider((Object)batchCalculatorImpl, true);
        BgBatchCalculatorImpl bgBatch = new BgBatchCalculatorImpl();
        ReportCalculateContext bgCalcContext = new ReportCalculateContext(ctx);
        if (reportInfo instanceof com.kingdee.eas.ma.budget.BgFormInfo) {
            bgCalcContext.setReportAdapter((IReportPropertyAdapter)new BgRptReportPropertyAdapter((com.kingdee.eas.ma.budget.BgFormInfo)reportInfo));
        } else {
            bgCalcContext.setReportAdapter((IReportPropertyAdapter)new RptReportPropertyAdapter(report));
        }
        bgCalcContext.setErrorProvider((IErrorProvider)errorhandler);
        bgCalcContext.setReportVariables(VariablesHelper.sheetParams2Variables((ReportInfo)report));
        bgBatch.initCalculateContext((ICalculateContextProvider)bgCalcContext);
        deps.getFunctionManager().addFunctionProvider((Object)bgBatch, true);
    }

    @Override
    protected ArrayList _reportCheck(Context ctx, IObjectValue reportInfo, String currentSheetName) throws BOSException {
        try {
            ReportBaseInfo report = (ReportBaseInfo)reportInfo;
            Book book1 = null;
            if (report.getData() != null) {
                book1 = report.getBook();
            }
            Book book = this.prepareCalculate(ctx, reportInfo, null, book1, null);
            RptOperationSchemaComp comp = null;
            BookProperties bp = BookProperties.loadFromBook(book);
            if (bp != null && bp.getVariables() != null) {
                bp.getVariables().add(new VariableEntry("Check_Permissioin", null, 1, "false", false));
            }
            comp = report.get("operationSchemas") != null ? (RptOperationSchemaComp)report.get("operationSchemas") : bp.getOperationSchema();
            ArrayList<Object> list = new ArrayList<Object>(1);
            ReportCheck checker = null;
            checker = currentSheetName != null ? new ReportCheck(book, comp.getExpTank(), ctx.getLocale(), currentSheetName) : new ReportCheck(book, comp.getExpTank(), ctx.getLocale());
            String s = checker.check();
            if (s != null) {
                list.add(Boolean.FALSE);
            } else {
                list.add(Boolean.TRUE);
            }
            list.add(new Integer(checker.getExpressionCount()));
            list.add(s);
            return list;
        }
        catch (Exception _) {
            logger.debug((Object)_.getMessage());
            throw new BOSException((Throwable)_);
        }
    }

    @Override
    protected ArrayList _reportCheck(Context ctx, IObjectValue reportInfo) throws BOSException {
        return this._reportCheck(ctx, reportInfo, null);
    }

    /*
     * Loose catch block
     */
    @Override
    protected BigDecimal _calcFomula(Context ctx, IObjectValue reportInfo, String formula) throws BOSException {
        Variant res;
        block9: {
            Book book = Book.Manager.getNewBook(null, (int)1);
            ReportCalculateErrorProvider errorhandler = null;
            errorhandler = (ReportCalculateErrorProvider)reportInfo.get("RPT_ERRORHANDLER");
            ReportCalculateErrorProvider.clear();
            ReportCalculateErrorProvider.addErrorProvider(EASBizException.class, (IErrorProvider)errorhandler);
            ReportCalculateContext calcContext = new ReportCalculateContext(ctx);
            ReportInfo report = (ReportInfo)reportInfo.cast(ReportInfo.class);
            if (report.getPeriodType() == null) {
                report.setPeriodType(RptPeriodTypeEnum.MONTHLY);
            }
            calcContext.setReportAdapter((IReportPropertyAdapter)new RptReportPropertyAdapter(report));
            calcContext.setErrorProvider((IErrorProvider)errorhandler);
            ReportVariables iv = VariablesHelper.sheetParams2Variables((ReportInfo)report);
            for (int i = 0; i < iv.getAllVariables().size(); ++i) {
                ((VariableEntry)iv.getAllVariables().get(i)).setSheetName(book.getSheet(0).getSheetName());
            }
            calcContext.setReportVariables(iv);
            FormulaDefinition.registerFormulaToBook((Book)book, (ICalculateContextProvider)calcContext);
            book.getUndoManager().enable(false);
            book.setCalculate(false);
            book.getUndoManager().enable(true);
            res = null;
            book.getSheet(0).getCell(0, 0, true).setFormula(formula);
            book.getSheet(0).calc();
            res = book.getSheet(0).getCell(0, 0, true).getValue();
            if (res == null) {
                return null;
            }
            if (res.toString() == null) break block9;
            if (res.toString().equalsIgnoreCase("false")) {
                return null;
            }
            if (!res.toString().equalsIgnoreCase("true")) break block9;
            return null;
            {
                catch (Exception _) {
                    logger.debug((Object)_.getMessage());
                    return null;
                }
            }
        }
        try {
            return res.toBigDecimal();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected void _updateWithPermission(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ReportInfo reportInfo = (ReportInfo)model;
        if (!CslRptUtil.isSupport13Period((Context)ctx) && !CslRptUtil.isMergeByFiscalPeriod((Context)ctx) && reportInfo.getPeriodType().equals((Object)RptPeriodTypeEnum.MONTHLY) && reportInfo.getPeriod() == 13) {
            reportInfo.setIsSupportGroup(IsSupportGroupReportEnum.NOTSUPPORT);
        }
        super._update(ctx, pk, (IObjectValue)reportInfo);
        ReportBaseCollection subReport = reportInfo.getSubReport();
        if (reportInfo.getSourceType() == RptSrcTypeEnum.SUM) {
            this.delSubReport(ctx, pk);
            this.addSubReport(ctx, pk, subReport);
        }
    }

    @Override
    protected void _deleteWithPermission(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ReportInfo reportInfo = (ReportInfo)model;
        ObjectUuidPK pk = new ObjectUuidPK(reportInfo.getId());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcReport", (Object)pk.toString()));
        if (ReportFactory.getLocalInstance(ctx).exists(filter)) {
            throw new ReportException(ReportException.CAN_NOT_DELETE);
        }
        this.delReportCheck(ctx, (IObjectPK)pk);
        this.delIndexData(ctx, (IObjectPK)pk);
        if (reportInfo.getSourceType().equals((Object)RptSrcTypeEnum.COMMOMSUM)) {
            this.deleteSumRelation(ctx, (IObjectPK)pk);
        }
        super._delete(ctx, (IObjectPK)pk);
        AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
        asm.deleteAttachemtsByBoID(pk.toString());
    }

    @Override
    protected List _reportBatchCheck(Context ctx, List ids) throws BOSException, EASBizException {
        ReportCollection reports = this.getReportStatusById(ctx, ids);
        ReportInfo r = null;
        ArrayList<Object> result = new ArrayList<Object>(reports.size());
        boolean needGetMsg = false;
        ArrayList<ReportInfo> rptlist = new ArrayList<ReportInfo>();
        for (int i = 0; i < reports.size(); ++i) {
            r = reports.get(i);
            if ((r.getSourceType() == RptSrcTypeEnum.COMMITREPORT || r.getSourceType() == RptSrcTypeEnum.DYNAMICNORMALREPORT || r.getSourceType() == RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT) && IsSupportGroupReportEnum.SUPPORT.equals((Object)r.getIsSupportGroup())) {
                needGetMsg = true;
                rptlist.add(r);
                continue;
            }
            this.updateScheme(ctx, (IObjectValue)r);
            ArrayList checked = ReportCheck.checkReport(ctx, r, null);
            HashMap<String, Object> rst = new HashMap<String, Object>();
            if (checked != null) {
                rst.put("CHECKPASSED", checked.get(0));
                rst.put("CHECKCOUNT", checked.get(1));
                rst.put("CHECKMSG", checked.get(2));
                rst.put("REPORTID", r.getId().toString());
            }
            ArrayList list = new ArrayList();
            ArrayList innerList = new ArrayList();
            HashMap map = new HashMap();
            result.add(rst);
            for (int j = checked.size() - 1; j >= 0; --j) {
                if (!(checked.get(j) instanceof HashMap)) continue;
                innerList.add(checked.get(j));
                map.put("tableInnerCheck", innerList);
                list.add(map);
            }
            result.add(list);
        }
        if (needGetMsg) {
            ArrayList msgs = CslReportFactory.getLocalInstance((Context)ctx).preCheckReport(rptlist);
            for (int i = 0; msgs != null && i < msgs.size(); ++i) {
                Map map = (Map)msgs.get(i);
                if (map == null || map.get("KEY_ID") == null) continue;
                Object removed = map.remove("KEY_ID");
                for (int f = 0; f < rptlist.size(); ++f) {
                    ReportInfo ri = (ReportInfo)rptlist.get(f);
                    if (!removed.toString().equalsIgnoreCase(ri.getCslReport().getId().toString())) continue;
                    removed = ri.getId().toString();
                }
                map.put("REPORTID", removed);
                map.put("CHECKPASSED", map.remove("KEY_CHECK_FLAG"));
                map.put("CHECKMSG", map.remove("KEY_CHECK_MESSAGE"));
                result.add(map);
            }
            if (msgs == null) {
                msgs = new ArrayList(0);
            }
            result.add(msgs);
        }
        return result;
    }

    private ReportCollection getReportStatusById(Context ctx, List ids) throws BOSException {
        HashSet set = new HashSet(ids);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selectors = this.getSelectors2();
        SelectorItemCollection selector = view.getSelector();
        Iterator i = selectors.iterator();
        while (i.hasNext()) {
            selector.add((SelectorItemInfo)i.next());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        view.setFilter(filter);
        return this.getReportCollection(ctx, view);
    }

    protected void _unCommitReport(Context ctx, List idList) throws BOSException, EASBizException {
    }

    @Override
    protected void _setReportForGroup(Context ctx, List idList) throws BOSException, EASBizException {
        StringBuffer exceptionBuffer = new StringBuffer();
        for (int i = 0; i < idList.size(); ++i) {
            String pk = idList.get(i).toString();
            ReportInfo info = this.getReportInfo(ctx, (IObjectPK)new ObjectUuidPK(pk), this.getSelectors());
            try {
                this.setOneReportForGroup(ctx, info);
                continue;
            }
            catch (Exception e) {
                exceptionBuffer.append(e.getMessage()).append('\n');
            }
        }
        if (exceptionBuffer.length() > 0) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, new Object[]{exceptionBuffer});
        }
    }

    private void setOneReportForGroup(Context ctx, ReportInfo info) throws EASBizException, BOSException {
        ReportCollection c = this.getGroupReport(ctx, info);
        if (c.size() > 0) {
            ReportInfo theReport = c.get(0);
            if (theReport.getCommittedStatus() != CommittedStatusEnum.UNCOMMITTED) {
                throw new ReportException(ReportException.COMMON_EXCEPTION, new Object[]{RptUtil.getReportResource("CANNOT_SET_SAME_REPORT", ctx.getOriginLocale()) + " " + info.getTemplate().getName() + " " + RptUtil.getReportResource("ALREADY_COMMITTED", ctx.getOriginLocale())});
            }
            this.updateCommittedStatus(ctx, theReport.getId().toString(), theReport.getCslReport().getId().toString(), true);
            CslReportFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(theReport.getCslReport().getId()), true);
        } else {
            int sourceType = info.getReportSourceType().getValue();
            sourceType = sourceType == 7 ? 1 : sourceType;
            ITempletDispense ie = TempletDispenseFactory.getLocalInstance((Context)ctx);
            String cslRptId = ie.getReportByTmpVersion2(null, info.getCompany().getId().toString(), info.getCurrency().getId().toString(), info.getTemplate().getId().toString(), sourceType, info.getPeriodType().getValue(), info.getYear(), (int)info.getPeriod(), null, info.getDataCollectNumber());
            if (cslRptId != null) {
                throw new ReportException(ReportException.COMMON_EXCEPTION, new Object[]{RptUtil.getReportResource("CANNOT_SET_SAME_REPORT", ctx.getOriginLocale()) + " " + info.getTemplate().getName() + " " + RptUtil.getResourceSince51("CslReportBatchExistsSupportGroup")});
            }
        }
        String cslid = null;
        if (info.getCslReport() == null) {
            CslReportInfo csl = ReportToGroupHelper.copyReportInfoToGroup(ctx, info);
            cslid = csl.getId().toString();
        } else {
            cslid = info.getCslReport().getId().toString();
        }
        this.updateCommittedStatus(ctx, info.getId().toString(), cslid, false, info.getAuditedStatus());
        if (info.getAuditedStatus() == AuditedStatusEnum.AUDITED) {
            this.updateCslrptStatus(ctx, cslid, info.getAuditedStatus());
        }
    }

    private void updateCslrptStatus(Context ctx, String cslid, AuditedStatusEnum auditedStatus) throws BOSException {
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append(" UPDATE T_CSL_CSLReport  set  \n");
        sql.append(" \t FAuditedStatus = ? \t\n");
        params.add(new Integer(auditedStatus.getValue()));
        sql.append(" WHERE FID = ?\t\t\t\t\n");
        params.add(cslid);
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
    }

    private ReportCollection getGroupReport(Context ctx, ReportInfo info) throws BOSException {
        String dataCollectNumber;
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("periodType", (Object)info.getPeriodType().getValue()));
        if (info.getPeriodType().equals((Object)RptPeriodTypeEnum.DAILY)) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("startDate", (Object)info.getStartDate()));
            view.getFilter().getFilterItems().add(new FilterItemInfo("endDate", (Object)info.getEndDate()));
        } else if (info.getPeriodType().equals((Object)RptPeriodTypeEnum.YEARLY)) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("year", (Object)new Integer(info.getYear())));
        } else {
            view.getFilter().getFilterItems().add(new FilterItemInfo("year", (Object)new Integer(info.getYear())));
            view.getFilter().getFilterItems().add(new FilterItemInfo("period", (Object)new Short(info.getPeriod())));
        }
        view.getFilter().getFilterItems().add(new FilterItemInfo("template.group", (Object)info.getTemplate().getGroup()));
        view.getFilter().getFilterItems().add(new FilterItemInfo("company", (Object)info.getCompany().getId().toString()));
        view.getFilter().getFilterItems().add(new FilterItemInfo("currency", (Object)info.getCurrency().getId().toString()));
        if (info.getSourceCurrency() != null) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("sourceCurrency", (Object)info.getSourceCurrency().getId().toString()));
        } else {
            view.getFilter().getFilterItems().add(new FilterItemInfo("sourceCurrency", null));
        }
        view.getFilter().getFilterItems().add(new FilterItemInfo("isSupportGroup", (Object)new Integer(1)));
        if (info.getId() != null) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (!StringUtils.isEmpty((String)(dataCollectNumber = info.getDataCollectNumber()))) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("dataCollectNumber", (Object)dataCollectNumber));
        }
        view.getFilter().getFilterItems().add(new FilterItemInfo("sourcetype", (Object)100, CompareType.NOTEQUALS));
        SelectorItemCollection sitem = view.getSelector();
        sitem.add("CommittedStatus");
        sitem.add("CslReport.id");
        ReportCollection c = this.getReportCollection(ctx, view);
        return c;
    }

    private boolean canSaveGroupReport(Context ctx, ReportInfo info, boolean isSupport13Period, boolean isMergeByFiscalPeriod) throws BOSException {
        Object formulaCalcId = info.get("KEY_FORMULACALCID");
        if (formulaCalcId != null && !StringUtils.isEmpty((String)((String)formulaCalcId))) {
            return true;
        }
        if (!isSupport13Period && !isMergeByFiscalPeriod && info.getPeriodType().equals((Object)RptPeriodTypeEnum.MONTHLY) && info.getPeriod() == 13) {
            return false;
        }
        ReportCollection c = this.getGroupReport(ctx, info);
        return c.size() <= 0;
    }

    private void updateCommittedStatus(Context ctx, String id, String cslID, boolean isCancelPreCommit, AuditedStatusEnum audit) throws BOSException {
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append(" UPDATE T_RPT_Report  set  \n");
        if (audit != null) {
            sql.append(" \t FAuditedStatus = ?, \t\n");
            params.add(new Integer(audit.getValue()));
        }
        sql.append(" \t FIsSupportGroup = ?, \t\n");
        if (isCancelPreCommit) {
            params.add(new Integer(2));
            sql.append("\t FCslReportID = null\t\t\n");
        } else {
            if (ctx.get((Object)"rptautoweave_isfromgeextractdataf") != null) {
                params.add(new Integer(2));
            } else {
                params.add(new Integer(1));
            }
            sql.append("\t FCslReportID =? \t\n");
            params.add(cslID);
        }
        sql.append(" WHERE FID ='").append(id).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
    }

    private void updateCommittedStatus(Context ctx, String id, String cslID, boolean isCancelPreCommit) throws BOSException {
        this.updateCommittedStatus(ctx, id, cslID, isCancelPreCommit, null);
    }

    private CslReportInfo copyReportInfoToGroup(Context ctx, ReportInfo report) throws EASBizException, BOSException {
        CslReportInfo result = this.rpt2CslRpt(ctx, report);
        if (report.getCslReport() == null || report.getCslReport().getId() == null) {
            report.setCslReport(this.getSameCSLReportInfo(ctx, report));
        }
        UserInfo commitor = null;
        if (report.getCslReport() != null && report.getCslReport().getId() != null) {
            BOSUuid cslid = report.getCslReport().getId();
            result.setId(cslid);
            this.updateCommittedStatus(ctx, report.getId().toString(), cslid.toString(), true);
            if (report.getCslReport().getCommitor() != null) {
                commitor = report.getCslReport().getCommitor();
            }
            CslReportFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(cslid), true);
        }
        result.setId(null);
        result.setIsSchemeUpdate(report.isIsSchemeUpdate());
        result.setCommitor(commitor);
        IObjectPK pk = CslReportFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)result);
        result.setId(BOSUuid.read((String)pk.toString()));
        return result;
    }

    private CslReportInfo getSameCSLReportInfo(Context ctx, ReportInfo report) throws EASBizException, BOSException {
        Object obj;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)report.getCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("currency", (Object)report.getCurrency().getId().toString()));
        if (report.getSourceCurrency() != null) {
            filter.getFilterItems().add(new FilterItemInfo("sourceCurrency", (Object)report.getSourceCurrency().getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("sourceCurrency", (Object)report.getCurrency().getId().toString()));
        }
        String group = report.getTemplate().getGroup();
        if (group == null || group.length() == 0) {
            ITemplate it = TemplateFactory.getLocalInstance(ctx);
            ObjectUuidPK templatePk = new ObjectUuidPK(report.getTemplate().getId().toString());
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("group"));
            TemplateInfo template = it.getTemplateInfo((IObjectPK)templatePk, sic);
            group = template.getGroup();
            if (group == null || group.length() == 0) {
                throw new BOSException("group is null");
            }
        }
        filter.getFilterItems().add(new FilterItemInfo("template.group", (Object)group));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)new Integer(report.getPeriodType().getValue())));
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)new Integer(report.getYear())));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(report.getPeriod())));
        int sourceType = report.getSourceType().getValue();
        if (7 == sourceType || 1 == sourceType) {
            HashSet<Integer> types = new HashSet<Integer>();
            types.add(new Integer(7));
            types.add(new Integer(1));
            filter.getFilterItems().add(new FilterItemInfo("sourceType", types, CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("sourceType", (Object)new Integer(sourceType)));
        }
        filter.getFilterItems().add(new FilterItemInfo("isSaveAs", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("adjustStatus", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("IsCommitReport", (Object)Boolean.TRUE));
        String dataCollectNumber = report.getDataCollectNumber();
        if (dataCollectNumber != null && !dataCollectNumber.equals("")) {
            filter.getFilterItems().add(new FilterItemInfo("dataCollectNumber", (Object)dataCollectNumber, CompareType.EQUALS));
        }
        if ((obj = report.get("rptautoweave_isfromgeextractdataf")) != null && Boolean.parseBoolean(obj.toString())) {
            filter.getFilterItems().add(new FilterItemInfo("sourceType", (Object)100));
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.getSelector().add("id");
        CslReportCollection coll = CslReportFactory.getLocalInstance((Context)ctx).getCslReportCollection(view);
        return coll != null && coll.size() > 0 ? coll.get(0) : null;
    }

    private DataCollectInfo getDataCollectByNumber(Context ctx, String number) throws BOSException, EASBizException {
        IDataCollect iDataCollect = DataCollectFactory.getLocalInstance((Context)ctx);
        DataCollectInfo dataCollectInfo = iDataCollect.getDataCollectInfo("where number = '" + number + "'");
        return dataCollectInfo;
    }

    private CslReportInfo rpt2CslRpt(Context ctx, ReportInfo report) throws EASBizException, BOSException {
        int i;
        Object objFormulaCalc;
        CslReportInfo cslReport = new CslReportInfo();
        cslReport.setOrgUnit(report.getCompany().castToFullOrgUnitInfo());
        cslReport.setSourceCurrency(report.getCurrency());
        cslReport.setReportDate(DateTimeUtils.truncateDate((Date)report.getEndDate()));
        cslReport.setDataCollectNumber(report.getDataCollectNumber());
        cslReport.setDataCollect(report.getDataCollect());
        cslReport.setIsCommitReport(true);
        cslReport.setRptFrom(report.getRptFrom());
        cslReport.setYear(report.getYear());
        short period = report.getPeriod();
        if (report.getEndDate() != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(report.getEndDate());
            if (RptPeriodTypeEnum.DAILY.equals((Object)report.getPeriodType()) || RptPeriodTypeEnum.YEARLY.equals((Object)report.getPeriodType())) {
                period = (short)RPTDateUtil.getPeriod((int)calendar.get(1), (int)(calendar.get(2) + 1), (int)calendar.get(5), (RptPeriodTypeEnum)report.getPeriodType());
            }
        }
        cslReport.setPeriod(period);
        cslReport.setStartDate(report.getStartDate());
        cslReport.setEndDate(report.getEndDate());
        cslReport.setAuditor(report.getAuditor());
        cslReport.setTemplate(report.getTemplate());
        cslReport.setCompany(report.getCompany());
        cslReport.setDynaRptType(report.getTemplate().getDynaRptType());
        cslReport.setPeriodType(report.getPeriodType());
        cslReport.setPublicStatus(report.getPublicStatus());
        cslReport.setPublishedStatus(PublishedStatusEnum.UNPUBLISHED);
        cslReport.setCommittedStatus(CommittedStatusEnum.UNCOMMITTED);
        if (!RptSrcTypeEnum.DYNAMICNORMALREPORT.equals((Object)report.getSourceType()) && !RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT.equals((Object)report.getSourceType())) {
            cslReport.setSourceType(RptSrcTypeEnum.NORMAL);
        } else if (RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT.equals((Object)report.getSourceType())) {
            cslReport.setSourceType(RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT);
        } else {
            cslReport.setSourceType(RptSrcTypeEnum.DYNAMICNORMALREPORT);
        }
        if (report.getSourceType().equals((Object)RptSrcTypeEnum.SINGLEEXTRACTDATA)) {
            cslReport.setSourceType(RptSrcTypeEnum.SINGLEEXTRACTDATA);
        }
        cslReport.setCurrency(report.getCurrency());
        cslReport.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        cslReport.setZipData(report.getZipData());
        if (report.getCurBook() != null) {
            cslReport.setCurBook(report.getCurBook());
        }
        cslReport.setFormulaCalc((objFormulaCalc = report.get("rptautoweave_extractdatafid")) == null ? null : (FormulaCalcContextInfo)objFormulaCalc);
        RptSheetParamCollection srcCol = (RptSheetParamCollection)((Object)report.getSheetParam().clone());
        RptSheetParamInfo paramInfo = null;
        int n = srcCol.size();
        for (i = 0; i < n; ++i) {
            paramInfo = srcCol.get(i);
            paramInfo.setRelaType(ReportTypeEnum.REPORT);
            paramInfo.setStatus(1);
            paramInfo.setId(null);
            paramInfo.setReport((VirtualSheetParamInfo)cslReport);
            if (paramInfo.getPostils() == null || paramInfo.getPostils().size() <= 0) continue;
            int j = paramInfo.getPostils().size();
            for (int m = 0; m < j; ++m) {
                PostilInfo pi = paramInfo.getPostils().get(m);
                pi.setId(null);
                pi.getSheet().setId(null);
            }
        }
        cslReport.getSheetParam().addCollection(srcCol);
        if (report.getPostils() != null && report.getPostils().size() > 0) {
            for (i = report.getPostils().size() - 1; i >= 0; --i) {
                PostilInfo pi = report.getPostils().get(i);
                Enumeration enums = pi.keys();
                PostilInfo pi2 = new PostilInfo();
                while (enums.hasMoreElements()) {
                    String k = (String)enums.nextElement();
                    pi2.put(k, pi.get(k));
                }
                pi2.setId(null);
                pi2.setReport((ReportBaseInfo)cslReport);
                if (pi2.getPostilType() != PostilTypeEnum.REPORT) {
                    for (int u = 0; u < srcCol.size(); ++u) {
                        if (pi2.getSheet() == null || srcCol.get(u) == null) continue;
                        String n1 = pi2.getSheet().getSheetName();
                        String n2 = srcCol.get(u).getSheetName();
                        if (n1 == null || n2 == null || !n1.equals(n2)) continue;
                        pi2.setSheet(srcCol.get(u));
                    }
                }
                cslReport.getPostils().add(pi2);
            }
        }
        cslReport.setName(report.getName());
        cslReport.setNumber(report.getNumber());
        cslReport.setDescription(report.getDescription());
        cslReport.setCreator(report.getCreator());
        cslReport.setCreateTime(report.getCreateTime());
        cslReport.setLastUpdateUser(report.getLastUpdateUser());
        cslReport.setLastUpdateTime(report.getLastUpdateTime());
        cslReport.setAuditTime(report.getAuditTime());
        if (report.getSourceCurrency() != null) {
            cslReport.setSourceCurrency(report.getSourceCurrency());
        } else {
            cslReport.setSourceCurrency(report.getCurrency());
        }
        cslReport.setConvertStatus(report.getConvertStatus());
        IReport ir = ReportFactory.getLocalInstance(ctx);
        ReportCollection rc = ir.getReportCollection("select cu where id = '" + report.getId().toString() + "'");
        if (rc.size() == 1) {
            cslReport.setCU(rc.get(0).getCU());
        }
        cslReport.setOrgType(report.getOrgType());
        Object formulaCalcId = report.get("KEY_FORMULACALCID");
        if (formulaCalcId != null && !StringUtils.isEmpty((String)((String)formulaCalcId))) {
            FormulaCalcContextInfo info = new FormulaCalcContextInfo();
            info.setId(BOSUuid.read((String)((String)formulaCalcId)));
            cslReport.setFormulaCalc(info);
            cslReport.setFastMergeSoluId((String)formulaCalcId);
        }
        return cslReport;
    }

    @Override
    protected Map _getSumFromRela(Context ctx, ArrayList companyList, String templateId, Object periodType, int year, int period) throws BOSException, EASBizException {
        int periodType1 = ((RptPeriodTypeEnum)periodType).getValue();
        ArrayList<String> groupRep = new ArrayList<String>();
        String sumReport = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean isExistGroupRpt = false;
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from T_RPT_Report where fCompanyId in(");
        int size = companyList.size();
        for (int i = 0; i < size; ++i) {
            if (i != size - 1) {
                sql.append("'").append(companyList.get(i)).append("',");
                continue;
            }
            sql.append("'").append(companyList.get(i)).append("')");
        }
        sql.append(" and ftemplateId = '").append(templateId).append("' and  fperiodType = ").append(periodType1);
        sql.append(" and fyear = ").append(year).append(" and fperiod = ").append(period);
        StringBuffer sql2 = new StringBuffer();
        sql2.append("select fsumreportid from t_Csl_sumrptrela where freportid in (");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                isExistGroupRpt = true;
                String reportId = rs.getString("fid");
                groupRep.add(reportId);
                sql2.append("'").append(reportId).append("',");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        sql2.deleteCharAt(sql2.length() - 1);
        sql2.append(")");
        map.put("isExistGroupRpt", new Boolean(isExistGroupRpt));
        if (!isExistGroupRpt) {
            return map;
        }
        StringBuffer sql1 = new StringBuffer();
        rs = DbUtil.executeQuery((Context)ctx, (String)sql2.toString());
        boolean isSumRep = true;
        if (rs.size() > 0) {
            try {
                while (rs.next()) {
                    isSumRep = true;
                    String sumreportId = rs.getString("fsumreportid");
                    sql1.append("select freportid from t_Csl_sumrptrela where fsumreportid = '");
                    sql1.append(sumreportId).append("'");
                    IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1.toString());
                    if (rs1.size() == groupRep.size()) {
                        while (rs1.next()) {
                            if (groupRep.contains(rs1.getString("freportid"))) continue;
                            isSumRep = false;
                            break;
                        }
                    } else {
                        map.put("isSum", Boolean.FALSE);
                        map.put("groupRep", groupRep);
                        return map;
                    }
                    if (!isSumRep) continue;
                    sumReport = sumreportId;
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        } else {
            map.put("isSum", Boolean.FALSE);
            map.put("groupRep", groupRep);
            return map;
        }
        if (sumReport == null) {
            map.put("isSum", Boolean.FALSE);
            map.put("groupRep", groupRep);
            return map;
        }
        map.put("isSum", Boolean.TRUE);
        map.put("sumReport", sumReport);
        return map;
    }

    @Override
    protected void _saveToSumRela(Context ctx, List rptList, IObjectValue sumReportInfo) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        ReportInfo sumInfo = (ReportInfo)sumReportInfo;
        Calendar ca = Calendar.getInstance();
        ca.setTime(sumInfo.getCreateTime());
        int year = ca.get(1);
        int month = ca.get(2);
        int day = ca.get(5);
        int hour = ca.get(11);
        int min = ca.get(12);
        int sec = ca.get(13);
        Connection con = super.getConnection(ctx);
        Statement st = null;
        try {
            st = con.createStatement();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        for (int i = 0; i < rptList.size(); ++i) {
            String id = Uuid.create().toString();
            sql.append("insert into t_csl_sumrptRela (fid,fsumreportid,freportid,fcreatetime,fcreatorid,").append("flastupdatetime,flastupdateuserid,fcontrolunitid,fsheetid )");
            sql.append(" values('").append(id).append("','");
            sql.append(sumInfo.getId().toString()).append("','");
            sql.append(rptList.get(i)).append("',");
            sql.append("{ts'");
            sql.append(sb.append(year).append("-").append(month + 1).append("-").append(day).append(" ").append(hour).append(":").append(min).append(":").append(sec));
            sql.append("'},'");
            sb.delete(0, sb.length());
            sql.append(sumInfo.getCreator().getId().toString()).append("',{ts'");
            sql.append(sb.append(year).append("-").append(month + 1).append("-").append(day).append(" ").append(hour).append(":").append(min).append(":").append(sec)).append("'},'");
            sql.append(sumInfo.getLastUpdateUser().getId().toString()).append("','");
            sql.append(sumInfo.getCU().getId().toString()).append("','");
            sql.append("").append("'");
            sql.append(")");
            try {
                st.addBatch(sql.toString());
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            sql.delete(0, sql.length());
            sb.delete(0, sb.length());
        }
        try {
            st.executeBatch();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Statement)st, (Connection)con);
        }
    }

    @Override
    protected HashMap _calculateSumRptBySheets(Context ctx, ArrayList cslRptIDs, Map sheets) throws BOSException, EASBizException {
        if (cslRptIDs == null || sheets == null) {
            return null;
        }
        String curSheetName = null;
        HashMap<String, String> rptSheets = new HashMap<String, String>();
        Iterator iterSheet = sheets.keySet().iterator();
        String companyNumber = "";
        while (iterSheet.hasNext()) {
            curSheetName = (String)iterSheet.next();
            if (curSheetName == null || curSheetName.length() == 0) continue;
            rptSheets.put(curSheetName, curSheetName);
        }
        HashMap sumSheets = new HashMap();
        for (String sheetName : sheets.keySet()) {
            sumSheets.put(sheetName, new HashMap());
        }
        try {
            Book book = null;
            int nodeCount = 0;
            int n = cslRptIDs.size();
            for (int j = 0; j < n; ++j) {
                ReportBaseInfo cslRpt = null;
                cslRpt = this.getReport((String)cslRptIDs.get(j), ctx);
                book = IOHelper.unpackBook(cslRpt.getData(), IBookFieldFlags.FLAG_DATA | IBookFieldFlags.FLAG_FORMULA);
                if (book != null && (nodeCount = book.getSheetCount()) > 0) {
                    for (int i = 0; i < nodeCount; ++i) {
                        Sheet sheet = book.getSheet(i);
                        curSheetName = sheet.getSheetName();
                        if (!rptSheets.containsKey(curSheetName)) continue;
                        HashMap curSumDataMap = (HashMap)sumSheets.get(curSheetName);
                        SumcalcRange sumZone = (SumcalcRange)sheets.get(curSheetName);
                        if (cslRpt.getCompany() != null && cslRpt.getCompany().getNumber() != null) {
                            companyNumber = cslRpt.getCompany().getNumber();
                        }
                        this.calculateSheets(curSumDataMap, sheet, companyNumber, cslRpt.getNumber(), sumZone);
                        sheet = null;
                    }
                }
                cslRpt = null;
                book = null;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return sumSheets;
    }

    private ReportBaseInfo getReport(String id, Context ctx) throws EASBizException, BOSException {
        ReportBaseInfo rpt = ReportFactory.getLocalInstance(ctx).getReportBaseInfo("select id,name,number,company.id,company.number,data where id='" + id + "'");
        return rpt;
    }

    private void calculateSheets(HashMap curSumDataMap, Sheet curSheet, String companyNum, String reportName, SumcalcRange sumZone) {
        if (curSheet == null) {
            return;
        }
        if (sumZone == null || sumZone.size() < 1) {
            return;
        }
        for (int index = 0; index < sumZone.size(); ++index) {
            CellBlock block = sumZone.getCellBlock(index);
            Range range = curSheet.getRange(block);
            Sheet.ICellsIterator it = curSheet.getBook().getRangeCellsIterator(range, false, true);
            while (it.hasNext()) {
                String expression;
                BigDecimal tmpCellValue;
                Cell cell2 = it.next();
                Variant var = cell2.getValue();
                Object tmpCellObj = var.isEmpty() ? null : var.getValue();
                String expr = range.getFormula();
                if (tmpCellObj == null && StringUtils.isEmpty((String)expr)) continue;
                try {
                    tmpCellValue = tmpCellObj == null ? null : new BigDecimal(tmpCellObj.toString());
                }
                catch (Exception e) {
                    continue;
                }
                HashMap cell = (HashMap)curSumDataMap.get(new Point(cell2.getCol(), cell2.getRow()));
                if (cell == null) {
                    HashMap<String, Object> cell1 = new HashMap<String, Object>(2);
                    if (tmpCellValue != null && tmpCellValue.scale() < 0) {
                        tmpCellValue = tmpCellValue.setScale(0 - tmpCellValue.scale());
                    }
                    cell1.put("value", tmpCellValue);
                    expression = "ref(\"" + companyNum + "\",\"" + reportName + "\",\"" + curSheet.getSheetName() + "\",\"" + cell2.getName(false, false) + "\")";
                    cell1.put("expression", expression);
                    curSumDataMap.put(new Point(cell2.getCol(), cell2.getRow()), cell1);
                    continue;
                }
                BigDecimal tmpMapValue = (BigDecimal)cell.get("value");
                if (tmpMapValue != null && tmpCellValue != null) {
                    tmpMapValue = tmpMapValue.add(tmpCellValue);
                } else if (tmpMapValue == null && tmpCellValue != null) {
                    tmpMapValue = tmpCellValue;
                }
                expression = (String)cell.get("expression");
                String newexpression = "ref(\"" + companyNum + "\",\"" + reportName + "\",\"" + curSheet.getSheetName() + "\",\"" + cell2.getName(false, false) + "\")";
                expression = expression + "+" + newexpression;
                if (tmpMapValue != null && tmpMapValue.scale() < 0) {
                    tmpMapValue = tmpMapValue.setScale(0 - tmpMapValue.scale());
                }
                cell.put("value", tmpMapValue);
                cell.put("expression", expression);
                curSumDataMap.put(new Point(cell2.getCol(), cell2.getRow()), cell);
            }
        }
    }

    @Override
    protected List _reportBatchCheckNoParam(Context ctx, List ids) throws BOSException, EASBizException {
        ReportCollection reports = this.getReportStatusById(ctx, ids);
        ReportInfo r = null;
        ArrayList<Object> result = new ArrayList<Object>(reports.size());
        boolean needGetMsg = false;
        ArrayList<ReportInfo> rptlist = new ArrayList<ReportInfo>();
        ArrayList listInnerCheck = new ArrayList();
        for (int i = 0; i < reports.size(); ++i) {
            r = reports.get(i);
            if ((r.getSourceType() == RptSrcTypeEnum.COMMITREPORT || r.getSourceType() == RptSrcTypeEnum.DYNAMICNORMALREPORT) && IsSupportGroupReportEnum.SUPPORT.equals((Object)r.getIsSupportGroup())) {
                needGetMsg = true;
                rptlist.add(r);
                continue;
            }
            this.updateScheme(ctx, (IObjectValue)r);
            ArrayList checked = ReportCheck.checkReport(ctx, r, null);
            HashMap<String, Object> rst = new HashMap<String, Object>();
            if (checked != null) {
                rst.put("CHECKPASSED", checked.get(0));
                rst.put("CHECKCOUNT", checked.get(1));
                rst.put("CHECKMSG", checked.get(2));
                rst.put("REPORTID", r.getId().toString());
            }
            result.add(rst);
            if (checked.size() < 4 || checked.get(3) == null) continue;
            listInnerCheck.add(checked.get(3));
        }
        if (needGetMsg) {
            List msgs = CslReportFactory.getLocalInstance((Context)ctx).preCheckReportNoParam(rptlist);
            for (int i = 0; msgs != null && i < msgs.size(); ++i) {
                Map map = (Map)msgs.get(i);
                if (map == null || map.get("KEY_ID") == null) continue;
                Object removed = map.remove("KEY_ID");
                for (int f = 0; f < rptlist.size(); ++f) {
                    ReportInfo ri = (ReportInfo)rptlist.get(f);
                    if (!removed.toString().equalsIgnoreCase(ri.getCslReport().getId().toString())) continue;
                    removed = ri.getId().toString();
                }
                map.put("REPORTID", removed);
                map.put("CHECKPASSED", map.remove("KEY_CHECK_FLAG"));
                map.put("CHECKMSG", map.remove("KEY_CHECK_MESSAGE"));
                result.add(map);
            }
            if (msgs != null && msgs.size() > 0 && listInnerCheck.size() > 0) {
                for (int k = 0; k < msgs.size(); ++k) {
                    HashMap mapAll = (HashMap)msgs.get(k);
                    if (mapAll == null || mapAll.size() <= 0 || mapAll.get("tableInnerCheck") == null) continue;
                    ArrayList listAll = (ArrayList)mapAll.get("tableInnerCheck");
                    for (int i = 0; i < listInnerCheck.size(); ++i) {
                        listAll.add(listInnerCheck.get(i));
                    }
                }
            }
            result.add(msgs);
        } else {
            ArrayList msgs = new ArrayList();
            HashMap mapAll = new HashMap();
            ArrayList listAll = new ArrayList();
            mapAll.put("tableInnerCheck", listAll);
            for (int i = 0; i < listInnerCheck.size(); ++i) {
                listAll.add(listInnerCheck.get(i));
            }
            msgs.add(mapAll);
            result.add(msgs);
        }
        return result;
    }

    protected boolean _isAudited(Context ctx, BOSUuid reportId) throws BOSException, EASBizException, SQLException {
        String sql = "SELECT FAuditedStatus FROM T_RPT_Report WHERE FID=?    ";
        Object[] params = new Object[]{reportId.toString()};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        if (rowSet.next()) {
            int auditedStatus = rowSet.getInt("FAuditedStatus");
            return auditedStatus == 2;
        }
        return false;
    }

    @Override
    protected Map _getWeaveProgess(Context ctx, String companyId, FilterInfo filterInfo, SorterItemInfo sorterItemInfo) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        if (filterItems == null || filterItems.size() < 4) {
            throw new BOSException("Invaild params!");
        }
        Integer periodType = new Integer(0);
        Integer year = new Integer(0);
        Integer period = new Integer(0);
        String status = null;
        String currencyId = null;
        String orgBoundIds = null;
        String dataCollectNumber = null;
        for (int i = 0; i < filterItems.size(); ++i) {
            FilterItemInfo itemInfo = filterItems.get(i);
            if ("periodType".equals(itemInfo.getPropertyName())) {
                periodType = (Integer)itemInfo.getCompareValue();
                continue;
            }
            if ("year".equals(itemInfo.getPropertyName())) {
                year = (Integer)itemInfo.getCompareValue();
                continue;
            }
            if ("period".equals(itemInfo.getPropertyName())) {
                period = (Integer)itemInfo.getCompareValue();
                continue;
            }
            if ("status".equals(itemInfo.getPropertyName())) {
                status = (String)itemInfo.getCompareValue();
                continue;
            }
            if ("currency".equals(itemInfo.getPropertyName())) {
                currencyId = (String)itemInfo.getCompareValue();
                continue;
            }
            if ("dataCollectNumber".equals(itemInfo.getPropertyName())) {
                dataCollectNumber = (String)itemInfo.getCompareValue();
                continue;
            }
            if (!"sqlTime".equals(itemInfo.getPropertyName())) continue;
            Time time = (Time)itemInfo.getCompareValue();
            IUnionVersionControllerFacade unionVersionFacade = UnionVersionControllerFacadeFactory.getLocalInstance((Context)ctx);
            String[] ids = unionVersionFacade.getIDList(new Timestamp(time.getTime()));
            if (ids == null || ids.length <= 0) continue;
            orgBoundIds = "'" + ids[0] + "'";
            for (int j = 1; j < ids.length; ++j) {
                orgBoundIds = orgBoundIds + ",'" + ids[j] + "'";
            }
        }
        DataCollectInfo dataCollectInfo = this.getDataCollectByNumber(ctx, dataCollectNumber);
        String language = ctx.getLocale().getLanguage();
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer querySql = new StringBuffer();
        StringBuffer querySql_1 = new StringBuffer();
        StringBuffer querySql_2 = new StringBuffer();
        querySql_1.append("select distinct null as FID").append("\r\n");
        querySql_1.append(",CASE t1.FTemplateType  WHEN 3 then 2  WHEN 5 then 3 WHEN 10 then 10  WHEN 2 THEN 7");
        querySql_1.append("  WHEN 11 then 11 WHEN 13 THEN 12 WHEN 6 THEN 7 WHEN 15 THEN 13 ELSE 1 END AS sourceType").append("\r\n");
        querySql_1.append(",null as \"Report.number\",null as \"Report.name\"").append("\r\n");
        querySql_1.append(",t1.FNumber AS \"template.number\",t1.FName AS \"template.name\"").append("\r\n");
        querySql_1.append(",N'" + dataCollectInfo.getName() + "'");
        querySql_1.append(" as \"dataCollect.name\"").append("\r\n");
        querySql_1.append(",null as \"currency.name\"").append("\r\n");
        querySql_1.append(",-1 as auditedStatus,-1 as committedStatus").append("\r\n");
        querySql_1.append(",1 as periodType").append("\r\n");
        querySql_1.append(",1 as ReportStatus").append("\r\n");
        querySql_1.append("from T_RPT_Template t1").append("\r\n");
        querySql_1.append("inner join T_CSL_TempletDispense").append("\r\n");
        querySql_1.append("t2 on t2.FDispenseSrcID = t1.fid").append("\r\n");
        querySql_1.append("where t2.FCompanyID = ?").append("\r\n");
        querySql_1.append("and t1.fisfreezed=0").append("\r\n");
        querySql_1.append("and t1.FVersionStatus = 1").append("\r\n");
        querySql_1.append("and t1.FPeriodType = ?").append("\r\n");
        if (dataCollectInfo.getNumber().equals("BUDGETDATA")) {
            querySql_1.append("and t1.FIsIncludeOtherDC = 1   \r\n");
        }
        querySql_1.append("and t1.FTemplateType in(").append(6);
        querySql_1.append(",").append(10);
        querySql_1.append(",").append(15);
        querySql_1.append(")").append("\r\n");
        querySql_1.append("and not exists").append("\r\n");
        querySql_1.append("(").append("\r\n");
        querySql_1.append("  select t.FID").append("\r\n");
        querySql_1.append("  from T_RPT_Template t").append("\r\n");
        querySql_1.append("  where t.FCompanyID = t2.FCompanyID").append("\r\n");
        if (dataCollectInfo.getNumber().equals("BUDGETDATA")) {
            querySql_1.append("and t.FIsIncludeOtherDC = 1   \r\n");
        }
        querySql_1.append("  and t.FVersionStatus = 1  and t.FGroup = t1.FGroup").append("\r\n");
        querySql_1.append("  and t.FTemplateType in(").append(2);
        querySql_1.append(")").append("\r\n");
        querySql_1.append(")").append("\r\n");
        querySql_1.append("and not exists").append("\r\n");
        querySql_1.append("(").append("\r\n");
        querySql_1.append("  select t.FID").append("\r\n");
        querySql_1.append("  from T_CSL_CslReport t").append("\r\n");
        querySql_1.append("  inner join T_RPT_Template tt").append("\r\n");
        querySql_1.append("  on tt.FID = t.FTemplateID").append("\r\n");
        querySql_1.append("  where tt.FID = t.FTemplateID").append("\r\n");
        querySql_1.append("  and t.FCompanyID = t2.FCompanyID").append("\r\n");
        querySql_1.append("  and t.FPeriodType = ").append(periodType).append("\r\n");
        querySql_1.append("  and t.FYear = ").append(year).append("\r\n");
        querySql_1.append("  and t.FPeriod = ").append(period).append("\r\n");
        querySql_1.append("  and tt.FGroup = t1.FGroup").append("\r\n");
        if (!StringUtils.isEmpty((String)dataCollectNumber)) {
            querySql_1.append("and t.FDataCollectNumber = '").append(dataCollectNumber).append("'\r\n");
        }
        if (!StringUtils.isEmpty((String)currencyId)) {
            querySql_1.append("  and t.FCurrencyID = '").append(currencyId).append("'").append("\r\n");
        }
        querySql_1.append(")").append("\r\n");
        params.add(companyId);
        params.add(periodType);
        if (!StringUtils.isEmpty((String)orgBoundIds)) {
            querySql_1.append("and t2.FOrgBoundID in(").append(orgBoundIds).append(")").append("\r\n");
        }
        querySql_1.append("union").append("\r\n");
        querySql_1.append("select distinct null as FID").append("\r\n");
        querySql_1.append(",CASE t1.FTemplateType  WHEN 3 then 2  WHEN 5 then 3 WHEN 10 THEN 10 WHEN 2 THEN 7");
        querySql_1.append(" WHEN 11 THEN 11 WHEN 13 THEN 12 WHEN 6 THEN 7 ELSE 1 END AS sourceType").append("\r\n");
        querySql_1.append(",null as \"Report.number\",null as \"Report.name\"").append("\r\n");
        querySql_1.append(",t1.FNumber AS \"template.number\",t1.FName AS \"template.name\"").append("\r\n");
        querySql_1.append(",N'" + dataCollectInfo.getName() + "'");
        querySql_1.append(" as \"dataCollect.name\"").append("\r\n");
        querySql_1.append(",null as \"currency.name\"").append("\r\n");
        querySql_1.append(",-1 as auditedStatus,-1 as committedStatus").append("\r\n");
        querySql_1.append(",1 as periodType").append("\r\n");
        querySql_1.append(",1 as ReportStatus").append("\r\n");
        querySql_1.append("from T_RPT_Template t1").append("\r\n");
        querySql_1.append("inner  join T_RPT_Template t2").append("\r\n");
        querySql_1.append("on t1.FGroup = t2.FGroup").append("\r\n");
        querySql_1.append("inner  join T_CSL_TempletDispense d").append("\r\n");
        querySql_1.append("on t2.fid = d.FDispenseSrcID").append("\r\n");
        querySql_1.append("where t1.FCompanyID = ?").append("\r\n");
        querySql_1.append("and t1.fisfreezed=0").append("\r\n");
        if (dataCollectInfo.getNumber().equals("BUDGETDATA")) {
            querySql_1.append("and t1.FIsIncludeOtherDC = 1   \r\n");
        }
        querySql_1.append("and t1.FVersionStatus < 2").append("\r\n");
        querySql_1.append("and d.FIsAllowChgTemplet = 1").append("\r\n");
        querySql_1.append("and t1.FPeriodType = ?").append("\r\n");
        querySql_1.append("and t1.FTemplateType in(").append(2);
        querySql_1.append(")").append("\r\n");
        querySql_1.append("and not exists").append("\r\n");
        querySql_1.append("(").append("\r\n");
        querySql_1.append("  select t.FID").append("\r\n");
        querySql_1.append("  from T_CSL_CslReport t").append("\r\n");
        querySql_1.append("  inner join T_RPT_Template tt").append("\r\n");
        querySql_1.append("  on tt.FID = t.FTemplateID").append("\r\n");
        querySql_1.append("  where tt.FID = t.FTemplateID").append("\r\n");
        querySql_1.append("  and t.FCompanyID = t1.FCompanyID").append("\r\n");
        querySql_1.append("  and t.FPeriodType = ").append(periodType).append("\r\n");
        querySql_1.append("  and t.FYear = ").append(year).append("\r\n");
        querySql_1.append("  and t.FPeriod = ").append(period).append("\r\n");
        querySql_1.append("  and tt.FGroup = t1.FGroup").append("\r\n");
        if (!StringUtils.isEmpty((String)dataCollectNumber)) {
            querySql_1.append("and t.FDataCollectNumber = '").append(dataCollectNumber).append("'\r\n");
        }
        if (!StringUtils.isEmpty((String)currencyId)) {
            querySql_1.append("  and t.FCurrencyID = '").append(currencyId).append("'").append("\r\n");
        }
        querySql_1.append(")").append("\r\n");
        if (!StringUtils.isEmpty((String)orgBoundIds)) {
            querySql_1.append("and d.FOrgBoundID in(").append(orgBoundIds).append(")").append("\r\n");
        }
        params.add(companyId);
        params.add(periodType);
        querySql_2.append("select t1.FID").append("\r\n");
        querySql_2.append(",t1.FSourceType as sourceType").append("\r\n");
        querySql_2.append(",t1.FNumber as \"Report.number\",t1.FName as \"Report.name\"").append("\r\n");
        querySql_2.append(",t2.FNumber as \"template.number\",t2.FName as \"template.name\"").append("\r\n");
        querySql_2.append(", d.fname_").append(language).append(" as \"dataCollect.name\"").append("\r\n");
        querySql_2.append(",t3.FName_" + ctx.getLocale() + " as \"currency.name\"").append("\r\n");
        querySql_2.append(",t1.FAuditedStatus as auditedStatus,t1.FCommittedStatus as committedStatus").append("\r\n");
        querySql_2.append(",case when (t1.FAuditedStatus*t1.FCommittedStatus+1) > 3 then 4 else (t1.FAuditedStatus*t1.FCommittedStatus+1) end as periodType").append("\r\n");
        querySql_2.append(",case when (t1.FAuditedStatus*t1.FCommittedStatus+1) > 3 then 4 else (t1.FAuditedStatus*t1.FCommittedStatus+1) end as ReportStatus").append("\r\n");
        querySql_2.append("from T_RPT_Report t1").append("\r\n");
        querySql_2.append("inner join T_RPT_Template t2").append("\r\n");
        querySql_2.append("on t2.FID = t1.FTemplateID").append("\r\n");
        querySql_2.append("and t2.fisfreezed=0").append("\r\n");
        querySql_2.append("inner join T_BD_Currency t3").append("\r\n");
        querySql_2.append("on t3.FID = t1.FCurrencyID").append("\r\n");
        querySql_2.append("inner join t_Csl_Datacollect d on d.fnumber = t1.fdatacollectnumber  \n");
        querySql_2.append("where t1.FSourceType in(7,10,13)").append("\r\n");
        querySql_2.append("and t1.FCompanyID = ?").append("\r\n");
        querySql_2.append("and t1.FPeriodType = ?").append("\r\n");
        querySql_2.append("and t1.FYear = ?").append("\r\n");
        querySql_2.append("and t1.FPeriod = ?").append("\r\n");
        if (dataCollectInfo.getNumber().equals("BUDGETDATA")) {
            querySql_2.append("and t2.FIsIncludeOtherDC = 1   \r\n");
        }
        params.add(companyId);
        params.add(periodType);
        params.add(year);
        params.add(period);
        if (!StringUtils.isEmpty((String)currencyId)) {
            querySql_2.append("and t1.FCurrencyID = ?").append("\r\n");
            params.add(currencyId);
        }
        if (!StringUtils.isEmpty((String)dataCollectNumber)) {
            querySql_2.append("and t1.FDataCollectNumber = ?").append("\r\n");
            params.add(dataCollectNumber);
        }
        querySql_2.append("and t1.FIsSupportGroup = ").append(1).append("\r\n");
        querySql.append("select ReportStatus,count(ReportStatus) from").append("\r\n");
        querySql.append("(").append("\r\n");
        querySql.append(querySql_1);
        querySql.append("union").append("\r\n");
        querySql.append(querySql_2);
        querySql.append(") t").append("\r\n");
        querySql.append("group by ReportStatus").append("\r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])params.toArray());
        int[] statData = new int[5];
        try {
            while (rs.next()) {
                statData[rs.getInt((int)1)] = rs.getInt(2);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        statData[0] = statData[1] + statData[2] + statData[3] + statData[4];
        querySql.setLength(0);
        querySql.append("select * from").append("\r\n");
        querySql.append("(").append("\r\n");
        querySql.append(querySql_1);
        querySql.append("union").append("\r\n");
        querySql.append(querySql_2);
        querySql.append(") t").append("\r\n");
        if (status != null) {
            querySql.append("where t.ReportStatus in(").append(status).append(")").append("\r\n");
        }
        if (sorterItemInfo == null) {
            querySql.append("order by t.ReportStatus");
        } else {
            querySql.append("order by ");
            sorterItemInfo.output(querySql);
        }
        rs = DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])params.toArray());
        result.put("KEY_RCV_STAT", statData);
        result.put("KEY_RCV_ROWSET", rs);
        return result;
    }

    @Override
    protected List _commitReportNew(Context ctx, List idList) throws BOSException, EASBizException {
        HashMap<String, Object> map;
        int i;
        ArrayList<String> cslReportIds = new ArrayList<String>();
        ICslReport csl = CslReportFactory.getLocalInstance((Context)ctx);
        ReportCollection rpts = new ReportCollection();
        for (int i2 = 0; i2 < idList.size(); ++i2) {
            ReportInfo report = this.getReportInfo(ctx, (IObjectPK)new ObjectStringPK(idList.get(i2).toString()), this.getSelectors());
            if (report.getCommittedStatus().getValue() == 2) {
                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"report_commit_committed", (Locale)ctx.getOriginLocale())});
            }
            if (report.getAuditedStatus().getValue() == 1) {
                String errorMsg = ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"Report", (Locale)ctx.getOriginLocale()) + report.getName() + " " + ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"NoauditedCannotCommit", (Locale)ctx.getOriginLocale()) + "\n";
                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{errorMsg});
            }
            cslReportIds.add(report.getCslReport().getId().toString());
            rpts.add(report);
        }
        ICslReport icr = CslReportFactory.getLocalInstance((Context)ctx);
        Map intExchCheckResult = icr.batchCheckInterExchReport(cslReportIds);
        List unPassIDs = (List)intExchCheckResult.get("unPassIDs");
        List unPassResult = (List)intExchCheckResult.get("checkResult");
        if (unPassIDs != null && unPassIDs.size() > 0) {
            ArrayList<String> removeRptIds = new ArrayList<String>();
            for (int i3 = 0; i3 < unPassIDs.size(); ++i3) {
                String cslrptid = (String)unPassIDs.get(i3);
                for (int j = 0; j < rpts.size(); ++j) {
                    ReportInfo report = rpts.get(j);
                    String cslid = report.getCslReport().getId().toString();
                    if (!cslrptid.equals(cslid)) continue;
                    String rptid = report.getId().toString();
                    removeRptIds.add(rptid);
                }
            }
            idList.removeAll(removeRptIds);
            cslReportIds.removeAll(unPassIDs);
        }
        List result = csl.reportCheck(cslReportIds, 3);
        boolean passed = true;
        String msg = null;
        if (result != null && result.size() > 0) {
            for (i = 0; i < result.size(); ++i) {
                map = (HashMap<String, Object>)result.get(i);
                if (map != null && map.get("KEY_CHECK_FLAG") != null) {
                    passed = (Boolean)map.get("KEY_CHECK_FLAG");
                }
                if (map != null && map.get("KEY_CHECK_MESSAGE") != null) {
                    msg = (String)map.get("KEY_CHECK_MESSAGE");
                }
                if (map == null || map.get("KEY_ID") == null) continue;
                String cslreportId = map.get("KEY_ID").toString();
                if (!passed) continue;
                String reportId = this.getReportId(ctx, cslreportId);
                csl.commitReport1(reportId, cslreportId);
                csl.commitReportLog((IObjectPK)new ObjectUuidPK(cslreportId));
            }
        } else {
            for (i = 0; i < idList.size(); ++i) {
                csl.commitReport1((String)idList.get(i), (String)cslReportIds.get(i));
                csl.commitReportLog((IObjectPK)new ObjectUuidPK((String)cslReportIds.get(i)));
            }
        }
        ArrayList allResult = new ArrayList();
        map = null;
        if (unPassResult.size() > 0) {
            StringBuffer msgs = new StringBuffer();
            for (int i4 = 0; i4 < unPassResult.size(); ++i4) {
                Map chkItem = (Map)unPassResult.get(i4);
                String id = (String)chkItem.get("KEY_ID");
                for (int j = 0; j < rpts.size(); ++j) {
                    ReportInfo report = rpts.get(j);
                    String cslid = report.getCslReport().getId().toString();
                    if (!id.equals(cslid)) continue;
                    String name = report.getName();
                    String currency = report.getCurrency().getName();
                    msgs.append(CslRptUtil.getStringWithFormat((String)"batchAuditCheckErrorMsgNoDC", (Object[])new Object[]{name, currency}));
                    String msg1 = (String)chkItem.get("KEY_CHECK_MESSAGE");
                    msgs.append(msg1);
                    msgs.append("<br>");
                }
            }
            map = new HashMap();
            map.put("checkInterExch", msgs.toString());
            allResult.add(map);
        }
        if (!StringUtils.isEmpty(msg)) {
            map = new HashMap<String, Object>();
            map.put("reportCheck", result);
            allResult.add(map);
            return allResult;
        }
        return allResult;
    }

    private String getReportId(Context ctx, String reportId) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        StringBuffer s = new StringBuffer();
        s.append("select id where cslReport.id='").append(reportId).append("'");
        ReportInfo info = ReportFactory.getLocalInstance(ctx).getReportInfo(s.toString());
        return info.getId().toString();
    }

    private String doCover(Context ctx, List ids, Map convertParam, boolean isFromAutoWeave) throws BOSException, EASBizException {
        StringBuffer buf = new StringBuffer();
        int selectStatus = Integer.valueOf(convertParam.get("CSLCYAFTERSTATUS").toString());
        String currencyId = ((Map)convertParam.get("KEY_BASE")).get("KEY_BASE_TARGETCY").toString();
        CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
        for (int j = 0; j < ids.size(); ++j) {
            ReportInfo rinfo;
            ReportInfo info = this.getReport(ctx, (String)ids.get(j));
            if (!IsSupportGroupReportEnum.SUPPORT.equals((Object)info.getIsSupportGroup()) || info.getSourceType().equals((Object)RptSrcTypeEnum.NORMAL) || ConvertStatusEnum.Converted.equals((Object)info.getConvertStatus())) {
                buf.append(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.baobiao", (Locale)ctx.getOriginLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.notSup", (Locale)ctx.getOriginLocale()) + " \r\n " + ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.onlySup", (Locale)ctx.getOriginLocale()) + "\r\n");
                continue;
            }
            ((Map)convertParam.get("KEY_BASE")).put("KEY_BASE_DATE", info.getEndDate() != null ? new Date(info.getEndDate().getTime()) : null);
            convertParam.put("year", new Integer(info.getYear()));
            convertParam.put("period", new Integer(info.getPeriod()));
            convertParam.put("periodType", info.getPeriodType());
            convertParam.put("CONVTADJ", new Boolean(false));
            convertParam.put("isFromReportsystem", "true");
            HashMap initDataMap = new HashMap();
            convertParam.put("initDataMap", initDataMap);
            ArrayList<String> list = new ArrayList<String>();
            list.add(info.getCslReport().getId().toString());
            EntityViewInfo tView = new EntityViewInfo();
            tView.getSelector().add(new SelectorItemInfo("*"));
            tView.setFilter(new FilterInfo());
            tView.getFilter().getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId().toString()));
            tView.getFilter().getFilterItems().add(new FilterItemInfo("template.group", (Object)info.getTemplate().getGroup()));
            tView.getFilter().getFilterItems().add(new FilterItemInfo("year", (Object)new Integer(info.getYear())));
            tView.getFilter().getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(info.getPeriod())));
            tView.getFilter().getFilterItems().add(new FilterItemInfo("periodType", (Object)info.getPeriodType()));
            tView.getFilter().getFilterItems().add(new FilterItemInfo("convertStatus", (Object)new Integer(ConvertStatusEnum.Converted.getValue())));
            tView.getFilter().getFilterItems().add(new FilterItemInfo("sourceCurrency.id", (Object)info.getCurrency().getId().toString()));
            tView.getFilter().getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
            tView.getFilter().getFilterItems().add(new FilterItemInfo("dataCollectNumber", (Object)info.getDataCollectNumber()));
            CoreBaseCollection collection1 = ReportFactory.getLocalInstance(ctx).getCollection(tView);
            if (collection1 != null && collection1.size() > 0 && !(rinfo = (ReportInfo)collection1.get(0)).getCommittedStatus().equals((Object)CommittedStatusEnum.GROUPCOMMITTED)) {
                if (rinfo.getCommittedStatus().equals((Object)CommittedStatusEnum.COMMITTED)) {
                    ArrayList<String> todo = new ArrayList<String>();
                    todo.add(rinfo.getCslReport().getId().toString());
                    RPTDataServiceFactory.getLocalInstance((Context)ctx).sendBack(todo);
                } else if (rinfo.getAuditedStatus().equals((Object)AuditedStatusEnum.AUDITED)) {
                    ReportFactory.getLocalInstance(ctx).unAudit((IObjectPK)new ObjectUuidPK(rinfo.getId().toString()));
                }
                ReportFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(rinfo.getId().toString()));
            }
            convertParam.put("KEY_REPORT", "report");
            Map map = CyConvtFactory.getLocalInstance((Context)ctx).convertByReport(list, convertParam);
            String msg = (String)map.get("Message");
            if (msg == null || msg.trim().length() == 0) {
                ArrayList id = (ArrayList)map.get("reports");
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id.get(0).toString()));
                SelectorItemCollection sc = new SelectorItemCollection();
                sc.add(new SelectorItemInfo("*"));
                CslReportInfo cslInfo = CslReportFactory.getLocalInstance((Context)ctx).getCslReportInfo((IObjectPK)pk, sc);
                byte[] data = cslInfo.getData();
                if (CslReportFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(cslInfo.getId().toString()))) {
                    RPTDataServiceFactory.getLocalInstance((Context)ctx).deleteConvertedRpt(info.getCslReport().getId().toString(), currencyId);
                }
                this.SaveNewReport(info, buf, currency, data, ctx, selectStatus, isFromAutoWeave);
                continue;
            }
            buf.append(info.getName() + ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.cError", (Locale)ctx.getOriginLocale()) + " \r\n").append(msg + "\r\n");
        }
        return buf.toString();
    }

    @Override
    protected String _cyCover(Context ctx, ArrayList ids, ArrayList lst) throws BOSException, EASBizException {
        return this.doCover(ctx, ids, (Map)lst.get(0), false);
    }

    private ReportInfo getReport(Context ctx, String id) throws EASBizException, BOSException, UuidException {
        return ReportFactory.getLocalInstance(ctx).getReportInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)), this.getSelectors());
    }

    private ReportInfo ToNewReport(ReportInfo info) {
        RptTypeRelaCollection c3;
        PostilCollection c2;
        RptOrgRelaCollection c1;
        RptSheetParamCollection c = info.getSheetParam();
        if (c != null && c.size() > 0) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                RptSheetParamInfo sino = (RptSheetParamInfo)it.next();
                sino.setId(null);
            }
        }
        if ((c1 = info.getOrgRela()) != null && c1.size() > 0) {
            Iterator it = c1.iterator();
            while (it.hasNext()) {
                RptOrgRelaInfo sino = (RptOrgRelaInfo)it.next();
                sino.setId(null);
            }
        }
        if ((c2 = info.getPostils()) != null && c2.size() > 0) {
            Iterator it = c2.iterator();
            while (it.hasNext()) {
                PostilInfo sino = (PostilInfo)it.next();
                sino.setId(null);
            }
        }
        if ((c3 = info.getSavePoint()) != null && c3.size() > 0) {
            Iterator it = c3.iterator();
            while (it.hasNext()) {
                RptTypeRelaInfo sino = (RptTypeRelaInfo)it.next();
                sino.setId(null);
            }
        }
        return info;
    }

    private void SaveNewReport(ReportInfo info, StringBuffer buf, CurrencyInfo currency, byte[] data, Context ctx, int selectStatus, boolean isFromAutoWeave) throws EASBizException, BOSException {
        CurrencyInfo sourceCurrency = null;
        info = this.ToNewReport(info);
        ReportInfo srcReport = new ReportInfo();
        srcReport.setId(info.getId());
        info.setId(null);
        if (info.getCheckedStatus() == null) {
            info.setCheckedStatus(CheckedStatusEnum.UNCHECKED);
        }
        info.setNumber(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.cvn", (Locale)ctx.getOriginLocale()) + "-" + info.getNumber() + "-" + currency.getNumber() + "-" + info.getYear() + "-" + info.getPeriod());
        sourceCurrency = info.getCurrency();
        info.setSourceCurrency(info.getCurrency());
        info.setCurrency(currency);
        info.setConvertStatus(ConvertStatusEnum.Converted);
        info.setData(data);
        info.setIsSupportGroup(IsSupportGroupReportEnum.SUPPORT);
        info.setSrcReport(srcReport);
        info.setCslReport(null);
        if (selectStatus == 1) {
            info.setCommittedStatus(CommittedStatusEnum.UNCOMMITTED);
            info.setCommitTime(null);
            info.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
            info.setAuditor(null);
            info.setAuditTime(null);
            info.setCreateTime(null);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("template.id", (Object)info.getTemplate().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)new Integer(info.getYear())));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(info.getPeriod())));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)info.getCurrency().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isSupportGroup", (Object)new Integer(1)));
        if (ReportFactory.getLocalInstance(ctx).exists(filter)) {
            info.setIsSupportGroup(IsSupportGroupReportEnum.NOTSUPPORT);
        }
        info.put("NoCodeR", "NoCodeR");
        info.setCreator(UserFactory.getLocalInstance((Context)ctx).getUserByID(ctx.getCaller()));
        info.setCreateTime(null);
        IObjectPK pk2 = ReportFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)info);
        if (selectStatus == 2 && info.getCslReport() != null) {
            CslReportInfo cslReportInfo = info.getCslReport();
            cslReportInfo.setCheckedStatus(info.getCheckedStatus());
            cslReportInfo.setAuditedStatus(info.getAuditedStatus());
            cslReportInfo.setCommittedStatus(info.getCommittedStatus());
            this.updateRptComitStatus(ctx, cslReportInfo, (IObjectPK)new ObjectUuidPK(cslReportInfo.getId().toString()));
            this.setItemDataStatus(ctx, cslReportInfo.getId().toString(), cslReportInfo.getCommittedStatus().getValue());
        }
        if (!isFromAutoWeave) {
            buf.append(info.getName() + ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.cSucess", (Locale)ctx.getOriginLocale()) + " \r\n");
        }
    }

    private void updateRptComitStatus(Context ctx, CslReportInfo oldReport, IObjectPK pk) throws BOSException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE T_Csl_CslReport ");
        buffer.append("   SET FAuditedStatus = ?, FCommittedStatus = ?, FCheckedStatus = ?");
        buffer.append(" WHERE FId = ?");
        Object[] params = new Object[]{new Integer(oldReport.getAuditedStatus().getValue()), new Integer(oldReport.getCommittedStatus().getValue()), new Integer(oldReport.getCheckedStatus().getValue()), pk.toString()};
        DbUtil.execute((Context)ctx, (String)buffer.toString(), (Object[])params);
    }

    private void setItemDataStatus(Context ctx, String reportId, int commitStatus) throws SQLDataException {
        StringBuffer buffer = new StringBuffer();
        Timestamp time = new Timestamp(new Date().getTime());
        Statement st = null;
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            st = cn.createStatement();
            buffer.append("UPDATE T_CSL_ITEMDATA ");
            buffer.append("   SET FCommitStatus = ");
            buffer.append(commitStatus);
            if (commitStatus == 1) {
                buffer.append(", FCommitDate = null \r\n");
            } else {
                buffer.append(",FCommitDate = Date'" + time.toString() + "' \r\n");
            }
            buffer.append("WHERE FReportID = '" + reportId + "'");
            st.addBatch(buffer.toString());
            buffer = new StringBuffer();
            buffer.append(" UPDATE T_CSL_ITEMDATAENTRY \r\n");
            buffer.append(" SET FCommitStatus = ");
            buffer.append(commitStatus);
            buffer.append(" WHERE FReportID = '" + reportId + "'");
            st.addBatch(buffer.toString());
            buffer = new StringBuffer();
            buffer.append("UPDATE T_CSL_DynaItemData \r\n");
            buffer.append("SET FCommitStatus = ");
            buffer.append(commitStatus);
            buffer.append("WHERE FReportID = '" + reportId + "'");
            st.addBatch(buffer.toString());
            buffer = new StringBuffer();
            buffer.append("Update T_CSL_InterItemData \r\n");
            buffer.append("SET FCommitStatus =");
            buffer.append(commitStatus);
            if (commitStatus == 1) {
                buffer.append(",FCommitDate = null \r\n");
            } else {
                buffer.append(",FCommitDate = Date'" + time.toString() + "' \r\n");
            }
            buffer.append("WHERE FReport = '" + reportId + "'");
            st.addBatch(buffer.toString());
            buffer = new StringBuffer();
            buffer.append("Update T_CSL_ExchItemData \r\n");
            buffer.append("SET FCommitStatus =");
            buffer.append(commitStatus);
            if (commitStatus == 1) {
                buffer.append(",FCommitDate = null \r\n");
            } else {
                buffer.append(",FCommitDate = Date'" + time.toString() + "' \r\n");
            }
            buffer.append("WHERE FReport = '" + reportId + "'");
            st.addBatch(buffer.toString());
            buffer = new StringBuffer();
            buffer.append("Update T_CSL_InvestItemData \r\n");
            buffer.append("SET FCommitStatus =");
            buffer.append(commitStatus);
            if (commitStatus == 1) {
                buffer.append(",FCommitDate = null \r\n");
            } else {
                buffer.append(",FCommitDate = Date'" + time.toString() + "' \r\n");
            }
            buffer.append("WHERE FReportID = '" + reportId + "'");
            st.addBatch(buffer.toString());
            st.executeBatch();
            st.clearBatch();
        }
        catch (SQLException e2) {
            try {
                throw new SQLDataException(e2);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)cn);
    }

    @Override
    protected String _calcFomulaString(Context ctx, IObjectValue reportInfo, String formula) throws BOSException {
        try {
            Book book = Book.Manager.getNewBook(null, (int)1);
            Dependents deps = book.getDeps();
            ReportCalculateErrorProvider errorhandler = null;
            errorhandler = (ReportCalculateErrorProvider)reportInfo.get("RPT_ERRORHANDLER");
            deps.getFunctionManager().setErrorProvider(EASBizException.class, (IErrorProvider)errorhandler);
            ReportCalculateErrorProvider.clear();
            ReportCalculateErrorProvider.addErrorProvider(EASBizException.class, (IErrorProvider)errorhandler);
            deps.getFunctionManager().addFunctionProvider((Object)new ReportCaclProxy(ctx, book, reportInfo), true);
            ReportBatchCalculateProvider rptBatchCalc = new ReportBatchCalculateProvider(ctx, (ReportBaseInfo)reportInfo);
            deps.getFunctionManager().addFunctionProvider((Object)rptBatchCalc, true);
            ReportBatchCalculatorImpl impl = new ReportBatchCalculatorImpl();
            ReportCalculateContext calcContext = new ReportCalculateContext(ctx);
            ReportInfo report = (ReportInfo)reportInfo.cast(ReportInfo.class);
            if (report.getPeriodType() == null) {
                report.setPeriodType(RptPeriodTypeEnum.MONTHLY);
            }
            calcContext.setReportAdapter((IReportPropertyAdapter)new RptReportPropertyAdapter(report));
            calcContext.setErrorProvider((IErrorProvider)errorhandler);
            ReportVariables iv = VariablesHelper.sheetParams2Variables((ReportInfo)report);
            for (int i = 0; i < iv.getAllVariables().size(); ++i) {
                ((VariableEntry)iv.getAllVariables().get(i)).setSheetName(book.getSheet(0).getSheetName());
            }
            calcContext.setReportVariables(iv);
            impl.initCalculateContext((ICalculateContextProvider)calcContext);
            deps.getFunctionManager().addFunctionProvider((Object)impl, true);
            book.getUndoManager().enable(false);
            book.setCalculate(false);
            book.getUndoManager().enable(true);
            Variant res = null;
            book.getSheet(0).getCell(0, 0, true).setFormula(formula);
            book.getSheet(0).calc();
            res = book.getSheet(0).getCell(0, 0, true).getValue();
            if (res == null) {
                return "  ";
            }
            return res.toString();
        }
        catch (Exception ex) {
            logger.debug((Object)ex.getMessage());
            return "EXCEPTION";
        }
    }

    @Override
    protected void _savePlace(Context ctx, ArrayList list) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("*"));
        view.setFilter(new FilterInfo());
        HashSet set = new HashSet();
        for (int i = 1; i < list.size(); ++i) {
            set.add(list.get(i));
        }
        view.getFilter().getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        ReportCollection collect = ReportFactory.getLocalInstance(ctx).getReportCollection(view);
        Iterator it = collect.iterator();
        while (it.hasNext()) {
            try {
                ReportInfo report = (ReportInfo)it.next();
                report.getSavePoint().clear();
                ReportTypeCollection savePointReportTypeColl = (ReportTypeCollection)((Object)list.get(0));
                if (savePointReportTypeColl != null && savePointReportTypeColl.size() > 0) {
                    int savePointReportTypeCollSize = savePointReportTypeColl.size();
                    for (int i = 0; i < savePointReportTypeCollSize; ++i) {
                        RptTypeRelaInfo temp = new RptTypeRelaInfo();
                        temp.setRptType(savePointReportTypeColl.get(i));
                        temp.setRelaType(ReportTypeEnum.REPORT);
                        report.getSavePoint().add(temp);
                    }
                }
                String lastUpdateUserID = null;
                if (report.getLastUpdateUser() != null && report.getLastUpdateUser().getId() != null) {
                    lastUpdateUserID = report.getLastUpdateUser().getId().toString();
                }
                Timestamp updateTime = report.getLastUpdateTime();
                super.savePlace(ctx, (IObjectPK)new ObjectUuidPK(report.getId()), (IObjectValue)report);
                if (lastUpdateUserID == null) continue;
                String sql = "update T_RPT_Report set FLastUpdateUserID = ?, FLastUpdateTime = ?  where FID = ? ";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{lastUpdateUserID, updateTime, report.getId().toString()});
            }
            catch (Exception ex) {
                logger.debug((Object)ex.getStackTrace(), (Throwable)ex);
            }
        }
    }

    @Override
    protected String _batchAddNewReport(Context ctx, Set templateIdSet, String companyID, String currencyID, Object[] rptPath, int[] yearAndPeriod) throws BOSException, EASBizException {
        HashMap<String, TemplateInfo> templateInfoMap = new HashMap<String, TemplateInfo>();
        HashMap<String, TemplateReportSavePointCollection> reportSaveInfoMap = new HashMap<String, TemplateReportSavePointCollection>();
        HashMap<String, ReportTypeInfo> reportTypeInfoMap = new HashMap<String, ReportTypeInfo>();
        FullOrgUnitInfo companyInfo = null;
        OrgType orgType = OrgType.Company;
        if (rptPath != null && rptPath.length == 1 && rptPath[0] instanceof OrgType) {
            orgType = (OrgType)rptPath[0];
            rptPath = null;
        }
        if (templateIdSet.size() > 0) {
            companyInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyID)));
            EntityViewInfo v = new EntityViewInfo();
            SelectorItemCollection selector = v.getSelector();
            selector.add(new SelectorItemInfo("*"));
            selector.add(new SelectorItemInfo("company.*"));
            FilterInfo f = new FilterInfo();
            v.setFilter(f);
            f.getFilterItems().add(new FilterItemInfo("id", (Object)templateIdSet, CompareType.INCLUDE));
            TemplateCollection templates = TemplateFactory.getLocalInstance(ctx).getTemplateCollection(v);
            for (int i = 0; i < templates.size(); ++i) {
                templateInfoMap.put(templates.get(i).getId().toString(), templates.get(i));
            }
            f = new FilterInfo();
            f.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID));
            f.getFilterItems().add(new FilterItemInfo("template.id", (Object)templateIdSet, CompareType.INCLUDE));
            v = new EntityViewInfo();
            v.getSelector().add(new SelectorItemInfo("*"));
            v.setFilter(f);
            TemplateReportSavePointCollection rpts = TemplateReportSavePointFactory.getLocalInstance(ctx).getCollection(v);
            for (int i = 0; i < rpts.size(); ++i) {
                TemplateReportSavePointInfo rpt = rpts.get(i);
                TemplateReportSavePointCollection c = new TemplateReportSavePointCollection();
                if (reportSaveInfoMap.containsKey(rpt.getTemplate().getId().toString())) {
                    c = (TemplateReportSavePointCollection)((Object)reportSaveInfoMap.get(rpt.getTemplate().getId().toString()));
                }
                c.add(rpt);
                reportSaveInfoMap.put(rpt.getTemplate().getId().toString(), c);
            }
            HashSet<String> savePointIdSet = new HashSet<String>();
            try {
                for (TemplateReportSavePointCollection ccc : reportSaveInfoMap.values()) {
                    TemplateReportSavePointInfo spInfo = ccc.get(0);
                    ByteArrayInputStream ins = new ByteArrayInputStream(spInfo.getIds());
                    ObjectInputStream in = new ObjectInputStream(ins);
                    int count = in.readInt();
                    for (int j = 0; j < count; ++j) {
                        savePointIdSet.add(in.readObject().toString());
                    }
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            if (savePointIdSet.size() > 0) {
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", savePointIdSet, CompareType.INCLUDE));
                EntityViewInfo entityView = new EntityViewInfo();
                entityView.setFilter(filterInfo);
                entityView.getSelector().add(new SelectorItemInfo("*"));
                ReportTypeCollection r = ReportTypeFactory.getLocalInstance(ctx).getReportTypeCollection(entityView);
                for (int i = 0; i < r.size(); ++i) {
                    reportTypeInfoMap.put(r.get(i).getId().toString(), r.get(i));
                }
            }
        }
        CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectStringPK(currencyID));
        EntityViewInfo templateView = new EntityViewInfo();
        templateView.getSelector().add(new SelectorItemInfo("id"));
        templateView.getSelector().add(new SelectorItemInfo("number"));
        templateView.getSelector().add(new SelectorItemInfo("name"));
        templateView.getSelector().add(new SelectorItemInfo("templateType"));
        templateView.getSelector().add(new SelectorItemInfo("versionNumber"));
        templateView.getSelector().add(new SelectorItemInfo("periodType"));
        templateView.getSelector().add(new SelectorItemInfo("data"));
        templateView.getSelector().add(new SelectorItemInfo("group"));
        templateView.getSelector().add(new SelectorItemInfo("description"));
        templateView.getSelector().add(new SelectorItemInfo("isK3Tpl"));
        templateView.getSelector().add(new SelectorItemInfo("easTplIdForK3"));
        templateView.getSelector().add(new SelectorItemInfo("templateSource"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)templateIdSet, CompareType.INCLUDE));
        templateView.getSorter().add(new SorterItemInfo("number"));
        templateView.setFilter(filterInfo);
        ITemplate template = TemplateFactory.getLocalInstance(ctx);
        TemplateCollection selectTemplate = template.getTemplateCollection(templateView);
        HashMap<String, TemplateInfo> easTplMap = new HashMap<String, TemplateInfo>();
        HashSet<String> grpTmplIDs = new HashSet<String>();
        int len = selectTemplate.size();
        for (int i = 0; i < len; ++i) {
            if (!selectTemplate.get(i).isIsK3Tpl()) continue;
            grpTmplIDs.add(selectTemplate.get(i).getEasTplIdForK3());
        }
        if (grpTmplIDs.size() > 0) {
            templateView = new EntityViewInfo();
            SelectorItemCollection selector = templateView.getSelector();
            selector.add(new SelectorItemInfo("*"));
            selector.add(new SelectorItemInfo("company.*"));
            FilterInfo filterInfo2 = new FilterInfo();
            filterInfo2.getFilterItems().add(new FilterItemInfo("id", grpTmplIDs, CompareType.INCLUDE));
            templateView.setFilter(filterInfo2);
            TemplateCollection easTmplCol = TemplateFactory.getLocalInstance(ctx).getTemplateCollection(templateView);
            int len2 = easTmplCol.size();
            for (int i = 0; i < len2; ++i) {
                easTplMap.put(easTmplCol.get(i).getId().toString(), easTmplCol.get(i));
            }
        }
        IReport ireport = ReportFactory.getLocalInstance(ctx);
        StringBuffer buf = new StringBuffer();
        String param = null;
        PublicStatusEnum item = null;
        try {
            param = ParamManager.getParamValue((Context)ctx, null, (String)"fi_rp_005");
            item = "true".equalsIgnoreCase(param) ? PublicStatusEnum.PUBLIC : PublicStatusEnum.UNPUBLIC;
        }
        catch (Exception e1) {
            item = PublicStatusEnum.PUBLIC;
        }
        boolean[] params = this.batchgetParam(ctx);
        boolean isMergeByFiscalPeriod = params[0];
        boolean isSupport13Period = params[1];
        PeriodCollection perCollection = null;
        HashMap<String, PeriodCollection> cachePeriodCollection = isMergeByFiscalPeriod ? new HashMap<String, PeriodCollection>() : null;
        for (int i = 0; i < selectTemplate.size(); ++i) {
            TemplateInfo t = selectTemplate.get(i);
            ReportInfo info = new ReportInfo();
            if (companyInfo == null) {
                FullOrgUnitInfo comp = new FullOrgUnitInfo();
                comp.setId(BOSUuid.read((String)companyID));
                info.setCompany(comp);
            } else {
                info.setCompany(companyInfo);
            }
            if (isMergeByFiscalPeriod) {
                String key = info.getCompany().getId().toString();
                if (cachePeriodCollection != null && cachePeriodCollection.containsKey(key)) {
                    perCollection = (PeriodCollection)cachePeriodCollection.get(key);
                } else {
                    perCollection = FiscalPeriodHelper.getPeriodCollection((Context)ctx, (String)key);
                    if (cachePeriodCollection == null) {
                        cachePeriodCollection = new HashMap();
                    }
                    cachePeriodCollection.put(key, perCollection);
                }
            }
            info.setYear(yearAndPeriod[0]);
            info.setPeriod((short)yearAndPeriod[1]);
            info.setExchangeRate(new BigDecimal("0"));
            info.setPeriodType(t.getPeriodType());
            info.setCurrency(currency);
            info.setPublicStatus(item);
            info.setDataCollect(DataCollectConstant.getActualDC());
            info.setDataCollectNumber(DataCollectConstant.getActualDC().getNumber());
            try {
                RptCheckExpTank tank;
                Book book = t.getBook();
                ReportVariables variables = ReportVariables.loadFromBook((Book)book);
                BookProperties properties = BookProperties.loadFromBook(book);
                if (properties == null) {
                    properties = new BookProperties();
                    properties.restoreToBook(book);
                }
                if (variables == null) {
                    variables = properties.getVariables();
                }
                if ((tank = properties.getOperationSchema().getExpTank()) != null && tank.getExpressions() != null) {
                    Iterator it = tank.getExpressions().iterator();
                    RptCheckExpression exp = null;
                    while (it.hasNext()) {
                        exp = (RptCheckExpression)it.next();
                        if (exp == null) continue;
                        exp.setStatus(0);
                    }
                    t.setBook(book);
                }
                for (int j = 0; j < book.getSheetCount(); ++j) {
                    Sheet sheet = book.getSheet(j);
                    String name = sheet.getSheetName();
                    RptSheetParamInfo pinfo = VariablesHelper.variables2SheetParams((ReportVariables)variables, (String)name, (boolean)true, (Context)ctx);
                    pinfo.setSheetID(sheet.getID());
                    pinfo.setRelaType(ReportTypeEnum.REPORT);
                    info.getSheetParam().add(pinfo);
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            info.setPublishedStatus(PublishedStatusEnum.UNPUBLISHED);
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
            info.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
            info.setCommittedStatus(CommittedStatusEnum.UNCOMMITTED);
            info.setIsSupportGroup(IsSupportGroupReportEnum.NOTSUPPORT);
            info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            info.setDescription(t.getDescription());
            info.setOrgType(orgType);
            Date[] beginDateAndEndDate = this.getBeginDateAndEndDate(ctx, info.getYear(), info.getPeriod(), perCollection, t.getPeriodType(), isMergeByFiscalPeriod);
            info.setStartDate(beginDateAndEndDate[0]);
            info.setEndDate(beginDateAndEndDate[1]);
            FormulaSoluInfo formulaSoluInfo = FormulaSoluCalcHelp.getInstance().preRptDataFormulaSoluForServer(ctx, t.getData(), (OrgUnitInfo)companyInfo, t);
            byte[] data = formulaSoluInfo.getReportData();
            info.setData(data);
            if (t.getTemplateType().equals((Object)RptTmpTypeEnum.COMMONREPORT) || RptTmpTypeEnum.COMMONPUBLICTEMPLATE.equals((Object)t.getTemplateType())) {
                info.setSourceType(RptSrcTypeEnum.NORMAL);
            } else {
                RptTmpTypeEnum choosedTemplateType = t.getTemplateType();
                if (choosedTemplateType == RptTmpTypeEnum.DYNAMICNORMALREPORT || choosedTemplateType == RptTmpTypeEnum.RPTDYNAMICREPORT) {
                    info.setSourceType(RptSrcTypeEnum.DYNAMICNORMALREPORT);
                } else if (choosedTemplateType == RptTmpTypeEnum.MULTIDYNAMICCSLREPORT || choosedTemplateType == RptTmpTypeEnum.MULTIRPTDYNAMICREPORT) {
                    info.setSourceType(RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT);
                } else {
                    info.setSourceType(RptSrcTypeEnum.COMMITREPORT);
                }
            }
            try {
                if (t.isIsK3Tpl()) {
                    String easTmplID = t.getEasTplIdForK3();
                    if (!StringUtils.isEmpty((String)easTmplID)) {
                        info.setK3Template(t);
                        t = (TemplateInfo)easTplMap.get(easTmplID);
                    }
                } else {
                    t = (TemplateInfo)templateInfoMap.get(t.getId().toString());
                }
                if (t == null) continue;
                info.setTemplate(t);
                this.createNumberNew(ctx, info);
                info.setName(t.getName());
                TemplateReportSavePointCollection ccc = (TemplateReportSavePointCollection)((Object)reportSaveInfoMap.get(t.getId().toString()));
                if (ccc != null && ccc.size() > 0 || rptPath != null) {
                    if (ccc != null && ccc.size() > 0) {
                        TemplateReportSavePointInfo spInfo = ccc.get(0);
                        ReportTypeCollection r = new ReportTypeCollection();
                        ByteArrayInputStream ins = new ByteArrayInputStream(spInfo.getIds());
                        ObjectInputStream in = new ObjectInputStream(ins);
                        int count = in.readInt();
                        for (int j = 0; j < count; ++j) {
                            String key = in.readObject().toString();
                            if (!reportTypeInfoMap.containsKey(key)) continue;
                            r.add((ReportTypeInfo)reportTypeInfoMap.get(key));
                        }
                        if (r != null && r.size() > 0) {
                            for (int k = 0; k < r.size(); ++k) {
                                RptTypeRelaInfo temp = new RptTypeRelaInfo();
                                temp.setRptType(r.get(k));
                                temp.setRelaType(ReportTypeEnum.REPORT);
                                info.getSavePoint().add(temp);
                            }
                        }
                    } else {
                        Object[] os = rptPath;
                        if (os != null) {
                            for (int kk = 0; kk < os.length; ++kk) {
                                if (!(os[kk] instanceof ReportTypeInfo)) continue;
                                RptTypeRelaInfo temp = new RptTypeRelaInfo();
                                temp.setRptType((ReportTypeInfo)os[kk]);
                                temp.setRelaType(ReportTypeEnum.REPORT);
                                info.getSavePoint().add(temp);
                            }
                        }
                    }
                }
                this.addnew(ctx, info, isSupport13Period, isMergeByFiscalPeriod, formulaSoluInfo);
                buf.append(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"5_ReportControllerBean", (Locale)ctx.getOriginLocale()) + " " + t.getName() + " " + ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"6_ReportControllerBean", (Locale)ctx.getOriginLocale()) + " " + info.getName() + " " + ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"7_ReportControllerBean", (Locale)ctx.getOriginLocale()).replaceAll("\\\\r", "\r").replaceAll("\\\\n", "\n"));
                buf.append("\r\n");
                continue;
            }
            catch (Exception e3) {
                logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"8_ReportControllerBean", (Locale)ctx.getOriginLocale()), (Throwable)e3);
                buf.append(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"5_ReportControllerBean", (Locale)ctx.getOriginLocale()) + " " + t.getName() + " " + ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"6_ReportControllerBean", (Locale)ctx.getOriginLocale()) + " " + info.getName() + " " + ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"9_ReportControllerBean", (Locale)ctx.getOriginLocale()) + "\r\n        " + ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"9_ReportControllerBean_1", (Locale)ctx.getOriginLocale()) + " " + e3.getMessage() + "\r\n");
            }
        }
        return buf.toString();
    }

    private int[] getYearAndPeriod(RptPeriodTypeEnum RptPeriodTypeE, Date date1, boolean isMergeByFiscalPeriod, PeriodCollection periods) {
        if (date1 != null) {
            if (FiscalPeriodHelper.isMergeByFiscalPeriod((boolean)isMergeByFiscalPeriod, (RptPeriodTypeEnum)RptPeriodTypeE)) {
                return FiscalPeriodHelper.getPeriod((Date)date1, (RptPeriodTypeEnum)RptPeriodTypeE, (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod);
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(date1);
            int year = cal.get(1);
            int month = cal.get(2) + 1;
            int day = cal.get(5);
            int[] yp = new int[]{year, RPTDateUtil.getPeriod((int)year, (int)month, (int)day, (RptPeriodTypeEnum)RptPeriodTypeE)};
            return yp;
        }
        return null;
    }

    private ICodingRuleManager getICodingRuleManager(Context ctx) throws Exception {
        return CodingRuleManagerFactory.getLocalInstance((Context)ctx);
    }

    protected int createNumberNew(Context ctx, ReportBaseInfo baseInfo) throws EASBizException, BOSException {
        if (baseInfo == null) {
            return -2;
        }
        if (baseInfo.getNumber() != null && baseInfo.getNumber().toString().trim().length() > 0) {
            return -3;
        }
        String number = null;
        ICodingRuleManager iCodingRuleManager = null;
        CodingRuleInfo codingRule = null;
        CompanyOrgUnitInfo company = this.getCompanyForNumber(ctx, baseInfo);
        if (null == company) {
            return -1;
        }
        String companyID = company.getId().toString();
        iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        boolean isCodingRule = iCodingRuleManager.isExist((IObjectValue)baseInfo, companyID, "sourceType");
        if (isCodingRule) {
            codingRule = iCodingRuleManager.getCodingRule((IObjectValue)baseInfo, companyID, "sourceType");
        } else {
            isCodingRule = iCodingRuleManager.isExist((IObjectValue)baseInfo, companyID);
            if (isCodingRule) {
                codingRule = iCodingRuleManager.getCodingRule((IObjectValue)baseInfo, companyID);
            }
        }
        if (!isCodingRule || codingRule == null) {
            if (StringUtils.isEmpty(number)) {
                FilterInfo filterInfo;
                boolean isExists;
                String templateNumber = null;
                templateNumber = baseInfo.getTemplate() == null ? "NOTPL" : baseInfo.getTemplate().getNumber();
                String str = templateNumber + "_" + baseInfo.getYear() + "_" + baseInfo.getPeriod() + "_" + baseInfo.getCurrency().getNumber() + "_";
                int index = 0;
                do {
                    filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)(str + ++index)));
                } while (isExists = ReportFactory.getLocalInstance(ctx).exists(filterInfo));
                baseInfo.setNumber(str + index);
            }
            return 0;
        }
        number = iCodingRuleManager.getNumber((IObjectValue)baseInfo, codingRule);
        baseInfo.setNumber(number);
        return 1;
    }

    private CompanyOrgUnitInfo getCompanyForNumber(Context ctx, ReportBaseInfo baseInfo) throws EASBizException, BOSException {
        FullOrgUnitInfo company = baseInfo.getCompany();
        if (company == null || null == company.getId() || company.getId().toString().equals("")) {
            return null;
        }
        CompanyOrgUnitInfo org = MultOrgUnitHelper.getInstance().getDelegateCompanyNoOrgType((OrgUnitInfo)company, ctx);
        return org;
    }

    protected void createNumber(Context ctx, ReportInfo editData, String companyID, CompanyOrgUnitInfo rootOrg, HashMap existCodingRuleMap) throws CodingRuleException, EASBizException, BOSException, Exception {
        if (companyID != null) {
            int codingRuleType = 0;
            boolean isCodingRule = false;
            boolean isUseIntermitNumber = false;
            ICodingRuleManager iCodingRuleManager = this.getICodingRuleManager(ctx);
            isCodingRule = iCodingRuleManager.isExist((IObjectValue)editData, companyID, "sourceType");
            if (isCodingRule) {
                codingRuleType = 2;
                isUseIntermitNumber = iCodingRuleManager.isUseIntermitNumber((IObjectValue)editData, companyID, "sourceType");
            } else {
                isCodingRule = iCodingRuleManager.isExist((IObjectValue)editData, companyID);
                if (isCodingRule) {
                    codingRuleType = 1;
                    isUseIntermitNumber = iCodingRuleManager.isUseIntermitNumber((IObjectValue)editData, companyID);
                } else {
                    codingRuleType = 0;
                }
            }
            if (isCodingRule) {
                String number = "";
                switch (codingRuleType) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (isUseIntermitNumber) {
                            number = iCodingRuleManager.getNonbreakNumber((IObjectValue)editData, companyID);
                            break;
                        }
                        number = iCodingRuleManager.getNumber((IObjectValue)editData, companyID);
                        break;
                    }
                    case 2: {
                        number = isUseIntermitNumber ? iCodingRuleManager.getNonbreakNumber((IObjectValue)editData, companyID, "sourceType", "") : iCodingRuleManager.getNumber((IObjectValue)editData, companyID, "sourceType", "");
                    }
                }
                editData.setNumber(number);
            } else if (rootOrg != null) {
                String rootOrgNumber = rootOrg.getId().toString();
                isCodingRule = iCodingRuleManager.isExist((IObjectValue)editData, rootOrgNumber, "sourceType");
                if (isCodingRule) {
                    codingRuleType = 2;
                    isUseIntermitNumber = iCodingRuleManager.isUseIntermitNumber((IObjectValue)editData, rootOrgNumber, "sourceType");
                } else {
                    isCodingRule = iCodingRuleManager.isExist((IObjectValue)editData, rootOrgNumber);
                    if (isCodingRule) {
                        codingRuleType = 1;
                        isUseIntermitNumber = iCodingRuleManager.isUseIntermitNumber((IObjectValue)editData, rootOrgNumber);
                    } else {
                        codingRuleType = 0;
                    }
                }
                if (isCodingRule) {
                    String number = "";
                    switch (codingRuleType) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            if (isUseIntermitNumber) {
                                number = iCodingRuleManager.getNonbreakNumber((IObjectValue)editData, rootOrgNumber);
                                break;
                            }
                            number = iCodingRuleManager.getNumber((IObjectValue)editData, rootOrgNumber);
                            break;
                        }
                        case 2: {
                            number = isUseIntermitNumber ? iCodingRuleManager.getNonbreakNumber((IObjectValue)editData, rootOrgNumber, "sourceType", "") : iCodingRuleManager.getNumber((IObjectValue)editData, rootOrgNumber, "sourceType", "");
                        }
                    }
                    editData.setNumber(number);
                }
            }
        }
        if (editData.getNumber() == null || editData.getNumber().trim().length() == 0) {
            EntityViewInfo view;
            ReportBaseCollection c;
            String str = editData.getTemplate().getNumber() + "_" + editData.getYear() + "_" + editData.getPeriod() + "_" + editData.getCurrency().getNumber() + "_";
            int index = 0;
            do {
                view = new EntityViewInfo();
                view.getSelector().add(new SelectorItemInfo("number"));
                view.setFilter(new FilterInfo());
                view.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)(str + ++index)));
            } while ((c = ReportFactory.getLocalInstance(ctx).getReportBaseCollection(view)) != null && c.size() != 0);
            editData.setNumber(str + index);
        }
    }

    @Override
    protected Variant[] _calcFormulas(Context ctx, Map contextMap, List formulas) throws BOSException {
        for (Map.Entry entry : contextMap.entrySet()) {
            ctx.put(entry.getKey(), entry.getValue());
        }
        return this._calcFormulas(ctx, formulas);
    }

    @Override
    protected Variant[] _calcFormulas(Context ctx, Map contextMap, List formulas, IContextHandler contextHandler) throws BOSException {
        for (Map.Entry entry : contextMap.entrySet()) {
            ctx.put(entry.getKey(), entry.getValue());
        }
        return this._calcFormulas(ctx, formulas, contextHandler);
    }

    @Override
    protected Variant[] _calcFormulas(Context ctx, List formulas, IContextHandler handler) throws BOSException {
        int i;
        Book book = Book.Manager.getNewBook(null, (int)1);
        ReportCalculateContext calcContext = new ReportCalculateContext(ctx);
        calcContext.setPermission(new ChecFmlParamPermissionUtil(ctx));
        ReportInfo report = new ReportInfo();
        ReportVariables iv = VariablesHelper.sheetParams2Variables((ReportInfo)report);
        for (i = 0; i < iv.getAllVariables().size(); ++i) {
            ((VariableEntry)iv.getAllVariables().get(i)).setSheetName(book.getSheet(0).getSheetName());
        }
        calcContext.setReportVariables(iv);
        if (handler == null) {
            handler = new DefaultContextHandler();
        }
        handler.handlerContext(ctx, report, iv);
        calcContext.setReportAdapter((IReportPropertyAdapter)new RptReportPropertyAdapter(report));
        try {
            FormulaDefinition.registerFormulaToBook((Book)book, (ICalculateContextProvider)calcContext);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        book.getUndoManager().enable(false);
        book.setCalculate(false);
        for (i = 0; i < formulas.size(); ++i) {
            String formula = (String)formulas.get(i);
            book.getSheet(0).getCell(i, 0, true).setFormula(formula);
        }
        book.calc();
        book.getUndoManager().enable(false);
        Variant[] results = new Variant[formulas.size()];
        for (int i2 = 0; i2 < formulas.size(); ++i2) {
            results[i2] = book.getSheet(0).getCell(i2, 0, true).getValue();
        }
        return results;
    }

    @Override
    protected Variant[] _calcFormulas(Context ctx, List formulas) throws BOSException {
        return this._calcFormulas(ctx, formulas, null);
    }

    @Override
    protected void _tagUnsubmitReports(Context ctx, List reportIDs) throws BOSException, EASBizException {
        if (reportIDs == null || reportIDs.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer("update T_RPT_Report set FCommitTime=NULL ,FCommitorID = null,FAuditorID = NULL where FCslreportID in ");
        sql.append(RptUtilForServer.createInStringSql(reportIDs.iterator(), ctx));
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected List _getSelectIds(Context ctx, List idList) throws BOSException {
        ArrayList<String> list = new ArrayList<String>();
        if (idList != null && idList.size() > 0) {
            StringBuffer sqlBuffer = new StringBuffer("SELECT FID FROM T_RPT_Report WHERE FID IN ");
            sqlBuffer.append(RptUtilForServer.createInStringSql(idList.iterator(), ctx));
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
            try {
                while (iRowSet.next()) {
                    list.add(iRowSet.getString("FID"));
                }
            }
            catch (SQLException sqlex) {
                throw new BOSException((Throwable)sqlex);
            }
        }
        return list;
    }

    @Override
    protected HashMap _getReportsForBatchProcess(Context ctx, HashMap params) throws BOSException, EASBizException {
        EntityViewInfo entityView_for_loadReport = (EntityViewInfo)params.get("EntityViewWithoutPermission");
        EntityViewInfo entityView_for_loadReport_forPermission = (EntityViewInfo)params.get("EntityViewWithPermission");
        ReportBaseCollection reports = null;
        if (entityView_for_loadReport != null) {
            reports = ReportFactory.getLocalInstance(ctx).getReportBaseCollection(entityView_for_loadReport);
        }
        String permissionContidion = PermissionFactory.getLocalInstance((Context)ctx).getQueryPermissionSQL((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId()), (IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentFIUnit((Context)ctx).getId()), "rpt_report_view");
        String maskString = entityView_for_loadReport_forPermission.getFilter().getMaskString();
        if (!StringUtils.isEmpty((String)maskString) && !StringUtils.isEmpty((String)permissionContidion)) {
            try {
                FilterInfo permisFilter = new FilterInfo(" id in (" + permissionContidion + ")");
                entityView_for_loadReport_forPermission.getFilter().mergeFilter(permisFilter, "and");
                ReportBaseCollection reportsWithPermission = ReportFactory.getLocalInstance(ctx).getReportBaseCollection(entityView_for_loadReport_forPermission);
                if (reportsWithPermission != null && reportsWithPermission.size() > 0 && reports != null) {
                    reports.addCollection(reportsWithPermission);
                }
            }
            catch (Exception ex) {
                logger.error((Object)"get Reports error.", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
        }
        ArrayList<ReportInfo> allReports = new ArrayList<ReportInfo>();
        OneToManyMap tempMap = new OneToManyMap();
        Boolean hasViewP = (Boolean)params.get("hasViewP");
        if (reports != null && reports.size() > 0) {
            Iterator it = reports.iterator();
            while (it.hasNext()) {
                ReportInfo info = (ReportInfo)it.next();
                if (hasViewP.booleanValue()) {
                    info.put("select", new Boolean(true));
                    allReports.add(info);
                }
                if (info.getTemplate() == null) continue;
                tempMap.put(info.getTemplate().getNumber(), info);
            }
        }
        HashMap<String, Cloneable> returnValue = new HashMap<String, Cloneable>();
        returnValue.put("allReports", allReports);
        returnValue.put("tempMap", tempMap);
        return returnValue;
    }

    private ReportCollection getReportCollectionById(Context ctx, List ids) throws BOSException {
        HashSet set = new HashSet(ids);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("isSupportGroup"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("auditedStatus"));
        view.getSelector().add(new SelectorItemInfo("publishedStatus"));
        view.getSelector().add(new SelectorItemInfo("committedStatus"));
        view.getSelector().add(new SelectorItemInfo("sourceType"));
        view.getSelector().add(new SelectorItemInfo("cslReport"));
        view.getSelector().add(new SelectorItemInfo("PublicStatus"));
        view.getSelector().add(new SelectorItemInfo("year"));
        view.getSelector().add(new SelectorItemInfo("period"));
        view.getSelector().add(new SelectorItemInfo("periodType"));
        view.getSelector().add(new SelectorItemInfo("template.CheckOpenPeriod"));
        view.getSelector().add(new SelectorItemInfo("dataCollectNumber"));
        view.getSelector().add(new SelectorItemInfo("company.id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        view.setFilter(filter);
        return ReportFactory.getLocalInstance(ctx).getReportCollection(view);
    }

    public boolean IsAudit(ReportInfo reportInfo) throws BOSException {
        if (reportInfo == null) {
            return false;
        }
        return reportInfo.getAuditedStatus() != null && reportInfo.getAuditedStatus().getValue() == 2;
    }

    public boolean IsPublish(ReportInfo reportInfo) throws BOSException {
        if (reportInfo == null) {
            return false;
        }
        PublishedStatusEnum status = reportInfo.getPublishedStatus();
        return status != null && status.getValue() == 2;
    }

    @Override
    protected Map _batchCheckReportForBatchProcess(Context ctx, List reportIdList) throws BOSException, EASBizException {
        HashMap<String, Serializable> resultMap = new HashMap<String, Serializable>();
        StringBuffer auditedNumber = new StringBuffer();
        StringBuffer publishedNumber = new StringBuffer();
        StringBuffer inWorkFlowNumber = new StringBuffer();
        StringBuffer notCommitRpt = new StringBuffer();
        StringBuffer committedRpt = new StringBuffer();
        StringBuffer generalLedgerNotCheckout = new StringBuffer();
        ReportCollection reports = this.getReportCollectionById(ctx, reportIdList);
        ArrayList<String> idList = new ArrayList<String>();
        try {
            if (reports != null && reports.size() > 0) {
                HashSet<String> companyidset = new HashSet<String>();
                for (int i = 0; i < reports.size(); ++i) {
                    ReportInfo report = reports.get(i);
                    if (report == null || report.getTemplate() == null || !report.getTemplate().isCheckOpenPeriod()) continue;
                    companyidset.add(report.getCompany().getId().toString());
                }
                HashMap map = new HashMap();
                if (companyidset.size() > 0) {
                    map = CslRptUtil.getrptSysStatusCtrol((Context)ctx, companyidset);
                }
                int j = reports.size();
                for (int i = 0; i < j; ++i) {
                    ReportInfo report = reports.get(i);
                    if (report.getIsSupportGroup() == null || report.getIsSupportGroup() == IsSupportGroupReportEnum.NOTSUPPORT || report.getSourceType().getValue() != 7 && report.getSourceType().getValue() != 10 && report.getSourceType().getValue() != 13) {
                        if (notCommitRpt.length() > 0) {
                            notCommitRpt.append(", ");
                        }
                        notCommitRpt.append('\"').append(report.getName()).append('\"');
                        continue;
                    }
                    if (report.getCommittedStatus().getValue() == 2 || report.getCommittedStatus().getValue() == 3) {
                        if (committedRpt.length() > 0) {
                            committedRpt.append(", ");
                        }
                        committedRpt.append('\"').append(report.getName()).append('\"');
                        continue;
                    }
                    if (!this.IsAudit(report)) {
                        if (auditedNumber.length() > 0) {
                            auditedNumber.append(", ");
                        }
                        auditedNumber.append('\"').append(report.getName()).append('\"');
                        continue;
                    }
                    if (this.IsPublish(report)) {
                        if (publishedNumber.length() > 0) {
                            publishedNumber.append(", ");
                        }
                        publishedNumber.append('\"').append(report.getName()).append('\"');
                        continue;
                    }
                    if (RptUtilForServer.editDataIsInWorkflow(ctx, null, report.getId().toString())) {
                        if (inWorkFlowNumber.length() > 0) {
                            inWorkFlowNumber.append(", ");
                        }
                        inWorkFlowNumber.append('\"').append(report.getName()).append('\"');
                        continue;
                    }
                    if (!CslRptUtil.checkGeneralLedgerIsCheckout((Context)ctx, (Map)map, (ReportBaseInfo)report)) {
                        if (generalLedgerNotCheckout.length() > 0) {
                            generalLedgerNotCheckout.append(", ");
                        }
                        generalLedgerNotCheckout.append('\"').append(report.getName()).append('\"');
                        continue;
                    }
                    idList.add(report.getId().toString());
                }
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        resultMap.put("idList", idList);
        resultMap.put("auditedNumber", auditedNumber);
        resultMap.put("publishedNumber", publishedNumber);
        resultMap.put("inWorkFlowNumber", inWorkFlowNumber);
        resultMap.put("notCommitRpt", notCommitRpt);
        resultMap.put("committedRpt", committedRpt);
        resultMap.put("generalLedgerNotCheckout", generalLedgerNotCheckout);
        return resultMap;
    }

    @Override
    protected boolean _setDebugLogger(Context ctx, boolean isDebug) throws BOSException, EASBizException {
        DebugLogger.setDebugLogger(ctx, isDebug);
        TemplateDispenseNewUtil.clearAllServerNewTempletDisOrgTreeSet((Context)ctx);
        return false;
    }

    public void checkCslReportDump(Context ctx, ReportInfo info) throws BOSException, RptAndTempException, EASBizException {
        String dataCollectNumber;
        if (info.getSourceType() != null && info.getSourceType().equals((Object)RptSrcTypeEnum.COMMOMSUM)) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("periodType", (Object)info.getPeriodType()));
        if (info.getPeriodType().equals((Object)RptPeriodTypeEnum.DAILY)) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("startDate", (Object)info.getStartDate()));
            view.getFilter().getFilterItems().add(new FilterItemInfo("endDate", (Object)info.getEndDate()));
        } else if (info.getPeriodType().equals((Object)RptPeriodTypeEnum.YEARLY)) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("year", (Object)new Integer(info.getYear())));
        } else {
            view.getFilter().getFilterItems().add(new FilterItemInfo("year", (Object)new Integer(info.getYear())));
            view.getFilter().getFilterItems().add(new FilterItemInfo("period", (Object)new Short(info.getPeriod())));
        }
        if (info.getTemplate() == null) {
            return;
        }
        view.getFilter().getFilterItems().add(new FilterItemInfo("template.group", (Object)info.getTemplate().getGroup()));
        if (info.getCompany() != null) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("company", (Object)info.getCompany().getId().toString()));
        }
        if (info.getCurrency() != null) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("currency", (Object)info.getCurrency().getId().toString()));
        }
        if (info.getSourceCurrency() != null) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("sourceCurrency", (Object)info.getSourceCurrency().getId().toString()));
        } else {
            view.getFilter().getFilterItems().add(new FilterItemInfo("sourceCurrency", null));
        }
        if (info.getCslReport() != null) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)info.getCslReport().getId().toString(), CompareType.NOTEQUALS));
        }
        if (!(dataCollectNumber = info.getDataCollectNumber()).equals("") && dataCollectNumber != null) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("dataCollectNumber", (Object)dataCollectNumber, CompareType.EQUALS));
        }
        SelectorItemCollection sitem = view.getSelector();
        sitem.add("fid");
        CslReportCollection c = CslReportFactory.getLocalInstance((Context)ctx).getCslReportCollection(view);
        ArrayList<BOSUuid> condition = new ArrayList<BOSUuid>();
        for (int i = 0; i < c.size(); ++i) {
            condition.add(c.get(i).getId());
        }
        if (c.size() > 0) {
            EntityViewInfo viewReport = new EntityViewInfo();
            viewReport.setFilter(new FilterInfo());
            viewReport.getFilter().getFilterItems().add(new FilterItemInfo("cslReport", new HashSet(condition), CompareType.INCLUDE));
            ReportCollection reports = ReportFactory.getLocalInstance(ctx).getReportCollection(viewReport);
            if (c.size() > reports.size()) {
                throw new CslRptCommitException(CslRptCommitException.EXISTCSLREPORT);
            }
        }
    }

    @Override
    protected Map _copyHisRpt(Context ctx, List rptIdList, Map params) throws BOSException, EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        for (String id : rptIdList) {
            idSet.add(id);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.getSelector().add("*");
        view.getSelector().add("template.id");
        view.getSelector().add("template.name");
        view.getSelector().add("template.number");
        view.getSelector().add("template.group");
        view.getSelector().add("currency.id");
        view.getSelector().add("currency.number");
        view.getSelector().add("currency.name");
        view.getSelector().add("sourceCurrency.id");
        view.getSelector().add("savePoint.*");
        view.getSelector().add("sheetParam.*");
        view.getSelector().add("postils.*");
        view.getSelector().add("postils.report.id");
        view.getSelector().add("postils.sheet.id");
        view.getSelector().add("postils.sheet.sheetid");
        view.getSelector().add("postils.creator.id");
        view.getSelector().add("postils.creator.name");
        view.getSelector().add("company.id");
        view.getSelector().add("company.name");
        view.getSelector().add("company.number");
        view.getSelector().add("CU.id");
        view.getSelector().add("CU.name");
        view.getSelector().add("CU.number");
        view.getSelector().add("orgTree.id");
        view.getSelector().add("orgTree.name");
        view.getSelector().add("orgTree.number");
        ReportCollection reportCollection = this.getReportCollection(ctx, view);
        int curYear = (Integer)params.get("year");
        int curPeriod = (Integer)params.get("period");
        ArrayList<String> faultRptList = new ArrayList<String>();
        StringBuffer faultRptMsg = null;
        ArrayList<String> faultTmplList = new ArrayList<String>();
        StringBuffer faultTmplMsg = null;
        int sucessCount = 0;
        ArrayList<String> idList = new ArrayList<String>();
        boolean isMergeByFiscalPeriod = FiscalPeriodHelper.isMergeByFiscalPeriod((Context)ctx);
        PeriodCollection perCollection = null;
        for (int i = 0; i < reportCollection.size(); ++i) {
            ReportInfo reportInfo = reportCollection.get(i);
            String oldId = reportInfo.getId().toString();
            ReportInfo copyInfo = (ReportInfo)reportInfo.clone();
            BOSUuid newBosId = BOSUuid.create((BOSObjectType)copyInfo.getBOSType());
            String newId = newBosId.toString();
            copyInfo.setId(newBosId);
            copyInfo.setNumber(null);
            copyInfo.setCslReport(null);
            copyInfo.setYear(curYear);
            copyInfo.setPeriod((short)curPeriod);
            if (isMergeByFiscalPeriod) {
                perCollection = FiscalPeriodHelper.getPeriodCollection((Context)ctx, (String)reportInfo.getCompany().getId().toString());
            }
            Date[] beginDateAndEndDate = this.getBeginDateAndEndDate(ctx, curYear, curPeriod, perCollection, reportInfo.getPeriodType(), isMergeByFiscalPeriod);
            copyInfo.setStartDate(beginDateAndEndDate[0]);
            copyInfo.setEndDate(beginDateAndEndDate[1]);
            copyInfo.setCreateTime(null);
            copyInfo.setCreator(null);
            copyInfo.setLastUpdateTime(null);
            copyInfo.setLastUpdateUser(null);
            copyInfo.setAuditor(null);
            copyInfo.setAuditTime(null);
            copyInfo.setCommitTime(null);
            copyInfo.setPublishedStatus(PublishedStatusEnum.UNPUBLISHED);
            copyInfo.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
            copyInfo.setCommittedStatus(CommittedStatusEnum.UNCOMMITTED);
            copyInfo.getPostils().clear();
            copyInfo.getSavePoint().clear();
            ConvertStatusEnum convertStatusEnum = copyInfo.getConvertStatus();
            if (convertStatusEnum != null && convertStatusEnum.getValue() == 1) {
                copyInfo.setSrcReport(null);
            }
            this.createNumberNew(ctx, copyInfo);
            boolean isExistsSsSupportGroup = false;
            if (reportInfo.getSourceType() != RptSrcTypeEnum.NORMAL) {
                String templateId = reportInfo.getTemplate().getId().toString();
                boolean isTheNewestVersionTemplate = this.checkReportCreatedByTheNewestVersionTemplate(ctx, templateId);
                if (!isTheNewestVersionTemplate) {
                    faultTmplMsg = new StringBuffer();
                    faultTmplMsg.append(copyInfo.getPeriodType().getAlias());
                    faultTmplMsg.append("  ");
                    faultTmplMsg.append(reportInfo.getYear());
                    faultTmplMsg.append("  ");
                    faultTmplMsg.append(reportInfo.getPeriod());
                    faultTmplMsg.append("  ");
                    faultTmplMsg.append(reportInfo.getNumber());
                    faultTmplMsg.append("  ");
                    faultTmplMsg.append(copyInfo.getName());
                    faultTmplMsg.append("  ");
                    faultTmplMsg.append(copyInfo.getCurrency().getName());
                    faultTmplList.add(faultTmplMsg.toString());
                    continue;
                }
                try {
                    this.checkCslReportDump(ctx, copyInfo);
                }
                catch (CslRptCommitException e) {
                    faultRptMsg = new StringBuffer();
                    faultRptMsg.append(copyInfo.getCurrency().getName());
                    faultRptMsg.append("  ");
                    faultRptMsg.append(copyInfo.getName());
                    faultRptMsg.append("  ");
                    faultRptMsg.append(copyInfo.getPeriodType().getAlias());
                    faultRptMsg.append("  ");
                    faultRptMsg.append(copyInfo.getYear());
                    faultRptMsg.append("  ");
                    faultRptMsg.append(copyInfo.getPeriod());
                    faultRptList.add(faultRptMsg.toString());
                    continue;
                }
                StringBuffer sub = new StringBuffer();
                sub.append("select count(*) from t_rpt_report a inner join t_rpt_template b on a.ftemplateid = b.fid where a.fcompanyid = ? and b.fgroup = ? and a.fcurrencyid = ? and a.fyear = ? and a.fperiod = ? and a.fperiodtype = ? and a.fdatacollectid = ? and a.FIsSupportGroup = ?");
                ArrayList<Object> para = new ArrayList<Object>();
                para.add(copyInfo.getCompany().getId().toString());
                para.add(copyInfo.getTemplate().getGroup());
                para.add(copyInfo.getCurrency().getId().toString());
                para.add(new Integer(copyInfo.getYear()));
                para.add(new Integer(copyInfo.getPeriod()));
                para.add(new Integer(copyInfo.getPeriodType().getValue()));
                para.add(copyInfo.getDataCollect().getId().toString());
                para.add(new Integer(1));
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sub.toString(), (Object[])para.toArray());
                try {
                    int c;
                    if (rowSet.next() && (c = rowSet.getInt(1)) > 0) {
                        isExistsSsSupportGroup = true;
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            this.submit(ctx, (CoreBaseInfo)copyInfo);
            if (reportInfo.getSourceType() != RptSrcTypeEnum.NORMAL) {
                int isSupportGroup = 1;
                if (isExistsSsSupportGroup) {
                    isSupportGroup = 2;
                }
                String sql = "update t_rpt_report set FIsSupportGroup = ? where fid = '" + newId + "'";
                Object[] paramArray = new Object[]{new Integer(isSupportGroup)};
                DbUtil.execute((Context)ctx, (String)sql, (Object[])paramArray);
            }
            StringBuffer _sql = new StringBuffer("delete from t_rpt_rptTypeRela where");
            _sql.append(" Freportid= ?");
            DbUtil.execute((Context)ctx, (String)_sql.toString(), (Object[])new Object[]{newId});
            ReportTypeCollection reportType = (ReportTypeCollection)((Object)params.get("pathColl"));
            if (reportType != null && reportType.size() > 0) {
                IRptTypeRela typeRela = RptTypeRelaFactory.getLocalInstance(ctx);
                int reportTypeSize = reportType.size();
                for (int j = 0; j < reportTypeSize; ++j) {
                    RptTypeRelaInfo temp = new RptTypeRelaInfo();
                    temp.setRptType(reportType.get(j));
                    temp.setRelaType(ReportTypeEnum.REPORT);
                    temp.setReport(copyInfo);
                    typeRela.addnew((CoreBaseInfo)temp);
                }
            }
            String newCslId = null;
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)"select fcslreportid from t_rpt_report where fid=?", (Object[])new Object[]{newId});
            try {
                if (rowSet.next()) {
                    newCslId = rowSet.getString(1);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            HashMap sheetMapping = new HashMap();
            DbUtil.execute((Context)ctx, (String)"delete t_rpt_RptSheetPara where freportid=?", (Object[])new Object[]{newId});
            UnionVersionUtil.insertReportSheetPara((Context)ctx, (String)oldId, (String)newId, sheetMapping);
            UnionVersionUtil.addCSLPostil((Context)ctx, (String)oldId, (String)newId, sheetMapping);
            if (newCslId != null && newCslId.length() > 0) {
                DbUtil.execute((Context)ctx, (String)"delete t_rpt_RptSheetPara where freportid=?", (Object[])new Object[]{newCslId});
                UnionVersionUtil.insertReportSheetPara((Context)ctx, (String)oldId, (String)newCslId, sheetMapping);
                UnionVersionUtil.addCSLPostil((Context)ctx, (String)oldId, (String)newCslId, sheetMapping);
            }
            idList.add(newId);
            ++sucessCount;
        }
        HashMap<String, Serializable> resultMap = new HashMap<String, Serializable>();
        resultMap.put("successCount", new Integer(sucessCount));
        resultMap.put("faultRptList", faultRptList);
        resultMap.put("faultTmplList", faultTmplList);
        resultMap.put("idList", idList);
        return resultMap;
    }

    private boolean checkReportCreatedByTheNewestVersionTemplate(Context ctx, String templateId) throws BOSException {
        String theNewestVersionTemplateId;
        String groupTemplateId = this.getGroupTemplateId(ctx, templateId);
        return groupTemplateId.equals(theNewestVersionTemplateId = this.getNewestTemplateId(ctx, groupTemplateId));
    }

    private String getGroupTemplateId(Context ctx, String templateId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" Select case when t.FGroupTemplateID is null then t.FId else t.FGroupTemplateID end as id  \n");
        sql.append(" From T_Rpt_Template t \n");
        sql.append(" Where t.FID = ? ");
        ArrayList<String> params = new ArrayList<String>();
        params.add(templateId);
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
            if (rs.next()) {
                return rs.getString("id");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private String getNewestTemplateId(Context ctx, String templateId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" Select t.FId as id  \n");
        sql.append(" From T_Rpt_Template t \n");
        sql.append(" Inner Join T_Rpt_Template t0 ON t.FGROUP  = t0.FGROUP \n");
        sql.append(" Where t0.FID  = ? And t.FVersionStatus = ? And t.FIsFreezed = ? And t.FIsK3Tpl = ? And t.FGroupTemplateID is null ");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(templateId);
        params.add(1);
        params.add(0);
        params.add(0);
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
            if (rs.next()) {
                return rs.getString("id");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private String generateNumber(Context ctx, ReportInfo reportInfo) throws BOSException, EASBizException {
        String rtnValue = null;
        String number = null;
        int year = reportInfo.getYear();
        short period = reportInfo.getPeriod();
        number = reportInfo.getTemplate() != null ? reportInfo.getTemplate().getNumber() : reportInfo.getNumber();
        StringBuffer numberPattern = new StringBuffer();
        numberPattern.append(number).append("_").append(year).append("_").append(period).append("_");
        StringBuffer sql = new StringBuffer();
        String fnumberTemplatePrefix = number + "#_" + year + "#_" + period + "#_";
        sql.append("select fnumber from t_rpt_report where fnumber like '");
        sql.append(fnumberTemplatePrefix);
        sql.append("______' escape '#'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String maxNumStr = null;
        int maxNum = 0;
        try {
            while (rowSet.next()) {
                int currNum;
                maxNumStr = rowSet.getString(1);
                if (!(maxNumStr = maxNumStr.substring(fnumberTemplatePrefix.length() - 3)).matches("[0-9]+") || (currNum = Integer.valueOf(maxNumStr).intValue()) <= maxNum) continue;
                maxNum = currNum;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (maxNumStr == null) {
            rtnValue = numberPattern.append("000001").toString();
        } else {
            if (++maxNum > 999999) {
                throw new ServerException(ServerException.REPORTMAXNUMBERSEQEXCEED);
            }
            String seqStr = String.valueOf(maxNum);
            int len = 6 - seqStr.length();
            StringBuffer zeroStr = new StringBuffer();
            for (int i = 0; i < len; ++i) {
                zeroStr.append("0");
            }
            seqStr = zeroStr + seqStr;
            rtnValue = numberPattern.append(seqStr).toString();
        }
        return rtnValue;
    }

    @Override
    protected IRowSet _getCopyReport(Context ctx, EntityViewInfo commonView, IMetaDataPK metaDataPK, int start, int length) throws BOSException, EASBizException {
        FilterInfo filterInfo = commonView.getFilter();
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
            commonView.setFilter(filterInfo);
        }
        String cmpIdTmp = null;
        int orgType = 1;
        int size = filterInfo.getFilterItems().size();
        for (int k = 0; k < size; ++k) {
            FilterItemInfo itemInfo = filterInfo.getFilterItems().get(k);
            if ("company.id".equalsIgnoreCase(itemInfo.getPropertyName())) {
                cmpIdTmp = (String)itemInfo.getCompareValue();
            }
            if (!"orgType".equalsIgnoreCase(itemInfo.getPropertyName())) continue;
            orgType = (Integer)itemInfo.getCompareValue();
        }
        String dataRule = null;
        String rptPermissionSQL = null;
        if (orgType == 1) {
            String companyid = StringUtils.isEmpty(cmpIdTmp) ? ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString() : cmpIdTmp;
            ObjectUuidPK currentUserPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
            IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
            rptPermissionSQL = iPermission.getQueryPermissionSQL((IObjectPK)currentUserPK, (IObjectPK)new ObjectUuidPK(companyid), "rpt_report_view");
            StringBuffer sql = new StringBuffer(rptPermissionSQL);
            dataRule = RptUtilForServer.getCommonDataRule(ctx, (IObjectPK)currentUserPK, (IObjectPK)new ObjectUuidPK(companyid), "rpt_report_view");
            String mask = filterInfo.getMaskString();
            FilterItemCollection filterItems = filterInfo.getFilterItems();
            if (filterInfo.getMaskString() == null && filterItems.size() > 0) {
                StringBuffer mask1 = new StringBuffer();
                for (int i = 0; i < filterItems.size(); ++i) {
                    if (i == 0) {
                        mask1.append(" #0 ");
                        continue;
                    }
                    mask1.append(" and #").append(i);
                }
                mask = mask1.toString();
            }
            filterInfo.setMaskString(mask);
            try {
                if (!StringUtils.isEmpty((String)rptPermissionSQL)) {
                    String permisionSql = " Report.id in (" + rptPermissionSQL + ")";
                    if (StringUtils.isEmpty((String)dataRule)) {
                        permisionSql = "Report.id in (select fid from t_rpt_report curRpt where fid in(" + rptPermissionSQL + ") or FPublicStatus =" + 2 + ")";
                    }
                    filterInfo.mergeFilter(new FilterInfo(permisionSql), "and");
                }
            }
            catch (Exception ex) {
                logger.error((Object)"", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
        }
        QueryExecuteOption queryExeOption = new QueryExecuteOption();
        queryExeOption.isAutoIgnoreZero = true;
        queryExeOption.isAutoTranslateBoolean = true;
        queryExeOption.isAutoTranslateEnum = true;
        queryExeOption.pageCount = KDTDataRequestManager.defaultPageRow;
        QueryDataAccess queryDataAccess = new QueryDataAccess(ctx);
        return queryDataAccess.getRowSet(metaDataPK, commonView, new HashMap(), queryExeOption, start, length);
    }

    @Override
    protected String _checkReport(Context ctx, int year, int period, int maxRow, int maxCol) throws BOSException, EASBizException {
        return CheckReport.checkReport(ctx, year, period, maxRow, maxCol).toString();
    }

    @Override
    protected boolean _isStartGLSystem(Context ctx, String companyID) throws BOSException {
        StringBuffer sb = new StringBuffer();
        boolean bool = false;
        sb.append("select fisstart \r\n");
        sb.append(" from T_BD_SystemStatusCtrol c \r\n");
        sb.append(" inner join T_BD_SystemStatus s on s.fid=c.FSystemStatusID \r\n");
        sb.append(" where s.FName = 6 and c.fcompanyid = '").append(companyID).append("' \r\n");
        IRowSet rs = DbUtil.executeQueryNoTx((Context)ctx, (String)sb.toString());
        try {
            if (rs.next() && "1".equals(rs.getString("fisstart"))) {
                bool = true;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return bool;
    }

    private Date[] getBeginDateAndEndDate(Context ctx, int year, int period, PeriodCollection perCollection, RptPeriodTypeEnum periodTypeEnum, boolean isMergeByFiscalPeriod) throws EASBizException, BOSException {
        Date startDate = FiscalPeriodHelper.getPeriodFirstDate((int)year, (int)period, (RptPeriodTypeEnum)periodTypeEnum, (PeriodCollection)perCollection, (boolean)isMergeByFiscalPeriod);
        Date endDate = FiscalPeriodHelper.getPeriodLastDate((PeriodCollection)perCollection, (int)year, (int)period, (RptPeriodTypeEnum)periodTypeEnum, (boolean)isMergeByFiscalPeriod);
        return new Date[]{startDate, endDate};
    }

    @Override
    protected boolean _isHasSpecialDataPerm(Context ctx, String userid, String companyid, String entityBosType, String permitemid) throws BOSException {
        try {
            int permtype = 0;
            int ownerexceptpermtype = 0;
            IRowSet rowSet = this.getPermType(ctx, userid, companyid, entityBosType, permitemid);
            if (rowSet.next()) {
                permtype = rowSet.getInt("permtype");
            }
            StringBuffer sql = new StringBuffer();
            sql.append(" select ownerexceptpermitem.fpermtype ownerexceptpermtype from t_pm_ownerexceptpermitem  ownerexceptpermitem  \n");
            sql.append(" inner join t_pm_ownerpermexcept ownerpermexcept ");
            sql.append(" on ownerpermexcept.fobjtype = ownerexceptpermitem.fobjtype and ownerpermexcept.fcontrolunitid = ownerexceptpermitem.fcontrolunitid \n");
            sql.append(" where ownerexceptpermitem.fcontrolunitid = ? and ownerexceptpermitem.fobjtype = ? \n");
            sql.append(" and ownerpermexcept.fuserid = ? and ownerexceptpermitem.fpermitemid = ? ");
            IRowSet ownerExceptRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyid, entityBosType, userid, permitemid});
            if (ownerExceptRowSet.next()) {
                ownerexceptpermtype = ownerExceptRowSet.getInt("ownerexceptpermtype");
            }
            if (10 == permtype) {
                return ownerexceptpermtype == 10;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"isHasSpecialDataPerm", (Throwable)e);
        }
        return true;
    }

    private IRowSet getPermType(Context ctx, String userid, String companyid, String entityBosType, String permitemid) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select datapermentry.fpermtype permtype from  t_pm_specialdatapermentry  datapermentry  \n");
        sql.append("inner join t_pm_specialdataperm  dataperm  on dataperm.fid = datapermentry.fspecialdatapermid \n");
        sql.append(" where dataperm.fcontrolunitid = ? and dataperm.fbizobjecttype = ? and dataperm.fisenablecreatorperm = 1 \n");
        sql.append(" and datapermentry.fpermitemid = ? \n");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyid, entityBosType, permitemid});
        return rowSet;
    }

    @Override
    protected Map _cyCover(Context ctx, List ids, Map convertParam) throws BOSException, EASBizException {
        String result = this.doCover(ctx, ids, convertParam, true);
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)result)) {
            map.put("status", "success");
        } else {
            map.put("status", "error");
            map.put("msg", result);
        }
        return map;
    }

    protected void _isReferenced(Context ctx, IObjectPK pk, Connection cn) throws ObjectReferedException {
        BizReference ref = null;
        try {
            ref = ReferenceDAO.getReference((Context)ctx, (BOSUuid)BOSUuid.read((String)pk.toString()));
        }
        catch (Exception e) {
            throw new ObjectReferedException((Object)ref, (Throwable)e);
        }
        if (this.isrptHisRelaRpt(ref)) {
            return;
        }
        if (ref != null) {
            logger.error((Object)(ref.getClass() + "," + ref.getRefEntityName() + "," + ref.getRefFieldName() + "," + ref.getRefFieldName() + "," + ref.getRefTableName()));
            throw new ObjectReferedException((Object)ref, (Throwable)new BizReferenceException(BizReferenceException.BIZ_REFENCED));
        }
    }

    private boolean isrptHisRelaRpt(BizReference ref) {
        if (ref == null) {
            return true;
        }
        return ref.getRefEntityName().equals("RptHistory") && ref.getRefFieldName().equals("FReportID") && ref.getRefTableName().equals("T_RPT_RptHistory");
    }

    @Override
    protected String _getLogInfo(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("sourceType");
        selector.add("year");
        selector.add("period");
        selector.add("name");
        selector.add("number");
        selector.add("company.name");
        ReportInfo info = this.getReportInfo(ctx, pk, selector);
        return info.getLogInfo();
    }

    @Override
    protected void _checkReportDataPermission(Context ctx, IObjectPK userPK, IObjectPK orgPK, String permItemName, IObjectPK dataPK) throws BOSException, EASBizException {
        DataPermissionService service = new DataPermissionService(ctx);
        try {
            ReportCollection rpts;
            if (("rpt_report_update".equals(permItemName) || "rpt_report_delete".equals(permItemName)) && (rpts = ReportFactory.getLocalInstance(ctx).getReportCollection("SELECT PublicStatus WHERE ID = '" + dataPK.toString() + "'")) != null && rpts.size() > 0 && rpts.get(0).getPublicStatus().getValue() == 2) {
                PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache((Context)ctx).getPermItem(ctx, permItemName);
                Method method = service.getClass().getDeclaredMethod("getCommonDataRule", IObjectPK.class, IObjectPK.class, PermItemInfo.class);
                NewRptUtil.makeAccessible((Method)method);
                String commonDataRule = (String)method.invoke((Object)service, userPK, orgPK, permItemInfo);
                if (StringUtils.isEmpty((String)commonDataRule)) {
                    return;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"_checkReportDataPermission error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        service.checkPermission(userPK, orgPK, permItemName, (Object)dataPK);
    }
}

