/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.PostilInfo;
import com.kingdee.eas.fi.rpt.PostilTypeEnum;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportCollection;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.DateTimeUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;

public class ReportToGroupHelper {
    public static CslReportInfo copyReportInfoToGroup(Context ctx, ReportInfo report) throws EASBizException, BOSException {
        AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
        String[] attachIDs = asm.getAttachmentIDsByBoID(report.getId().toString());
        CslReportInfo result = ReportToGroupHelper.rpt2CslRpt(ctx, report);
        if (report.getCslReport() != null && report.getCslReport().getId() != null) {
            result.setId(report.getCslReport().getId());
        }
        result.setIsSchemeUpdate(report.isIsSchemeUpdate());
        IObjectPK pk = CslReportFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)result);
        asm.addAssociations(pk.toString(), attachIDs);
        result.setId(BOSUuid.read((String)pk.toString()));
        return result;
    }

    protected static CslReportInfo rpt2CslRpt(Context ctx, ReportInfo report) throws EASBizException, BOSException {
        int i;
        boolean isUpdate = false;
        if (report.getCslReport() != null && report.getCslReport().getId() != null) {
            isUpdate = true;
        }
        CslReportInfo cslReport = new CslReportInfo();
        cslReport.setOrgUnit(report.getCompany().castToFullOrgUnitInfo());
        cslReport.setSourceCurrency(report.getCurrency());
        cslReport.setReportDate(DateTimeUtils.truncateDate((Date)report.getEndDate()));
        cslReport.setIsCommitReport(true);
        cslReport.setYear(report.getYear());
        short period = report.getPeriod();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(report.getEndDate());
        if (RptPeriodTypeEnum.DAILY.equals((Object)report.getPeriodType()) || RptPeriodTypeEnum.YEARLY.equals((Object)report.getPeriodType())) {
            period = (short)RPTDateUtil.getPeriod((int)calendar.get(1), (int)(calendar.get(2) + 1), (int)calendar.get(5), (RptPeriodTypeEnum)report.getPeriodType());
        }
        cslReport.setPeriod(period);
        cslReport.setStartDate(report.getStartDate());
        cslReport.setEndDate(report.getEndDate());
        cslReport.setAuditor(report.getAuditor());
        cslReport.setTemplate(report.getTemplate());
        cslReport.setCompany(report.getCompany());
        cslReport.setDataCollectNumber(DataCollectConstant.getDefaultDCNumber((String)report.getDataCollectNumber()));
        cslReport.setDataCollect(DataCollectConstant.getDefaultDataCollectInfo((DataCollectInfo)report.getDataCollect()));
        cslReport.setPeriodType(report.getPeriodType());
        cslReport.setPublicStatus(report.getPublicStatus());
        cslReport.setPublishedStatus(report.getPublishedStatus());
        cslReport.setCommittedStatus(report.getCommittedStatus());
        if (!RptSrcTypeEnum.DYNAMICNORMALREPORT.equals((Object)report.getSourceType()) && !RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT.equals((Object)report.getSourceType())) {
            cslReport.setSourceType(RptSrcTypeEnum.NORMAL);
        } else if (RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT.equals((Object)report.getSourceType())) {
            cslReport.setSourceType(RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT);
        } else {
            cslReport.setSourceType(RptSrcTypeEnum.DYNAMICNORMALREPORT);
        }
        cslReport.setCurrency(report.getCurrency());
        cslReport.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        cslReport.setZipData(report.getZipData());
        RptSheetParamCollection srcCol = (RptSheetParamCollection)((Object)report.getSheetParam().clone());
        HashSet<String> toBeModifySet = new HashSet<String>();
        RptSheetParamInfo paramInfo = null;
        int n = srcCol.size();
        for (i = 0; i < n; ++i) {
            paramInfo = srcCol.get(i);
            if (isUpdate) {
                toBeModifySet.add(paramInfo.getId().toString());
            }
            paramInfo.setRelaType(ReportTypeEnum.REPORT);
            paramInfo.setStatus(1);
            paramInfo.setId(null);
            paramInfo.setReport((VirtualSheetParamInfo)cslReport);
            if (paramInfo.getPostils() == null || paramInfo.getPostils().size() <= 0) continue;
            int j = paramInfo.getPostils().size();
            for (int m = 0; m < j; ++m) {
                PostilInfo pi = paramInfo.getPostils().get(m);
                pi.setId(null);
                pi.getSheet().setId(null);
            }
        }
        cslReport.getSheetParam().addCollection(srcCol);
        if (report.getPostils() != null && report.getPostils().size() > 0) {
            for (i = report.getPostils().size() - 1; i >= 0; --i) {
                PostilInfo pi = report.getPostils().get(i);
                pi.setId(null);
                pi.setReport((ReportBaseInfo)cslReport);
                if (pi.getPostilType().equals((Object)PostilTypeEnum.REPORT)) continue;
                report.getPostils().removeObject(i);
            }
            cslReport.getPostils().addCollection(report.getPostils());
        }
        cslReport.setName(report.getName());
        cslReport.setNumber(report.getNumber());
        cslReport.setDescription(report.getDescription());
        cslReport.setCreator(report.getCreator());
        cslReport.setCreateTime(report.getCreateTime());
        cslReport.setLastUpdateUser(report.getLastUpdateUser());
        cslReport.setLastUpdateTime(report.getLastUpdateTime());
        cslReport.setAuditTime(report.getAuditTime());
        IReport ir = ReportFactory.getLocalInstance(ctx);
        ReportCollection rc = ir.getReportCollection("select cu where id = '" + report.getId().toString() + "'");
        if (rc.size() == 1) {
            cslReport.setCU(rc.get(0).getCU());
        }
        return cslReport;
    }
}

