/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.IRptTypeRela;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.ReportTypeInfo;
import com.kingdee.eas.fi.rpt.RptTypeRelaFactory;
import com.kingdee.eas.fi.rpt.RptTypeStdFactory;
import com.kingdee.eas.fi.rpt.app.AbstractReportTypeControllerBean;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReportTypeControllerBean
extends AbstractReportTypeControllerBean {
    private static final Logger log = Logger.getLogger((String)ReportTypeControllerBean.class.getName());

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ReportTypeInfo reportTypeInfo = (ReportTypeInfo)model;
        this.checkNameDup(ctx, (DataBaseInfo)reportTypeInfo);
        this._checkNumberDup(ctx, (IObjectValue)reportTypeInfo);
        this._checkTypeAndStdInSameCom(ctx, model);
        return super._addnew(ctx, (IObjectValue)reportTypeInfo);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK reportTypeInfoPK = pk;
        ReportTypeInfo reportTypeInfo = (ReportTypeInfo)model;
        this._checkNameDup(ctx, (IObjectValue)reportTypeInfo);
        this._checkNumberDup(ctx, (IObjectValue)reportTypeInfo);
        this._checkTypeAndStdInSameCom(ctx, model);
        super._update(ctx, reportTypeInfoPK, (IObjectValue)reportTypeInfo);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean isExist;
        ReportTypeInfo reportTypeInfoThis = (ReportTypeInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)reportTypeInfoThis.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (reportTypeInfoThis.getRptTypeStd() != null && reportTypeInfoThis.getRptTypeStd().getStdType() != null) {
            FilterItemInfo filterItemTypeStd = new FilterItemInfo("rptTypeStd.stdType", (Object)new Integer(reportTypeInfoThis.getRptTypeStd().getStdType().getValue()), CompareType.EQUALS);
            filter.getFilterItems().add(filterItemTypeStd);
        }
        if (reportTypeInfoThis.getCompany() != null) {
            FilterItemInfo filterItemTypeComp = new FilterItemInfo("company", (Object)reportTypeInfoThis.getCompany().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItemTypeComp);
        }
        if (reportTypeInfoThis.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)reportTypeInfoThis.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (isExist = this.exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{reportTypeInfoThis.getNumber()});
        }
    }

    protected void checkLNForTree(Context ctx, TreeBaseInfo treeBaseInfo) throws BOSException, EASBizException, TreeBaseException {
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean isExist;
        ReportTypeInfo reportTypeInfoThis = (ReportTypeInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)reportTypeInfoThis.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (reportTypeInfoThis.getRptTypeStd() != null && reportTypeInfoThis.getRptTypeStd().getStdType() != null) {
            FilterItemInfo filterItemTypeStd = new FilterItemInfo("rptTypeStd.stdType", (Object)new Integer(reportTypeInfoThis.getRptTypeStd().getStdType().getValue()), CompareType.EQUALS);
            filter.getFilterItems().add(filterItemTypeStd);
        }
        if (reportTypeInfoThis.getCompany() != null) {
            FilterItemInfo filterItemTypeComp = new FilterItemInfo("company", (Object)reportTypeInfoThis.getCompany().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItemTypeComp);
        }
        if (reportTypeInfoThis.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)reportTypeInfoThis.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (isExist = this.exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{reportTypeInfoThis.getName()});
        }
    }

    protected void _checkTypeAndStdInSameCom(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ReportTypeEnum rptType = this.getStdType(ctx, pk);
        try {
            String _sql = "select count(fid) idcount from t_rpt_reporttype where ftypestandid =(select fid from t_rpt_rpttypestd where fisused=1 and fid=(select ftypestandid from t_rpt_reporttype where fid=?))";
            IRowSet idRowSet = DbUtil.executeQuery((Context)ctx, (String)_sql, (Object[])new Object[]{pk.toString()});
            if (idRowSet.next() && idRowSet.getInt("idcount") == 1) {
                throw new ReportException(ReportException.DISABLERPTTYPE, new Object[]{""});
            }
        }
        catch (SQLException e) {
            log.debug((Object)e.getMessage());
        }
        IRptTypeRela rptTypeRela = RptTypeRelaFactory.getLocalInstance(ctx);
        rptTypeRela.deleteForReportTypeId(pk);
        super._delete(ctx, pk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReportTypeEnum getStdType(Context ctx, IObjectPK pk) throws BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("rptTypeStd.stdType");
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            ReportTypeEnum reportTypeEnum = ((ReportTypeInfo)this.getDAO(ctx, cn).getValue(pk, selector)).getRptTypeStd().getStdType();
            return reportTypeEnum;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    @Override
    protected IRowSet _getReportTypeforStd(Context ctx, IObjectPK stdPK) throws BOSException, EASBizException {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.fi.rpt.app", "RptTypeQuery");
        IQueryExecutor queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("rptTypeStd.id", (Object)stdPK.toString()));
        view.setFilter(filterInfo);
        SorterItemCollection typesortic = view.getSorter();
        typesortic.add(new SorterItemInfo("level"));
        typesortic.add(new SorterItemInfo("number"));
        queryExecutor.setObjectView(view);
        queryExecutor.option().isAutoTranslateEnum = true;
        return queryExecutor.executeQuery();
    }

    @Override
    protected IRowSet _getReportType(Context ctx, IObjectPK reportTypePK) throws BOSException, EASBizException {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.fi.rpt.app", "RptTypeQuery");
        IQueryExecutor queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)reportTypePK.toString()));
        view.setFilter(filterInfo);
        SorterItemCollection typesortic = view.getSorter();
        typesortic.add(new SorterItemInfo("level"));
        typesortic.add(new SorterItemInfo("number"));
        queryExecutor.setObjectView(view);
        queryExecutor.option().isAutoTranslateEnum = true;
        return queryExecutor.executeQuery();
    }

    @Override
    protected Map _getTypeAndStandard(Context ctx, Map params) throws BOSException, EASBizException {
        String currCompanyID = (String)params.get("currCompanyID");
        ReportTypeEnum reportType = (ReportTypeEnum)((Object)params.get("ReportTypeEnum"));
        HashMap<String, AbstractObjectCollection> result = new HashMap<String, AbstractObjectCollection>(2);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("rptTypeStd.id"));
        sic.add(new SelectorItemInfo("rptTypeStd.stdType"));
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("rptTypeStd.stdType", (Object)new Integer(reportType.getValue()));
        FilterItemInfo filterItem2 = new FilterItemInfo("company", (Object)currCompanyID);
        filter.getFilterItems().add(filterItem);
        filter.getFilterItems().add(filterItem2);
        view.setFilter(filter);
        SorterItemCollection sortic = view.getSorter();
        sortic.add(new SorterItemInfo("level"));
        sortic.add(new SorterItemInfo("number"));
        result.put("ReportTypeCollection", this.getReportTypeCollection(ctx, view));
        EntityViewInfo viewTypeStd = new EntityViewInfo();
        SelectorItemCollection sicTypeStd = viewTypeStd.getSelector();
        sicTypeStd.add(new SelectorItemInfo("id"));
        sicTypeStd.add(new SelectorItemInfo("name"));
        sicTypeStd.add(new SelectorItemInfo("seq"));
        FilterInfo filterTypeStd = new FilterInfo();
        FilterItemInfo filterItemTypeStd1 = new FilterItemInfo("isUsed", (Object)new Integer(1));
        FilterItemInfo filterItemTypeStd2 = new FilterItemInfo("stdType", (Object)new Integer(reportType.getValue()));
        FilterItemInfo filterItemTypeStd3 = new FilterItemInfo("company", (Object)currCompanyID);
        filterTypeStd.getFilterItems().add(filterItemTypeStd1);
        filterTypeStd.getFilterItems().add(filterItemTypeStd2);
        filterTypeStd.getFilterItems().add(filterItemTypeStd3);
        viewTypeStd.setFilter(filterTypeStd);
        SorterItemCollection sorticTypeStd = viewTypeStd.getSorter();
        sorticTypeStd.add(new SorterItemInfo("seq"));
        result.put("RptTypeStdCollection", RptTypeStdFactory.getLocalInstance(ctx).getRptTypeStdCollection(viewTypeStd));
        return result;
    }
}

