/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.sql.DbType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCommonFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.EASAppException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.dao.ReferenceDAO;
import com.kingdee.eas.cp.ba.IRptReportSubscibe;
import com.kingdee.eas.cp.ba.RptReportSubscibeCollection;
import com.kingdee.eas.cp.ba.RptReportSubscibeFactory;
import com.kingdee.eas.cp.ba.RptReportSubscibeInfo;
import com.kingdee.eas.cp.ba.RptSubscibeReceiverCollection;
import com.kingdee.eas.cp.ba.RptSubscibeReceiverInfo;
import com.kingdee.eas.fi.gr.cslrpt.AutoItemException;
import com.kingdee.eas.fi.gr.cslrpt.CSLK3TemplateFactory;
import com.kingdee.eas.fi.gr.cslrpt.CSLK3TemplateInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslReportRelaFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportRelaInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataRepairUtil;
import com.kingdee.eas.fi.gr.cslrpt.DiffTableSumRelaFactory;
import com.kingdee.eas.fi.gr.cslrpt.DiffTableSumRelaInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICSLK3Template;
import com.kingdee.eas.fi.gr.cslrpt.ICslReportRela;
import com.kingdee.eas.fi.gr.cslrpt.IDiffTableSumRela;
import com.kingdee.eas.fi.gr.cslrpt.ITempletDispense;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseCollection;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseFactory;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseInfo;
import com.kingdee.eas.fi.gr.cslrpt.TempletItemListFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.ExtractFormulaScheme;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.util.TimeLog;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveSchmTempEntryFactory;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveSchmTempEntryInfo;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluCollection;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluDispenseFactory;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluFactory;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluInfo;
import com.kingdee.eas.fi.newrpt.util.TemplateDispenseNewUtil;
import com.kingdee.eas.fi.rpt.AccountORMFactory;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.IIndexItem;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.IndexItemCollection;
import com.kingdee.eas.fi.rpt.IndexItemFactory;
import com.kingdee.eas.fi.rpt.PublicTemplateException;
import com.kingdee.eas.fi.rpt.PublishedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.RptAndTempException;
import com.kingdee.eas.fi.rpt.RptIndexFacadeFactory;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSumTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.RptTypeStdCollection;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.TemplateReportSavePointCollection;
import com.kingdee.eas.fi.rpt.TemplateReportSavePointFactory;
import com.kingdee.eas.fi.rpt.TemplateReportSavePointInfo;
import com.kingdee.eas.fi.rpt.TemplateSourceEnum;
import com.kingdee.eas.fi.rpt.VersionStatusEnum;
import com.kingdee.eas.fi.rpt.app.AbstractTemplateControllerBean;
import com.kingdee.eas.fi.rpt.app.ConditionWrappedInfo;
import com.kingdee.eas.fi.rpt.app.TemplateItemListSeparateHelper;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.RptUtilForServer;
import com.kingdee.eas.fi.rpt.util.TemplateVersionComparator;
import com.kingdee.eas.fi.rpt.util.TemplateVersionMgr;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.BizReference;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class TemplateControllerBean
extends AbstractTemplateControllerBean {
    private static Logger logger = Logger.getLogger(TemplateControllerBean.class);
    protected final String REPORT_FIELDINFO_TREENUMBER = "FTreeNumber";
    protected final String REPORT_FIELDINFO_TREENAME = "FTreeName";
    protected final String REPORT_FIELDINFO_UNITNUMBER = "FUnitNumber";
    protected final String REPORT_FIELDINFO_UNITNAME = "FUnitName";
    protected final String REPORT_FIELDINFO_SOURCETEMPNUMBER = "FSourceTmpNumber";
    protected final String REPORT_FIELDINFO_SOURCETEMPNAME = "FSourceTmpName";
    protected final String REPORT_FIELDINFO_TARGETTEMPNUMBER = "FTargetTmpNumber";
    protected final String REPORT_FIELDINFO_TARGETTEMPNAME = "FTargetTmpName";
    protected final String REPORT_FIELDINFO_ITEMFORMULA = "FItemFormula";
    protected final String REPORT_FIELDINFO_TEMPLATETYPE = "FTemplateType";
    protected final String REPORT_FIELDINFO_PERIODTYPE = "FPeriodType";
    protected final String REPORT_FIELDINFO_TARGETSHEETNAME = "FTrgtSheetName";
    protected final String REPORT_FIELDINFO_TARGETCELLNAME = "FTrgtCellName";

    @Override
    protected String _getLogInfo(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        TemplateInfo info = this.getTemplateInfo(ctx, pk);
        return info.getLogInfo();
    }

    protected void _checkUnaudit(Context ctx, IObjectPK pk, UserInfo auditor) throws BOSException, EASBizException {
        TemplateInfo info = this.getTemplateInfo(ctx, pk);
        if (info.getAuditor() != null && !auditor.getId().toString().equals(info.getAuditor().getId().toString()) && CslRptUtil.canUnAuditCheck((Context)ctx)) {
            throw new RptAndTempException(RptAndTempException.UNADITE_SAMECREATOR);
        }
    }

    @Override
    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        TemplateInfo templateInfo = (TemplateInfo)model;
        TemplateReportSavePointCollection c = templateInfo.getReportSavePoint();
        templateInfo.setReportSavePoint(new TemplateReportSavePointCollection());
        ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
        RptTmpTypeEnum rptTmpType = templateInfo.getTemplateType();
        if (!TemplateVersionMgr.isGroupTemplate(templateInfo) || RptTmpTypeEnum.COMMONPUBLICTEMPLATE.equals((Object)rptTmpType)) {
            this.addForRpt(ctx, (IObjectValue)templateInfo);
            String companyId = templateInfo.getCompany().getId().toString();
            if (this.getCodingRuleCtrl(ctx).isExist((IObjectValue)templateInfo, companyId)) {
                if (StringUtils.isEmpty((String)templateInfo.getNumber())) {
                    templateInfo.setNumber(this.getCodingRuleCtrl(ctx).getNumber((IObjectValue)templateInfo, companyId));
                }
            } else {
                CompanyOrgUnitInfo rootOrg = OrgUnitCommonFactory.getLocalInstance((Context)ctx).getRootCompany();
                if (rootOrg != null) {
                    companyId = rootOrg.getId().toString();
                    if (this.getCodingRuleCtrl(ctx).isExist((IObjectValue)templateInfo, companyId) && StringUtils.isEmpty((String)templateInfo.getNumber())) {
                        templateInfo.setNumber(this.getCodingRuleCtrl(ctx).getNumber((IObjectValue)templateInfo, companyId));
                    }
                }
            }
        } else if (rptTmpType.equals((Object)RptTmpTypeEnum.GROUPCOMMREPORT) || rptTmpType.equals((Object)RptTmpTypeEnum.DYNAMICNORMALREPORT)) {
            this.addForCslComm(ctx, model);
        } else {
            this.addForCsl(ctx, model);
        }
        boolean isChangingByCompany = false;
        int subCompanyLevel = 0;
        RptTmpTypeEnum tmpType = templateInfo.getTemplateType();
        if ((RptTmpTypeEnum.GROUPCOMMREPORT.equals((Object)tmpType) || RptTmpTypeEnum.DYNAMICNORMALREPORT.equals((Object)tmpType)) && templateInfo.getGroupTemplate() != null) {
            if (RptTmpTypeEnum.DYNAMICNORMALREPORT.equals((Object)tmpType)) {
                templateInfo.setTemplateType(RptTmpTypeEnum.RPTDYNAMICREPORT);
            } else if (RptTmpTypeEnum.MULTIDYNAMICCSLREPORT.equals((Object)tmpType)) {
                templateInfo.setTemplateType(RptTmpTypeEnum.MULTIRPTDYNAMICREPORT);
            } else {
                templateInfo.setTemplateType(RptTmpTypeEnum.GROUPREPORT);
            }
            isChangingByCompany = true;
            subCompanyLevel = 1;
        } else if (RptTmpTypeEnum.COMMONPUBLICTEMPLATE.equals((Object)rptTmpType) && (subCompanyLevel = this.getPublicTemplateChangeCompanyLevel(ctx, templateInfo)) > 0) {
            isChangingByCompany = true;
        }
        TemplateVersionMgr manager = new TemplateVersionMgr(templateInfo, isChangingByCompany, subCompanyLevel);
        templateInfo.setVersionNumber(manager.getVersion());
        templateInfo.getGroupTemplate();
        if (templateInfo.getGroup() == null) {
            templateInfo.setGroup(Uuid.create().toString());
        }
        this.checkVersionExists(ctx, templateInfo);
        this.checktempCodeDump(ctx, templateInfo);
        this.checkTemplateData(ctx, templateInfo);
        super._addnew(ctx, pk, model);
        templateInfo.setId(BOSUuid.read((String)pk.toString()));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("template.id", (Object)templateInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)templateInfo.getCompany().getId().toString()));
        TemplateReportSavePointFactory.getLocalInstance(ctx).delete(filter);
        if (c != null && c.size() > 0) {
            for (int i = 0; i < c.size(); ++i) {
                TemplateReportSavePointInfo info = c.get(i);
                if (info == null || info.getCompany() == null || info.getCompany().getId() == null || !info.getCompany().getId().equals((Object)templateInfo.getCompany().getId().toString())) continue;
                info.setId(null);
                info.setTemplate(templateInfo);
                TemplateReportSavePointFactory.getLocalInstance(ctx).addnew(info);
            }
        }
    }

    public void checktempCodeDump(Context ctx, TemplateInfo templateInfo) throws BOSException, EASBizException {
        boolean isExist;
        FilterItemInfo filterItem5;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("orgType"));
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)templateInfo.getNumber());
        FilterItemInfo filterItem3 = new FilterItemInfo("templateType", (Object)new Integer(templateInfo.getTemplateType().getValue()));
        if (templateInfo.getGroup() != null) {
            filterItem5 = new FilterItemInfo("group", (Object)templateInfo.getGroup(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem5);
        }
        if (templateInfo.getId() != null) {
            filterItem5 = new FilterItemInfo("id", (Object)templateInfo.getId().toString(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem5);
        }
        if (RptTmpTypeEnum.COMMONPUBLICTEMPLATE.equals((Object)templateInfo.getTemplateType())) {
            Set companyIDS = this.getSuperCompanyIDs(ctx);
            companyIDS.add(templateInfo.getCompany().getId().toString());
            FilterItemInfo filterItem52 = new FilterItemInfo("company.id", (Object)companyIDS, CompareType.INCLUDE);
            filter.getFilterItems().add(filterItem52);
        }
        filter.getFilterItems().add(filterItem);
        if (!TemplateVersionMgr.isGroupTemplate(templateInfo)) {
            FilterItemInfo filterItem2 = new FilterItemInfo("company", (Object)templateInfo.getCompany().getId().toString());
            filter.getFilterItems().add(filterItem2);
        }
        filter.getFilterItems().add(filterItem3);
        filter.getFilterItems().add(new FilterItemInfo("isK3Tpl", (Object)templateInfo.isIsK3Tpl()));
        view.setFilter(filter);
        TemplateCollection col = this.getTemplateCollection(ctx, view);
        boolean bl = isExist = col.size() > 0;
        if (isExist && RptTmpTypeEnum.COMMONPUBLICTEMPLATE.equals((Object)templateInfo.getTemplateType())) {
            throw new RptAndTempException(RptAndTempException.PUBLIC_DUP);
        }
        if (isExist) {
            throw new RptAndTempException(RptAndTempException.TEMPLATE_DUP, new Object[]{col.get(0).getOrgType().getAlias()});
        }
    }

    private void checkVersionExists(Context ctx, TemplateInfo templateInfo) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)templateInfo.getCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("versionNumber", (Object)templateInfo.getVersionNumber()));
        filter.getFilterItems().add(new FilterItemInfo("group", (Object)templateInfo.getGroup()));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)templateInfo.getPeriodType()));
        if (this.exists(ctx, filter)) {
            throw new RptAndTempException(RptAndTempException.TEMPLATE_HAS_NEW_VERSION);
        }
    }

    private void checkTemplateData(Context ctx, TemplateInfo templateInfo) throws BOSException, RptAndTempException {
        FullOrgUnitInfo company = templateInfo.getCompany();
        if (company == null) {
            throw new RptAndTempException(RptAndTempException.COMPANY_IS_NULL);
        }
        String name = templateInfo.getName();
        if (name != null && name.length() > 80) {
            templateInfo.setName(name.substring(0, 80));
        }
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (!model.containsKey("isK3Tpl")) {
            model.put("isK3Tpl", (Object)false);
        }
        TemplateInfo templateInfo = (TemplateInfo)model;
        TemplateReportSavePointCollection c = templateInfo.getReportSavePoint();
        templateInfo.setReportSavePoint(new TemplateReportSavePointCollection());
        RptTmpTypeEnum rptTmpType = templateInfo.getTemplateType();
        if (!TemplateVersionMgr.isGroupTemplate(templateInfo) || RptTmpTypeEnum.COMMONPUBLICTEMPLATE.equals((Object)rptTmpType)) {
            BOSUuid id;
            this.addForRpt(ctx, (IObjectValue)templateInfo);
            String companyId = RptNewUIUtil.getDelegateCompanyNoOrgType((Context)ctx, (OrgUnitInfo)templateInfo.getCompany()).getId().toString();
            if (this.getCodingRuleCtrl(ctx).isExist((IObjectValue)templateInfo, companyId)) {
                if (StringUtils.isEmpty((String)templateInfo.getNumber())) {
                    String number = this.getCodingRuleCtrl(ctx).getNumber((IObjectValue)templateInfo, companyId);
                    if (number.startsWith("Auto-Standard")) {
                        throw new RptAndTempException(RptAndTempException.CANNOTADD_STANDTEMP);
                    }
                    id = templateInfo.getId();
                    templateInfo.remove("Id");
                    templateInfo.setNumber(number);
                    templateInfo.setId(id);
                }
            } else {
                CompanyOrgUnitInfo rootOrg = OrgUnitCommonFactory.getLocalInstance((Context)ctx).getRootCompany();
                if (rootOrg != null) {
                    companyId = rootOrg.getId().toString();
                    if (this.getCodingRuleCtrl(ctx).isExist((IObjectValue)templateInfo, companyId) && StringUtils.isEmpty((String)templateInfo.getNumber())) {
                        id = templateInfo.getId();
                        templateInfo.remove("Id");
                        templateInfo.setNumber(this.getCodingRuleCtrl(ctx).getNumber((IObjectValue)templateInfo, companyId));
                        templateInfo.setId(id);
                    }
                }
            }
        } else if (!templateInfo.isChangeByTemplate()) {
            if (rptTmpType.equals((Object)RptTmpTypeEnum.GROUPCOMMREPORT) || rptTmpType.equals((Object)RptTmpTypeEnum.DYNAMICNORMALREPORT)) {
                this.addForCslComm(ctx, model);
            } else if (rptTmpType.equals((Object)RptTmpTypeEnum.INVESTELIMMANUSCRIPT)) {
                this.addForInvestElimMnsTmpl(ctx, model);
            } else {
                this.addForCsl(ctx, model);
            }
        }
        boolean isChangingByCompany = false;
        int subCompanyLevel = 0;
        if ((RptTmpTypeEnum.GROUPCOMMREPORT.equals((Object)rptTmpType) || RptTmpTypeEnum.DYNAMICNORMALREPORT.equals((Object)rptTmpType) || RptTmpTypeEnum.MULTIDYNAMICCSLREPORT.equals((Object)templateInfo.getTemplateType())) && templateInfo.getGroupTemplate() != null || templateInfo.isChangeByTemplate()) {
            if (RptTmpTypeEnum.DYNAMICNORMALREPORT.equals((Object)templateInfo.getTemplateType())) {
                templateInfo.setTemplateType(RptTmpTypeEnum.RPTDYNAMICREPORT);
            } else if (RptTmpTypeEnum.MULTIDYNAMICCSLREPORT.equals((Object)templateInfo.getTemplateType())) {
                templateInfo.setTemplateType(RptTmpTypeEnum.MULTIRPTDYNAMICREPORT);
            } else {
                templateInfo.setTemplateType(RptTmpTypeEnum.GROUPREPORT);
            }
            isChangingByCompany = true;
            subCompanyLevel = 1;
        } else if (RptTmpTypeEnum.COMMONPUBLICTEMPLATE.equals((Object)rptTmpType) && (subCompanyLevel = this.getPublicTemplateChangeCompanyLevel(ctx, templateInfo)) > 0) {
            isChangingByCompany = true;
        }
        TemplateVersionMgr manager = new TemplateVersionMgr(templateInfo, isChangingByCompany, subCompanyLevel);
        templateInfo.setVersionNumber(manager.getVersion());
        if (templateInfo.getGroup() == null) {
            templateInfo.setGroup(Uuid.create().toString());
        }
        this.checkVersionExists(ctx, templateInfo);
        if (!templateInfo.isIsK3Tpl()) {
            this.checktempCodeDump(ctx, templateInfo);
        }
        this.checkTemplateData(ctx, templateInfo);
        IObjectPK pk = super._addnew(ctx, model);
        templateInfo.setId(BOSUuid.read((String)pk.toString()));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("template.id", (Object)templateInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)templateInfo.getCompany().getId().toString()));
        TemplateReportSavePointFactory.getLocalInstance(ctx).delete(filter);
        if (c != null && c.size() > 0) {
            for (int i = 0; i < c.size(); ++i) {
                TemplateReportSavePointInfo info = c.get(i);
                if (info == null || info.getCompany() == null || info.getCompany().getId() == null || !info.getCompany().getId().equals((Object)templateInfo.getCompany().getId().toString())) continue;
                info.setId(null);
                info.setTemplate(templateInfo);
                TemplateReportSavePointFactory.getLocalInstance(ctx).addnew(info);
            }
        }
        return pk;
    }

    @Override
    protected boolean _isAudited(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("auditedStatus"));
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("id", (Object)pk.toString());
        FilterItemInfo filterItem1 = new FilterItemInfo("auditedStatus", (Object)new Integer(2));
        filter.getFilterItems().add(filterItem);
        filter.getFilterItems().add(filterItem1);
        boolean isExist = this.exists(ctx, filter);
        return isExist;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        TemplateInfo templateInfo = (TemplateInfo)model;
        if (Boolean.TRUE.equals(model.get("update_direct"))) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("templateType"));
            sic.add(new SelectorItemInfo("group"));
            TemplateInfo oldVO = this.getTemplateInfo(ctx, pk, sic);
            if (!oldVO.getTemplateType().equals((Object)templateInfo.getTemplateType())) {
                this.checktempCodeDump(ctx, templateInfo);
            }
            String sql = "update T_RPT_Template set FTemplateType = ? , FIsAllowSubCompanyModify = ?  ,FGroupCompanyID = ? where FID = ? ";
            int allow = templateInfo.isIsAllowSubCompanyModify() ? 1 : 0;
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(templateInfo.getTemplateType().getValue()), new Integer(allow), templateInfo.getGroupCompany().getId().toString(), pk.toString()});
            if (!oldVO.getTemplateType().equals((Object)templateInfo.getTemplateType()) && RptTmpTypeEnum.COMMONPUBLICTEMPLATE.equals((Object)oldVO.getTemplateType()) && RptTmpTypeEnum.COMMONREPORT.equals((Object)templateInfo.getTemplateType())) {
                this.sealPublicTemplates(ctx, oldVO, oldVO);
            }
            return;
        }
        TemplateReportSavePointCollection c = templateInfo.getReportSavePoint();
        templateInfo.setReportSavePoint(new TemplateReportSavePointCollection());
        this.allowUpdate(ctx, pk, templateInfo);
        ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
        RptTmpTypeEnum rptTmpType = templateInfo.getTemplateType();
        if (TemplateVersionMgr.isGroupTemplate(templateInfo) && !RptTmpTypeEnum.COMMONPUBLICTEMPLATE.equals((Object)rptTmpType) && !rptTmpType.equals((Object)RptTmpTypeEnum.GROUPCOMMREPORT) && !rptTmpType.equals((Object)RptTmpTypeEnum.DYNAMICNORMALREPORT)) {
            if (rptTmpType.equals((Object)RptTmpTypeEnum.INVESTELIMMANUSCRIPT)) {
                this.updateForInvestElimMnsTmpl(ctx, pk, model);
            } else {
                this.updateForCsl(ctx, model, pk);
            }
        }
        this.checktempCodeDump(ctx, templateInfo);
        this.checkTemplateData(ctx, templateInfo);
        super._update(ctx, pk, (IObjectValue)templateInfo);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("template.id", (Object)templateInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)templateInfo.getCompany().getId().toString()));
        TemplateReportSavePointFactory.getLocalInstance(ctx).delete(filter);
        if (c != null && c.size() > 0) {
            for (int i = 0; i < c.size(); ++i) {
                TemplateReportSavePointInfo info = c.get(i);
                if (info == null || info.getCompany() == null || info.getCompany().getId() == null || !info.getCompany().getId().toString().equals(templateInfo.getCompany().getId().toString())) continue;
                info.setId(null);
                info.setTemplate(templateInfo);
                TemplateReportSavePointFactory.getLocalInstance(ctx).addnew(info);
            }
        }
        ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
        if (templateInfo.containsKey("isAlterProperties")) {
            this.updatePropertiesLog(ctx, templateInfo);
        } else {
            this.updateDataLog(ctx, templateInfo);
        }
    }

    private boolean allowUpdate(Context ctx, IObjectPK pk, TemplateInfo model) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("auditedStatus"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        TemplateInfo objectBaseInfo = this.getTemplateInfo(ctx, pk, sic);
        if (objectBaseInfo == null) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"TemplateRemovedCannotUpdate", (Locale)ctx.getLocale())});
        }
        return true;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        boolean isAudite = this._isAudited(ctx, pk);
        TemplateInfo info = this.getTemplate(ctx, pk);
        RptTmpTypeEnum rptTmpType = info.getTemplateType();
        if (rptTmpType == null) {
            return;
        }
        ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
        if (TemplateVersionMgr.isGroupTemplate(info) && !RptTmpTypeEnum.COMMONPUBLICTEMPLATE.equals((Object)rptTmpType)) {
            if (rptTmpType.equals((Object)RptTmpTypeEnum.GROUPCOMMREPORT) || rptTmpType.equals((Object)RptTmpTypeEnum.DYNAMICNORMALREPORT)) {
                this.deleteForCslComm(ctx, pk);
            } else if (rptTmpType.equals((Object)RptTmpTypeEnum.INVESTELIMMANUSCRIPT)) {
                this.deleteForInvestElimMnsTmpl(ctx, pk);
            } else {
                this.deleteForCsl(ctx, pk);
            }
        }
        this.deleteCslCheck(ctx, pk);
        this.deleteCommCheck(ctx, pk);
        if (isAudite) {
            throw new RptAndTempException(RptAndTempException.CANNTDEL_AUDITED);
        }
        TemplateInfo templateInfo = this.getTemplateInfo(ctx, pk);
        this.delIndexItems(ctx, pk);
        this.delK3Template(ctx, pk);
        String number = templateInfo.getNumber();
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from t_rpt_template where fgroup in (");
        sql.append(" select fgroup from t_rpt_template where fnumber = ?");
        sql.append(")");
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{number});
        if (set.size() == 1) {
            sql = new StringBuffer();
            sql.append("delete from T_CSL_FormulaDispense where FTemplateNumber = ?");
            sql.append(" and FTemplateType = ?");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{number, new Integer(templateInfo.getTemplateType().getValue())});
        }
        TempletItemListFactory.getLocalInstance((Context)ctx).clearItemList(pk.toString());
        this.delAttach(ctx, pk);
        this.delTemplateAttach(ctx, pk);
        this.delSceneRecord(ctx, pk, rptTmpType);
        super._delete(ctx, pk);
        if (this.getCodingRuleCtrl(ctx).isExist((IObjectValue)templateInfo, templateInfo.getCompany().getId().toString())) {
            this.getCodingRuleCtrl(ctx).recycleNumber((IObjectValue)templateInfo, templateInfo.getCompany().getId().toString(), templateInfo.getNumber());
        } else {
            CompanyOrgUnitInfo rootOrg = OrgUnitCommonFactory.getLocalInstance((Context)ctx).getRootCompany();
            if (rootOrg != null && this.getCodingRuleCtrl(ctx).isExist((IObjectValue)templateInfo, rootOrg.getId().toString())) {
                this.getCodingRuleCtrl(ctx).recycleNumber((IObjectValue)templateInfo, rootOrg.getId().toString(), templateInfo.getNumber());
            }
        }
        TemplateInfo easForK3Info = this.getEasTplForK3(ctx, pk.toString(), null);
        if (easForK3Info == null) {
            return;
        }
        this.delete(ctx, (IObjectPK)new ObjectUuidPK(easForK3Info.getId()));
    }

    private void delSceneRecord(Context ctx, IObjectPK pk, RptTmpTypeEnum rptTmpType) throws BOSException {
        if (!rptTmpType.equals((Object)RptTmpTypeEnum.INVESTELIMMANUSCRIPT)) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("Delete From T_CSL_SceneRecord Where FTemplateId = ?");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{pk.toString()});
    }

    private void delK3Template(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CSLK3TemplateFactory.getLocalInstance((Context)ctx).delete(" where sourceTemplate.id = '" + pk.toString() + "'");
    }

    private void delIndexItems(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        IIndexItem iIndexItem = IndexItemFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("templateId", (Object)pk.toString()));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        IndexItemCollection indexitems = iIndexItem.getIndexItemCollection(view);
        int size = indexitems.size();
        for (int i = 0; i < size; ++i) {
            iIndexItem.delete((IObjectPK)new ObjectUuidPK(indexitems.get(i).getId()));
        }
    }

    protected ICodingRuleManager getCodingRuleCtrl(Context ctx) throws BOSException {
        return CodingRuleManagerFactory.getLocalInstance((Context)ctx);
    }

    private void delTempAttach(Context ctx, IObjectPK pk) throws BOSException {
        StringBuffer _sql = new StringBuffer("delete from t_rpt_template ");
        _sql.append(" where fid in ");
        _sql.append(" (select fid from t_rpt_template where ");
        _sql.append(" fnumber = (select fnumber from  t_rpt_template where fid = ?))");
        _sql.append(" and fcompanyid = (select fcompanyid from  t_rpt_template where fid = ?)");
        _sql.append(" and FTemplateType = (select FTemplateType from  t_rpt_template where fid = ?)");
        _sql.append(" and fid != ?");
        Object[] params = new Object[]{pk.toString(), pk.toString(), pk.toString(), pk.toString()};
        DbUtil.execute((Context)ctx, (String)_sql.toString(), (Object[])params);
    }

    private void deleteCommCheck(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("template.id", (Object)pk.toString());
        filter.getFilterItems().add(filterItem);
        IReport iReport = ReportFactory.getLocalInstance(ctx);
        boolean isExist = iReport.exists(filter);
        if (isExist) {
            throw new RptAndTempException(RptAndTempException.HASREPORTNODELETE);
        }
    }

    @Override
    protected HashMap _fetchInitData(Context ctx) throws BOSException {
        HashMap<String, CurrencyCollection> initHashMap = new HashMap<String, CurrencyCollection>();
        ICurrency initICurrcny = CurrencyFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        CurrencyCollection initCurrencyCollection = initICurrcny.getCurrencyCollection(view);
        initHashMap.put("0", initCurrencyCollection);
        return initHashMap;
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._unAudit(ctx, pk, null);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk, OrgUnitInfo selectOrg) throws BOSException, EASBizException {
        TemplateInfo info = this.getTemplate(ctx, pk);
        boolean isCompanyType = OrgType.Company.equals((Object)info.getOrgType());
        RptTmpTypeEnum rptTmpType = this.getTmpType(ctx, pk);
        if (isCompanyType) {
            if (!(rptTmpType.equals((Object)RptTmpTypeEnum.COMMONREPORT) || rptTmpType.equals((Object)RptTmpTypeEnum.GROUPREPORT) || rptTmpType.equals((Object)RptTmpTypeEnum.RPTDYNAMICREPORT) || rptTmpType.equals((Object)RptTmpTypeEnum.MULTIRPTDYNAMICREPORT) || rptTmpType.equals((Object)RptTmpTypeEnum.COMMONPUBLICTEMPLATE))) {
                if (rptTmpType.equals((Object)RptTmpTypeEnum.GROUPCOMMREPORT) || rptTmpType.equals((Object)RptTmpTypeEnum.DYNAMICNORMALREPORT) || rptTmpType.equals((Object)RptTmpTypeEnum.MULTIDYNAMICCSLREPORT)) {
                    ServiceStateManager.getInstance().enableNextCallServices();
                    this.unAuditForCslComm(ctx, pk);
                } else if (rptTmpType.equals((Object)RptTmpTypeEnum.INVESTELIMMANUSCRIPT)) {
                    ServiceStateManager.getInstance().enableNextCallServices();
                    this.unAuditForInvestElimMnsTmpl(ctx, pk);
                } else {
                    ServiceStateManager.getInstance().enableNextCallServices();
                    this.unAuditForCsl(ctx, pk);
                }
            }
        } else {
            ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
            if (rptTmpType.equals((Object)RptTmpTypeEnum.COMMONREPORT) || rptTmpType.equals((Object)RptTmpTypeEnum.GROUPREPORT) || rptTmpType.equals((Object)RptTmpTypeEnum.RPTDYNAMICREPORT) || rptTmpType.equals((Object)RptTmpTypeEnum.MULTIRPTDYNAMICREPORT) || rptTmpType.equals((Object)RptTmpTypeEnum.COMMONPUBLICTEMPLATE) || rptTmpType.equals((Object)RptTmpTypeEnum.GROUPCOMMREPORT) || rptTmpType.equals((Object)RptTmpTypeEnum.DYNAMICNORMALREPORT) || rptTmpType.equals((Object)RptTmpTypeEnum.MULTIDYNAMICCSLREPORT)) {
                ServiceStateManager.getInstance().enableNextCallServices();
                this.unAuditForCslComm(ctx, pk);
            } else if (rptTmpType.equals((Object)RptTmpTypeEnum.INVESTELIMMANUSCRIPT)) {
                ServiceStateManager.getInstance().enableNextCallServices();
                this.unAuditForInvestElimMnsTmpl(ctx, pk);
            } else {
                ServiceStateManager.getInstance().enableNextCallServices();
                this.unAuditForCsl(ctx, pk);
            }
        }
        if (!this.isCompanyLastestVersion(ctx, pk.toString(), false, false, info.getCompany().getId().toString(), info)) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"TemplateExistsNewVersion", (Locale)ctx.getLocale())});
        }
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        if (TemplateVersionMgr.isGroupTemplate(info)) {
            this._checkUnaudit(ctx, pk, userInfo);
        }
        if (RptTmpTypeEnum.COMMONPUBLICTEMPLATE.equals((Object)info.getTemplateType())) {
            String currentFiUnitId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
            if (selectOrg != null && selectOrg.getId() != null && !StringUtils.isEmpty((String)selectOrg.getId().toString())) {
                currentFiUnitId = selectOrg.getId().toString();
            }
            if (!info.getCompany().getId().toString().equals(currentFiUnitId)) {
                throw new PublicTemplateException(PublicTemplateException.NOT_ALLOWED_MODIFY);
            }
            List quotedList = this._checkPublicTemplateQuoted(ctx, pk.toString());
            if (quotedList != null && quotedList.size() > 0) {
                throw new PublicTemplateException(PublicTemplateException.TEMPLATE_QUOTED, new Exception(this.buildQuetedPublicTemplateMsg(info, quotedList, ctx)));
            }
        }
        StringBuffer _sql = new StringBuffer("update T_rpt_template set");
        _sql.append(" FAuditedStatus = ?");
        _sql.append(",FAuditorId = null");
        _sql.append(",FAuditedTime = null");
        _sql.append(",FVersionStatus = ?");
        _sql.append(" where fid = ?");
        Object[] params = new Object[3];
        params[0] = new Integer(1);
        String versionNumber = info.getVersionNumber();
        String lastVersion = versionNumber.substring(versionNumber.indexOf(".") + 1, versionNumber.length());
        boolean isCompany = lastVersion.indexOf(".") > 0 || Integer.parseInt(lastVersion) > 0;
        IObjectPK pkOld = this._getPreviousVersion(ctx, pk);
        params[1] = isCompany ? new Integer(0) : (pkOld == null ? new Integer(1) : new Integer(0));
        params[2] = pk.toString();
        DbUtil.execute((Context)ctx, (String)_sql.toString(), (Object[])params);
        ExtractFormulaScheme extrFormulaAction = new ExtractFormulaScheme(new DBHandler(ctx));
        if (pkOld == null) {
            FullOrgUnitInfo company = null;
            if (info.getGroupTemplate() != null) {
                company = info.getCompany();
            }
            extrFormulaAction.clearScheme(info, (OrgUnitInfo)company);
            TemplateInfo smallVersionTemplate = this.getSmallVersionTemplate(ctx, info);
            if (smallVersionTemplate != null) {
                extrFormulaAction.clearScheme(smallVersionTemplate, (OrgUnitInfo)smallVersionTemplate.getCompany());
            }
            return;
        }
        _sql = new StringBuffer();
        params = new Object[2];
        _sql.append(" UPDATE T_RPT_Template SET         \n");
        _sql.append("     FVersionStatus = ?            \n");
        params[0] = new Integer(1);
        _sql.append(" WHERE FID = ?                     \n");
        params[1] = pkOld.toString();
        DbUtil.execute((Context)ctx, (String)_sql.toString(), (Object[])params);
        this.updateGroupTemplateIdForGrade(ctx, pkOld.toString(), info);
        int version = Integer.parseInt(versionNumber.substring(0, versionNumber.indexOf(".")));
        if (version > 1 && !isCompany) {
            _sql = new StringBuffer();
            _sql.append("Update T_Rpt_Template set FVersionStatus = 0 ");
            _sql.append(" where FTemplateType in (2, 10, 12, 15, 16)");
            _sql.append(" and FAuditedStatus = 1");
            _sql.append(" and FGroup = ?");
            _sql.append(" and FVersionNumber like '").append(version - 1).append(".%'");
            DbUtil.execute((Context)ctx, (String)_sql.toString(), (Object[])new Object[]{info.getGroup()});
            _sql.setLength(0);
            _sql.append("Update T_Rpt_Template set FVersionStatus = 1 ");
            _sql.append(" where FTemplateType in (2, 10, 12, 15, 16)");
            _sql.append(" and FAuditedStatus = 2");
            _sql.append(" and FGroup = ?");
            _sql.append(" and FVersionNumber in (");
            _sql.append("select max(FVersionNumber) from T_Rpt_Template  ");
            _sql.append(" where FTemplateType in (2, 10, 12, 15, 16)");
            _sql.append(" and FAuditedStatus = 2");
            _sql.append(" and FGroup = ?");
            _sql.append(" and FVersionNumber like '").append(version - 1).append(".%'");
            _sql.append(" )");
            DbUtil.execute((Context)ctx, (String)_sql.toString(), (Object[])new Object[]{info.getGroup(), info.getGroup()});
        }
        if (pkOld != null) {
            TemplateInfo currValidTemplate = this.getTemplateInfo(ctx, pkOld);
            this.extrFormula(ctx, currValidTemplate);
        }
    }

    private void updateGroupTemplateIdForGrade(Context ctx, String oldId, TemplateInfo info) throws EASBizException, BOSException {
        String oldGroupTplId;
        String groupTplId;
        TemplateInfo oldTemplate;
        if (info.getTemplateSource().equals((Object)TemplateSourceEnum.GRADETEMPLATE) && (oldTemplate = this.getTemplate(ctx, (IObjectPK)new ObjectUuidPK(oldId))).getTemplateSource().equals((Object)TemplateSourceEnum.GRADETEMPLATE) && !(groupTplId = info.getGroupTemplate().getId().toString()).equals(oldGroupTplId = oldTemplate.getGroupTemplate().getId().toString())) {
            StringBuffer _sql = new StringBuffer();
            Object[] params = new Object[2];
            _sql.append(" UPDATE T_RPT_Template SET \n");
            _sql.append("     FGroupTemplateID = ? \n");
            params[0] = groupTplId;
            _sql.append(" WHERE FID = ? \n");
            params[1] = oldId.toString();
            DbUtil.execute((Context)ctx, (String)_sql.toString(), (Object[])params);
        }
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        TemplateInfo templateInfo = this.getTemplate(ctx, pk);
        boolean isCompanyType = OrgType.Company.equals((Object)templateInfo.getOrgType());
        RptTmpTypeEnum rptTmpType = this.getTmpType(ctx, pk);
        if (isCompanyType) {
            if (!(rptTmpType.equals((Object)RptTmpTypeEnum.COMMONREPORT) || rptTmpType.equals((Object)RptTmpTypeEnum.GROUPREPORT) || rptTmpType.equals((Object)RptTmpTypeEnum.RPTDYNAMICREPORT) || rptTmpType.equals((Object)RptTmpTypeEnum.MULTIRPTDYNAMICREPORT) || rptTmpType.equals((Object)RptTmpTypeEnum.COMMONPUBLICTEMPLATE))) {
                if (rptTmpType.equals((Object)RptTmpTypeEnum.GROUPCOMMREPORT) || rptTmpType.equals((Object)RptTmpTypeEnum.DYNAMICNORMALREPORT) || rptTmpType.equals((Object)RptTmpTypeEnum.MULTIDYNAMICCSLREPORT)) {
                    ServiceStateManager.getInstance().enableNextCallServices();
                    this.auditForCslComm(ctx, pk);
                } else if (rptTmpType.equals((Object)RptTmpTypeEnum.INVESTELIMMANUSCRIPT)) {
                    ServiceStateManager.getInstance().enableNextCallServices();
                    this.auditForInvestElimMnsTmpl(ctx, pk);
                } else {
                    ServiceStateManager.getInstance().enableNextCallServices();
                    this.auditForCsl(ctx, pk);
                }
            }
        } else {
            ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
            if (rptTmpType.equals((Object)RptTmpTypeEnum.COMMONREPORT) || rptTmpType.equals((Object)RptTmpTypeEnum.GROUPREPORT) || rptTmpType.equals((Object)RptTmpTypeEnum.RPTDYNAMICREPORT) || rptTmpType.equals((Object)RptTmpTypeEnum.MULTIRPTDYNAMICREPORT) || rptTmpType.equals((Object)RptTmpTypeEnum.COMMONPUBLICTEMPLATE) || rptTmpType.equals((Object)RptTmpTypeEnum.GROUPCOMMREPORT) || rptTmpType.equals((Object)RptTmpTypeEnum.DYNAMICNORMALREPORT) || rptTmpType.equals((Object)RptTmpTypeEnum.MULTIDYNAMICCSLREPORT)) {
                this.auditForCslComm(ctx, pk);
            } else if (rptTmpType.equals((Object)RptTmpTypeEnum.INVESTELIMMANUSCRIPT)) {
                ServiceStateManager.getInstance().enableNextCallServices();
                this.auditForInvestElimMnsTmpl(ctx, pk);
            } else {
                this.auditForCsl(ctx, pk);
            }
        }
        StringBuffer sql = null;
        ArrayList<Object> params = new ArrayList<Object>();
        sql = new StringBuffer();
        sql.append(" UPDATE T_RPT_Template      \n");
        sql.append(" SET FAuditedStatus = ?     \n");
        params.add(new Integer(2));
        sql.append(" ,FAuditorId = ?            \n");
        params.add(ctx.getCaller().toString());
        sql.append(" ,FAuditedTime = ?          \n");
        params.add(new Timestamp(new Date().getTime()));
        sql.append(" ,FVersionStatus = ?        \n");
        params.add(new Integer(1));
        sql.append(" WHERE FID = ?              \n");
        params.add(pk.toString());
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        TemplateInfo template = this.getTemplateInfo(ctx, pk);
        int templateSource = template.getTemplateSource().getValue();
        if (templateSource == 0 && TemplateVersionMgr.isNewGroupVersion(template.getVersionNumber()) || templateSource == 1 && TemplateVersionMgr.isNewGradeVersion(template.getVersionNumber())) {
            IObjectPK pkOld = this._getPreviousVersion(ctx, (IObjectPK)new ObjectUuidPK(template.getId()));
            if (pkOld == null) {
                this.extrFormula(ctx, template);
                return;
            }
            TemplateInfo preTemplate = this.getTemplateInfo(ctx, pkOld);
            if (preTemplate == null) {
                this.extrFormula(ctx, template);
                return;
            }
            sql = new StringBuffer();
            params.clear();
            sql.append(" UPDATE T_RPT_Template SET      \n");
            sql.append("     FVersionStatus = ?         \n");
            params.add(new Integer(2));
            sql.append(" WHERE FID = ?                  \n");
            params.add(preTemplate.getId().toString());
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
            String ret = null;
            if (RptTmpTypeEnum.CSLREPORT.equals((Object)template.getTemplateType()) || RptTmpTypeEnum.MANUSCRIPT.equals((Object)template.getTemplateType()) || RptTmpTypeEnum.SUMREPORT.equals((Object)template.getTemplateType()) || RptTmpTypeEnum.DYNAMICSUMREPORT.equals((Object)template.getTemplateType()) || RptTmpTypeEnum.MULTIDYNAMICSUMREPORT.equals((Object)template.getTemplateType()) || RptTmpTypeEnum.DIFFTABLE.equals((Object)template.getTemplateType()) || RptTmpTypeEnum.INVESTELIMMANUSCRIPT.equals((Object)template.getTemplateType()) || RptTmpTypeEnum.DYNAMICCSLREPORT.equals((Object)template.getTemplateType()) || RptTmpTypeEnum.MULTIDYNAMICCSLPORT.equals((Object)template.getTemplateType())) {
                DataRepairUtil.clearExcrescentTemplateDispenseRecord((Context)ctx, (String)preTemplate.getId().toString());
                ret = this.auditAutoDispense(ctx, template.getId().toString(), preTemplate.getId().toString(), false, null);
                if (!StringUtils.isEmpty((String)ret)) {
                    throw new EASBizException(new NumericExceptionSubItem("1", ret));
                }
            } else if (!RptTmpTypeEnum.COMMONPUBLICTEMPLATE.equals((Object)template.getTemplateType())) {
                int i;
                DataRepairUtil.clearExcrescentTemplateDispenseRecord((Context)ctx, (String)pkOld.toString());
                StringBuffer oql = new StringBuffer();
                oql.append(" select id,company, company.id,orgBound,orgBound.id,isAllowChgTemplet,isCoverTmpFormula,").append(" CU,CU.id,isCoverFormula,isAllwChgCheckSol,isCoverNoLockCell,orgBound.status ").append(" where dispenseSrcID = '").append(pkOld.toString()).append("'").append(" and orgBound.status = 1");
                TempletDispenseCollection dispenses = TempletDispenseFactory.getLocalInstance((Context)ctx).getTempletDispenseCollection(oql.toString());
                boolean hasSubVersion = false;
                boolean isAutoUpdate = template.isIsAutoUpdate();
                TempletDispenseInfo dispenseInfo = null;
                HashMap collectInfos = new HashMap();
                TimeLog timeLog = new TimeLog();
                TempletDispenseCollection needToCheckdispenses = new TempletDispenseCollection();
                timeLog.enterMethod("auditAutoDispense");
                HashSet<String> companySet = new HashSet<String>();
                boolean useEasDisp = false;
                if (dispenses.isEmpty() && preTemplate.isIsK3Tpl()) {
                    useEasDisp = true;
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add("id");
                    selector.add("company.id");
                    selector.add("orgBound.id");
                    selector.add("isAllowChgTemplet");
                    selector.add("isCoverTmpFormula");
                    selector.add("CU.id");
                    selector.add("isCoverFormula");
                    selector.add("isAllwChgCheckSol");
                    selector.add("isCoverNoLockCell");
                    selector.add("orgBound.status");
                    String easTplId = preTemplate.getEasTplIdForK3();
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.appendFilterItem("dispenseSrcID", (Object)easTplId);
                    view.setFilter(filter);
                    view.setSelector(selector);
                    dispenses = TempletDispenseFactory.getLocalInstance((Context)ctx).getTempletDispenseCollection(view);
                }
                for (int i2 = 0; i2 < dispenses.size(); ++i2) {
                    companySet.add(dispenses.get(i2).getCompany().getId().toString());
                }
                HashSet<String> checkCompanySet = new HashSet<String>();
                if (companySet.size() > 0) {
                    EntityViewInfo view = new EntityViewInfo();
                    view.getSelector().add(new SelectorItemInfo("id"));
                    view.getSelector().add(new SelectorItemInfo("company"));
                    FilterInfo filter = new FilterInfo();
                    view.setFilter(filter);
                    filter.getFilterItems().add(new FilterItemInfo("company", companySet, CompareType.INCLUDE));
                    filter.getFilterItems().add(new FilterItemInfo("versionStatus", (Object)new Integer(2), CompareType.LESS));
                    filter.getFilterItems().add(new FilterItemInfo("groupTemplate", (Object)pkOld.toString(), CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("templateSource", (Object)new Integer(0), CompareType.EQUALS));
                    TemplateCollection templateCollection = this.getTemplateCollection(ctx, view);
                    if (templateCollection != null && templateCollection.size() > 0) {
                        for (i = 0; i < templateCollection.size(); ++i) {
                            checkCompanySet.add(templateCollection.get(i).getCompany().getId().toString());
                        }
                    }
                }
                sql = new StringBuffer();
                sql.append(" UPDATE T_RPT_Template SET              \n");
                sql.append("     FVersionStatus = ?                 \n");
                sql.append(" WHERE FCompanyID = ?                   \n");
                sql.append(" AND FGroup = ? AND FTemplateSource = ? \n");
                sql.append(" AND FGroupTemplateID IS NOT NULL       \n");
                ArrayList<Object[]> allParams = new ArrayList<Object[]>();
                HashSet<String> updatedSet = new HashSet<String>();
                int n = dispenses.size();
                for (int i3 = 0; i3 < n; ++i3) {
                    dispenseInfo = dispenses.get(i3);
                    hasSubVersion = false;
                    if (checkCompanySet.contains(dispenseInfo.getCompany().getId().toString())) {
                        hasSubVersion = true;
                    }
                    String key = dispenseInfo.getCompany().getId().toString() + template.getGroup();
                    if (hasSubVersion && isAutoUpdate && !updatedSet.contains(key)) {
                        params.clear();
                        params.add(new Integer(2));
                        params.add(dispenseInfo.getCompany().getId().toString());
                        params.add(template.getGroup());
                        params.add(0);
                        updatedSet.add(key);
                        allParams.add(params.toArray());
                    }
                    if ((!hasSubVersion || !isAutoUpdate) && hasSubVersion) continue;
                    needToCheckdispenses.add(dispenseInfo);
                }
                if (useEasDisp) {
                    dispenses.clear();
                    needToCheckdispenses.clear();
                }
                Object[][] objectParams = new Object[allParams.size()][];
                for (i = 0; i < allParams.size(); ++i) {
                    objectParams[i] = (Object[])allParams.get(i);
                }
                CslRptUtil.batchExecute((Context)ctx, (String)sql.toString(), (Object[][])objectParams);
                ret = this.auditAutoDispense(ctx, template.getId().toString(), needToCheckdispenses, collectInfos, preTemplate.getId().toString());
                if (!StringUtils.isEmpty((String)ret)) {
                    throw new EASBizException(new NumericExceptionSubItem("1", ret));
                }
                if (collectInfos.size() > 0) {
                    TempletDispenseFactory.getLocalInstance((Context)ctx).addNewsCoverFomula(new ArrayList(collectInfos.values()));
                    this.excuteFormulaSolution(ctx, pk, templateInfo, collectInfos);
                } else if (template.isIsK3Tpl()) {
                    TempletDispenseFactory.getLocalInstance((Context)ctx).addNewsCoverFomulaForK3(template.getId().toString());
                }
                this.upPublicTemplate(ctx, preTemplate, template);
            }
        }
    }

    private void excuteFormulaSolution(Context ctx, IObjectPK pk, TemplateInfo templateInfo, Map collectInfos) throws BOSException, EASBizException {
        HashMap<String, Boolean> dispParam = new HashMap<String, Boolean>();
        TempletDispenseInfo dispense = (TempletDispenseInfo)new ArrayList(collectInfos.values()).get(0);
        dispParam.put("isAllowChgTemplate", dispense.isIsAllowChgTemplet());
        dispParam.put("isCoverTmpFormula", dispense.isIsCoverFormula());
        dispParam.put("isCoverUnLockCell", dispense.isIsCoverNoLockCell());
        dispParam.put("isAllowChgCheckSol", dispense.isIsAllwChgCheckSol());
        FormulaSoluDispenseFactory.getLocalInstance((Context)ctx).dispenseNewVersion(pk.toString(), dispParam);
        String tplGroupId = templateInfo.getGroup();
        List<String> soluIds = this.getFormulaSolutions(ctx, tplGroupId);
        if (soluIds != null && !soluIds.isEmpty()) {
            FormulaSoluDispenseFactory.getLocalInstance((Context)ctx).updateSubCompanyTemplate(soluIds, null);
        }
    }

    private List<String> getFormulaSolutions(Context ctx, String tplGroupId) throws BOSException {
        ArrayList<String> soluIds = new ArrayList<String>();
        FormulaSoluCollection solus = FormulaSoluFactory.getLocalInstance((Context)ctx).getFormulaSoluCollection("where templateGroupId = '" + tplGroupId + "' and auditedStatus = " + 1 + "");
        if (solus != null && !solus.isEmpty()) {
            for (FormulaSoluInfo formulaSoluInfo : solus) {
                soluIds.add(formulaSoluInfo.getId().toString());
            }
        }
        return soluIds;
    }

    protected void extrFormula(Context ctx, TemplateInfo template) throws EASBizException, BOSException {
        block5: {
            if (!template.isHasExtrItem()) {
                return;
            }
            ExtractFormulaScheme extrFormulaAction = null;
            FullOrgUnitInfo company = null;
            try {
                extrFormulaAction = new ExtractFormulaScheme(new DBHandler(ctx));
                if (template.getGroupTemplate() != null) {
                    company = template.getCompany();
                }
                extrFormulaAction.repeatAction(template, (OrgUnitInfo)company);
                TemplateInfo smallVersionTemplate = this.getSmallVersionTemplate(ctx, template);
                if (smallVersionTemplate != null) {
                    extrFormulaAction.repeatAction(smallVersionTemplate, (OrgUnitInfo)smallVersionTemplate.getCompany());
                }
                template.setHasExtrItem(true);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("hasExtrItem");
                this.updatePartial(ctx, (CoreBaseInfo)template, selector);
            }
            catch (AutoItemException e) {
                if (!AutoItemException.INVALID_FORMULA_DEFINE.getCode().equals(e.getSubCode()) || extrFormulaAction == null) break block5;
                extrFormulaAction.clearScheme(template, (OrgUnitInfo)company);
            }
        }
    }

    protected TemplateInfo getSmallVersionTemplate(Context ctx, TemplateInfo template) throws EASBizException, BOSException {
        try {
            if (template.getGroupTemplate() != null) {
                return null;
            }
            return TemplateFactory.getLocalInstance(ctx).getTemplateInfo(" select id,number,name,groupTemplate.id,company.*,data,templateType,sheetParam.*,versionNumber  where groupTemplate = '" + template.getId().toString() + "' and versionStatus = " + 1);
        }
        catch (ObjectNotFoundException e) {
            logger.warn((Object)"", (Throwable)e);
            return null;
        }
    }

    private void upPublicTemplate(Context ctx, TemplateInfo oldTemplate, TemplateInfo newTemplate) throws BOSException {
        if (RptTmpTypeEnum.COMMONPUBLICTEMPLATE.equals((Object)oldTemplate.getTemplateType()) && RptTmpTypeEnum.COMMONREPORT.equals((Object)newTemplate.getTemplateType())) {
            this.sealPublicTemplates(ctx, oldTemplate, newTemplate);
        }
    }

    private void insertToDispense(Context ctx, String templateId, TempletDispenseCollection dispenses, Map collectInfos, String tableName) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" INSERT INTO ").append(tableName).append("(                 \n");
        sql.append(" FID, FCreatorID, FCreateTime, FLastUpdateUserID,           \n");
        sql.append(" FLastUpdateTime, FCompanyID, FOrgBoundID, FSourceType,     \n");
        sql.append(" FDispenseSrcID, FIsAllowChgTemplet, FIsCoverTmpFormula, FControlUnitID,FIsCoverFormula,FIsAllowChgSol,FisCoverNoLockCell  \n");
        sql.append(" ) VALUES (?, ?, getdate(), ?,   getdate(), ?, ?, ?,   ?, ?, ?, ?,?,?, ?) \n");
        boolean isNewBoundOrgTable = tableName.equals(TemplateDispenseNewUtil.templatedis_new);
        Set NewTempletDisOrgTreeSet = TemplateDispenseNewUtil.getNewTempletDisOrgTreeSet((Context)ctx);
        Connection cn = null;
        PreparedStatement ps = null;
        String userID = ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString();
        String cuID = "11111111-1111-1111-1111-111111111111CCE7AED4";
        Integer sourceType = new Integer(1);
        try {
            cn = super.getConnection(ctx);
            ps = cn.prepareStatement(sql.toString());
            int size = dispenses.size();
            boolean isEmpty = true;
            boolean isNewOrgTree = false;
            for (int j = 0; j < size; ++j) {
                TempletDispenseInfo dispenseInfo = dispenses.get(j);
                isNewOrgTree = NewTempletDisOrgTreeSet.contains(dispenseInfo.getOrgBound().getId().toString());
                if (isNewBoundOrgTable && !isNewOrgTree || !isNewBoundOrgTable && isNewOrgTree) continue;
                String companyId = dispenseInfo.getCompany() == null ? "" : dispenseInfo.getCompany().getId().toString();
                isEmpty = false;
                ps.setObject(1, dispenseInfo.getId().toString());
                ps.setObject(2, userID);
                ps.setObject(3, userID);
                ps.setObject(4, companyId);
                ps.setObject(5, dispenseInfo.getOrgBound().getId().toString());
                ps.setObject(6, sourceType);
                ps.setObject(7, templateId);
                ps.setObject(8, new Integer(dispenseInfo.isIsAllowChgTemplet() ? 1 : 0));
                ps.setObject(9, new Integer(dispenseInfo.isIsCoverTmpFormula() ? 1 : 0));
                ps.setObject(10, cuID);
                ps.setObject(11, new Integer(dispenseInfo.isIsCoverFormula() ? 1 : 0));
                ps.setObject(12, new Integer(dispenseInfo.isIsAllwChgCheckSol() ? 1 : 0));
                ps.setObject(13, new Integer(dispenseInfo.isIsCoverNoLockCell() ? 1 : 0));
                ps.addBatch();
            }
            if (!isEmpty) {
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"insertToDispense error.", (Throwable)e);
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                TemplateDispenseNewUtil.clearNewTempletDisOrgTreeSet();
                SQLUtils.cleanup(ps, (Connection)cn);
                throw throwable;
            }
        }
        TemplateDispenseNewUtil.clearNewTempletDisOrgTreeSet();
        SQLUtils.cleanup((Statement)ps, (Connection)cn);
    }

    private String checkTemplateDubDispense(Context ctx, String templateId, TempletDispenseCollection dispenses, Map collectInfos, Set companyIds, Map mapSubsciebes) throws BOSException, EASBizException {
        String sDup = "";
        try {
            HashSet<String> boundIDs = new HashSet<String>();
            int size = dispenses.size();
            BOSObjectType bosType = new TempletDispenseInfo().getBOSType();
            ITempletDispense templetDispense = TempletDispenseFactory.getLocalInstance((Context)ctx);
            for (int j = 0; j < size; ++j) {
                TempletDispenseInfo dispenseInfo = dispenses.get(j);
                String companyId = dispenseInfo.getCompany() == null ? "" : dispenseInfo.getCompany().getId().toString();
                String ids = BOSUuid.create((BOSObjectType)bosType).toString();
                if (mapSubsciebes != null) {
                    mapSubsciebes.put(dispenseInfo.getId().toString(), ids);
                }
                if (!boundIDs.contains(dispenseInfo.getOrgBound().getId().toString()) && dispenseInfo.getOrgBound().getStatus().getValue() == 1) {
                    boundIDs.add(dispenseInfo.getOrgBound().getId().toString());
                }
                if (!companyIds.contains(companyId)) {
                    companyIds.add(companyId);
                }
                String key = companyId + templateId;
                if (collectInfos != null) {
                    collectInfos.put(key, dispenseInfo);
                }
                dispenseInfo.setId(BOSUuid.read((String)ids));
                dispenseInfo.setCreator((UserInfo)ctx.get((Object)"UserInfo"));
                dispenseInfo.setDispenseSrcID(templateId);
            }
            IRowSet rstemp = null;
            for (Object e : boundIDs) {
                rstemp = templetDispense.checkSingleTemplateDispenseNew((String)e, new ArrayList(companyIds), templateId, "AUDIT");
                sDup = sDup + this.getReportString(rstemp, false, ctx);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"checkTemplateDubDispense error.", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        return sDup;
    }

    private String auditAutoDispense(Context ctx, String templateId, TempletDispenseCollection dispenses, Map collectInfos, String oldTemplateId) throws BOSException, EASBizException {
        if (dispenses.size() == 0) {
            return "";
        }
        HashSet companyIds = new HashSet();
        String sDup = this.checkTemplateDubDispense(ctx, templateId, dispenses, collectInfos, companyIds, null);
        if (!StringUtils.isEmpty((String)sDup)) {
            return sDup;
        }
        try {
            this.insertToDispense(ctx, templateId, dispenses, collectInfos, TemplateDispenseNewUtil.templatedis_new);
            this.insertToDispense(ctx, templateId, dispenses, collectInfos, TemplateDispenseNewUtil.templatedis_old);
            RptReportSubscibeCollection subscibeCol = this.getRptReportSubscibes(ctx, new ArrayList(companyIds), oldTemplateId);
            this.insertRptSubscibe(ctx, subscibeCol, templateId);
        }
        catch (Exception e) {
            logger.error((Object)"auditAutoDispense error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return sDup;
    }

    private RptReportSubscibeCollection getRptReportSubscibes(Context ctx, List companyIds, String oldTemplateId) {
        if (companyIds == null || companyIds.isEmpty()) {
            return null;
        }
        String oql = " where supplyid like '%,tid=" + oldTemplateId + "'";
        try {
            if (!RptReportSubscibeFactory.getLocalInstance((Context)ctx).exists(oql)) {
                return null;
            }
        }
        catch (Exception e) {
            logger.debug((Object)"In the method getRptReportSubInfo() exception!", (Throwable)e);
        }
        HashSet<String> virsualIds = new HashSet<String>();
        for (int i = 0; i < companyIds.size(); ++i) {
            String virsualId = "cid=" + companyIds.get(i).toString() + ";tid=" + oldTemplateId;
            virsualIds.add(virsualId);
        }
        return this.getRptReportSubscibes(ctx, virsualIds);
    }

    private RptReportSubscibeCollection getRptReportSubscibes(Context ctx, Collection virsualIds) {
        if (virsualIds == null || virsualIds.isEmpty()) {
            return null;
        }
        EntityViewInfo ev = new EntityViewInfo();
        SelectorItemCollection sic = ev.getSelector();
        sic.add(new SelectorItemInfo("personDec"));
        sic.add(new SelectorItemInfo("releaseType"));
        sic.add(new SelectorItemInfo("fromSys"));
        sic.add(new SelectorItemInfo("rptType.*"));
        sic.add(new SelectorItemInfo("rptType.name"));
        sic.add(new SelectorItemInfo("reader.*"));
        sic.add(new SelectorItemInfo("supplyID"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("supplyID", (Object)virsualIds, CompareType.INCLUDE));
        ev.setFilter(filter);
        RptReportSubscibeCollection cols = null;
        IRptReportSubscibe iSub = null;
        try {
            iSub = RptReportSubscibeFactory.getLocalInstance((Context)ctx);
            cols = iSub.getRptReportSubscibeCollection(ev);
        }
        catch (Exception e) {
            logger.info((Object)"In the method getRptReportSubInfo() exception!", (Throwable)e);
        }
        return cols;
    }

    private void insertRptSubscibe(Context ctx, RptReportSubscibeCollection subscibeCol, String newTemplate) throws EASBizException, BOSException {
        if (subscibeCol == null || subscibeCol.isEmpty()) {
            return;
        }
        IRptReportSubscibe iRptReportSubscibe = RptReportSubscibeFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < subscibeCol.size(); ++i) {
            RptReportSubscibeInfo info = subscibeCol.get(i);
            String virsualId = info.getSupplyID();
            if (StringUtils.isEmpty((String)virsualId) || virsualId.indexOf(59) == -1) continue;
            String[] virsualIds = info.getSupplyID().split(";");
            virsualIds[1] = "tid=" + newTemplate;
            info.setSupplyID(virsualIds[0] + ";" + virsualIds[1]);
            RptSubscibeReceiverCollection recCols = info.getReader();
            if (recCols == null || recCols.isEmpty()) continue;
            for (int j = 0; j < recCols.size(); ++j) {
                RptSubscibeReceiverInfo recInfo = recCols.get(j);
                recInfo.setId(null);
            }
            info.setId(null);
            iRptReportSubscibe.submit((CoreBaseInfo)info);
        }
    }

    private String auditAutoDispense(Context ctx, String templateId, String preTemplateId, boolean isSingle, Map collectInfos) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select id,company,company.id,orgBound,orgBound.id,isAllowChgTemplet,isCoverTmpFormula,").append(" CU,CU.id,isCoverFormula,isAllwChgCheckSol,isCoverNoLockCell,orgBound.status").append(" where dispenseSrcID = '").append(preTemplateId).append("'");
        TempletDispenseCollection dispenses = TempletDispenseFactory.getLocalInstance((Context)ctx).getTempletDispenseCollection(sql.toString());
        HashSet companyIds = new HashSet();
        HashMap mapSubsciebes = new HashMap();
        String sDup = this.checkTemplateDubDispense(ctx, templateId, dispenses, collectInfos, companyIds, mapSubsciebes);
        if (!StringUtils.isEmpty((String)sDup)) {
            return sDup;
        }
        try {
            this.insertToDispense(ctx, templateId, dispenses, collectInfos, TemplateDispenseNewUtil.templatedis_new);
            this.insertToDispense(ctx, templateId, dispenses, collectInfos, TemplateDispenseNewUtil.templatedis_old);
            this.InserteportSubscibes(ctx, mapSubsciebes);
        }
        catch (Exception e) {
            logger.error((Object)"auditAutoDispense error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return sDup;
    }

    private void InserteportSubscibes(Context ctx, Map mapSubscibe) throws BOSException, EASBizException {
        if (mapSubscibe == null || mapSubscibe.isEmpty()) {
            return;
        }
        HashSet<String> virsualIds = new HashSet<String>();
        Iterator it = mapSubscibe.keySet().iterator();
        while (it.hasNext()) {
            virsualIds.add(it.next().toString());
        }
        RptReportSubscibeCollection col = this.getRptReportSubscibes(ctx, virsualIds);
        if (col == null || col.isEmpty()) {
            return;
        }
        IRptReportSubscibe iRptReportSubscibe = RptReportSubscibeFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < col.size(); ++i) {
            RptReportSubscibeInfo info = col.get(i);
            if (!mapSubscibe.containsKey(info.getSupplyID())) continue;
            String newSupplyId = mapSubscibe.get(info.getSupplyID()).toString();
            info.setSupplyID(newSupplyId);
            RptSubscibeReceiverCollection recCols = info.getReader();
            if (recCols == null || recCols.isEmpty()) continue;
            for (int j = 0; j < recCols.size(); ++j) {
                RptSubscibeReceiverInfo recInfo = recCols.get(j);
                recInfo.setId(null);
            }
            info.setId(null);
            iRptReportSubscibe.submit((CoreBaseInfo)info);
        }
    }

    protected String getReportString(IRowSet rs, boolean isCslTemplet, Context ctx) {
        if (rs == null) {
            return "";
        }
        StringBuffer report = new StringBuffer();
        int index = 0;
        StringBuffer keyString = new StringBuffer();
        HashMap<String, String> ls = new HashMap<String, String>();
        Object[] params = null;
        String line = null;
        String pattern1 = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Template_AsignCsl_CheckResult1", (Locale)ctx.getLocale());
        String pattern2 = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Template_AsignCsl_CheckResult2", (Locale)ctx.getLocale());
        String pattern3 = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Template_AsignCsl_CheckResult3", (Locale)ctx.getLocale());
        String pattern4 = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Template_AsignCsl_CheckResult4", (Locale)ctx.getLocale());
        String pattern5 = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Template_AsignCsl_CheckResult5", (Locale)ctx.getLocale());
        try {
            HashSet recordKeysForDup = new HashSet();
            while (rs.next()) {
                if (isCslTemplet && this.checkRepeatRecord(rs, recordKeysForDup)) continue;
                keyString = new StringBuffer();
                if (!isCslTemplet) {
                    keyString.append(rs.getString("FUnitNumber"));
                    keyString.append("!");
                    keyString.append(rs.getString("FTargetTmpNumber"));
                } else {
                    keyString.append(rs.getString("FTreeNumber"));
                    keyString.append("!");
                    keyString.append(rs.getString("FTargetTmpNumber"));
                }
                if (index == 0) {
                    params = new Object[]{rs.getString("FSourceTmpNumber"), rs.getString("FSourceTmpName")};
                    line = MessageFormat.format(pattern1, params);
                    report.append(line);
                }
                if (isCslTemplet && !ls.containsKey(keyString.toString()) || !isCslTemplet && index == 0) {
                    params = new Object[]{rs.getString("FTreeNumber"), rs.getString("FTreeName")};
                    line = MessageFormat.format(pattern2, params);
                    report.append(line);
                }
                if (!isCslTemplet && !ls.containsKey(keyString.toString())) {
                    params = new Object[]{rs.getString("FUnitNumber"), rs.getString("FUnitName")};
                    line = MessageFormat.format(pattern3, params);
                    report.append(line);
                }
                if (!ls.containsKey(keyString.toString())) {
                    params = new Object[]{rs.getString("FTargetTmpNumber"), rs.getString("FTargetTmpName")};
                    line = MessageFormat.format(pattern4, params);
                    report.append(line);
                }
                params = new Object[]{rs.getString("FTrgtSheetName"), rs.getString("FTrgtCellName"), rs.getString("FItemFormula")};
                line = MessageFormat.format(pattern5, params);
                report.append(line);
                report.append(" \r\n");
                if (!ls.containsKey(keyString.toString())) {
                    ls.put(keyString.toString(), "");
                }
                ++index;
            }
            recordKeysForDup.clear();
        }
        catch (SQLException recordKeysForDup) {
            // empty catch block
        }
        String result = report.toString().replaceAll("\\\\r", "\r").replaceAll("\\\\n", "\n");
        return result;
    }

    protected boolean checkRepeatRecord(IRowSet rs, Set recordKeysForDup) throws SQLException {
        if (recordKeysForDup == null || rs == null) {
            return false;
        }
        StringBuffer recordKeys = new StringBuffer();
        recordKeys.append(rs.getString(this.REPORT_FIELDINFO_TREENUMBER));
        recordKeys.append('-');
        recordKeys.append(rs.getString(this.REPORT_FIELDINFO_TARGETTEMPNUMBER));
        recordKeys.append('-');
        recordKeys.append(rs.getString(this.REPORT_FIELDINFO_TARGETSHEETNAME));
        recordKeys.append('-');
        recordKeys.append(rs.getString(this.REPORT_FIELDINFO_TARGETCELLNAME));
        if (recordKeysForDup.contains(recordKeys.toString())) {
            return true;
        }
        recordKeysForDup.add(recordKeys.toString());
        return false;
    }

    @Override
    protected IObjectPK _getPreviousVersion(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        String oql = " select id, versionNumber, group, company.id, templateType,groupTemplate.id,templateSource where id = '" + pk.toString() + "' ";
        TemplateInfo template = this.getTemplateInfo(ctx, oql.toString());
        String previousVersion = null;
        previousVersion = template.getTemplateSource().getValue() == 1 ? TemplateVersionMgr.getPreviousVersionByGrade(ctx, template.getGroup(), template.getVersionNumber()) : TemplateVersionMgr.getPreviousVersionLocal(template.getVersionNumber());
        if (previousVersion == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer(" SELECT FID FROM T_RPT_Template");
        ArrayList<String> params = new ArrayList<String>();
        sql.append(" WHERE FGroup = ? ");
        params.add(template.getGroup());
        sql.append(" AND FVersionNumber = ? ");
        params.add(previousVersion);
        if (RptTmpTypeEnum.COMMONREPORT.equals((Object)template.getTemplateType()) || RptTmpTypeEnum.GROUPREPORT.equals((Object)template.getTemplateType()) || RptTmpTypeEnum.RPTDYNAMICREPORT.equals((Object)template.getTemplateType()) || RptTmpTypeEnum.MULTIRPTDYNAMICREPORT.equals((Object)template.getTemplateType()) || RptTmpTypeEnum.COMMONPUBLICTEMPLATE.equals((Object)template.getTemplateType())) {
            sql.append("AND FCompanyID = ?");
            params.add(template.getCompany().getId().toString());
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        ObjectUuidPK retVal = null;
        try {
            if (rs.next()) {
                retVal = new ObjectUuidPK(rs.getString(1));
            }
            if (rs.next()) {
                throw new BOSException("multi record found; should be only one");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return retVal;
    }

    protected RowSet _CurrTypeTemplate(Context ctx, Object[] rptTypeRelaColl, RptTypeStdCollection rptTypeStdColl) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected IObjectPK _tempVersion(Context ctx, TemplateInfo editData) throws BOSException, EASBizException {
        ICSLK3Template ickt;
        CoreBaseCollection k3Col;
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getSelector().add(new SelectorItemInfo("company.*"));
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("template.id", (Object)editData.getId().toString()));
        TemplateReportSavePointCollection ccc = TemplateReportSavePointFactory.getLocalInstance(ctx).getCollection(view);
        BOSUuid srcId = editData.getId();
        editData.setReportSavePoint(new TemplateReportSavePointCollection());
        if (editData.getVersionStatus().equals((Object)VersionStatusEnum.VERSION)) {
            throw new RptAndTempException(RptAndTempException.TEMPLATE_HAS_NEW_VERSION);
        }
        ObjectUuidPK oldPK = new ObjectUuidPK(editData.getId());
        String creator = editData.getCreator().getId().toString();
        editData.setId(BOSUuid.create((BOSObjectType)this.getBOSType()));
        editData.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        if (editData.getGroup() == null) {
            editData.setGroup(Uuid.create().toString());
        }
        editData.setVersionStatus(VersionStatusEnum.CREATED);
        editData.setPublishedStatus(PublishedStatusEnum.UNPUBLISHED);
        editData.setAuditedTime(null);
        editData.setAuditor(null);
        FullOrgUnitInfo company = editData.getCompany() == null ? ContextUtil.getCurrentFIUnit((Context)ctx).castToFullOrgUnitInfo() : editData.getCompany();
        editData.setCompany(company);
        IObjectPK newPK = this.addnew(ctx, (CoreBaseInfo)editData);
        BOSUuid oldId = editData.getId();
        editData.setId(BOSUuid.read((String)newPK.toString()));
        if (ccc != null && ccc.size() > 0) {
            for (int i = 0; i < ccc.size(); ++i) {
                TemplateReportSavePointInfo info = ccc.get(i);
                info.setId(null);
                info.setTemplate(editData);
                TemplateReportSavePointFactory.getLocalInstance(ctx).addnew(info);
            }
        }
        editData.setId(oldId);
        if (RptTmpTypeEnum.SUMREPORT.equals((Object)editData.getTemplateType()) && RptSumTypeEnum.BYPAGE.equals((Object)editData.getSumType())) {
            TemplateInfo newTemplate = this.getTemplateInfo(ctx, newPK);
            ICslReportRela icrr = CslReportRelaFactory.getLocalInstance((Context)ctx);
            CoreBaseCollection cbc = icrr.getCollection("select id, sourceTemplet.id where targetTemplet.id = '" + oldPK.toString() + "'");
            CslReportRelaInfo oldRelaInfo = null;
            CslReportRelaInfo newRelaInfo = null;
            for (int i = 0; i < cbc.size(); ++i) {
                oldRelaInfo = (CslReportRelaInfo)cbc.get(i);
                newRelaInfo = new CslReportRelaInfo();
                newRelaInfo.setSourceTemplet(oldRelaInfo.getSourceTemplet());
                newRelaInfo.setTargetTemplet(newTemplate);
                icrr.addnew((CoreBaseInfo)newRelaInfo);
            }
        }
        if (RptTmpTypeEnum.DIFFTABLE.equals((Object)editData.getTemplateType())) {
            TemplateInfo newTemplate = this.getTemplateInfo(ctx, newPK);
            IDiffTableSumRela idr = DiffTableSumRelaFactory.getLocalInstance((Context)ctx);
            CoreBaseCollection col = idr.getCollection("select id, sumTmpGroup where diffTableTemplate.id = '" + oldPK.toString() + "'");
            for (int i = 0; i < col.size(); ++i) {
                DiffTableSumRelaInfo info = (DiffTableSumRelaInfo)col.get(i);
                info.setId(null);
                info.setDiffTableTemplate(newTemplate);
                idr.addnew((CoreBaseInfo)info);
            }
        }
        if ((RptTmpTypeEnum.GROUPCOMMREPORT.equals((Object)editData.getTemplateType()) || RptTmpTypeEnum.DYNAMICNORMALREPORT.equals((Object)editData.getTemplateType())) && (k3Col = (ickt = CSLK3TemplateFactory.getLocalInstance((Context)ctx)).getCollection("where sourceTemplate.id = '" + oldPK + "'")) != null && k3Col.size() != 0) {
            CSLK3TemplateInfo k3 = (CSLK3TemplateInfo)k3Col.get(0);
            k3.setId(null);
            TemplateInfo newTemplate = this.getTemplateInfo(ctx, newPK);
            k3.setSourceTemplate(newTemplate);
            ickt.addnew((CoreBaseInfo)k3);
            ArrayList<String> tplIds = new ArrayList<String>();
            tplIds.add(newPK.toString());
            this.createEasTplForK3(ctx, tplIds, true);
        }
        if (editData.getTemplateType().getValue() == 1) {
            RptIndexFacadeFactory.getLocalInstance(ctx).synVersionIndex(oldPK.toString(), newPK.toString());
            this.updateDiscretePermissionWhenVersion(ctx, oldPK.toString(), newPK.toString());
            String updateCreator = "UPDATE T_RPT_TEMPLATE SET FCreatorID = ? where FID = ?";
            DbUtil.execute((Context)ctx, (String)updateCreator.toString(), (Object[])new String[]{creator, newPK.toString()});
        }
        if (editData.getTemplateType().getValue() == 1 || editData.getTemplateType().getValue() == 14) {
            this._updateTemplateStatus(ctx, oldPK.toString(), newPK.toString());
        }
        editData.setId(srcId);
        return newPK;
    }

    private void createEasTplForK3(Context ctx, String easTplId, boolean isUpdateForExist, String preVersEasTplId) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("group");
        selector.add("versionNumber");
        TemplateInfo preEasTplInfoForK3 = this.getEasTplForK3(ctx, preVersEasTplId, selector);
        if (preEasTplInfoForK3 == null) {
            return;
        }
        TemplateInfo easTplInfo = this.getTemplateInfo(ctx, (IObjectPK)new ObjectUuidPK(easTplId));
        String tplGroup = preEasTplInfoForK3.getGroup();
        easTplInfo.setVersionNumber(preEasTplInfoForK3.getVersionNumber());
        easTplInfo.setGroup(tplGroup);
        TemplateCollection easTplInfos = new TemplateCollection();
        easTplInfos.add(easTplInfo);
        this.createEasTplForK3(ctx, easTplInfos, isUpdateForExist);
    }

    private void setVersionStatus(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StringBuffer _sql = new StringBuffer("update t_rpt_Template set");
        _sql.append(" FVersionStatus= ?,");
        _sql.append(" FPublishedStatus= ?");
        _sql.append(" where fid= ?");
        Object[] params = new Object[]{new Integer(2), new Integer(2), pk.toString()};
        DbUtil.execute((Context)ctx, (String)_sql.toString(), (Object[])params);
    }

    private void updateDiscretePermissionWhenVersion(Context ctx, String oldTemplateId, String newTemplateId) throws BOSException {
        String sql = " insert into T_PM_DiscretePermRptTemplate                      (FUserID, FOrgID, FRoleID, FPermItemID, FBizDataID)                select FUserID, FOrgID, FRoleID, FPermItemID, '" + newTemplateId + "' as FBizDataID      from T_PM_DiscretePermRptTemplate                                  where FBizDataID=  '" + oldTemplateId + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void deleteCslCheck(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    @Override
    protected void _addForRpt(Context ctx, IObjectValue inof) throws BOSException {
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return super._getValue(ctx, pk);
    }

    protected RptTmpTypeEnum getTmpType(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("templateType");
        Object cn = null;
        TemplateInfo templateInfo = this.getTemplateInfo(ctx, pk, selector);
        if (templateInfo == null) {
            return null;
        }
        return templateInfo.getTemplateType();
    }

    private TemplateInfo getTemplate(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("templateType");
        selector.add("groupTemplate.id");
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("company"));
        selector.add(new SelectorItemInfo("group"));
        selector.add(new SelectorItemInfo("createTime"));
        selector.add(new SelectorItemInfo("versionNumber"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("hasExtrItem"));
        selector.add(new SelectorItemInfo("orgType"));
        selector.add(new SelectorItemInfo("templateSource"));
        Object cn = null;
        TemplateInfo templateInfo = this.getTemplateInfo(ctx, pk, selector);
        if (templateInfo == null) {
            return null;
        }
        return templateInfo;
    }

    protected void _unAuditForCheckRpt(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (this._existRpt(ctx, pk)) {
            throw new ReportException(ReportException.TEMPLATE_EXIST_REPORT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _publish(Context ctx, List pk) throws BOSException, EASBizException {
        IObjectPK objectPK = LogUtil.beginLog((Context)ctx, (String)(RptUtil.getReportResource("template", ctx.getLocale()) + RptUtil.getReportResource("Report_Publish", ctx.getLocale())), (BOSObjectType)new TemplateInfo().getBOSType(), null, (String)this.getLogDetailString(this.getNumberListByPK(ctx, pk)));
        try {
            this.doPubish(ctx, pk, PublishedStatusEnum.PUBLISHED);
        }
        finally {
            LogUtil.afterLog((Context)ctx, (IObjectPK)objectPK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _unPublish(Context ctx, List pk) throws BOSException, EASBizException {
        IObjectPK objectPK = LogUtil.beginLog((Context)ctx, (String)(RptUtil.getReportResource("template", ctx.getLocale()) + RptUtil.getReportResource("Report_UnPublish", ctx.getLocale())), (BOSObjectType)new TemplateInfo().getBOSType(), null, (String)this.getLogDetailString(this.getNumberListByPK(ctx, pk)));
        try {
            this.doPubish(ctx, pk, PublishedStatusEnum.UNPUBLISHED);
        }
        finally {
            LogUtil.afterLog((Context)ctx, (IObjectPK)objectPK);
        }
    }

    private void doPubish(Context ctx, List pk, PublishedStatusEnum publish) throws BOSException {
        StringBuffer _sql = new StringBuffer("update t_rpt_Template set");
        _sql.append(" FPublishedStatus= ? where");
        Object[] params = new Object[pk.size() + 1];
        params[0] = new Integer(publish.getValue());
        for (int i = 0; i < pk.size(); ++i) {
            params[i + 1] = pk.get(i).toString();
            if (i == 0) {
                _sql.append(" fid= ?");
                continue;
            }
            _sql.append(" OR fid= ?");
        }
        DbUtil.execute((Context)ctx, (String)_sql.toString(), (Object[])params);
    }

    private String getLogDetailString(IRowSet set) {
        StringBuffer sb = new StringBuffer();
        try {
            if (set.next()) {
                sb.append(set.getString("fnumber"));
            }
            while (set.next()) {
                sb.append(", ").append(set.getString("fnumber"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return sb.toString();
    }

    private IRowSet getNumberListByPK(Context ctx, List pk) throws BOSException {
        StringBuffer _sql = new StringBuffer("select fnumber from t_rpt_Template where");
        Object[] params = new Object[pk.size()];
        for (int i = 0; i < pk.size(); ++i) {
            params[i] = pk.get(i).toString();
            if (i == 0) {
                _sql.append(" fid= ?");
                continue;
            }
            _sql.append(" OR fid= ?");
        }
        return DbUtil.executeQueryNoTx((Context)ctx, (String)_sql.toString(), (Object[])params);
    }

    @Override
    protected boolean _existRpt(Context ctx, IObjectPK tempPK) throws BOSException, EASBizException {
        IReport iReport = ReportFactory.getLocalInstance(ctx);
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("template", (Object)tempPK.toString());
        FilterItemInfo filterItemK3 = new FilterItemInfo("k3Template.id", (Object)tempPK.toString());
        filterInfo.getFilterItems().add(filterItem);
        filterInfo.getFilterItems().add(filterItemK3);
        filterInfo.setMaskString("#0 or #1");
        return iReport.exists(filterInfo);
    }

    @Override
    protected void _updateForData(Context ctx, IObjectValue model) throws BOSException, EASAppException {
        TemplateInfo templateInfo = (TemplateInfo)model;
        ObjectStringPK pk = new ObjectStringPK(templateInfo.getId().toString());
        try {
            super._update(ctx, (IObjectPK)pk, model);
        }
        catch (EASBizException e) {
            throw new BOSException(e.getMessage());
        }
        catch (BOSException e) {
            throw e;
        }
    }

    @Override
    protected void _unSubmit(Context ctx, BOSUuid id) throws BOSException {
    }

    @Override
    protected void _submitUnAudite(Context ctx, BOSUuid id) throws BOSException {
    }

    @Override
    protected void _submitWorkFlow(Context ctx, BOSUuid id) throws BOSException {
    }

    @Override
    protected void _submitCslNormalWF(Context ctx, BOSUuid id) throws BOSException {
    }

    @Override
    protected void _submitCslWF(Context ctx, BOSUuid id) throws BOSException {
    }

    @Override
    protected IObjectPK _getLatestVersion(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        TemplateInfo template = this.getTemplateInfo(ctx, pk);
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append(" SELECT TOP 1 FID FROM T_Rpt_Template \n");
        sql.append(" WHERE FGroup = ? \n");
        params.add(template.getGroup());
        sql.append(" AND FVersionStatus = ? \n");
        params.add(new Integer(1));
        sql.append(" AND FAuditedStatus = ? \n");
        params.add(new Integer(2));
        if (template.getGroupTemplate() != null) {
            sql.append("     AND (FCompanyID = ? OR FGroupTemplateID IS NULL) \n");
            params.add(template.getCompany().getId().toString());
        } else {
            sql.append("     AND FGroupTemplateID IS NULL \n");
        }
        sql.append(" ORDER BY FLastUpdateTime DESC ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        ObjectUuidPK pkResult = null;
        try {
            if (rs.next()) {
                pkResult = new ObjectUuidPK(rs.getString(1));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return pkResult;
    }

    private IObjectPK getLatestVersionContainUnAudit(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        TemplateInfo template = this.getTemplateInfo(ctx, pk);
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append(" SELECT TOP 1 FID FROM T_Rpt_Template \n");
        sql.append(" WHERE FGroup = ? \n");
        params.add(template.getGroup());
        sql.append(" AND FVersionStatus <> ? \n");
        params.add(new Integer(2));
        if (template.getGroupTemplate() != null) {
            sql.append("     AND (FCompanyID = ? OR FGroupTemplateID IS NULL) \n");
            params.add(template.getCompany().getId().toString());
        } else {
            sql.append("     AND FGroupTemplateID IS NULL \n");
        }
        sql.append(" ORDER BY FLastUpdateTime DESC ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        ObjectUuidPK pkResult = null;
        try {
            if (rs.next()) {
                pkResult = new ObjectUuidPK(rs.getString(1));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return pkResult;
    }

    @Override
    protected TemplateInfo _getLatestVersionTempletInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IObjectPK lastVersionPk = this._getLatestVersion(ctx, pk);
        TemplateInfo template = this.getTemplate(ctx, lastVersionPk);
        return template;
    }

    @Override
    protected boolean _isLastestVersion(Context ctx, String id, boolean isForGroup, boolean isEnabledOnly) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("templateType"));
        sic.add(new SelectorItemInfo("company"));
        sic.add(new SelectorItemInfo("group"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("versionNumber"));
        sic.add(new SelectorItemInfo("templateSource"));
        TemplateInfo template = this.getTemplateInfo(ctx, (IObjectPK)new ObjectUuidPK(id), sic);
        return this.isCompanyLastestVersion(ctx, id, isForGroup, isEnabledOnly, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString(), template);
    }

    private boolean isCompanyLastestVersion(Context ctx, String id, boolean isForGroup, boolean isEnabledOnly, String companyID, TemplateInfo template) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        if (RptTmpTypeEnum.COMMONREPORT.equals((Object)template.getTemplateType()) || RptTmpTypeEnum.GROUPREPORT.equals((Object)template.getTemplateType()) || RptTmpTypeEnum.RPTDYNAMICREPORT.equals((Object)template.getTemplateType()) || RptTmpTypeEnum.MULTIRPTDYNAMICREPORT.equals((Object)template.getTemplateType()) || RptTmpTypeEnum.COMMONPUBLICTEMPLATE.equals((Object)template.getTemplateType()) || !isForGroup) {
            if (template.getTemplateSource().equals((Object)TemplateSourceEnum.GRADETEMPLATE)) {
                sql.append(" SELECT solu.FVersionNumber \n");
                sql.append(" FROM T_CSL_FormulaSolu solu \n");
                sql.append(" INNER JOIN T_Csl_FormulaSoluDispense dispense on dispense.FFormulaSoluId=solu.fid \n");
                sql.append(" WHERE solu.FTemplateGroupId = ? \n");
                params.add(template.getGroup());
                sql.append(" And dispense.FCompanyId = ? \n");
                params.add(template.getCompany().getId().toString());
                sql.append(" AND solu.FVersionStatus = ? \n");
                params.add(new Integer(1));
            } else {
                sql.append(" SELECT FVersionNumber              \n");
                sql.append(" FROM T_RPT_Template            \n");
                sql.append(" WHERE FCompanyID = ?           \n");
                params.add(companyID);
                sql.append("     AND FGroup = ?             \n");
                params.add(template.getGroup());
                sql.append("     AND (FTemplateType =? or FTemplateType =? or FTemplateType =? or FTemplateType =? or FTemplateType =?)    \n");
                params.add(new Integer(1));
                params.add(new Integer(2));
                params.add(new Integer(12));
                params.add(new Integer(14));
                params.add(new Integer(16));
            }
        } else {
            sql.append(" SELECT FVersionNumber              \n");
            sql.append(" FROM T_RPT_Template            \n");
            sql.append(" WHERE FGroup = ?               \n");
            params.add(template.getGroup());
            sql.append("     AND (FTemplateType = ?     \n");
            params.add(new Integer(5));
            sql.append("     OR FTemplateType = ?       \n");
            params.add(new Integer(6));
            sql.append("     OR FTemplateType = ?       \n");
            params.add(new Integer(10));
            sql.append("     OR FTemplateType = ?       \n");
            params.add(new Integer(11));
            sql.append("     OR FTemplateType = ?       \n");
            params.add(new Integer(15));
            sql.append("     OR FTemplateType = ?       \n");
            params.add(new Integer(4));
            sql.append("     OR FTemplateType = ?)      \n");
            params.add(new Integer(3));
        }
        if (isEnabledOnly) {
            sql.append("     AND FVersionStatus = ? \n");
            params.add(new Integer(1));
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        String tempVN = template.getVersionNumber();
        try {
            while (rs.next()) {
                if (TemplateControllerBean.versionCompare(rs.getString(1), tempVN) <= 0) continue;
                return false;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return true;
    }

    private static final int versionCompare(String left, String right) {
        String[] l = left.split("\\.");
        String[] r = right.split("\\.");
        int len = Math.max(l.length, r.length);
        for (int i = 0; i < len; ++i) {
            int il = 0;
            int ir = 0;
            if (i <= l.length - 1) {
                il = Integer.parseInt(l[i]);
            }
            if (i <= r.length - 1) {
                ir = Integer.parseInt(r[i]);
            }
            if (il > ir) {
                return 1;
            }
            if (il >= ir) continue;
            return -1;
        }
        return 0;
    }

    @Override
    protected List _getTemplateIds(Context ctx, List selectedPathId, ArrayList tempTypeList, boolean audited, boolean isRemovePublished, String companyPK, EntityViewInfo commonView, String permissionCondition) throws BOSException, EASBizException {
        return this.getIDs(ctx, selectedPathId, tempTypeList, audited, isRemovePublished, companyPK, -1, commonView, permissionCondition);
    }

    private List getIDs(Context ctx, List selectedPathId, ArrayList tempTypeList, boolean isNeedAudited, boolean isRemovePublished, String companyPK, int top, EntityViewInfo commonView, String permissionCondition) throws BOSException, EASBizException {
        int orgType = this.decodeOrgType(tempTypeList);
        int periodType = this.decodePeriodType(tempTypeList);
        StringBuffer sortBuf = new StringBuffer();
        StringBuffer groupBuf = new StringBuffer();
        boolean isBatchReport = false;
        if (commonView != null) {
            SorterItemCollection sorter;
            if (commonView.getFilter() != null) {
                FilterItemCollection items = commonView.getFilter().getFilterItems();
                for (int i = 0; i < items.size(); ++i) {
                    FilterItemInfo filter = items.get(i);
                    if (filter == null || !"isBatchReport".equals(filter.getPropertyName()) || !"true".equals(filter.getCompareValue())) continue;
                    isBatchReport = true;
                    break;
                }
            }
            if ((sorter = commonView.getSorter()) != null && sorter.size() > 0) {
                for (int j = 0; j < sorter.size(); ++j) {
                    SorterItemInfo info = sorter.get(j);
                    String p = info.getPropertyName();
                    if (p.equalsIgnoreCase("Template.templateType")) {
                        p = "template.FTEMPLATETYPE";
                    } else if (p.equalsIgnoreCase("Template.number")) {
                        p = "template.FNUMBER";
                    } else if (p.equalsIgnoreCase("Template.name")) {
                        p = "template.FNAME";
                    } else if (p.equalsIgnoreCase("Template.periodType")) {
                        p = "template.FPERIODTYPE";
                    } else if (p.equalsIgnoreCase("lastUpdateUser.name")) {
                        p = "lastUpdateUser.FNAME_" + ctx.getLocale();
                    } else if (p.equalsIgnoreCase("lastUpdateTime")) {
                        p = "template.FLASTUPDATETIME";
                    } else if (p.equalsIgnoreCase("publishedStatus")) {
                        p = "template.FPUBLISHEDSTATUS";
                    } else if (p.equalsIgnoreCase("auditedStatus")) {
                        p = "template.FAUDITEDSTATUS";
                    } else if (p.equalsIgnoreCase("auditor.name")) {
                        p = "auditor.FNAME_" + ctx.getLocale();
                    } else if (p.equalsIgnoreCase("versionNumber")) {
                        p = "template.FVERSIONNUMBER";
                    } else if (p.equalsIgnoreCase("canClosePeriod")) {
                        p = "template.FCANCLOSEPERIOD";
                    } else if (p.equalsIgnoreCase("CheckOpenPeriod")) {
                        p = "template.FCHECKOPENPERIOD";
                    } else if (p.equalsIgnoreCase("creator.name")) {
                        p = "creator.FNAME_" + ctx.getLocale();
                    } else if (p.equalsIgnoreCase("createTime")) {
                        p = "template.FCreateTime";
                    } else if (p.equalsIgnoreCase("number")) {
                        p = "template.FNumber";
                    } else if (p.equalsIgnoreCase("name")) {
                        p = "template.FName";
                    }
                    if (j > 0) {
                        sortBuf.append(", ");
                    } else {
                        sortBuf.append(" ORDER BY ");
                    }
                    groupBuf.append(", ").append(p);
                    sortBuf.append(p).append(" ").append(info.getSortType());
                }
            }
        }
        String dbType = (String)ctx.get((Object)"dbType");
        IRowSet idRowset = null;
        try {
            String companyid = null;
            companyid = companyPK == null ? ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString() : companyPK.toString();
            if (!StringUtils.isEmpty((String)permissionCondition) && permissionCondition.startsWith("not")) {
                String permissionContidion2 = PermissionFactory.getLocalInstance((Context)ctx).getQueryPermissionSQL((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId()), (IObjectPK)new ObjectUuidPK(companyid), "rpt_template_view");
                permissionCondition = permissionCondition + " and template.fid in (" + permissionContidion2 + ")";
            }
            if (selectedPathId == null || selectedPathId.size() == 0) {
                ArrayList<Object> myparam = new ArrayList<Object>(10);
                StringBuffer kqlBuffer = new StringBuffer(484);
                kqlBuffer.append(" select " + (top > 0 ? "top " + top : ""));
                if (3 != DbType.getValue((String)dbType)) {
                    kqlBuffer.append(" template.fid,template.count from (select ");
                }
                kqlBuffer.append(" template.fid fid, min(d.fseq),sum(d.fseq), count(r.FID) count from T_RPT_Template template  \n").append(" left join T_RPT_RptTypeRela r on template.FID = r.FReportID                                           \n").append(" left join T_PM_User creator on template.FCreatorID = creator.FID                                      \n").append(" left join T_PM_User lastUpdateUser on template.FLastUpdateUserID = lastUpdateUser.FID                 \n").append(" left join T_PM_User auditor on template.FAuditorID = auditor.FID                                      \n").append(" left join t_rpt_reporttype c on r.freporttypeid = c.fid                                               \n").append(" left join t_rpt_rpttypestd d on c.ftypestandid = d.fid                                                \n").append(" where template.FCompanyId = ?                                                                         \n").append(" and template.forgtype =").append(orgType).append("\n");
                if (periodType != -1) {
                    kqlBuffer.append(" and template.fPeriodType =").append(periodType).append("\n");
                }
                myparam.add(companyid);
                if (isRemovePublished) {
                    kqlBuffer.append(" and template.FPublishedStatus = 1   \n");
                }
                kqlBuffer.append(" and template.fversionStatus <= 1        \n");
                if (isNeedAudited) {
                    kqlBuffer.append(" and template.fauditedstatus = 2");
                }
                if (tempTypeList != null && tempTypeList.size() > 0) {
                    kqlBuffer.append(" and template.ftemplateType in(");
                    for (int j = 0; j < tempTypeList.size(); ++j) {
                        RptTmpTypeEnum rptTmpTypeEnum = (RptTmpTypeEnum)((Object)tempTypeList.get(j));
                        if (j > 0) {
                            kqlBuffer.append(",");
                        }
                        kqlBuffer.append("?");
                        myparam.add(new Integer(rptTmpTypeEnum.getValue()));
                    }
                    kqlBuffer.append(" )");
                }
                kqlBuffer.append(" and template.ftemplateType <> ? ");
                myparam.add(new Integer(14));
                if (!StringUtils.isEmpty((String)permissionCondition)) {
                    kqlBuffer.append(" and template.fid " + permissionCondition);
                }
                kqlBuffer.append(" group by template.fid                                                   ").append(groupBuf);
                if (!isBatchReport) {
                    kqlBuffer.append(" having min(d.fseq)>1 or sum(d.fseq) = 0 or count(r.fid)=0           ");
                }
                kqlBuffer.append(sortBuf);
                if (3 != DbType.getValue((String)dbType)) {
                    kqlBuffer.append(") template");
                }
                idRowset = DbUtil.executeQuery((Context)ctx, (String)kqlBuffer.toString(), (Object[])myparam.toArray());
                DebugLogger.info(logger, "template execute kql", kqlBuffer);
                DebugLogger.info(logger, "params", myparam.toArray());
            } else {
                int selectArrayIdLength = selectedPathId.size();
                ArrayList<Object> params = new ArrayList<Object>(10);
                StringBuffer kqlBuffer = new StringBuffer();
                kqlBuffer.append(" select " + (top > 0 ? "top " + top : ""));
                if (3 != DbType.getValue((String)dbType)) {
                    kqlBuffer.append(" template.fid,template.count from (select ");
                }
                kqlBuffer.append(" template.fid fid, count(type.fid) count from T_RPT_Template template             \n").append(" inner join T_RPT_RptTypeRela rela on template.FID = rela.FReportID                        \n").append(" left join T_PM_User creator on template.FCreatorID = creator.FID                          \n").append(" left join T_PM_User lastUpdateUser on template.FLastUpdateUserID = lastUpdateUser.FID     \n").append(" left join T_PM_User auditor on template.FAuditorID = auditor.FID                          \n").append(" inner join t_rpt_reporttype type on rela.freporttypeid = type.fid                         \n").append(" where template.FCompanyID = ?                                                             \n").append(" and template.forgtype =").append(orgType).append(" \n");
                params.add(companyid);
                if (isNeedAudited) {
                    kqlBuffer.append(" and template.fauditedstatus =?                                               \n");
                    params.add(new Integer(2));
                }
                if (isRemovePublished) {
                    kqlBuffer.append(" and template.FPublishedStatus = 1                                            \n");
                }
                kqlBuffer.append(" and template.fversionStatus <= 1                                                 \n");
                kqlBuffer.append(" and type.fid in(  ");
                for (int i = 0; i < selectArrayIdLength; ++i) {
                    params.add(selectedPathId.get(i).toString());
                    if (i == 0) {
                        kqlBuffer.append(" ? ");
                        continue;
                    }
                    kqlBuffer.append(" ,? ");
                }
                kqlBuffer.append(" ) \n");
                if (tempTypeList != null && tempTypeList.size() > 0) {
                    kqlBuffer.append(" and template.ftemplateType in(");
                    for (int j = 0; j < tempTypeList.size(); ++j) {
                        RptTmpTypeEnum rptTmpTypeEnum = (RptTmpTypeEnum)((Object)tempTypeList.get(j));
                        if (j > 0) {
                            kqlBuffer.append(",");
                        }
                        kqlBuffer.append("?");
                        params.add(new Integer(rptTmpTypeEnum.getValue()));
                    }
                    kqlBuffer.append(" ) \n");
                }
                kqlBuffer.append(" and template.ftemplateType <> ? \n");
                params.add(new Integer(14));
                if (!StringUtils.isEmpty((String)permissionCondition)) {
                    kqlBuffer.append(" and template.fid " + permissionCondition);
                }
                kqlBuffer.append(" group by template.fid \n").append(groupBuf).append(" having count(type.fid) = ? ").append(sortBuf);
                if (3 != DbType.getValue((String)dbType)) {
                    kqlBuffer.append(") template");
                }
                params.add(new Integer(selectArrayIdLength));
                idRowset = DbUtil.executeQuery((Context)ctx, (String)kqlBuffer.toString(), (Object[])params.toArray());
                DebugLogger.info(logger, "template execute kql", kqlBuffer);
                DebugLogger.info(logger, "params", params.toArray());
            }
            ArrayList<String> retrievedID = new ArrayList<String>();
            while (idRowset.next()) {
                retrievedID.add(idRowset.getString("fid"));
            }
            return retrievedID;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    @Override
    protected IRowSet _getTreeData(Context ctx, ArrayList selectArrayId, boolean isRemovePublished, boolean isNeedAudit, ArrayList tempTypeList, String currCompanyId, boolean isFirstPage, List pageIds, String permissionCondition, EntityViewInfo _view) throws BOSException {
        String companyid = currCompanyId == null ? ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString() : currCompanyId;
        HashSet set = new HashSet();
        try {
            if (isFirstPage) {
                set.addAll(this.getIDs(ctx, selectArrayId, tempTypeList, isNeedAudit, isRemovePublished, companyid, 100, _view, permissionCondition));
            } else {
                set.addAll(pageIds);
            }
            if (set.size() != 0) {
                MetaDataPK queryPK = null;
                queryPK = !StringUtils.isEmpty((String)permissionCondition) && permissionCondition.startsWith("not") ? new MetaDataPK("com.kingdee.eas.fi.rpt.app", "TemplatePermissionF7Query") : new MetaDataPK("com.kingdee.eas.fi.rpt.app", "TemplateQuery");
                IQueryExecutor queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
                view.setFilter(filterInfo);
                if (_view != null) {
                    Iterator it = _view.getSorter().iterator();
                    while (it.hasNext()) {
                        view.getSorter().add((SorterItemInfo)it.next());
                    }
                }
                queryExecutor.setObjectView(view);
                queryExecutor.option().isAutoTranslateEnum = true;
                if (StringUtils.isEmpty((String)permissionCondition)) {
                    queryExecutor.option().isIgnorePermissionCheck = true;
                }
                IRowSet rowset = queryExecutor.executeQuery();
                return rowset;
            }
            DynamicRowSet dynamicRowSet = new DynamicRowSet(1);
            dynamicRowSet.setColInfo(1, "field1", "pianrende", 1, null);
            return dynamicRowSet;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private int decodeOrgType(List lst) {
        int orgType = 1;
        if (lst != null && lst.size() > 0 && lst.get(lst.size() - 1) instanceof OrgType) {
            orgType = ((OrgType)lst.get(lst.size() - 1)).getValue();
            lst.remove(lst.size() - 1);
        }
        return orgType;
    }

    private int decodePeriodType(List lst) {
        int periodType = -1;
        if (lst != null && lst.size() > 0 && lst.get(lst.size() - 1) instanceof RptPeriodTypeEnum) {
            periodType = ((RptPeriodTypeEnum)lst.get(lst.size() - 1)).getValue();
            lst.remove(lst.size() - 1);
        }
        return periodType;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected IRowSet _getTreeDispenseData(Context ctx, String companyID, boolean isRemovePublished, boolean isOnlyUnversion, boolean isShowFreezed, List templateType, EntityViewInfo view) throws BOSException, EASBizException {
        displayTemplateTypeName = "";
        displayTemplateTypeValue = "";
        tmplSet = null;
        templateTypeIter = null;
        isDisplayTemplateType = false;
        isFromNewRptUI = false;
        isGroupCommReport = true;
        isK3Enable = AccountORMFactory.getLocalInstance(ctx).isLockByCompany((IObjectPK)new ObjectUuidPK(companyID));
        v0 = isUseK3 = isK3Enable != false && isGroupCommReport != false;
        if (isUseK3) {
            return this.getTreeDispenseDataNew(ctx, companyID, isRemovePublished, isOnlyUnversion, isShowFreezed, templateType, view);
        }
        orgType = this.decodeOrgType(templateType);
        periodType = this.decodePeriodType(templateType);
        if (templateType != null && templateType.size() == 0) {
            templateType = null;
        }
        includeOtherDCName = "";
        includeOtherDCValue = "";
        if (view != null && view.getFilter() != null && (filterItems = view.getFilter().getFilterItems()).size() >= 0) {
            size = filterItems.size();
            for (i = 0; i < size; ++i) {
                filterItem = filterItems.get(i);
                if (filterItem == null) continue;
                includeOtherDCName = filterItem.getPropertyName();
                includeOtherDCValue = filterItem.getCompareValue().toString();
                if (includeOtherDCName == null || !includeOtherDCName.equals("includeOtherDC")) {
                    includeOtherDCName = "";
                    includeOtherDCValue = "";
                }
                if ((displayTemplateTypeName = filterItem.getPropertyName()) != null && displayTemplateTypeName.equals("displayTemplateType.id")) {
                    isDisplayTemplateType = true;
                    templateTypeIter = ((Set)filterItem.getCompareValue()).iterator();
                    displayTemplateTypeValue = RptUtilForServer.createInStringSql(templateTypeIter, ctx);
                }
                if (displayTemplateTypeName != null && displayTemplateTypeName.equals("isFromNewRptUI")) {
                    isFromNewRptUI = true;
                }
                if ((schemeKey = filterItem.getPropertyName()) == null || !schemeKey.equals("schemeId")) continue;
                schemeid = (String)filterItem.getCompareValue();
                tplDao = RptWeaveSchmTempEntryFactory.getLocalInstance((Context)ctx);
                coll = tplDao.getRptWeaveSchmTempEntryCollection("select template.id where scheme = '" + schemeid + "'");
                it = coll.iterator();
                set = new HashSet<String>();
                while (it.hasNext()) {
                    info = (RptWeaveSchmTempEntryInfo)it.next();
                    set.add(info.getTemplate().getId().toString());
                }
                tmplIDs = set.iterator();
                tmplSet = RptUtilForServer.createInStringSql(tmplIDs, ctx);
            }
        }
        if (isFromNewRptUI && view != null && view.getFilter() != null) {
            view.getFilter().getFilterItems().removeObject((Object)"isFromNewRptUI");
        }
        if (companyID == null) {
            companyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        }
        currentUserPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        dataRule = RptUtilForServer.getCommonDataRule(ctx, (IObjectPK)currentUserPK, (IObjectPK)new ObjectUuidPK(companyID), "rpt_template_view");
        permissionCondition = null;
        if (!StringUtils.isEmpty((String)dataRule)) {
            try {
                permissionCondition = PermissionFactory.getLocalInstance((Context)ctx).getQueryPermissionSQL((IObjectPK)currentUserPK, (IObjectPK)new ObjectUuidPK(companyID), "rpt_template_view");
                permissionCondition = "in (" + permissionCondition + ")";
            }
            catch (EASBizException e1) {
                TemplateControllerBean.logger.error((Object)e1.getStackTrace(), (Throwable)e1);
            }
        }
        sql = new StringBuffer();
        language = "_" + ctx.getLocale().getLanguage();
        sql.append(" select DISTINCT * from ( \n").append("  SELECT    \n").append("  TEMPLATE.FID AS \"TEMPLATE.ID\",  \n").append("  TEMPLATE.FName AS \"TEMPLATE.NAME\",  \n").append("  TEMPLATE.FNumber AS \"TEMPLATE.NUMBER\",  \n").append("  TEMPLATE.FPeriodType AS \"TEMPLATE.PERIODTYPE\", \n").append("  TEMPLATE.FTemplateType AS \"TEMPLATE.TEMPLATETYPE\", \n").append("  TEMPLATE.FGroup AS \"TEMPLATE.GROUP\",  \n").append("  TEMPLATE.FGroupTemplateID AS \"TEMPLATE.GroupTemplateID\",  \n").append("  CREATOR.FName_" + ctx.getLocale() + " AS \"CREATOR.NAME\", \n").append("  CREATOR.FID AS \"CREATOR.ID\", \n").append("  LASTUPDATEUSER.FName_" + ctx.getLocale() + " AS \"LASTUPDATEUSER.NAME\", \n").append("  TEMPLATE.FLastUpdateTime AS \"LASTUPDATETIME\", \n").append("  AUDITOR.FName_" + ctx.getLocale() + " AS \"AUDITOR.NAME\", \n").append("  AUDITOR.FID AS \"AUDITOR.ID\", \n").append("  TEMPLATE.FVersionNumber AS \"VERSIONNUMBER\", \n").append("  TEMPLATE.FIsIncludeOtherDC AS \"INCLUDEOTHERDC\", \n").append("  TEMPLATE.FCanClosePeriod AS \"CANCLOSEPERIOD\", \n").append("  TEMPLATE.FCheckOpenPeriod AS \"CHECKOPENPERIOD\", \n").append("  TEMPLATE.FAuditedStatus AS \"AUDITEDSTATUS\", \n").append("  TEMPLATE.FPublishedStatus AS \"PUBLISHEDSTATUS\", \n").append("  TEMPLATE.FDescription AS \"FDescription\", \n").append("  COMPANY.FLongNumber AS \"COMPANY.LONGNUMBER\", \n").append("  Template.FCreateTime AS \"CreateTime\",  \n").append("  COMPANY.FID AS \"COMPANY.ID\",  \n").append("  COMPANY.FName").append(language).append(" AS \"COMPANY.NAME\",  \n").append("  d.FSourceType AS \"TEMPLETDISPENSE.SOURCETYPE\",  \n").append("  d.FIsAllowChgTemplet AS \"ISALLOWCHANGE\" , \n").append("  TEMPLATE.GU AS \"ISGROUP\" , \n").append("  TEMPLATE.FISK3TPL AS \"ISK3TPL\",  \n").append("  TEMPLATE.FEASTPLIDFORK3 AS \"EASTPLIDFORK3\",  \n").append("  TEMPLATE.FHasExtrItem AS HasExtrItem,  \n").append("  TEMPLATE.FTemplateSource AS \"TEMPLATESOURCE\" \n").append("   from T_RPT_Template as \"TEMPLATE\"  \n");
        easTplTableName = "TEMPLATE";
        if (isUseK3) {
            sql.append("   INNER JOIN T_RPT_Template as EAS_TPL  \n");
            sql.append("   ON (EAS_TPL.FISK3TPL = 0 AND ( ( TEMPLATE.FISK3TPL = 1 AND EAS_TPL.FID = TEMPLATE.FEASTPLIDFORK3)   \n");
            sql.append("   OR ( TEMPLATE.FISK3TPL = 0 AND EAS_TPL.FID = TEMPLATE.FID  AND   \n");
            sql.append("     NOT EXISTS (SELECT * FROM T_RPT_TEMPLATE t where EAS_TPL.FID = t.FEASTPLIDFORK3))))  \n");
            easTplTableName = "EAS_TPL";
        }
        sql.append("   inner join T_CSL_TempletDispense d on " + easTplTableName + ".fid = d.FDispenseSrcID \n").append("   INNER JOIN T_PM_User AS \"CREATOR\" ON \"TEMPLATE\".FCreatorID = \"CREATOR\".FID \n").append("   LEFT  JOIN T_PM_User AS \"AUDITOR\" ON \"TEMPLATE\".FAuditorID = \"AUDITOR\".FID \n").append("   LEFT  JOIN T_PM_User AS \"LASTUPDATEUSER\" ON \"TEMPLATE\".FLastUpdateUserID = \"LASTUPDATEUSER\".FID \n");
        sql.append("   left join ( select * from T_RPT_Template \n").append("           where   FCompanyID = ?  \n").append("           and FVersionStatus = 1  \n").append("           and (FTemplateType = 2 or FTemplateType=12 or FTemplateType=16) \t\n").append("           ) as t on TEMPLATE.fid=t.FGroupTemplateID  and d.FIsAllowChgTemplet = 1 \n");
        sql.append("   INNER JOIN T_ORG_BaseUnit AS COMPANY ON \"TEMPLATE\".FCompanyID = \"COMPANY\".FID \n").append("   where (d.FCompanyID = ?)  \n").append("   and TEMPLATE.fversionstatus = 1   \n").append("   and TEMPLATE.forgType =").append(orgType).append(" \n");
        if (periodType != -1) {
            sql.append(" and TEMPLATE.FPeriodType =").append(periodType).append(" \n");
        }
        if (templateType == null || templateType.contains((Object)RptTmpTypeEnum.GROUPCOMMREPORT)) {
            sql.append("   and (TEMPLATE.FTemplateType = 6");
        }
        if (templateType == null || templateType.contains((Object)RptTmpTypeEnum.RPTDYNAMICREPORT)) {
            if (templateType == null || templateType.contains((Object)RptTmpTypeEnum.GROUPCOMMREPORT)) {
                sql.append("  or TEMPLATE.FTemplateType=10");
            } else {
                sql.append("  and (TEMPLATE.FTemplateType=10");
            }
        }
        if (templateType == null || templateType.contains((Object)RptTmpTypeEnum.MULTIRPTDYNAMICREPORT)) {
            if (templateType == null || templateType.contains((Object)RptTmpTypeEnum.GROUPCOMMREPORT) || templateType.contains((Object)RptTmpTypeEnum.RPTDYNAMICREPORT)) {
                sql.append("  or TEMPLATE.FTemplateType=15");
            } else {
                sql.append("  and (TEMPLATE.FTemplateType=15");
            }
        }
        sql.append(") \n");
        sql.append(" and t.fid is null \n ");
        if (!isShowFreezed) {
            sql.append("   and TEMPLATE.FIsFreezed = 0 \n");
        }
        if (!includeOtherDCName.equals("") && !includeOtherDCValue.equals("")) {
            sql.append(" and TEMPLATE.FIsIncludeOtherDC =" + includeOtherDCValue);
        }
        if (!isFromNewRptUI) {
            if (isDisplayTemplateType) {
                sql.append(" and TEMPLATE.FDisplayTemplateTypeId in " + displayTemplateTypeValue);
            }
        } else {
            if (StringUtils.isEmpty((String)displayTemplateTypeValue)) {
                sql.append(" and TEMPLATE.FDisplayTemplateTypeId is null ");
            } else {
                sql.append(" and TEMPLATE.FDisplayTemplateTypeId in " + displayTemplateTypeValue);
            }
            sql.append(" and TEMPLATE.FAuditedStatus = 2 ");
        }
        if (!isUseK3) {
            sql.append(" and TEMPLATE.FIsK3Tpl = 0");
            sql.append(" and TEMPLATE.FGROUP not in( ");
            sql.append(" Select FGROUP From T_RPT_Template \n");
            sql.append(" Where FCompanyID = '" + companyID + "' And FVersionStatus = " + 1 + " ");
            sql.append(" And (FTemplateType = 2 or FTemplateType=12 or FTemplateType=16)  \n");
            sql.append(" And FTEMPLATESOURCE = 1) ");
        }
        if (tmplSet != null) {
            sql.append(" and TEMPLATE.FNumber in (SELECT FNumber FROM T_RPT_Template WHERE FID IN " + tmplSet + ") \n");
        }
        sql.append("  union all  \n").append("  SELECT \n").append("  TEMPLATE.FID AS \"TEMPLATE.ID\", \n").append("  TEMPLATE.FName AS \"TEMPLATE.NAME\",  \n").append("  TEMPLATE.FNumber AS \"TEMPLATE.NUMBER\", \n").append("  TEMPLATE.FPeriodType AS \"TEMPLATE.PERIODTYPE\", \n").append("  TEMPLATE.FTemplateType AS \"TEMPLATE.TEMPLATETYPE\",  \n").append("  TEMPLATE.FGroup AS \"TEMPLATE.GROUP\",  \n").append("  TEMPLATE.FGroupTemplateID AS \"TEMPLATE.GroupTemplateID\",  \n").append("  CREATOR.FName_" + ctx.getLocale() + " AS \"CREATOR.NAME\", \n").append("  CREATOR.FID AS \"CREATOR.ID\",   \n").append("  LASTUPDATEUSER.FName_" + ctx.getLocale() + " AS \"LASTUPDATEUSER.NAME\", \n").append("  TEMPLATE.FLastUpdateTime AS \"LASTUPDATETIME\", \n").append("  AUDITOR.FName_" + ctx.getLocale() + " AS \"AUDITOR.NAME\",  \n").append("  AUDITOR.FID AS \"AUDITOR.ID\",        \n").append("  TEMPLATE.FVersionNumber AS \"VERSIONNUMBER\",   \n").append("  TEMPLATE.FIsIncludeOtherDC AS \"INCLUDEOTHERDC\", \n").append("  TEMPLATE.FCanClosePeriod AS \"CANCLOSEPERIOD\", \n").append("  TEMPLATE.FCheckOpenPeriod AS \"CHECKOPENPERIOD\", \n").append("  TEMPLATE.FAuditedStatus AS \"AUDITEDSTATUS\",   \n").append("  TEMPLATE.FPublishedStatus AS \"PUBLISHEDSTATUS\",  \n").append("  TEMPLATE.FDescription AS \"FDescription\", \n").append("  COMPANY.FLongNumber AS \"COMPANY.LONGNUMBER\",  \n").append("  Template.FCreateTime AS \"CreateTime\", \n").append("  COMPANY.FID AS \"COMPANY.ID\",      \n").append("  COMPANY.FName").append(language).append(" AS \"COMPANY.NAME\",  \n").append("  d.FSourceType AS \"TEMPLETDISPENSE.SOURCETYPE\", \n ").append("  case when d.FIsAllowChgTemplet = 1 then d.FIsAllowChgTemplet else dispense.FISALLOWCHGTEMPLATE end AS \"ISALLOWCHANGE\" , \n").append("  TEMPLATE.GU AS \"ISGROUP\" , \n").append("  TEMPLATE.FISK3TPL AS \"ISK3TPL\",  \n").append("  TEMPLATE.FEASTPLIDFORK3 AS \"EASTPLIDFORK3\",  \n").append("  TEMPLATE.FHasExtrItem AS HasExtrItem,  \n").append("  TEMPLATE.FTemplateSource AS \"TEMPLATESOURCE\" \n").append("   from T_RPT_Template TEMPLATE \n");
        easTplTableName = "TEMPLATE";
        if (isUseK3) {
            sql.append("   INNER JOIN T_RPT_Template as EAS_TPL  \n");
            sql.append("   ON (EAS_TPL.FISK3TPL = 0 AND ( ( TEMPLATE.FISK3TPL = 1 AND EAS_TPL.FID = TEMPLATE.FEASTPLIDFORK3)   \n");
            sql.append("   OR ( TEMPLATE.FISK3TPL = 0 AND EAS_TPL.FID = TEMPLATE.FID  AND   \n");
            sql.append("     NOT EXISTS (SELECT * FROM T_RPT_TEMPLATE t where (EAS_TPL.FID = t.FEASTPLIDFORK3 OR EAS_TPL.FGROUPTEMPLATEID = T.FEASTPLIDFORK3 )))))  \n");
            easTplTableName = "EAS_TPL";
            sql.append("   inner join T_RPT_Template t2 on " + easTplTableName + ".FGroup = t2.FGroup \n");
            sql.append("   inner join T_CSL_TempletDispense d on t2.fid = d.FDispenseSrcID  \n");
        } else {
            sql.append("   inner join T_CSL_TempletDispense d ");
            sql.append("   on TEMPLATE.FGroupTemplateID = d.FDispenseSrcID  \n");
            sql.append(" left join T_CSL_FormulaSolu solu on TEMPLATE.FGROUP = solu.FTEMPLATEGROUPID \n");
            sql.append(" left Join T_Csl_FormulaSoluDispense dispense on dispense.FFormulaSoluId=solu.fid and dispense.FCOMPANYID = '" + companyID + "' \n");
        }
        sql.append("   INNER JOIN T_PM_User AS CREATOR ON \"TEMPLATE\".FCreatorID = \"CREATOR\".FID \n").append("   LEFT  JOIN T_PM_User AS \"AUDITOR\" ON \"TEMPLATE\".FAuditorID = \"AUDITOR\".FID \n").append("   LEFT  JOIN T_PM_User AS \"LASTUPDATEUSER\" ON \"TEMPLATE\".FLastUpdateUserID = \"LASTUPDATEUSER\".FID \n").append("   INNER JOIN T_ORG_BaseUnit AS COMPANY ON \"TEMPLATE\".FCompanyID = \"COMPANY\".FID \n").append("   where TEMPLATE.fcompanyid = ?  \n").append("   and TEMPLATE.forgType =").append(orgType).append(" \n").append("   and d.fcompanyid = ?  \n");
        if (periodType != -1) {
            sql.append(" and TEMPLATE.FPeriodType =").append(periodType).append(" \n");
        }
        if (!isUseK3) {
            sql.append(" and (d.FIsAllowChgTemplet = ? or dispense.FISALLOWCHGTEMPLATE = 1)");
        } else {
            sql.append(" and d.FIsAllowChgTemplet = ?  \n");
        }
        if (!isShowFreezed) {
            sql.append("   and TEMPLATE.FIsFreezed = 0 ");
            if (isUseK3) {
                sql.append(" and t2.FIsFreezed = 0 \n");
            }
        }
        if (templateType == null || templateType.contains((Object)RptTmpTypeEnum.GROUPCOMMREPORT)) {
            sql.append("   and (TEMPLATE.FTemplateType = 2");
        }
        if (templateType == null || templateType.contains((Object)RptTmpTypeEnum.RPTDYNAMICREPORT)) {
            if (templateType == null || templateType.contains((Object)RptTmpTypeEnum.GROUPCOMMREPORT)) {
                sql.append("  or TEMPLATE.FTemplateType=12");
            } else {
                sql.append("  and (TEMPLATE.FTemplateType=12");
            }
        }
        if (templateType == null || templateType.contains((Object)RptTmpTypeEnum.MULTIRPTDYNAMICREPORT)) {
            if (templateType == null || templateType.contains((Object)RptTmpTypeEnum.GROUPCOMMREPORT) || templateType.contains((Object)RptTmpTypeEnum.RPTDYNAMICREPORT)) {
                sql.append("  or TEMPLATE.FTemplateType=16");
            } else {
                sql.append("  and (TEMPLATE.FTemplateType=16");
            }
        }
        sql.append(") \n");
        if (!isFromNewRptUI) {
            if (isDisplayTemplateType) {
                sql.append(" and TEMPLATE.FDisplayTemplateTypeId in " + displayTemplateTypeValue);
            }
        } else {
            if (StringUtils.isEmpty((String)displayTemplateTypeValue)) {
                sql.append(" and TEMPLATE.FDisplayTemplateTypeId is null ");
            } else {
                sql.append(" and TEMPLATE.FDisplayTemplateTypeId in " + displayTemplateTypeValue);
            }
            sql.append(" and TEMPLATE.FAuditedStatus = 2 ");
        }
        if (isRemovePublished) {
            sql.append(" AND TEMPLATE.FPublishedStatus = 1");
        }
        if (isOnlyUnversion) {
            sql.append("\n AND TEMPLATE.FVERSIONSTATUS = 1");
        } else {
            sql.append("\n AND TEMPLATE.FVERSIONSTATUS <= 1");
        }
        if (!includeOtherDCName.equals("") && !includeOtherDCValue.equals("")) {
            sql.append(" and TEMPLATE.FIsIncludeOtherDC =" + includeOtherDCValue);
        }
        if (!isUseK3) {
            sql.append(" and TEMPLATE.FIsK3Tpl = 0");
        }
        if (tmplSet != null) {
            sql.append(" and TEMPLATE.FNumber in (SELECT FNumber FROM T_RPT_Template WHERE FID IN " + tmplSet + ") \n");
        }
        sql.append(" ) AS tt      \n ");
        if (!StringUtils.isEmpty((String)dataRule) && !StringUtils.isEmpty((String)permissionCondition)) {
            buffer = new StringBuffer();
            buffer.append("SELECT * FROM (").append(sql).append(") AS tb WHERE tb.\"TEMPLATE.ID\" ").append(permissionCondition);
            sql = buffer;
        }
        sortBuf = new StringBuffer();
        if (view != null) {
            sorter = view.getSorter();
            first = true;
            ** if (sorter == null || sorter.size() <= 0) goto lbl340
            for (j = 0; j < sorter.size(); ++j) {
                info = sorter.get(j);
                pTemp = p = info.getPropertyName();
                if (permissionCondition != null) {
                    if (p.equals("Template.templateType")) {
                        p = "tb.\"TEMPLATE.TEMPLATETYPE\"";
                    }
                    if (p.equals("Template.number")) {
                        p = "tb.\"TEMPLATE.NUMBER\"";
                    }
                    if (p.equals("Template.name")) {
                        p = "tb.\"TEMPLATE.NAME\"";
                    }
                    if (p.equals("Template.periodType")) {
                        p = "tb.\"TEMPLATE.PERIODTYPE\"";
                    }
                    if (p.equals("lastUpdateUser.name")) {
                        p = "tb.\"LASTUPDATEUSER.NAME\"";
                    }
                    if (p.equals("lastUpdateTime")) {
                        p = "tb.\"LASTUPDATETIME\"";
                    }
                    if (p.equals("publishedStatus")) {
                        p = "tb.\"PUBLISHEDSTATUS\"";
                    }
                    if (p.equals("auditedStatus")) {
                        p = "tb.\"AUDITEDSTATUS\"";
                    }
                    if (p.equals("auditor.name")) {
                        p = "tb.\"AUDITOR.NAME\"";
                    }
                    if (p.equals("versionNumber")) {
                        p = "tb.\"VERSIONNUMBER\"";
                    }
                    if (p.equals("templateSource")) {
                        p = "tb.\"TEMPLATESOURCE\"";
                    }
                    if (p.equals("includeOtherDC")) {
                        p = "tb.\"INCLUDEOTHERDC\"";
                    }
                    if (p.equals("canClosePeriod")) {
                        p = "tb.\"CANCLOSEPERIOD\"";
                    }
                    if (p.equals("checkOpenPeriod")) {
                        p = "tb.\"CHECKOPENPERIOD\"";
                    }
                    if (p.equals("isAllowChange")) {
                        p = "tb.\"ISALLOWCHANGE\"";
                    }
                    if (p.equals("creator.name")) {
                        p = "tb.\"CREATOR.NAME\"";
                    }
                    if (p.equals("createTime")) {
                        p = "tb.\"CreateTime\"";
                    }
                    if (p.equals("isGroup")) {
                        p = "tb.\"ISGROUP\"";
                    }
                    if (p.equals("company.name")) {
                        p = "tb.\"COMPANY.NAME\"";
                    }
                } else {
                    if (p.equals("Template.templateType")) {
                        p = "tt.\"TEMPLATE.TEMPLATETYPE\"";
                    }
                    if (p.equals("Template.number")) {
                        p = "tt.\"TEMPLATE.NUMBER\"";
                    }
                    if (p.equals("Template.name")) {
                        p = "tt.\"TEMPLATE.NAME\"";
                    }
                    if (p.equals("Template.periodType")) {
                        p = "tt.\"TEMPLATE.PERIODTYPE\"";
                    }
                    if (p.equals("lastUpdateUser.name")) {
                        p = "tt.\"LASTUPDATEUSER.NAME\"";
                    }
                    if (p.equals("lastUpdateTime")) {
                        p = "tt.\"LASTUPDATETIME\"";
                    }
                    if (p.equals("publishedStatus")) {
                        p = "tt.\"PUBLISHEDSTATUS\"";
                    }
                    if (p.equals("auditedStatus")) {
                        p = "tt.\"AUDITEDSTATUS\"";
                    }
                    if (p.equals("auditor.name")) {
                        p = "tt.\"AUDITOR.NAME\"";
                    }
                    if (p.equals("versionNumber")) {
                        p = "tt.\"VERSIONNUMBER\"";
                    }
                    if (p.equals("templateSource")) {
                        p = "tt.\"TEMPLATESOURCE\"";
                    }
                    if (p.equals("includeOtherDC")) {
                        p = "tt.\"INCLUDEOTHERDC\"";
                    }
                    if (p.equals("canClosePeriod")) {
                        p = "tt.\"CANCLOSEPERIOD\"";
                    }
                    if (p.equals("checkOpenPeriod")) {
                        p = "tb.\"CHECKOPENPERIOD\"";
                    }
                    if (p.equals("isAllowChange")) {
                        p = "tt.\"ISALLOWCHANGE\"";
                    }
                    if (p.equals("creator.name")) {
                        p = "tt.\"CREATOR.NAME\"";
                    }
                    if (p.equals("createTime")) {
                        p = "tt.\"CreateTime\"";
                    }
                    if (p.equals("isGroup")) {
                        p = "tt.\"ISGROUP\"";
                    }
                    if (p.equals("company.name")) {
                        p = "tt.\"COMPANY.NAME\"";
                    }
                }
                if (pTemp == p) continue;
                if (!first) {
                    sortBuf.append(", ");
                } else {
                    sortBuf.append(" ORDER BY ");
                    first = false;
                }
                sortBuf.append(p).append(" ").append(info.getSortType());
lbl-1000:
                // 2 sources

                {
                    continue;
                }
            }
        }
lbl340:
        // 4 sources

        if (sortBuf.length() > 0) {
            sql.append(sortBuf);
        } else if (permissionCondition != null) {
            sql.append(" order by tb.\"TEMPLATE.NUMBER\", tb.\"TEMPLATESOURCE\" , tb.\"VERSIONNUMBER\"   \n ");
        } else {
            sql.append(" order by tt.\"TEMPLATE.NUMBER\", tt.\"TEMPLATESOURCE\", tt.\"VERSIONNUMBER\"   \n ");
        }
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID, companyID, companyID, companyID, new Integer(1)});
    }

    @Override
    protected TemplateCollection _getTreeDispenseData2(Context ctx, String companyID, boolean isRemovePublished, boolean isOnlyUnversion, boolean isShowFreezed, List templateType, EntityViewInfo view) throws BOSException, EASBizException {
        IRowSet set = this._getTreeDispenseData(ctx, companyID, isRemovePublished, isOnlyUnversion, isShowFreezed, templateType, view);
        TemplateCollection c = new TemplateCollection();
        if (set != null) {
            try {
                while (set.next()) {
                    TemplateInfo info = new TemplateInfo();
                    info.setId(BOSUuid.read((String)set.getString("TEMPLATE.ID")));
                    info.setNumber(set.getString("TEMPLATE.NUMBER"));
                    info.setName(set.getString("TEMPLATE.NAME"));
                    info.setTemplateType(RptTmpTypeEnum.getEnum(set.getInt("TEMPLATE.TEMPLATETYPE")));
                    info.setVersionNumber(set.getString("VERSIONNUMBER"));
                    info.setTemplateSource(TemplateSourceEnum.getEnum(set.getInt("TEMPLATESOURCE")));
                    info.setPeriodType(RptPeriodTypeEnum.getEnum((int)set.getInt("TEMPLATE.PERIODTYPE")));
                    info.setDescription(set.getString("FDescription"));
                    info.setGroup(set.getString("TEMPLATE.GROUP"));
                    info.setIsAllowSubCompanyModify(set.getBoolean("ISALLOWCHANGE"));
                    String grpTmplID = set.getString("TEMPLATE.GROUPTEMPLATEID");
                    if (!StringUtils.isEmpty((String)grpTmplID)) {
                        TemplateInfo grpTmpl = new TemplateInfo();
                        grpTmpl.setId(BOSUuid.read((String)grpTmplID));
                        info.setGroupTemplate(grpTmpl);
                    }
                    info.setIsK3Tpl(set.getBoolean("ISK3TPL"));
                    info.setEasTplIdForK3(set.getString("EASTPLIDFORK3"));
                    String companyid = set.getString("COMPANY.ID");
                    String companyName = set.getString("COMPANY.NAME");
                    CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                    company.setId(BOSUuid.read((String)companyid));
                    company.setName(companyName);
                    info.setCompany(company);
                    FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
                    fullOrgUnitInfo.setId(BOSUuid.read((String)companyid));
                    fullOrgUnitInfo.setName(companyName);
                    info.setCompany(fullOrgUnitInfo);
                    c.add(info);
                }
            }
            catch (SQLException e) {
                throw new BOSException("ROWSET EXCEPTION ", (Throwable)e);
            }
        }
        return c;
    }

    @Override
    protected void _updateMaintainCU(Context ctx, String templateId, String cuId) throws BOSException, EASBizException {
        String sql = "update t_rpt_template set FMaintainCUId = ? where FId = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{cuId, templateId});
    }

    @Override
    protected int _setCanCloseOrCheckOpenPeriod(Context ctx, Map templateIdsAndStates) throws BOSException, EASBizException {
        if (templateIdsAndStates.containsKey("isEditUI")) {
            templateIdsAndStates.remove("isEditUI");
            boolean isOpenPeriod = false;
            if (templateIdsAndStates.containsKey("isOpenPeriod")) {
                isOpenPeriod = (Boolean)templateIdsAndStates.get("isOpenPeriod");
                templateIdsAndStates.remove("isOpenPeriod");
            }
            StringBuffer sql = new StringBuffer();
            sql.append(" update t_rpt_template set ");
            sql.append(" FCheckOpenPeriod=? ");
            sql.append(" where fid in (");
            sql.append(" select t1.fid from t_rpt_template t1 ");
            sql.append(" inner join t_rpt_template t2 on t1.fgroup = t2.fgroup ");
            sql.append(" where t2.FId = ? ");
            sql.append(" and (TO_NUMBER(SubString(t1.fversionNumber, 1, CharIndex('.', t1.fversionNumber)-1)))");
            sql.append("   <= TO_NUMBER(t2.fversionNumber) ");
            sql.append(" ) ");
            Iterator it = templateIdsAndStates.keySet().iterator();
            String id = null;
            int state = 0;
            if (it.hasNext()) {
                id = (String)it.next();
                state = (Boolean)templateIdsAndStates.get(id) != false ? 1 : 0;
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{isOpenPeriod ? 1 : 0, id});
            }
            sql = new StringBuffer();
            sql.append(" update t_rpt_template set ");
            sql.append(" FCanClosePeriod=? ");
            sql.append(" where fid in (");
            sql.append(" select t1.fid from t_rpt_template t1 ");
            sql.append(" inner join t_rpt_template t2 on t1.fgroup = t2.fgroup ");
            sql.append(" where t2.FId = ? ");
            sql.append(" and (TO_NUMBER(SubString(t1.fversionNumber, 1, CharIndex('.', t1.fversionNumber)-1)))");
            sql.append("   <= TO_NUMBER(t2.fversionNumber) ");
            sql.append(" ) ");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{state, id});
            return 1;
        }
        boolean isOpenPeriod = false;
        if (templateIdsAndStates.containsKey("isOpenPeriod")) {
            isOpenPeriod = (Boolean)templateIdsAndStates.get("isOpenPeriod");
            templateIdsAndStates.remove("isOpenPeriod");
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" update t_rpt_template set ");
        sql.append(isOpenPeriod ? " FCheckOpenPeriod=? " : " FCanClosePeriod=? ");
        sql.append(" where fid in (");
        sql.append(" select t1.fid from t_rpt_template t1 ");
        sql.append(" inner join t_rpt_template t2 on t1.fgroup = t2.fgroup ");
        sql.append(" where t2.FId = ? ");
        sql.append(" and (TO_NUMBER(SubString(t1.fversionNumber, 1, CharIndex('.', t1.fversionNumber)-1)))");
        sql.append("   <= TO_NUMBER(t2.fversionNumber) ");
        sql.append(" ) ");
        Connection conn = this.getConnection(ctx);
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(sql.toString());
            Iterator it = templateIdsAndStates.keySet().iterator();
            String pk = null;
            int state = 0;
            int count = 0;
            while (it.hasNext()) {
                pk = (String)it.next();
                state = (Boolean)templateIdsAndStates.get(pk) != false ? 1 : 0;
                stmt.setInt(1, state);
                stmt.setString(2, pk);
                stmt.addBatch();
                ++count;
            }
            stmt.executeBatch();
            int n = count;
            return n;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        }
    }

    @Override
    protected List _checkPublicTemplateQuoted(Context ctx, String templateID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String language = "_" + ctx.getLocale().getLanguage();
        sql.append("select Company.FName").append(language).append(" as CompanyName,template.FVersionNumber as Source,1 as SourceType\t\n");
        sql.append("from T_RPT_Template template\t\t\n");
        sql.append("inner join T_ORG_Company company on template.FCompanyID = company.fid\t\n");
        sql.append("where exists (\t\t\t\t\t\t\t\n");
        sql.append("\tselect * from T_RPT_Template tmp \t\n");
        sql.append("\twhere tmp.FGroup = template.FGroup\t\n");
        sql.append("\tand tmp.FGroupTemplateID = ?\t\t\t\t\t\t\n");
        sql.append("\tand template.FID <> ?\t\t\t\t\n");
        sql.append("\tand charindex(Left(tmp.FVersionNumber,Len(tmp.FVersionNumber)-1),template.FVersionNumber)=1\t\t\n");
        sql.append(")\t\t\n");
        sql.append("union all\t\t\t\t\t\t\t\t\n");
        sql.append("select Company.FName").append(language).append(" as CompanyName,report.FName as Source,2 as SourceType\t\n");
        sql.append("from T_RPT_Report report\t\n");
        sql.append("inner join T_ORG_Company company on report.FCompanyID = company.FID\t\n");
        sql.append("where report.FTemplateID = ? \n");
        Object[] params = new Object[]{templateID, templateID, templateID};
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        ArrayList result = new ArrayList();
        try {
            while (row.next()) {
                HashMap<String, Object> entry = new HashMap<String, Object>();
                entry.put("CompanyName", row.getString("CompanyName"));
                entry.put("SourceType", (Object)ReportTypeEnum.getEnum(row.getInt("SourceType")));
                entry.put("Source", row.getString("Source"));
                result.add(entry);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    @Override
    protected TemplateCollection _getPublicTemplateCollection(Context ctx, List versionList, boolean isShowUnPublish, boolean isShowUnAudit, SorterItemCollection sorter) throws BOSException, EASBizException {
        String companyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        IRowSet rowSet = this._getRowSetForPublicTemplate(ctx, companyID, versionList, isShowUnPublish, isShowUnAudit, sorter);
        TemplateCollection result = new TemplateCollection();
        try {
            while (rowSet.next()) {
                TemplateInfo info = new TemplateInfo();
                info.setId(BOSUuid.read((String)rowSet.getString("TEMPLATE.ID")));
                info.setName(rowSet.getString("TEMPLATE.NAME"));
                info.setNumber(rowSet.getString("TEMPLATE.NUMBER"));
                info.setDescription(rowSet.getString("FDescription"));
                info.setPeriodType(RptPeriodTypeEnum.getEnum((int)rowSet.getInt("TEMPLATE.PERIODTYPE")));
                info.setTemplateType(RptTmpTypeEnum.getEnum(rowSet.getInt("TEMPLATE.TEMPLATETYPE")));
                info.setVersionNumber(rowSet.getString("VERSIONNUMBER"));
                info.setAuditedStatus(AuditedStatusEnum.getEnum(rowSet.getInt("AUDITEDSTATUS")));
                info.setPublishedStatus(PublishedStatusEnum.getEnum(rowSet.getInt("PUBLISHEDSTATUS")));
                result.add(info);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    @Override
    protected IRowSet _getRowSetForPublicTemplate(Context ctx, String companyID, List versionTypeList, boolean isShowUnpublish, boolean isShowUnaudit, SorterItemCollection sorter) throws BOSException, EASBizException {
        int orgType = this.decodeOrgType(versionTypeList);
        int periodType = this.decodePeriodType(versionTypeList);
        Map superNewestTemplateIDs = this.getNewestSuperPublicTemplate(ctx, companyID);
        TemplateCollection templateCollection = this.getCurrentCompanyPublicTemplate(ctx, companyID, versionTypeList, isShowUnpublish, isShowUnaudit);
        Set ids = this.getIDsForPublicTemplate(ctx, templateCollection, superNewestTemplateIDs);
        StringBuffer sql = new StringBuffer();
        ArrayList params = new ArrayList();
        String language = "_" + ctx.getLocale().getLanguage();
        sql.append("  select DISTINCT * from ( \n").append("  SELECT    \n").append("  TEMPLATE.FID AS \"TEMPLATE.ID\",  \n").append("  TEMPLATE.FName AS \"TEMPLATE.NAME\",  \n").append("  TEMPLATE.FNumber AS \"TEMPLATE.NUMBER\",  \n").append("  TEMPLATE.FPeriodType AS \"TEMPLATE.PERIODTYPE\", \n").append(" TEMPLATE.FDescription AS \"FDescription\", \n").append("  TEMPLATE.FTemplateType AS \"TEMPLATE.TEMPLATETYPE\", \n").append("  TEMPLATE.FGroup AS \"TEMPLATE.GROUP\", \n").append("  TEMPLATE.FORGTYPE AS \"TEMPLATE.FORGTYPE\", \n").append("  CREATOR.FName").append(language).append(" AS \"CREATOR.NAME\", \n").append("  CREATOR.FID AS \"CREATOR.ID\", \n").append("  LASTUPDATEUSER.FName").append(language).append(" AS \"LASTUPDATEUSER.NAME\", \n").append("  TEMPLATE.FLastUpdateTime AS \"LASTUPDATETIME\", \n").append("  AUDITOR.FName").append(language).append(" AS \"AUDITOR.NAME\", \n").append("  AUDITOR.FID AS \"AUDITOR.ID\", \n").append("  TEMPLATE.FVersionNumber AS \"VERSIONNUMBER\", \n").append("  TEMPLATE.FCanClosePeriod AS \"CANCLOSEPERIOD\", \n").append("  TEMPLATE.FCheckOpenPeriod AS \"CHECKOPENPERIOD\", \n").append("  TEMPLATE.FAuditedStatus AS \"AUDITEDSTATUS\", \n").append("  TEMPLATE.FPublishedStatus AS \"PUBLISHEDSTATUS\", \n").append("  COMPANY.FLongNumber AS \"COMPANY.LONGNUMBER\", \n").append("  Template.FCreateTime AS \"CreateTime\",  \n").append("  COMPANY.FID AS \"COMPANY.ID\",  \n").append("  COMPANY.FName").append(language).append(" AS \"COMPANY.NAME\",  \n").append("  GROUPCOMPANY.FName").append(language).append(" AS \"GROUPCOMPANY.NAME\",\t\t\n").append("  TEMPLATE.FIsAllowSubCompanyModify AS \"isAllowSubCompanyModify\",  \n").append("  '' AS \"TEMPLETDISPENSE.SOURCETYPE\",  \n").append("  TEMPLATE.FIsAllowSubCompanyModify AS \"ISALLOWCHANGE\"  \n").append("  ,TEMPLATE.FHasExtrItem hasExtrItem  \n").append("  FROM T_RPT_Template as TEMPLATE  \n").append("  INNER JOIN T_PM_User AS CREATOR ON TEMPLATE.FCreatorID = CREATOR.FID \n").append("  LEFT  JOIN T_PM_User AS AUDITOR ON TEMPLATE.FAuditorID = AUDITOR.FID \n").append("  LEFT  JOIN T_PM_User AS LASTUPDATEUSER ON TEMPLATE.FLastUpdateUserID = LASTUPDATEUSER.FID \n").append("  INNER JOIN T_ORG_Company AS COMPANY ON TEMPLATE.FCompanyID = COMPANY.FID \n").append("  LEFT  JOIN T_ORG_Company AS GROUPCOMPANY ON TEMPLATE.FGroupCompanyID = GROUPCOMPANY.FID \n");
        if (ids != null && ids.size() > 0) {
            sql.append("   WHERE TEMPLATE.FID IN ");
            sql.append(RptUtilForServer.createInSql(ids.iterator(), params));
            sql.append(" AND TEMPLATE.FORGTYPE=").append(orgType).append(" ");
            if (periodType != -1) {
                sql.append(" And TEMPLATE.FPeriodType =").append(periodType).append(" ");
            }
            ObjectUuidPK currentUserPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
            String dataRule = RptUtilForServer.getCommonDataRule(ctx, (IObjectPK)currentUserPK, (IObjectPK)new ObjectUuidPK(companyID), "rpt_template_view");
            String permissionCondition = null;
            if (!StringUtils.isEmpty((String)dataRule)) {
                try {
                    permissionCondition = PermissionFactory.getLocalInstance((Context)ctx).getQueryPermissionSQL((IObjectPK)currentUserPK, (IObjectPK)new ObjectUuidPK(companyID), "rpt_template_view");
                    permissionCondition = "IN (" + permissionCondition + ")";
                }
                catch (EASBizException e1) {
                    logger.error((Object)e1.getStackTrace(), (Throwable)e1);
                }
            }
            if (!StringUtils.isEmpty((String)dataRule) && !StringUtils.isEmpty(permissionCondition)) {
                sql.append("AND TEMPLATE.FID " + permissionCondition + "\n");
            }
        } else {
            sql.append("  WHERE 1=2 ");
        }
        sql.append(") AS tt \t\n");
        StringBuffer sortBuf = new StringBuffer();
        if (sorter != null && sorter != null && sorter.size() > 0) {
            for (int j = 0; j < sorter.size(); ++j) {
                SorterItemInfo info = sorter.get(j);
                String p = info.getPropertyName();
                if (p.equalsIgnoreCase("includeOtherDC")) continue;
                if (j > 0) {
                    sortBuf.append(", ");
                } else {
                    sortBuf.append(" ORDER BY ");
                }
                if (p.equals("Template.templateType")) {
                    p = "tt.\"TEMPLATE.TEMPLATETYPE\"";
                }
                if (p.equals("Template.number")) {
                    p = "tt.\"TEMPLATE.NUMBER\"";
                }
                if (p.equals("Template.name")) {
                    p = "tt.\"TEMPLATE.NAME\"";
                }
                if (p.equals("Template.periodType")) {
                    p = "tt.\"TEMPLATE.PERIODTYPE\"";
                }
                if (p.equals("lastUpdateUser.name")) {
                    p = "tt.\"LASTUPDATEUSER.NAME\"";
                }
                if (p.equals("lastUpdateTime")) {
                    p = "tt.\"LASTUPDATETIME\"";
                }
                if (p.equals("publishedStatus")) {
                    p = "tt.\"PUBLISHEDSTATUS\"";
                }
                if (p.equals("auditedStatus")) {
                    p = "tt.\"AUDITEDSTATUS\"";
                }
                if (p.equals("auditor.name")) {
                    p = "tt.\"AUDITOR.NAME\"";
                }
                if (p.equals("versionNumber")) {
                    p = "tt.\"VERSIONNUMBER\"";
                }
                if (p.equals("canClosePeriod")) {
                    p = "tt.\"CANCLOSEPERIOD\"";
                }
                if (p.equals("CheckOpenPeriod")) {
                    p = "tt.\"CHECKOPENPERIOD\"";
                }
                if (p.equals("isAllowChange")) {
                    p = "tt.\"ISALLOWCHANGE\"";
                }
                if (p.equals("creator.name")) {
                    p = "tt.\"CREATOR.NAME\"";
                }
                if (p.equals("createTime")) {
                    p = "tt.\"CreateTime\"";
                }
                if (p.equals("isGroup")) {
                    p = "tt.\"PUBLISHEDSTATUS\"";
                }
                if (p.equals("company.name")) {
                    p = "tt.\"COMPANY.NAME\"";
                }
                if (p.equals("groupCompany.name")) {
                    p = "tt.\"GROUPCOMPANY.NAME\"";
                }
                sortBuf.append(p).append(" ").append(info.getSortType());
            }
        }
        if (sortBuf.length() > 0) {
            sql.append(sortBuf);
        } else {
            sql.append(" order by tt.\"TEMPLATE.NUMBER\", tt.\"VERSIONNUMBER\"   \n ");
        }
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
    }

    @Override
    protected Set _getSuperCompanyIDs(Context ctx) throws BOSException {
        List companyList = RptUtilForServer.getSuperCompanyIDs(ctx, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString());
        return new HashSet(companyList);
    }

    @Override
    protected boolean _isPublicTemplateNeedVersioning(Context ctx, String templateID, String currenctCompanyID) throws BOSException, EASBizException {
        TemplateInfo info = TemplateFactory.getLocalInstance(ctx).getTemplateInfo((IObjectPK)new ObjectStringPK(templateID));
        if (!info.getCompany().getId().toString().equals(currenctCompanyID) && !info.isIsAllowSubCompanyModify()) {
            throw new PublicTemplateException(PublicTemplateException.NOT_ALLOWED_MODIFY);
        }
        if (PublishedStatusEnum.PUBLISHED.equals((Object)info.getPublishedStatus())) {
            throw new PublicTemplateException(PublicTemplateException.PUBLISHED);
        }
        boolean isLastestVersion = this.isCompanyLastestVersion(ctx, info.getId().toString(), false, false, currenctCompanyID, info);
        if (!isLastestVersion) {
            throw new PublicTemplateException(PublicTemplateException.TEMPLATE_NOT_LASTVERSION);
        }
        if (info.getCompany().getId().toString().equals(currenctCompanyID) && AuditedStatusEnum.UNAUDITED.equals((Object)info.getAuditedStatus())) {
            return false;
        }
        List quoteResultList = this._checkPublicTemplateQuoted(ctx, templateID);
        if (quoteResultList != null && quoteResultList.size() > 0) {
            String detail = this.buildQuetedPublicTemplateMsg(info, quoteResultList, ctx);
            throw new PublicTemplateException(PublicTemplateException.TEMPLATE_QUOTED, new Exception(detail));
        }
        if (info.getCompany().getId().toString().equals(currenctCompanyID) && AuditedStatusEnum.AUDITED.equals((Object)info.getAuditedStatus())) {
            throw new PublicTemplateException(PublicTemplateException.NEEDUN_AUDIT_FIRST);
        }
        if (AuditedStatusEnum.AUDITED.equals((Object)info.getAuditedStatus())) {
            throw new PublicTemplateException(PublicTemplateException.TEMPLATE_AUDITED);
        }
        return true;
    }

    protected IRowSet getTreeDispenseDataNew(Context ctx, String companyID, boolean isRemovePublished, boolean isOnlyUnversion, boolean isShowFreezed, List templateType, EntityViewInfo view) throws BOSException, EASBizException {
        String sortField;
        ConditionWrappedInfo condition = new ConditionWrappedInfo();
        condition.setRemovePublished(isRemovePublished);
        condition.setShowFreezed(isShowFreezed);
        condition.setOnlyUnversion(isOnlyUnversion);
        condition.setOrgType(this.decodeOrgType(templateType));
        condition.setTemplateType(templateType);
        this.handleFilterItemInfo(ctx, view, condition);
        if (companyID == null) {
            companyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        }
        condition.setCompanyID(companyID);
        boolean isUseK3 = AccountORMFactory.getLocalInstance(ctx).isLockByCompany((IObjectPK)new ObjectUuidPK(companyID));
        condition.setUseK3(isUseK3);
        this.handlePermissionCondition(ctx, condition);
        String language = ctx.getLocale().getLanguage();
        condition.setLanguage(language);
        TemplateControllerBean.createDispenseTemplateRecordTable(ctx, condition);
        StringBuffer sql = new StringBuffer(5000);
        sql.append(" Select Distinct * from ( \n");
        sql.append(TemplateControllerBean.builderGroupTmplSQL(condition));
        sql.append(" Union All ");
        sql.append(TemplateControllerBean.builderSubTmplSQL(condition));
        sql.append(" ) AS tt      \n ");
        if (!StringUtils.isEmpty((String)condition.getDataRule()) && !StringUtils.isEmpty((String)condition.getPermissionCondition())) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT * FROM (").append(sql).append(") AS tb WHERE tb.\"TEMPLATE.ID\" ").append(condition.getPermissionCondition());
            sql = buffer;
        }
        if (!StringUtils.isEmpty((String)(sortField = this.convertSortField(view, condition)))) {
            sql.append(sortField);
        } else if (condition.getPermissionCondition() != null) {
            sql.append(" order by tb.\"TEMPLATE.NUMBER\", tb.\"VERSIONNUMBER\"   \n ");
        } else {
            sql.append(" order by tt.\"TEMPLATE.NUMBER\", tt.\"VERSIONNUMBER\"   \n ");
        }
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (!StringUtils.isEmpty((String)condition.getDispTmplTable())) {
                TempTablePool.getInstance((Context)ctx).releaseTable(condition.getDispTmplTable());
            }
        }
        return rs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String convertSortField(EntityViewInfo view, ConditionWrappedInfo condition) {
        StringBuffer sortBuf = new StringBuffer();
        if (view == null) return sortBuf.toString();
        SorterItemCollection sorter = view.getSorter();
        boolean first = true;
        if (sorter == null) return sortBuf.toString();
        if (sorter.size() <= 0) return sortBuf.toString();
        for (int j = 0; j < sorter.size(); ++j) {
            String p;
            SorterItemInfo info = sorter.get(j);
            String pTemp = p = info.getPropertyName();
            if (condition.getPermissionCondition() != null) {
                if (p.equals("Template.templateType")) {
                    p = "tb.\"TEMPLATE.TEMPLATETYPE\"";
                }
                if (p.equals("Template.number")) {
                    p = "tb.\"TEMPLATE.NUMBER\"";
                }
                if (p.equals("Template.name")) {
                    p = "tb.\"TEMPLATE.NAME\"";
                }
                if (p.equals("Template.periodType")) {
                    p = "tb.\"TEMPLATE.PERIODTYPE\"";
                }
                if (p.equals("lastUpdateUser.name")) {
                    p = "tb.\"LASTUPDATEUSER.NAME\"";
                }
                if (p.equals("lastUpdateTime")) {
                    p = "tb.\"LASTUPDATETIME\"";
                }
                if (p.equals("publishedStatus")) {
                    p = "tb.\"PUBLISHEDSTATUS\"";
                }
                if (p.equals("auditedStatus")) {
                    p = "tb.\"AUDITEDSTATUS\"";
                }
                if (p.equals("auditor.name")) {
                    p = "tb.\"AUDITOR.NAME\"";
                }
                if (p.equals("versionNumber")) {
                    p = "tb.\"VERSIONNUMBER\"";
                }
                if (p.equals("includeOtherDC")) {
                    p = "tb.\"INCLUDEOTHERDC\"";
                }
                if (p.equals("canClosePeriod")) {
                    p = "tb.\"CANCLOSEPERIOD\"";
                }
                if (p.equals("checkOpenPeriod")) {
                    p = "tb.\"CHECKOPENPERIOD\"";
                }
                if (p.equals("isAllowChange")) {
                    p = "tb.\"ISALLOWCHANGE\"";
                }
                if (p.equals("creator.name")) {
                    p = "tb.\"CREATOR.NAME\"";
                }
                if (p.equals("createTime")) {
                    p = "tb.\"CreateTime\"";
                }
                if (p.equals("isGroup")) {
                    p = "tb.\"ISGROUP\"";
                }
                if (p.equals("company.name")) {
                    p = "tb.\"COMPANY.NAME\"";
                }
            } else {
                if (p.equals("Template.templateType")) {
                    p = "tt.\"TEMPLATE.TEMPLATETYPE\"";
                }
                if (p.equals("Template.number")) {
                    p = "tt.\"TEMPLATE.NUMBER\"";
                }
                if (p.equals("Template.name")) {
                    p = "tt.\"TEMPLATE.NAME\"";
                }
                if (p.equals("Template.periodType")) {
                    p = "tt.\"TEMPLATE.PERIODTYPE\"";
                }
                if (p.equals("lastUpdateUser.name")) {
                    p = "tt.\"LASTUPDATEUSER.NAME\"";
                }
                if (p.equals("lastUpdateTime")) {
                    p = "tt.\"LASTUPDATETIME\"";
                }
                if (p.equals("publishedStatus")) {
                    p = "tt.\"PUBLISHEDSTATUS\"";
                }
                if (p.equals("auditedStatus")) {
                    p = "tt.\"AUDITEDSTATUS\"";
                }
                if (p.equals("auditor.name")) {
                    p = "tt.\"AUDITOR.NAME\"";
                }
                if (p.equals("versionNumber")) {
                    p = "tt.\"VERSIONNUMBER\"";
                }
                if (p.equals("includeOtherDC")) {
                    p = "tt.\"INCLUDEOTHERDC\"";
                }
                if (p.equals("canClosePeriod")) {
                    p = "tt.\"CANCLOSEPERIOD\"";
                }
                if (p.equals("checkOpenPeriod")) {
                    p = "tb.\"CHECKOPENPERIOD\"";
                }
                if (p.equals("isAllowChange")) {
                    p = "tt.\"ISALLOWCHANGE\"";
                }
                if (p.equals("creator.name")) {
                    p = "tt.\"CREATOR.NAME\"";
                }
                if (p.equals("createTime")) {
                    p = "tt.\"CreateTime\"";
                }
                if (p.equals("isGroup")) {
                    p = "tt.\"ISGROUP\"";
                }
                if (p.equals("company.name")) {
                    p = "tt.\"COMPANY.NAME\"";
                }
            }
            if (pTemp == p) continue;
            if (!first) {
                sortBuf.append(", ");
            } else {
                sortBuf.append(" ORDER BY ");
                first = false;
            }
            sortBuf.append(p).append(" ").append(info.getSortType());
        }
        return sortBuf.toString();
    }

    public static String builderGroupTmplSQL(ConditionWrappedInfo condition) {
        StringBuffer sql = new StringBuffer(1000);
        String selectPart = StringUtils.isEmpty((String)condition.getSelectorSql()) ? TemplateControllerBean.getTemplateSelector(condition) : condition.getSelectorSql();
        sql.append(selectPart);
        sql.append(" From T_RPT_Template  TEMPLATE \n");
        String easTplTableName = "TEMPLATE";
        if (condition.isUseK3()) {
            sql.append("   INNER JOIN T_RPT_Template as EAS_TPL  \n");
            sql.append("   ON ( ( TEMPLATE.FISK3TPL = 1 AND EAS_TPL.FID = TEMPLATE.FEASTPLIDFORK3)   \n");
            sql.append("   OR ( TEMPLATE.FISK3TPL = 0 AND EAS_TPL.FID = TEMPLATE.FID  AND   \n");
            sql.append("     NOT EXISTS (SELECT 'X' FROM T_RPT_TEMPLATE t where EAS_TPL.FID = t.FEASTPLIDFORK3)))  \n");
            easTplTableName = "EAS_TPL";
        }
        sql.append(" INNER JOIN ").append(condition.getDispTmplTable()).append(" as d \n");
        sql.append(" ON " + easTplTableName + ".FID = d.FDispenseSrcID \n");
        sql.append(" LEFT JOIN T_PM_User creator ON TEMPLATE.FCreatorID = creator.FID \n");
        sql.append(" LEFT JOIN T_PM_User auditor ON TEMPLATE.FAuditorID = auditor.FID \n");
        sql.append(" LEFT JOIN T_PM_User lastUpdateUser ON TEMPLATE.FLastUpdateUserID = lastUpdateUser.FID \n");
        sql.append(" INNER JOIN T_ORG_BaseUnit as company on d.FCompanyID = company.FID \n");
        sql.append(" Where (TEMPLATE.FTemplateType = ").append(6);
        if (condition.containsTemplateType(RptTmpTypeEnum.RPTDYNAMICREPORT)) {
            sql.append(" OR TEMPLATE.FTemplateType=10");
        }
        if (condition.containsTemplateType(RptTmpTypeEnum.MULTIRPTDYNAMICREPORT)) {
            sql.append(" OR TEMPLATE.FTemplateType=15");
        }
        sql.append(") \n");
        if (!condition.isShowFreezed()) {
            sql.append(" And TEMPLATE.FIsFreezed = 0 \n");
        }
        sql.append(" And  NOT EXISTS( Select 'X' \n");
        sql.append(" From T_RPT_Template t \n");
        sql.append(" where TEMPLATE.fid=t.FGroupTemplateID And t.FCompanyID ='" + condition.getCompanyID() + "'");
        sql.append(" And t.FVersionStatus = 1  \n");
        sql.append(" And d.FIsAllowChgTemplet = 1 \n");
        sql.append(" And t.FTemplateType in(2,12,16)) \n");
        if (!condition.isFromNewRptUI()) {
            if (condition.isDisplayTemplateType()) {
                sql.append(" and TEMPLATE.FDisplayTemplateTypeId in " + condition.getDisplayTemplateTypeValue());
            }
        } else {
            if (StringUtils.isEmpty((String)condition.getDisplayTemplateTypeValue())) {
                sql.append(" and TEMPLATE.FDisplayTemplateTypeId is null ");
            } else if (!"ALL".equalsIgnoreCase(condition.getDisplayTemplateTypeValue())) {
                sql.append(" and TEMPLATE.FDisplayTemplateTypeId in " + condition.getDisplayTemplateTypeValue());
            }
            sql.append(" and TEMPLATE.FAuditedStatus = 2 ");
        }
        if (!condition.isUseK3()) {
            sql.append(" And TEMPLATE.FIsK3Tpl = 0 \n");
        }
        if (condition.getPeriodType() != null) {
            sql.append(" And TEMPLATE.FperiodType = ").append(condition.getPeriodType().getValue());
        }
        return sql.toString();
    }

    public static String builderSubTmplSQL(ConditionWrappedInfo condition) {
        StringBuffer sql = new StringBuffer(1000);
        String selectPart = StringUtils.isEmpty((String)condition.getSelectorSql()) ? TemplateControllerBean.getTemplateSelector(condition) : condition.getSelectorSql();
        sql.append(selectPart);
        sql.append(" From T_RPT_Template  TEMPLATE \n");
        String easTplTableName = "TEMPLATE";
        if (condition.isUseK3()) {
            sql.append(" INNER JOIN T_RPT_Template as EAS_TPL  \n");
            sql.append(" ON ((TEMPLATE.FISK3TPL = 1 AND EAS_TPL.FID = TEMPLATE.FEASTPLIDFORK3)   \n");
            sql.append(" OR (TEMPLATE.FISK3TPL = 0 AND EAS_TPL.FID = TEMPLATE.FID  AND   \n");
            sql.append(" NOT EXISTS (SELECT 'X' FROM T_RPT_TEMPLATE t where (EAS_TPL.FID = t.FEASTPLIDFORK3 OR EAS_TPL.FGROUPTEMPLATEID = T.FEASTPLIDFORK3 )))) \n");
            easTplTableName = "EAS_TPL";
            sql.append(" INNER JOIN T_RPT_Template t2 on " + easTplTableName + ".FGroup = t2.FGroup \n");
            sql.append(" INNER JOIN " + condition.getDispTmplTable() + " d on t2.fid = d.FDispenseSrcID  \n");
        } else {
            sql.append(" INNER JOIN " + condition.getDispTmplTable() + " d \n");
            sql.append(" ON TEMPLATE.FGroupTemplateID = d.FDispenseSrcID   \n");
        }
        sql.append(" LEFT JOIN T_PM_User creator ON TEMPLATE.FCreatorID = creator.FID \n");
        sql.append(" LEFT JOIN T_PM_User auditor ON TEMPLATE.FAuditorID = auditor.FID \n");
        sql.append(" LEFT JOIN T_PM_User lastUpdateUser ON TEMPLATE.FLastUpdateUserID = lastUpdateUser.FID \n");
        sql.append(" INNER JOIN T_ORG_BaseUnit as company on TEMPLATE.FCompanyID = company.FID \n");
        sql.append(" Where TEMPLATE.fcompanyid ='" + condition.getCompanyID() + "' \n");
        sql.append(" And d.FIsAllowChgTemplet = 1 \n");
        if (condition.isShowFreezed()) {
            sql.append(" And TEMPLATE.FIsFreezed = 0 ");
            if (condition.isUseK3()) {
                sql.append(" And t2.FIsFreezed = 0 \n");
            }
        }
        sql.append(" And (TEMPLATE.FTemplateType = 2");
        if (condition.containsTemplateType(RptTmpTypeEnum.RPTDYNAMICREPORT)) {
            sql.append(" OR TEMPLATE.FTemplateType=12");
        }
        if (condition.containsTemplateType(RptTmpTypeEnum.MULTIRPTDYNAMICREPORT)) {
            sql.append(" OR TEMPLATE.FTemplateType=16");
        }
        sql.append(") \n");
        if (!condition.isFromNewRptUI()) {
            if (condition.isDisplayTemplateType()) {
                sql.append(" and TEMPLATE.FDisplayTemplateTypeId in " + condition.getDisplayTemplateTypeValue());
            }
        } else {
            if (StringUtils.isEmpty((String)condition.getDisplayTemplateTypeValue())) {
                sql.append(" and TEMPLATE.FDisplayTemplateTypeId is null ");
            } else if (!"ALL".equalsIgnoreCase(condition.getDisplayTemplateTypeValue())) {
                sql.append(" and TEMPLATE.FDisplayTemplateTypeId in " + condition.getDisplayTemplateTypeValue());
            }
            sql.append(" and TEMPLATE.FAuditedStatus = 2 ");
        }
        if (condition.isRemovePublished()) {
            sql.append("\n And TEMPLATE.FPublishedStatus = 1");
        }
        if (condition.isOnlyUnversion()) {
            sql.append("\n And TEMPLATE.FVersionStatus = 1");
        } else {
            sql.append("\n And TEMPLATE.FVersionStatus <= 1");
        }
        if (!condition.isUseK3()) {
            sql.append(" And TEMPLATE.FIsK3Tpl = 0 \n");
        }
        if (condition.getPeriodType() != null) {
            sql.append(" And TEMPLATE.FperiodType = ").append(condition.getPeriodType().getValue());
        }
        return sql.toString();
    }

    public static void createDispenseTemplateRecordTable(Context ctx, ConditionWrappedInfo condition) throws BOSException {
        String tableName = TemplateControllerBean.createTmplTable(ctx);
        condition.setDispTmplTable(tableName);
        StringBuffer sql = new StringBuffer(500);
        sql.append(" INSERT INTO ").append(tableName).append("\n").append(" Select Distinct disp.FDispenseSrcID,disp.FCompanyID,disp.FSourceType,\n").append(" disp.FisAllowChgTemplet,tmpl.FGroup \n").append(" From T_CSL_TempletDispense disp \n").append(" Join T_RPT_Template tmpl on disp.FDispenseSrcID = tmpl.FID \n").append(" Join T_ORG_BaseUnit company on company.FID = disp.FCompanyID").append(" Where company.FID = '").append(condition.getCompanyID()).append("' \n").append(" And tmpl.FOrgType = ").append(condition.getOrgType()).append(" \n").append(" And tmpl.FTemplateType in(6,10,15) \n").append(" And tmpl.FVersionStatus = 1 \n");
        if (condition.getPeriodType() != null) {
            sql.append(" And tmpl.FperiodType = ").append(condition.getPeriodType().getValue());
        }
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" Insert into ").append(tableName).append("\n").append(" Select Distinct disp.fdispensesrcid, disp.FCompanyID, \n").append(" disp.fsourcetype,disp.fisallowchgtemplet,tmpl.fgroup  \n").append(" From t_rpt_template tmpl \n").append(" Join (SELECT t1.fgroup,").append(" concat(rtrim(convert(varchar(50),max(TO_INT(substring(fversionnumber,1,charindex('.',fversionnumber)-1))))),'.0') FVERSIONNUMBER \n").append(" FROM T_Csl_templetdispense tmpDisp \n").append(" INNER JOIN T_RPT_Template t1 ON tmpDisp.FDispenseSrcID = t1.FID  \n").append(" Where t1.FisFreezed = 0 and tmpDisp.FCompanyID = '" + condition.getCompanyID() + "' \n").append(" And t1.FOrgType = ").append(condition.getOrgType()).append(" \n").append(" And t1.fgroup not in (select fgroup from " + tableName + ")\n").append(" GROUP BY t1.fgroup) maxtmpl ON tmpl.fgroup = maxtmpl.fgroup \n").append(" And tmpl.fversionnumber = maxtmpl.FVERSIONNUMBER \n").append(" Join t_csl_templetdispense disp ON tmpl.fid = disp.fdispensesrcid \n").append(" Where disp.fcompanyID = '" + condition.getCompanyID() + "' \n").append(" And tmpl.FTemplateType in(6,10,15) ");
        if (condition.getPeriodType() != null) {
            sql.append(" And tmpl.FperiodType = ").append(condition.getPeriodType().getValue());
        }
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private static String createTmplTable(Context ctx) throws BOSException {
        StringBuffer createSQL = new StringBuffer(100);
        createSQL.append(" CREATE TABLE T_DISPENSETEMPLATE_TBL(").append(" FDISPENSESRCID VARCHAR(44),FCOMPANYID VARCHAR(44),").append(" FSourceType INT ,FIsAllowChgTemplet INT,FGROUP VARCHAR(44))");
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String tblName = null;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            tblName = pool.createTempTable(createSQL.toString());
            pool.createIndex(tblName, "FDISPENSESRCID,FIsAllowChgTemplet", false, false);
            pool.createIndex(tblName, "FGROUP", false, false);
            pool.analyzeTable(conn, tblName);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        return tblName;
    }

    private static String getTemplateSelector(ConditionWrappedInfo condition) {
        StringBuffer sql = new StringBuffer(500);
        sql.append("  SELECT    \n").append("  TEMPLATE.FID AS \"TEMPLATE.ID\",  \n").append("  TEMPLATE.FName AS \"TEMPLATE.NAME\",  \n").append("  TEMPLATE.FNumber AS \"TEMPLATE.NUMBER\",  \n").append("  TEMPLATE.FPeriodType AS \"TEMPLATE.PERIODTYPE\", \n").append("  TEMPLATE.FTemplateType AS \"TEMPLATE.TEMPLATETYPE\", \n").append("  TEMPLATE.FDescription AS \"FDescription\", \n").append("  TEMPLATE.FGroup AS \"TEMPLATE.GROUP\",  \n").append("  TEMPLATE.FGroupTemplateID AS \"TEMPLATE.GroupTemplateID\",  \n").append("  CREATOR.FName_" + condition.getLanguage() + " AS \"CREATOR.NAME\", \n").append("  CREATOR.FID AS \"CREATOR.ID\", \n").append("  LASTUPDATEUSER.FName_" + condition.getLanguage() + " AS \"LASTUPDATEUSER.NAME\", \n").append("  TEMPLATE.FLastUpdateTime AS \"LASTUPDATETIME\", \n").append("  AUDITOR.FName_" + condition.getLanguage() + " AS \"AUDITOR.NAME\", \n").append("  AUDITOR.FID AS \"AUDITOR.ID\", \n").append("  TEMPLATE.FVersionNumber AS \"VERSIONNUMBER\", \n").append("  TEMPLATE.FIsIncludeOtherDC AS \"INCLUDEOTHERDC\", \n").append("  TEMPLATE.FCanClosePeriod AS \"CANCLOSEPERIOD\", \n").append("  TEMPLATE.FCheckOpenPeriod AS \"CHECKOPENPERIOD\", \n").append("  TEMPLATE.FAuditedStatus AS \"AUDITEDSTATUS\", \n").append("  TEMPLATE.FPublishedStatus AS \"PUBLISHEDSTATUS\", \n").append("  COMPANY.FLongNumber AS \"COMPANY.LONGNUMBER\", \n").append("  Template.FCreateTime AS \"CreateTime\",  \n").append("  COMPANY.FID AS \"COMPANY.ID\",  \n").append("  COMPANY.FName_").append(condition.getLanguage()).append(" AS \"COMPANY.NAME\",  \n").append("  d.FSourceType AS \"TEMPLETDISPENSE.SOURCETYPE\",  \n").append("  d.FIsAllowChgTemplet AS \"ISALLOWCHANGE\" , \n").append("  TEMPLATE.GU AS \"ISGROUP\" , \n").append("  TEMPLATE.FISK3TPL AS \"ISK3TPL\",  \n").append("  TEMPLATE.FEASTPLIDFORK3 AS \"EASTPLIDFORK3\"  \n");
        return sql.toString();
    }

    private void handlePermissionCondition(Context ctx, ConditionWrappedInfo condition) throws BOSException, EASBizException {
        ObjectUuidPK currentUserPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        String dataRule = RptUtilForServer.getCommonDataRule(ctx, (IObjectPK)currentUserPK, (IObjectPK)new ObjectUuidPK(condition.getCompanyID()), "rpt_template_view");
        String permissionCondition = null;
        if (!StringUtils.isEmpty((String)dataRule)) {
            try {
                permissionCondition = PermissionFactory.getLocalInstance((Context)ctx).getQueryPermissionSQL((IObjectPK)currentUserPK, (IObjectPK)new ObjectUuidPK(condition.getCompanyID()), "rpt_template_view");
                permissionCondition = "in (" + permissionCondition + ")";
            }
            catch (EASBizException e1) {
                logger.error((Object)e1.getStackTrace(), (Throwable)e1);
            }
        }
        condition.setDataRule(dataRule);
        condition.setPermissionCondition(permissionCondition);
    }

    private void handleFilterItemInfo(Context ctx, EntityViewInfo view, ConditionWrappedInfo condition) throws SQLDataException {
        if (view != null) {
            String displayTemplateTypeName = "";
            String displayTemplateTypeValue = "";
            FilterItemCollection filterItems = view.getFilter().getFilterItems();
            if (filterItems.size() >= 0) {
                int size = filterItems.size();
                for (int i = 0; i < size; ++i) {
                    FilterItemInfo filterItem = filterItems.get(i);
                    if (filterItem == null) continue;
                    displayTemplateTypeName = filterItem.getPropertyName();
                    if (displayTemplateTypeName != null && displayTemplateTypeName.equals("displayTemplateType.id")) {
                        condition.setDisplayTemplateType(true);
                        Iterator templateTypeIter = ((Set)filterItem.getCompareValue()).iterator();
                        displayTemplateTypeValue = RptUtilForServer.createInStringSql(templateTypeIter, ctx);
                        condition.setDisplayTemplateTypeValue(displayTemplateTypeValue);
                    }
                    if (displayTemplateTypeName == null || !displayTemplateTypeName.equals("isFromNewRptUI")) continue;
                    condition.setFromNewRptUI(true);
                }
            }
        }
        if (condition.isFromNewRptUI() && view != null && view.getFilter() != null) {
            view.getFilter().getFilterItems().removeObject((Object)"isFromNewRptUI");
        }
    }

    @Override
    protected boolean _updateTemplateStatus(Context ctx, String oldTemplateID, String newTemplateID) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sc = view.getSelector();
        sc.add("id");
        sc.add("templateType");
        sc.add("group");
        sc.add("versionNumber");
        FilterInfo filter = new FilterInfo();
        HashMap<String, TemplateInfo> idMap = new HashMap<String, TemplateInfo>();
        idMap.put(oldTemplateID, null);
        idMap.put(newTemplateID, null);
        filter.getFilterItems().add(new FilterItemInfo("id", idMap.keySet(), CompareType.INCLUDE));
        view.setFilter(filter);
        TemplateCollection templateCollection = this.getTemplateCollection(ctx, view);
        for (int i = 0; templateCollection != null && i < templateCollection.size(); ++i) {
            idMap.put(templateCollection.get(i).getId().toString(), templateCollection.get(i));
        }
        TemplateInfo oldTemplate = (TemplateInfo)idMap.get(oldTemplateID);
        TemplateInfo newTemplate = (TemplateInfo)idMap.get(newTemplateID);
        if (oldTemplate != null && newTemplate != null && !oldTemplate.getTemplateType().equals((Object)newTemplate.getTemplateType()) && RptTmpTypeEnum.COMMONPUBLICTEMPLATE.equals((Object)oldTemplate.getTemplateType()) && RptTmpTypeEnum.COMMONREPORT.equals((Object)newTemplate.getTemplateType())) {
            this.sealPublicTemplates(ctx, oldTemplate, newTemplate);
            this.updateVersionNumberForPublic2UnPublic(ctx, oldTemplate, newTemplate);
            return true;
        }
        return false;
    }

    private String buildQuetedPublicTemplateMsg(TemplateInfo info, List quoteResultList, Context ctx) {
        StringBuffer detail = new StringBuffer();
        detail.append(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"5_ReportControllerBean", (Locale)ctx.getLocale())).append(info.getNumber()).append(" ").append(info.getName()).append(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"20_TemplateControllerBean", (Locale)ctx.getLocale())).append("\n");
        for (Map entry : quoteResultList) {
            detail.append(entry.get("CompanyName")).append("\uff0c");
            ReportTypeEnum type = (ReportTypeEnum)((Object)entry.get("SourceType"));
            if (ReportTypeEnum.REPORT.equals((Object)type)) {
                detail.append(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"21_TemplateControllerBean", (Locale)ctx.getLocale())).append(entry.get("Source")).append("\n");
                continue;
            }
            detail.append(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"22_TemplateControllerBean", (Locale)ctx.getLocale())).append(entry.get("Source")).append("\n");
        }
        detail.append("\n");
        return detail.toString();
    }

    private TemplateCollection getCurrentCompanyPublicTemplate(Context ctx, String currentCompanyID, List versionTypeList, boolean isShowUnpublish, boolean isShowUnaudit) throws BOSException {
        StringBuffer sql = new StringBuffer();
        ArrayList<String> params = new ArrayList<String>();
        sql.append("Select FId,FGroup,FVersionNumber,Fauditedstatus from T_RPT_Template template\t\n");
        sql.append("where FCompanyID = ?\t\n");
        params.add(currentCompanyID);
        sql.append("and fversionstatus\tin\t\n");
        sql.append(RptUtilForServer.createInSql(versionTypeList.iterator(), params));
        sql.append("and fauditedstatus\tin  \n");
        HashSet<Integer> auditedstatus = new HashSet<Integer>();
        auditedstatus.add(new Integer(2));
        if (isShowUnaudit) {
            auditedstatus.add(new Integer(1));
        }
        sql.append(RptUtilForServer.createInSql(auditedstatus.iterator(), params));
        sql.append("and fpublishedStatus  in\t\n");
        HashSet<Integer> publishedStatus = new HashSet<Integer>();
        publishedStatus.add(new Integer(1));
        if (isShowUnpublish) {
            publishedStatus.add(new Integer(2));
        }
        sql.append(RptUtilForServer.createInSql(publishedStatus.iterator(), params));
        sql.append("and FTemplateType\t= 14\t\n");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        TemplateCollection collection = new TemplateCollection();
        try {
            while (rowSet.next()) {
                TemplateInfo info = new TemplateInfo();
                info.setId(BOSUuid.read((String)rowSet.getString("fid")));
                info.setVersionNumber(rowSet.getString("FVersionNumber"));
                info.setGroup(rowSet.getString("FGroup"));
                info.setAuditedStatus(AuditedStatusEnum.getEnum(rowSet.getInt("Fauditedstatus")));
                collection.add(info);
            }
            return collection;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private Set getIDsForPublicTemplate(Context ctx, TemplateCollection currentCompanyTemplate, Map newestSuperTemplate) {
        HashSet<String> result = new HashSet<String>();
        int count = 0;
        if (currentCompanyTemplate != null) {
            count = currentCompanyTemplate.size();
        }
        TemplateVersionComparator comparator = new TemplateVersionComparator();
        for (int i = 0; i < count; ++i) {
            TemplateInfo info = currentCompanyTemplate.get(i);
            if (AuditedStatusEnum.UNAUDITED.equals((Object)info.getAuditedStatus())) {
                result.add(info.getId().toString());
                continue;
            }
            if (!AuditedStatusEnum.AUDITED.equals((Object)info.getAuditedStatus())) continue;
            if (newestSuperTemplate.get(info.getGroup()) == null) {
                result.add(info.getId().toString());
                continue;
            }
            TemplateInfo superTemplate = (TemplateInfo)newestSuperTemplate.get(info.getGroup());
            int comparaResult = comparator.compare(info, superTemplate);
            TemplateInfo newestInfo = comparaResult > 0 ? info : superTemplate;
            newestSuperTemplate.put(info.getGroup(), newestInfo);
        }
        for (TemplateInfo info : newestSuperTemplate.values()) {
            result.add(info.getId().toString());
        }
        return result;
    }

    private Map getNewestSuperPublicTemplate(Context ctx, String currentCompanyID) throws BOSException {
        List companyList = RptUtilForServer.getSuperCompanyIDs(ctx, currentCompanyID);
        if (companyList == null || companyList.size() == 0) {
            return new HashMap();
        }
        StringBuffer sql = new StringBuffer();
        ArrayList<Integer> params = new ArrayList<Integer>();
        sql.append("Select FId,FGroup,FVersionNumber from T_RPT_Template template\t\t\t\n");
        sql.append("where FCompanyID in\t\t\n");
        sql.append(RptUtilForServer.createInSql(companyList.iterator(), params));
        sql.append("and fversionstatus\t= ?\t\n");
        params.add(new Integer(1));
        sql.append("and fauditedstatus\t= ?\t\n");
        params.add(new Integer(2));
        sql.append("and fpublishedStatus\t= ?\t\n");
        params.add(new Integer(1));
        sql.append("and FTemplateType\t= ");
        sql.append(14);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        try {
            HashMap<String, ArrayList<TemplateInfo>> infoMap = new HashMap<String, ArrayList<TemplateInfo>>();
            while (rowSet.next()) {
                TemplateInfo info = new TemplateInfo();
                info.setId(BOSUuid.read((String)rowSet.getString("fid")));
                info.setVersionNumber(rowSet.getString("FVersionNumber"));
                info.setGroup(rowSet.getString("FGroup"));
                ArrayList<TemplateInfo> list = (ArrayList<TemplateInfo>)infoMap.get(info.getGroup());
                if (list == null) {
                    list = new ArrayList<TemplateInfo>();
                    list.add(info);
                    infoMap.put(info.getGroup(), list);
                    continue;
                }
                list.add(info);
            }
            HashMap result = new HashMap();
            TemplateVersionComparator comparator = new TemplateVersionComparator();
            for (Map.Entry entry : infoMap.entrySet()) {
                Object info = Collections.max((List)entry.getValue(), comparator);
                result.put(entry.getKey(), info);
            }
            return result;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private int getPublicTemplateChangeCompanyLevel(Context ctx, TemplateInfo templateInfo) throws BOSException {
        if (templateInfo.getVersionNumber() == null || templateInfo.getGroup() == null) {
            return 0;
        }
        StringBuffer sql = new StringBuffer();
        ArrayList<String> params = new ArrayList<String>();
        sql.append("select company.FLevel lv from T_ORG_Company company \t\t\t\t\t\t\t\n");
        sql.append("inner join T_RPT_Template template on template.FCompanyID = company.FID\t\t\t\n");
        sql.append("where template.FVersionNumber = ?\t\t\t\t\t\t\t\t\t\t\t\t\n");
        params.add(templateInfo.getVersionNumber());
        sql.append("and template.FGroup = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        params.add(templateInfo.getGroup());
        sql.append("and exists (\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("Select distinct super.FID ID from T_ORG_Company super\t\t\n");
        sql.append("inner join T_ORG_Company sub on charindex(concat(super.flongnumber,'!'),sub.flongnumber) = 1\t\t\n");
        sql.append("where sub.fid = ?\t\t\t\t\t\n");
        params.add(templateInfo.getCompany().getId().toString());
        sql.append("and super.fid <> ?\t\t\t\t\t\n");
        params.add(templateInfo.getCompany().getId().toString());
        sql.append("and (Super.fid = Sub.fid or charindex(concat(Super.flongnumber,'!'),Sub.flongnumber) = 1 )\t\t\t \n");
        sql.append("and super.fiscompanyorgunit = 1 \t\n");
        sql.append("and super.FIssealup = 0 \t\t\t\n");
        sql.append("and company.FID = super.FID )\t\t\n");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        try {
            if (rowSet.next()) {
                int superLevel = rowSet.getInt("lv");
                int subLevel = templateInfo.getCompany().getLevel();
                if (subLevel > superLevel) {
                    return subLevel - superLevel;
                }
                return 0;
            }
            return 0;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private void sealPublicTemplates(Context ctx, TemplateInfo oldTemplate, TemplateInfo newTemplate) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update t_rpt_Template set");
        sql.append(" FVersionStatus= ?,");
        sql.append(" FPublishedStatus= ?");
        sql.append(" where fgroup = ?");
        sql.append(" and fid <> ?");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(new Integer(2));
        params.add(new Integer(2));
        params.add(oldTemplate.getGroup());
        params.add(newTemplate.getId().toString());
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
    }

    private void updateVersionNumberForPublic2UnPublic(Context ctx, TemplateInfo oldTemplate, TemplateInfo newTemplate) throws BOSException {
        String nextVersion = TemplateVersionMgr.getNextVersion(oldTemplate.getVersionNumber());
        String sql = " UPDATE T_RPT_TEMPLATE SET FVersionNumber = ? ,FGroup = ? where FID = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{nextVersion, oldTemplate.getGroup(), newTemplate.getId().toString()});
    }

    @Override
    protected List _forbid(Context ctx, List ids, boolean isFreezed) throws BOSException, EASBizException {
        if (ids == null) {
            return null;
        }
        return TemplateItemListSeparateHelper.forbid(ctx, ids, isFreezed);
    }

    @Override
    protected boolean _isGroupLastestVersion(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("templateType"));
        sic.add(new SelectorItemInfo("company"));
        sic.add(new SelectorItemInfo("group"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("versionNumber"));
        sic.add(new SelectorItemInfo("templateSource"));
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        TemplateInfo template = this.getTemplateInfo(ctx, (IObjectPK)new ObjectUuidPK(id), sic);
        if (template.getTemplateType() != RptTmpTypeEnum.COMMONPUBLICTEMPLATE && template.getTemplateType() != RptTmpTypeEnum.COMMONREPORT) {
            if (template.getTemplateSource().equals((Object)TemplateSourceEnum.GRADETEMPLATE)) {
                sql.append(" SELECT solu.FVersionNumber \n");
                sql.append(" FROM T_CSL_FormulaSolu solu \n");
                sql.append(" INNER JOIN T_Csl_FormulaSoluDispense dispense on dispense.FFormulaSoluId=solu.fid \n");
                sql.append(" WHERE solu.FTemplateGroupId = ? \n");
                params.add(template.getGroup());
                sql.append(" And dispense.FCompanyId = ? \n");
                params.add(template.getCompany().getId().toString());
                sql.append(" AND solu.FVersionStatus = ? \n");
                params.add(new Integer(1));
            } else {
                sql.append(" SELECT FVersionNumber              \n");
                sql.append(" FROM T_RPT_Template            \n");
                sql.append(" WHERE FGROUPTEMPLATEID is null      \n");
                sql.append(" AND FGroup = ?             \n");
                params.add(template.getGroup());
                sql.append(" AND FVersionStatus = ? \n");
                params.add(new Integer(1));
                sql.append(" AND FISFREEZED  = 0 \n");
                sql.append(" AND FISK3TPL  = 0 \n");
            }
        } else {
            sql.append(" SELECT FVersionNumber              \n");
            sql.append(" FROM T_RPT_Template            \n");
            sql.append(" WHERE FGroup = ?             \n");
            params.add(template.getGroup());
            sql.append(" AND FCompanyID = ?             \n");
            params.add(template.getCompany().getId().toString());
            sql.append(" AND FVersionStatus = ? \n");
            params.add(new Integer(1));
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        String verNum = template.getVersionNumber();
        try {
            while (rs.next()) {
                if (TemplateControllerBean.versionCompare(rs.getString("FVersionNumber"), verNum) <= 0) continue;
                return false;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return true;
    }

    public static String getInClause(int paramSize, String fieldName) {
        if (paramSize == 0 || fieldName == null || fieldName.length() == 0) {
            return "";
        }
        int valuesSize = 500;
        StringBuffer inClause = new StringBuffer();
        if (paramSize > valuesSize) {
            inClause.append("(");
        }
        for (int i = 0; i < paramSize; i += valuesSize) {
            if (i > 0) {
                inClause.append(" OR ");
            }
            inClause.append(fieldName);
            inClause.append(" IN(");
            for (int j = i; j < i + valuesSize && j < paramSize; ++j) {
                inClause.append("?,");
            }
            if (inClause.toString().endsWith(",")) {
                inClause.deleteCharAt(inClause.length() - 1);
            }
            inClause.append(")");
        }
        if (paramSize > valuesSize) {
            inClause.append(")");
        }
        return inClause.toString();
    }

    @Override
    protected int _batchsubmitStandardTemp(Context ctx, List templateList, Map tempPKMap) throws BOSException, EASBizException {
        int count = 0;
        for (int i = 0; i < templateList.size(); ++i) {
            TemplateInfo info = new TemplateInfo();
            info = (TemplateInfo)templateList.get(i);
            if (tempPKMap.get(info.getNumber()) != null && !"false".equals(tempPKMap.get(info.getNumber()))) {
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)tempPKMap.get(info.getNumber()).toString()));
                if (1 != this.getTemplateInfo(ctx, (IObjectPK)pk).getAuditedStatus().getValue()) continue;
                this.delete(ctx, (IObjectPK)pk);
                this.addnew(ctx, (CoreBaseInfo)info);
                ++count;
                continue;
            }
            this.submit(ctx, (CoreBaseInfo)info);
            ++count;
        }
        return count;
    }

    @Override
    protected int _batchsubmitInitializeTemp(Context ctx, List templateList, Map temPkMap) throws BOSException, EASBizException {
        int count = 0;
        for (int i = 0; i < templateList.size(); ++i) {
            TemplateInfo info = new TemplateInfo();
            info = (TemplateInfo)templateList.get(i);
            if (temPkMap.get(info.getNumber()) != null && !"false".equals(temPkMap.get(info.getNumber()))) {
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)temPkMap.get(info.getNumber()).toString()));
                IObjectPK auditVersionPK = this.getLatestVersion(ctx, (IObjectPK)pk);
                if (auditVersionPK == null) {
                    this.delete(ctx, (IObjectPK)pk);
                    this.addnew(ctx, (CoreBaseInfo)info);
                    ++count;
                    continue;
                }
                IObjectPK newVersionPK = this.getLatestVersionContainUnAudit(ctx, (IObjectPK)pk);
                TemplateInfo newVerTemp = this.getTemplateInfo(ctx, newVersionPK);
                TemplateInfo auditVerTemp = this.getTemplateInfo(ctx, auditVersionPK);
                if (1 == newVerTemp.getAuditedStatus().getValue()) {
                    this.delete(ctx, newVersionPK);
                }
                info.setId(auditVerTemp.getId());
                info.setGroup(auditVerTemp.getGroup());
                info.setVersionNumber(auditVerTemp.getVersionNumber());
                this.tempVersion(ctx, info);
                continue;
            }
            this.submit(ctx, (CoreBaseInfo)info);
            ++count;
        }
        return count;
    }

    @Override
    protected Map _getAllStandardTmepInfo(Context ctx, List templateList) throws BOSException, EASBizException {
        HashMap<String, String> templateMap = new HashMap<String, String>();
        StringBuffer sqlBuffer = null;
        boolean isAllAudit = true;
        for (int i = 0; i < templateList.size(); ++i) {
            IRowSet rs;
            TemplateInfo info = new TemplateInfo();
            info = (TemplateInfo)templateList.get(i);
            if (info == null) continue;
            sqlBuffer = new StringBuffer();
            ArrayList<Object> params = new ArrayList<Object>();
            sqlBuffer.append("select t.fid fid,t.fauditedStatus fauditedStatus from  T_RPT_Template t left join ");
            sqlBuffer.append("T_ORG_BaseUnit unit on t.fcompanyid = unit.FID  where t.fnumber=?");
            params.add(info.getNumber());
            String versionNumber = info.getVersionNumber();
            if (info.getVersionNumber() == null) {
                TemplateVersionMgr manager = new TemplateVersionMgr(info, false, 0);
                versionNumber = manager.getVersion();
            }
            params.add(versionNumber);
            sqlBuffer.append(" and t.fversionNumber=?");
            sqlBuffer.append(" and t.ftemplateType=?");
            params.add(new Integer(info.getTemplateType().getValue()));
            if (info.getCompany() != null && info.getTemplateType().equals((Object)RptTmpTypeEnum.COMMONREPORT)) {
                sqlBuffer.append(" and t.fcompanyid=? ");
                params.add(info.getCompany().getId().toString());
            }
            if ((rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString(), (Object[])params.toArray())) == null || rs.size() == 0) {
                isAllAudit = false;
                templateMap.put(info.getNumber(), "false");
                continue;
            }
            int audit = 1;
            try {
                while (rs.next()) {
                    audit = rs.getInt("fauditedStatus");
                    templateMap.put(info.getNumber(), rs.getString("fid"));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            if (1 != audit) continue;
            isAllAudit = false;
        }
        if (isAllAudit) {
            templateMap.put("isAllStandardTmepAduit", "true");
        } else {
            templateMap.put("isAllStandardTmepAduit", "false");
        }
        return templateMap;
    }

    @Override
    protected void _separateTmpItemData(Context ctx) throws BOSException, EASBizException {
        TemplateItemListSeparateHelper.separate(ctx);
    }

    @Override
    protected IObjectValue _getEasTplForK3(Context ctx, String easTplId, SelectorItemCollection selector) throws BOSException, EASBizException {
        TemplateCollection tpls;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.appendFilterItem("easTplIdForK3", (Object)easTplId);
        filter.appendFilterItem("isK3Tpl", (Object)Boolean.TRUE);
        filter.appendFilterItem("grouptemplate", null);
        if (selector != null) {
            view.setSelector(selector);
        }
        if ((tpls = this.getTemplateCollection(ctx, view)).isEmpty()) {
            return null;
        }
        return tpls.get(0);
    }

    @Override
    protected IObjectCollection _createEasTplForK3(Context ctx, List easTplIds, boolean isUpdateForExist) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(easTplIds), CompareType.INCLUDE));
        return this.createEasTplForK3(ctx, this.getTemplateCollection(ctx, view), isUpdateForExist);
    }

    @Override
    protected IObjectCollection _createEasTplForK3(Context ctx, IObjectCollection easTplInfos, boolean isUpdateForExist) throws BOSException, EASBizException {
        TemplateCollection retCols = new TemplateCollection();
        CoreBaseCollection retColsForCoreBase = new CoreBaseCollection();
        String easTplId = null;
        ICSLK3Template k3TplDao = CSLK3TemplateFactory.getLocalInstance((Context)ctx);
        TemplateInfo easTplForK3 = null;
        Map easTplIdForK3Map = this.getExistEasTplForK3(ctx, (TemplateCollection)easTplInfos);
        boolean updateBookFromEas = true;
        for (int i = 0; i < easTplInfos.size(); ++i) {
            TemplateInfo info;
            block11: {
                info = (TemplateInfo)easTplInfos.getObject(i);
                String preVerNum = TemplateVersionMgr.getPreviousVersionLocal(info.getVersionNumber());
                easTplId = info.getId().toString();
                info.setEasTplIdForK3(easTplId);
                easTplForK3 = (TemplateInfo)easTplIdForK3Map.get(easTplId);
                updateBookFromEas = true;
                if (easTplForK3 != null) {
                    if (!isUpdateForExist) continue;
                    info.setId(easTplForK3.getId());
                    info.setGroup(easTplForK3.getGroup());
                } else {
                    info.setId(null);
                    IObjectPK preVersTplId = this.getPreviousVersion(ctx, (IObjectPK)new ObjectUuidPK(easTplId));
                    if (preVersTplId == null) {
                        info.setVersionNumber(preVerNum);
                        info.setGroup(Uuid.create().toString());
                    } else {
                        TemplateInfo preVersTplInfos = this.getEasTplForK3(ctx, preVersTplId.toString(), null);
                        if (preVersTplInfos != null) {
                            info.setVersionNumber(preVersTplInfos.getVersionNumber());
                            info.setGroup(preVersTplInfos.getGroup());
                            try {
                                info.setBook(preVersTplInfos.getBook());
                                updateBookFromEas = false;
                                break block11;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                continue;
                            }
                        }
                        info.setVersionNumber(preVerNum);
                        info.setGroup(Uuid.create().toString());
                    }
                }
            }
            info.setIsK3Tpl(true);
            if (updateBookFromEas) {
                try {
                    info.setBook(k3TplDao.createK3Book(easTplId));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
            }
            retCols.addObject((IObjectValue)info);
            retColsForCoreBase.add((CoreBaseInfo)info);
        }
        this.save(ctx, retColsForCoreBase);
        return retCols;
    }

    private Map getExistEasTplForK3(Context ctx, TemplateCollection easTplInfos) throws BOSException, EASBizException {
        HashSet<String> ids = new HashSet<String>();
        for (int i = 0; i < easTplInfos.size(); ++i) {
            TemplateInfo info = easTplInfos.get(i);
            ids.add(info.getId().toString());
        }
        return this.getEasTplForK3(ctx, ids, null);
    }

    @Override
    protected Map _getEasTplForK3(Context ctx, Set ids, SelectorItemCollection selector) throws BOSException, EASBizException {
        TemplateCollection easTplsForK3;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("easTplIdForK3", (Object)ids, CompareType.INCLUDE));
        filter.appendFilterItem("isK3Tpl", (Object)Boolean.TRUE);
        filter.appendFilterItem("grouptemplate", null);
        if (selector != null) {
            view.setSelector(selector);
        }
        if ((easTplsForK3 = this.getTemplateCollection(ctx, view)).isEmpty()) {
            return new HashMap(0);
        }
        HashMap<String, TemplateInfo> eas2K3 = new HashMap<String, TemplateInfo>(easTplsForK3.size());
        for (int i = 0; i < easTplsForK3.size(); ++i) {
            TemplateInfo info = easTplsForK3.get(i);
            eas2K3.put(info.getEasTplIdForK3(), info);
        }
        return eas2K3;
    }

    @Override
    protected boolean _updateK3(Context ctx, String oldK3Id) throws BOSException, EASBizException {
        ICSLK3Template k3TplDao = CSLK3TemplateFactory.getLocalInstance((Context)ctx);
        CSLK3TemplateInfo k3TplInfo = (CSLK3TemplateInfo)k3TplDao.getValue((IObjectPK)new ObjectUuidPK(oldK3Id));
        if (k3TplInfo == null) {
            return false;
        }
        SelectorItemCollection retInfoSelector = new SelectorItemCollection();
        retInfoSelector.add("id");
        TemplateInfo easTplInfoForK3 = this.getEasTplForK3(ctx, k3TplInfo.getSourceTemplate().getId().toString(), retInfoSelector);
        try {
            easTplInfoForK3.setBook(k3TplInfo.getBook());
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("data");
        this.updatePartial(ctx, (CoreBaseInfo)easTplInfoForK3, selector);
        return true;
    }

    @Override
    protected void _addForCslComm(Context ctx, IObjectValue model) throws BOSException {
    }

    @Override
    protected void _addForCsl(Context ctx, IObjectValue model) throws BOSException {
    }

    @Override
    protected void _updateForCslComm(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException {
    }

    @Override
    protected void _updateForCsl(Context ctx, IObjectValue model, IObjectPK pk) throws BOSException {
    }

    @Override
    protected void _updateForRpt(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException {
    }

    @Override
    protected void _deleteForCslComm(Context ctx, IObjectPK pk) throws BOSException {
    }

    @Override
    protected void _deleteForCsl(Context ctx, IObjectPK pk) throws BOSException {
    }

    @Override
    protected void _getForCslComm(Context ctx, IObjectPK pk) throws BOSException {
    }

    @Override
    protected void _getForCsl(Context ctx, IObjectPK pk) throws BOSException {
    }

    @Override
    protected void _getForRpt(Context ctx, IObjectPK pk) throws BOSException {
    }

    @Override
    protected void _auditForCslComm(Context ctx, IObjectPK pk) throws BOSException {
    }

    @Override
    protected void _auditForCsl(Context ctx, IObjectPK pk) throws BOSException {
    }

    @Override
    protected void _auditForRpt(Context ctx, IObjectPK pk) throws BOSException {
    }

    @Override
    protected void _unAuditForCslComm(Context ctx, IObjectPK pk) throws BOSException {
    }

    @Override
    protected void _unAuditForCsl(Context ctx, IObjectPK pk) throws BOSException {
    }

    @Override
    protected void _deleteForRpt(Context ctx, IObjectPK pk) throws BOSException {
    }

    @Override
    protected void _unAuditForRpt(Context ctx, IObjectPK pk) throws BOSException {
    }

    protected void _isReferenced(Context ctx, IObjectPK pk, Connection cn) throws ObjectReferedException {
        BizReference ref = null;
        try {
            ref = ReferenceDAO.getReference((Context)ctx, (BOSUuid)BOSUuid.read((String)pk.toString()));
        }
        catch (Exception e) {
            throw new ObjectReferedException((Object)ref, (Throwable)e);
        }
        if (this.isrptHisRelaRpt(ref)) {
            return;
        }
        if (ref != null) {
            logger.error((Object)(ref.getClass() + "," + ref.getRefEntityName() + "," + ref.getRefFieldName() + "," + ref.getRefFieldName() + "," + ref.getRefTableName()));
            throw new ObjectReferedException((Object)ref, (Throwable)new BizReferenceException(BizReferenceException.BIZ_REFENCED));
        }
    }

    private boolean isrptHisRelaRpt(BizReference ref) {
        if (ref == null) {
            return true;
        }
        return ref.getRefEntityName().equals("RptHistory") && ref.getRefFieldName().equals("FTemplateID") && ref.getRefTableName().equals("T_RPT_RptHistory");
    }

    @Override
    protected Map _getDynaImportTemplates(Context ctx, Map param) throws BOSException, EASBizException {
        HashMap<String, TemplateCollection> result = new HashMap<String, TemplateCollection>();
        TemplateCollection col = new TemplateCollection();
        result.put("templateCollection", col);
        SQLBuilder builder = new SQLBuilder();
        builder.append("select distinct fid,fnumber,fname,ftemplatetype from ( ");
        builder.append(" select t.fid, t.fnumber, t.fname, t.ftemplatetype from t_rpt_template t  ");
        builder.append("   join t_csl_templetitemlist tl on tl.FTemplateId=t.FId ");
        builder.append("   join t_csl_rptitem item on item.fnumber = tl.fitemnumber ");
        builder.append("   join (select distinct entry.FItemId, entry.FDataElement  ");
        builder.append(" \t\tfrom t_csl_elimTemplet et ");
        builder.append(" \t\tinner join t_csl_elimTempletentry entry on et.FId = entry.FTempletId ");
        builder.append(" \t\twhere et.felimType<>2) elimTmp on elimTmp.FItemId=item.FId and elimTmp.FDataElement=tl.FDataElement ");
        builder.append("  where (t.FIsK3Tpl=0 and (t.FTemplateType=10 or (t.FTemplateType=13 and t.FIsSupportInnerExch=1))) and FVersionStatus=1");
        builder.append(" union all ");
        builder.append(" select t.fid, t.fnumber, t.fname, t.ftemplatetype from t_rpt_template t  ");
        builder.append("   join t_csl_templetitemlist tl on tl.FTemplateId=t.FId ");
        builder.append("   join t_csl_rptitem item on item.fnumber = tl.fitemnumber ");
        builder.append("   join t_csl_dynaItem2ElimItem itemMapping on itemMapping.FElimITemId=item.FId ");
        builder.append("  where (t.FIsK3Tpl=0 and (t.FTemplateType in(10,13))) and FVersionStatus=1 ");
        builder.append(" ) a ");
        builder.append("order by a.ftemplatetype, a.fnumber ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)builder.getSQL(), (Object[])builder.getParams());
        try {
            while (rs.next()) {
                TemplateInfo info = new TemplateInfo();
                info.setId(BOSUuid.read((String)rs.getString("FId")));
                info.setNumber(rs.getString("FNumber"));
                info.setName(rs.getString("FName"));
                info.setTemplateType(RptTmpTypeEnum.getEnum(rs.getInt("FTemplateType")));
                col.add(info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    protected TemplateCollection _getTreeAndPublicTemplate(Context ctx, String companyID) throws BOSException, EASBizException {
        TemplateCollection templates = this._getTreeDispenseData2(ctx, companyID, true, true, false, null, null);
        IRowSet rowSet = this._getRowSetForPublicTemplate(ctx, companyID, Arrays.asList(new Integer(1)), false, false, null);
        try {
            while (rowSet.next()) {
                TemplateInfo info = new TemplateInfo();
                info.setId(BOSUuid.read((String)rowSet.getString("TEMPLATE.ID")));
                info.setNumber(rowSet.getString("TEMPLATE.NUMBER"));
                info.setName(rowSet.getString("TEMPLATE.NAME"));
                info.setTemplateType(RptTmpTypeEnum.getEnum(rowSet.getInt("TEMPLATE.TEMPLATETYPE")));
                info.setVersionNumber(rowSet.getString("VERSIONNUMBER"));
                info.setPeriodType(RptPeriodTypeEnum.getEnum((int)rowSet.getInt("TEMPLATE.PERIODTYPE")));
                info.setGroup(rowSet.getString("TEMPLATE.GROUP"));
                templates.add(info);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return templates;
    }

    @Override
    protected boolean _isHasSpecialDataPerm(Context ctx, String userid, String companyid, String entityBosType, String permitemid, Map paramMap) throws BOSException, EASBizException {
        boolean hasSpecialDataPerm = true;
        try {
            int permtype = 0;
            int ownerexceptpermtype = 0;
            String specialDataPerm = "";
            IRowSet rowSet = this.getPermType(ctx, companyid, entityBosType, permitemid);
            if (!rowSet.next()) {
                return true;
            }
            permtype = rowSet.getInt("permtype");
            specialDataPerm = rowSet.getString("specialDataPerm");
            if (0 == permtype) {
                return true;
            }
            String creatorid = (String)paramMap.get("creatorid");
            String auditorId = (String)paramMap.get("auditorId");
            String lastUpdateUserId = (String)paramMap.get("lastUpdateUserId");
            StringBuffer sql = new StringBuffer();
            sql.append("select FPropertyName from T_PM_OtherOwner \t\n");
            sql.append("where FSPECIALDATAPERMID = ?\t\t\t\t\n");
            sql.append("and FIsOtherOwner = 1\t\t\t\t\t\t\n");
            sql.append("and FObjectType = ? \t\t\t\t\t\t\n");
            sql.append("and FControlUnitID = ?\t\t\t\t\t\t\n");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{specialDataPerm, entityBosType, companyid});
            HashSet<String> ownerSet = new HashSet<String>();
            ownerSet.add(creatorid);
            while (rowSet.next()) {
                String FPropertyName = rowSet.getString("FPropertyName");
                if ("auditor".equals(FPropertyName)) {
                    ownerSet.add(auditorId);
                    continue;
                }
                if (!"lastUpdateUser".equals(FPropertyName)) continue;
                ownerSet.add(lastUpdateUserId);
            }
            sql.setLength(0);
            sql.append(" select ownerexceptpermitem.fpermtype ownerexceptpermtype from t_pm_ownerexceptpermitem  ownerexceptpermitem  \t\t\t\t\t\t\n");
            sql.append(" inner join t_pm_ownerpermexcept ownerpermexcept ");
            sql.append(" on ownerpermexcept.fobjtype = ownerexceptpermitem.fobjtype and ownerpermexcept.fcontrolunitid = ownerexceptpermitem.fcontrolunitid \n");
            sql.append(" where ownerexceptpermitem.fcontrolunitid = ? \t\n");
            sql.append(" and ownerexceptpermitem.fobjtype = ? \t\t\t\n");
            sql.append(" and ownerpermexcept.fuserid = ?\t\t\t\t\n");
            sql.append(" and ownerexceptpermitem.fpermitemid = ? \t\t\n");
            IRowSet ownerExceptRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyid, entityBosType, userid, permitemid});
            if (ownerExceptRowSet.next()) {
                ownerexceptpermtype = ownerExceptRowSet.getInt("ownerexceptpermtype");
            }
            if (10 == permtype) {
                hasSpecialDataPerm = ownerSet.contains(userid) ? true : 10 == ownerexceptpermtype;
            } else if (20 == permtype) {
                hasSpecialDataPerm = 10 == ownerexceptpermtype ? true : (ownerSet.contains(userid) ? false : false);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"isHasSpecialDataPerm", (Throwable)e);
        }
        return hasSpecialDataPerm;
    }

    private IRowSet getPermType(Context ctx, String companyid, String entityBosType, String permitemid) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select datapermentry.fpermtype permtype,datapermentry.FSpecialDataPermID specialDataPerm from t_pm_specialdatapermentry datapermentry \n");
        sql.append("inner join t_pm_specialdataperm  dataperm  on dataperm.fid = datapermentry.fspecialdatapermid \t\t\t\t\n");
        sql.append(" where dataperm.fcontrolunitid = ? and dataperm.fbizobjecttype = ? and dataperm.fisenablecreatorperm = 1 \t\n");
        sql.append(" and datapermentry.fpermitemid = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyid, entityBosType, permitemid});
        return rowSet;
    }

    @Override
    protected void _addForInvestElimMnsTmpl(Context ctx, IObjectValue model) throws BOSException {
    }

    @Override
    protected void _updateForInvestElimMnsTmpl(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException {
    }

    @Override
    protected void _deleteForInvestElimMnsTmpl(Context ctx, IObjectPK pk) throws BOSException {
    }

    @Override
    protected void _auditForInvestElimMnsTmpl(Context ctx, IObjectPK pk) throws BOSException {
    }

    @Override
    protected void _unAuditForInvestElimMnsTmpl(Context ctx, IObjectPK pk) throws BOSException {
    }
}

