/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptCalcException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.ReportBatchCalculatorImpl;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fi.rpt.batch.FormulaValueBackfill;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AcctAcCalculator {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.rpt.batch.AcctAcCalculator");
    private ICalculateContextProvider context;
    private Context ServerCtx = null;
    private List companyOrgList = new ArrayList();
    private List customerList = new ArrayList();
    private List providerList = new ArrayList();
    private List otherList = new ArrayList();
    private List customerSumTotalList = new ArrayList();
    private List providerSumTotalList = new ArrayList();
    private SortedParameterArray acctParams = new SortedParameterArray();
    private List companyOrgAcctList = new ArrayList();
    private List customerAcctList = new ArrayList();
    private List providergAcctList = new ArrayList();
    private List tempAcctList = null;
    private List acctAcList = new ArrayList();
    private Map numberAsstHGAttributeMap = new HashMap();
    private boolean isMergeByFiscalPeriod = false;
    private Map companyIds_Periods = null;
    private BatchHelper batchHelper;

    public AcctAcCalculator(ICalculateContextProvider calContext, Context _serverCtx) {
        this.context = calContext;
        this.ServerCtx = _serverCtx;
        this.batchHelper = new BatchHelper(calContext, _serverCtx);
    }

    public void execute(SortedParameterArray params) {
        try {
            this.initAcctAc(params);
            this.calculateCompanyOrg();
            this.calculateCustomer();
            this.calculateProvider();
            this.calculateOthers();
            this.sumValue();
        }
        catch (Exception e) {
            logger.error((Object)"execute error.", (Throwable)e);
            for (int i = 0; i < params.size(); ++i) {
                FormulaValueBackfill backFill = new FormulaValueBackfill(params.getParameter(i));
                backFill.setException((Throwable)e);
            }
        }
    }

    private void calculateCustomer() throws Exception {
        HashSet<AcctAc> emptyAcctItemList = new HashSet<AcctAc>();
        for (AcctAc acctAc : this.customerList) {
            if (acctAc.arrAcctItems.length > acctAc.orgUnitAssitTypePosition + 1 && !StringUtils.isEmpty((String)acctAc.arrAcctItems[acctAc.orgUnitAssitTypePosition + 1])) continue;
            emptyAcctItemList.add(acctAc);
        }
        HashMap resultMap = new HashMap();
        if (emptyAcctItemList.size() > 0) {
            StringBuffer sql = new StringBuffer();
            sql.append("Select distinct inCompany.Fnumber keyNumber ,CsBase.FNumber Fnumber \n");
            sql.append("From T_BD_Customer CsBase,T_Org_BaseUnit inCompany \n");
            sql.append("Where CsBase.FInternalCompanyID = inCompany.FID \n");
            sql.append("and inCompany.Fnumber in \n");
            HashSet<String> valueList = new HashSet<String>(emptyAcctItemList.size());
            Iterator iterator = emptyAcctItemList.iterator();
            while (iterator.hasNext()) {
                valueList.add(((AcctAc)iterator.next()).destOrgUnit);
            }
            sql.append(this.createInSql(valueList.iterator()));
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ServerCtx, (String)sql.toString());
            while (rowSet.next()) {
                String key = rowSet.getString("keyNumber");
                List<String> list = resultMap.get(key) == null ? new ArrayList() : (List)resultMap.get(key);
                list.add(rowSet.getString("Fnumber"));
                resultMap.put(key, list);
            }
        }
        this.tempAcctList = new ArrayList();
        for (AcctAc acctAc : this.customerList) {
            if (acctAc.isException) {
                this.customerSumTotalList.add(new Integer(0));
                continue;
            }
            if (acctAc.arrAcctItems.length <= acctAc.orgUnitAssitTypePosition + 1 || StringUtils.isEmpty((String)acctAc.arrAcctItems[acctAc.orgUnitAssitTypePosition + 1])) {
                List numberList = (List)resultMap.get(acctAc.destOrgUnit);
                if (numberList != null) {
                    Iterator numbIter = numberList.iterator();
                    while (numbIter.hasNext()) {
                        String tempAcctItem = this.buildAcctItem(acctAc, (String)numbIter.next());
                        ArrayList<Variant> params = new ArrayList<Variant>(8);
                        params.add(new Variant((Object)acctAc.fiOrgUnit));
                        params.add(new Variant((Object)tempAcctItem));
                        params.add(new Variant((Object)acctAc.balanceType));
                        params.add(new Variant(acctAc.startYear));
                        params.add(new Variant(acctAc.startPeriod));
                        params.add(new Variant(acctAc.endYear));
                        params.add(new Variant(acctAc.endPeriod));
                        params.add(new Variant((Object)acctAc.currency));
                        Parameter parameter = new Parameter(params.toArray(), acctAc.getSheetName(), true);
                        this.tempAcctList.add(parameter);
                        this.customerAcctList.add(parameter);
                    }
                    this.customerSumTotalList.add(new Integer(numberList.size()));
                    continue;
                }
                this.customerSumTotalList.add(new Integer(0));
                acctAc.isException = true;
                acctAc.e = new CslRptCalcException(CslRptCalcException.ITEMDATASERVICENOCUSTOMERNUMBER);
                continue;
            }
            ArrayList<Variant> params = new ArrayList<Variant>(8);
            params.add(new Variant((Object)acctAc.fiOrgUnit));
            params.add(new Variant((Object)acctAc.acctItem));
            params.add(new Variant((Object)acctAc.balanceType));
            params.add(new Variant(acctAc.startYear));
            params.add(new Variant(acctAc.startPeriod));
            params.add(new Variant(acctAc.endYear));
            params.add(new Variant(acctAc.endPeriod));
            params.add(new Variant((Object)acctAc.currency));
            Parameter parameter = new Parameter(params.toArray(), acctAc.getSheetName(), true);
            this.tempAcctList.add(parameter);
            this.customerAcctList.add(parameter);
            this.customerSumTotalList.add(new Integer(1));
        }
        if (this.tempAcctList.size() > 0) {
            Object[] parameters = new Parameter[this.tempAcctList.size()];
            for (int i = 0; i < this.tempAcctList.size(); ++i) {
                Parameter parameter = (Parameter)this.tempAcctList.get(i);
                parameters[i] = parameter;
            }
            this.acctParams.insertAll(parameters);
        }
    }

    private String buildAcctItem(AcctAc acctAc, String acctItemNumber) {
        if (acctAc.orgUnitAssitTypePosition >= 0) {
            StringBuffer acctitem = new StringBuffer();
            if (acctAc.orgUnitAssitTypePosition >= acctAc.arrAcctItems.length - 1) {
                acctitem.append(acctAc.acctItem).append("|").append(acctItemNumber);
            } else {
                for (int i = 0; i < acctAc.arrAcctItems.length; ++i) {
                    if (i > 0) {
                        acctitem.append("|");
                    }
                    if (i == acctAc.orgUnitAssitTypePosition + 1) {
                        acctitem.append(acctItemNumber);
                        continue;
                    }
                    acctitem.append(acctAc.arrAcctItems[i]);
                }
            }
            return acctitem.toString();
        }
        return acctAc.acctItem;
    }

    private void calculateProvider() throws Exception {
        HashSet<AcctAc> emptyAcctItemList = new HashSet<AcctAc>();
        for (AcctAc acctAc : this.providerList) {
            if (acctAc.arrAcctItems.length > acctAc.orgUnitAssitTypePosition + 1 && !StringUtils.isEmpty((String)acctAc.arrAcctItems[acctAc.orgUnitAssitTypePosition + 1])) continue;
            emptyAcctItemList.add(acctAc);
        }
        HashMap resultMap = new HashMap();
        if (emptyAcctItemList.size() > 0) {
            StringBuffer sql = new StringBuffer();
            sql.append("Select distinct inCompany.Fnumber keyNumber ,CsBase.FNumber Fnumber \n");
            sql.append("From T_BD_Supplier CsBase,T_Org_BaseUnit inCompany \n");
            sql.append("Where CsBase.FInternalCompanyID = inCompany.FID \n");
            sql.append("and inCompany.Fnumber in \n");
            HashSet<String> valueList = new HashSet<String>(emptyAcctItemList.size());
            Iterator iterator = emptyAcctItemList.iterator();
            while (iterator.hasNext()) {
                valueList.add(((AcctAc)iterator.next()).destOrgUnit);
            }
            sql.append(this.createInSql(valueList.iterator()));
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ServerCtx, (String)sql.toString());
            while (rowSet.next()) {
                String key = rowSet.getString("keyNumber");
                List<String> list = resultMap.get(key) == null ? new ArrayList() : (List)resultMap.get(key);
                list.add(rowSet.getString("Fnumber"));
                resultMap.put(key, list);
            }
        }
        this.tempAcctList = new ArrayList();
        for (AcctAc acctAc : this.providerList) {
            if (acctAc.isException) {
                this.providerSumTotalList.add(new Integer(0));
                continue;
            }
            if (acctAc.arrAcctItems.length <= acctAc.orgUnitAssitTypePosition + 1 || StringUtils.isEmpty((String)acctAc.arrAcctItems[acctAc.orgUnitAssitTypePosition + 1])) {
                List numberList = (List)resultMap.get(acctAc.destOrgUnit);
                if (numberList != null) {
                    Iterator numbIter = numberList.iterator();
                    while (numbIter.hasNext()) {
                        String tempAcctItem = this.buildAcctItem(acctAc, (String)numbIter.next());
                        ArrayList<Variant> params = new ArrayList<Variant>(8);
                        params.add(new Variant((Object)acctAc.fiOrgUnit));
                        params.add(new Variant((Object)tempAcctItem));
                        params.add(new Variant((Object)acctAc.balanceType));
                        params.add(new Variant(acctAc.startYear));
                        params.add(new Variant(acctAc.startPeriod));
                        params.add(new Variant(acctAc.endYear));
                        params.add(new Variant(acctAc.endPeriod));
                        params.add(new Variant((Object)acctAc.currency));
                        Parameter parameter = new Parameter(params.toArray(), acctAc.getSheetName(), true);
                        this.tempAcctList.add(parameter);
                        this.providergAcctList.add(parameter);
                    }
                    this.providerSumTotalList.add(new Integer(numberList.size()));
                    continue;
                }
                this.providerSumTotalList.add(new Integer(0));
                acctAc.isException = true;
                acctAc.e = new CslRptCalcException(CslRptCalcException.ITEMDATASERVICENOCUSTOMERNUMBER);
                continue;
            }
            ArrayList<Variant> params = new ArrayList<Variant>(8);
            params.add(new Variant((Object)acctAc.fiOrgUnit));
            params.add(new Variant((Object)acctAc.acctItem));
            params.add(new Variant((Object)acctAc.balanceType));
            params.add(new Variant(acctAc.startYear));
            params.add(new Variant(acctAc.startPeriod));
            params.add(new Variant(acctAc.endYear));
            params.add(new Variant(acctAc.endPeriod));
            params.add(new Variant((Object)acctAc.currency));
            Parameter parameter = new Parameter(params.toArray(), acctAc.getSheetName(), true);
            this.tempAcctList.add(parameter);
            this.providergAcctList.add(parameter);
            this.providerSumTotalList.add(new Integer(1));
        }
        if (this.tempAcctList.size() > 0) {
            Object[] parameters = new Parameter[this.tempAcctList.size()];
            for (int i = 0; i < this.tempAcctList.size(); ++i) {
                Parameter parameter = (Parameter)this.tempAcctList.get(i);
                parameters[i] = parameter;
            }
            this.acctParams.insertAll(parameters);
        }
    }

    private void calculateOthers() {
        BOSException e = new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"AssitTypeIsNotFilt", (Locale)this.ServerCtx.getOriginLocale()));
        for (AcctAc acctAc : this.otherList) {
            acctAc.isException = true;
            if (acctAc.e != null) continue;
            acctAc.e = e;
        }
    }

    private void calculateCompanyOrg() {
        this.tempAcctList = new ArrayList();
        for (int i = 0; i < this.companyOrgList.size(); ++i) {
            AcctAc acctAc = (AcctAc)this.companyOrgList.get(i);
            if (acctAc.isException) {
                this.companyOrgAcctList.add(new Parameter(null, acctAc.getSheetName()));
                continue;
            }
            ArrayList<Variant> params = new ArrayList<Variant>(8);
            params.add(new Variant((Object)acctAc.fiOrgUnit));
            if (acctAc.arrAcctItems.length <= acctAc.orgUnitAssitTypePosition + 1 || StringUtils.isEmpty((String)acctAc.arrAcctItems[acctAc.orgUnitAssitTypePosition + 1])) {
                acctAc.acctItem = this.buildAcctItem(acctAc, acctAc.destOrgUnit);
            }
            params.add(new Variant((Object)acctAc.acctItem));
            params.add(new Variant((Object)acctAc.balanceType));
            params.add(new Variant(acctAc.startYear));
            params.add(new Variant(acctAc.startPeriod));
            params.add(new Variant(acctAc.endYear));
            params.add(new Variant(acctAc.endPeriod));
            params.add(new Variant((Object)acctAc.currency));
            Parameter parameter = new Parameter(params.toArray(), acctAc.getSheetName(), true);
            this.tempAcctList.add(parameter);
            this.companyOrgAcctList.add(parameter);
        }
        if (this.tempAcctList.size() > 0) {
            Object[] parameters = new Parameter[this.tempAcctList.size()];
            for (int i = 0; i < this.tempAcctList.size(); ++i) {
                Parameter parameter = (Parameter)this.tempAcctList.get(i);
                parameters[i] = parameter;
            }
            this.acctParams.insertAll(parameters);
        }
    }

    private void sumValue() throws Exception {
        ReportBatchCalculatorImpl calculater = new ReportBatchCalculatorImpl();
        ReportVariables reportVariables = this.context.getReportVariables();
        reportVariables.add(new VariableEntry("WILDCARD_EXPAND", null, 1, "false", false));
        calculater.batchMethodQuery(this.context, "acct", this.acctParams);
        this.mergeCompanyOrg();
        this.mergeCustumer();
        this.mergeProvider();
        this.mergeOthers();
    }

    private void mergeOthers() {
        for (int i = 0; i < this.otherList.size(); ++i) {
            AcctAc acctAc = (AcctAc)this.otherList.get(i);
            FormulaValueBackfill err = new FormulaValueBackfill(acctAc.param);
            err.setException((Throwable)acctAc.e);
        }
    }

    private void mergeCompanyOrg() throws Exception {
        for (int i = 0; i < this.companyOrgList.size(); ++i) {
            AcctAc acctAc = (AcctAc)this.companyOrgList.get(i);
            if (acctAc.isException) {
                FormulaValueBackfill err = new FormulaValueBackfill(acctAc.param);
                err.setException((Throwable)acctAc.e);
                continue;
            }
            BigDecimal result = new BigDecimal("0.00");
            Parameter parameter = (Parameter)this.companyOrgAcctList.get(i);
            Object o = parameter.getValue();
            if (o == null) {
                acctAc.param.setValue((Object)result);
                continue;
            }
            try {
                result = new BigDecimal(o.toString());
            }
            catch (Exception e) {
                acctAc.isException = true;
                acctAc.e = new Exception(o.toString());
            }
            if (acctAc.isException) {
                acctAc.param.setValue((Object)acctAc.e.getMessage());
                continue;
            }
            acctAc.param.setValue((Object)result);
        }
    }

    private void mergeProvider() throws Exception {
        int startIndex = 0;
        for (int i = 0; i < this.providerList.size(); ++i) {
            AcctAc acctAc = (AcctAc)this.providerList.get(i);
            if (acctAc.isException) {
                FormulaValueBackfill err = new FormulaValueBackfill(acctAc.param);
                err.setException((Throwable)acctAc.e);
                continue;
            }
            int count = (Integer)this.providerSumTotalList.get(i);
            BigDecimal result = new BigDecimal("0.00");
            int j = 0;
            for (j = startIndex; j < startIndex + count; ++j) {
                Parameter parameter = (Parameter)this.providergAcctList.get(j);
                Object o = parameter.getValue();
                if (o == null) continue;
                BigDecimal bigDecimal = null;
                try {
                    bigDecimal = new BigDecimal(o.toString());
                    result = result.add(bigDecimal);
                    continue;
                }
                catch (Exception e) {
                    acctAc.isException = true;
                    acctAc.e = new Exception(o.toString());
                    j = startIndex + count;
                    break;
                }
            }
            startIndex = j;
            if (acctAc.isException) {
                acctAc.param.setValue((Object)acctAc.e.getMessage());
                continue;
            }
            acctAc.param.setValue((Object)result);
        }
    }

    private void mergeCustumer() throws Exception {
        int startIndex = 0;
        for (int i = 0; i < this.customerList.size(); ++i) {
            AcctAc acctAc = (AcctAc)this.customerList.get(i);
            if (acctAc.isException) {
                FormulaValueBackfill err = new FormulaValueBackfill(acctAc.param);
                err.setException((Throwable)acctAc.e);
                continue;
            }
            int count = (Integer)this.customerSumTotalList.get(i);
            BigDecimal result = new BigDecimal("0.00");
            int j = 0;
            for (j = startIndex; j < startIndex + count; ++j) {
                Parameter parameter = (Parameter)this.customerAcctList.get(j);
                Object o = parameter.getValue();
                if (o == null) continue;
                BigDecimal bigDecimal = null;
                try {
                    bigDecimal = new BigDecimal(o.toString());
                    result = result.add(bigDecimal);
                    continue;
                }
                catch (Exception e) {
                    acctAc.isException = true;
                    acctAc.e = new Exception(o.toString());
                    j = startIndex + count;
                    break;
                }
            }
            if (acctAc.isException) {
                acctAc.param.setValue((Object)acctAc.e.getMessage());
            } else {
                acctAc.param.setValue((Object)result);
            }
            startIndex = j;
        }
    }

    private void initAcctAc(SortedParameterArray params) throws Exception {
        for (int i = 0; i < params.size(); ++i) {
            Parameter param = params.getParameter(i);
            AcctAc ac = new AcctAc(param);
            ac.initParam();
            if (!ac.isException) {
                for (int index = 1; index < ac.arrAcctItems.length; index += 2) {
                    this.numberAsstHGAttributeMap.put(ac.arrAcctItems[index], null);
                }
            }
            this.acctAcList.add(ac);
        }
        if (this.acctAcList.size() < 1) {
            return;
        }
        this.initYearAndPeriod();
        this.iniAsstActTypeMap();
        this.groupParamsByAsstHGAttribute();
    }

    private void initYearAndPeriod() throws Exception {
        HashSet<String> companyNumberSet = new HashSet<String>();
        this.isMergeByFiscalPeriod = CslRptUtil.isMergeByFiscalPeriod((Context)this.ServerCtx);
        for (AcctAc acctAc : this.acctAcList) {
            if (acctAc.isException || companyNumberSet.contains(acctAc.fiOrgUnit)) continue;
            companyNumberSet.add(acctAc.fiOrgUnit);
        }
        if (companyNumberSet.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("Select FID,FNumber from T_ORG_Company where Fnumber in ");
        sql.append(this.createInSql(companyNumberSet.iterator()));
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ServerCtx, (String)sql.toString());
        HashMap<String, String> companyNumberIdMap = new HashMap<String, String>();
        ArrayList<String> companyIds = new ArrayList<String>();
        while (rowSet.next()) {
            companyNumberIdMap.put(rowSet.getString("FNumber"), rowSet.getString("FID"));
            companyIds.add(rowSet.getString("FID"));
        }
        this.companyIds_Periods = FiscalPeriodHelper.getPeriodCollectionsByCompanyIds((Context)this.ServerCtx, companyIds);
        for (AcctAc acctAc : this.acctAcList) {
            this.exchageYearAndPeriod(acctAc, companyNumberIdMap);
        }
    }

    private void exchageYearAndPeriod(AcctAc acctAc, Map companyNumberIdMap) throws BOSException, EASBizException {
        int[] start;
        int rptYear = acctAc.getReport_Year();
        int rptPeriod = acctAc.getReport_Period();
        String companyId = (String)companyNumberIdMap.get(acctAc.fiOrgUnit);
        if (companyId == null) {
            acctAc.setException((Exception)((Object)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"24_AcctAcCalculator", (Locale)this.ServerCtx.getOriginLocale()) + acctAc.fiOrgUnit})));
        }
        if ((start = RPTDateUtil.getYearAndPeriod((boolean)true, (Context)this.ServerCtx, (int)acctAc.startYear, (int)acctAc.startPeriod, (String)acctAc.param.getSheetName(), (ReportVariables)this.context.getReportVariables(), (IReportPropertyAdapter)this.context.getReportAdapter(), (String)companyId, (PeriodCollection)((PeriodCollection)this.companyIds_Periods.get(companyId)), (boolean)this.isMergeByFiscalPeriod)) == null) {
            acctAc.startYear = rptYear;
            acctAc.startPeriod = rptPeriod;
        } else {
            acctAc.startYear = start[0];
            acctAc.startPeriod = start[1];
        }
        int[] end = RPTDateUtil.getYearAndPeriod((boolean)false, (Context)this.ServerCtx, (int)acctAc.endYear, (int)acctAc.endPeriod, (String)acctAc.param.getSheetName(), (ReportVariables)this.context.getReportVariables(), (IReportPropertyAdapter)this.context.getReportAdapter(), (String)companyId, (PeriodCollection)((PeriodCollection)this.companyIds_Periods.get(companyId)), (boolean)this.isMergeByFiscalPeriod);
        if (end == null) {
            acctAc.endYear = rptYear;
            acctAc.endPeriod = rptPeriod;
        } else {
            acctAc.endYear = end[0];
            acctAc.endPeriod = end[1];
        }
    }

    private void groupParamsByAsstHGAttribute() {
        for (AcctAc param : this.acctAcList) {
            if (param.isException) {
                this.otherList.add(param);
                continue;
            }
            int index = 1;
            int firstIndex = -1;
            List firstList = null;
            List tmpList = null;
            boolean isFind = false;
            while (index < param.arrAcctItems.length) {
                String asstHGAttribute = (String)this.numberAsstHGAttributeMap.get(param.arrAcctItems[index]);
                if ("companyOrg".equalsIgnoreCase(asstHGAttribute)) {
                    tmpList = this.companyOrgList;
                } else if ("customer".equalsIgnoreCase(asstHGAttribute)) {
                    tmpList = this.customerList;
                } else if ("provider".equalsIgnoreCase(asstHGAttribute)) {
                    tmpList = this.providerList;
                }
                if (firstList == null) {
                    firstList = tmpList;
                }
                if (tmpList != null) {
                    if (param.arrAcctItems.length <= index + 1 || StringUtils.isEmpty((String)param.arrAcctItems[index + 1])) {
                        param.orgUnitAssitTypePosition = index;
                        index += 2;
                        tmpList.add(param);
                        isFind = true;
                        break;
                    }
                    firstIndex = index;
                    index += 2;
                    continue;
                }
                index += 2;
            }
            if (isFind) continue;
            if (firstList != null) {
                param.orgUnitAssitTypePosition = firstIndex;
                firstList.add(param);
                continue;
            }
            this.otherList.add(param);
        }
    }

    private Map iniAsstActTypeMap() throws Exception {
        Set numbers = this.numberAsstHGAttributeMap.keySet();
        if (numbers.size() == 0) {
            return this.numberAsstHGAttributeMap;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select FNumber,FAsstHGAttribute from T_BD_AsstActType where FNumber in \n");
        sql.append(this.createInSql(numbers.iterator()));
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ServerCtx, (String)sql.toString());
        while (rowSet.next()) {
            this.numberAsstHGAttributeMap.put(rowSet.getString("FNumber"), rowSet.getString("FAsstHGAttribute"));
        }
        return this.numberAsstHGAttributeMap;
    }

    private String createInSql(Iterator iterator) throws Exception {
        if (!iterator.hasNext()) {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"25_AcctAcCalculator", (Locale)this.ServerCtx.getOriginLocale()));
        }
        boolean first = true;
        StringBuffer sql = new StringBuffer("(");
        while (iterator.hasNext()) {
            if (first) {
                sql.append(" '").append(iterator.next()).append("' ");
                first = false;
                continue;
            }
            sql.append(" ,'").append(iterator.next()).append("' ");
        }
        sql.append(")");
        return sql.toString();
    }

    class AcctAc {
        BigDecimal acctValue = null;
        Parameter param = null;
        Exception e;
        boolean isException = false;
        private String fiOrgUnit;
        private String orgUnit;
        private String destOrgUnit;
        private String acctItem;
        private String balanceType;
        private int startYear;
        private int startPeriod;
        private int endYear;
        private int endPeriod;
        private String currency;
        private boolean includeUnposted;
        private String[] arrAcctItems;
        private int orgUnitAssitTypePosition = -1;

        public BigDecimal getValue() {
            return null;
        }

        public AcctAc(Parameter param) {
            this.param = param;
        }

        public void setException(Exception e) {
            this.isException = true;
            this.e = e;
        }

        public void initParam() {
            try {
                Object[] args = this.param.getArgs();
                this.orgUnit = ((Variant)args[0]).getValue() == null ? null : ((Variant)args[0]).getValue().toString();
                this.destOrgUnit = ((Variant)args[1]).getValue() == null ? null : ((Variant)args[1]).getValue().toString();
                this.acctItem = ((Variant)args[2]).getValue() == null ? null : ((Variant)args[2]).getValue().toString();
                this.balanceType = ((Variant)args[3]).getValue() == null ? null : ((Variant)args[3]).getValue().toString();
                this.startYear = Integer.parseInt(((Variant)args[4]).getValue().toString());
                this.startPeriod = Integer.parseInt(((Variant)args[5]).getValue().toString());
                this.endYear = Integer.parseInt(((Variant)args[6]).getValue().toString());
                this.endPeriod = Integer.parseInt(((Variant)args[7]).getValue().toString());
                String string = this.currency = ((Variant)args[8]).getValue() == null ? null : ((Variant)args[8]).getValue().toString();
                if (StringUtils.isEmpty((String)this.orgUnit)) {
                    this.orgUnit = this.getCompany_Number();
                }
                this.fiOrgUnit = AcctAcCalculator.this.batchHelper.convertFIOrgUnit(this.orgUnit);
                if (StringUtils.isEmpty((String)this.fiOrgUnit)) {
                    throw new ReportException(ReportException.FIND_COMPANY_ERROR);
                }
                AcctAcCalculator.this.batchHelper.checkCompanyPermision(this.orgUnit);
                if (StringUtils.isEmpty((String)this.currency)) {
                    this.currency = this.getCorrect_Currency_Number();
                }
                this.includeUnposted = AcctAcCalculator.this.context.getReportVariables().getBoolValue("IncludePosted", this.param.getSheetName(), false);
                if (StringUtils.isEmpty((String)this.fiOrgUnit)) {
                    throw new CslRptCalcException(CslRptCalcException.SOURCE_COMPANY_IS_EMPTY);
                }
                if (StringUtils.isEmpty((String)this.destOrgUnit)) {
                    throw new CslRptCalcException(CslRptCalcException.DEST_COMPANY_IS_EMPTY);
                }
                if (StringUtils.isEmpty((String)this.acctItem)) {
                    throw new CslRptCalcException(CslRptCalcException.ACCT_AND_ITEM_IS_EMPTY);
                }
                this.arrAcctItems = StringUtils.split((String)this.acctItem.trim(), (String)"|");
                if (this.arrAcctItems.length <= 1) {
                    String[] nullArrAcctItems = new String[]{this.acctItem, "null"};
                    this.arrAcctItems = nullArrAcctItems;
                    throw new CslRptCalcException(CslRptCalcException.ACCT_AND_ITEM_IS_EMPTY);
                }
                if (this.arrAcctItems.length < 3) {
                    String[] temp = new String[3];
                    System.arraycopy(this.arrAcctItems, 0, temp, 0, this.arrAcctItems.length);
                    this.arrAcctItems = temp;
                }
                if (StringUtils.isEmpty((String)this.balanceType)) {
                    throw new CslRptCalcException(CslRptCalcException.BALANCE_TYPE_IS_EMPTY);
                }
            }
            catch (NumberFormatException e) {
                this.setException(e);
            }
            catch (EASBizException e) {
                this.setException((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.setException((Exception)((Object)e));
            }
        }

        private String getCompany_Number() {
            return (String)AcctAcCalculator.this.context.getReportAdapter().getReportProperty("Company.Number");
        }

        private int getReport_Year() {
            return (Integer)AcctAcCalculator.this.context.getReportAdapter().getReportProperty("Report.Year");
        }

        private int getReport_Period() {
            return (Integer)AcctAcCalculator.this.context.getReportAdapter().getReportProperty("Report.Period");
        }

        private String getCorrect_Currency_Number() {
            String currency = AcctAcCalculator.this.context.getReportVariables().getStringValue("Currency", this.param.getSheetName());
            if (StringUtils.isEmpty((String)currency)) {
                currency = (String)AcctAcCalculator.this.context.getReportAdapter().getReportProperty("Currency.Number");
            }
            return currency;
        }

        public String getSheetName() {
            return this.param.getSheetName();
        }

        public int hashCode() {
            return this.fiOrgUnit.hashCode() * 19 + this.destOrgUnit.hashCode() * 17 + this.acctItem.hashCode() * 13 + this.balanceType.hashCode() * 11 + this.startYear * 7 + this.endYear * 5 + this.endPeriod * 3 + this.currency.hashCode();
        }
    }
}

