/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.AcctFormula;

import com.kingdee.eas.fi.rpt.app.AcctCalculaterExt;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.AcctQueryObject;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.AcctSubQuerySolution;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.ResourceMaping;
import com.kingdee.eas.fi.rpt.batchquery.sql.SelectFieldCollection;
import com.kingdee.eas.fi.rpt.batchquery.sql.WhereItem;
import com.kingdee.eas.fi.rpt.batchquery.sql.WhereItems;
import java.sql.Connection;

public class AcctBDBSubQuerySolution
extends AcctSubQuerySolution {
    public AcctBDBSubQuerySolution(Connection _conn) {
        super(_conn);
        this.resourceMaping = ResourceMaping.createNoDetailModeMap();
    }

    @Override
    public String configFromPart() {
        return this.BalTableName + " A_Bal inner join T_BD_AccountView A_Acct on A_Bal.FAccountID=A_Acct.FID  ";
    }

    @Override
    public boolean configAutoItemIsNeedGroupBy() {
        return true;
    }

    @Override
    public WhereItems configStaticWherePart() {
        WhereItems ws = super.configStaticWherePart();
        ws.addItem(new WhereItem(" (A_Acct.FCAA IS NULL) "));
        return ws;
    }

    @Override
    public void add(AcctCalculaterExt acct) throws Exception {
        if (this.flag) {
            this.flag = false;
            this.BalTableName = acct.getBalTableNameWithNoAsst();
            this.FOrgUnitID = acct.getCompany().getId().toString();
            this.FCurrencyID = acct.getCurrency().getId().toString();
            this.FPeriodID = acct.getStrPeriodID();
            this.FBalType = acct.getIBalType();
            this.defaultValue = acct.getCurrency().get("_DPV");
        }
        acct.setDefaultACCTValue(this.defaultValue);
        this.configQueryObjectToSolution(new AcctQueryObjectBDB(acct));
    }

    private class AcctQueryObjectBDB
    extends AcctQueryObject {
        public AcctQueryObjectBDB(AcctCalculaterExt acct) {
            super(acct);
        }

        @Override
        public WhereItems configWhereItems() {
            WhereItems wis = new WhereItems();
            wis.addItem(new WhereItem("A_Acct.FNumber", this.acct.getAccountItem().startAccount.account.number, 1));
            wis.addItem(new WhereItem("A_Acct.FLevel", this.acct.getAccountItem().startAccount.account.level + 1));
            String accountTableId = this.acct.getAccountItem().startAccount.getCompany().getAccountTable().getId().toString();
            wis.addItem(new WhereItem("A_Acct.faccounttableid", accountTableId));
            return wis;
        }

        @Override
        public SelectFieldCollection configSelectFields() {
            SelectFieldCollection sc = new SelectFieldCollection();
            sc.addSelectField(AcctBDBSubQuerySolution.this.resourceMaping.lookUpSelectField(this.acct.getBalanceType().getName(), this));
            return sc;
        }

        @Override
        public void fillValueList(Object[] objList) {
            this.acct.setACCTValue(objList[0]);
        }
    }
}

