/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.AcctFormula.comm;

import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.util.DBUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.app.AcctCalculaterExt;
import com.kingdee.eas.util.client.EASResource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AccrualPermissionQuerySolution {
    private static final int PARAM_BATCH_SIZE = 150;
    private final Connection connection;
    private Map subCompany;
    private Map noPermissionCompanyMap;
    private List acctCalcList;

    public AccrualPermissionQuerySolution(Connection connection) {
        this.connection = connection;
        this.subCompany = new HashMap();
        this.noPermissionCompanyMap = new HashMap();
        this.acctCalcList = new ArrayList();
    }

    public void add(AcctCalculaterExt acctCalc) {
        CompanyOrgUnitInfo companyOrgUnitInfo = acctCalc.getCompany();
        ArrayList<AcctCalculaterExt> acctCalcExtList = (ArrayList<AcctCalculaterExt>)this.subCompany.get(companyOrgUnitInfo.getNumber());
        if (acctCalcExtList == null) {
            acctCalcExtList = new ArrayList<AcctCalculaterExt>();
            this.subCompany.put(companyOrgUnitInfo.getNumber(), acctCalcExtList);
        }
        acctCalcExtList.add(acctCalc);
        this.acctCalcList.add(acctCalc);
    }

    public void executeCheckPermissionService(Map userPermissionOrgsMap) throws Exception {
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT super.fnumber superNumber,sub.FNumber subNumber   \n");
        sql.append(" FROM T_ORG_Company super INNER JOIN T_ORG_Company sub    \n");
        sql.append(" ON CHARINDEX(super.flongnumber,sub.FLongnumber)=1        \n");
        sql.append(" WHERE sub.FIsbizunit = 1 AND super.FNumber IN            \n");
        int paramCount = 1;
        boolean isFirst = true;
        StringBuffer inKqlBuffer = new StringBuffer();
        ArrayList paramList = new ArrayList();
        Iterator it = this.subCompany.keySet().iterator();
        while (it.hasNext()) {
            if (isFirst) {
                isFirst = false;
            } else {
                inKqlBuffer.append(',');
            }
            inKqlBuffer.append('?');
            paramList.add(it.next());
            if (++paramCount <= 150 && it.hasNext()) continue;
            StringBuffer kqlBuffer = new StringBuffer();
            kqlBuffer.append(sql);
            kqlBuffer.append('(');
            kqlBuffer.append(inKqlBuffer);
            kqlBuffer.append(')');
            try {
                stmt = this.connection.prepareStatement(kqlBuffer.toString());
                for (int i = 0; i < paramList.size(); ++i) {
                    String acctId = (String)paramList.get(i);
                    stmt.setObject(i + 1, acctId);
                }
                resultSet = stmt.executeQuery();
                while (resultSet.next()) {
                    String superNumber = resultSet.getString("superNumber");
                    String subNumber = resultSet.getString("subNumber");
                    if (userPermissionOrgsMap.containsKey(subNumber)) continue;
                    ArrayList<String> noPermissionCompanyList = (ArrayList<String>)this.noPermissionCompanyMap.get(superNumber);
                    if (noPermissionCompanyList == null) {
                        noPermissionCompanyList = new ArrayList<String>();
                        this.noPermissionCompanyMap.put(superNumber, noPermissionCompanyList);
                    }
                    noPermissionCompanyList.add(subNumber);
                }
            }
            catch (SQLException e) {
                try {
                    throw new SQLDataException(e);
                }
                catch (Throwable throwable) {
                    DBUtil.closeResultSet(resultSet);
                    DBUtil.closeStatement((Statement)stmt);
                    throw throwable;
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            DBUtil.closeStatement((Statement)stmt);
            isFirst = true;
            paramCount = 1;
            paramList.clear();
            inKqlBuffer.delete(0, inKqlBuffer.length());
        }
        for (String supperNumber : this.noPermissionCompanyMap.keySet()) {
            StringBuffer noPermissionOrgsBuffer = new StringBuffer();
            List noPermissionOrgsList = (List)this.noPermissionCompanyMap.get(supperNumber);
            if (noPermissionOrgsList == null) continue;
            Iterator it1 = noPermissionOrgsList.iterator();
            while (it1.hasNext()) {
                noPermissionOrgsBuffer.append(it1.next());
                if (!it1.hasNext()) continue;
                noPermissionOrgsBuffer.append(",");
            }
            List acctCalcExtList = (List)this.subCompany.get(supperNumber);
            if (acctCalcExtList == null) continue;
            String msg = null;
            for (AcctCalculaterExt acctCalc : acctCalcExtList) {
                this.acctCalcList.remove(acctCalc);
                msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"73_AccrualPermissionQuerySolution");
                acctCalc.setACCTValue((Object)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{MessageFormat.format(msg, noPermissionOrgsBuffer.toString())}));
            }
        }
    }

    public List getAcctCalcList() {
        return this.acctCalcList;
    }

    public void setAcctCalcList(List acctCalcList) {
        this.acctCalcList = acctCalcList;
    }
}

