/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.AcctFormula.comm;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.DBUtil;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ColumnInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.TableInfo;
import com.kingdee.eas.fi.rpt.app.Account;
import com.kingdee.eas.fi.rpt.app.AccountItemExt;
import com.kingdee.eas.fi.rpt.app.AcctCalculaterExt;
import com.kingdee.eas.fi.rpt.app.AsstActType;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DetailItemQueryByAccount {
    public static final int LEAF = 101;
    public static final int SUB = 102;
    private static final String SQL = "SELECT DISTINCT superAccount.fid FAccountID,                                         \nCASE WHEN account.FIsLeaf = 0 THEN NULL ELSE item.Fnumber END FNumber,                                           \nCASE WHEN account.FIsLeaf = 0 THEN NULL ELSE item.frealtiondataobject END FTableName,                            \nCASE WHEN account.FIsLeaf = 0 THEN NULL ELSE item.fmappingfieldname  END FFieldName,                             \nCASE WHEN account.FIsLeaf = 0 THEN NULL ELSE item.FGLAsstActTypeGrpID END FGlAsstActTypeGrpID,                   \nCASE WHEN account.FIsLeaf = 0 THEN NULL ELSE item.FGroupTableName END FGroupTableName,                           \nCASE WHEN account.FIsLeaf = 0 THEN NULL ELSE item.FGroupMappingFieldName END FGroupMappingFieldName,             \nCASE WHEN item.Fnumber IS NOT NULL AND account.FIsLeaf = 1 THEN NULL ELSE account.FID END SubAccountID,          \nCASE WHEN item.Fnumber IS NOT NULL AND account.FIsLeaf = 1 THEN NULL ELSE account.FNumber END SubAccountNumber,  \nCASE WHEN item.Fnumber IS NOT NULL AND account.FIsLeaf = 1 THEN NULL ELSE account.FLevel END SubAccountLevel     \nFROM T_BD_AccountView superAccount                                                                               \nINNER JOIN T_BD_AccountView account ON account.FLongNumber like concat(superAccount.FLongNumber, '!%')        \nAND superAccount.FCompanyID = account.FCompanyID AND superAccount.FAccountTableID = account.FAccountTableID      \nLEFT JOIN T_BD_AsstAccount book ON account.FCaa = book.FID                                                       \nLEFT JOIN T_BD_AsstActGroupDetail rel ON book.FID = rel.FasstAccountID                                           \nLEFT JOIN T_BD_AsstActType item ON item.FID = rel.FasstActTypeID                        \n";
    private Map leafMap;
    private Map subMap;
    private List addedFormulas;
    private final Connection _conn;
    private final Context _ctx;
    private static final int PARAM_BATCH_SIZE = 200;

    public DetailItemQueryByAccount(Connection conn, Context ctx) {
        this._conn = conn;
        this._ctx = ctx;
        this.leafMap = new HashMap();
        this.subMap = new HashMap();
    }

    public void add(AcctCalculaterExt acct, int leafOrSub) {
        AccountItemExt account = acct.getAccountItem();
        if (account == null || account.startAccount == null || account.startAccount.account == null || account.startAccount.account.id == null) {
            return;
        }
        Map map = null;
        if (leafOrSub == 101) {
            map = this.leafMap;
        } else if (leafOrSub == 102) {
            map = this.subMap;
        }
        if (map != null) {
            ArrayList<AcctCalculaterExt> object = (ArrayList<AcctCalculaterExt>)map.get(account.startAccount.account.id);
            if (object == null) {
                object = new ArrayList<AcctCalculaterExt>();
                map.put(account.startAccount.account.id, object);
            }
            object.add(acct);
        }
    }

    public void execute() throws Exception {
        this.execute(101);
        this.execute(102);
    }

    private ParamTempTblService getTempTblService(Context ctx, Collection ids) {
        TableInfo table = new TableInfo("t_temp_account");
        table.addColumn(new ColumnInfo("Fid", "varchar(44)"));
        ParamTempTblService service = ParamTempTblService.getInstance((Context)ctx, (TableInfo)table, (Collection)ids, null);
        return service;
    }

    private Set getParams(Map map) {
        HashSet<String> result = new HashSet<String>();
        for (String accountid : map.keySet()) {
            result.add(accountid);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(int type) throws Exception {
        String accountID;
        ResultSet resultSet;
        PreparedStatement stmt;
        ParamTempTblService srv;
        Map map;
        block16: {
            map = null;
            String sql = null;
            if (type == 101) {
                map = this.leafMap;
                sql = " Where account.FIsLeaf  = 1 ";
            } else if (type == 102) {
                map = this.subMap;
                sql = " Where account.FLevel = superAccount.FLevel + 1 ";
            }
            if (map == null || map.keySet().size() < 1) {
                return;
            }
            srv = this.getTempTblService(this._ctx, this.getParams(map));
            String tblName = srv.getTmpTableName();
            String innerSql = "inner join " + tblName + " temp on superAccount.Fid = temp.Fid ";
            StringBuffer inKqlBuffer = new StringBuffer();
            stmt = null;
            resultSet = null;
            ArrayList paramList = new ArrayList();
            StringBuffer kqlBuffer = new StringBuffer();
            kqlBuffer.append(SQL);
            kqlBuffer.append(innerSql);
            kqlBuffer.append(sql);
            stmt = this._conn.prepareStatement(kqlBuffer.toString(), 1004, 1007);
            resultSet = stmt.executeQuery();
            HashSet<String> removeSet = new HashSet<String>();
            HashSet<String> confirmSet = new HashSet<String>();
            while (resultSet.next()) {
                accountID = resultSet.getString("FAccountID");
                String subAccountID = resultSet.getString("SubAccountID");
                if (StringUtils.isEmpty((String)subAccountID)) {
                    confirmSet.add(accountID);
                    continue;
                }
                removeSet.add(accountID);
            }
            removeSet.removeAll(confirmSet);
            for (String accountID2 : removeSet) {
                map.remove(accountID2);
            }
            if (map.size() != 0) break block16;
            srv.release();
            DBUtil.closeResultSet((ResultSet)resultSet);
            DBUtil.closeStatement((Statement)stmt);
            return;
        }
        try {
            resultSet.beforeFirst();
            while (resultSet.next()) {
                accountID = resultSet.getString("SubAccountID");
                if (!StringUtils.isEmpty((String)accountID)) {
                    String acct = resultSet.getString("FAccountID");
                    List lst = (List)map.get(acct);
                    if (lst == null) continue;
                    for (int i = 0; i < lst.size(); ++i) {
                        if (this.addedFormulas == null) {
                            this.addedFormulas = new ArrayList();
                        }
                        AcctCalculaterExt acctParam = (AcctCalculaterExt)lst.get(i);
                        AcctCalculaterExt newAcct = new AcctCalculaterExt(acctParam.getStruct().copy(), acctParam.getStruct().getBackFiller());
                        newAcct.getStruct().setAccountItem(resultSet.getString("SubAccountNumber"));
                        newAcct.setAccountItem(new AccountItemExt(newAcct.getStruct().getAccountItem(), acctParam.getCompany()));
                        newAcct.getAccountItem().startAccount.account = new Account();
                        newAcct.getAccountItem().startAccount.account.number = newAcct.getStruct().getAccountItem();
                        newAcct.getAccountItem().startAccount.account.id = accountID;
                        newAcct.getAccountItem().startAccount.account.isLeaf = true;
                        newAcct.getAccountItem().startAccount.account.level = resultSet.getInt("SubAccountLevel");
                        newAcct.getAccountItem().endAccount.account = newAcct.getAccountItem().startAccount.account;
                        newAcct.setCompany(acctParam.getCompany());
                        newAcct.setStrPeriodID(acctParam.getStrPeriodID());
                        newAcct.setCurrency(acctParam.getCurrency());
                        newAcct.setAccountTable(acctParam.getAccountTable());
                        newAcct.setCorrectAccountTable(acctParam.isCorrectAccountTable());
                        newAcct.setiStartYear(acctParam.getIStartYear());
                        newAcct.setiStartPeriod(acctParam.getIStartPeriod());
                        newAcct.setIEndYear(acctParam.getIEndYear());
                        newAcct.setIEndPeriod(acctParam.getIEndPeriod());
                        newAcct.getStruct().setOrgType(acctParam.getOrgType());
                        this.addedFormulas.add(newAcct);
                    }
                    continue;
                }
                AsstActType asstActType = new AsstActType();
                asstActType.mappingFieldName = resultSet.getString("FFieldName");
                asstActType.number = resultSet.getString("FNumber");
                asstActType.realtionDataObject = resultSet.getString("FTableName");
                asstActType.glAsstActTypeGrpID = resultSet.getString("FGlAsstActTypeGrpID");
                asstActType.groupTableName = resultSet.getString("FGroupTableName");
                asstActType.groupMappingFieldName = resultSet.getString("FGroupMappingFieldName");
                String acct = resultSet.getString("FAccountID");
                List lst = (List)map.get(acct);
                if (lst == null) continue;
                for (int i = 0; i < lst.size(); ++i) {
                    AcctCalculaterExt acctParam = (AcctCalculaterExt)lst.get(i);
                    AccountItemExt account = acctParam.getAccountItem();
                    ArrayList<AsstActType> itemTypes = account.getSynedDetailAsstActTypes();
                    if (itemTypes == null) {
                        itemTypes = new ArrayList<AsstActType>();
                        account.setSynedDetailAsstActTypes(itemTypes);
                    }
                    itemTypes.add(asstActType);
                }
            }
        }
        catch (Throwable throwable) {
            srv.release();
            DBUtil.closeResultSet(resultSet);
            DBUtil.closeStatement(stmt);
            throw throwable;
        }
        srv.release();
        DBUtil.closeResultSet((ResultSet)resultSet);
        DBUtil.closeStatement((Statement)stmt);
    }

    public List getAddedFormulas() {
        return this.addedFormulas;
    }
}

