/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.AcctFormula.comm;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.fi.rpt.app.AssistantGroup;
import com.kingdee.eas.fi.rpt.batchquery.IQueryObject;
import com.kingdee.eas.fi.rpt.batchquery.Solution;
import com.kingdee.eas.fi.rpt.batchquery.sql.SelectFieldCollection;
import com.kingdee.eas.fi.rpt.batchquery.sql.WhereItems;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MaterialGroupStandardQuery
extends Solution {
    private Context serverCtx;
    private Map container = new HashMap();
    private final Connection _conn;

    public void setContext(Context ctx) {
        this.serverCtx = ctx;
    }

    public MaterialGroupStandardQuery(Connection _conn) {
        super(_conn);
        this._conn = _conn;
    }

    @Override
    public boolean configAutoItemIsNeedGroupBy() {
        return false;
    }

    @Override
    public String configFromPart() {
        return null;
    }

    @Override
    public WhereItems configStaticWherePart() {
        return null;
    }

    @Override
    public void exec() throws SQLException, Exception {
        MaterialGroupStandardCollection coll = MaterialGroupStandardFactory.getLocalInstance((Context)this.serverCtx).getMaterialGroupStandardCollection();
        if (coll == null || coll.size() < 1) {
            return;
        }
        for (int i = 0; i < coll.size(); ++i) {
            MaterialGroupStandardInfo info = coll.get(i);
            String number = info.getNumber();
            List subset = (List)this.container.get(number);
            if (subset == null) continue;
            for (int j = 0; j < subset.size(); ++j) {
                ((IQueryObject)subset.get(j)).fillValueObject(info);
            }
        }
    }

    public void add(AssistantGroup g) {
        try {
            this.configQueryObjectToSolution(new MyHolder(g));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void configQueryObjectToSolution(IQueryObject queryObject) throws Exception {
        String[] fields = queryObject.getOrderedSelectedFields();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < fields.length; ++i) {
            sb.append(fields[i]);
        }
        String toString = sb.toString();
        ArrayList<IQueryObject> subset = (ArrayList<IQueryObject>)this.container.get(toString);
        if (subset == null) {
            subset = new ArrayList<IQueryObject>();
        }
        subset.add(queryObject);
        this.container.put(toString, subset);
    }

    class MyHolder
    extends IQueryObject {
        private final AssistantGroup node;

        public MyHolder(AssistantGroup node) {
            this.node = node;
        }

        @Override
        public String[] getOrderedSelectedFields() {
            if (this.node.standardType == 1) {
                this.node.setStandardNumber("BaseGroupStandard");
            }
            return new String[]{this.node.getStandardNumber()};
        }

        @Override
        public SelectFieldCollection configSelectFields() {
            return null;
        }

        @Override
        public WhereItems configWhereItems() {
            return null;
        }

        @Override
        public void fillValueList(Object[] objList) {
        }

        @Override
        public void fillValueObject(Object value) {
            MaterialGroupStandardInfo info = (MaterialGroupStandardInfo)value;
            this.node.standardID = info.getId().toString();
            this.node.standardNumber = info.getNumber();
            this.node.standardType = info.getStandardType().getValue();
        }
    }
}

