/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.AcctFormula.comm;

import com.kingdee.eas.fi.rpt.app.Account;
import com.kingdee.eas.fi.rpt.app.AccountExt;
import com.kingdee.eas.fi.rpt.batchquery.IObjectBulider;
import com.kingdee.eas.fi.rpt.batchquery.IQueryObject;
import com.kingdee.eas.fi.rpt.batchquery.Solution;
import com.kingdee.eas.fi.rpt.batchquery.sql.SelectField;
import com.kingdee.eas.fi.rpt.batchquery.sql.SelectFieldCollection;
import com.kingdee.eas.fi.rpt.batchquery.sql.WhereItem;
import com.kingdee.eas.fi.rpt.batchquery.sql.WhereItems;
import java.sql.Connection;
import java.util.Map;

public class TailAccountSubQuerySolution
extends Solution {
    private Map accountCache;
    private static final int WHERE_SIZE = 50;
    private String accountTableId;
    private String[] companyLongNumberSplit;
    private boolean flag = true;

    public TailAccountSubQuerySolution(Connection _conn) {
        super(_conn);
        this.getQueryManager().setWhereSize(50);
    }

    @Override
    public WhereItems configStaticWherePart() {
        WhereItems ws = new WhereItems();
        ws.addItem("V.FAccountTableID", this.accountTableId);
        WhereItem item = new WhereItem("O.FLongNumber", this.companyLongNumberSplit, 6);
        ws.addItem(item);
        return ws;
    }

    @Override
    public String configFromPart() {
        return "T_Bd_AccountView V inner join T_ORG_Company O on V.FCompanyID = O.FID";
    }

    @Override
    public IObjectBulider configDefaultObjectBuilder() {
        return new ObjectBulider();
    }

    @Override
    public boolean configAutoItemIsNeedGroupBy() {
        return true;
    }

    public void add(AccountExt account) throws Exception {
        if (this.flag) {
            this.flag = false;
            this.accountTableId = account.getAccountTable().getId().toString();
            String companylongNumber = null;
            companylongNumber = account.getCompany().isIsProfitOrgUnit() && account.getCompany().get("DELEGATED_COMPANY_LONG_NUMBER") instanceof String ? (String)account.getCompany().get("DELEGATED_COMPANY_LONG_NUMBER") : account.getCompany().getLongNumber();
            this.companyLongNumberSplit = TailAccountSubQuerySolution.getCompanyLongNumber(companylongNumber);
        }
        this.configQueryObjectToSolution(new AccountQueryObject(account));
    }

    private static final String[] getCompanyLongNumber(String sx) {
        String[] x = sx.split("!");
        String[] companyLongNumberSplit = new String[x.length];
        for (int i = 0; i < x.length; ++i) {
            String s = "";
            for (int j = 0; j <= i; ++j) {
                if (j != 0) {
                    s = s + '!';
                }
                s = s + x[j];
            }
            companyLongNumberSplit[i] = s;
        }
        return companyLongNumberSplit;
    }

    public void setAccountCache(Map accountCache) {
        this.accountCache = accountCache;
    }

    class AccountQueryObject
    extends IQueryObject {
        private AccountExt accountEx;

        public AccountQueryObject(AccountExt account) {
            this.accountEx = account;
        }

        @Override
        public WhereItems configWhereItems() {
            WhereItems w = new WhereItems();
            WhereItem whereItem = new WhereItem("V.FNumber", this.accountEx.getAccountNumber());
            whereItem.setIsSupportGroupBy(false);
            w.addItem(whereItem);
            return w;
        }

        @Override
        public SelectFieldCollection configSelectFields() {
            SelectFieldCollection sc = new SelectFieldCollection();
            sc.addSelectField(new SelectField("V.FID", "FID", true));
            sc.addSelectField(new SelectField("V.FDc", "FDc", true));
            sc.addSelectField(new SelectField("V.FIsLeaf", "FIsLeaf", true));
            sc.addSelectField(new SelectField("V.FLevel", "FLevel", true));
            sc.addSelectField(new SelectField("V.FNumber", "FNumber", true));
            sc.addSelectField(new SelectField("max(O.FLevel)", "O_FLevel"));
            return sc;
        }

        @Override
        public void fillValueObject(Object value) {
            this.accountEx.account = (Account)value;
            String cacheKey = "tail" + this.accountEx.getCompany().getId().toString() + this.accountEx.getAccountTable().getId().toString() + this.accountEx.getAccountNumber();
            if (TailAccountSubQuerySolution.this.accountCache != null && !TailAccountSubQuerySolution.this.accountCache.containsKey(cacheKey)) {
                TailAccountSubQuerySolution.this.accountCache.put(cacheKey, this.accountEx.account);
            }
        }

        @Override
        public void fillValueList(Object[] objList) {
        }
    }

    class ObjectBulider
    implements IObjectBulider {
        ObjectBulider() {
        }

        @Override
        public Object bulider(Object[] value) throws Exception {
            Account account = new Account();
            account.id = value[0].toString();
            account.dc = Integer.parseInt(value[1].toString());
            account.isLeaf = value[2].toString().equals("1");
            account.level = Integer.parseInt(value[3].toString());
            account.number = value[4].toString();
            return account;
        }

        @Override
        public String[] getOrderedSelectedFields() {
            return new String[]{"FID", "FDc", "FIsLeaf", "FLevel", "FNumber", "O_FLevel"};
        }
    }
}

