/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.ParamMutiLangFieldInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.CTypeEnum;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.batch.AbstractCalculator;
import com.kingdee.eas.fi.rpt.batch.AbstractFormulaCalculatorParameter;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fi.rpt.batch.IInnerChecker;
import com.kingdee.eas.fi.rpt.batch.PropertyFilter;
import com.kingdee.eas.fi.rpt.batch.SQLStringWrapper;
import com.kingdee.eas.fi.rpt.util.AcctountAsstItemParser;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AgeCalculator
extends AbstractCalculator {
    private static final Logger log = Logger.getLogger((String)AgeCalculator.class.getName());
    private List ageList = this.getFormulaCalculatorParameterList();
    private List subjectList;
    private List asstActList;
    private List asstActTypeList;
    private Set asstActTypeNumberSet;
    private Map companyNumber2IDMap;
    private Map currencyNumber2IDMap;
    private static final int SUBJECT = 1;
    private static final int SUBJECT_ASSTACTTYPE = 2;
    private static final int SUBJECT_ASSTACTTYPE_ASSTACT = 3;
    private int maxFormulaCount = 20;
    private static final BigDecimal BIGDECIMAL_ONE = new BigDecimal(1.0);
    private static final BigDecimal BIGDECIMAL_TWO = new BigDecimal(2.0);
    private boolean isMergeByFiscalPeriod;
    PeriodCollection periods;

    public AgeCalculator(ICalculateContextProvider context, Context serverCtx) {
        super(context, serverCtx);
        this.isMergeByFiscalPeriod = FiscalPeriodHelper.isMergeByFiscalPeriod((Context)serverCtx);
        RptPeriodTypeEnum periodTypeEnum = RptPeriodTypeEnum.getEnum((int)this.batchHelper.getReport_PeriodType());
        if (FiscalPeriodHelper.isMergeByFiscalPeriod((boolean)this.isMergeByFiscalPeriod, (RptPeriodTypeEnum)periodTypeEnum)) {
            try {
                this.periods = FiscalPeriodHelper.getPeriodCollection((Context)this.serverContext, (String)this.batchHelper.getCompany_ID());
            }
            catch (Exception e) {
                this.handleException(this.formulaCalculatorList, e);
                log.debug((Object)e.getMessage());
                this.handleAllException();
            }
        }
    }

    @Override
    protected void init(SortedParameterArray params) throws BOSException, EASBizException {
        this.initAges(params);
        this.initAsstActType();
        this.initCompanyOrgUnit();
        this.initCurrency();
        this.initVerifyMode();
        this.groupAges();
    }

    private void initAges(SortedParameterArray params) {
        int count = params.size();
        this.asstActTypeNumberSet = new HashSet();
        this.companyNumber2IDMap = new HashMap();
        this.currencyNumber2IDMap = new HashMap();
        for (int i = 0; i < count; ++i) {
            Age age = new Age(params.getParameter(i), this.batchHelper, this.isMergeByFiscalPeriod, this.periods);
            if (age.isException()) {
                this.addToErrorList(age);
                continue;
            }
            this.ageList.add(age);
            this.companyNumber2IDMap.put(age.fiOrgUnit, null);
            this.currencyNumber2IDMap.put(age.currency, null);
        }
    }

    private void initAsstActType() throws BOSException {
        if (this.asstActTypeNumberSet.size() == 0) {
            return;
        }
        EntityViewInfo info = new EntityViewInfo();
        info.getSelector().add(new SelectorItemInfo("mappingFieldName"));
        info.getSelector().add(new SelectorItemInfo("realtionDataObject"));
        info.getSelector().add(new SelectorItemInfo("number"));
        info.setFilter(new FilterInfo());
        info.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)this.asstActTypeNumberSet, CompareType.INCLUDE));
        AsstActTypeCollection asstActTypeCollection = AsstActTypeFactory.getLocalInstance((Context)this.serverContext).getAsstActTypeCollection(info);
        HashMap<String, AsstActTypeInfo> asstActTypeNumberMap = new HashMap<String, AsstActTypeInfo>();
        for (AsstActTypeInfo asstActTypeInfo : asstActTypeCollection) {
            asstActTypeNumberMap.put(asstActTypeInfo.getNumber(), asstActTypeInfo);
        }
        for (Age age : this.ageList) {
            if (age.actItemType != 2) continue;
            HashMap<String, String> tableMap = new HashMap<String, String>();
            for (int i = 0; i < age.asstItems.length; ++i) {
                AcctountAsstItemParser.AsstItem asstItem = age.asstItems[i];
                AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)asstActTypeNumberMap.get(asstItem.asstTypeNumber);
                if (asstActTypeInfo == null) continue;
                tableMap.put("table", asstActTypeInfo.getRealtionDataObject());
                tableMap.put("mapingFieldName", asstActTypeInfo.getMappingFieldName());
                tableMap.put("typeNumber", asstActTypeInfo.getNumber());
                if (asstItem.startNumber == null || asstItem.startNumber.trim().length() == 0) {
                    tableMap.put("from", null);
                } else {
                    tableMap.put("from", asstItem.startNumber.trim());
                    age.actItemType = 3;
                }
                if (asstItem.endNumber == null || asstItem.endNumber.trim().length() == 0) {
                    tableMap.put("to", null);
                } else {
                    tableMap.put("to", asstItem.endNumber.trim());
                    age.actItemType = 3;
                }
                age.asstActTypes.add(tableMap);
            }
        }
    }

    private void initCompanyOrgUnit() throws BOSException {
        if (this.companyNumber2IDMap.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("Select FID,FNumber from T_ORG_Company where FNumber in ");
        sql.append(this.batchHelper.createInSql(this.companyNumber2IDMap.keySet().iterator()));
        IRowSet rowSet = DbUtil.executeQuery((Context)this.serverContext, (String)sql.toString());
        try {
            while (rowSet.next()) {
                this.companyNumber2IDMap.put(rowSet.getString("FNumber"), rowSet.getString("FID"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        for (Age age : this.ageList) {
            age.companyid = (String)this.companyNumber2IDMap.get(age.fiOrgUnit);
            if (age.companyid != null) continue;
            this.addToErrorList(age, (Exception)((Object)new ReportException(ReportException.CMPNULL)));
        }
    }

    private void initCurrency() throws BOSException {
        if (this.currencyNumber2IDMap.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("Select FID,FNumber from T_BD_Currency where FNumber in ");
        sql.append(this.batchHelper.createInSql(this.currencyNumber2IDMap.keySet().iterator()));
        IRowSet rowSet = DbUtil.executeQuery((Context)this.serverContext, (String)sql.toString());
        try {
            while (rowSet.next()) {
                this.currencyNumber2IDMap.put(rowSet.getString("FNumber"), rowSet.getString("FID"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        for (Age age : this.ageList) {
            age.currencyid = (String)this.currencyNumber2IDMap.get(age.currency);
            if (age.currencyid != null) continue;
            this.addToErrorList(age, (Exception)((Object)new ReportException(ReportException.CRYNULL)));
        }
    }

    private void initVerifyMode() throws BOSException {
        Map verifyModeMap = this.getVerifyMode(this.companyNumber2IDMap.values());
        for (Age age : this.ageList) {
            if (verifyModeMap.get(age.companyid) == null) {
                age.setException((Exception)((Object)new EASBizException(new NumericExceptionSubItem("001", ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"53_AgeCalculator", (Locale)this.serverContext.getLocale())))));
                continue;
            }
            int verifyMode = (Integer)verifyModeMap.get(age.companyid);
            boolean bl = age.isInTimeVerify = verifyMode == 0;
            if (verifyMode == 2) {
                age.includeVoucher = true;
            }
            if (age.includeVoucher && age.isInTimeVerify) {
                age.amountField = "UnholdedAmtFor";
                if (CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(age.currencyid)) {
                    age.amountField = "UnholdedAmtLocal";
                    continue;
                }
                if (CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(age.currencyid)) {
                    age.amountField = "UnholdedAmtRpt";
                    continue;
                }
                age.isGeneralCurrency = false;
                continue;
            }
            age.amountField = "UnVerifiedAmtFor";
            if (CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(age.currencyid)) {
                age.amountField = "UnVerifiedAmtLocal";
                continue;
            }
            if (CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(age.currencyid)) {
                age.amountField = "UnVerifiedAmtRpt";
                continue;
            }
            age.isGeneralCurrency = false;
        }
    }

    private Map getVerifyMode(Collection orgUnitIds) throws BOSException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        if (orgUnitIds.size() == 0) {
            return result;
        }
        StringBuffer sql = new StringBuffer();
        ArrayList<String> params = new ArrayList<String>();
        ParamMutiLangFieldInfo mutiFieldInfo = new ParamMutiLangFieldInfo(this.serverContext.getLocale());
        sql.append("select param.").append(mutiFieldInfo.getParamDefValue()).append(" defaultval  \n");
        sql.append(", item.").append(mutiFieldInfo.getParamItemValue()).append(" itemvalue");
        sql.append(",item.forgunitid orgunitid\t\t\n");
        sql.append("from T_BAS_Param param \t\n");
        sql.append("left outer join T_BAS_ParamItem item on param.fid = item.fkeyid ");
        sql.append("Where item.forgunitid in \t\t\n");
        String orgIdInString = this.batchHelper.createInSql(orgUnitIds.iterator());
        sql.append(orgIdInString).append("\n");
        sql.append("and param.fnumber = ? \t\t\n");
        params.add("GL_052");
        sql.append("and item.forgunitid in   \t\n");
        sql.append(orgIdInString).append("\n");
        IRowSet rs = DbUtil.executeQuery((Context)this.serverContext, (String)sql.toString(), (Object[])params.toArray());
        try {
            while (rs.next()) {
                String defaultVal = rs.getString("defaultval");
                String itemValue = rs.getString("itemvalue");
                String orgUnitId = rs.getString("orgunitid");
                int verifyMode = 0;
                if (itemValue != null) {
                    verifyMode = Integer.parseInt(itemValue);
                } else if (defaultVal != null) {
                    verifyMode = Integer.parseInt(defaultVal);
                }
                result.put(orgUnitId, new Integer(verifyMode));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    private void groupAges() {
        this.subjectList = new ArrayList();
        this.asstActList = new ArrayList();
        this.asstActTypeList = new ArrayList();
        for (Age age : this.ageList) {
            if (age.actItemType == 1) {
                this.subjectList.add(age);
                continue;
            }
            if (age.actItemType == 2) {
                this.asstActList.add(age);
                continue;
            }
            this.asstActTypeList.add(age);
        }
    }

    @Override
    protected void calculate() throws BOSException, EASBizException {
        this.executeCalculate(this.subjectList, 1);
        for (Age age : this.asstActList) {
            this.calculateDirect(age);
        }
        for (Age age : this.asstActTypeList) {
            try {
                this.calculateDirect(age);
            }
            catch (Exception e) {
                this.addToErrorList(age, e);
            }
        }
    }

    private void executeCalculate(List ageFormulaList, int type) throws BOSException {
        if (ageFormulaList.size() == 0) {
            return;
        }
        try {
            AgeSQLStringWrapper initWrapper = this.createInitCalcSql(ageFormulaList, type);
            IRowSet initRs = DbUtil.executeQuery((Context)this.serverContext, (String)initWrapper.getSQLString(), (Object[])initWrapper.getArrayParams());
            ArrayList propertyList = new ArrayList();
            while (initRs.next()) {
                HashMap<String, Object> property = new HashMap<String, Object>();
                property.put("UnholdedAmtFor", initRs.getBigDecimal("UnholdedAmtFor"));
                property.put("UnholdedAmtLocal", initRs.getBigDecimal("UnholdedAmtLocal"));
                property.put("UnholdedAmtRpt", initRs.getBigDecimal("UnholdedAmtRpt"));
                property.put("UnVerifiedAmtFor", initRs.getBigDecimal("UnVerifiedAmtFor"));
                property.put("UnVerifiedAmtLocal", initRs.getBigDecimal("UnVerifiedAmtLocal"));
                property.put("UnVerifiedAmtRpt", initRs.getBigDecimal("UnVerifiedAmtRpt"));
                property.put("AccountNumber", initRs.getString("AccountNumber"));
                property.put("CompanyId", initRs.getString("CompanyId"));
                property.put("CurrencyId", initRs.getString("CurrencyId"));
                property.put("EndDate", initRs.getDate("EndDate"));
                property.put("BizDate", initRs.getDate("BizDate"));
                if (type != 1) {
                    for (Map map : initWrapper.getAsstActTypes()) {
                        String fieldId = map.get("table") + ".FID";
                        property.put(fieldId, initRs.getString(fieldId));
                        String hgId = (String)map.get("mapingFieldName");
                        property.put(hgId, initRs.getString(hgId));
                        if (type != 3) continue;
                        String field = map.get("table") + ".FNumber";
                        property.put(field, initRs.getString(fieldId));
                    }
                }
                propertyList.add(property);
            }
            PropertyFilter indexer = new PropertyFilter(propertyList);
            if (type != 1) {
                indexer.setInnerChecker(new IInnerChecker(){

                    @Override
                    public boolean isInnerCheckPassed(Object o) {
                        Map map = (Map)o;
                        String fieldId = map.get("table") + ".FID";
                        String hgId = (String)map.get("mapingFieldName");
                        return fieldId != null && hgId != null && fieldId.equals(hgId);
                    }
                });
            }
            for (Age age : ageFormulaList) {
                if (age.isException()) {
                    this.addToErrorList(age, age.getException());
                    continue;
                }
                FilterInfo filter = this.createInitFilterInfo(age, false);
                Map[] propertyMapByConditions = indexer.getPropertyMapByConditions(filter);
                for (int i = 0; i < propertyMapByConditions.length; ++i) {
                    Object value = propertyMapByConditions[i].get(age.amountField);
                    age.combineValue(value, true);
                }
            }
            AgeSQLStringWrapper sqlWrapper = this.createMainCalcSql(ageFormulaList, type);
            IRowSet sqlRs = DbUtil.executeQuery((Context)this.serverContext, (String)sqlWrapper.getSQLString(), (Object[])sqlWrapper.getArrayParams());
            ArrayList propertyList2 = new ArrayList();
            while (sqlRs.next()) {
                HashMap<String, Object> property = new HashMap<String, Object>();
                property.put("EntryDirection", new Integer(sqlRs.getInt("EntryDirection")));
                property.put("Direction", new Integer(sqlRs.getInt("Direction")));
                property.put("UnholdedAmtFor", sqlRs.getBigDecimal("UnholdedAmtFor"));
                property.put("UnholdedAmtLocal", sqlRs.getBigDecimal("UnholdedAmtLocal"));
                property.put("UnholdedAmtRpt", sqlRs.getBigDecimal("UnholdedAmtRpt"));
                property.put("UnVerifiedAmtFor", sqlRs.getBigDecimal("UnVerifiedAmtFor"));
                property.put("UnVerifiedAmtLocal", sqlRs.getBigDecimal("UnVerifiedAmtLocal"));
                property.put("UnVerifiedAmtRpt", sqlRs.getBigDecimal("UnVerifiedAmtRpt"));
                property.put("AccountNumber", sqlRs.getString("AccountNumber"));
                property.put("CompanyId", sqlRs.getString("CompanyId"));
                property.put("CurrencyId", sqlRs.getString("CurrencyId"));
                property.put("EndDate", sqlRs.getDate("EndDate"));
                property.put("BizDate", sqlRs.getDate("BizDate"));
                property.put("BizStatus", new Integer(sqlRs.getInt("BizStatus")));
                if (type != 1) {
                    for (Map map : sqlWrapper.getAsstActTypes()) {
                        String fieldId = map.get("table") + ".FID";
                        property.put(fieldId, sqlRs.getString(fieldId));
                        String hgId = (String)map.get("mapingFieldName");
                        property.put(hgId, sqlRs.getString(hgId));
                        if (type != 3) continue;
                        String field = map.get("table") + ".FNumber";
                        property.put(field, sqlRs.getString(fieldId));
                    }
                }
                propertyList2.add(property);
            }
            PropertyFilter indexer2 = new PropertyFilter(propertyList2);
            if (type != 1) {
                indexer2.setInnerChecker(new IInnerChecker(){

                    @Override
                    public boolean isInnerCheckPassed(Object o) {
                        Map map = (Map)o;
                        String fieldId = map.get("table") + ".FID";
                        String hgId = (String)map.get("mapingFieldName");
                        return fieldId != null && hgId != null && fieldId.equals(hgId);
                    }
                });
            }
            for (Age age : ageFormulaList) {
                if (age.isException()) {
                    this.addToErrorList(age, age.getException());
                    continue;
                }
                FilterInfo filter = this.createMainFilterInfo(age, false);
                Map[] propertyMapByConditions = indexer2.getPropertyMapByConditions(filter);
                for (int i = 0; i < propertyMapByConditions.length; ++i) {
                    BigDecimal amountField = CslConstant.BGZERO;
                    BigDecimal entryDirection = CslConstant.BGZERO;
                    BigDecimal direction = CslConstant.BGZERO;
                    try {
                        amountField = new BigDecimal(propertyMapByConditions[i].get(age.amountField).toString());
                        entryDirection = new BigDecimal(propertyMapByConditions[i].get("EntryDirection").toString());
                        direction = new BigDecimal(propertyMapByConditions[i].get("Direction").toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    BigDecimal value = entryDirection.multiply(BIGDECIMAL_TWO).subtract(BIGDECIMAL_ONE).multiply(direction).multiply(amountField);
                    age.combineValue(value, true);
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private FilterInfo createMainFilterInfo(Age age, boolean needJoin) {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItems = filter.getFilterItems();
        if (age.accountFromNumber != null && age.accountToNumber != null) {
            if (age.accountFromNumber.equals(age.accountToNumber)) {
                filterItems.add(new FilterItemInfo("AccountNumber", (Object)age.accountFromNumber, CompareType.EQUALS));
            } else {
                filterItems.add(new FilterItemInfo("AccountNumber", (Object)age.accountFromNumber, CompareType.GREATER_EQUALS));
                filterItems.add(new FilterItemInfo("AccountNumber", (Object)age.accountToNumber, CompareType.LESS_EQUALS));
            }
        } else if (age.accountFromNumber != null) {
            filterItems.add(new FilterItemInfo("AccountNumber", (Object)age.accountFromNumber, CompareType.EQUALS));
        } else if (age.accountToNumber != null) {
            filterItems.add(new FilterItemInfo("AccountNumber", (Object)age.accountToNumber, CompareType.EQUALS));
        }
        filterItems.add(new FilterItemInfo("CompanyId", (Object)age.companyid, CompareType.EQUALS));
        if (!age.isGeneralCurrency) {
            filterItems.add(new FilterItemInfo("CurrencyId", (Object)age.currencyid, CompareType.EQUALS));
        }
        String dateString = "EndDate";
        if (age.balType.equalsIgnoreCase("B")) {
            dateString = "BizDate";
        }
        if (!age.isCalcAll) {
            filterItems.add(new FilterItemInfo(dateString, (Object)age.sqlfromDate, CompareType.LESS_EQUALS));
            if (age.to != null && age.to.trim().length() != 0) {
                filterItems.add(new FilterItemInfo(dateString, (Object)age.sqltoDate, CompareType.GREATER_EQUALS));
            }
        } else {
            Calendar cal = Calendar.getInstance();
            cal.setTime(age.endDate);
            filterItems.add(new FilterItemInfo(dateString, (Object)new Date(cal.getTimeInMillis()), CompareType.GREATER_EQUALS));
        }
        if (!age.includeVoucher) {
            filterItems.add(new FilterItemInfo("BizStatus", (Object)new Integer(5), CompareType.EQUALS));
        }
        if (needJoin) {
            for (Map map : age.asstActTypes) {
                String field = map.get("table") + ".FNumber";
                if (map.get("from") != null && map.get("to") != null) {
                    filterItems.add(new FilterItemInfo(field, map.get("from"), CompareType.GREATER_EQUALS));
                    filterItems.add(new FilterItemInfo(field, map.get("to"), CompareType.LESS_EQUALS));
                    continue;
                }
                if (map.get("from") != null) {
                    filterItems.add(new FilterItemInfo(field, map.get("from"), CompareType.EQUALS));
                    continue;
                }
                if (map.get("to") == null) continue;
                filterItems.add(new FilterItemInfo(field, map.get("to"), CompareType.EQUALS));
            }
        }
        return filter;
    }

    private FilterInfo createInitFilterInfo(Age age, boolean needJion) {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItems = filter.getFilterItems();
        if (age.accountFromNumber != null && age.accountToNumber != null) {
            if (age.accountFromNumber.equals(age.accountToNumber)) {
                filterItems.add(new FilterItemInfo("AccountNumber", (Object)age.accountFromNumber, CompareType.EQUALS));
            } else {
                filterItems.add(new FilterItemInfo("AccountNumber", (Object)age.accountFromNumber, CompareType.GREATER_EQUALS));
                filterItems.add(new FilterItemInfo("AccountNumber", (Object)age.accountToNumber, CompareType.LESS_EQUALS));
            }
        } else if (age.accountFromNumber != null) {
            filterItems.add(new FilterItemInfo("AccountNumber", (Object)age.accountFromNumber, CompareType.EQUALS));
        } else if (age.accountToNumber != null) {
            filterItems.add(new FilterItemInfo("AccountNumber", (Object)age.accountToNumber, CompareType.EQUALS));
        }
        filterItems.add(new FilterItemInfo("CompanyId", (Object)age.companyid, CompareType.EQUALS));
        if (!age.isGeneralCurrency) {
            filterItems.add(new FilterItemInfo("CurrencyId", (Object)age.currencyid, CompareType.EQUALS));
        }
        String dateString = "EndDate";
        if (age.balType.equalsIgnoreCase("B")) {
            dateString = "BizDate";
        }
        if (!age.isCalcAll) {
            filterItems.add(new FilterItemInfo(dateString, (Object)age.sqlfromDate, CompareType.LESS_EQUALS));
            if (age.to != null && age.to.trim().length() != 0) {
                filterItems.add(new FilterItemInfo(dateString, (Object)age.sqltoDate, CompareType.GREATER_EQUALS));
            }
        } else {
            Calendar cal = Calendar.getInstance();
            cal.setTime(age.endDate);
            filterItems.add(new FilterItemInfo(dateString, (Object)new Date(cal.getTimeInMillis()), CompareType.GREATER_EQUALS));
        }
        if (needJion) {
            for (Map map : age.asstActTypes) {
                String field = map.get("table") + ".FNumber";
                if (map.get("from") != null && map.get("to") != null) {
                    filterItems.add(new FilterItemInfo(field, map.get("from"), CompareType.GREATER_EQUALS));
                    filterItems.add(new FilterItemInfo(field, map.get("to"), CompareType.LESS_EQUALS));
                    continue;
                }
                if (map.get("from") != null) {
                    filterItems.add(new FilterItemInfo(field, map.get("from"), CompareType.EQUALS));
                    continue;
                }
                if (map.get("to") == null) continue;
                filterItems.add(new FilterItemInfo(field, map.get("to"), CompareType.EQUALS));
            }
        }
        return filter;
    }

    private AgeSQLStringWrapper createMainCalcSql(List eachAgeList, int actItemType) {
        String tableName;
        Map map;
        int i;
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> sqlParam = new ArrayList<Object>();
        List asstActTypes = null;
        if (actItemType != 1) {
            asstActTypes = this.combineAsstActTypes(eachAgeList);
        }
        sql.append("select entry.fentrydc As EntryDirection");
        sql.append(",account.fdc AS Direction");
        sql.append(",cussent.funholdedAmtFor AS UnholdedAmtFor\t\t\t\n");
        sql.append(",cussent.funholdedAmtLocal AS UnholdedAmtLocal\t\t\n");
        sql.append(",cussent.funholdedAmtRpt AS UnholdedAmtRpt\t\t\t\n");
        sql.append(",cussent.funVerifiedAmtFor AS UnVerifiedAmtFor\t\t\n");
        sql.append(",cussent.funVerifiedAmtLocal AS UnVerifiedAmtLocal\t\n");
        sql.append(",cussent.funVerifiedAmtRpt AS UnVerifiedAmtRpt\t\t\n");
        sql.append(",account.fnumber AS AccountNumber\t\n");
        sql.append(",cussent.fcompanyid AS CompanyId\t\n");
        sql.append(",cussent.fcurrencyid AS CurrencyId\t\n");
        sql.append(",assist.fenddate AS EndDate\t\n");
        sql.append(",assist.fbizdate AS BizDate\t\n");
        sql.append(",voucher.FBizStatus AS BizStatus\t\n");
        if (actItemType != 1) {
            for (i = 0; i < asstActTypes.size(); ++i) {
                map = (Map)asstActTypes.get(i);
                if (map.get("from") == null && map.get("to") == null) continue;
                tableName = (String)map.get("table");
                sql.append(" , ").append(tableName).append(".FID \t\n");
                if (actItemType != 3) continue;
                sql.append(" , ").append(tableName).append(".Fnumber \t\n");
            }
        }
        sql.append("from t_gl_voucherassistrecord assist \n");
        sql.append("inner join t_gl_acctcussent cussent on cussent.fvchassistrecordid=assist.fid\t\n");
        sql.append("inner join t_gl_voucherentry entry on assist.fentryid=entry.fid\t\t\n");
        sql.append("inner join t_gl_voucher voucher on entry.fbillid=voucher.fid \t\t\n");
        sql.append("inner join t_bd_accountview account on entry.faccountid=account.fid \n");
        sql.append("inner join t_bd_Currency currency on entry.fcurrencyid=currency.fid\t\n");
        if (actItemType != 1) {
            sql.append("inner join t_bd_assistanthg hg on assist.fassgrpid=hg.fid \t\n");
            for (i = 0; i < asstActTypes.size(); ++i) {
                map = (Map)asstActTypes.get(i);
                tableName = (String)map.get("table");
                sql.append("Left JOIN ").append(tableName).append(" ON hg.").append(map.get("mapingFieldName")).append(" = ").append(tableName).append(".FID   \n");
            }
        }
        sql.append(" WHERE cussent.fisinit<>1 and (");
        boolean addOr = false;
        for (Age age : eachAgeList) {
            if (age.isException()) continue;
            if (addOr) {
                sql.append("OR    \n");
            } else {
                addOr = true;
            }
            sql.append("( ");
            if (age.accountFromNumber != null && age.accountToNumber != null) {
                if (age.accountFromNumber.equals(age.accountToNumber)) {
                    sql.append(" ( account.fnumber=? )");
                    sqlParam.add(age.accountFromNumber);
                } else {
                    sql.append(" ( account.fnumber>=? AND account.fnumber<=? )");
                    sqlParam.add(age.accountFromNumber);
                    sqlParam.add(age.accountToNumber);
                }
            } else if (age.accountFromNumber != null) {
                sql.append(" ( account.fnumber=? )");
                sqlParam.add(age.accountFromNumber);
            } else if (age.accountToNumber != null) {
                sql.append(" ( account.fnumber=? )");
                sqlParam.add(age.accountToNumber);
            } else {
                this.addToErrorList(age, (Exception)((Object)new ReportException(ReportException.NULLACOUNT)));
                continue;
            }
            sql.append(")");
            sql.append("AND cussent.fcompanyid=? ");
            sqlParam.add(age.companyid);
            if (!age.isGeneralCurrency) {
                sql.append("AND cussent.fcurrencyid=? ");
                sqlParam.add(age.currencyid);
            }
            if (!age.isCalcAll) {
                sql.append("AND ( assist." + age.strDateType + "<=?)");
                sqlParam.add(age.sqlfromDate);
                if (age.to != null && age.to.trim().length() != 0) {
                    sql.append("AND ( assist." + age.strDateType + ">=?)");
                    sqlParam.add(age.sqltoDate);
                }
            } else {
                Calendar cal = Calendar.getInstance();
                cal.setTime(age.endDate);
                sql.append("AND ( assist." + age.strDateType + ">=?)");
                sqlParam.add(new Date(cal.getTimeInMillis()));
            }
            if (!age.includeVoucher) {
                sql.append(" and voucher.FBizStatus=? \n");
                sqlParam.add(new Integer(5));
                continue;
            }
            sql.append(" and voucher.fbizstatus <> ? and voucher.fbizstatus<>? \n");
            sqlParam.add(new Integer(0));
            sqlParam.add(new Integer(2));
        }
        sql.append(")");
        if (actItemType == 3) {
            sql.append("and (");
            boolean hasOr = false;
            for (int i2 = 0; i2 < asstActTypes.size(); ++i2) {
                Map map2 = (Map)asstActTypes.get(i2);
                if (map2.get("from") == null && map2.get("to") == null) continue;
                if (hasOr) {
                    sql.append("OR    \n");
                } else {
                    hasOr = true;
                }
                String tableName2 = (String)map2.get("table");
                sql.append("(");
                if (map2.get("from") != null && map2.get("to") != null) {
                    if (map2.get("from").equals(map2.get("to"))) {
                        sql.append(tableName2).append(".fnumber=? \t\n");
                        sqlParam.add(map2.get("from"));
                    } else {
                        sql.append(tableName2).append(".fnumber>=? \t\n");
                        sqlParam.add(map2.get("from"));
                        sql.append(" and ").append(tableName2).append(".fnumber<=? \t\n");
                        sqlParam.add(map2.get("to"));
                    }
                } else if (map2.get("from") != null) {
                    sql.append(tableName2).append(".fnumber=? \t\n");
                    sqlParam.add(map2.get("from"));
                } else if (map2.get("to") != null) {
                    sql.append(tableName2).append(".fnumber=? \t\n");
                    sqlParam.add(map2.get("to"));
                }
                sql.append(")");
            }
            sql.append(")");
        }
        AgeSQLStringWrapper wrapper = new AgeSQLStringWrapper(sql.toString(), sqlParam);
        wrapper.setAsstActTypes(asstActTypes);
        return wrapper;
    }

    private List combineAsstActTypes(List eachAgeList) {
        HashMap resultMap = new HashMap();
        for (Age age : eachAgeList) {
            Iterator iterator2 = age.asstActTypes.iterator();
            while (iterator2.hasNext()) {
                Map formerTableFieldMap;
                HashMap<String, String> tableFieldMap = new HashMap<String, String>();
                tableFieldMap.putAll((Map)iterator2.next());
                String table = (String)tableFieldMap.get("table");
                String mapingFieldName = (String)tableFieldMap.get("mapingFieldName");
                String from = (String)tableFieldMap.get("from");
                String to = (String)tableFieldMap.get("to");
                HashMap<String, String> eachMap = new HashMap<String, String>();
                eachMap.put("table", table);
                eachMap.put("mapingFieldName", mapingFieldName);
                if (table != null && mapingFieldName != null && (from != null || to != null) && (formerTableFieldMap = (Map)resultMap.get(eachMap)) != null) {
                    String formerTo;
                    String formerFrom = (String)tableFieldMap.get("from");
                    if (formerFrom != null && formerFrom.compareTo(from) < 0) {
                        tableFieldMap.put("from", formerFrom);
                    }
                    if ((formerTo = (String)tableFieldMap.get("to")) != null && formerTo.compareTo(to) > 0) {
                        tableFieldMap.put("to", formerTo);
                    }
                }
                resultMap.put(eachMap, tableFieldMap);
            }
        }
        ArrayList result = new ArrayList();
        result.addAll(resultMap.values());
        return result;
    }

    private Date getLastDateByBeforeDay(int beforeDay, java.util.Date date) {
        if (beforeDay != -1) {
            Calendar cal = GregorianCalendar.getInstance();
            cal.setTime(date);
            cal.add(5, -1 * beforeDay);
            return new Date(cal.getTimeInMillis());
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return new Date(cal.getTimeInMillis());
    }

    private AgeSQLStringWrapper createInitCalcSql(List eachAgeList, int actItemType) {
        String tableName;
        Map map;
        int i;
        StringBuffer initSql = new StringBuffer();
        ArrayList<Object> initParam = new ArrayList<Object>();
        List asstActTypes = null;
        if (actItemType != 1) {
            asstActTypes = this.combineAsstActTypes(eachAgeList);
        }
        initSql.append("select cussent.funholdedAmtFor AS UnholdedAmtFor\t\n");
        initSql.append(",cussent.funholdedAmtLocal AS UnholdedAmtLocal\t\t\n");
        initSql.append(",cussent.funholdedAmtRpt AS UnholdedAmtRpt\t\t\t\n");
        initSql.append(",cussent.funVerifiedAmtFor AS UnVerifiedAmtFor\t\t\n");
        initSql.append(",cussent.funVerifiedAmtLocal AS UnVerifiedAmtLocal\t\n");
        initSql.append(",cussent.funVerifiedAmtRpt AS UnVerifiedAmtRpt\t\t\n");
        initSql.append(",account.fnumber AS AccountNumber\t\t\t\t\t\n");
        initSql.append(",cussent.fcompanyid AS CompanyId\t\t\t\t\t\n");
        initSql.append(",cussent.fcurrencyid AS CurrencyId\t\t\t\t\t\n");
        initSql.append(",assist.fenddate AS EndDate\t\t\t\t\t\t\t\n");
        initSql.append(",assist.fbizdate AS BizDate\t\t\t\t\t\t\t\n");
        if (actItemType != 1) {
            for (i = 0; i < asstActTypes.size(); ++i) {
                map = (Map)asstActTypes.get(i);
                if (map.get("from") == null && map.get("to") == null) continue;
                tableName = (String)map.get("table");
                initSql.append(" , ").append(tableName).append(".FID \t\n");
                if (actItemType != 3) continue;
                initSql.append(" , ").append(tableName).append(".Fnumber \t\n");
            }
        }
        initSql.append("from t_gl_voucherassistrecord assist \t\n");
        initSql.append("inner join t_gl_acctcussent cussent on cussent.fvchassistrecordid = assist.fid \n");
        initSql.append("inner join t_bd_accountview account on cussent.FAccountID=account.fid \t\t\n");
        initSql.append("inner join t_bd_Currency currency on cussent.fcurrencyid = currency.fid\t\t\n");
        if (actItemType != 1) {
            initSql.append("inner join t_bd_assistanthg hg on assist.fassgrpid = hg.fid \t\n");
            for (i = 0; i < asstActTypes.size(); ++i) {
                map = (Map)asstActTypes.get(i);
                tableName = (String)map.get("table");
                initSql.append("Left JOIN ").append(tableName).append(" ON hg.").append(map.get("mapingFieldName")).append(" = ").append(tableName).append(".FID   \n");
            }
        }
        initSql.append(" WHERE  (");
        boolean addOr = false;
        for (Age age : eachAgeList) {
            if (age.isException()) continue;
            if (addOr) {
                initSql.append("OR    \n");
            } else {
                addOr = true;
            }
            initSql.append("(");
            if (age.accountFromNumber != null && age.accountToNumber != null) {
                if (age.accountFromNumber.equals(age.accountToNumber)) {
                    initSql.append(" ( account.fnumber=? )");
                    initParam.add(age.accountFromNumber);
                } else {
                    initSql.append(" ( account.fnumber>=? AND account.fnumber<=? )");
                    initParam.add(age.accountFromNumber);
                    initParam.add(age.accountToNumber);
                }
            } else if (age.accountFromNumber != null) {
                initSql.append(" ( account.fnumber=? )");
                initParam.add(age.accountFromNumber);
            } else if (age.accountToNumber != null) {
                initSql.append(" ( account.fnumber=? )");
                initParam.add(age.accountToNumber);
            } else {
                this.addToErrorList(age, (Exception)((Object)new ReportException(ReportException.NULLACOUNT)));
                continue;
            }
            initSql.append(")");
            initSql.append("AND cussent.fcompanyid=? ");
            initParam.add(age.companyid);
            if (!age.isGeneralCurrency) {
                initSql.append("AND(cussent.fcurrencyid=?)");
                initParam.add(age.currencyid);
            }
            if (!age.isCalcAll) {
                initSql.append("AND ( assist." + age.strDateType + "<=?)");
                initParam.add(age.sqlfromDate);
                if (age.to == null || age.to.trim().length() == 0) continue;
                initSql.append("AND ( assist." + age.strDateType + ">=?)");
                initParam.add(age.sqltoDate);
                continue;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(age.endDate);
            initSql.append("AND ( assist." + age.strDateType + ">=?)");
            initParam.add(new Date(cal.getTimeInMillis()));
        }
        initSql.append(") and assist.fentryid is null and cussent.fisinit=1 and cussent.fisinitclosed=1 \n");
        if (actItemType == 3) {
            initSql.append("and (");
            boolean hasOr = false;
            for (int i2 = 0; i2 < asstActTypes.size(); ++i2) {
                Map map2 = (Map)asstActTypes.get(i2);
                if (map2.get("from") == null && map2.get("to") == null) continue;
                if (hasOr) {
                    initSql.append("OR    \n");
                } else {
                    hasOr = true;
                }
                String tableName2 = (String)map2.get("table");
                initSql.append("(");
                if (map2.get("from") != null && map2.get("to") != null) {
                    if (map2.get("from").equals(map2.get("to"))) {
                        initSql.append(tableName2).append(".fnumber=? \t\n");
                        initParam.add(map2.get("from"));
                    } else {
                        initSql.append(tableName2).append(".fnumber>=? \t\n");
                        initParam.add(map2.get("from"));
                        initSql.append(" and ").append(tableName2).append(".fnumber<=? \t\n");
                        initParam.add(map2.get("to"));
                    }
                } else if (map2.get("from") != null) {
                    initSql.append(tableName2).append(".fnumber=? \t\n");
                    initParam.add(map2.get("from"));
                } else if (map2.get("to") != null) {
                    initSql.append(tableName2).append(".fnumber=? \t\n");
                    initParam.add(map2.get("to"));
                }
                initSql.append(")");
            }
            initSql.append(")");
        }
        AgeSQLStringWrapper wrapper = new AgeSQLStringWrapper(initSql.toString(), initParam);
        wrapper.setAsstActTypes(asstActTypes);
        return wrapper;
    }

    public void setMaxFormulaCount(int maxFormulaCount) {
        this.maxFormulaCount = maxFormulaCount;
    }

    private void calculateDirect(Age age) throws BOSException, ReportException {
        boolean calcAll;
        Map map;
        String amountField = null;
        boolean general = true;
        if (age.includeVoucher && age.isInTimeVerify) {
            amountField = "cussent.funholdedAmtFor";
            if (CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(age.currencyid)) {
                amountField = "cussent.funholdedAmtLocal";
            } else if (CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(age.currencyid)) {
                amountField = "cussent.funholdedAmtRpt";
            } else {
                general = false;
            }
        } else {
            amountField = "cussent.funVerifiedAmtFor";
            if (CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(age.currencyid)) {
                amountField = "cussent.funVerifiedAmtLocal";
            } else if (CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(age.currencyid)) {
                amountField = "cussent.funVerifiedAmtRpt";
            } else {
                general = false;
            }
        }
        StringBuffer initSql = new StringBuffer();
        ArrayList<Object> initParam = new ArrayList<Object>();
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> sqlParam = new ArrayList<Object>();
        sql.append("select sum((entry.fentrydc*2-1)*account.fdc*").append(amountField).append(") as sumall");
        initSql.append("select sum(").append(amountField).append(") as sumall");
        sql.append(" from t_gl_voucherassistrecord assist \r\n inner join t_gl_acctcussent cussent on cussent.fvchassistrecordid=assist.fid \r\n inner join t_gl_voucherentry entry on assist.fentryid=entry.fid");
        sql.append("  \r\n inner join t_gl_voucher voucher on entry.fbillid=voucher.fid \r\n inner join t_bd_accountview account on entry.faccountid=account.fid ");
        sql.append(" \r\n inner join t_bd_Currency currency on entry.fcurrencyid=currency.fid");
        initSql.append(" \r\n from t_gl_voucherassistrecord assist \r\n inner join t_gl_acctcussent cussent on cussent.fvchassistrecordid = assist.fid ");
        initSql.append(" \r\n inner join t_bd_accountview account on cussent.FAccountID=account.fid ");
        initSql.append(" \r\n inner join t_bd_Currency currency on cussent.fcurrencyid = currency.fid");
        switch (age.actItemType) {
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                sql.append(" \r\n inner join t_bd_assistanthg hg on assist.fassgrpid=hg.fid ");
                initSql.append(" \r\n inner join t_bd_assistanthg hg on assist.fassgrpid = hg.fid ");
                for (int i = 0; i < age.asstActTypes.size(); ++i) {
                    map = (Map)age.asstActTypes.get(i);
                    sql.append("\r\n inner JOIN " + map.get("table") + " AS T" + i + " ON hg." + map.get("mapingFieldName") + " = T" + i + ".FID    ");
                    initSql.append("\r\n inner JOIN " + map.get("table") + " AS T" + i + " ON hg." + map.get("mapingFieldName") + " = T" + i + ".FID    ");
                }
                break;
            }
        }
        switch (age.actItemType) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                for (int k = 0; k < age.asstActTypes.size(); ++k) {
                    map = (HashMap)age.asstActTypes.get(k);
                    if (((HashMap)map).get("from") == null && ((HashMap)map).get("to") == null) continue;
                    if (((HashMap)map).get("from") != null && ((HashMap)map).get("to") != null) {
                        sql.append(" and ").append(" T" + k).append(".fnumber>=? ");
                        sqlParam.add(((HashMap)map).get("from"));
                        sql.append(" and ").append(" T" + k).append(".fnumber<=? ");
                        sqlParam.add(((HashMap)map).get("to"));
                    } else if (((HashMap)map).get("from") != null) {
                        sql.append(" and ").append(" T" + k).append(".fnumber=? ");
                        sqlParam.add(((HashMap)map).get("from"));
                    } else if (((HashMap)map).get("to") != null) {
                        sql.append(" and ").append(" T" + k).append(".fnumber=? ");
                        sqlParam.add(((HashMap)map).get("to"));
                    }
                    if (((HashMap)map).get("from") != null && ((HashMap)map).get("to") != null) {
                        initSql.append(" and ").append(" T" + k).append(".fnumber>=? ");
                        initParam.add(((HashMap)map).get("from"));
                        initSql.append(" and ").append(" T" + k).append(".fnumber<=? ");
                        initParam.add(((HashMap)map).get("to"));
                        continue;
                    }
                    if (((HashMap)map).get("from") != null) {
                        initSql.append(" and ").append(" T" + k).append(".fnumber=? ");
                        initParam.add(((HashMap)map).get("from"));
                        continue;
                    }
                    if (((HashMap)map).get("to") == null) continue;
                    initSql.append(" and ").append(" T" + k).append(".fnumber=? ");
                    initParam.add(((HashMap)map).get("to"));
                }
                break;
            }
        }
        sql.append(" WHERE ");
        initSql.append(" WHERE ");
        sql.append("( ");
        initSql.append("(");
        if (age.accountFromNumber != null && age.accountToNumber != null) {
            sql.append(" ( account.fnumber>=? AND account.fnumber<=? )");
            sqlParam.add(age.accountFromNumber);
            sqlParam.add(age.accountToNumber);
            initSql.append(" ( account.fnumber>=? AND account.fnumber<=? )");
            initParam.add(age.accountFromNumber);
            initParam.add(age.accountToNumber);
        } else if (age.accountFromNumber != null) {
            sql.append(" ( account.fnumber=? )");
            sqlParam.add(age.accountFromNumber);
            initSql.append(" ( account.fnumber=? )");
            initParam.add(age.accountFromNumber);
        } else if (age.accountToNumber != null) {
            sql.append(" ( account.fnumber=? )");
            sqlParam.add(age.accountToNumber);
            initSql.append(" ( account.fnumber=? )");
            initParam.add(age.accountToNumber);
        } else {
            throw new ReportException(ReportException.NULLACOUNT);
        }
        sql.append(")");
        initSql.append(")");
        sql.append("AND(  cussent.fcompanyid=?)");
        sqlParam.add(age.companyid);
        initSql.append("AND(cussent.fcompanyid=?)");
        initParam.add(age.companyid);
        if (!general) {
            sql.append("AND(cussent.fcurrencyid=?)");
            sqlParam.add(age.currencyid);
            initSql.append("AND(cussent.fcurrencyid=?)");
            initParam.add(age.currencyid);
        }
        boolean bl = calcAll = age.from != null && (age.from.equals("0") || age.from.trim().length() == 0) && age.to != null && age.to.equals("0");
        if (!calcAll) {
            Date sqlfromDate = null;
            if (age.from != null && age.from.trim().length() != 0) {
                int fromv = Integer.parseInt(age.from);
                Calendar cal = GregorianCalendar.getInstance();
                cal.setTime(age.endDate);
                cal.add(5, -1 * fromv);
                sqlfromDate = new Date(cal.getTimeInMillis());
            } else {
                Calendar cal = GregorianCalendar.getInstance();
                cal.setTime(age.endDate);
                sqlfromDate = new Date(cal.getTimeInMillis());
            }
            sql.append("AND ( assist." + age.strDateType + "<=?)");
            sqlParam.add(sqlfromDate);
            initSql.append("AND ( assist." + age.strDateType + "<=?)");
            initParam.add(sqlfromDate);
            Date sqltoDate = null;
            if (age.to != null && age.to.trim().length() != 0) {
                int tov = Integer.parseInt(age.to);
                Calendar cal = GregorianCalendar.getInstance();
                cal.setTime(age.endDate);
                cal.add(5, -1 * tov);
                sqltoDate = new Date(cal.getTimeInMillis());
                sql.append("AND ( assist." + age.strDateType + ">=?)");
                sqlParam.add(sqltoDate);
                initSql.append("AND ( assist." + age.strDateType + ">=?)");
                initParam.add(sqltoDate);
            }
        } else {
            Calendar cal = Calendar.getInstance();
            cal.setTime(age.endDate);
            sql.append("AND ( assist." + age.strDateType + ">=?)");
            sqlParam.add(new Date(cal.getTimeInMillis()));
            initSql.append("AND ( assist." + age.strDateType + ">=?)");
            initParam.add(new Date(cal.getTimeInMillis()));
        }
        sql.append(" and cussent.fisinit<>1 and cussent.fvchassistrecordid=assist.fid ");
        initSql.append(" and cussent.fvchassistrecordid=assist.fid ");
        if (!age.includeVoucher) {
            sql.append(" and voucher.FBizStatus=? ");
            sqlParam.add(new Integer(5));
        } else {
            sql.append(" and voucher.fbizstatus <> ? and voucher.fbizstatus<>? ");
            sqlParam.add(new Integer(0));
            sqlParam.add(new Integer(2));
        }
        initSql.append(" and assist.fentryid is null and cussent.fisinit=1 and cussent.fisinitclosed=1 ");
        BigDecimal initV = null;
        BigDecimal sqlV = null;
        IRowSet rsetSql = DbUtil.executeQuery((Context)this.serverContext, (String)sql.toString(), (Object[])sqlParam.toArray());
        try {
            while (rsetSql.next()) {
                sqlV = rsetSql.getBigDecimal("sumall");
            }
        }
        catch (SQLException e1) {
            this.addToErrorList(age, e1);
            return;
        }
        IRowSet rsetInit = DbUtil.executeQuery((Context)this.serverContext, (String)initSql.toString(), (Object[])initParam.toArray());
        try {
            while (rsetInit.next()) {
                initV = rsetInit.getBigDecimal("sumall");
            }
        }
        catch (SQLException e) {
            this.addToErrorList(age, e);
            return;
        }
        BigDecimal allV = new BigDecimal("0");
        if (sqlV != null) {
            allV = allV.add(sqlV);
        }
        if (initV != null) {
            allV = allV.add(initV);
        }
        age.getParameter().setValue((Object)allV);
    }

    @Override
    protected void clear() {
    }

    private class AgeSQLStringWrapper
    extends SQLStringWrapper {
        private List asstActTypes;

        public AgeSQLStringWrapper(String sql, List params) {
            super(sql, params);
        }

        public List getAsstActTypes() {
            return this.asstActTypes;
        }

        public void setAsstActTypes(List asstActTypes) {
            this.asstActTypes = asstActTypes;
        }
    }

    private class Age
    extends AbstractFormulaCalculatorParameter {
        String fiOrgUnit;
        String acctItem;
        String currency;
        String endDateString;
        String from;
        String to;
        String balType;
        java.util.Date endDate;
        boolean includeVoucher;
        int actItemType;
        List asstActTypes;
        AcctountAsstItemParser.AsstItem[] asstItems;
        String accountFromNumber;
        String accountToNumber;
        String companyid;
        String currencyid;
        String amountField;
        boolean isGeneralCurrency;
        String strDateType;
        boolean isCalcAll;
        Date sqlfromDate;
        Date sqltoDate;
        boolean isInTimeVerify;
        BatchHelper batchHelper;
        boolean isMergeByFiscalPeriod;
        PeriodCollection periods;

        public Age(Parameter param, BatchHelper batchHelper, boolean isMergeByFiscalPeriod, PeriodCollection periods) {
            this.batchHelper = batchHelper;
            this.isMergeByFiscalPeriod = isMergeByFiscalPeriod;
            this.periods = periods;
            this.setParameter(param);
            try {
                this.initArgs();
                this.verifyArgs();
            }
            catch (Exception e) {
                this.setException(e);
            }
        }

        @Override
        protected void initArgs() throws ReportException {
            Object[] args = this.getParameter().getArgs();
            this.fiOrgUnit = ((Variant)args[0]).getValue() == null ? null : ((Variant)args[0]).getValue().toString();
            this.acctItem = ((Variant)args[1]).getValue() == null ? null : ((Variant)args[1]).getValue().toString();
            this.currency = ((Variant)args[2]).getValue() == null ? null : ((Variant)args[2]).getValue().toString();
            this.endDateString = ((Variant)args[3]).getValue() == null ? null : ((Variant)args[3]).getValue().toString();
            this.from = ((Variant)args[4]).getValue() == null ? null : ((Variant)args[4]).getValue().toString();
            this.to = ((Variant)args[5]).getValue() == null ? null : ((Variant)args[5]).getValue().toString();
            this.balType = ((Variant)args[6]).getValue() == null ? null : ((Variant)args[6]).getValue().toString();
            this.actItemType = 1;
            this.asstActTypes = new ArrayList();
            this.isGeneralCurrency = true;
        }

        @Override
        protected void verifyArgs() throws BOSException, EASBizException {
            CTypeEnum type = null;
            if (this.balType.equalsIgnoreCase("E")) {
                type = CTypeEnum.E;
            }
            if (this.balType.equalsIgnoreCase("B")) {
                type = CTypeEnum.B;
            }
            if (type == null) {
                throw new ReportException(ReportException.TYPE_NULL);
            }
            this.strDateType = "fenddate";
            if (this.balType.equalsIgnoreCase("B")) {
                this.strDateType = "fbizdate";
            }
            this.includeVoucher = this.batchHelper.isSheet_IncludePosted(this.getSheetName());
            if (StringUtils.isEmpty((String)this.fiOrgUnit)) {
                this.fiOrgUnit = this.batchHelper.getCompany_Number();
            }
            if (StringUtils.isEmpty((String)this.fiOrgUnit)) {
                throw new ReportException(ReportException.FIND_COMPANY_ERROR);
            }
            this.batchHelper.checkCompanyPermision(this.fiOrgUnit);
            if (this.currency == null || this.currency.length() <= 0) {
                this.currency = this.batchHelper.getCorrect_Currency_Number(this.getSheetName());
            }
            if (this.endDateString == null || this.endDateString.trim().length() <= 0) {
                java.util.Date sheetEndDate = this.batchHelper.getSheet_EndDate(this.getSheetName());
                if (sheetEndDate == null) {
                    RptPeriodTypeEnum periodTypeEnum = RptPeriodTypeEnum.getEnum((int)this.batchHelper.getReport_PeriodType());
                    int endYear = this.batchHelper.getSheet_EndYear(this.getSheetName());
                    int endPeriod = this.batchHelper.getSheet_EndPeriod(this.getSheetName());
                    if (this.isMergeByFiscalPeriod && this.periods != null) {
                        int[] result = FiscalPeriodHelper.getRptYearAndPeriod((PeriodCollection)this.periods, (int)this.batchHelper.getReport_Year(), (int)this.batchHelper.getReport_Period(), (int)this.batchHelper.getReport_PeriodType(), (int)endYear, (int)endPeriod, (boolean)this.isMergeByFiscalPeriod);
                        this.endDate = FiscalPeriodHelper.getPeriodLastDate((PeriodCollection)this.periods, (int)result[0], (int)result[1], (RptPeriodTypeEnum)periodTypeEnum, (boolean)this.isMergeByFiscalPeriod);
                    } else {
                        if (endYear <= 0) {
                            endYear = this.batchHelper.getReport_Year() + endYear;
                        }
                        if (endPeriod <= 0) {
                            endPeriod = this.batchHelper.getReport_Period() + endPeriod;
                        }
                        this.endDate = RPTDateUtil.getPeriodLastDate((int)endYear, (int)endPeriod, (RptPeriodTypeEnum)periodTypeEnum);
                    }
                }
                if (this.endDate == null) {
                    throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getResourceSince51("thisYearAndPeriodNotExist")});
                }
            } else {
                Calendar cal = Calendar.getInstance();
                cal.set(10, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                int year = 0;
                int mouth = 0;
                int day = 0;
                int i = 0;
                StringTokenizer tok = new StringTokenizer(this.endDateString, "-");
                while (tok.hasMoreElements()) {
                    String intv = (String)tok.nextElement();
                    switch (++i) {
                        case 1: {
                            year = Integer.parseInt(intv);
                            cal.set(1, year);
                            break;
                        }
                        case 2: {
                            mouth = Integer.parseInt(intv);
                            cal.set(2, mouth - 1);
                            break;
                        }
                        case 3: {
                            day = Integer.parseInt(intv);
                            cal.set(5, day);
                        }
                    }
                }
                this.endDate = cal.getTime();
            }
            this.adjust();
            this.isCalAll();
        }

        private void isCalAll() {
            boolean bl = this.isCalcAll = this.from != null && (this.from.equals("0") || this.from.trim().length() == 0) && this.to != null && this.to.equals("0");
            if (!this.isCalcAll) {
                int fromv = -1;
                if (this.from != null && this.from.trim().length() != 0) {
                    fromv = Integer.parseInt(this.from);
                }
                this.sqlfromDate = AgeCalculator.this.getLastDateByBeforeDay(fromv, this.endDate);
                int tov = -1;
                if (this.to != null && this.to.trim().length() != 0) {
                    tov = Integer.parseInt(this.to);
                }
                this.sqltoDate = AgeCalculator.this.getLastDateByBeforeDay(tov, this.endDate);
            }
        }

        private void adjust() throws ReportException {
            this.adjustFromAndTo();
            if (this.balType == null || this.balType.trim().length() == 0) {
                this.balType = "E";
            }
            if (!this.balType.equalsIgnoreCase("E") && !this.balType.equalsIgnoreCase("B")) {
                throw new ReportException(ReportException.TYPEERROR);
            }
            this.parseAcctItem();
            this.endDate = DateTimeUtils.truncateDate((java.util.Date)this.endDate);
        }

        private void parseAcctItem() throws ReportException {
            if (this.acctItem == null || this.acctItem.length() < 1) {
                throw new ReportException(ReportException.PARAM_IS_NOT_INTEGRATED);
            }
            AcctountAsstItemParser.AccountAsstItem asstitem = null;
            try {
                asstitem = AcctountAsstItemParser.parse(this.acctItem);
            }
            catch (ParseException e) {
                throw new ReportException(new NumericExceptionSubItem("007", ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"54_AgeCalculator", (Locale)AgeCalculator.this.serverContext.getLocale())));
            }
            this.asstItems = asstitem.asstItems;
            this.accountFromNumber = asstitem.startNumber;
            this.accountToNumber = asstitem.endNumber;
            if (this.accountFromNumber != null && this.accountFromNumber.trim().length() == 0) {
                this.accountFromNumber = null;
            }
            if (this.accountToNumber != null && this.accountToNumber.trim().length() == 0) {
                this.accountToNumber = null;
            }
            if (asstitem.asstItems != null && asstitem.asstItems.length >= 1) {
                this.actItemType = 2;
                for (int i = 0; i < asstitem.asstItems.length; ++i) {
                    AgeCalculator.this.asstActTypeNumberSet.add(asstitem.asstItems[i].asstTypeNumber);
                }
            }
        }

        private void adjustFromAndTo() {
            if (this.from != null && this.from.trim().length() > 0 && this.to != null && this.to.trim().length() > 0) {
                int f = Integer.parseInt(this.from);
                int t = Integer.parseInt(this.to);
                if (t < f) {
                    String temp = this.from;
                    this.from = this.to;
                    this.to = temp;
                }
            }
        }

        public Object[] getFields() {
            return null;
        }
    }
}

