/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.io.BookIOUtil;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.eas.fi.newrpt.AnalysisReportCollection;
import com.kingdee.eas.fi.newrpt.AnalysisReportFactory;
import com.kingdee.eas.fi.newrpt.IAnalysisReport;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.report.ItemAnalysisConstant;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ArefBatchCalculater {
    private static Logger logger = Logger.getLogger((String)ArefBatchCalculater.class.getName());
    private ICalculateContextProvider calCulateContext;
    private Context serverContext;
    private String splitStr = ";;";

    public ArefBatchCalculater(ICalculateContextProvider context, Context serverCtx) {
        this.calCulateContext = context;
        this.serverContext = serverCtx;
    }

    public void execute(SortedParameterArray params) {
        Map<String, List<Aref>> groupMap = this.groupAref(params);
        this.getDataByGroup(groupMap);
        groupMap.clear();
    }

    private void getDataByGroup(Map<String, List<Aref>> groupMap) {
        List<Aref> arefs = null;
        try {
            AnalysisReportCollection coll = null;
            byte[] data = null;
            HashMap<String, Object> fetchDataMap = new HashMap<String, Object>();
            IAnalysisReport ianalysisRpt = AnalysisReportFactory.getLocalInstance((Context)this.serverContext);
            for (String key : groupMap.keySet()) {
                fetchDataMap.clear();
                arefs = groupMap.get(key);
                if (arefs.isEmpty()) continue;
                coll = ianalysisRpt.getAnalysisReportCollection("select data where company.number='" + key.split(this.splitStr)[0] + "' and number='" + key.split(this.splitStr)[1] + "'");
                if (coll != null && coll.size() > 0) {
                    data = coll.get(0).getData();
                    this.getFetchDataMap(fetchDataMap, arefs);
                    BookIOUtil.loadSomeCellValues((byte[])data, fetchDataMap);
                    logger.info((Object)("aref get value:" + fetchDataMap.toString()));
                    this.setValue(fetchDataMap, arefs);
                    continue;
                }
                this.setException(arefs, MessageFormat.format(EASResource.getString((String)ItemAnalysisConstant.resClassName, (String)"99_analysisRptNumberNotExist"), key.split(this.splitStr)[1]));
            }
            fetchDataMap.clear();
        }
        catch (Exception ex) {
            logger.error((Object)"handle error.", (Throwable)ex);
            this.setException(arefs, ex.getMessage());
        }
    }

    private void setValue(Map<String, Object> fetchDataMap, List<Aref> arefs) {
        Object obj = null;
        for (Aref aref : arefs) {
            obj = fetchDataMap.get(aref.getCellAdress());
            if (obj == null || "".equals(obj.toString())) {
                obj = Variant.nullVariant;
            }
            aref.param.setValue(obj);
        }
    }

    private void getFetchDataMap(Map<String, Object> fetchDataMap, List<Aref> arefs) {
        for (Aref aref : arefs) {
            fetchDataMap.put(aref.getCellAdress(), null);
        }
    }

    private void setException(List<Aref> arefs, String message) {
        for (Aref aref : arefs) {
            aref.isException = true;
            aref.param.setValue((Object)new SyntaxErrorException(128L, (Object)message));
        }
    }

    private Map<String, List<Aref>> groupAref(SortedParameterArray params) {
        HashMap<String, List<Aref>> groupArefMap = new HashMap<String, List<Aref>>();
        Aref aref = null;
        String key = null;
        ArrayList<Aref> arefs = null;
        for (int i = 0; i < params.size(); ++i) {
            aref = new Aref(params.getParameter(i));
            if (aref.isException) continue;
            key = aref.orgNumber + this.splitStr + aref.analysisRptNumber;
            arefs = (ArrayList<Aref>)groupArefMap.get(key);
            if (arefs == null) {
                arefs = new ArrayList<Aref>();
            }
            arefs.add(aref);
            groupArefMap.put(key, arefs);
        }
        return groupArefMap;
    }

    private class Aref {
        String orgNumber = null;
        String analysisRptNumber = null;
        String sheetName = null;
        String cellName = null;
        boolean isException = false;
        Parameter param = null;

        public Aref(Parameter param) {
            this.param = param;
            Object[] args = param.getArgs();
            this.initArgs(args);
        }

        private void initArgs(Object[] args) {
            if (args.length != 4) {
                this.isException = true;
                this.param.setValue((Object)new SyntaxErrorException(128L, (Object)"args count is not right."));
            } else {
                this.orgNumber = String.valueOf(args[0]);
                this.analysisRptNumber = String.valueOf(args[1]);
                this.sheetName = String.valueOf(args[2]);
                this.cellName = String.valueOf(args[3]);
                if (StringUtils.isEmpty((String)this.orgNumber)) {
                    this.orgNumber = (String)ArefBatchCalculater.this.calCulateContext.getReportAdapter().getReportProperty("Company.Number");
                }
                if (StringUtils.isEmpty((String)this.orgNumber)) {
                    this.isException = true;
                    this.param.setValue((Object)new SyntaxErrorException(128L, (Object)EASResource.getString((String)ItemAnalysisConstant.resClassName, (String)"101_orgUnitCantNull")));
                }
                if (StringUtils.isEmpty((String)this.analysisRptNumber)) {
                    this.isException = true;
                    this.param.setValue((Object)new SyntaxErrorException(128L, (Object)EASResource.getString((String)ItemAnalysisConstant.resClassName, (String)"100_analysisRptNumberCantNull")));
                }
                if (StringUtils.isEmpty((String)this.sheetName)) {
                    this.isException = true;
                    this.param.setValue((Object)new SyntaxErrorException(128L, (Object)EASResource.getString((String)ItemAnalysisConstant.resClassName, (String)"102_SheetNameCantNull")));
                }
                if (StringUtils.isEmpty((String)this.cellName)) {
                    this.isException = true;
                    this.param.setValue((Object)new SyntaxErrorException(128L, (Object)EASResource.getString((String)ItemAnalysisConstant.resClassName, (String)"103_cellNameCantNull")));
                }
            }
        }

        public String getCellAdress() {
            return (this.sheetName + "!" + this.cellName).toUpperCase();
        }

        public boolean isException() {
            return this.isException;
        }
    }
}

