/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch;

import com.kingdee.eas.fi.rpt.batch.IBatchSQLSortState;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSorterRegister;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BatchSQLSorterRegister
implements IBatchSQLSorterRegister {
    private static Logger logger = Logger.getLogger(BatchSQLSorterRegister.class);
    protected List stateList = new LinkedList();
    protected IBatchSQLSortState sortState;
    protected Map sortMap = new HashMap();
    protected Map context;

    public BatchSQLSorterRegister(Map context, String sortStateClassName) {
        this.context = context;
        try {
            Object instance = Class.forName(sortStateClassName).newInstance();
            if (instance instanceof IBatchSQLSortState) {
                this.sortState = (IBatchSQLSortState)instance;
                this.sortState.setContext(context);
            }
        }
        catch (InstantiationException e) {
            logger.error((Object)sortStateClassName, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)sortStateClassName, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)sortStateClassName, (Throwable)e);
        }
    }

    public BatchSQLSorterRegister(Map context) {
        this.context = context;
    }

    @Override
    public List getSortStates() {
        return this.stateList;
    }

    @Override
    public void register(IFormulaCalculator formula) {
        if (this.sortState != null) {
            this.setSortState(formula);
            String key = this.sortState.generateKey();
            IBatchSQLSortState state = (IBatchSQLSortState)this.sortMap.get(key);
            if (state == null) {
                state = (IBatchSQLSortState)this.sortState.clone();
                state.setContext(this.context);
                this.stateList.add(state);
                this.sortMap.put(key, state);
            }
            state.addFormula(formula);
        } else {
            formula.getParameter().setValue(null);
        }
    }

    protected void setSortState(IFormulaCalculator formula) {
        this.sortState.reset();
        this.sortState.setState(formula);
    }

    public void setSortState(IBatchSQLSortState sortState) {
        this.sortState = sortState;
    }

    public void clearRegister() {
        this.stateList.clear();
        this.sortMap.clear();
    }
}

