/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch;

import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLProcessor;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.IFormulaCombinationPreparedState;
import com.kingdee.eas.fi.rpt.batch.IFormulaMutiReturnValue;
import com.kingdee.eas.fi.rpt.batch.IMutiReturnValueSQLProcessor;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.util.PropertyContainer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CalculatorCombiner {
    private Map propertyToCalculatorMap;
    private Set possibleCombination;
    private IFormulaCombinationPreparedState prepareState;

    public CalculatorCombiner(Map propertyToCalculatorMap, Set allowedNullFields) {
        this.propertyToCalculatorMap = propertyToCalculatorMap;
        this.possibleCombination = CalculatorCombiner.getAllPossibleCombination(allowedNullFields);
    }

    public CalculatorCombiner(Map propertyToCalculatorMap) {
        this.propertyToCalculatorMap = propertyToCalculatorMap;
        this.possibleCombination = new HashSet();
        this.possibleCombination.add(new HashSet());
    }

    public CalculatorCombiner() {
        this.propertyToCalculatorMap = new HashMap();
        this.possibleCombination = new HashSet();
        this.possibleCombination.add(new HashSet());
    }

    public CalculatorCombiner(Set allowedNullFields) {
        this.propertyToCalculatorMap = new HashMap();
        this.possibleCombination = CalculatorCombiner.getAllPossibleCombination(allowedNullFields);
    }

    public void setAllowedNullFields(Set allowedNullFields) {
        this.possibleCombination = CalculatorCombiner.getAllPossibleCombination(allowedNullFields);
    }

    public void addFormulaParameter(PropertyContainer index, IFormulaCalculator parameter) {
        if (this.propertyToCalculatorMap.get(index) != null) {
            Object oldParameter = this.propertyToCalculatorMap.get(index);
            if (oldParameter instanceof List) {
                ((List)oldParameter).add(parameter);
            } else {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(oldParameter);
                list.add(parameter);
                this.propertyToCalculatorMap.put(index, list);
            }
        } else {
            this.propertyToCalculatorMap.put(index, parameter);
        }
    }

    public void addFormulaParameter(String index, IFormulaCalculator parameter) {
        if (this.propertyToCalculatorMap.get(index) != null) {
            Object oldParameter = this.propertyToCalculatorMap.get(index);
            if (oldParameter instanceof List) {
                ((List)oldParameter).add(parameter);
            } else {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(oldParameter);
                list.add(parameter);
                this.propertyToCalculatorMap.put(index, list);
            }
        } else {
            this.propertyToCalculatorMap.put(index, parameter);
        }
    }

    public void combineValue(PropertyContainer propertyFromDatabase, Object value, boolean isNumberValue) {
        for (Set fileds : this.possibleCombination) {
            PropertyContainer property = (PropertyContainer)propertyFromDatabase.clone();
            for (String key : fileds) {
                property.put(key, null);
            }
            ArrayList formulaList = new ArrayList();
            Object formulas = this.propertyToCalculatorMap.get(property);
            if (formulas instanceof IFormulaCalculator) {
                formulaList.add(formulas);
            } else {
                if (!(formulas instanceof Collection)) continue;
                formulaList.addAll((Collection)formulas);
            }
            for (IFormulaCalculator formula : formulaList) {
                if ((formula == null || this.prepareState != null) && (formula == null || !this.prepareState.isPrepared(formula))) continue;
                this.combineEachValue(formula, value, isNumberValue);
            }
        }
    }

    public void combineValue(String propertyFromDatabase, boolean isNumberValue) {
        this.combineValue(propertyFromDatabase, isNumberValue, null);
    }

    public void combineValue(String propertyFromDatabase, boolean isNumberValue, IBatchSQLProcessor sqlBuilder) {
        Object formulas = this.propertyToCalculatorMap.get(propertyFromDatabase);
        if (this.prepareState == null) {
            return;
        }
        if (formulas instanceof IFormulaCalculator) {
            IFormulaCalculator formula = (IFormulaCalculator)formulas;
            this.combineEachValue(formula, isNumberValue, sqlBuilder);
        } else if (formulas instanceof Collection) {
            Collection formulaList = (Collection)formulas;
            for (IFormulaCalculator formula : formulaList) {
                this.combineEachValue(formula, isNumberValue, sqlBuilder);
            }
        }
    }

    public void combineEachValue(IFormulaCalculator formula, boolean isNumberValue, IBatchSQLProcessor sqlBuilder) {
        if (formula != null && this.prepareState.isPrepared(formula)) {
            if (sqlBuilder != null && sqlBuilder instanceof IMutiReturnValueSQLProcessor && ((IMutiReturnValueSQLProcessor)((Object)sqlBuilder)).isMutiReturnValue() && formula instanceof IFormulaMutiReturnValue) {
                ((IFormulaMutiReturnValue)((Object)formula)).processMutiReturnValue(this.prepareState);
            } else {
                Object value = this.prepareState.getFormulaResultValue(formula);
                this.combineEachValue(formula, value, isNumberValue);
            }
        }
    }

    public void combineValue(String propertyFromDatabase, Object value, boolean isNumberValue) {
        if (this.prepareState == null) {
            return;
        }
        Object formulas = this.propertyToCalculatorMap.get(propertyFromDatabase);
        if (formulas instanceof IFormulaCalculator) {
            IFormulaCalculator formula = (IFormulaCalculator)formulas;
            if (formula != null && this.prepareState.isPrepared(formula)) {
                this.combineEachValue(formula, value, isNumberValue);
            }
        } else if (formulas instanceof Collection) {
            Collection formulaList = (Collection)formulas;
            for (IFormulaCalculator formula : formulaList) {
                if (formula == null || !this.prepareState.isPrepared(formula)) continue;
                this.combineEachValue(formula, value, isNumberValue);
            }
        }
    }

    public void combineValue(String propertyFromDatabase) {
        if (this.prepareState == null) {
            return;
        }
        Object formulas = this.propertyToCalculatorMap.get(propertyFromDatabase);
        if (formulas instanceof IFormulaCalculator) {
            IFormulaCalculator formula = (IFormulaCalculator)formulas;
            if (formula != null && this.prepareState.isPrepared(formula)) {
                Object value = this.prepareState.getFormulaResultValue(formula);
                this.combineEachValue(formula, value, this.prepareState.isFormulaResultNumberValue(formula));
            }
        } else if (formulas instanceof Collection) {
            Collection formulaList = (Collection)formulas;
            for (Object o : formulaList) {
                IFormulaCalculator formula = (IFormulaCalculator)o;
                if (formula == null || !this.prepareState.isPrepared(formula)) continue;
                Object value = this.prepareState.getFormulaResultValue(formula);
                this.combineEachValue(formula, value, this.prepareState.isFormulaResultNumberValue(formula));
            }
        }
    }

    public void combineValue(PropertyContainer propertyFromDatabase) {
        if (this.prepareState == null) {
            return;
        }
        for (Set fileds : this.possibleCombination) {
            PropertyContainer property = (PropertyContainer)propertyFromDatabase.clone();
            for (String key : fileds) {
                property.put(key, null);
            }
            ArrayList formulaList = new ArrayList();
            Object formulas = this.propertyToCalculatorMap.get(property);
            if (formulas instanceof IFormulaCalculator) {
                formulaList.add(formulas);
            } else {
                if (!(formulas instanceof Collection)) continue;
                formulaList.addAll((Collection)formulas);
            }
            for (Object o : formulaList) {
                IFormulaCalculator formula = (IFormulaCalculator)o;
                if (formula == null || !this.prepareState.isPrepared(formula)) continue;
                Object value = this.prepareState.getFormulaResultValue(formula);
                this.combineEachValue(formula, value, this.prepareState.isFormulaResultNumberValue(formula));
            }
        }
    }

    public Object getFormulaResultValue(IFormulaCalculator formula) {
        return this.prepareState.getFormulaResultValue(formula);
    }

    public void combineEachValue(IFormulaCalculator formula, Object value, boolean isNumberValue) {
        Parameter parameter = formula.getParameter();
        if (isNumberValue) {
            Object old = parameter.getValue();
            String sheetName = parameter.getSheetName();
            if (DebugLogger.isDebug && sheetName.equalsIgnoreCase("debug")) {
                return;
            }
            if (old == null || "".equals(old.toString().trim())) {
                try {
                    BigDecimal newValue = new BigDecimal(value.toString());
                    parameter.setValue((Object)newValue);
                }
                catch (Exception e) {
                    parameter.setValue(value);
                }
            } else if (value instanceof String) {
                BigDecimal oldValue = null;
                try {
                    oldValue = new BigDecimal(old.toString());
                }
                catch (RuntimeException e1) {
                    old = CslConstant.BGZERO;
                    oldValue = CslConstant.BGZERO;
                }
                try {
                    BigDecimal newValue = new BigDecimal(value.toString());
                    parameter.setValue((Object)oldValue.add(newValue));
                }
                catch (RuntimeException e) {
                    parameter.setValue(value);
                }
            } else if (value instanceof BigDecimal) {
                BigDecimal oldValue = null;
                try {
                    oldValue = new BigDecimal(old.toString());
                }
                catch (RuntimeException e1) {
                    old = CslConstant.BGZERO;
                    oldValue = CslConstant.BGZERO;
                }
                try {
                    BigDecimal newValue = (BigDecimal)value;
                    parameter.setValue((Object)oldValue.add(newValue));
                }
                catch (RuntimeException e) {
                    parameter.setValue(value);
                }
            }
        } else {
            parameter.setValue(value);
        }
    }

    public static Set getAllPossibleCombination(Set allowedNullFields) {
        HashSet<Set> sum = new HashSet<Set>();
        sum.add(allowedNullFields);
        CalculatorCombiner.divideCombin(allowedNullFields, sum);
        return sum;
    }

    private static void divideCombin(Set pre, Set sum) {
        Iterator iterator = pre.iterator();
        while (iterator.hasNext()) {
            HashSet result = new HashSet();
            result.addAll(pre);
            result.remove(iterator.next());
            sum.add(result);
            if (result.size() <= 0) continue;
            CalculatorCombiner.divideCombin(result, sum);
        }
    }

    public void combineValuesWithPropertySet(IFormulaCalculator formula, Collection values, boolean isNumberValue) {
        for (Object value : values) {
            this.combineEachValue(formula, value, isNumberValue);
        }
    }

    public Set getPossibleCombination() {
        return this.possibleCombination;
    }

    public void setPrepareState(IFormulaCombinationPreparedState prepareState) {
        this.prepareState = prepareState;
    }

    public IFormulaCombinationPreparedState getPrepareState() {
        return this.prepareState;
    }

    public void setPropertyToCalculatorMap(Map propertyToCalculatorMap) {
        this.propertyToCalculatorMap = propertyToCalculatorMap;
    }

    public Map getPropertyToCalculatorMap() {
        return this.propertyToCalculatorMap;
    }
}

