/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ColumnInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.TableInfo;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.ICalculaterContextExt;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fi.rpt.batch.ExceptionSeter;
import com.kingdee.eas.fi.rpt.util.ArrayIterator;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ChecFmlParamPermissionUtil
implements Serializable {
    private static final long serialVersionUID = 5384785490176101704L;
    private Context ServerCtx = null;
    private HashMap orgTreePermision = null;
    private HashMap UserPermissionOrgsCache = null;
    private HashMap unitAcompPermision = null;
    private Map UserProfitCenterOrgPermissionsCache = null;
    private HashMap UserProfitCenterCalPermissionOrgsCache = null;
    private Set permissionOrgTreeIdSet;
    HashMap _unitAcompPermision = new HashMap();
    private IPermission permission;

    public ChecFmlParamPermissionUtil(Context _ServerCtx) throws BOSException {
        this.ServerCtx = _ServerCtx;
    }

    public void checkCompanyAndProfPermision(String company) throws ReportException, BOSException {
        this.initCompanyPermision();
        this.initProfPermision();
        Iterator stoken = this.split(company);
        while (stoken.hasNext()) {
            String trim = stoken.next().toString().trim().toUpperCase();
            if (this.UserPermissionOrgsCache.get(trim) != null || this.UserProfitCenterCalPermissionOrgsCache.get(trim) != null) continue;
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"35_Acctext", (Locale)this.ServerCtx.getOriginLocale()) + trim + ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"36_Acctext", (Locale)this.ServerCtx.getOriginLocale())});
        }
    }

    public void checkCompanyPermision(OrgType orgType, String orgNum) throws ReportException, BOSException {
        this.initCompanyPermision();
        this.initProfitCenterPermision();
        Iterator stoken = this.split(orgNum);
        while (stoken.hasNext()) {
            String trim = stoken.next().toString().trim();
            if (this.getUserPermissionCache(orgType).get(trim.toUpperCase()) != null) continue;
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"35_Acctext", (Locale)this.ServerCtx.getOriginLocale()) + trim + ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"36_Acctext", (Locale)this.ServerCtx.getOriginLocale())});
        }
    }

    private void initProfPermision() throws BOSException {
        if (this.UserProfitCenterCalPermissionOrgsCache != null) {
            return;
        }
        this.UserProfitCenterCalPermissionOrgsCache = new HashMap();
        FullOrgUnitCollection fullOrgs = null;
        try {
            fullOrgs = PermissionFactory.getLocalInstance((Context)this.ServerCtx).getAuthorizedOrg((IObjectPK)new ObjectUuidPK(this.ServerCtx.getCaller().toString()), OrgType.ProfitCenter, null, "prof_calculate_getsql");
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        if (fullOrgs == null || fullOrgs.size() == 0) {
            return;
        }
        int n = fullOrgs.size();
        for (int i = 0; i < n; ++i) {
            this.UserProfitCenterCalPermissionOrgsCache.put(fullOrgs.get(i).getNumber().toUpperCase(), fullOrgs.get(i).getId());
        }
    }

    public void checkCompanyPermisionNotSplit(OrgType orgType, String orgNum) throws ReportException, BOSException {
        this.initCompanyPermision();
        this.initProfitCenterPermision();
        if (this.getUserPermissionCache(orgType).get(orgNum.toUpperCase()) == null) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"35_Acctext", (Locale)this.ServerCtx.getOriginLocale()) + orgNum + ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"36_Acctext", (Locale)this.ServerCtx.getOriginLocale())});
        }
    }

    private Map getUserPermissionCache(OrgType orgType) {
        if (OrgType.ProfitCenter.equals((Object)orgType)) {
            return this.UserProfitCenterOrgPermissionsCache;
        }
        if (orgType == null || OrgType.Company.equals((Object)orgType)) {
            return this.UserPermissionOrgsCache;
        }
        return this.UserPermissionOrgsCache;
    }

    public void checkCompanyPermision(String company) throws ReportException, BOSException {
        this.initCompanyPermision();
        Iterator stoken = this.split(company);
        while (stoken.hasNext()) {
            String trim = stoken.next().toString().trim().toUpperCase();
            if (this.UserPermissionOrgsCache.get(trim.toUpperCase()) != null) continue;
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"35_Acctext", (Locale)this.ServerCtx.getOriginLocale()) + trim + ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"36_Acctext", (Locale)this.ServerCtx.getOriginLocale())});
        }
    }

    public void checkOrgTreePremision(String orgTree) throws ReportException, BOSException {
        Iterator stoken = this.split(orgTree);
        this.initUnitPremision();
        while (stoken.hasNext()) {
            String trim = stoken.next().toString().trim();
            if (this.orgTreePermision.get(trim.toUpperCase()) != null) continue;
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"NoCompanyPermission", (Locale)this.ServerCtx.getOriginLocale())});
        }
    }

    public void checkCommitRepotPermision(String orgTree, String company) throws ReportException, BOSException {
        this.initCompanyPermision();
        Iterator companyStoken = this.split(company);
        while (companyStoken.hasNext()) {
            String comTrim = companyStoken.next().toString().trim();
            Iterator orgTreeStoken = this.split(orgTree);
            this.initUnitPremision();
            while (orgTreeStoken.hasNext()) {
                String orgTrim = orgTreeStoken.next().toString().trim();
                if (this.UserPermissionOrgsCache.get(comTrim.toUpperCase()) != null || this.orgTreePermision.get(orgTrim.toUpperCase()) != null) continue;
                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"NoCompanyPermission", (Locale)this.ServerCtx.getOriginLocale())});
            }
        }
    }

    public void checkCommitRepotPermision(OrgType orgType, String orgTree, String company) throws ReportException, BOSException {
        if (orgType.equals((Object)OrgType.Company)) {
            this.initCompanyPermision();
        } else {
            this.initProfitCenterPermision();
        }
        Iterator companyStoken = this.split(company);
        while (companyStoken.hasNext()) {
            String comTrim = companyStoken.next().toString().trim();
            Iterator orgTreeStoken = this.split(orgTree);
            this.initUnitPremision();
            while (orgTreeStoken.hasNext()) {
                String orgTrim = orgTreeStoken.next().toString().trim();
                if (this.getUserPermissionCache(orgType).get(comTrim.toUpperCase()) != null || this.orgTreePermision.get(orgTrim.toUpperCase()) != null) continue;
                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"NoCompanyPermission", (Locale)this.ServerCtx.getOriginLocale())});
            }
        }
    }

    private Iterator split(String str) {
        Object[] array = str.split("\\||\\,|\\;");
        return new ArrayIterator(array);
    }

    public void checkUnitCompPermision(String unit) throws ReportException, BOSException {
        this.initCompanyPermision();
        this.initUnitPremision();
        Iterator stoken = this.split(unit);
        while (stoken.hasNext()) {
            String trim = stoken.next().toString().trim();
            if (this.unitAcompPermision.get(trim.toUpperCase()) != null || this.UserPermissionOrgsCache.get(trim.toUpperCase()) != null) continue;
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"NoCompanyPermission", (Locale)this.ServerCtx.getOriginLocale())});
        }
    }

    public void checkUnitCompPermision(OrgType orgType, String unit) throws ReportException, BOSException {
        this.initCompanyPermision();
        this.initProfitCenterPermision();
        this.initUnitPremision();
        Iterator stoken = this.split(unit);
        while (stoken.hasNext()) {
            String trim = stoken.next().toString().trim();
            if (this.unitAcompPermision.get(trim.toUpperCase()) != null || this.getUserPermissionCache(orgType).get(trim.toUpperCase()) != null) continue;
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"NoCompanyPermission", (Locale)this.ServerCtx.getOriginLocale())});
        }
    }

    public void checkUnitCompPermision(Set units, Set orgTrees, Map units2Handler) throws ReportException, BOSException {
        if (units.isEmpty()) {
            return;
        }
        HashSet<String> checkUnits = new HashSet<String>();
        HashMap smallUnits2Handler = new HashMap();
        for (String unit : units) {
            Iterator stoken = this.split(unit);
            Object ref = units2Handler.get(unit);
            while (stoken.hasNext()) {
                String trim = stoken.next().toString().trim();
                checkUnits.add(trim);
                smallUnits2Handler.put(trim, ref);
            }
        }
        this.checkUnitPermissionForShortNumber(checkUnits, orgTrees, smallUnits2Handler);
    }

    public void _checkUnitCompPermision(String orgn, String unit) throws ReportException, BOSException {
        this.initUnitPremision();
        Iterator stoken = this.split(unit);
        while (stoken.hasNext()) {
            String trim = stoken.next().toString().trim();
            if (orgn != null && this._unitAcompPermision.get(orgn.toUpperCase() + "$" + trim.toUpperCase()) != null) continue;
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"NoCompanyPermission", (Locale)this.ServerCtx.getOriginLocale())});
        }
    }

    public void checkUnitCompPermissionForLongNumber(Set units, Set treeNums, Map units2Handler) throws ReportException, BOSException {
        if (units.isEmpty()) {
            return;
        }
        HashSet<String> longNumberUnitComposites = new HashSet<String>();
        HashMap smallUnits2Handler = new HashMap();
        for (String unit : units) {
            String headUnit = unit.substring(0, unit.indexOf("!"));
            String tailUnit = unit.substring(1 + unit.indexOf("!"));
            treeNums.add(headUnit);
            Iterator stoken = this.split(tailUnit);
            Object handler = units2Handler.get(unit);
            while (stoken.hasNext()) {
                String trim = stoken.next().toString().trim();
                String newOrg = headUnit.toUpperCase() + "$" + trim.toUpperCase();
                longNumberUnitComposites.add(newOrg);
                smallUnits2Handler.put(newOrg, handler);
            }
        }
        this.checkUnitPermissionForLongNumber(longNumberUnitComposites, treeNums, smallUnits2Handler);
    }

    private void initCompanyPermision() throws BOSException {
        if (this.UserPermissionOrgsCache != null) {
            return;
        }
        this.UserPermissionOrgsCache = new HashMap();
        FullOrgUnitCollection fullOrgs = null;
        try {
            fullOrgs = PermissionFactory.getLocalInstance((Context)this.ServerCtx).getAuthorizedOrg((IObjectPK)new ObjectUuidPK(this.ServerCtx.getCaller().toString()), OrgType.Company, null, "rpt_report_calculate");
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        if (fullOrgs == null || fullOrgs.size() == 0) {
            return;
        }
        int n = fullOrgs.size();
        for (int i = 0; i < n; ++i) {
            this.UserPermissionOrgsCache.put(fullOrgs.get(i).getNumber().toUpperCase(), fullOrgs.get(i).getId());
        }
    }

    private void initProfitCenterPermision() throws BOSException {
        if (this.UserProfitCenterOrgPermissionsCache != null) {
            return;
        }
        this.UserProfitCenterOrgPermissionsCache = new HashMap();
        FullOrgUnitCollection fullOrgs = null;
        try {
            fullOrgs = PermissionFactory.getLocalInstance((Context)this.ServerCtx).getAuthorizedOrg((IObjectPK)new ObjectUuidPK(this.ServerCtx.getCaller().toString()), OrgType.ProfitCenter, null, "prof_rpt_update");
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        if (fullOrgs == null || fullOrgs.size() == 0) {
            return;
        }
        int n = fullOrgs.size();
        for (int i = 0; i < n; ++i) {
            this.UserProfitCenterOrgPermissionsCache.put(fullOrgs.get(i).getNumber().toUpperCase(), fullOrgs.get(i).getId());
        }
    }

    private Set getPermissionOrgTreeId() {
        if (this.permissionOrgTreeIdSet != null) {
            return this.permissionOrgTreeIdSet;
        }
        if (this.orgTreePermision == null) {
            return null;
        }
        this.permissionOrgTreeIdSet = new HashSet();
        for (Object object : this.orgTreePermision.values()) {
            if (object instanceof String) {
                this.permissionOrgTreeIdSet.add(object);
                continue;
            }
            if (!(object instanceof Collection)) continue;
            this.permissionOrgTreeIdSet.addAll((Collection)object);
        }
        return this.permissionOrgTreeIdSet;
    }

    private Set getPermissionOrgTreeId(Set treeNumLimits) {
        if (this.orgTreePermision == null) {
            return null;
        }
        HashSet<String> upperTreeNumLimits = new HashSet<String>();
        for (Object number : treeNumLimits) {
            if (number == null) continue;
            upperTreeNumLimits.add(number.toString().toUpperCase());
        }
        HashSet permOrgTreeIds = new HashSet();
        for (Map.Entry entry : this.orgTreePermision.entrySet()) {
            if (!upperTreeNumLimits.contains(entry.getKey())) continue;
            Object treeIds = entry.getValue();
            if (treeIds instanceof String) {
                permOrgTreeIds.add(treeIds);
                continue;
            }
            if (!(treeIds instanceof Collection)) continue;
            permOrgTreeIds.addAll((Collection)treeIds);
        }
        upperTreeNumLimits.clear();
        return permOrgTreeIds;
    }

    private void initOrgTreePermision() throws BOSException {
        if (this.orgTreePermision != null) {
            return;
        }
        this.orgTreePermision = new HashMap();
        OrgTreeCollection tree = null;
        try {
            tree = this.getPermission().getAllUnionTrees((IObjectPK)new ObjectUuidPK(this.ServerCtx.getCaller().toString()));
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        int n = tree.size();
        for (int i = 0; i < n; ++i) {
            Object object = this.orgTreePermision.get(tree.get(i).getNumber().toUpperCase());
            if (object != null) {
                ArrayList<Object> list;
                if (object instanceof String) {
                    list = new ArrayList<Object>();
                    list.add(object);
                    list.add(tree.get(i).getId().toString());
                    this.orgTreePermision.put(tree.get(i).getNumber().toUpperCase(), list);
                    continue;
                }
                list = (ArrayList<Object>)object;
                list.add(tree.get(i).getId().toString());
                continue;
            }
            this.orgTreePermision.put(tree.get(i).getNumber().toUpperCase(), tree.get(i).getId().toString());
        }
    }

    private void initUnitPremision() throws BOSException {
        if (this.unitAcompPermision != null) {
            return;
        }
        this.unitAcompPermision = new HashMap();
        this.initOrgTreePermision();
        if (this.orgTreePermision.size() > 0) {
            ParamTempTblService service = null;
            try {
                HashSet unionUnits = new HashSet();
                Iterator it = this.getPermissionOrgTreeId().iterator();
                while (it.hasNext()) {
                    Map units = this.getPermission().getUnionUnits(this.ServerCtx.getCaller(), (IObjectPK)new ObjectUuidPK(it.next().toString()));
                    unionUnits.addAll(units.keySet());
                }
                String unitIdStrs = null;
                if (unionUnits.size() < 50) {
                    unitIdStrs = CslRptUtil.changeIdSet2String(unionUnits);
                } else {
                    TableInfo table = new TableInfo("T_CSL_unitIdTable");
                    table.addColumn(new ColumnInfo("FId", "varchar(44)"));
                    service = ParamTempTblService.getInstance((Context)this.ServerCtx, (TableInfo)table, unionUnits, null);
                    unitIdStrs = "select fid from " + service.getTmpTableName();
                }
                StringBuffer kqlBuffer = new StringBuffer();
                kqlBuffer.append("SELECT distinct unit.FNumber unitNumber, tree.FNumber treeNumber FROM T_ORG_Structure  structure \n").append(" INNER JOIN T_ORG_BASEUNIT unit ON structure.FUnitId = unit.FID                \n").append(" INNER JOIN T_ORG_TREE tree ON structure.FTreeId = tree.FID                    \n").append(" LEFT OUTER JOIN T_ORG_Structure parent ON structure.FParentID = parent.FID    \n").append(" WHERE tree.FID IN ").append(BatchHelper.buildInSql(this.getPermissionOrgTreeId().iterator(), this.ServerCtx)).append("\n").append(" AND (unit.FIsUnion = 0 AND parent.FUnitId IN (").append(unitIdStrs).append(")").append("\n").append(" OR unit.FID IN (").append(unitIdStrs).append("))");
                String sql = kqlBuffer.toString();
                IRowSet rs = DbUtil.executeQuery((Context)this.ServerCtx, (String)sql);
                while (rs.next()) {
                    String unitNumber = rs.getString("unitNumber");
                    this._unitAcompPermision.put(rs.getString("treeNumber").toUpperCase() + "$" + unitNumber.toUpperCase(), unitNumber);
                    this.unitAcompPermision.put(unitNumber.toUpperCase(), unitNumber);
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                if (service != null && !DebugLogger.isDebug) {
                    service.release();
                }
            }
        }
    }

    private boolean checkUnitPermissionForLongNumber(Set longNumberUnitComposites, Set treeNums, Map smallUnits2Handler) throws BOSException {
        this.initOrgTreePermision();
        if (this.orgTreePermision.size() > 0) {
            boolean it;
            HashSet unionUnits = new HashSet();
            Set permOrgTreeIds = this.getPermissionOrgTreeId(treeNums);
            if (treeNums.isEmpty() || permOrgTreeIds == null || permOrgTreeIds.isEmpty()) {
                permOrgTreeIds = this.getPermissionOrgTreeId();
            }
            Iterator it2 = permOrgTreeIds.iterator();
            while (it2.hasNext()) {
                String orgTreeId = it2.next().toString();
                Map units = this.getPermission().getUnionUnits(this.ServerCtx.getCaller(), (IObjectPK)new ObjectUuidPK(orgTreeId));
                unionUnits.addAll(units.keySet());
            }
            StringBuffer kqlBuffer = new StringBuffer();
            kqlBuffer.append("SELECT DISTINCT UCASE(CONCAT(CONCAT(TREE.FNUMBER,'$'),UNIT.FNUMBER)) LONG_NUMBER FROM T_ORG_Structure  structure \n").append(" INNER JOIN T_ORG_BASEUNIT unit ON structure.FUnitId = unit.FID                \n").append(" INNER JOIN T_ORG_TREE tree ON structure.FTreeId = tree.FID                    \n").append(" LEFT OUTER JOIN T_ORG_Structure parent ON structure.FParentID = parent.FID    \n").append(" WHERE tree.FID IN ").append(BatchHelper.buildInSql(this.getPermissionOrgTreeId().iterator(), this.ServerCtx)).append("\n").append(" AND ((unit.FIsUnion = 0 AND parent.FUnitId IN ").append(BatchHelper.buildInSql(unionUnits.iterator(), this.ServerCtx)).append(")").append("\n").append(" OR unit.FID IN ").append(BatchHelper.buildInSql(unionUnits.iterator(), this.ServerCtx)).append(")").append(" AND UCASE(CONCAT(CONCAT(TREE.FNUMBER,'$'),UNIT.FNUMBER)) IN ").append(BatchHelper.buildInSql(longNumberUnitComposites.iterator(), this.ServerCtx));
            String sql = kqlBuffer.toString();
            Connection conn = null;
            Statement statement = null;
            ResultSet rs = null;
            try {
                conn = EJBFactory.getQueryConnection((Context)this.ServerCtx);
                statement = conn.createStatement();
                rs = statement.executeQuery(sql);
                while (rs.next()) {
                    longNumberUnitComposites.remove(rs.getString("LONG_NUMBER"));
                }
                for (String exceptUnit : longNumberUnitComposites) {
                    if (smallUnits2Handler.get(exceptUnit) instanceof ExceptionSeter) {
                        ((ExceptionSeter)smallUnits2Handler.get(exceptUnit)).toSetException((Exception)((Object)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"NoCompanyPermission", (Locale)this.ServerCtx.getOriginLocale()) + ":" + exceptUnit})));
                        continue;
                    }
                    if (!(smallUnits2Handler.get(exceptUnit) instanceof Collection)) continue;
                    for (ExceptionSeter handler : (Collection)smallUnits2Handler.get(exceptUnit)) {
                        handler.toSetException((Exception)((Object)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"NoCompanyPermission", (Locale)this.ServerCtx.getOriginLocale()) + ":" + exceptUnit})));
                    }
                }
                it = true;
            }
            catch (SQLException exc) {
                try {
                    try {
                        throw new BOSException("Sql5 execute exception : " + sql, (Throwable)exc);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs, statement, (Connection)conn);
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
            return it;
        }
        return false;
    }

    private boolean checkUnitPermissionForShortNumber(Set unitNumbers, Set treeNums, Map smallUnits2Handler) throws BOSException {
        HashSet waitUnitNumbers = new HashSet(unitNumbers);
        this.initOrgTreePermision();
        if (this.orgTreePermision.size() > 0) {
            try {
                HashSet unionUnits = new HashSet();
                Set permOrgTreeIds = this.getPermissionOrgTreeId(treeNums);
                if (treeNums.isEmpty() || permOrgTreeIds == null || permOrgTreeIds.isEmpty()) {
                    permOrgTreeIds = this.getPermissionOrgTreeId();
                }
                Iterator it = permOrgTreeIds.iterator();
                while (it.hasNext()) {
                    String orgTreeId = it.next().toString();
                    Map units = this.getPermission().getUnionUnits(this.ServerCtx.getCaller(), (IObjectPK)new ObjectUuidPK(orgTreeId));
                    unionUnits.addAll(units.keySet());
                }
                StringBuffer kqlBuffer = new StringBuffer();
                kqlBuffer.append("SELECT DISTINCT unit.FNumber NUMBER FROM T_ORG_Structure  structure \n").append(" INNER JOIN T_ORG_BASEUNIT unit ON structure.FUnitId = unit.FID                \n").append(" INNER JOIN T_ORG_TREE tree ON structure.FTreeId = tree.FID                    \n").append(" LEFT OUTER JOIN T_ORG_Structure parent ON structure.FParentID = parent.FID    \n").append(" WHERE tree.FID IN ").append(BatchHelper.buildInSql(permOrgTreeIds.iterator(), this.ServerCtx)).append("\n").append(" AND ((unit.FIsUnion = 0 AND parent.FUnitId IN ").append(BatchHelper.buildInSql(unionUnits.iterator(), this.ServerCtx)).append(")").append("\n").append(" OR unit.FID IN ").append(BatchHelper.buildInSql(unionUnits.iterator(), this.ServerCtx)).append(")").append(" AND UNIT.FNUMBER IN ").append(BatchHelper.buildInSql(unitNumbers.iterator(), this.ServerCtx));
                String sql = kqlBuffer.toString();
                IRowSet rs = DbUtil.executeQueryNoTx((Context)this.ServerCtx, (String)sql);
                while (rs.next()) {
                    waitUnitNumbers.remove(rs.getString("NUMBER"));
                }
                this.checkSmallUnits2HandlerPermission(waitUnitNumbers, smallUnits2Handler);
                return true;
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        this.checkSmallUnits2HandlerPermission(waitUnitNumbers, smallUnits2Handler);
        return false;
    }

    private void checkSmallUnits2HandlerPermission(Set waitUnitNumbers, Map smallUnits2Handler) {
        for (String exceptUnit : waitUnitNumbers) {
            if (smallUnits2Handler.get(exceptUnit) instanceof ExceptionSeter) {
                ((ExceptionSeter)smallUnits2Handler.get(exceptUnit)).toSetException((Exception)((Object)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"NoCompanyPermission", (Locale)this.ServerCtx.getOriginLocale()) + ":" + exceptUnit})));
                continue;
            }
            if (!(smallUnits2Handler.get(exceptUnit) instanceof Collection)) continue;
            for (ExceptionSeter handler : (Collection)smallUnits2Handler.get(exceptUnit)) {
                handler.toSetException((Exception)((Object)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"NoCompanyPermission", (Locale)this.ServerCtx.getOriginLocale()) + ":" + exceptUnit})));
            }
        }
    }

    private IPermission getPermission() throws BOSException {
        if (this.permission == null) {
            this.permission = this.ServerCtx == null ? PermissionFactory.getRemoteInstance() : PermissionFactory.getLocalInstance((Context)this.ServerCtx);
        }
        return this.permission;
    }

    public static ChecFmlParamPermissionUtil getInstance(ICalculateContextProvider ccp) {
        if (ccp instanceof ICalculaterContextExt) {
            return ((ICalculaterContextExt)ccp).getPermissionUtil();
        }
        return null;
    }
}

