/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.io.BookIOUtil;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.IRptReceived;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.RptReceivedFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.DateUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLPermissionUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fi.rpt.batch.ChecFmlParamPermissionUtil;
import com.kingdee.eas.fi.rpt.batch.ExceptionSeter;
import com.kingdee.eas.fi.rpt.batch.FormulaValueBackfill;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.ma.budget.BgRptReportPropertyAdapter;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class CsRefBatchCalculater {
    private ICalculateContextProvider context;
    private ChecFmlParamPermissionUtil pmc;
    private ReportVariables reportVariables;
    private boolean needCheck;
    private PeriodCollection periods;
    private boolean isMergeByFiscalPeriod;
    private boolean isSupport13Period;
    private boolean isSupportOtherDS;
    private boolean isCheckPermission;
    private static final Logger logger = Logger.getLogger(CsRefBatchCalculater.class);
    private BatchHelper batchHelper;
    private Map<String, Integer> periodTempMap;
    private Map<String, String> orgTreeIdMap;
    HashMap map3;
    private Map<String, String> defaultTreeCache;
    Context ServerCtx;
    private IPermission permission;
    HashMap permissionOrgs;

    public CsRefBatchCalculater(ICalculateContextProvider calContext, Context _serverCtx) {
        block3: {
            this.needCheck = false;
            this.periods = null;
            this.isMergeByFiscalPeriod = false;
            this.isSupport13Period = false;
            this.isSupportOtherDS = false;
            this.isCheckPermission = true;
            this.orgTreeIdMap = new HashMap<String, String>();
            this.map3 = new HashMap();
            this.defaultTreeCache = new HashMap<String, String>();
            this.ServerCtx = null;
            this.permissionOrgs = null;
            this.context = calContext;
            this.ServerCtx = _serverCtx;
            this.batchHelper = new BatchHelper(calContext, _serverCtx);
            this.pmc = this.batchHelper.getPermissionUtilInstance();
            this.reportVariables = calContext.getReportVariables();
            try {
                boolean[] values = CSLParamUtil.batchGetParam((Context)this.ServerCtx, (String[])new String[]{"GR_CSL_REPORT_CHECK", "GR_CSL_Support13Period", "GR_CSL_MergeByFiscalPeriod", "GR_CSL_SupportOtherDS", "GR_CSL_ChkUnitPermissionWhenCalc"});
                this.needCheck = values[0];
                this.isSupport13Period = values[1];
                this.isMergeByFiscalPeriod = values[2];
                if (this.isMergeByFiscalPeriod) {
                    this.periods = FiscalPeriodHelper.initFormualFiscalPeriods((Context)this.ServerCtx, (ICalculateContextProvider)this.context);
                }
                this.isSupportOtherDS = values[3];
                this.isCheckPermission = values[4];
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug((Object)e);
            }
        }
        this.periodTempMap = new HashMap<String, Integer>();
    }

    public void execute(SortedParameterArray params) {
        try {
            Ref ref;
            int i;
            HashMap checkPermission = new HashMap();
            String splitStr = "|";
            checkPermission = new HashMap();
            boolean isIncludeOrgTree = false;
            ArrayList<Ref> refs = new ArrayList<Ref>(params.size());
            HashSet<String> allCheckFIOrgUnits = new HashSet<String>();
            HashSet allCheckFIOrgUnitsByLongNumber = new HashSet();
            HashSet<String> allCheckFIOrgTrees = new HashSet<String>();
            HashMap exceptHandlers = new HashMap();
            for (i = 0; i < params.size(); ++i) {
                String orgUnitNumber;
                String[] strs;
                ref = new Ref(params.getParameter(i));
                if (ref.formulaValue._exception != null) continue;
                if (ref.fiOrgUnit.indexOf("!") >= 0 && (strs = (orgUnitNumber = ref.fiOrgUnit).split("\\!")).length == 2) {
                    ref.fiOrgTree = strs[0];
                    ref.fiOrgUnit = strs[1];
                }
                refs.add(ref);
                RptTmpTypeEnum tmpType = RptTmpTypeEnum.getEnum(ref.groupTempType);
                if (tmpType == null) {
                    ref.toSetException((Exception)((Object)new BOSException(RptUtil.getReportResource("Valide_SourceType"))));
                    continue;
                }
                Integer rptTmpType = new Integer(tmpType.getValue());
                if (!this.isCheckPermission) continue;
                if (rptTmpType == 6) {
                    if (this.batchHelper == null) continue;
                    try {
                        this.batchHelper.checkCompanyPermision(ref.fiOrgUnit);
                    }
                    catch (Exception e) {
                        ref.toSetException(e);
                    }
                    continue;
                }
                isIncludeOrgTree = true;
                if (!StringUtils.isEmpty((String)ref.fiOrgTree)) {
                    allCheckFIOrgTrees.add(ref.fiOrgTree);
                }
                if (!StringUtils.isEmpty((String)ref.fiOrgUnit)) {
                    allCheckFIOrgUnits.add(ref.fiOrgUnit);
                }
                if (exceptHandlers.containsKey(ref.fiOrgUnit)) {
                    ((Collection)exceptHandlers.get(ref.fiOrgUnit)).add(ref);
                    continue;
                }
                ArrayList<Ref> handlers = new ArrayList<Ref>();
                handlers.add(ref);
                exceptHandlers.put(ref.fiOrgUnit, handlers);
            }
            if (this.pmc != null && isIncludeOrgTree) {
                this.pmc.checkUnitCompPermision(allCheckFIOrgUnits, allCheckFIOrgTrees, exceptHandlers);
            }
            for (i = 0; i < refs.size(); ++i) {
                block17: {
                    ref = (Ref)refs.get(i);
                    try {
                        if (ref.formulaValue._exception != null) continue;
                        if (!this.isSupportOtherDS) break block17;
                        CSLPermissionUtil.checkDataCollectPermissionForFormula((Context)this.ServerCtx, (String)this.ServerCtx.getCaller().toString(), (String)ref.dataCollectNumber, checkPermission);
                    }
                    catch (Throwable a) {
                        ref.formulaValue.setException(a);
                        ref.formulaValue.submit();
                        continue;
                    }
                }
                if (ref.formulaValue._exception != null) continue;
                String key = new StringBuffer().append(ref.year).append(splitStr).append(ref.period).append(splitStr).append(ref.fiOrgTree).append(splitStr).append(ref.fiOrgUnit).append(splitStr).append(ref.currency).append(splitStr).append(ref.sourceCurrency).append(splitStr).append(ref.tempCode).append(splitStr).append(ref.groupTempType).append(splitStr).append(ref.isAdjusted).append(splitStr).append(ref.mergeSchmNum).append(splitStr).append(ref.dataCollectNumber).toString();
                ArrayList<Ref> list = (ArrayList<Ref>)this.map3.get(key);
                if (list == null) {
                    list = new ArrayList<Ref>();
                    this.map3.put(key, list);
                }
                list.add(ref);
            }
            this.execute();
        }
        catch (Exception e) {
            logger.error((Object)"csref error.", (Throwable)e);
            for (int i = 0; i < params.size(); ++i) {
                params.getParameter(i).setValue((Object)new SyntaxErrorException(128L, (Object)e));
            }
        }
    }

    private void execute() {
        if (this.map3.values().size() > 0) {
            for (ArrayList list : this.map3.values()) {
                int i;
                Ref ref = (Ref)list.get(0);
                IObjectCollection c = null;
                try {
                    c = this.getReportCollection(this.ServerCtx, ref.fiOrgTree, ref.fiOrgUnit, ref.year, ref.period, ref.periodType, ref.currency, ref.sourceCurrency, ref.tempCode, ref.groupTempType, ref.isAdjusted, ref.dataCollectNumber, ref.mergeSchmNum);
                }
                catch (Exception e) {
                    logger.error((Object)"getReportCollection error", (Throwable)e);
                    for (i = 0; i < list.size(); ++i) {
                        Ref obj = (Ref)list.get(i);
                        obj.formulaValue.setException(e);
                    }
                }
                if (c != null && c.size() > 0) {
                    for (int i2 = 0; i2 < 1; ++i2) {
                        ReportBaseInfo report = (ReportBaseInfo)c.iterator().next();
                        this.saveDataToFile(report);
                        this.loadData(list, report.getData());
                    }
                    continue;
                }
                boolean tableInnerCheck = new Boolean(this.reportVariables.getStringValue("tableInnerCheck", null));
                if (this.needCheck || !tableInnerCheck) continue;
                for (i = 0; i < list.size(); ++i) {
                    Ref refEX = (Ref)list.get(i);
                    refEX.formulaValue.setException(new EASBizException(new NumericExceptionSubItem("1", "REPORT IS NULL")));
                }
            }
            this.submit(this.map3);
        }
    }

    private IObjectCollection getReportCollection(Context ctx, String treeNumber, String orgUnitNumber, int iYear, int iPeriod, int periodType, String currencyNumber, String sourceCurrencyNumber, String templateNumber, String groupTempType, boolean isAdjusted, String dataCollectNumber, String mergeSchmNum) throws BOSException, EASBizException {
        RptTmpTypeEnum tmpType;
        String key;
        String[] strs = orgUnitNumber.split("\\!");
        String orgTreeNumber = treeNumber;
        if (strs.length == 2) {
            orgTreeNumber = strs[0];
            orgUnitNumber = strs[1];
        } else if (!(this.context.getReportAdapter() instanceof RptReportPropertyAdapter)) {
            OrgTreeInfo tree = (OrgTreeInfo)ctx.get((Object)"KEY_ORGTREE_INFO");
            if (StringUtils.isEmpty((String)orgTreeNumber) && tree != null) {
                orgTreeNumber = tree.getNumber();
            } else if (StringUtils.isEmpty((String)orgTreeNumber)) {
                orgTreeNumber = this.getOrgTree_Number();
            }
        }
        String orgTreeId = null;
        if (!StringUtils.isEmpty((String)orgTreeNumber) && periodType > 0 && StringUtils.isEmpty((String)(orgTreeId = this.orgTreeIdMap.get(key = orgTreeNumber + iYear + iPeriod + periodType)))) {
            Date date = DateUtil.getEndDate((RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)periodType), (int)iYear, (int)iPeriod);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String curDate = sdf.format(date);
            StringBuffer sql = new StringBuffer();
            sql.append("select id where number='").append(orgTreeNumber).append("' and startDate<={ts'").append(curDate).append("'} and (");
            sql.append(" endDate>={ts'").append(curDate).append("'} or endDate is null) and layerType!=6 and (ISHIDE  <> 1  or ISHIDE is null) ");
            OrgTreeCollection coll = OrgTreeFactory.getLocalInstance((Context)ctx).getOrgTreeCollection(sql.toString());
            if (coll != null && coll.size() > 0) {
                orgTreeId = coll.get(0).getId().toString();
            }
            this.orgTreeIdMap.put(key, orgTreeId);
        }
        if ((tmpType = RptTmpTypeEnum.getEnum(groupTempType)) == null) {
            throw new BOSException(RptUtil.getReportResource("Valide_SourceType"));
        }
        Integer rptTmpType = new Integer(tmpType.getValue());
        SQLBuilder sql = new SQLBuilder();
        sql.append("select distinct rpt.fid from t_csl_cslreport rpt  \r\n");
        sql.append("inner join t_rpt_template template on template.fid=rpt.ftemplateid  \r\n");
        sql.append("inner join t_org_baseunit baseUnit on baseunit.fid=rpt.forgunitid  \r\n");
        sql.append("inner join t_bd_currency currency on currency.fid=rpt.fcurrencyid  \r\n");
        sql.append("inner join t_bd_currency srccurrency on srccurrency.fid=rpt.fsourcecurrencyid  \r\n");
        sql.append("left join t_csl_fastmergesolu solu on solu.fid=rpt.ffastMergeSoluId  \r\n");
        sql.append("left join t_csl_SumRptAddedPerporty sumRptAddedPerporty on sumRptAddedPerporty.freport=rpt.fid  \r\n");
        sql.append("inner join t_csl_rptreceived received on received.freportid=rpt.fid  \r\n");
        sql.append("inner join t_org_tree orgTree on orgTree.fid=received.forgTreeId  \r\n");
        sql.append("left join t_csl_cslreport adjustRpt on adjustRpt.fsourcerptid=rpt.fid and adjustRpt.fadjustStatus=1  \r\n");
        sql.append(" where rpt.fyear=?", (Object)iYear);
        sql.append(" and rpt.fperiod=?", (Object)iPeriod);
        sql.append(" and baseUnit.fnumber=?", (Object)orgUnitNumber);
        sql.append(" and currency.fnumber=?", (Object)currencyNumber);
        if (rptTmpType != 4) {
            sql.append(" and srccurrency.fnumber=?", (Object)sourceCurrencyNumber);
        }
        sql.append(" and template.fnumber=?", (Object)templateNumber);
        sql.append(" and rpt.fdataCollectNumber=?", (Object)dataCollectNumber);
        if (!StringUtils.isEmpty((String)mergeSchmNum)) {
            sql.append(" and solu.fnumber=?", (Object)mergeSchmNum);
        } else {
            int rptType = this.getCslRptType(rptTmpType);
            if (rptType > 0) {
                sql.append(" and rpt.fsourceType=?", (Object)rptType);
            } else {
                sql.append(" and rpt.fsourceType<>100");
            }
            sql.append(" and (sumRptAddedPerporty.fisSupportGroup<>2 or sumRptAddedPerporty.fid is null) ");
        }
        String curTmpType = rptTmpType == 6 ? rptTmpType + "," + 2 : String.valueOf(rptTmpType);
        sql.append(" and template.ftemplateType in (").append(curTmpType).append(")  \r\n");
        if (!StringUtils.isEmpty((String)orgTreeId)) {
            sql.append(" and orgTree.fid=?", (Object)orgTreeId);
        } else if (!StringUtils.isEmpty((String)orgTreeNumber)) {
            sql.append(" and orgTree.fnumber=?", (Object)orgTreeNumber);
        }
        if (isAdjusted) {
            sql.append(" and (rpt.fadjustStatus=?", (Object)1).append(" or (adjustRpt.fid is null and rpt.fadjustStatus=0))");
        } else {
            sql.append(" and rpt.fadjustStatus=?", (Object)0);
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
        if (rowSet != null) {
            StringBuffer inStr = new StringBuffer();
            try {
                while (rowSet.next()) {
                    inStr.append("'").append(rowSet.getString(1)).append("',");
                }
                if (inStr.length() > 0) {
                    inStr.deleteCharAt(inStr.length() - 1);
                    ICslReport cslReport = CslReportFactory.getLocalInstance((Context)ctx);
                    return cslReport.getCslReportCollection("select data where id in(" + inStr.toString() + ")");
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return null;
    }

    private int getCslRptType(int tmpType) {
        HashMap<Integer, Integer> type = new HashMap<Integer, Integer>();
        type.put(3, 2);
        type.put(4, 4);
        type.put(5, 3);
        type.put(11, 11);
        type.put(13, 12);
        type.put(8, 8);
        if (type.get(tmpType) != null) {
            return (Integer)type.get(tmpType);
        }
        return -1;
    }

    private IObjectCollection getAdjustReportByOrgTree(Context ctx, IObjectCollection objCL, String orgTreeNumber) throws BOSException, EASBizException {
        CslReportCollection col = new CslReportCollection();
        for (int i = 0; i < objCL.size(); ++i) {
            CslReportInfo info = (CslReportInfo)objCL.getObject(i);
            if (info == null) continue;
            IRptReceived iReceived = RptReceivedFactory.getLocalInstance((Context)ctx);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("orgTree.number", (Object)orgTreeNumber));
            filter.getFilterItems().add(new FilterItemInfo("report", (Object)info.getId().toString()));
            if (!iReceived.exists(filter)) continue;
            col.addObject((IObjectValue)info);
        }
        return col;
    }

    private String makeValidOrgcode(String orgCode) {
        if (orgCode == null || orgCode.length() < 1) {
            int type = this.getReport_SourceType();
            if (type == 2 || type == 3 || type == 4 || type == 11 || type == 12 || type == 14 || type == 15 || type == 8 || type == 67 || type == 68 || type == 69) {
                orgCode = this.getOrgUnit_Number();
                if (StringUtils.isEmpty((String)orgCode)) {
                    orgCode = this.getCompany_Number();
                }
            } else {
                orgCode = this.getCompany_Number();
                if (StringUtils.isEmpty((String)orgCode)) {
                    orgCode = this.getOrgUnit_Number();
                }
            }
        }
        return orgCode;
    }

    private int getReport_SourceType() {
        Integer i = (Integer)this.context.getReportAdapter().getReportProperty("Report.SourceType");
        return i != null ? i : -1;
    }

    private String getOrgTree_Number() {
        OrgTreeInfo tree;
        String treeNum = (String)this.context.getReportAdapter().getReportProperty("CSLReport_OrgTree_Number");
        if (StringUtils.isEmpty((String)treeNum) && (tree = (OrgTreeInfo)this.ServerCtx.get((Object)"KEY_ORGTREE_INFO")) != null) {
            treeNum = tree.getNumber();
        }
        return treeNum;
    }

    private String getOrgUnit_Number() {
        return (String)this.context.getReportAdapter().getReportProperty("OrgUnit.Number");
    }

    private String getCompany_Number() {
        return (String)this.context.getReportAdapter().getReportProperty("Company.Number");
    }

    private HashMap createMap(ArrayList list) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < list.size(); ++i) {
            map.put(((Ref)list.get(i)).getCellRefAddr(), null);
        }
        return map;
    }

    private void submit(HashMap map) {
        for (ArrayList list : map.values()) {
            for (int i = 0; i < list.size(); ++i) {
                ((Ref)list.get((int)i)).formulaValue.submit();
            }
        }
    }

    private void saveDataToFile(ReportBaseInfo reportInfo) {
        String easInstanceHome = System.getProperty("EAS_INSTANCE_HOME");
        if (!StringUtils.isEmpty((String)easInstanceHome) && DebugLogger.isDebug) {
            try {
                IOHelper.saveDataToFile(reportInfo.getData(), easInstanceHome + "/CsRefBatchCalculate.data");
            }
            catch (Exception e) {
                logger.error((Object)e.getStackTrace());
            }
        }
    }

    private void loadData(ArrayList list, byte[] data) {
        if (list == null) {
            return;
        }
        HashMap map = this.createMap(list);
        try {
            BookIOUtil.loadSomeCellValues((byte[])data, (HashMap)map);
        }
        catch (Exception e) {
            for (int i = 0; i < list.size(); ++i) {
                Ref ref = (Ref)list.get(i);
                ref.formulaValue.setException(e);
            }
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Ref ref = (Ref)list.get(i);
            Object object = map.get(ref.getCellRefAddr());
            if (!(object instanceof Variant)) {
                object = new Variant(object);
            }
            ref.formulaValue.setValue(object);
        }
    }

    private String getDataCollectNumber() {
        String dataCollectNumber;
        String string = dataCollectNumber = this.context == null ? "" : (String)this.context.getReportAdapter().getReportProperty("CSLReport_DataCollect_Number");
        if (StringUtils.isEmpty((String)dataCollectNumber)) {
            dataCollectNumber = (String)this.ServerCtx.get((Object)"KEY_DATACOLLECT_NUMBER");
        }
        if (StringUtils.isEmpty((String)dataCollectNumber)) {
            dataCollectNumber = "ACTUALDATA";
        }
        return dataCollectNumber;
    }

    public boolean initPermission(ICalculateContextProvider context) {
        VariableEntry v;
        boolean contextPermission = true;
        ReportVariables rvs = context.getReportVariables();
        if (rvs != null && (v = rvs.get("Check_Permissioin", null)) != null) {
            try {
                contextPermission = Boolean.valueOf(v.getValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return contextPermission;
    }

    public void checkPermision(String org) throws ReportException, BOSException {
        StringTokenizer stoken = new StringTokenizer(org, ";");
        while (stoken.hasMoreElements()) {
            String trim = stoken.nextElement().toString().trim();
            if (!this.initPermission(this.context) || this.getUserPermissionOrgs().containsKey(trim.toUpperCase())) continue;
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"NoCompanyPermission", (Locale)this.ServerCtx.getOriginLocale())});
        }
    }

    private IPermission getPermission() throws BOSException {
        if (this.permission == null) {
            this.permission = this.ServerCtx == null ? PermissionFactory.getRemoteInstance() : PermissionFactory.getLocalInstance((Context)this.ServerCtx);
        }
        return this.permission;
    }

    private Map getUserPermissionOrgs() throws BOSException {
        if (this.permissionOrgs != null) {
            return this.permissionOrgs;
        }
        Map fullOrgs = new HashMap();
        try {
            IPermission dao = this.getPermission();
            fullOrgs = OrgType.Company.equals((Object)this.batchHelper.getRptOrgType()) ? dao.getAuthorizedOrgs((IObjectPK)new ObjectUuidPK(this.ServerCtx.getCaller().toString()), OrgType.Company, null, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.rpt.client", "RptReportProcessUI"), (IMetaDataPK)new MetaDataPK("rpt_report_calculate")) : dao.getAuthorizedOrgs((IObjectPK)new ObjectUuidPK(this.ServerCtx.getCaller().toString()), OrgType.ProfitCenter, null, (IMetaDataPK)MetaDataPK.create((String)" com.kingdee.eas.fi.newrpt.client.rptnewui", (String)"ProfReportProcessUI"), (IMetaDataPK)MetaDataPK.create((String)"prof_rpt_update"));
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.setFilter(new FilterInfo());
        Iterator iterator = ((HashMap)fullOrgs).keySet().iterator();
        StringBuffer mask = new StringBuffer();
        int index = 0;
        while (iterator.hasNext()) {
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)iterator.next().toString(), CompareType.EQUALS));
            if (index == 0) {
                mask.append("#" + index++);
                continue;
            }
            mask.append(" or #" + index++);
        }
        evi.getFilter().setMaskString(mask.toString());
        IFullOrgUnit company = FullOrgUnitFactory.getLocalInstance((Context)this.ServerCtx);
        FullOrgUnitCollection coms = company.getFullOrgUnitCollection(evi);
        this.permissionOrgs = new HashMap();
        this.permissionOrgs.put("", null);
        int n = coms.size();
        for (int i = 0; i < n; ++i) {
            this.permissionOrgs.put(coms.get(i).getNumber().toUpperCase(), new FunctionPermission(coms.get(i).getId()));
        }
        return this.permissionOrgs;
    }

    private class FunctionPermission {
        IObjectPK companyId = null;
        Map permissionItems = new HashMap(2);

        FunctionPermission(BOSUuid id) {
            this.companyId = new ObjectUuidPK(id);
        }
    }

    class CalculateBackFiller {
        private Throwable _exception = null;
        private ArrayList vlist = new ArrayList();
        Parameter param;

        public CalculateBackFiller(Parameter _param) {
            this.param = _param;
        }

        public void setValue(Object value) {
            if (value == null) {
                return;
            }
            this.vlist.add(value);
        }

        public void setException(Throwable exception) {
            this._exception = exception;
            this.setException(this.param, exception);
        }

        public void setException(Parameter p, Throwable e) {
            IErrorProvider errorProvider = ReportCalculateErrorProvider.getErrorProvider(e.getClass());
            if (errorProvider != null && e instanceof Exception) {
                Object value = errorProvider.getProperValue((Exception)e).getValue();
                try {
                    value = new BigDecimal(value.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                p.setValue(value);
            } else {
                p.setValue((Object)("#BAD FUNCTION " + e.getMessage()));
            }
        }

        void submit() {
            if (this._exception != null) {
                IErrorProvider errorProvider = ReportCalculateErrorProvider.getErrorProvider(this._exception.getClass());
                if (errorProvider != null && this._exception instanceof Exception) {
                    Object value = errorProvider.getProperValue((Exception)this._exception).getValue();
                    try {
                        value = new BigDecimal(value.toString());
                        this.param.setValue(value);
                    }
                    catch (Exception e) {
                        FormulaValueBackfill backFill = new FormulaValueBackfill(this.param);
                        backFill.setException(this._exception);
                    }
                } else {
                    FormulaValueBackfill backFill = new FormulaValueBackfill(this.param);
                    backFill.setException(this._exception);
                }
            } else if (this.vlist.size() == 0) {
                this.param.setValue((Object)Variant.nullVariant);
            } else if (this.vlist.size() == 1) {
                this.param.setValue(this.vlist.get(0));
            } else {
                ArrayList<BigDecimal> bList = new ArrayList<BigDecimal>();
                boolean isAllNumber = true;
                for (int i = 0; i < this.vlist.size(); ++i) {
                    try {
                        bList.add(new BigDecimal(this.vlist.get(i).toString()));
                        continue;
                    }
                    catch (Exception e) {
                        isAllNumber = false;
                        break;
                    }
                }
                if (isAllNumber) {
                    BigDecimal r = new BigDecimal("0");
                    for (int i = 0; i < bList.size(); ++i) {
                        r = r.add((BigDecimal)bList.get(i));
                    }
                    this.param.setValue((Object)r);
                } else {
                    StringBuffer buf = new StringBuffer();
                    for (int j = 0; j < this.vlist.size(); ++j) {
                        Object temp = this.vlist.get(j);
                        if (temp == null) continue;
                        if (temp instanceof Calendar) {
                            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                            buf.append(format.format(((Calendar)temp).getTime()));
                            continue;
                        }
                        buf.append(temp.toString());
                    }
                    this.param.setValue((Object)buf.toString());
                }
            }
        }
    }

    private class Ref
    implements ExceptionSeter {
        String fiOrgTree;
        String fiOrgUnit;
        Exception exp = null;
        int year;
        int period;
        String currency;
        String sourceCurrency;
        String tempType;
        String tempCode;
        String groupTempType;
        String sheetName;
        String cellName;
        int periodType = -1;
        boolean isAdjusted = true;
        CalculateBackFiller formulaValue;
        String dataCollectNumber = "";
        String mergeSchmNum = "";

        String getCellRefAddr() {
            return (this.sheetName + "!" + this.cellName).toUpperCase();
        }

        public Ref(Parameter param) {
            this.formulaValue = new CalculateBackFiller(param);
            Object[] params = param.getArgs();
            if (params[0] instanceof Object[]) {
                params = (Object[])params[0];
            }
            int index = 0;
            if (params.length >= 11) {
                this.fiOrgTree = ((Variant)params[index]).getValue() == null ? null : ((Variant)params[index]).getValue().toString();
                ++index;
            }
            this.fiOrgUnit = ((Variant)params[index]).getValue() == null ? null : ((Variant)params[index]).getValue().toString();
            this.fiOrgUnit = CsRefBatchCalculater.this.makeValidOrgcode(this.fiOrgUnit);
            this.groupTempType = ((Variant)params[++index]).getValue() == null ? null : ((Variant)params[index]).getValue().toString();
            RptTmpTypeEnum tmpType = RptTmpTypeEnum.getEnum(this.groupTempType);
            boolean hasHandleParamUpdate = false;
            if (tmpType == null) {
                tmpType = this.tryToCatchNextParamConvt2RptTmpTypeEnum(params, index);
                if (tmpType == null) {
                    this.formulaValue.setException(new BOSException(RptUtil.getReportResource("Valide_SourceType")));
                    return;
                }
                hasHandleParamUpdate = true;
                this.tempCode = ((Variant)params[index]).getValue() == null ? null : ((Variant)params[index]).getValue().toString();
                ++index;
            }
            Integer rptTmpType = new Integer(tmpType.getValue());
            this.tempType = String.valueOf(tmpType.getValue());
            if (!hasHandleParamUpdate) {
                String string = this.tempCode = ((Variant)params[++index]).getValue() == null ? null : ((Variant)params[index]).getValue().toString();
            }
            if (StringUtils.isEmpty((String)this.tempCode)) {
                this.formulaValue.setException(new ReportException(ReportException.COMMON_EXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"57_CsRefBatchCalculater", (Locale)CsRefBatchCalculater.this.ServerCtx.getOriginLocale())}));
                return;
            }
            ++index;
            this.handDefaultOrgTree(rptTmpType);
            try {
                this.year = Integer.parseInt(((Variant)params[index]).getValue().toString());
                ++index;
            }
            catch (Exception ex) {
                this.formulaValue.setException(new ReportException(ReportException.COMMON_EXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"58_CsRefBatchCalculater", (Locale)CsRefBatchCalculater.this.ServerCtx.getOriginLocale())}));
                return;
            }
            try {
                this.period = Integer.parseInt(((Variant)params[index]).getValue().toString());
                ++index;
            }
            catch (Exception ex) {
                this.formulaValue.setException(new ReportException(ReportException.COMMON_EXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"59_CsRefBatchCalculater", (Locale)CsRefBatchCalculater.this.ServerCtx.getOriginLocale())}));
                return;
            }
            int curYear = 0;
            int curPeriod = 0;
            int int_periodType = 0;
            if (CsRefBatchCalculater.this.context.getReportAdapter() instanceof BgRptReportPropertyAdapter) {
                String bfperiodNumber = (String)CsRefBatchCalculater.this.context.getReportAdapter().getReportProperty("BG_PERIOD_NUMBER");
                int[] yp = RptUtil.transYearAndPeriodFronBgNumber(bfperiodNumber);
                curYear = yp[0];
                curPeriod = yp[1];
                int_periodType = 3;
            } else {
                curYear = (Integer)CsRefBatchCalculater.this.context.getReportAdapter().getReportProperty("Report.Year");
                curPeriod = (Integer)CsRefBatchCalculater.this.context.getReportAdapter().getReportProperty("Report.Period");
                int_periodType = this.getReport_PeriodType(this.tempCode, rptTmpType);
            }
            this.periodType = int_periodType;
            if (this.year == 0) {
                this.year = curYear;
            }
            if (curPeriod == 0) {
                this.period = curPeriod;
            }
            int[] arrYearAndPeriod = null;
            arrYearAndPeriod = CsRefBatchCalculater.this.isSupport13Period ? RPTDate13Util.getRptYearAndPeriod((int)curYear, (int)curPeriod, (int)int_periodType, (int)this.year, (int)this.period, (boolean)CsRefBatchCalculater.this.isSupport13Period) : FiscalPeriodHelper.getRptFormualYearAndPeriod((PeriodCollection)CsRefBatchCalculater.this.periods, (int)curYear, (int)curPeriod, (int)int_periodType, (int)this.year, (int)this.period, (boolean)CsRefBatchCalculater.this.isMergeByFiscalPeriod);
            if (arrYearAndPeriod == null) {
                this.year = curYear;
                this.period = curPeriod;
            } else {
                this.year = arrYearAndPeriod[0];
                this.period = arrYearAndPeriod[1];
            }
            this.sheetName = ((Variant)params[index]).getValue() == null ? null : ((Variant)params[index]).getValue().toString();
            this.cellName = ((Variant)params[++index]).getValue() == null ? null : ((Variant)params[index]).getValue().toString();
            this.currency = ((Variant)params[++index]).getValue() == null ? null : ((Variant)params[index]).getValue().toString();
            ++index;
            if (params.length >= 10) {
                this.sourceCurrency = ((Variant)params[index]).getValue() == null ? null : ((Variant)params[index]).getValue().toString();
                ++index;
                try {
                    this.isAdjusted = ((Variant)params[index]).toBoolean();
                    ++index;
                }
                catch (SyntaxErrorException syntaxErrorException) {
                    // empty catch block
                }
            }
            if (this.currency == null || this.currency.trim().length() == 0) {
                this.currency = (String)CsRefBatchCalculater.this.context.getReportAdapter().getReportProperty("Currency.Number");
            }
            if (this.sourceCurrency == null || this.sourceCurrency.trim().length() == 0) {
                this.sourceCurrency = (String)CsRefBatchCalculater.this.context.getReportAdapter().getReportProperty("SourceCurrency.Number");
                if (this.sourceCurrency == null) {
                    this.sourceCurrency = (String)CsRefBatchCalculater.this.context.getReportAdapter().getReportProperty("Currency.Number");
                }
            }
            if (params.length == 11) {
                String string = this.dataCollectNumber = ((Variant)params[10]).getValue() == null ? "" : ((Variant)params[10]).getValue().toString();
                if (!this.dataCollectNumber.equals("ACTUALDATA") && !this.dataCollectNumber.equals("ACTUALDATA")) {
                    this.dataCollectNumber = "";
                }
            } else if (params.length == 12) {
                String string = this.dataCollectNumber = ((Variant)params[11]).getValue() == null ? "" : ((Variant)params[11]).getValue().toString();
            }
            if (StringUtils.isEmpty((String)this.dataCollectNumber)) {
                this.dataCollectNumber = CsRefBatchCalculater.this.getDataCollectNumber();
            }
            if (params.length >= 13) {
                this.mergeSchmNum = ((Variant)params[12]).getValue() == null ? "" : ((Variant)params[12]).getValue().toString();
            }
        }

        private void handDefaultOrgTree(Integer rptTmpType) {
            if (rptTmpType != 6) {
                if (StringUtils.isEmpty((String)this.fiOrgTree)) {
                    this.fiOrgTree = CsRefBatchCalculater.this.getOrgTree_Number();
                    if (StringUtils.isEmpty((String)this.fiOrgTree)) {
                        this.formulaValue.setException(new ReportException(ReportException.COMMON_EXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"48_AdjustDataCalculator", (Locale)CsRefBatchCalculater.this.ServerCtx.getOriginLocale())}));
                        return;
                    }
                }
            } else if (!StringUtils.isEmpty((String)this.fiOrgTree) || CsRefBatchCalculater.this.batchHelper.getTemplateId() != null) {
                // empty if block
            }
        }

        private RptTmpTypeEnum tryToCatchNextParamConvt2RptTmpTypeEnum(Object[] params, int index) {
            this.groupTempType = ((Variant)params[++index]).getValue() == null ? null : ((Variant)params[index]).getValue().toString();
            return RptTmpTypeEnum.getEnum(this.groupTempType);
        }

        private int getReport_PeriodType(String tempCode, Integer rptTmpType) {
            Integer period = null;
            if (CsRefBatchCalculater.this.periodTempMap.containsKey(tempCode)) {
                period = (Integer)CsRefBatchCalculater.this.periodTempMap.get(tempCode);
                return period;
            }
            try {
                IRowSet rs = DbUtil.executeQuery((Context)CsRefBatchCalculater.this.ServerCtx, (String)("select FPERIODTYPE  from t_rpt_template where FNUMBER in('" + tempCode + "') and FTemplateType=" + rptTmpType));
                if (rs != null && rs.next()) {
                    period = rs.getInt(1);
                }
            }
            catch (Exception e) {
                logger.error((Object)"getTemplate_Exception", (Throwable)e);
            }
            if (period == null) {
                return -1;
            }
            CsRefBatchCalculater.this.periodTempMap.put(tempCode, period);
            return period;
        }

        @Override
        public void toSetException(Exception e) {
            this.formulaValue.setException(e);
            this.formulaValue.submit();
        }
    }
}

