/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.batch.AbstractCalculator;
import com.kingdee.eas.fi.rpt.batch.FormulaValueBackfill;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class GetOrgMessageBatchCalculater
extends AbstractCalculator {
    private static Logger logger = Logger.getLogger(GetOrgMessageBatchCalculater.class);
    private Map formulas = null;
    private static final String SPLIT = "@&@";
    private EntityViewInfo viewInfo = null;
    private Set adminMsg = new HashSet();

    public GetOrgMessageBatchCalculater(ICalculateContextProvider calContext, Context _serverCtx) {
        super(calContext, _serverCtx);
    }

    @Override
    protected void init(SortedParameterArray params) throws BOSException, EASBizException {
        this.formulas = new HashMap(params.size());
        this.viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection itemCollection = filter.getFilterItems();
        HashSet<String> adminNum = new HashSet<String>();
        OrgMessage orgMessage = null;
        String key = null;
        for (int i = 0; i < params.size(); ++i) {
            orgMessage = new OrgMessage(params.getParameter(i));
            if (orgMessage.exp != null) continue;
            adminNum.add(orgMessage.orgNumber);
            this.adminMsg.add(orgMessage.orgMessageType);
            key = orgMessage.orgNumber + SPLIT + orgMessage.orgMessageType;
            ArrayList<OrgMessage> group = (ArrayList<OrgMessage>)this.formulas.get(key);
            if (group == null) {
                group = new ArrayList<OrgMessage>();
                this.formulas.put(key, group);
            }
            group.add(orgMessage);
        }
        itemCollection.add(new FilterItemInfo("number", adminNum, CompareType.INCLUDE));
        SelectorItemCollection coll = this.getSelectors();
        this.viewInfo.setSelector(coll);
        this.viewInfo.setFilter(filter);
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isAdminOrgUnit"));
        if (this.adminMsg.contains("name")) {
            sic.add(new SelectorItemInfo("name"));
        }
        if (this.adminMsg.contains("simpleName")) {
            sic.add(new SelectorItemInfo("simpleName"));
        }
        if (this.adminMsg.contains("code")) {
            sic.add(new SelectorItemInfo("code"));
        }
        if (this.adminMsg.contains("description")) {
            sic.add(new SelectorItemInfo("description"));
        }
        if (this.adminMsg.contains("economicType")) {
            sic.add(new SelectorItemInfo("partAdmin.economicType"));
        }
        if (this.adminMsg.contains("industry")) {
            sic.add(new SelectorItemInfo("partAdmin.industry.name"));
        }
        if (this.adminMsg.contains("orgUnitLayerType")) {
            sic.add(new SelectorItemInfo("partAdmin.unitLayerType.name"));
        }
        if (this.adminMsg.contains("juridicalPerson")) {
            sic.add(new SelectorItemInfo("partAdmin.juridicalPerson.name"));
        }
        if (this.adminMsg.contains("registeredCapital")) {
            sic.add(new SelectorItemInfo("partAdmin.registeredCapital"));
        }
        if (this.adminMsg.contains("address")) {
            sic.add(new SelectorItemInfo("partAdmin.address.name"));
        }
        if (this.adminMsg.contains("territory")) {
            sic.add(new SelectorItemInfo("partAdmin.area.name"));
        }
        if (this.adminMsg.contains("taxNumber")) {
            sic.add(new SelectorItemInfo("partAdmin.taxNumber"));
        }
        if (this.adminMsg.contains("registeredCode")) {
            sic.add(new SelectorItemInfo("partAdmin.registeredCode"));
        }
        if (this.adminMsg.contains("area")) {
            sic.add(new SelectorItemInfo("partAdmin.area.name"));
        }
        return sic;
    }

    @Override
    protected void calculate() throws BOSException, EASBizException {
        FullOrgUnitCollection orgUnit = FullOrgUnitFactory.getLocalInstance((Context)this.serverContext).getFullOrgUnitCollection(this.viewInfo);
        FullOrgUnitInfo info = null;
        HashMap<String, Object> orgMessage = new HashMap<String, Object>();
        String numTmp = null;
        for (int i = 0; i < orgUnit.size(); ++i) {
            info = orgUnit.get(i);
            numTmp = info.getNumber();
            if (!info.isIsAdminOrgUnit()) continue;
            orgMessage.put(numTmp + SPLIT + "isAdminOrgUnit", new Boolean(info.isIsAdminOrgUnit()));
            if (this.adminMsg.contains("name")) {
                orgMessage.put(numTmp + SPLIT + "name", info.getName());
            }
            if (this.adminMsg.contains("simpleName")) {
                orgMessage.put(numTmp + SPLIT + "simpleName", info.getSimpleName());
            }
            if (this.adminMsg.contains("code")) {
                orgMessage.put(numTmp + SPLIT + "code", info.getCode());
            }
            if (this.adminMsg.contains("description")) {
                orgMessage.put(numTmp + SPLIT + "description", info.getDescription());
            }
            if (this.adminMsg.contains("economicType") && info.getPartAdmin().getEconomicType() != null) {
                orgMessage.put(numTmp + SPLIT + "economicType", info.getPartAdmin().getEconomicType().getAlias());
            }
            if (this.adminMsg.contains("industry") && info.getPartAdmin().getIndustry() != null) {
                orgMessage.put(numTmp + SPLIT + "industry", info.getPartAdmin().getIndustry().getName());
            }
            if (this.adminMsg.contains("orgUnitLayerType") && info.getPartAdmin().getUnitLayerType() != null) {
                orgMessage.put(numTmp + SPLIT + "orgUnitLayerType", info.getPartAdmin().getUnitLayerType().getName());
            }
            if (this.adminMsg.contains("juridicalPerson") && info.getPartAdmin().getJuridicalPerson() != null) {
                orgMessage.put(numTmp + SPLIT + "juridicalPerson", info.getPartAdmin().getJuridicalPerson().getName());
            }
            if (this.adminMsg.contains("registeredCapital")) {
                orgMessage.put(numTmp + SPLIT + "registeredCapital", info.getPartAdmin().getRegisteredCapital());
            }
            if (this.adminMsg.contains("address") && info.getPartAdmin().getAddress() != null) {
                orgMessage.put(numTmp + SPLIT + "address", info.getPartAdmin().getAddress().getName());
            }
            if (this.adminMsg.contains("territory") && info.getPartAdmin().getArea() != null) {
                orgMessage.put(numTmp + SPLIT + "territory", info.getPartAdmin().getArea().getName());
            }
            if (this.adminMsg.contains("taxNumber")) {
                orgMessage.put(numTmp + SPLIT + "taxNumber", info.getPartAdmin().getTaxNumber());
            }
            if (this.adminMsg.contains("registeredCode")) {
                orgMessage.put(numTmp + SPLIT + "registeredCode", info.getPartAdmin().getRegisteredCode());
            }
            if (!this.adminMsg.contains("area") || info.getPartAdmin().getArea() == null) continue;
            orgMessage.put(numTmp + SPLIT + "area", info.getPartAdmin().getArea().getName());
        }
        for (String key : this.formulas.keySet()) {
            List group = (List)this.formulas.get(key);
            for (int i = 0; i < group.size(); ++i) {
                OrgMessage ref = (OrgMessage)group.get(i);
                Object object = orgMessage.get(ref.orgNumber + SPLIT + ref.orgMessageType);
                ref.formulaValue.setValue(object != null ? object : Variant.nullVariant);
            }
        }
    }

    private String makeValidOrgcode(String orgCode) {
        if (this.calCulateContext != null && (orgCode == null || orgCode.length() < 1)) {
            String ci = null;
            if (this.calCulateContext != null) {
                ci = (String)this.calCulateContext.getReportAdapter().getReportProperty("Company.Number");
            }
            return ci;
        }
        return orgCode;
    }

    @Override
    protected void clear() {
        this.formulas.clear();
        this.adminMsg.clear();
    }

    private class OrgMessage {
        String orgNumber;
        String orgMessageType;
        FormulaValueBackfill formulaValue;
        Exception exp = null;

        public OrgMessage(Parameter param) {
            Object[] params = param.getArgs();
            params = param.getArgs()[0] instanceof Object[] ? (Object[])param.getArgs()[0] : param.getArgs();
            this.initOrgMessage((String)((Variant)params[0]).getValue(), (String)((Variant)params[1]).getValue());
            this.formulaValue = new FormulaValueBackfill(param);
            if (this.exp != null) {
                this.formulaValue.setException((Throwable)this.exp);
            } else {
                this.formulaValue.setValue((Object)Variant.nullVariant);
            }
        }

        private void initOrgMessage(String orgNumber, String orgMessageType) {
            this.orgNumber = GetOrgMessageBatchCalculater.this.makeValidOrgcode(orgNumber);
            this.orgMessageType = orgMessageType;
            if (StringUtils.isEmpty((String)this.orgMessageType)) {
                this.exp = new ReportException(ReportException.PARAM_IS_NOT_INTEGRATED);
                return;
            }
        }
    }
}

