/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CashFlowDirection;
import com.kingdee.eas.basedata.assistant.CashFlowItemFactory;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.CashTypeEnum;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.RptAndTempException;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.app.GroupTreeNode;
import com.kingdee.eas.fi.rpt.app.RptCalculaterDAO;
import com.kingdee.eas.fi.rpt.batch.ChecFmlParamPermissionUtil;
import com.kingdee.eas.fi.rpt.batch.FormulaValueBackfill;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ICashFlowCalculater {
    private static final Logger log = Logger.getLogger((String)ICashFlowCalculater.class.getName());
    private ICalculateContextProvider context;
    Context ServerCtx = null;
    ChecFmlParamPermissionUtil pmc;
    ArrayList list = new ArrayList();
    HashMap sortMap = new HashMap();
    Parameter _pma;
    private HashMap companyCache = new HashMap();
    String templateTbl = null;

    public ICashFlowCalculater(ICalculateContextProvider calContext, Context _serverCtx) {
        this.context = calContext;
        this.ServerCtx = _serverCtx;
        this.pmc = ChecFmlParamPermissionUtil.getInstance(calContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(SortedParameterArray params) {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("number"));
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("isleaf", (Object)new Integer(1)));
        ICompanyOrgUnit icompany = null;
        CompanyOrgUnitCollection companyCl = null;
        for (int i = 0; i < params.size(); ++i) {
            boolean isOpCompanyEmpty;
            IncashFlow item;
            block23: {
                item = new IncashFlow(params.getParameter(i));
                isOpCompanyEmpty = false;
                if (!item.init()) continue;
                if (item._opCompany == null || item._opCompany.length() == 0) {
                    try {
                        icompany = CompanyOrgUnitFactory.getLocalInstance((Context)this.ServerCtx);
                        companyCl = icompany.getCompanyOrgUnitCollection(view);
                        if (companyCl == null || companyCl.size() <= 0) break block23;
                        isOpCompanyEmpty = true;
                        Iterator it = companyCl.iterator();
                        while (it.hasNext()) {
                            item = new IncashFlow(params.getParameter(i));
                            item.init();
                            item._opCompany = ((CompanyOrgUnitInfo)it.next()).getNumber();
                            this.list.add(item);
                        }
                    }
                    catch (Exception e) {
                        continue;
                    }
                }
            }
            if (isOpCompanyEmpty) continue;
            this.list.add(item);
        }
        if (this.list.size() == 0) {
            return;
        }
        this.checkOpCompany();
        if (this.list.size() == 0) {
            return;
        }
        this.queryCompany();
        if (this.list.size() == 0) {
            return;
        }
        this.getGroupLongNumber();
        if (this.list.size() == 0) {
            return;
        }
        this.queryInfo();
        if (this.list.size() == 0) {
            return;
        }
        this.sort();
        if (this.list.size() == 0) {
            return;
        }
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)this.ServerCtx);
            this.queryValue(conn);
        }
        catch (Throwable e) {
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    log.debug((Object)e.getMessage());
                }
            }
        }
    }

    void insertMap(StringBuffer key, IncashFlow item) {
        ArrayList<IncashFlow> tempList;
        key.append("|" + item._intYear + "|");
        key.append(item._intYear2 + "|");
        key.append(item._startPeriod + "|");
        key.append(item._endPeriod + "|");
        key.append((Object)((Object)item._cashTypeEnum) + "|");
        if (!item._cashTypeEnum.equals((Object)CashTypeEnum.AS) && !item._cashTypeEnum.equals((Object)CashTypeEnum.AZ)) {
            key.append(item._currency + "|");
        }
        if ((tempList = (ArrayList<IncashFlow>)this.sortMap.get(key.toString())) == null) {
            tempList = new ArrayList<IncashFlow>();
            this.sortMap.put(key.toString(), tempList);
        }
        tempList.add(item);
    }

    void sort() {
        for (IncashFlow item : this.list) {
            if (item.isProfit) {
                ArrayList<IncashFlow> tempList = (ArrayList<IncashFlow>)this.sortMap.get("isProfit");
                if (tempList == null) {
                    tempList = new ArrayList<IncashFlow>();
                    this.sortMap.put("isProfit", tempList);
                }
                tempList.add(item);
                continue;
            }
            StringBuffer key = new StringBuffer();
            if (item._isincludingUnPosted) {
                key.append("i");
            } else {
                key.append("k");
            }
            if (item._opCompany != null && item._opCompany.trim().length() > 0) {
                key.append("f");
                if (item._sup) {
                    key.append("s");
                }
                if (item._cus) {
                    key.append("c");
                }
                if (item._sup) {
                    key.append("i");
                }
            } else {
                key.append("d");
            }
            if (item.masterItem == 0) {
                key.append("p");
                if (item.isLeaf || !item.isLeaf && item.direction != CashFlowDirection.IN_OR_OUT) {
                    key.append("a");
                    if (item._cashTypeEnum.getValue() == 2) {
                        key.append("y");
                        this.insertMap(key, item);
                        continue;
                    }
                    if (item._cashTypeEnum.getValue() == 1 || item._cashTypeEnum.getValue() == 4) {
                        key.append("z");
                        this.insertMap(key, item);
                        continue;
                    }
                    if (item._cashTypeEnum.getValue() == 3 || item._cashTypeEnum.getValue() == 5) {
                        key.append("s");
                        this.insertMap(key, item);
                        continue;
                    }
                    this.setException((Exception)((Object)new ReportException(ReportException.EXECP_ACCTEXT_VOUTYPE_INVALID)), item._param);
                    continue;
                }
                key.append("b");
                if (item._cashTypeEnum.getValue() == 2) {
                    key.append("y");
                    this.insertMap(key, item);
                    continue;
                }
                if (item._cashTypeEnum.getValue() == 1 || item._cashTypeEnum.getValue() == 4) {
                    key.append("z");
                    this.insertMap(key, item);
                    continue;
                }
                if (item._cashTypeEnum.getValue() == 3 || item._cashTypeEnum.getValue() == 5) {
                    key.append("s");
                    this.insertMap(key, item);
                    continue;
                }
                this.setException((Exception)((Object)new ReportException(ReportException.EXECP_ACCTEXT_VOUTYPE_INVALID)), item._param);
                continue;
            }
            key.append("u");
            if (item._cashTypeEnum.getValue() == 2) {
                key.append("y");
                this.insertMap(key, item);
                continue;
            }
            if (item._cashTypeEnum.getValue() == 1 || item._cashTypeEnum.getValue() == 4) {
                key.append("z");
                this.insertMap(key, item);
                continue;
            }
            if (item._cashTypeEnum.getValue() == 3 || item._cashTypeEnum.getValue() == 5) {
                key.append("s");
                this.insertMap(key, item);
                continue;
            }
            this.setException((Exception)((Object)new ReportException(ReportException.EXECP_ACCTEXT_VOUTYPE_INVALID)), item._param);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queryValue(Connection conn) throws Exception {
        ArrayList tempList = (ArrayList)this.sortMap.get("isProfit");
        this.sortMap.put("isProfit", null);
        if (tempList != null) {
            for (IncashFlow item : tempList) {
                try {
                    item._param.setValue((Object)this.getRetainedProfits(this.ServerCtx, item.company, item._cashTypeEnum, item._currency, item._intYear, item._startPeriod, item._endPeriod, item._isincludingUnPosted));
                }
                catch (Exception e) {
                    this.setException(e, item._param);
                }
            }
        }
        Iterator<Object> it = this.sortMap.values().iterator();
        ArrayList temp = null;
        this.createTempTable();
        while (it.hasNext()) {
            tempList = (ArrayList)it.next();
            if (tempList == null || tempList.size() == 0) continue;
            ArrayList queryList = new ArrayList();
            HashMap rtMap = new HashMap();
            String[] fields = this.builderReturnVar((IncashFlow)tempList.get(0), rtMap, tempList, queryList);
            if (temp == null) {
                temp = new ArrayList();
            } else {
                temp.clear();
            }
            String select = "select " + this.builderSel((IncashFlow)tempList.get(0));
            String from = " \r\n   " + this.builderFrom((IncashFlow)tempList.get(0));
            String where = " \r\n  " + this.builderWhere((IncashFlow)tempList.get(0), temp);
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                this.insertCondition(queryList, conn);
                String sql = select + " " + from + " inner join " + this.templateTbl + " dyn on 1=1 " + where;
                this.close(ps);
                ps = conn.prepareStatement(sql);
                Object value = null;
                if (temp != null && temp.size() > 0) {
                    for (int i = 1; i <= temp.size(); ++i) {
                        ps.setObject(i, temp.get(i - 1));
                    }
                }
                rs = ps.executeQuery();
                this.exportResult(rtMap, rs, fields);
                this.close(rs);
                this.deleteTempTableData(this.templateTbl);
                this.close(ps);
                this.close(rs);
                ps = null;
                rs = null;
            }
            catch (Exception e) {
                for (IncashFlow item : tempList) {
                    this.setException(e, item._param);
                }
                continue;
            }
            finally {
                this.close(ps);
                this.close(rs);
                ps = null;
                rs = null;
                TempTablePool.getInstance((Context)this.ServerCtx).releaseTable(this.templateTbl);
                continue;
            }
            TempTablePool.getInstance((Context)this.ServerCtx).releaseTable(this.templateTbl);
        }
    }

    void exportResult(HashMap rtMap, ResultSet rs, String[] fields) throws SQLException {
        IncashFlow item2 = null;
        while (rs.next()) {
            StringBuffer key = new StringBuffer();
            for (int i = 0; i < fields.length; ++i) {
                if (i > 0) {
                    key.append("|");
                }
                key.append(rs.getObject(fields[i]).toString());
            }
            ArrayList tls = (ArrayList)rtMap.get(key.toString());
            if (tls == null) continue;
            for (IncashFlow item2 : tls) {
                if (!(item2._param.getValue() instanceof BigDecimal)) continue;
                if (CslConstant.BGZERO.compareTo((BigDecimal)item2._param.getValue()) != 0) {
                    item2._param.setValue((Object)((BigDecimal)item2._param.getValue()).add(rs.getBigDecimal("cashValue")));
                    continue;
                }
                item2._param.setValue((Object)rs.getBigDecimal("cashValue"));
            }
        }
    }

    void close(Object obj) {
        try {
            Method method = obj.getClass().getMethod("close", new Class[0]);
            method.invoke(obj, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    String[] builderReturnVar(IncashFlow item, HashMap map, ArrayList tempList, ArrayList queryList) {
        boolean currency = false;
        boolean op = false;
        ArrayList<String> tl = new ArrayList<String>();
        tl.add("companyLongNumber");
        tl.add("nodeLongNumber");
        if (item._opCompany != null && item._opCompany.trim().length() > 0) {
            if (item._inCompany) {
                tl.add("inCompany");
                op = true;
            }
            if (item._sup) {
                tl.add("sup");
                op = true;
            }
            if (item._cus) {
                tl.add("cus");
                op = true;
            }
        }
        Iterator it = tempList.iterator();
        while (it.hasNext()) {
            ArrayList<IncashFlow> lst;
            StringBuffer buf = new StringBuffer();
            item = (IncashFlow)it.next();
            buf.append(item.company.getLongNumber() + "|");
            buf.append(item.node.getLongNumber());
            if (op) {
                buf.append("|" + item._opCompany);
            }
            if ((lst = (ArrayList<IncashFlow>)map.get(buf.toString())) == null) {
                lst = new ArrayList<IncashFlow>();
                map.put(buf.toString(), lst);
                queryList.add(item);
            }
            lst.add(item);
        }
        return tl.toArray(new String[tl.size()]);
    }

    String builderExtSelect(IncashFlow item) {
        StringBuffer buf = new StringBuffer();
        buf.append(" ,dyn.companyLongNumber as companyLongNumber  ");
        buf.append(" , dyn.nodeLongNumber  as nodeLongNumber ");
        if (item._opCompany != null && item._opCompany.trim().length() > 0) {
            if (item._inCompany) {
                buf.append(" ,dyn.inCompany as  inCompany ");
            }
            if (item._sup) {
                buf.append(",dyn.sup as sup ");
            }
            if (item._cus) {
                buf.append(" ,dyn.cus as cus ");
            }
        }
        return buf.toString();
    }

    String buliderGroupBy(IncashFlow item) {
        StringBuffer buf = new StringBuffer();
        buf.append("group by dyn.companyLongNumber ");
        buf.append(" , dyn.nodeLongNumber ");
        if (item._opCompany != null && item._opCompany.trim().length() > 0) {
            if (item._inCompany) {
                buf.append(" ,dyn.inCompany ");
            }
            if (item._sup) {
                buf.append(",dyn.sup ");
            }
            if (item._cus) {
                buf.append(" ,dyn.cus ");
            }
        }
        return buf.toString();
    }

    String buliderDynTableItem(IncashFlow item) {
        StringBuffer buf = new StringBuffer();
        buf.append("select '" + item.company.getLongNumber() + "' as companyLongNumber ,");
        buf.append("'" + item.company.getLongNumber() + "!'  as companyLongNumberd ,");
        buf.append("'" + item.node.getLongNumber() + "' as nodeLongNumber ,");
        buf.append("'" + item.node.getLongNumber() + "!'  as nodeLongNumberd ");
        if (item._opCompany != null && item._opCompany.trim().length() > 0) {
            if (item._inCompany) {
                buf.append(",'" + item._opCompany + "' as inCompany ");
            }
            if (item._sup) {
                buf.append(",'" + item._opCompany + "' as sup ");
            }
            if (item._cus) {
                buf.append(",'" + item._opCompany + "' as cus ");
            }
        }
        return buf.toString();
    }

    int calcDynTableItemSize(IncashFlow item) {
        return this.buliderDynTableItem(item).length() + 10;
    }

    String builderWhere(IncashFlow item, List temp) {
        StringBuffer buf = new StringBuffer();
        buf.append(" where (  Cash.FVoucherID = voucher.FID and voucher.FBizStatus <>0 and  voucher.FBizStatus <>2 ");
        buf.append(" and CashItem.FIsLeaf=1  ");
        if (!item._isincludingUnPosted) {
            buf.append(" and voucher.FBizStatus=5");
        }
        if (item._intYear == item._intYear2) {
            buf.append(" and  ( period.FPeriodYear = ? ");
            temp.add(new Integer(item._intYear));
            if (item._startPeriod == item._endPeriod) {
                buf.append(" and period.FPeriodNumber = ? )");
                temp.add(new Integer(item._startPeriod));
            } else {
                buf.append(" and period.FPeriodNumber >= ?");
                buf.append(" and period.FPeriodNumber <= ?)");
                temp.add(new Integer(item._startPeriod));
                temp.add(new Integer(item._endPeriod));
            }
        } else if (item._intYear < item._intYear2) {
            buf.append(" and (  (period.FPeriodYear = ? and period.FPeriodNumber >= ?  )  or ");
            temp.add(new Integer(item._intYear));
            temp.add(new Integer(item._startPeriod));
            buf.append("   ( period.FPeriodYear > ?   and period.FPeriodYear < ?  ) or ");
            temp.add(new Integer(item._intYear));
            temp.add(new Integer(item._intYear2));
            buf.append(" (period.FPeriodYear = ? and period.FPeriodNumber <= ? ) )");
            temp.add(new Integer(item._intYear2));
            temp.add(new Integer(item._endPeriod));
        } else {
            buf.append(" and  (1>2) ");
        }
        if (!item._cashTypeEnum.equals((Object)CashTypeEnum.AS) && !item._cashTypeEnum.equals((Object)CashTypeEnum.AZ)) {
            buf.append(" and Currency.FNumber = ?");
            temp.add(item._currency);
        }
        buf.append(")");
        buf.append(" and(( OrgUnit.FLongNumber = dyn.companyLongNumber ");
        buf.append(" or charindex( dyn.companyLongNumberd ,OrgUnit.FLongNumber )=1 )");
        buf.append(" and (CashItem.FLongNumber =  dyn.nodeLongNumber ");
        buf.append(" or charindex(dyn.nodeLongNumberd,CashItem.FLongNumber )=1 ) ");
        if (item._opCompany != null && item._opCompany.trim().length() > 0) {
            if (item._inCompany) {
                buf.append(" and incom.fnumber =dyn.inCompany ");
            }
            if (item._sup) {
                buf.append(" and comsup.fnumber =dyn.sup ");
            }
            if (item._cus) {
                buf.append(" and comcust.fnumber =dyn.cus ");
            }
        }
        buf.append(")");
        buf.append(" " + this.buliderGroupBy(item));
        return buf.toString();
    }

    String builderSel(IncashFlow item) {
        StringBuffer buf = new StringBuffer();
        if (item.masterItem == 0) {
            if (item.isLeaf || !item.isLeaf && item.direction != CashFlowDirection.IN_OR_OUT) {
                buf.append(" sum( " + this.getAmountPart(item.masterItem, item._cashTypeEnum, item._currency) + ") cashValue");
            } else {
                buf.append(" sum( " + this.getAmountPart(item.masterItem, item._cashTypeEnum, item._currency) + " *(3-2*CashItem.FDirection)) cashValue");
            }
        } else {
            buf.append(" sum( " + this.getAmountPart(item.masterItem, item._cashTypeEnum, item._currency) + ") cashValue");
        }
        buf.append(this.builderExtSelect(item));
        return buf.toString();
    }

    String builderFrom(IncashFlow item) {
        StringBuffer sql = new StringBuffer("");
        sql.append(" From T_GL_CashflowRecord Cash ").append(" inner join T_BD_CashFlowItem CashItem on CashItem.FID=");
        if (item.masterItem == 0) {
            sql.append(" Cash.FPrimaryItemID ");
        } else {
            sql.append(" Cash.FSupplementaryItemID ");
        }
        sql.append(" inner join T_GL_VoucherEntry ve on Cash.FEntryId = ve.FID").append(" inner join T_GL_Voucher voucher on voucher.FID = ve.FBillID").append(" inner join T_BD_Period period on period.FID = voucher.FPeriodID").append(" inner join T_Org_Company OrgUnit on OrgUnit.FID = voucher.FCompanyID").append(" inner join T_BD_Currency Currency on Currency.FID = ve.FCurrencyID");
        if (item._opCompany != null && item._opCompany.trim().length() > 0) {
            sql.append(" left join t_bd_assistanthg c on Cash.fassgrpid=c.fid  ");
            if (item._inCompany) {
                sql.append("left join t_org_company incom on incom.fid = c.fcompanyorgid  ");
            }
            if (item._sup) {
                sql.append(" left join t_bd_supplier sup on sup.fid=c.fproviderid  left join t_org_company comsup  on comsup.fid=sup.FInternalCompanyID  ");
            }
            if (item._cus) {
                sql.append(" left join t_bd_customer cust on cust.fid=c.fcustomerid  left join t_org_company comcust  on comcust.fid=cust.FInternalCompanyID  ");
            }
        }
        return sql.toString();
    }

    private String getAmountPart(int isPrimary, CashTypeEnum cashTypeEnum, String currency) {
        String coeffient = null;
        coeffient = isPrimary == 0 ? " Cash.FPrimaryCoeffient * " : " Cash.FSupplementaryCoeffient * ";
        if (cashTypeEnum.getValue() == 2) {
            return coeffient + "Cash.FOriginalAmount ";
        }
        if (cashTypeEnum.getValue() == 1 || cashTypeEnum.getValue() == 4) {
            return coeffient + "Cash.FLocalAmount ";
        }
        if (cashTypeEnum.getValue() == 3 || cashTypeEnum.getValue() == 5) {
            return coeffient + "Cash.FReportingAmount";
        }
        return null;
    }

    void queryInfo() {
        ArrayList<IncashFlow> newList = new ArrayList<IncashFlow>();
        Iterator<Object> it = this.list.iterator();
        EntityViewInfo ev = new EntityViewInfo();
        ev.getSelector().add(new SelectorItemInfo("type"));
        ev.getSelector().add(new SelectorItemInfo("isLeaf"));
        ev.getSelector().add(new SelectorItemInfo("direction"));
        ev.getSelector().add(new SelectorItemInfo("isProfit"));
        ev.getSelector().add(new SelectorItemInfo("number"));
        ev.getSelector().add(new SelectorItemInfo("id"));
        ev.setFilter(new FilterInfo());
        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>();
        HashSet<String> set = new HashSet<String>();
        int count = 0;
        String fc = null;
        while (it.hasNext()) {
            IncashFlow item = (IncashFlow)it.next();
            ArrayList tempList = (ArrayList)map.get(item._strProjCode);
            if (tempList == null) {
                if (++count == 1) {
                    fc = item._strProjCode;
                }
                set.add(item._strProjCode);
                tempList = new ArrayList();
                map.put(item._strProjCode, tempList);
            }
            tempList.add(item);
        }
        if (set.size() == 0) {
            return;
        }
        if (count > 1) {
            ev.getFilter().getFilterItems().add(new FilterItemInfo("number", set, CompareType.INCLUDE));
        } else {
            ev.getFilter().getFilterItems().add(new FilterItemInfo("number", fc));
        }
        CoreBaseCollection c = null;
        try {
            c = CashFlowItemFactory.getLocalInstance((Context)this.ServerCtx).getCollection(ev);
        }
        catch (BOSException e) {
            for (ArrayList tempList : map.values()) {
                if (tempList == null) continue;
                for (IncashFlow item : tempList) {
                    this.setException((Exception)((Object)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getResourceSince51("NotExistsCashFlowItem")})), item._param);
                }
            }
            this.list = newList;
            return;
        }
        for (CashFlowItemInfo info : c) {
            ArrayList tempList = (ArrayList)map.get(info.getNumber());
            if (tempList == null) continue;
            for (int i = 0; i < tempList.size(); ++i) {
                IncashFlow item = (IncashFlow)tempList.get(i);
                item.masterItem = info.getType().getValue();
                item.isLeaf = info.isIsLeaf();
                item.direction = info.getDirection();
                item.isProfit = info.isIsProfit();
                if (!item.company.isIsBizUnit() && item.masterItem != 0) {
                    this.setException((Exception)((Object)new RptAndTempException(RptAndTempException.NOTSUPPORTORG)), item._param);
                    continue;
                }
                newList.add(item);
            }
            map.put(info.getNumber(), null);
        }
        for (ArrayList tempList : map.values()) {
            if (tempList == null) continue;
            for (IncashFlow item : tempList) {
                this.setException((Exception)((Object)new RptAndTempException(RptAndTempException.ITEMISNULL)), item._param);
            }
        }
        this.list = newList;
    }

    void getGroupLongNumber() {
        ArrayList<IncashFlow> newList = new ArrayList<IncashFlow>();
        Iterator<Object> it = this.list.iterator();
        ArrayList<String> strList = new ArrayList<String>();
        HashMap<String, ArrayList<IncashFlow>> map = new HashMap<String, ArrayList<IncashFlow>>();
        while (it.hasNext()) {
            IncashFlow item = (IncashFlow)it.next();
            ArrayList<IncashFlow> tempList = (ArrayList<IncashFlow>)map.get(item._strProjCode);
            if (tempList == null) {
                strList.add(item._strProjCode);
                tempList = new ArrayList<IncashFlow>();
                map.put(item._strProjCode, tempList);
            }
            tempList.add(item);
        }
        if (strList.size() == 0) {
            return;
        }
        RptCalculaterDAO dao = new RptCalculaterDAO(this.ServerCtx);
        Map longNumber = null;
        try {
            longNumber = dao.getGroupLongNumber(strList.toArray(new String[strList.size()]), "T_BD_CashFlowItem");
        }
        catch (Exception e) {
            for (ArrayList tempList : map.values()) {
                if (tempList == null) continue;
                for (IncashFlow item : tempList) {
                    this.setException((Exception)((Object)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getResourceSince51("NotExistsCashFlowItem")})), item._param);
                }
            }
            this.list = newList;
            return;
        }
        for (Object key : map.keySet()) {
            IncashFlow item;
            int i;
            ArrayList tempList = (ArrayList)map.get(key);
            if (tempList == null) continue;
            GroupTreeNode node = (GroupTreeNode)longNumber.get(key.toString());
            if (node != null) {
                for (i = 0; i < tempList.size(); ++i) {
                    item = (IncashFlow)tempList.get(i);
                    item.node = node;
                    newList.add(item);
                }
                continue;
            }
            for (i = 0; i < tempList.size(); ++i) {
                item = (IncashFlow)tempList.get(i);
                this.setException((Exception)((Object)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getResourceSince51("NotExistsCashFlowItem")})), item._param);
            }
        }
        this.list = newList;
    }

    void queryCompany() {
        ArrayList<IncashFlow> newList = new ArrayList<IncashFlow>();
        Iterator it = this.list.iterator();
        HashMap<String, ArrayList<IncashFlow>> map = new HashMap<String, ArrayList<IncashFlow>>();
        String fcNumber = null;
        int count = 0;
        HashSet<String> set = new HashSet<String>();
        while (it.hasNext()) {
            IncashFlow item = (IncashFlow)it.next();
            ArrayList<IncashFlow> tempList = (ArrayList<IncashFlow>)map.get(item._fiOrgUnit);
            if (tempList == null) {
                tempList = new ArrayList<IncashFlow>();
                map.put(item._fiOrgUnit, tempList);
                if (++count == 1) {
                    fcNumber = item._fiOrgUnit;
                }
                set.add(item._fiOrgUnit);
            }
            tempList.add(item);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("*"));
        view.setFilter(new FilterInfo());
        if (count == 0) {
            return;
        }
        if (count > 1) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("number", set, CompareType.INCLUDE));
        } else {
            view.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)fcNumber));
        }
        ICompanyOrgUnit icompany = null;
        CompanyOrgUnitCollection companyCl = null;
        try {
            icompany = CompanyOrgUnitFactory.getLocalInstance((Context)this.ServerCtx);
            companyCl = icompany.getCompanyOrgUnitCollection(view);
        }
        catch (BOSException e) {
            for (ArrayList tempList : map.values()) {
                if (tempList == null) continue;
                for (IncashFlow item : tempList) {
                    this.setException((Exception)((Object)new ReportException(ReportException.FIND_COMPANY_ERROR, (Throwable)e)), item._param);
                }
            }
            this.list = newList;
            return;
        }
        if (companyCl != null && companyCl.size() > 0) {
            for (CompanyOrgUnitInfo opc : companyCl) {
                ArrayList tempList = (ArrayList)map.get(opc.getNumber());
                if (tempList == null) continue;
                for (int i = 0; i < tempList.size(); ++i) {
                    IncashFlow item = (IncashFlow)tempList.get(i);
                    item.company = opc;
                    newList.add(item);
                }
                map.put(opc.getNumber(), null);
            }
        }
        for (ArrayList tempList : map.values()) {
            if (tempList == null) continue;
            for (IncashFlow item : tempList) {
                this.setException((Exception)((Object)new ReportException(ReportException.FIND_COMPANY_ERROR)), item._param);
            }
        }
        this.list = newList;
    }

    void checkOpCompany() {
        ArrayList<IncashFlow> newList = new ArrayList<IncashFlow>();
        HashMap<String, ArrayList<IncashFlow>> map = new HashMap<String, ArrayList<IncashFlow>>();
        Iterator it = this.list.iterator();
        String fcNumber = null;
        int count = 0;
        HashSet<String> set = new HashSet<String>();
        while (it.hasNext()) {
            IncashFlow item = (IncashFlow)it.next();
            if (item._opCompany != null && item._opCompany.trim().length() > 0) {
                ArrayList<IncashFlow> tempList = (ArrayList<IncashFlow>)map.get(item._opCompany);
                if (tempList == null) {
                    tempList = new ArrayList<IncashFlow>();
                    map.put(item._opCompany, tempList);
                    if (++count == 1) {
                        fcNumber = item._opCompany;
                    }
                    set.add(item._opCompany);
                }
                tempList.add(item);
                continue;
            }
            newList.add(item);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("number"));
        view.setFilter(new FilterInfo());
        if (count == 0) {
            return;
        }
        if (count > 1) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("number", set, CompareType.INCLUDE));
        } else {
            view.getFilter().getFilterItems().add(new FilterItemInfo("number", fcNumber));
        }
        ICompanyOrgUnit icompany = null;
        CompanyOrgUnitCollection companyCl = null;
        try {
            icompany = CompanyOrgUnitFactory.getLocalInstance((Context)this.ServerCtx);
            companyCl = icompany.getCompanyOrgUnitCollection(view);
        }
        catch (BOSException e) {
            for (ArrayList tempList : map.values()) {
                if (tempList == null) continue;
                for (IncashFlow item : tempList) {
                    this.setException((Exception)((Object)new ReportException(ReportException.OPC_ERROR, (Throwable)e)), item._param);
                }
            }
            this.list = newList;
            return;
        }
        if (companyCl != null && companyCl.size() > 0) {
            for (CompanyOrgUnitInfo opc : companyCl) {
                ArrayList tempList = (ArrayList)map.get(opc.getNumber());
                if (tempList == null) continue;
                for (int i = 0; i < tempList.size(); ++i) {
                    IncashFlow item = (IncashFlow)tempList.get(i);
                    if (!(item._inCompany || item._sup || item._cus)) {
                        item._param.setValue((Object)new ReportException(ReportException.TYPE_ERROR).getMessage());
                        continue;
                    }
                    newList.add(item);
                }
                map.put(opc.getNumber(), null);
            }
        }
        for (ArrayList tempList : map.values()) {
            if (tempList == null) continue;
            for (IncashFlow item : tempList) {
                this.setException((Exception)((Object)new ReportException(ReportException.OPC_ERROR)), item._param);
            }
        }
        this.list = newList;
    }

    private String getCalculateSheetName() {
        return this._pma.getSheetName();
    }

    private void setException(Exception e, Parameter _param) {
        FormulaValueBackfill backFill = new FormulaValueBackfill(_param);
        backFill.setException((Throwable)e);
    }

    private int getSheet_StartPeriod() {
        return this.context.getReportVariables().getIntValue("StartPeriod", this.getCalculateSheetName(), 0);
    }

    private int getReport_PeriodType() {
        Integer period = (Integer)this.context.getReportAdapter().getReportProperty("PeriodType");
        if (period == null) {
            return -1;
        }
        return period;
    }

    private boolean isSheet_IncludePosted() {
        return this.context.getReportVariables().getBoolValue("IncludePosted", this.getCalculateSheetName(), false);
    }

    private int getSheet_StartYear() {
        ReportVariables vs = this.context.getReportVariables();
        if (vs == null) {
            return 0;
        }
        return vs.getIntValue("StartYear", this.getCalculateSheetName(), 0);
    }

    private int getSheet_EndPeriod() {
        ReportVariables vs = this.context.getReportVariables();
        if (vs == null) {
            return 0;
        }
        return vs.getIntValue("EndPeriod", this.getCalculateSheetName(), 0);
    }

    private int getReport_Year() {
        return (Integer)this.context.getReportAdapter().getReportProperty("Report.Year");
    }

    private int getReport_Period() {
        return (Integer)this.context.getReportAdapter().getReportProperty("Report.Period");
    }

    private String getCorrect_Currency_Number() {
        String currency = (String)this.context.getReportAdapter().getReportProperty("Currency.Number");
        return currency;
    }

    private String getSource_Currency_Number() {
        return (String)this.context.getReportAdapter().getReportProperty("SourceCurrency.Number");
    }

    private String getOrgUnit_Number() {
        return (String)this.context.getReportAdapter().getReportProperty("OrgUnit.Number");
    }

    private String getCompany_Number() {
        return (String)this.context.getReportAdapter().getReportProperty("Company.Number");
    }

    private String getOrgTreeNumber() {
        OrgTreeInfo info;
        String orgTreeNumber = (String)this.context.getReportAdapter().getReportProperty("CSLReport_OrgTree_Number");
        if (orgTreeNumber == null && (info = (OrgTreeInfo)this.context.getServerContext().get((Object)"KEY_ORGTREE_INFO")) != null) {
            orgTreeNumber = info.getNumber();
        }
        return orgTreeNumber;
    }

    private BigDecimal getRetainedProfits(Context ctx, CompanyOrgUnitInfo company, CashTypeEnum cashTypeEnum, String currency, int intYear, int startPeriod, int endPeriod, boolean isincludingUnPosted) throws BOSException, EASBizException {
        BigDecimal bdReturn = null;
        StringBuffer sbSql = new StringBuffer("select ");
        if (cashTypeEnum.equals((Object)CashTypeEnum.Z) || cashTypeEnum.equals((Object)CashTypeEnum.AZ)) {
            sbSql.append(" sum(case ve.FEntryDC when 0 then ve.FLocalAmount else (-1) * FLocalAmount end) FAmount");
        } else if (cashTypeEnum.equals((Object)CashTypeEnum.S) || cashTypeEnum.equals((Object)CashTypeEnum.AS)) {
            sbSql.append(" sum(case ve.FEntryDC when 0 then ve.FReportingAmount else (-1) * FReportingAmount end) FAmount");
        } else {
            sbSql.append(" sum(case ve.FEntryDC when 0 then ve.FOriginalAmount else (-1) * FOriginalAmount end) FAmount");
        }
        sbSql.append(" from T_GL_Voucher voucher join T_GL_VoucherEntry ve on voucher.FID = ve.FBillID join T_BD_AccountView account on ve.FAccountID = account.FID left join t_bd_cashflowaccountdiff on fdiffaccountid=account.FID ").append(" inner join T_BD_Currency Currency on Currency.FID = ve.FCurrencyID");
        sbSql.append(" ,T_BD_Period period");
        sbSql.append(" where voucher.FCompanyID = ?");
        sbSql.append(" and fdiffaccountid is null");
        sbSql.append(" and account.FPLType <> ?");
        sbSql.append(" and voucher.FPeriodID = period.FID");
        sbSql.append(" and period.FPeriodYear >= ?");
        sbSql.append(" and period.FPeriodNumber >= ?");
        sbSql.append(" and period.FPeriodYear <= ?");
        sbSql.append(" and period.FPeriodNumber <= ?");
        if (!cashTypeEnum.equals((Object)CashTypeEnum.AS) && !cashTypeEnum.equals((Object)CashTypeEnum.AZ)) {
            sbSql.append(" and UPPER(Currency.FNumber) = ?  ");
        }
        sbSql.append(" and voucher.FSourceType<>1 ");
        sbSql.append(" and voucher.FBizStatus in(");
        sbSql.append(5);
        if (isincludingUnPosted) {
            sbSql.append(",");
            sbSql.append(1);
            sbSql.append(",");
            sbSql.append(3);
        }
        sbSql.append(")");
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)this.ServerCtx);
            ps = conn.prepareStatement(sbSql.toString());
            int index = 1;
            ps.setString(index++, company.getId().toString());
            ps.setInt(index++, 0);
            ps.setInt(index++, intYear);
            ps.setInt(index++, startPeriod);
            ps.setInt(index++, intYear);
            ps.setInt(index++, endPeriod);
            if (!cashTypeEnum.equals((Object)CashTypeEnum.AS) && !cashTypeEnum.equals((Object)CashTypeEnum.AZ)) {
                ps.setString(index++, currency);
            }
            rs = ps.executeQuery();
            rs.next();
            bdReturn = rs.getBigDecimal("FAmount");
        }
        catch (SQLException se) {
            try {
                throw new BOSException((Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return bdReturn == null ? new BigDecimal(0.0) : bdReturn;
    }

    private CompanyOrgUnitInfo getCacheCompany(String fiOrgUnit) throws BOSException {
        if (this.companyCache.get(fiOrgUnit) == null) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.getSelector().add(new SelectorItemInfo("*"));
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)fiOrgUnit, CompareType.EQUALS));
            ICompanyOrgUnit company = null;
            company = this.ServerCtx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)this.ServerCtx);
            CompanyOrgUnitCollection coms = company.getCompanyOrgUnitCollection(evi);
            if (coms != null && coms.size() > 0) {
                this.companyCache.put(fiOrgUnit, coms.get(0));
            }
        }
        return (CompanyOrgUnitInfo)this.companyCache.get(fiOrgUnit);
    }

    public void checkPermision(String org) throws EASBizException, BOSException {
        ChecFmlParamPermissionUtil p = ChecFmlParamPermissionUtil.getInstance(this.context);
        if (p != null) {
            p.checkCompanyPermision(org);
        }
    }

    public void insertCondition(List list, Connection conn) throws Exception {
        if (list == null || list.size() == 0) {
            return;
        }
        Iterator it = list.iterator();
        PreparedStatement ps = null;
        IncashFlow item = null;
        String insertStr = "INSERT INTO " + this.templateTbl + " VALUES (?,?,?,?,?,?,?)";
        try {
            ps = conn.prepareStatement(insertStr);
            while (it.hasNext()) {
                item = (IncashFlow)it.next();
                ps.setString(1, item.company.getLongNumber());
                ps.setString(2, item.company.getLongNumber() + '!');
                ps.setString(3, item.node.getLongNumber());
                ps.setString(4, item.node.getLongNumber() + '!');
                ps.setString(5, item._inCompany ? item._opCompany : "");
                ps.setString(6, item._sup ? item._opCompany : "");
                ps.setString(7, item._cus ? item._opCompany : "");
                ps.addBatch();
            }
            ps.executeBatch();
            conn.commit();
        }
        catch (SQLException e) {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"65_ICashFlowCalculater", (Locale)this.ServerCtx.getOriginLocale()) + e.getCause());
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public String createTempTable() throws Exception {
        String tempTable = "COMPANY_TEMP";
        StringBuffer createSql = new StringBuffer("CREATE  TABLE ");
        createSql.append(tempTable);
        createSql.append(" (companyLongNumber varchar(200),companyLongNumberd varchar(201),");
        createSql.append(" nodeLongNumber varchar(200),nodeLongNumberd varchar(201),inCompany varchar(100),");
        createSql.append(" sup varchar(100),cus varchar(100) )");
        try {
            tempTable = TempTablePool.getInstance((Context)this.ServerCtx).createTempTable(createSql.toString());
        }
        catch (Exception e) {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"66_ICashFlowCalculater", (Locale)this.ServerCtx.getOriginLocale()) + e.getCause());
        }
        this.templateTbl = tempTable;
        return tempTable;
    }

    private void deleteTempTableData(String tempateTable) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("delete " + tempateTable);
        DbUtil.execute((Context)this.ServerCtx, (String)sql.toString());
    }

    class IncashFlow {
        Parameter _param = null;
        String _strProjCode = null;
        boolean _inCompany = false;
        boolean _sup = false;
        boolean _cus = false;
        String _currency;
        CashTypeEnum _cashTypeEnum;
        String _fiOrgUnit;
        String _opCompany;
        boolean _isincludingUnPosted;
        int _intYear;
        int _intYear2;
        int _startPeriod;
        int _endPeriod;
        CompanyOrgUnitInfo company = null;
        GroupTreeNode node = null;
        boolean isLeaf = false;
        CashFlowDirection direction = null;
        int masterItem = -1;
        boolean isProfit = false;

        public IncashFlow(Parameter p) {
            this._param = p;
            this._param.setValue((Object)new BigDecimal("0"));
        }

        boolean init() {
            try {
                Integer b;
                String FlowPorj;
                ICashFlowCalculater.this._pma = this._param;
                Object[] params = this._param.getArgs();
                String fiOrgUnit = ((Variant)params[0]).getValue() == null ? null : ((Variant)params[0]).getValue().toString();
                String oprOrg = ((Variant)params[1]).getValue() == null ? null : ((Variant)params[1]).getValue().toString();
                String cashTypeEnumStr = ((Variant)params[2]).getValue() == null ? null : ((Variant)params[2]).getValue().toString();
                String currency = ((Variant)params[3]).getValue() == null ? null : ((Variant)params[3]).getValue().toString();
                int intYear = Integer.parseInt(((Variant)params[4]).getValue().toString());
                int startPeriod = Integer.parseInt(((Variant)params[5]).getValue().toString());
                int endPeriod = Integer.parseInt(((Variant)params[6]).getValue().toString());
                String string = FlowPorj = ((Variant)params[7]).getValue() == null ? null : ((Variant)params[7]).getValue().toString();
                if (ICashFlowCalculater.this.pmc != null) {
                    try {
                        if (ICashFlowCalculater.this.pmc != null) {
                            ICashFlowCalculater.this.pmc.checkCompanyPermision(fiOrgUnit);
                        }
                    }
                    catch (Exception e) {
                        FormulaValueBackfill backFill = new FormulaValueBackfill(this._param);
                        backFill.setException((Throwable)e);
                        return false;
                    }
                }
                CashTypeEnum cashTypeEnum = null;
                if (!StringUtils.isEmpty((String)cashTypeEnumStr)) {
                    cashTypeEnumStr = cashTypeEnumStr.toUpperCase();
                    cashTypeEnum = CashTypeEnum.getEnum(cashTypeEnumStr);
                }
                if (fiOrgUnit == null || fiOrgUnit.length() <= 0) {
                    fiOrgUnit = ICashFlowCalculater.this.getCompany_Number();
                }
                this.company = ICashFlowCalculater.this.getCacheCompany(fiOrgUnit);
                if (this.company == null) {
                    ICashFlowCalculater.this.setException((Exception)((Object)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"33_AcctCashCalcter", (Locale)ICashFlowCalculater.this.ServerCtx.getOriginLocale())})), this._param);
                    return false;
                }
                if (intYear <= 0 && (intYear += ICashFlowCalculater.this.getSheet_StartYear()) <= 0) {
                    intYear += ICashFlowCalculater.this.getReport_Year();
                }
                int intYear2 = intYear;
                if (startPeriod <= 0) {
                    if ((startPeriod += ICashFlowCalculater.this.getSheet_StartPeriod()) <= 0) {
                        startPeriod += ICashFlowCalculater.this.getReport_Period();
                    }
                    if (startPeriod <= 0) {
                        startPeriod += PeriodUtils.getMaxPeriodNumber((Context)ICashFlowCalculater.this.ServerCtx, (int)(--intYear), (String)this.company.getId().toString());
                    }
                    if (ICashFlowCalculater.this.getReport_PeriodType() > 0 && 3 != ICashFlowCalculater.this.getReport_PeriodType()) {
                        Date periodLastDate = RPTDateUtil.getPeriodLastDate((int)intYear, (int)startPeriod, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)ICashFlowCalculater.this.getReport_PeriodType()));
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(periodLastDate);
                        intYear = calendar.get(1);
                        startPeriod = calendar.get(2) + 1;
                    }
                }
                if (endPeriod <= 0) {
                    if ((endPeriod += ICashFlowCalculater.this.getSheet_EndPeriod()) <= 0) {
                        endPeriod += ICashFlowCalculater.this.getReport_Period();
                    }
                    if (endPeriod <= 0) {
                        endPeriod += PeriodUtils.getMaxPeriodNumber((Context)ICashFlowCalculater.this.ServerCtx, (int)(--intYear2), (String)this.company.getId().toString());
                    }
                    if (ICashFlowCalculater.this.getReport_PeriodType() > 0 && 3 != ICashFlowCalculater.this.getReport_PeriodType()) {
                        Calendar calendar = Calendar.getInstance();
                        Date periodLastDate = RPTDateUtil.getPeriodLastDate((int)intYear2, (int)endPeriod, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)ICashFlowCalculater.this.getReport_PeriodType()));
                        calendar.setTime(periodLastDate);
                        intYear2 = calendar.get(1);
                        endPeriod = calendar.get(2) + 1;
                    }
                }
                if ((b = (Integer)ICashFlowCalculater.this.context.getReportAdapter().getReportProperty("SupportAdjustPeriodData")) != null && b == 1 && endPeriod == 12) {
                    endPeriod = PeriodUtils.getMaxPeriodNumber((Context)ICashFlowCalculater.this.ServerCtx, (int)intYear2, (String)this.company.getId().toString());
                }
                if (currency == null || currency.length() <= 0) {
                    currency = ICashFlowCalculater.this.getCorrect_Currency_Number();
                }
                boolean includeVoucher = ICashFlowCalculater.this.isSheet_IncludePosted();
                if (FlowPorj != null && FlowPorj.indexOf("|") > 0) {
                    String code = FlowPorj.substring(0, FlowPorj.indexOf("|"));
                    String other = FlowPorj.substring(FlowPorj.indexOf("|") + 1);
                    if (other == null) {
                        other = "";
                    }
                    other = other.toUpperCase().trim();
                    FlowPorj = code;
                    if (other.equals("C")) {
                        this._cus = true;
                    }
                    if (other.equals("I")) {
                        this._inCompany = true;
                    }
                    if (other.equals("S")) {
                        this._sup = true;
                    }
                }
                this._strProjCode = FlowPorj;
                this._currency = currency;
                this._cashTypeEnum = cashTypeEnum;
                this._fiOrgUnit = fiOrgUnit;
                this._opCompany = oprOrg;
                this._isincludingUnPosted = includeVoucher;
                this._intYear = intYear;
                this._intYear2 = intYear2;
                this._startPeriod = startPeriod;
                this._endPeriod = endPeriod;
                if (StringUtils.isEmpty((String)this._currency)) {
                    this._param.setValue((Object)RptUtil.getResourceSince51("NeedCurrency"));
                    return false;
                }
                if (StringUtils.isEmpty((String)this._strProjCode)) {
                    this._param.setValue((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"NeedCashFlowItem", (Locale)ICashFlowCalculater.this.ServerCtx.getOriginLocale()));
                    return false;
                }
                if ((this._currency.equalsIgnoreCase("GLC") || this._currency.equalsIgnoreCase("GRC")) && this._cashTypeEnum != null && (this._cashTypeEnum.equals((Object)CashTypeEnum.S) || this._cashTypeEnum.equals((Object)CashTypeEnum.Y) || this._cashTypeEnum.equals((Object)CashTypeEnum.Z))) {
                    ICashFlowCalculater.this.setException((Exception)((Object)new ReportException(ReportException.CANNOT_CURRENCY)), this._param);
                    return false;
                }
                if (this._cashTypeEnum != null && this._cashTypeEnum.equals((Object)CashTypeEnum.AS) && !this._currency.equalsIgnoreCase("GRC")) {
                    ICashFlowCalculater.this.setException((Exception)((Object)new ReportException(ReportException.ONLY_GRC)), this._param);
                    return false;
                }
                if (this._cashTypeEnum != null && this._cashTypeEnum.equals((Object)CashTypeEnum.AZ) && !this._currency.equalsIgnoreCase("GLC")) {
                    ICashFlowCalculater.this.setException((Exception)((Object)new ReportException(ReportException.ONLY_GLC)), this._param);
                    return false;
                }
                return true;
            }
            catch (Throwable a) {
                this._param.setValue((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"34_AcctCashCalcter", (Locale)ICashFlowCalculater.this.ServerCtx.getOriginLocale()));
                return false;
            }
        }
    }
}

