/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ColumnInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.TableInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.StringUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.dbcenter.DBCenterInfo;
import com.kingdee.eas.fi.newrpt.dbcenter.pool.DBPoolManager;
import com.kingdee.eas.fi.newrpt.dbcenter.util.DBCenterManager;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.ValueTypeEnum;
import com.kingdee.eas.fi.rpt.batch.ChecFmlParamPermissionUtil;
import com.kingdee.eas.fi.rpt.batch.FormulaValueBackfill;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.log4j.Logger;

public class KPGetSqlBatchCalculator {
    private static final Logger log = Logger.getLogger((String)KPGetSqlBatchCalculator.class.getName());
    private Map formulas = new HashMap();
    private ICalculateContextProvider calContext;
    private Context context;
    ChecFmlParamPermissionUtil pmc = null;
    public String batchStr = "##";
    public String inBatchStr = "@@";
    private boolean checkPermission = true;

    public KPGetSqlBatchCalculator(ICalculateContextProvider calContext, Context _serverCtx) {
        this.context = _serverCtx;
        this.calContext = calContext;
        this.pmc = ChecFmlParamPermissionUtil.getInstance(calContext);
    }

    private Connection getConnection() throws SQLDataException {
        try {
            return EJBFactory.getQueryConnection((Context)this.context);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    public void initPermission(ICalculateContextProvider context) {
        ReportVariables rvs = context.getReportVariables();
        if (rvs == null) {
            return;
        }
        VariableEntry v = rvs.get("Check_Permissioin", null);
        if (v == null) {
            return;
        }
        try {
            this.checkPermission = Boolean.valueOf(v.getValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(SortedParameterArray params) {
        if (params == null) {
            return;
        }
        Connection conn = null;
        IRowSet rs = null;
        try {
            this.initPermission(this.calContext);
            for (int i = 0; i < params.size(); ++i) {
                KPGetSql kPGetSql = new KPGetSql(params.getParameter(i));
                this.putToFormulasMap(kPGetSql, null);
            }
            try {
                this.setCompanyIds(this.formulas.keySet());
            }
            catch (Exception e1) {
                log.debug((Object)e1.getMessage());
                for (KPGetSql kPGetSql : this.formulas.keySet()) {
                    kPGetSql.isFormulaValid = false;
                    this.formulas.put(kPGetSql, e1);
                }
                this.exportData();
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        log.debug((Object)e.getMessage());
                    }
                }
                return;
            }
            try {
                if (this.checkPermission) {
                    this.checkPermission(this.formulas.keySet());
                }
            }
            catch (Exception e1) {
                log.debug((Object)e1.getMessage());
                for (KPGetSql kPGetSql : this.formulas.keySet()) {
                    kPGetSql.isFormulaValid = false;
                    this.formulas.put(kPGetSql, e1);
                }
                this.exportData();
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        log.debug((Object)e.getMessage());
                    }
                }
                return;
            }
            HashMap batchFormulas = new HashMap();
            String batchKey = null;
            HashMap<String, HashSet<KPGetSql>> fieldV_sqlMap = null;
            HashSet<KPGetSql> curKPGetSql = null;
            for (KPGetSql kPGetSql : this.formulas.keySet()) {
                if (!kPGetSql.isFormulaValid || !StringUtils.isEmpty((String)kPGetSql.dbCenterNumber)) continue;
                try {
                    if (kPGetSql.isBatchQuery) {
                        String batchParamKey;
                        batchKey = kPGetSql.batchSql + kPGetSql.columnName;
                        fieldV_sqlMap = (HashMap<String, HashSet<KPGetSql>>)batchFormulas.get(batchKey);
                        if (fieldV_sqlMap == null) {
                            fieldV_sqlMap = new HashMap<String, HashSet<KPGetSql>>();
                        }
                        if ((curKPGetSql = (HashSet<KPGetSql>)fieldV_sqlMap.get(batchParamKey = kPGetSql.getBatchParamsKey())) == null) {
                            curKPGetSql = new HashSet<KPGetSql>();
                        }
                        curKPGetSql.add(kPGetSql);
                        fieldV_sqlMap.put(batchParamKey, curKPGetSql);
                        batchFormulas.put(batchKey, fieldV_sqlMap);
                        continue;
                    }
                    if (conn == null) {
                        conn = this.getConnection();
                    }
                    if (kPGetSql.isProcedure) {
                        this.excuteProcedure(conn, kPGetSql);
                        continue;
                    }
                    rs = DbUtil.executeQuery((Context)this.context, (String)kPGetSql.sql);
                    if (rs == null || !rs.next()) continue;
                    this.putToFormulasMap(kPGetSql, rs.getObject(kPGetSql.columnName));
                }
                catch (Exception e) {
                    log.error((Object)"kpetSQL error.", (Throwable)e);
                    kPGetSql.setFormulaUnvalid(e);
                }
            }
            ArrayList<ParamTempTblService> services = new ArrayList<ParamTempTblService>();
            Iterator iter = null;
            for (Map batchFormula : batchFormulas.values()) {
                Set kpGetSqls = (Set)batchFormula.values().iterator().next();
                try {
                    Object kpGetSql2 = (KPGetSql)kpGetSqls.iterator().next();
                    String sql = ((KPGetSql)kpGetSql2).batchSql;
                    Set curParams = batchFormula.keySet();
                    int paramSize = ((String)curParams.iterator().next()).split(";").length;
                    Set[] colParams = new Set[paramSize];
                    for (String param : curParams) {
                        String[] colparamArr = param.split(";");
                        for (int i = 0; i < colparamArr.length; ++i) {
                            if (colParams[i] == null) {
                                colParams[i] = new HashSet();
                            }
                            colParams[i].add(colparamArr[i]);
                        }
                    }
                    for (int i = 0; i < colParams.length; ++i) {
                        String inStr = null;
                        if (curParams.size() > 20) {
                            TableInfo table = new TableInfo("T_CSL_SqlParams");
                            table.addColumn(new ColumnInfo("FVALUE", "nvarchar(300)"));
                            ParamTempTblService service = ParamTempTblService.getInstance((Context)this.context, (TableInfo)table, (Collection)colParams[i], null);
                            inStr = "select FVALUE from " + service.getTmpTableName();
                            services.add(service);
                        } else {
                            boolean isVar = ((KPGetSql)kpGetSql2).paramTypes.get(i) == 12;
                            inStr = CslRptUtil.collection2String((Collection)colParams[i], (String)",", (boolean)isVar);
                        }
                        sql = StringUtil.replaceFirst((String)sql, (String)this.inBatchStr, (String)inStr);
                    }
                    rs = DbUtil.executeQuery((Context)this.context, (String)sql);
                    StringBuffer key = new StringBuffer();
                    while (rs != null && rs.next()) {
                        key.setLength(0);
                        for (int i = 0; i < paramSize; ++i) {
                            key.append(rs.getString("batchFieldKey" + i)).append(";");
                        }
                        if (key.length() > 0) {
                            key.deleteCharAt(key.lastIndexOf(";"));
                        }
                        kpGetSqls = (Set)batchFormula.get(key.toString());
                        for (Object kpGetSql2 : kpGetSqls) {
                            this.putToFormulasMap(kpGetSql2, rs.getObject(((KPGetSql)kpGetSql2).columnName));
                        }
                    }
                }
                catch (Exception ex) {
                    log.error((Object)"batchSql error.", (Throwable)ex);
                    for (KPGetSql kpGetSql : kpGetSqls) {
                        kpGetSql.setFormulaUnvalid(ex);
                    }
                }
                finally {
                    if (services.isEmpty() || DebugLogger.isDebug) continue;
                    for (ParamTempTblService service : services) {
                        service.release();
                    }
                }
            }
            try {
                this.getOuterDBCenterData(this.formulas);
            }
            catch (Exception ex) {
                log.error((Object)"getOuterDBCenterData Error: ", (Throwable)ex);
            }
            this.exportData();
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    log.debug((Object)e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void excuteProcedure(Connection conn, KPGetSql kPGetSql) throws SQLException {
        CallableStatement cstmt = conn.prepareCall("{" + kPGetSql.sql + "}");
        if (!"PostgresSQL".equals(ContextUtil.getDbType((Context)this.context))) {
            cstmt.registerOutParameter(kPGetSql.returnColumnIndex, kPGetSql.sqlValueType);
        }
        int len = kPGetSql.procParams.size();
        for (int i = 0; i < len; ++i) {
            int paramIndex = i + 1;
            if (paramIndex == kPGetSql.returnColumnIndex) continue;
            if (kPGetSql.procParams.get(i) instanceof Integer) {
                cstmt.setInt(paramIndex, (int)((Integer)kPGetSql.procParams.get(i)));
                continue;
            }
            cstmt.setObject(paramIndex, kPGetSql.procParams.get(i));
        }
        if (!"PostgresSQL".equals(ContextUtil.getDbType((Context)this.context))) {
            cstmt.execute();
        }
        Object result = null;
        if ("MS SQL Server".equals(ContextUtil.getDbType((Context)this.context))) {
            ResultSet result0 = cstmt.getResultSet();
            if (result0 != null && result0.next()) {
                result = result0.getObject(1);
            } else if (result0 == null) {
                try {
                    result = cstmt.getObject(kPGetSql.returnColumnIndex);
                    if (result != null && result instanceof ResultSet && ((ResultSet)result).next()) {
                        result = ((ResultSet)result).getObject(kPGetSql.returnColumnIndex);
                    }
                }
                catch (Exception e) {
                    log.error((Object)"sql get result error----", (Throwable)e);
                    result = null;
                }
            }
        } else if (!"PostgresSQL".equals(ContextUtil.getDbType((Context)this.context))) {
            result = cstmt.getObject(kPGetSql.returnColumnIndex);
            if (result != null && result instanceof ResultSet && ((ResultSet)result).next()) {
                result = ((ResultSet)result).getObject(kPGetSql.returnColumnIndex);
            }
        } else {
            try (ResultSet resultSet = null;){
                resultSet = cstmt.executeQuery();
                if (resultSet.next()) {
                    result = resultSet.getObject(1);
                }
            }
        }
        this.putToFormulasMap(kPGetSql, result);
        cstmt.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getOuterDBCenterData(Map formulas) throws Exception {
        Map dbCentersMap = new HashMap();
        Map<String, List<KPGetSql>> map = this.getFormulaWithDBCenterNumber(formulas.keySet());
        Set<String> keys = map.keySet();
        block7: for (String number : keys) {
            List<KPGetSql> kPGetSqls = map.get(number);
            Connection conn = null;
            if (dbCentersMap.size() == 0) {
                dbCentersMap = DBCenterManager.getAllDbCenters((Context)this.context);
            }
            try {
                for (KPGetSql kPGetSql : kPGetSqls) {
                    block16: {
                        if (conn == null && dbCentersMap.containsKey(number)) {
                            DBCenterInfo info = (DBCenterInfo)dbCentersMap.get(number);
                            try {
                                conn = DBPoolManager.getConnection((DBCenterInfo)info);
                                break block16;
                            }
                            catch (Exception ex) {
                                if (conn != null) {
                                    conn.close();
                                    conn = null;
                                }
                                for (KPGetSql kPGetSqlex : kPGetSqls) {
                                    kPGetSqlex.setFormulaUnvalid(ex);
                                }
                                continue block7;
                            }
                        }
                        if (!dbCentersMap.containsKey(number)) {
                            kPGetSql.setFormulaUnvalid(new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"notExistDBCenterInfo", (Locale)this.context.getOriginLocale())));
                        }
                    }
                    if (kPGetSql.isProcedure) {
                        this.excuteProcedure(conn, kPGetSql);
                        continue;
                    }
                    this.excuteQuery(conn, kPGetSql);
                }
            }
            catch (Exception ex) {
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
                log.error((Object)"getOuterDBCenterData: ", (Throwable)ex);
            }
            finally {
                if (conn == null) continue;
                conn.close();
                conn = null;
            }
        }
        dbCentersMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void excuteQuery(Connection conn, KPGetSql kPGetSql) throws SQLException {
        PreparedStatement stmt;
        block5: {
            stmt = null;
            try {
                long time = System.currentTimeMillis();
                stmt = conn.prepareStatement(kPGetSql.sql);
                ResultSet rs = stmt.executeQuery();
                if (DebugLogger.isDebug) {
                    DbUtil.writeSqlLog((Context)this.context, (String)kPGetSql.sql, null, (long)(System.currentTimeMillis() - time));
                }
                if (rs == null || !rs.next()) break block5;
                this.putToFormulasMap(kPGetSql, rs.getObject(kPGetSql.columnName));
            }
            catch (Exception ex) {
                try {
                    kPGetSql.setFormulaUnvalid(ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(stmt);
                    throw throwable;
                }
                SQLUtils.cleanup((Statement)stmt);
            }
        }
        SQLUtils.cleanup((Statement)stmt);
    }

    private Map<String, List<KPGetSql>> getFormulaWithDBCenterNumber(Set kPGetSqls) {
        HashMap<String, List<KPGetSql>> formulas = new HashMap<String, List<KPGetSql>>();
        for (KPGetSql kPGetSql : kPGetSqls) {
            if (!kPGetSql.isFormulaValid) continue;
            ArrayList<KPGetSql> kpGetsqlList = new ArrayList<KPGetSql>();
            if (StringUtils.isEmpty((String)kPGetSql.dbCenterNumber)) continue;
            if (formulas.containsKey(kPGetSql.dbCenterNumber)) {
                ((List)formulas.get(kPGetSql.dbCenterNumber)).add(kPGetSql);
                continue;
            }
            kpGetsqlList.add(kPGetSql);
            formulas.put(kPGetSql.dbCenterNumber, kpGetsqlList);
        }
        return formulas;
    }

    private void exportData() {
        if (this.formulas == null) {
            return;
        }
        Iterator it = this.formulas.keySet().iterator();
        while (it.hasNext()) {
            KPGetSql key = null;
            try {
                key = (KPGetSql)it.next();
                Object value = this.formulas.get(key);
                if (value == null) {
                    value = new String("");
                }
                if ((key.sqlValueType == 3 || key.sqlValueType == 4) && key.isFormulaValid) {
                    try {
                        key.formulaValue.setValue((Object)new BigDecimal(value.toString()));
                    }
                    catch (Exception e) {
                        log.debug((Object)e.getMessage());
                        key.formulaValue.setValue((Object)new BigDecimal(0.0));
                    }
                    continue;
                }
                key.formulaValue.setValue(value);
            }
            catch (Exception e) {
                key.formulaValue.setValue((Object)e);
            }
        }
    }

    private String getCompanyNumber() {
        return (String)this.calContext.getReportAdapter().getReportProperty("Company.Number");
    }

    private int getReport_Year() {
        return (Integer)this.calContext.getReportAdapter().getReportProperty("Report.Year");
    }

    private int getReport_Period() {
        return (Integer)this.calContext.getReportAdapter().getReportProperty("Report.Period");
    }

    private int getReport_PeriodType() {
        return 3;
    }

    private String getCorrect_Currency_Number() {
        String currency = (String)this.calContext.getReportAdapter().getReportProperty("Currency.Number");
        return currency;
    }

    private void putToFormulasMap(Object key, Object value) {
        if (this.formulas == null) {
            this.formulas = new HashMap();
        }
        if (this.formulas.get(key) == null || ((KPGetSql)key).isFormulaValid) {
            this.formulas.put(key, value);
        }
    }

    private void setCompanyIds(Set kPGetSqls) throws BOSException, SQLException {
        if (kPGetSqls == null || kPGetSqls.size() == 0 || this.validFormulaCount(kPGetSqls) == 0) {
            return;
        }
        ArrayList<KPGetSql> list = new ArrayList<KPGetSql>();
        StringBuffer sql = new StringBuffer("select FNumber,Fid from T_ORG_BASEUNIT where FNumber in (");
        Iterator it = kPGetSqls.iterator();
        int i = 0;
        HashSet<String> companyNumberSet = new HashSet<String>();
        while (it.hasNext()) {
            KPGetSql kPGetSql = (KPGetSql)it.next();
            list.add(kPGetSql);
            if (!kPGetSql.isFormulaValid || companyNumberSet.contains(kPGetSql.companyNumber)) continue;
            if (i > 0) {
                sql.append(",");
            }
            sql.append("'" + kPGetSql.companyNumber + "'");
            companyNumberSet.add(kPGetSql.companyNumber);
            ++i;
        }
        companyNumberSet.clear();
        sql.append(")");
        IRowSet rs = null;
        if (i > 0) {
            rs = DbUtil.executeQuery((Context)this.context, (String)sql.toString());
        }
        if (rs != null) {
            String key = null;
            while (rs.next()) {
                key = rs.getString("FNumber");
                for (int j = 0; j < list.size(); ++j) {
                    KPGetSql ksql = (KPGetSql)list.get(j);
                    if (!ksql.companyNumber.equalsIgnoreCase(key)) continue;
                    ksql.companyId = rs.getString("Fid");
                    if (!ksql.isProcedure) {
                        ksql.sql = ksql.sql.replaceAll("@company", "'" + ksql.companyId + "'");
                        ksql.sql = ksql.sql.replaceAll("#company", "'" + ksql.companyId + "'");
                        if (ksql.batchSql == null) continue;
                        ksql.batchSql = ksql.batchSql.replaceAll("@company", "'" + ksql.companyId + "'");
                        ksql.batchSql = ksql.batchSql.replaceAll("#company", "'" + ksql.companyId + "'");
                        continue;
                    }
                    ksql.replaceCompanyIDInProcParams(ksql.companyId);
                }
            }
        }
    }

    private void checkPermission(Set kPGetSqls) throws Exception {
        if (kPGetSqls == null || kPGetSqls.size() == 0 || this.validFormulaCount(kPGetSqls) == 0) {
            return;
        }
        IObjectPK userPK = this.context.getCaller();
        String userID = userPK.toString();
        PermItemInfo rptPermItemInfo = PermissionCacheFactory.getPermItemCache((Context)this.context).getPermItem(this.context, "rpt_calculate_getsql");
        PermItemInfo profPermItemInfo = PermissionCacheFactory.getPermItemCache((Context)this.context).getPermItem(this.context, "prof_calculate_getsql");
        String rptPermItemID = rptPermItemInfo.getId().toString();
        String profPermItemID = profPermItemInfo.getId().toString();
        StringBuffer companyIds = new StringBuffer();
        ArrayList<KPGetSql> list = new ArrayList<KPGetSql>();
        HashSet<String> companyIdSet = new HashSet<String>();
        ReportException noRightException = new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"NoCompanyPermission", (Locale)this.context.getLocale())});
        if (kPGetSqls.size() > 0) {
            Iterator it = kPGetSqls.iterator();
            int i = 0;
            while (it.hasNext()) {
                KPGetSql kPGetSql = (KPGetSql)it.next();
                if (!kPGetSql.isFormulaValid) continue;
                if (!companyIdSet.contains(kPGetSql.companyId)) {
                    if (companyIds.length() > 0) {
                        companyIds.append(",");
                    }
                    companyIds.append("'").append(kPGetSql.companyId).append("'");
                    companyIdSet.add(kPGetSql.companyId);
                }
                list.add(kPGetSql);
                kPGetSql.setFormulaUnvalid((Exception)((Object)noRightException));
                ++i;
            }
        }
        companyIdSet.clear();
        Object[] params = new Object[]{userID, rptPermItemID, profPermItemID, userID, rptPermItemID, new Integer(rptPermItemInfo.getOrgRelation().getValue()), profPermItemID, new Integer(profPermItemInfo.getOrgRelation().getValue())};
        StringBuffer sql = new StringBuffer(2000);
        sql.append(" SELECT UserOrgPerm.FPermType AS FPermType,UserOrgPerm.FOrgID AS FOrgID FROM T_PM_UserOrgPerm UserOrgPerm ").append(" WHERE UserOrgPerm.FOwner = ? ").append(" AND UserOrgPerm.FOrgID in(").append(companyIds).append(")").append(" AND UserOrgPerm.FPermItemID in(?,?) ").append(" AND UserOrgPerm.FPermType <> ").append(30).append(" ").append(" UNION ").append(" SELECT RolePerm.FPermType AS FPermType,UserRoleOrg.FOrgID AS FOrgID FROM T_PM_RolePerm RolePerm ").append(" INNER JOIN  T_PM_UserRoleOrg UserRoleOrg ON UserRoleOrg.FRoleID = RolePerm.FRoleID ").append(" INNER JOIN T_PM_PermItem PermItem ON PermItem.FID = RolePerm.FPermItemID ").append(" WHERE UserRoleOrg.FUserID =?");
        sql.append(" AND ((RolePerm.FPermItemID = ? ").append(" AND PermItem.FOrgRelation = ?) ").append(" OR (RolePerm.FPermItemID = ? ").append(" AND PermItem.FOrgRelation = ?)) ").append(" AND UserRoleOrg.FOrgID in (").append(companyIds).append(")");
        IRowSet rowSet = null;
        rowSet = DbUtil.executeQuery((Context)this.context, (String)sql.toString(), (Object[])params);
        try {
            int i;
            int permType;
            if (rowSet == null) {
                return;
            }
            while (rowSet.next()) {
                permType = rowSet.getInt("FPermType");
                if (permType != 10) continue;
                for (i = 0; i < list.size(); ++i) {
                    KPGetSql ksql = (KPGetSql)list.get(i);
                    if (!ksql.companyId.equalsIgnoreCase(rowSet.getString("FOrgID"))) continue;
                    ksql.isFormulaValid = true;
                    this.putToFormulasMap(ksql, null);
                }
            }
            rowSet.beforeFirst();
            while (rowSet.next()) {
                permType = rowSet.getInt("FPermType");
                if (permType != 20) continue;
                for (i = 0; i < list.size(); ++i) {
                    if (!((KPGetSql)list.get((int)i)).companyId.equalsIgnoreCase(rowSet.getString("FOrgID"))) continue;
                    ((KPGetSql)list.get(i)).setFormulaUnvalid((Exception)((Object)noRightException));
                }
            }
        }
        catch (SQLException e) {
            throw new PermissionException(PermissionException.CHECK_PERMISSION_FAIL, (Throwable)e);
        }
    }

    private int validFormulaCount(Set kPGetSqlFormulas) {
        int i = 0;
        if (kPGetSqlFormulas != null) {
            Iterator it = kPGetSqlFormulas.iterator();
            while (it.hasNext()) {
                if (!((KPGetSql)it.next()).isFormulaValid) continue;
                ++i;
            }
        }
        return i;
    }

    class KPGetSql {
        String sql;
        String valueType;
        int sqlValueType;
        int paramType;
        String columnName;
        int returnColumnIndex = -1;
        String companyNumber;
        String companyId = "";
        String[] params;
        List procParams;
        int procParamsCompIndex = -1;
        FormulaValueBackfill formulaValue;
        boolean isProcedure = false;
        boolean isFormulaValid = true;
        String dbCenterNumber;
        boolean isBatchQuery = false;
        List<String> batchParams = new ArrayList<String>();
        String batchSql = null;
        List<String> batchFields = new ArrayList<String>();
        List<Integer> paramTypes = new ArrayList<Integer>();

        public KPGetSql(Parameter param) {
            Object[] params = param.getArgs();
            if (params.length == 4) {
                this.initSql((String)((Variant)params[0]).getValue(), (String)((Variant)params[1]).getValue(), (String)((Variant)params[2]).getValue(), (String)((Variant)params[3]).getValue());
            } else {
                String dbCenterNumber = (String)((Variant)params[4]).getValue();
                if (StringUtils.isEmpty((String)dbCenterNumber)) {
                    this.initSql((String)((Variant)params[0]).getValue(), (String)((Variant)params[1]).getValue(), (String)((Variant)params[2]).getValue(), (String)((Variant)params[3]).getValue());
                } else {
                    this.initSql((String)((Variant)params[0]).getValue(), (String)((Variant)params[1]).getValue(), (String)((Variant)params[2]).getValue(), (String)((Variant)params[3]).getValue(), (String)((Variant)params[4]).getValue());
                }
            }
            this.formulaValue = new FormulaValueBackfill(param);
            this.formulaValue.setValue((Object)"");
        }

        private void initSql(String sql, String valueType, String colName, String companyNumber, String dbCenterNumber) {
            this.dbCenterNumber = dbCenterNumber;
            this.initSql(sql, valueType, colName, companyNumber);
        }

        private void initSql(String sql, String valueType, String colName, String companyNumber) {
            this.sql = sql;
            this.valueType = valueType;
            this.columnName = colName;
            this.companyNumber = companyNumber;
            if (StringUtils.isEmpty((String)this.sql)) {
                this.setFormulaUnvalid((Exception)((Object)new ReportException(ReportException.FORMULA_IS_NULL)));
            }
            if (!"PostgresSQL".equals(ContextUtil.getDbType((Context)KPGetSqlBatchCalculator.this.context)) && StringUtils.isEmpty((String)this.columnName)) {
                this.setFormulaUnvalid((Exception)((Object)new ReportException(ReportException.PARAM_IS_NOT_INTEGRATED)));
            }
            this.sqlValueType = this.getSqlType(this.valueType);
            this.paramType = 3;
            this.sql = this.sql.trim();
            String lowerSql = this.sql.toLowerCase(Locale.ENGLISH);
            if (lowerSql.startsWith("call")) {
                this.isProcedure = true;
            } else if (lowerSql.startsWith("select")) {
                int batchIndex = this.sql.indexOf(KPGetSqlBatchCalculator.this.batchStr);
                if (StringUtils.isEmpty((String)this.dbCenterNumber) && batchIndex > 0 && this.handleBatchSql(batchIndex, false)) {
                    batchIndex = this.batchSql.indexOf(KPGetSqlBatchCalculator.this.batchStr);
                    while (batchIndex > 0) {
                        this.handleBatchSql(batchIndex, false);
                        batchIndex = this.batchSql.indexOf(KPGetSqlBatchCalculator.this.batchStr);
                    }
                    this.isBatchQuery = true;
                } else {
                    this.sql = "select top 1 " + this.columnName + " from (" + this.sql + ") t";
                }
            } else if (lowerSql.startsWith("/*dialect*/")) {
                int batchIndex = this.sql.indexOf(KPGetSqlBatchCalculator.this.batchStr);
                if (batchIndex > 0) {
                    batchIndex = this.sql.indexOf(KPGetSqlBatchCalculator.this.batchStr);
                    if (StringUtils.isEmpty((String)this.dbCenterNumber) && batchIndex > 0 && this.handleBatchSql(batchIndex, true)) {
                        batchIndex = this.batchSql.indexOf(KPGetSqlBatchCalculator.this.batchStr);
                        while (batchIndex > 0) {
                            this.handleBatchSql(batchIndex, true);
                            batchIndex = this.batchSql.indexOf(KPGetSqlBatchCalculator.this.batchStr);
                        }
                        this.isBatchQuery = true;
                    }
                }
            } else {
                this.setFormulaUnvalid((Exception)((Object)new ReportException(ReportException.ONLYQUERY)));
            }
            if (StringUtils.isEmpty((String)this.companyNumber)) {
                this.companyNumber = KPGetSqlBatchCalculator.this.getCompanyNumber();
            }
            this.replaceParams();
            this.buildProcedure();
            this.sqlValueType = this.getSqlType(this.valueType);
        }

        private boolean handleBatchSql(int batchStrIndex, boolean isIncludeDialect) {
            String curSqlStr;
            int optIndex = -1;
            String dialect = "/*dialect*/";
            String string = curSqlStr = this.batchSql == null ? this.sql : this.batchSql;
            if (isIncludeDialect) {
                curSqlStr = curSqlStr.substring(curSqlStr.indexOf(dialect) + dialect.length());
                batchStrIndex -= dialect.length();
            }
            StringBuffer field = new StringBuffer();
            String curbatchField = null;
            for (int i = batchStrIndex - 1; i >= 0; --i) {
                char curChar = curSqlStr.charAt(i);
                if (curChar == '=') {
                    optIndex = i;
                    continue;
                }
                if (curChar != ' ') {
                    if (optIndex <= 0) continue;
                    field.insert(0, curChar);
                    continue;
                }
                if (curChar != ' ' || field.length() <= 0) continue;
                curbatchField = field.toString();
                this.batchFields.add(curbatchField);
                field.setLength(0);
                break;
            }
            if (optIndex < 0 || curbatchField == null) {
                return false;
            }
            String curBatchParam = null;
            int paramEndIndex = -1;
            StringBuffer param = new StringBuffer();
            Stack<String> spStr = new Stack<String>();
            for (int i = batchStrIndex + KPGetSqlBatchCalculator.this.batchStr.length(); i < curSqlStr.length(); ++i) {
                char curChar = curSqlStr.charAt(i);
                if (!(curChar != '\'' || param.length() != 0 && spStr.isEmpty())) {
                    if (spStr.isEmpty()) {
                        spStr.push("'");
                        this.paramType = 12;
                    } else {
                        spStr.pop();
                    }
                    if (!spStr.isEmpty()) continue;
                    paramEndIndex = i + 1;
                    curBatchParam = param.toString();
                    this.batchParams.add(curBatchParam);
                    param.setLength(0);
                    break;
                }
                if (spStr.isEmpty() && (curChar == ' ' || i + 1 == curSqlStr.length())) {
                    if (param.length() <= 0) continue;
                    if (curChar != ' ') {
                        param.append(curChar);
                    } else {
                        paramEndIndex = i;
                    }
                    curBatchParam = param.toString();
                    this.batchParams.add(curBatchParam);
                    param.setLength(0);
                    break;
                }
                param.append(curChar);
            }
            if (curBatchParam == null) {
                this.batchFields.remove(this.batchFields.size() - 1);
                return false;
            }
            this.paramTypes.add(this.paramType);
            StringBuffer curSql = new StringBuffer();
            String lowerSql = curSqlStr.toLowerCase();
            int fromIndex = lowerSql.indexOf("from");
            curSql.append(curSqlStr.substring(0, fromIndex)).append(",").append(curbatchField).append(" batchFieldKey").append(this.batchParams.size() - 1).append(" ");
            boolean isAddGroup = false;
            if (curSql.indexOf("sum(") > 0 || curSql.indexOf("count(") > 0 || curSql.indexOf("avg(") > 0) {
                isAddGroup = true;
            }
            curSql.append(curSqlStr.subSequence(fromIndex, optIndex)).append(" in(").append(KPGetSqlBatchCalculator.this.inBatchStr).append(")");
            if (paramEndIndex > 0) {
                curSql.append(curSqlStr.substring(paramEndIndex));
            }
            if (isAddGroup) {
                int groupIndex = curSql.lastIndexOf("group by");
                if (groupIndex > 0 && curSql.indexOf(")", groupIndex) < 0) {
                    curSql.append(" , ").append(curbatchField);
                } else {
                    curSql.append(" group by ").append(curbatchField);
                }
            }
            this.batchSql = curSql.toString();
            if (isIncludeDialect) {
                this.batchSql = "/*dialect*/" + this.batchSql;
            }
            curSql.setLength(0);
            return true;
        }

        private void buildProcedure() {
            if (this.isProcedure) {
                this.procParams = new ArrayList();
                this.handleProcedureParams();
                try {
                    if (!"PostgresSQL".equals(ContextUtil.getDbType((Context)KPGetSqlBatchCalculator.this.context)) && this.returnColumnIndex == -1) {
                        this.setFormulaUnvalid((Exception)((Object)new ReportException(ReportException.PARAM_IS_NOT_INTEGRATED)));
                    }
                }
                catch (Exception e) {
                    log.debug((Object)e.getMessage());
                    this.setFormulaUnvalid((Exception)((Object)new ReportException(ReportException.PARAM_IS_NOT_INTEGRATED)));
                }
            }
        }

        private void handleProcedureParams() {
            int rightSign;
            if (StringUtils.isEmpty((String)this.sql)) {
                return;
            }
            int leftSign = this.sql.indexOf(40);
            String paramStr = this.sql.substring(leftSign + 1, rightSign = this.sql.indexOf(41));
            String[] splitArr = paramStr.split(",");
            if (splitArr == null) {
                return;
            }
            int len = splitArr.length;
            for (int i = 0; i < len; ++i) {
                String tmpStr = splitArr[i].trim();
                if (tmpStr.equals("@year") || tmpStr.equals("#year")) {
                    this.procParams.add(new Integer(KPGetSqlBatchCalculator.this.getReport_Year()));
                } else if (tmpStr.equals("@period") || tmpStr.equals("#period")) {
                    this.procParams.add(new Integer(KPGetSqlBatchCalculator.this.getReport_Period()));
                } else if (tmpStr.equals("@periodType") || tmpStr.equals("#periodType")) {
                    this.procParams.add(new Integer(KPGetSqlBatchCalculator.this.getReport_PeriodType()));
                } else if (tmpStr.equals("@currency") || tmpStr.equals("#currency")) {
                    this.procParams.add(KPGetSqlBatchCalculator.this.getCorrect_Currency_Number());
                } else if (tmpStr.equals("@company") || tmpStr.equals("#company")) {
                    this.procParams.add("companyId");
                    this.procParamsCompIndex = i;
                } else if (tmpStr.equals(this.columnName)) {
                    this.returnColumnIndex = i + 1;
                    this.procParams.add("NONE");
                } else if (tmpStr.startsWith("'") && tmpStr.endsWith("'")) {
                    this.procParams.add(tmpStr.replaceAll("'", ""));
                } else {
                    this.procParams.add(new Integer(tmpStr));
                }
                this.sql = StringUtil.replaceFirst((String)this.sql, (String)splitArr[i], (String)"?");
            }
        }

        private void replaceCompanyIDInProcParams(String companyID) {
            if (this.procParamsCompIndex != -1) {
                this.procParams.set(this.procParamsCompIndex, companyID);
            }
        }

        public String getBatchParamsKey() {
            StringBuffer str = new StringBuffer();
            for (String param : this.batchParams) {
                str.append(param).append(";");
            }
            if (str.length() > 0) {
                str.deleteCharAt(str.lastIndexOf(";"));
            }
            return str.toString();
        }

        private void replaceParams() {
            if (this.sql == null || this.isProcedure) {
                return;
            }
            this.sql = this.sql.replaceAll("@year", String.valueOf(KPGetSqlBatchCalculator.this.getReport_Year()));
            this.sql = this.sql.replaceAll("#year", String.valueOf(KPGetSqlBatchCalculator.this.getReport_Year()));
            this.sql = this.sql.replaceAll("@period(\\W)", KPGetSqlBatchCalculator.this.getReport_Period() + "$1");
            this.sql = this.sql.replaceAll("#period(\\W)", KPGetSqlBatchCalculator.this.getReport_Period() + "$1");
            this.sql = this.sql.replaceAll("@periodType", String.valueOf(KPGetSqlBatchCalculator.this.getReport_PeriodType()));
            this.sql = this.sql.replaceAll("#periodType", String.valueOf(KPGetSqlBatchCalculator.this.getReport_PeriodType()));
            this.sql = this.sql.replaceAll("@currency", "'" + KPGetSqlBatchCalculator.this.getCorrect_Currency_Number() + "'");
            this.sql = this.sql.replaceAll("#currency", "'" + KPGetSqlBatchCalculator.this.getCorrect_Currency_Number() + "'");
        }

        private int getSqlType(String typeName) {
            int type = 3;
            try {
                type = ValueTypeEnum.getEnum(typeName.toUpperCase()).getValue();
            }
            catch (Exception e) {
                return type;
            }
            return type;
        }

        private int getReturnColumnIndex() {
            return 1;
        }

        public void setFormulaUnvalid(Exception e) {
            KPGetSqlBatchCalculator.this.putToFormulasMap(this, "#BAD FUNCTION :" + (e == null ? "" : e.getMessage()));
            this.isFormulaValid = false;
        }
    }
}

