/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.FormulaAdapter;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLPermissionUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fi.rpt.batch.CalculatorCombiner;
import com.kingdee.eas.fi.rpt.batch.ChecFmlParamPermissionUtil;
import com.kingdee.eas.fi.rpt.batch.FormulaValueBackfill;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.IFormulaCombinationPreparedState;
import com.kingdee.eas.fi.rpt.batch.SQLStringWrapper;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.PropertyContainer;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RefDMCalcuter {
    private static Logger logger = Logger.getLogger(RefDMCalcuter.class);
    private ICalculateContextProvider calCulateContext;
    private Context serverContext;
    private BatchHelper batchHelper;
    private List refDMList;
    private List beforeAndAfterAdjustRefDMList;
    private List adjustingRefDMList;
    private Set orgTreeNumberSet;
    private List refDMAllList;
    private static int batchSize = 2000;
    private static int variableSize = 180;
    public boolean isMergeByFiscalPeriod = false;
    public boolean isSupport13Period = false;
    public PeriodCollection periods = null;
    private boolean isParamadjustSeparate;

    public RefDMCalcuter(ICalculateContextProvider context, Context serverCtx) {
        this.calCulateContext = context;
        this.serverContext = serverCtx;
        this.batchHelper = new BatchHelper(context, serverCtx);
        this.refDMList = new ArrayList();
        boolean[] values = CSLParamUtil.batchGetParam((Context)this.serverContext, (String[])new String[]{"GR_CSL_Support13Period", "GR_CSL_MergeByFiscalPeriod", "GR_CSL_AdjustSeparate"});
        this.isSupport13Period = values[0];
        this.isMergeByFiscalPeriod = values[1];
        this.isParamadjustSeparate = values[2];
    }

    public void execute(SortedParameterArray params) {
        try {
            if (this.isMergeByFiscalPeriod) {
                this.periods = FiscalPeriodHelper.initFormualFiscalPeriods((Context)this.serverContext, (ICalculateContextProvider)this.calCulateContext);
            }
            this.initBatchSize();
            this.initParameterList(params);
            this.preCalculate();
            int size = this.refDMAllList.size();
            int count = 0;
            count = size <= batchSize ? 1 : (size % batchSize == 0 ? size / batchSize : size / batchSize + 1);
            for (int batch = 1; batch <= count; ++batch) {
                this.init(batch);
                this.calculate();
                this.handleAllException();
            }
        }
        catch (Exception e) {
            for (RefDM refdm : this.refDMAllList) {
                FormulaValueBackfill err = new FormulaValueBackfill(refdm.param);
                err.setException((Throwable)e);
            }
        }
    }

    private void handleAllException() {
        for (RefDM refDM : this.refDMList) {
            if (refDM.isException) {
                FormulaValueBackfill err = new FormulaValueBackfill(refDM.param);
                err.setException((Throwable)refDM.e);
                continue;
            }
            if (refDM.param.getValue() != null) continue;
            refDM.param.setValue((Object)CslConstant.BGZERO);
        }
    }

    private void preCalculate() throws EASBizException, BOSException {
        boolean needCheck = CSLParamUtil.isReportCheck((Context)this.serverContext);
        boolean tableInnerCheck = new Boolean(this.calCulateContext.getReportVariables().getStringValue("tableInnerCheck", null));
        if (needCheck || !tableInnerCheck) {
            return;
        }
        for (RefDM refdm : this.refDMAllList) {
            Boolean isAdjust = null;
            isAdjust = RptUtil.isTrue(refdm.isAdjusted) ? new Boolean(true) : new Boolean(false);
            String orgNumber = this.makeValidOrgcode(refdm.companyNumber);
            IObjectCollection collection = CslRptUtil.getReportCollection((Context)this.serverContext, (String)orgNumber, (int)refdm.year, (int)refdm.period, (String)refdm.currencyNumber, (String)refdm.srcCurrencyNumber, (String)refdm.templateNumber, (String)refdm.templateType, (Boolean)isAdjust, (String)refdm.dataCollectNumber);
            if (null != collection && 0 != collection.size()) continue;
            refdm.setException((Exception)((Object)new BOSException("REPORT IS NULL")));
        }
    }

    private String makeValidOrgcode(String orgCode) throws EASBizException, BOSException {
        if (orgCode == null || orgCode.length() < 1) {
            int type = this.batchHelper.getReport_SourceType();
            if (type == 2 || type == 3 || type == 11 || type == 12) {
                orgCode = this.batchHelper.getOrgUnit_Number();
                if (StringUtils.isEmpty((String)orgCode)) {
                    orgCode = this.batchHelper.getCompany_Number();
                }
            } else {
                orgCode = this.batchHelper.getCompany_Number();
                if (StringUtils.isEmpty((String)orgCode)) {
                    orgCode = this.batchHelper.getCompany_Number();
                }
            }
        }
        return orgCode;
    }

    private void calculate() {
        List needNextCalcList = this.calculateBeforeAndAfterAdjust();
        Map prepareRefDMForAdjusting = this.prepareRefDMForAdjusting(this.adjustingRefDMList);
        Map needNextCalcMap = this.prepareRefDMForAdjusting(needNextCalcList);
        this.adjustingRefDMList.addAll(needNextCalcList);
        this.calculateAdjusting(prepareRefDMForAdjusting, needNextCalcMap);
    }

    private void calculateAdjusting(Map prepareRefDMForAdjusting, Map needNextCalcMap) {
        this.verifyAdjustingRefDMList();
        if (this.adjustingRefDMList.size() == 0) {
            return;
        }
        StringBuffer kqlBuffer = new StringBuffer();
        kqlBuffer.append("Select Sum(ItemDataEntry.FValue) AS Value \n").append(", ItemDataEntry.FTextValue AS TextValue \t\t\t\n").append(",ItemData.FDataSource AS TemplateType\t\t\t\t\n").append(",BaseUnit.FNumber AS CompanyNumber\t\t\t\t\t\n").append(",Currency.FNumber AS Currency\t\t\t\t\t\t\n").append(",SrcCurrency.FNumber AS SourceCurrency\t\t\t\t\n").append(",ItemDataEntry.FItemID AS ItemNumber\t\t\t\t\n").append(",ItemDataEntry.FKeyNumber AS DyItemNumber\t\t\t\n").append(",ItemDataEntry.FYear AS EntryYear\t\t\t\t\t\n").append(",ItemDataEntry.FPeriod AS Period\t\t\t\t\t\n").append(",ItemDataEntry.FDataElement AS FetchType\t\t\t\n").append(",ItemDataEntry.FValueType AS ValueType\t\t\t\t\n").append("From T_CSL_DynaItemData ItemData \n").append("inner join T_CSL_DynaItemDataEntry ItemDataEntry on ItemData.FID=ItemDataEntry.FItemDataID \n").append("inner join T_Org_BaseUnit BaseUnit on ItemData.FOrgUnitID=BaseUnit.FID \n").append("inner join T_BD_Currency Currency on ItemData.FCurrencyID=Currency.FID \n").append("inner join T_BD_Currency SrcCurrency on ItemData.FSourceCurrencyId=SrcCurrency.FID \n");
        kqlBuffer.append(" Left join T_CSL_RptReceived Received on Received.FReportID =ItemData.FReportID \n");
        kqlBuffer.append("Where ItemData.FDataType = 1 and\t(    \n");
        StringBuffer groupByBuffer = new StringBuffer();
        groupByBuffer.append(") \n group by ItemDataEntry.FTextValue,ItemData.FDataSource").append(",BaseUnit.FNumber,Currency.FNumber,").append("SrcCurrency.FNumber,ItemDataEntry.FItemID,").append("ItemDataEntry.FKeyNumber,ItemDataEntry.FYear,ItemDataEntry.FPeriod,").append("ItemDataEntry.FDataElement,ItemDataEntry.FValueType \n");
        HashSet<String> allowedNullKeysSet = new HashSet<String>();
        allowedNullKeysSet.add("SourceCurrency");
        allowedNullKeysSet.add("DyItemNumber");
        allowedNullKeysSet.add("TemplateType");
        CalculatorCombiner combiner = new CalculatorCombiner(prepareRefDMForAdjusting, allowedNullKeysSet);
        PrepareState combineState = new PrepareState();
        combiner.setPrepareState(combineState);
        CalculatorCombiner needLastCombiner = null;
        if (needNextCalcMap.size() > 0) {
            needLastCombiner = new CalculatorCombiner(needNextCalcMap, allowedNullKeysSet);
            needLastCombiner.setPrepareState(combineState);
        }
        PropertyContainer property = new PropertyContainer(11);
        ArrayList<Object> params = new ArrayList<Object>();
        boolean addOr = false;
        StringBuffer kqlWhere = new StringBuffer();
        Iterator iterator = this.adjustingRefDMList.iterator();
        while (iterator.hasNext()) {
            if (addOr) {
                kqlWhere.append("OR    \n");
            } else {
                addOr = true;
            }
            RefDM refDM = (RefDM)iterator.next();
            kqlWhere.append(" ( BaseUnit.FNumber = ? \n");
            params.add(refDM.companyNumber);
            if (!StringUtils.isEmpty((String)refDM.templateType)) {
                kqlWhere.append("and ItemData.FDataSource = ? \n");
                params.add(new Integer(RptTmpTypeEnum.getEnum(refDM.templateType).getValue()));
            }
            kqlWhere.append(" and Currency.FNumber = ? \n");
            params.add(refDM.currencyNumber);
            if (!StringUtils.isEmpty((String)refDM.srcCurrencyNumber)) {
                kqlWhere.append(" and SrcCurrency.FNumber = ? \n");
                params.add(refDM.srcCurrencyNumber);
            }
            kqlWhere.append(" and ItemDataEntry.FItemID = ? \n");
            params.add(refDM.itemNumber);
            if (!StringUtils.isEmpty((String)refDM.dyItemNumber)) {
                kqlWhere.append(" and ItemDataEntry.FKeyNumber = ? \n");
                params.add(refDM.dyItemNumber);
            }
            kqlWhere.append("and ItemDataEntry.FYear = ? \n");
            params.add(new Integer(refDM.year));
            kqlWhere.append("and ItemDataEntry.FPeriod = ? \n");
            params.add(new Integer(refDM.period));
            kqlWhere.append("and ItemDataEntry.FDataElement = ? \n");
            params.add(new Integer(refDM.int_fetchType));
            kqlWhere.append("and ItemDataEntry.FValueType = ?  )\n");
            params.add(new Integer(refDM.int_valueType));
            if (!StringUtils.isEmpty((String)refDM.orgBoundId)) {
                kqlWhere.append(" and Received.FOrgTreeID='").append(refDM.orgBoundId).append("'\r\n");
            }
            if (params.size() <= variableSize && iterator.hasNext()) continue;
            try {
                StringBuffer executeKqlBuffer = new StringBuffer();
                executeKqlBuffer.append(kqlBuffer).append(kqlWhere).append(groupByBuffer);
                IRowSet row = DbUtil.executeQuery((Context)this.serverContext, (String)executeKqlBuffer.toString(), (Object[])params.toArray());
                while (row.next()) {
                    property.put("TemplateType", (Object)new Integer(row.getInt("TemplateType")));
                    property.put("CompanyNumber", (Object)row.getString("CompanyNumber"));
                    property.put("Currency", (Object)row.getString("Currency"));
                    property.put("SourceCurrency", (Object)row.getString("SourceCurrency"));
                    property.put("ItemNumber", (Object)row.getString("ItemNumber"));
                    property.put("DyItemNumber", (Object)row.getString("DyItemNumber"));
                    property.put("EntryYear", (Object)new Integer(row.getInt("EntryYear")));
                    property.put("Period", (Object)new Integer(row.getInt("Period")));
                    property.put("FetchType", (Object)new Integer(row.getInt("FetchType")));
                    property.put("ValueType", (Object)new Integer(row.getInt("ValueType")));
                    BigDecimal value = row.getBigDecimal("Value");
                    if (value == null) {
                        value = CslConstant.BGZERO;
                    }
                    String textValue = row.getString("TextValue");
                    BigDecimal numberValue = value;
                    combineState.setNumberValue(numberValue);
                    combineState.setTextValue(textValue);
                    combiner.combineValue(property);
                    if (needLastCombiner == null) continue;
                    needLastCombiner.combineValue(property);
                }
            }
            catch (BOSException e) {
                this.handleException(this.adjustingRefDMList, (Exception)((Object)e));
            }
            catch (SQLException e) {
                this.handleException(this.adjustingRefDMList, e);
            }
            kqlWhere = kqlWhere.delete(0, kqlWhere.length());
            params.clear();
            addOr = false;
        }
    }

    private Map prepareRefDMForAdjusting(List adjustingRefDMList2) {
        HashMap<PropertyContainer, Object> result = new HashMap<PropertyContainer, Object>();
        for (RefDM refDM : adjustingRefDMList2) {
            PropertyContainer property = new PropertyContainer(11);
            property.put("TemplateType", (Object)new Integer(RptTmpTypeEnum.getEnum(refDM.templateType).getValue()));
            property.put("CompanyNumber", (Object)refDM.companyNumber);
            property.put("Currency", (Object)refDM.currencyNumber);
            property.put("SourceCurrency", (Object)refDM.srcCurrencyNumber);
            property.put("ItemNumber", (Object)refDM.itemNumber);
            property.put("DyItemNumber", (Object)refDM.dyItemNumber);
            property.put("EntryYear", (Object)new Integer(refDM.year));
            property.put("Period", (Object)new Integer(refDM.period));
            property.put("FetchType", (Object)new Integer(refDM.int_fetchType));
            property.put("ValueType", (Object)new Integer(refDM.int_valueType));
            if (result.get(property) != null) {
                Object oldDyItem = result.get(property);
                if (oldDyItem instanceof List) {
                    ((List)oldDyItem).add(refDM);
                    continue;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(oldDyItem);
                list.add(refDM);
                result.put(property, list);
                continue;
            }
            result.put(property, refDM);
        }
        return result;
    }

    private void verifyAdjustingRefDMList() {
        ArrayList<RefDM> removeList = new ArrayList<RefDM>();
        HashSet<RptTmpTypeEnum> validRptTmpTypeEnumSet = new HashSet<RptTmpTypeEnum>();
        validRptTmpTypeEnumSet.add(RptTmpTypeEnum.DYNAMICNORMALREPORT);
        validRptTmpTypeEnumSet.add(RptTmpTypeEnum.DYNAMICSUMREPORT);
        validRptTmpTypeEnumSet.add(RptTmpTypeEnum.DYNAMICCSLREPORT);
        validRptTmpTypeEnumSet.add(RptTmpTypeEnum.DIFFTABLE);
        for (RefDM refDM : this.adjustingRefDMList) {
            if (refDM.templateType == null || validRptTmpTypeEnumSet.contains((Object)RptTmpTypeEnum.getEnum(refDM.templateType))) continue;
            refDM.setException((Exception)((Object)new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"68_RefDMCalcuter", (Locale)this.serverContext.getLocale()))));
            removeList.add(refDM);
        }
        this.adjustingRefDMList.removeAll(removeList);
    }

    private List calculateBeforeAndAfterAdjust() {
        if (this.beforeAndAfterAdjustRefDMList.size() == 0) {
            return new ArrayList(0);
        }
        ArrayList<RefDM> needTemplateTypeList = new ArrayList<RefDM>();
        ArrayList<RefDM> notNeedTemplateTypeList = new ArrayList<RefDM>();
        for (RefDM refDM : this.beforeAndAfterAdjustRefDMList) {
            if (refDM.isException) continue;
            RptTmpTypeEnum type = null;
            try {
                type = RptTmpTypeEnum.getEnum(refDM.templateType);
            }
            catch (RuntimeException e) {
                e.getStackTrace();
            }
            if (type != null && (type == RptTmpTypeEnum.DYNAMICNORMALREPORT || type == RptTmpTypeEnum.RPTDYNAMICREPORT)) {
                notNeedTemplateTypeList.add(refDM);
                continue;
            }
            needTemplateTypeList.add(refDM);
        }
        ArrayList notNeedTemplateTypeListAfterCalFirst = new ArrayList();
        notNeedTemplateTypeListAfterCalFirst.addAll(this.calculateBeforeAndAfterNeedTempType(needTemplateTypeList));
        notNeedTemplateTypeListAfterCalFirst.addAll(this.calculateBeforeAndAfterWithoutTempType(notNeedTemplateTypeList));
        return notNeedTemplateTypeListAfterCalFirst;
    }

    private Set calculateBeforeAndAfterNeedTempType(List needTemplateTypeList) {
        Iterator iterator1;
        String textValue;
        BigDecimal numberValue;
        BigDecimal value;
        int dataType;
        IRowSet row;
        StringBuffer executeKqlBuffer;
        RefDM refDM2;
        HashSet notNeedTemplateNumberList = new HashSet();
        if (needTemplateTypeList.size() == 0) {
            return notNeedTemplateNumberList;
        }
        StringBuffer kqlBuffer = new StringBuffer();
        kqlBuffer.append("Select Sum(ItemDataEntry.FValue) AS Value \n").append(", ItemDataEntry.FTextValue AS TextValue \t\t\t\n").append(", ItemData.FDataType AS DataType \t\t\t\t\t\n").append(",Template.FNumber AS TemplateNumber\t\t\t\t\n").append(",Template.FTemplateType AS TemplateType\t\t\t\n").append(",BaseUnit.FNumber AS CompanyNumber\t\t\t\t\t\n").append(",Currency.FNumber AS Currency\t\t\t\t\t\t\n").append(",SrcCurrency.FNumber AS SourceCurrency\t\t\t\t\n").append(",ItemDataEntry.FItemID AS ItemNumber\t\t\t\t\n").append(",ItemDataEntry.FKeyNumber AS DyItemNumber\t\t\t\n").append(",ItemDataEntry.FYear AS EntryYear\t\t\t\t\t\n").append(",ItemDataEntry.FPeriod AS Period\t\t\t\t\t\n").append(",ItemDataEntry.FDataElement AS FetchType\t\t\t\n").append(",ItemDataEntry.FValueType AS ValueType\t\t\t\t\n").append(",ItemData.FDataCollectNumber AS DataCollectNumber\t\n").append(",Received.FOrgTreeID AS OrgTreeID\t\t\t\t    \n").append("From T_CSL_DynaItemData ItemData                   \n").append("inner join T_CSL_DynaItemDataEntry ItemDataEntry on ItemData.FID=ItemDataEntry.FItemDataID \n").append("inner join T_Org_BaseUnit BaseUnit on ItemData.FOrgUnitID=BaseUnit.FID                     \n").append("inner join T_BD_Currency Currency on ItemData.FCurrencyID=Currency.FID                     \n").append("inner join T_BD_Currency SrcCurrency on ItemData.FSourceCurrencyId=SrcCurrency.FID         \n").append("inner join T_CSL_CSLReport Report on Report.FID = ItemData.FReportID                       \n").append("inner join T_RPT_Template Template on Template.FID = Report.FTemplateID                    \n").append("Left join T_CSL_RptReceived Received on Received.FReportID = Report.FID                    \n");
        StringBuffer groupByBuffer = new StringBuffer();
        groupByBuffer.append(" ) group by ItemData.FDataType,ItemDataEntry.FTextValue,Template.FNumber").append(",Template.FTemplateType,BaseUnit.FNumber,Currency.FNumber,").append("SrcCurrency.FNumber,ItemDataEntry.FItemID,").append("ItemDataEntry.FKeyNumber,ItemDataEntry.FYear,ItemDataEntry.FPeriod,").append("ItemDataEntry.FDataElement,ItemDataEntry.FValueType,ItemData.FDataCollectNumber,Received.FOrgTreeID \n");
        Map refDMMap = this.prepareRefDMForBeforeAndAfterNeedTempType(needTemplateTypeList);
        HashSet<String> allowedNullKeysSet = new HashSet<String>();
        allowedNullKeysSet.add("SourceCurrency");
        allowedNullKeysSet.add("DyItemNumber");
        allowedNullKeysSet.add("TemplateType");
        CalculatorCombiner combiner = new CalculatorCombiner(refDMMap, allowedNullKeysSet);
        BeforeAdjustCombineState combineState = new BeforeAdjustCombineState();
        combiner.setPrepareState(combineState);
        PropertyContainer property = new PropertyContainer(14);
        Set isAdjustedSet = this.createIsAdjustedSet(needTemplateTypeList.iterator());
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereKqlBuffer = new StringBuffer();
        if (this.isAllSameExcludeItem(needTemplateTypeList)) {
            boolean isFirst = true;
            kqlBuffer.append("Where \n");
            StringBuffer inSql = new StringBuffer();
            refDM2 = null;
            for (RefDM refDM2 : needTemplateTypeList) {
                if (refDM2 == null) continue;
                if (isFirst) {
                    whereKqlBuffer.append("( Template.FNumber = ? \n");
                    params.add(refDM2.templateNumber);
                    if (!StringUtils.isEmpty((String)refDM2.templateType)) {
                        whereKqlBuffer.append(" and Template.FTemplateType = ? ");
                        params.add(new Integer(RptTmpTypeEnum.getEnum(refDM2.templateType).getValue()));
                    }
                    if (!StringUtils.isEmpty((String)refDM2.orgBoundId) && this.isParamadjustSeparate) {
                        whereKqlBuffer.append(" and( Received.FOrgTreeID= ? and Received.FID IS NOT NULL )\n");
                        params.add(refDM2.orgBoundId);
                    }
                    whereKqlBuffer.append(" and BaseUnit.FNumber = ? \n");
                    params.add(refDM2.companyNumber);
                    whereKqlBuffer.append(" and Currency.FNumber = ? \n");
                    params.add(refDM2.currencyNumber);
                    if (!StringUtils.isEmpty((String)refDM2.srcCurrencyNumber)) {
                        whereKqlBuffer.append(" and SrcCurrency.FNumber = ? \n");
                        params.add(refDM2.srcCurrencyNumber);
                    }
                    if (!StringUtils.isEmpty((String)refDM2.dyItemNumber)) {
                        whereKqlBuffer.append(" and ItemDataEntry.FKeyNumber = ? \n");
                        params.add(refDM2.dyItemNumber);
                    }
                    whereKqlBuffer.append("and ItemDataEntry.FYear = ? \n");
                    params.add(new Integer(refDM2.year));
                    whereKqlBuffer.append("and ItemDataEntry.FPeriod = ? \n");
                    params.add(new Integer(refDM2.period));
                    whereKqlBuffer.append("and ItemDataEntry.FDataElement = ? \n");
                    params.add(new Integer(refDM2.int_fetchType));
                    whereKqlBuffer.append("and ItemDataEntry.FValueType = ?   \n");
                    params.add(new Integer(refDM2.int_valueType));
                    whereKqlBuffer.append("and ItemData.FDataCollectNumber = ?  ) \n");
                    whereKqlBuffer.append("and ItemData.FDYNATYPE=1 \n");
                    params.add(refDM2.dataCollectNumber);
                    inSql.append("'").append(refDM2.itemNumber).append("'");
                } else {
                    inSql.append(",'").append(refDM2.itemNumber).append("'");
                }
                isFirst = false;
            }
            whereKqlBuffer.append(" and ItemDataEntry.FItemID in (").append(inSql).append("");
            executeKqlBuffer = new StringBuffer();
            executeKqlBuffer.append(kqlBuffer).append(whereKqlBuffer).append(groupByBuffer);
            try {
                row = DbUtil.executeQuery((Context)this.serverContext, (String)executeKqlBuffer.toString(), (Object[])params.toArray());
                while (row.next()) {
                    property.put("TemplateNumber", (Object)row.getString("TemplateNumber"));
                    property.put("TemplateType", (Object)new Integer(row.getInt("TemplateType")));
                    property.put("CompanyNumber", (Object)row.getString("CompanyNumber"));
                    property.put("Currency", (Object)row.getString("Currency"));
                    property.put("datacollectnumber", (Object)row.getString("DataCollectNumber"));
                    property.put("SourceCurrency", (Object)row.getString("SourceCurrency"));
                    property.put("ItemNumber", (Object)row.getString("ItemNumber"));
                    property.put("DyItemNumber", (Object)row.getString("DyItemNumber"));
                    property.put("EntryYear", (Object)new Integer(row.getInt("EntryYear")));
                    property.put("Period", (Object)new Integer(row.getInt("Period")));
                    property.put("FetchType", (Object)new Integer(row.getInt("FetchType")));
                    property.put("ValueType", (Object)new Integer(row.getInt("ValueType")));
                    if (refDM2 != null && !StringUtils.isEmpty((String)refDM2.orgBoundId)) {
                        property.put("OrgTreeID", (Object)row.getString("OrgTreeID"));
                    }
                    dataType = row.getInt("DataType");
                    value = row.getBigDecimal("Value");
                    if (value == null) {
                        value = CslConstant.BGZERO;
                    }
                    numberValue = value;
                    textValue = row.getString("TextValue");
                    combineState.setNotNeedTemplateNumberList(notNeedTemplateNumberList);
                    combineState.setDataType(dataType);
                    combineState.setNumberValue(numberValue);
                    combineState.setTextValue(textValue);
                    iterator1 = isAdjustedSet.iterator();
                    while (iterator1.hasNext()) {
                        property.put("isAdjusted", iterator1.next());
                        combiner.combineValue(property);
                    }
                }
            }
            catch (BOSException e) {
                this.handleException(needTemplateTypeList, (Exception)((Object)e));
            }
            catch (SQLException e) {
                this.handleException(needTemplateTypeList, e);
            }
            params.clear();
        } else {
            boolean addOr = false;
            kqlBuffer.append("Where (\t\n");
            Iterator iterator = needTemplateTypeList.iterator();
            while (iterator.hasNext()) {
                if (addOr) {
                    whereKqlBuffer.append("OR    \n");
                } else {
                    addOr = true;
                }
                refDM2 = (RefDM)iterator.next();
                whereKqlBuffer.append("( Template.FNumber = ? \n");
                params.add(refDM2.templateNumber);
                if (!StringUtils.isEmpty((String)refDM2.templateType)) {
                    whereKqlBuffer.append(" and Template.FTemplateType = ? ");
                    params.add(new Integer(RptTmpTypeEnum.getEnum(refDM2.templateType).getValue()));
                }
                if (!StringUtils.isEmpty((String)refDM2.orgBoundId)) {
                    whereKqlBuffer.append(" and( Received.FOrgTreeID= ? and Received.FID IS NOT NULL )\n");
                    params.add(refDM2.orgBoundId);
                }
                whereKqlBuffer.append(" and BaseUnit.FNumber = ? \n");
                params.add(refDM2.companyNumber);
                whereKqlBuffer.append(" and Currency.FNumber = ? \n");
                params.add(refDM2.currencyNumber);
                if (!StringUtils.isEmpty((String)refDM2.srcCurrencyNumber)) {
                    whereKqlBuffer.append(" and SrcCurrency.FNumber = ? \n");
                    params.add(refDM2.srcCurrencyNumber);
                }
                whereKqlBuffer.append(" and ItemDataEntry.FItemID = ? \n");
                params.add(refDM2.itemNumber);
                if (!StringUtils.isEmpty((String)refDM2.dyItemNumber)) {
                    whereKqlBuffer.append(" and ItemDataEntry.FKeyNumber = ? \n");
                    params.add(refDM2.dyItemNumber);
                }
                whereKqlBuffer.append("and ItemDataEntry.FYear = ? \n");
                params.add(new Integer(refDM2.year));
                whereKqlBuffer.append("and ItemDataEntry.FPeriod = ? \n");
                params.add(new Integer(refDM2.period));
                whereKqlBuffer.append("and ItemDataEntry.FDataElement = ? \n");
                params.add(new Integer(refDM2.int_fetchType));
                whereKqlBuffer.append("and ItemDataEntry.FValueType = ?   \n");
                params.add(new Integer(refDM2.int_valueType));
                whereKqlBuffer.append("and ItemData.FDataCollectNumber = ?  ) \n");
                whereKqlBuffer.append("and ItemData.FDYNATYPE=1 \n");
                params.add(refDM2.dataCollectNumber);
                if (params.size() <= variableSize && iterator.hasNext()) continue;
                executeKqlBuffer = new StringBuffer();
                executeKqlBuffer.append(kqlBuffer).append(whereKqlBuffer).append(groupByBuffer);
                try {
                    row = DbUtil.executeQuery((Context)this.serverContext, (String)executeKqlBuffer.toString(), (Object[])params.toArray());
                    while (row.next()) {
                        property.put("TemplateNumber", (Object)row.getString("TemplateNumber"));
                        property.put("TemplateType", (Object)new Integer(row.getInt("TemplateType")));
                        property.put("CompanyNumber", (Object)row.getString("CompanyNumber"));
                        property.put("Currency", (Object)row.getString("Currency"));
                        property.put("datacollectnumber", (Object)row.getString("DataCollectNumber"));
                        property.put("SourceCurrency", (Object)row.getString("SourceCurrency"));
                        property.put("ItemNumber", (Object)row.getString("ItemNumber"));
                        property.put("DyItemNumber", (Object)row.getString("DyItemNumber"));
                        property.put("EntryYear", (Object)new Integer(row.getInt("EntryYear")));
                        property.put("Period", (Object)new Integer(row.getInt("Period")));
                        property.put("FetchType", (Object)new Integer(row.getInt("FetchType")));
                        property.put("ValueType", (Object)new Integer(row.getInt("ValueType")));
                        if (!StringUtils.isEmpty((String)refDM2.orgBoundId)) {
                            property.put("OrgTreeID", (Object)row.getString("OrgTreeID"));
                        }
                        dataType = row.getInt("DataType");
                        value = row.getBigDecimal("Value");
                        if (value == null) {
                            value = CslConstant.BGZERO;
                        }
                        numberValue = value;
                        textValue = row.getString("TextValue");
                        combineState.setNotNeedTemplateNumberList(notNeedTemplateNumberList);
                        combineState.setDataType(dataType);
                        combineState.setNumberValue(numberValue);
                        combineState.setTextValue(textValue);
                        iterator1 = isAdjustedSet.iterator();
                        while (iterator1.hasNext()) {
                            property.put("isAdjusted", iterator1.next());
                            combiner.combineValue(property);
                        }
                    }
                }
                catch (BOSException e) {
                    this.handleException(needTemplateTypeList, (Exception)((Object)e));
                }
                catch (SQLException e) {
                    this.handleException(needTemplateTypeList, e);
                }
                params.clear();
                whereKqlBuffer.delete(0, whereKqlBuffer.length());
                addOr = false;
            }
        }
        Iterator iterator = notNeedTemplateNumberList.iterator();
        while (iterator.hasNext()) {
            RefDM refDM3 = (RefDM)iterator.next();
            if (!refDM3.isGetFromAdjusted) continue;
            iterator.remove();
        }
        return notNeedTemplateNumberList;
    }

    private Set createIsAdjustedSet(Iterator iterator) {
        HashSet<String> result = new HashSet<String>();
        while (iterator.hasNext()) {
            RefDM refDM = (RefDM)iterator.next();
            result.add(refDM.isAdjusted);
        }
        return result;
    }

    private Map prepareRefDMForBeforeAndAfterNeedTempType(List needTemplateTypeList) {
        HashMap<PropertyContainer, Object> result = new HashMap<PropertyContainer, Object>();
        for (RefDM refDM : needTemplateTypeList) {
            PropertyContainer property = new PropertyContainer(13);
            property.put("TemplateNumber", (Object)refDM.templateNumber);
            property.put("TemplateType", (Object)new Integer(RptTmpTypeEnum.getEnum(refDM.templateType).getValue()));
            property.put("CompanyNumber", (Object)refDM.companyNumber);
            property.put("Currency", (Object)refDM.currencyNumber);
            property.put("SourceCurrency", (Object)refDM.srcCurrencyNumber);
            property.put("ItemNumber", (Object)refDM.itemNumber);
            property.put("DyItemNumber", (Object)refDM.dyItemNumber);
            property.put("EntryYear", (Object)new Integer(refDM.year));
            property.put("Period", (Object)new Integer(refDM.period));
            property.put("FetchType", (Object)new Integer(refDM.int_fetchType));
            property.put("ValueType", (Object)new Integer(refDM.int_valueType));
            property.put("isAdjusted", (Object)refDM.isAdjusted);
            property.put("DataCollectNumber", (Object)refDM.dataCollectNumber);
            if (!StringUtils.isEmpty((String)refDM.orgBoundId)) {
                property.put("OrgTreeID", (Object)refDM.orgBoundId);
            }
            if (result.get(property) != null) {
                Object oldDyItem = result.get(property);
                if (oldDyItem instanceof List) {
                    ((List)oldDyItem).add(refDM);
                    continue;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(oldDyItem);
                list.add(refDM);
                result.put(property, list);
                continue;
            }
            result.put(property, refDM);
        }
        return result;
    }

    private Set calculateBeforeAndAfterWithoutTempType(List notNeedTemplateTypeList) {
        HashSet notNeedTemplateNumberList = new HashSet();
        if (notNeedTemplateTypeList.size() == 0) {
            return notNeedTemplateNumberList;
        }
        StringBuffer kqlBuffer = new StringBuffer();
        kqlBuffer.append("Select Sum(ItemDataEntry.FValue) AS Value \t\n").append(", ItemDataEntry.FTextValue AS TextValue \t\t\t    \n").append(", ItemData.FDataType AS DataType \t\t\t\t\t    \n").append(",ItemDataEntry.FItemID AS ItemNumber\t\t\t\t    \n").append(",ItemDataEntry.FKeyNumber AS DyItemNumber\t\t\t    \n").append(",ItemData.FDataCollectNumber AS DataCollectNumber\t\t\t    \n").append("From T_CSL_DynaItemData ItemData \n").append("inner join T_CSL_DynaItemDataEntry ItemDataEntry on ItemData.FID=ItemDataEntry.FItemDataID \n").append("inner join T_Org_BaseUnit BaseUnit on ItemData.FOrgUnitID=BaseUnit.FID                     \n").append("inner join T_BD_Currency Currency on ItemData.FCurrencyID=Currency.FID                     \n").append("inner join T_BD_Currency SrcCurrency on ItemData.FSourceCurrencyId=SrcCurrency.FID         \n").append("inner join T_CSL_CSLReport Report on Report.FID = ItemData.FReportID                       \n").append("inner join T_RPT_Template Template on Template.FID = Report.FTemplateID                    \n");
        StringBuffer groupByKqlBuffer = new StringBuffer();
        groupByKqlBuffer.append(" group by ItemData.FDataType,ItemDataEntry.FTextValue ").append(",ItemDataEntry.FItemID,").append("ItemDataEntry.FKeyNumber, ItemData.FDataCollectNumber");
        Map refDMSortMap = this.prepareSortRefDMForCalculate(notNeedTemplateTypeList);
        ArrayList<Object> params = new ArrayList<Object>();
        boolean addOr = false;
        StringBuffer DywhereKqlBuffer = new StringBuffer();
        for (Object object : refDMSortMap.values()) {
            StringBuffer fixedWhereKqlBuffer = new StringBuffer();
            RefDM refdm = null;
            ArrayList<RefDM> sortRefDMList = null;
            if (object instanceof List) {
                sortRefDMList = (ArrayList<RefDM>)object;
                refdm = (RefDM)sortRefDMList.get(0);
            } else {
                sortRefDMList = new ArrayList<RefDM>();
                refdm = (RefDM)object;
                sortRefDMList.add(refdm);
            }
            Map refDMMap = this.prepareRefDMForBeforeAndAfterNotNeedTempType(sortRefDMList);
            CalculatorCombiner combiner = new CalculatorCombiner(refDMMap);
            BeforeAdjustCombineState combineState = new BeforeAdjustCombineState();
            combiner.setPrepareState(combineState);
            fixedWhereKqlBuffer.append(" Where Template.FNumber = ? \n");
            params.add(refdm.templateNumber);
            StringBuffer receivedLeftJoin = new StringBuffer();
            if (!StringUtils.isEmpty((String)refdm.orgBoundId)) {
                receivedLeftJoin.append(" Left join T_CSL_RptReceived Received on Received.FReportID = Report.FID                    \n");
                fixedWhereKqlBuffer.append(" and( Received.FOrgTreeID= ? and Received.FID IS NOT NULL )\n");
                params.add(refdm.orgBoundId);
            }
            fixedWhereKqlBuffer.append(" and BaseUnit.FNumber = ? \n");
            params.add(refdm.companyNumber);
            fixedWhereKqlBuffer.append(" and Currency.FNumber = ? \n");
            params.add(refdm.currencyNumber);
            if (!StringUtils.isEmpty((String)refdm.srcCurrencyNumber)) {
                fixedWhereKqlBuffer.append(" and SrcCurrency.FNumber = ? \n");
                params.add(refdm.srcCurrencyNumber);
            }
            fixedWhereKqlBuffer.append("and ItemDataEntry.FYear = ? \n");
            params.add(new Integer(refdm.year));
            fixedWhereKqlBuffer.append("and ItemDataEntry.FPeriod = ? \n");
            params.add(new Integer(refdm.period));
            fixedWhereKqlBuffer.append("and ItemDataEntry.FDataElement = ? \n");
            params.add(new Integer(refdm.int_fetchType));
            fixedWhereKqlBuffer.append("and ItemDataEntry.FValueType = ?   \n");
            params.add(new Integer(refdm.int_valueType));
            fixedWhereKqlBuffer.append(" and ItemData.FDataCollectNumber = ? \n");
            params.add(refdm.dataCollectNumber);
            ArrayList<String> dyParams = new ArrayList<String>();
            Iterator it = sortRefDMList.iterator();
            while (it.hasNext()) {
                RefDM refDM = (RefDM)it.next();
                if (addOr) {
                    DywhereKqlBuffer.append("OR    \n");
                } else {
                    addOr = true;
                    DywhereKqlBuffer.append("AND (");
                }
                DywhereKqlBuffer.append("( ItemDataEntry.FItemID = ? \n");
                dyParams.add(refDM.itemNumber);
                if (!StringUtils.isEmpty((String)refDM.dyItemNumber)) {
                    DywhereKqlBuffer.append(" and ItemDataEntry.FKeyNumber = ?) \n");
                    dyParams.add(refDM.dyItemNumber);
                } else {
                    DywhereKqlBuffer.append(" )");
                }
                if (dyParams.size() <= variableSize && it.hasNext()) continue;
                try {
                    ArrayList<Object> executeParam = new ArrayList<Object>();
                    executeParam.addAll(params);
                    executeParam.addAll(dyParams);
                    DywhereKqlBuffer.append(" ) and Template.FTemplateType in (?,?,?,?) ");
                    executeParam.add(new Integer(10));
                    executeParam.add(new Integer(11));
                    executeParam.add(new Integer(13));
                    executeParam.add(new Integer(12));
                    StringBuffer executeKqlBuffer = new StringBuffer();
                    executeKqlBuffer.append(kqlBuffer).append(receivedLeftJoin).append(fixedWhereKqlBuffer).append(DywhereKqlBuffer).append(groupByKqlBuffer);
                    IRowSet row = DbUtil.executeQuery((Context)this.serverContext, (String)executeKqlBuffer.toString(), (Object[])executeParam.toArray());
                    while (row.next()) {
                        StringBuffer sb = new StringBuffer();
                        sb.append("[").append(row.getString("ItemNumber")).append("]");
                        sb.append("[").append(StringUtils.isEmpty((String)refDM.dyItemNumber) ? "" : row.getString("DyItemNumber")).append("]");
                        int dataType = row.getInt("DataType");
                        BigDecimal value = row.getBigDecimal("Value");
                        if (value == null) {
                            value = CslConstant.BGZERO;
                        }
                        String textValue = row.getString("TextValue");
                        BigDecimal numberValue = value;
                        combineState.setNotNeedTemplateNumberList(notNeedTemplateNumberList);
                        combineState.setDataType(dataType);
                        combineState.setNumberValue(numberValue);
                        combineState.setTextValue(textValue);
                        combiner.combineValue(sb.toString());
                    }
                }
                catch (BOSException e) {
                    this.handleException(notNeedTemplateTypeList, (Exception)((Object)e));
                }
                catch (SQLException e) {
                    this.handleException(notNeedTemplateTypeList, e);
                }
                DywhereKqlBuffer.delete(0, DywhereKqlBuffer.length());
                dyParams.clear();
                addOr = false;
            }
            params.clear();
        }
        Iterator<Object> iterator = notNeedTemplateNumberList.iterator();
        while (iterator.hasNext()) {
            RefDM refDM = (RefDM)iterator.next();
            if (!refDM.isGetFromAdjusted) continue;
            iterator.remove();
        }
        return notNeedTemplateNumberList;
    }

    private Map prepareSortRefDMForCalculate(List notNeedTemplateTypeList) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        StringBuffer sb = new StringBuffer();
        for (RefDM refDM : notNeedTemplateTypeList) {
            sb.append("[").append(refDM.templateNumber).append("]");
            sb.append("[").append(refDM.companyNumber).append("]");
            sb.append("[").append(refDM.currencyNumber).append("]");
            sb.append("[").append(StringUtils.isEmpty((String)refDM.srcCurrencyNumber) ? "" : refDM.srcCurrencyNumber).append("]");
            sb.append("[").append(refDM.year).append("]");
            sb.append("[").append(refDM.period).append("]");
            sb.append("[").append(refDM.int_valueType).append("]");
            sb.append("[").append(refDM.int_fetchType).append("]");
            sb.append("[").append(StringUtils.isEmpty((String)refDM.dyItemNumber) ? "0" : "1").append("]");
            if (!StringUtils.isEmpty((String)refDM.orgBoundId)) {
                sb.append("[").append(refDM.orgBoundId).append("]");
            } else {
                sb.append("[").append("").append("]");
            }
            String key = sb.toString();
            if (result.get(key) != null) {
                Object oldDyItem = result.get(key);
                if (oldDyItem instanceof List) {
                    ((List)oldDyItem).add(refDM);
                    continue;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(oldDyItem);
                list.add(refDM);
                result.put(key, list);
                continue;
            }
            result.put(key, refDM);
        }
        return result;
    }

    private Map prepareRefDMForBeforeAndAfterNotNeedTempType(List notNeedTemplateTypeList) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (RefDM refDM : notNeedTemplateTypeList) {
            StringBuffer sb = new StringBuffer();
            sb.append("[").append(refDM.itemNumber).append("]");
            sb.append("[").append(StringUtils.isEmpty((String)refDM.dyItemNumber) ? "" : refDM.dyItemNumber).append("]");
            String key = sb.toString();
            if (result.get(key) != null) {
                ArrayList<RefDM> list;
                Object oldDyItem = result.get(key);
                if (oldDyItem instanceof List) {
                    list = (ArrayList<RefDM>)oldDyItem;
                    if (list.contains(refDM)) continue;
                    list.add(refDM);
                    continue;
                }
                if (oldDyItem == refDM) continue;
                list = new ArrayList<RefDM>();
                list.add((RefDM)oldDyItem);
                list.add(refDM);
                result.put(key, list);
                continue;
            }
            result.put(key, refDM);
        }
        return result;
    }

    private void handleException(List list, Exception e) {
        for (RefDM refDM : list) {
            refDM.setException(e);
        }
    }

    private void init(int batch) throws BOSException {
        this.initRefDMs(batch);
        this.initTemplatePeriodType();
        this.initOrgBoundId();
        this.groupRefDMs();
    }

    private void groupRefDMs() {
        this.beforeAndAfterAdjustRefDMList = new ArrayList();
        this.adjustingRefDMList = new ArrayList();
        for (RefDM refDM : this.refDMList) {
            if (!StringUtils.isEmpty((String)refDM.templateNumber)) {
                this.beforeAndAfterAdjustRefDMList.add(refDM);
                continue;
            }
            this.adjustingRefDMList.add(refDM);
        }
    }

    private void initOrgBoundId() throws BOSException {
        HashMap<String, OrgTreeCollection> orgBoundNumber2OrgTreeCollectionMap = new HashMap<String, OrgTreeCollection>();
        if (this.orgTreeNumberSet.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select Fid,FNumber,FStartDate,FEndDate from T_ORG_Tree where FNumber in \n");
        sql.append(this.batchHelper.createInSql(this.orgTreeNumberSet.iterator()));
        sql.append(" and (FStatus in (1,2))  \n");
        sql.append(" order by FstartDate desc,FendDate desc");
        IRowSet row = DbUtil.executeQuery((Context)this.serverContext, (String)sql.toString());
        try {
            while (row.next()) {
                OrgTreeInfo info = new OrgTreeInfo();
                info.setId(BOSUuid.read((String)row.getString("Fid")));
                String number = row.getString("FNumber");
                info.setNumber(number);
                info.setStartDate(row.getTimestamp("FStartDate"));
                info.setEndDate(row.getTimestamp("FEndDate"));
                OrgTreeCollection collection = (OrgTreeCollection)orgBoundNumber2OrgTreeCollectionMap.get(number);
                if (collection == null) {
                    collection = new OrgTreeCollection();
                }
                collection.add(info);
                orgBoundNumber2OrgTreeCollectionMap.put(number, collection);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        this.initOrgTreeByPeriods(orgBoundNumber2OrgTreeCollectionMap);
    }

    private void initRefDMs(int batch) {
        this.orgTreeNumberSet = new HashSet();
        if (this.refDMList != null && this.refDMList.size() > 0) {
            this.refDMList.clear();
        }
        int startCount = (batch - 1) * batchSize;
        int count = batch * batchSize > this.refDMAllList.size() ? this.refDMAllList.size() : batch * batchSize;
        boolean isSupportOtherDS = CslRptUtil.isSupportOtherDSServer((Context)this.batchHelper.getServerContext());
        HashMap checkPermission = new HashMap();
        for (int i = startCount; i < count; ++i) {
            RefDM refDM = (RefDM)this.refDMAllList.get(i);
            this.refDMList.add(refDM);
            try {
                if (isSupportOtherDS) {
                    CSLPermissionUtil.checkDataCollectPermissionForFormula((Context)this.batchHelper.getServerContext(), (String)this.batchHelper.getServerContext().getCaller().toString(), (String)refDM.dataCollectNumber, checkPermission);
                }
                if (refDM.isException) continue;
                if (refDM.companyNumber.indexOf(33) != -1) {
                    String[] numbers = refDM.companyNumber.split("!");
                    this.orgTreeNumberSet.add(numbers[0]);
                    refDM.orgBoundNumber = numbers[0];
                    refDM.companyNumber = numbers[1];
                    continue;
                }
                if (!StringUtils.isEmpty((String)refDM.orgBoundNumber)) {
                    this.orgTreeNumberSet.add(refDM.orgBoundNumber);
                    continue;
                }
                String orgeTree = this.getOrgTreeNumberByNotAdjustedFlag(refDM);
                if (!StringUtils.isEmpty((String)orgeTree)) {
                    this.orgTreeNumberSet.add(orgeTree);
                    refDM.orgBoundNumber = orgeTree;
                    continue;
                }
                refDM.param.setValue(null);
                continue;
            }
            catch (Exception e) {
                refDM.setException((Exception)((Object)new ReportException(ReportException.COMMON_EXCEPTION, new Object[]{e.getMessage()})));
            }
        }
    }

    private void initParameterList(SortedParameterArray params) throws EASBizException, BOSException {
        this.refDMAllList = new ArrayList();
        int count = params.size();
        for (int i = 0; i < count; ++i) {
            RefDM refDM = new RefDM(params.getParameter(i));
            this.refDMAllList.add(refDM);
        }
    }

    private void initTemplatePeriodType() throws BOSException {
        HashMap<PropertyContainer, Integer> templatePeriodTypeMap = new HashMap<PropertyContainer, Integer>();
        ArrayList<String> numberList = new ArrayList<String>();
        ArrayList<Integer> templateTypeList = new ArrayList<Integer>();
        for (RefDM refdm : this.refDMList) {
            if (refdm.isException || refdm.templateType == null) continue;
            numberList.add(refdm.templateNumber);
            RptTmpTypeEnum type = RptTmpTypeEnum.getEnum(refdm.templateType);
            templateTypeList.add(new Integer(type.getValue()));
        }
        if (templateTypeList.size() > 0) {
            HashMap<String, ArrayList<Object>> conditions = new HashMap<String, ArrayList<Object>>();
            conditions.put("FNumber", numberList);
            conditions.put("FTemplateType", templateTypeList);
            SQLStringWrapper sqlWrapper = this.batchHelper.createMultiAndCondition(conditions);
            StringBuffer sql = new StringBuffer();
            sql.append("select FNumber,FTemplateType,FPeriodType from T_RPT_Template Where ").append("\r\n");
            sql.append(sqlWrapper.getSQLString());
            IRowSet rowSet = DbUtil.executeQuery((Context)this.serverContext, (String)sql.toString(), (Object[])sqlWrapper.getArrayParams());
            try {
                while (rowSet.next()) {
                    PropertyContainer templateWrapper = new PropertyContainer(2);
                    templateWrapper.put("number", (Object)rowSet.getString("FNumber"));
                    templateWrapper.put("templateType", (Object)new Integer(rowSet.getInt("FTemplateType")));
                    templatePeriodTypeMap.put(templateWrapper, new Integer(rowSet.getInt("FPeriodType")));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        for (RefDM refdm : this.refDMList) {
            Integer periodType;
            if (refdm.isException) continue;
            PropertyContainer templateWrapper = new PropertyContainer(2);
            templateWrapper.put("number", (Object)refdm.templateNumber);
            if (refdm.templateType == null) {
                templateWrapper.put("templateType", null);
            } else {
                templateWrapper.put("templateType", (Object)new Integer(RptTmpTypeEnum.getEnum(refdm.templateType).getValue()));
            }
            if ((periodType = (Integer)templatePeriodTypeMap.get(templateWrapper)) == null) continue;
            refdm.periodType = periodType;
        }
    }

    public void initOrgTreeByPeriods(Map orgBoundNumber2OrgTreeCollectionMap) {
        block0: for (RefDM refDM : this.refDMList) {
            if (refDM.isException) continue;
            if (refDM.periodType == 0) {
                refDM.periodType = 3;
            }
            RptPeriodTypeEnum curPeriodType = RptPeriodTypeEnum.getEnum((int)refDM.periodType);
            OrgTreeCollection orgTreeCollection = (OrgTreeCollection)orgBoundNumber2OrgTreeCollectionMap.get(refDM.orgBoundNumber);
            if (orgTreeCollection != null && orgTreeCollection.size() > 0) {
                Date curDate = FiscalPeriodHelper.getPeriodLastDate((PeriodCollection)this.periods, (int)refDM.year, (int)refDM.period, (RptPeriodTypeEnum)curPeriodType, (boolean)this.isMergeByFiscalPeriod);
                for (int i = 0; i < orgTreeCollection.size(); ++i) {
                    String strOrgTreeID = orgTreeCollection.get(i).getId().toString();
                    Timestamp sDate = orgTreeCollection.get(i).getStartDate();
                    if (curDate == null || sDate.compareTo(new Timestamp(curDate.getTime())) > 0) continue;
                    refDM.orgBoundId = strOrgTreeID;
                    continue block0;
                }
                continue;
            }
            if (!refDM.isAdjusted.equalsIgnoreCase("true") && !refDM.templateType.equalsIgnoreCase("DYNAMICSUMREPORT") && !refDM.templateType.equalsIgnoreCase("DYNAMICCSLREPORT") || StringUtils.isEmpty((String)refDM.orgBoundNumber)) continue;
            refDM.setException((Exception)((Object)new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"60_DyItemCalculator", (Locale)this.serverContext.getLocale()))));
        }
    }

    private String getOrgTreeNumber() {
        OrgTreeInfo info;
        String orgTreeNumber = (String)this.calCulateContext.getReportAdapter().getReportProperty("CSLReport_OrgTree_Number");
        if (orgTreeNumber == null && (info = (OrgTreeInfo)this.calCulateContext.getServerContext().get((Object)"KEY_ORGTREE_INFO")) != null) {
            orgTreeNumber = info.getNumber();
        }
        return orgTreeNumber;
    }

    private String getOrgTreeNumberByNotAdjustedFlag(RefDM refDM) {
        String treeNumber = null;
        if (refDM.isAdjusted.equalsIgnoreCase("true")) {
            return null;
        }
        StringBuffer sql = new StringBuffer(200);
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append(" select top 1 tree.Fnumber as treeNumber from t_org_tree tree \n").append(" join t_csl_rptreceived rec on tree.fid = rec.Forgtreeid \n").append(" join t_csl_cslreport rpt on rec.freportid = rpt.fid \n").append(" join t_rpt_template tmp on tmp.fid = rpt.ftemplateid \n").append(" join t_org_baseunit unit on rpt.fcompanyid = unit.fid \n").append(" where tmp.fnumber = ? and unit.fnumber = ? \n ").append(" and rpt.fyear = ? and rpt.fperiod = ? \n");
        params.add(refDM.templateNumber);
        params.add(refDM.companyNumber);
        params.add(new Integer(refDM.year));
        params.add(new Integer(refDM.period));
        try {
            IRowSet row = DbUtil.executeQuery((Context)this.serverContext, (String)sql.toString(), (Object[])params.toArray());
            while (row.next()) {
                treeNumber = row.getString("treeNumber");
            }
        }
        catch (BOSException e) {
            logger.debug((Object)e.getMessage());
        }
        catch (SQLException e) {
            logger.debug((Object)e.getMessage());
        }
        return treeNumber;
    }

    private void initBatchSize() throws BOSException {
        String sql = "SELECT FKEY,FVALUE FROM T_CSL_CSLParam WHERE FKEY IN (?,?)";
        IRowSet rowSet = DbUtil.executeQuery((Context)this.serverContext, (String)sql, (Object[])new Object[]{"KEY_CSLPARAM_REFDM_BATCH_SIZE", "KEY_CSLPARAM_REFDM_WHERE_VARIABLE_SIZE"});
        try {
            while (rowSet.next()) {
                String key = rowSet.getString("FKEY");
                if ("KEY_CSLPARAM_REFDM_BATCH_SIZE".equalsIgnoreCase(key)) {
                    String stringBatchSize = rowSet.getString("FVALUE");
                    batchSize = Integer.parseInt(stringBatchSize);
                    continue;
                }
                if (!"KEY_CSLPARAM_REFDM_WHERE_VARIABLE_SIZE".equalsIgnoreCase(key)) continue;
                String stringvariableSize = rowSet.getString("FVALUE");
                variableSize = Integer.parseInt(stringvariableSize);
            }
        }
        catch (Exception e) {
            logger.debug((Object)e.getMessage());
        }
    }

    private boolean isAllSameExcludeItem(List needTemplateTypeList) {
        HashMap condition = new HashMap();
        Iterator iterator = needTemplateTypeList.iterator();
        while (iterator.hasNext()) {
            StringBuffer sb = new StringBuffer();
            RefDM refDM = (RefDM)iterator.next();
            sb.append(refDM.templateNumber);
            if (!StringUtils.isEmpty((String)refDM.templateType)) {
                sb.append(new Integer(RptTmpTypeEnum.getEnum(refDM.templateType).getValue()));
            }
            if (!StringUtils.isEmpty((String)refDM.orgBoundId) && this.isParamadjustSeparate) {
                sb.append(refDM.orgBoundId);
            }
            sb.append(refDM.companyNumber);
            sb.append(refDM.currencyNumber);
            if (!StringUtils.isEmpty((String)refDM.srcCurrencyNumber)) {
                sb.append(refDM.srcCurrencyNumber);
            }
            if (!StringUtils.isEmpty((String)refDM.dyItemNumber)) {
                sb.append(refDM.dyItemNumber);
            }
            sb.append(refDM.year);
            sb.append(refDM.period);
            sb.append(refDM.int_fetchType);
            sb.append(refDM.int_valueType);
            sb.append(refDM.dataCollectNumber);
            if (condition.containsKey(sb.toString())) continue;
            condition.put(sb.toString(), null);
        }
        if (condition.size() > 1) {
            return false;
        }
        condition.clear();
        return true;
    }

    private class RefDM
    implements IFormulaCalculator {
        Parameter param;
        String companyNumber;
        String templateNumber;
        String templateType;
        String currencyNumber;
        String srcCurrencyNumber;
        int year;
        int period;
        String itemNumber;
        String dyItemNumber;
        String fetchType;
        String valueType;
        String isAdjusted;
        Exception e;
        boolean isException;
        boolean isGetFromAdjusted;
        private int int_fetchType;
        private int int_valueType;
        private String orgBoundId;
        private String orgBoundNumber;
        private int periodType;
        private String dataCollectNumber;

        RefDM(Parameter param) {
            this.param = param;
            try {
                this.initParam();
            }
            catch (EASBizException e) {
                this.setException((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.setException((Exception)((Object)e));
            }
            catch (RuntimeException e) {
                this.setException(e);
            }
        }

        void setException(Exception e) {
            this.isException = true;
            this.e = e;
        }

        @Override
        public String getSheetName() {
            return this.param.getSheetName();
        }

        private void initParam() throws BOSException, EASBizException {
            block15: {
                this.initArgs();
                int rptYear = RefDMCalcuter.this.batchHelper.getReport_Year();
                int rptPeriod = RefDMCalcuter.this.batchHelper.getReport_Period();
                int int_periodType = RefDMCalcuter.this.batchHelper.getReport_PeriodType();
                if (this.currencyNumber == null || this.currencyNumber.trim().equals("")) {
                    this.currencyNumber = RefDMCalcuter.this.batchHelper.getCorrect_Currency_Number();
                }
                if (StringUtils.isEmpty((String)this.srcCurrencyNumber)) {
                    this.srcCurrencyNumber = RefDMCalcuter.this.batchHelper.getSource_Currency_Number();
                }
                if (StringUtils.isEmpty((String)this.isAdjusted)) {
                    this.isAdjusted = (String)RefDMCalcuter.this.calCulateContext.getReportAdapter().getReportProperty("CSLReport_AdjustedStatus");
                    if (StringUtils.isEmpty((String)this.isAdjusted)) {
                        this.isAdjusted = String.valueOf(0);
                    }
                }
                if (StringUtils.isEmpty((String)this.dataCollectNumber)) {
                    this.dataCollectNumber = RefDMCalcuter.this.batchHelper.getDataCollectNumber();
                }
                int[] start = null;
                start = RefDMCalcuter.this.isSupport13Period ? RPTDate13Util.getRptYearAndPeriod((int)rptYear, (int)rptPeriod, (int)int_periodType, (int)this.year, (int)this.period, (boolean)RefDMCalcuter.this.isSupport13Period) : FiscalPeriodHelper.getRptFormualYearAndPeriod((PeriodCollection)RefDMCalcuter.this.periods, (int)rptYear, (int)rptPeriod, (int)int_periodType, (int)this.year, (int)this.period, (boolean)RefDMCalcuter.this.isMergeByFiscalPeriod);
                if (start != null) {
                    this.year = start[0];
                    this.period = start[1];
                }
                this.int_fetchType = -1;
                this.int_fetchType = RefDMCalcuter.this.serverContext == null ? DataElementProvider.getDataElementInnerValue((String)this.fetchType) : DataElementProvider.getDataElementInnerValue((Context)RefDMCalcuter.this.serverContext, (String)this.fetchType);
                if (StringUtils.isEmpty((String)this.itemNumber)) {
                    this.setException((Exception)((Object)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"70_RefDMCalcuter", (Locale)RefDMCalcuter.this.serverContext.getLocale())})));
                }
                if (RptTmpTypeEnum.getEnum(this.templateType) == null) {
                    String tmpStr = this.templateType;
                    this.templateType = this.templateNumber;
                    this.templateNumber = tmpStr;
                }
                if (!StringUtils.isEmpty((String)this.templateType)) {
                    RptTmpTypeEnum templateTypeEnum = null;
                    try {
                        templateTypeEnum = RptTmpTypeEnum.getEnum(this.templateType);
                        if (templateTypeEnum == null) {
                            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"71_RefDMCalcuter", (Locale)RefDMCalcuter.this.serverContext.getLocale())});
                        }
                        break block15;
                    }
                    catch (RuntimeException e) {
                        throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"71_RefDMCalcuter", (Locale)RefDMCalcuter.this.serverContext.getLocale())});
                    }
                }
                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"72_RefDMCalcuter", (Locale)RefDMCalcuter.this.serverContext.getLocale())});
            }
            this.int_valueType = FormulaAdapter.getValueType((String)this.valueType);
            if (StringUtils.isEmpty((String)this.orgBoundNumber)) {
                this.orgBoundNumber = RefDMCalcuter.this.getOrgTreeNumber();
            }
            if (this.companyNumber.length() <= 0) {
                this.companyNumber = this.makeValidOrgcode(this.companyNumber);
            }
            this.checkOrgPermission(this.companyNumber);
            if (StringUtils.isEmpty((String)this.dyItemNumber)) {
                this.dyItemNumber = null;
            }
        }

        private void checkOrgPermission(String companyNumber) throws ReportException, BOSException {
            ChecFmlParamPermissionUtil pmc = RefDMCalcuter.this.batchHelper.getPermissionUtilInstance();
            if (pmc != null) {
                if (companyNumber.indexOf("!") >= 0) {
                    pmc._checkUnitCompPermision(companyNumber.substring(0, companyNumber.indexOf("!")), companyNumber.substring(1 + companyNumber.indexOf("!")));
                } else {
                    pmc.checkUnitCompPermision(companyNumber);
                }
            }
        }

        private void initArgs() {
            Object[] args = this.getParameter().getArgs();
            if (args[0] instanceof Object[]) {
                args = (Object[])args[0];
            }
            if (args.length != 14) {
                Object[] newArgs = new Object[14];
                int index = 0;
                for (int i = 0; i < 14; ++i) {
                    newArgs[i] = args.length == 9 && (i == 0 || i == 3 || i == 5 || i == 12 || i == 13) ? new Variant() : (args.length == 10 && (i == 0 || i == 5 || i == 12 || i == 13) ? new Variant() : (args.length == 12 && i == 0 ? new Variant() : (args.length == 13 && i == 13 ? new Variant() : args[index++])));
                }
                args = newArgs;
            }
            this.orgBoundNumber = ((Variant)args[0]).getValue() == null ? null : ((Variant)args[0]).getValue().toString();
            this.companyNumber = ((Variant)args[1]).getValue() == null ? null : ((Variant)args[1]).getValue().toString();
            this.templateType = ((Variant)args[2]).getValue() == null ? null : ((Variant)args[2]).getValue().toString();
            this.templateNumber = ((Variant)args[3]).getValue() == null ? null : ((Variant)args[3]).getValue().toString();
            this.currencyNumber = ((Variant)args[4]).getValue() == null ? null : ((Variant)args[4]).getValue().toString();
            this.srcCurrencyNumber = ((Variant)args[5]).getValue() == null ? null : ((Variant)args[5]).getValue().toString();
            this.year = Integer.parseInt(((Variant)args[6]).getValue().toString());
            this.period = Integer.parseInt(((Variant)args[7]).getValue().toString());
            this.itemNumber = ((Variant)args[8]).getValue() == null ? null : ((Variant)args[8]).getValue().toString();
            this.dyItemNumber = ((Variant)args[9]).getValue() == null ? null : ((Variant)args[9]).getValue().toString();
            this.fetchType = ((Variant)args[10]).getValue() == null ? null : ((Variant)args[10]).getValue().toString();
            this.valueType = ((Variant)args[11]).getValue() == null ? null : ((Variant)args[11]).getValue().toString();
            this.isAdjusted = ((Variant)args[12]).getValue() == null ? null : ((Variant)args[12]).getValue().toString();
            this.dataCollectNumber = ((Variant)args[13]).getValue() == null ? null : ((Variant)args[13]).getValue().toString();
        }

        private String makeValidOrgcode(String orgCode) throws EASBizException, BOSException {
            if (orgCode == null || orgCode.length() < 1) {
                int type = RefDMCalcuter.this.batchHelper.getReport_SourceType();
                if (type == 2 || type == 3 || type == 11 || type == 12) {
                    orgCode = RefDMCalcuter.this.batchHelper.getOrgUnit_Number();
                    if (StringUtils.isEmpty((String)orgCode)) {
                        orgCode = RefDMCalcuter.this.batchHelper.getCompany_Number();
                    }
                } else {
                    orgCode = RefDMCalcuter.this.batchHelper.getCompany_Number();
                    if (StringUtils.isEmpty((String)orgCode)) {
                        orgCode = RefDMCalcuter.this.batchHelper.getOrgUnit_Number();
                    }
                }
            }
            return orgCode;
        }

        @Override
        public Parameter getParameter() {
            return this.param;
        }

        @Override
        public Exception getException() {
            return null;
        }

        public Object[] getFields() {
            return null;
        }

        @Override
        public boolean isException() {
            return false;
        }

        public Set getNullFields() {
            return null;
        }
    }

    private class BeforeAdjustCombineState
    implements IFormulaCombinationPreparedState {
        private Set notNeedTemplateNumberList;
        private int dataType;
        private String textValue;
        private BigDecimal numberValue;

        private BeforeAdjustCombineState() {
        }

        @Override
        public boolean isPrepared(IFormulaCalculator formula) {
            RefDM refDM = (RefDM)formula;
            if (RptUtil.isTrue(refDM.isAdjusted) && this.dataType == 2) {
                if (!refDM.isGetFromAdjusted) {
                    refDM.isGetFromAdjusted = true;
                    refDM.getParameter().setValue(null);
                }
                return true;
            }
            if (!RptUtil.isTrue(refDM.isAdjusted) && this.dataType == 0) {
                return true;
            }
            if (RptUtil.isTrue(refDM.isAdjusted)) {
                this.notNeedTemplateNumberList.add(refDM);
            }
            return this.dataType == 0 && !refDM.isGetFromAdjusted;
        }

        @Override
        public Object getFormulaResultValue(IFormulaCalculator formula) {
            RefDM refDM = (RefDM)formula;
            if (refDM.int_valueType == 3) {
                return this.textValue;
            }
            return this.numberValue;
        }

        @Override
        public boolean isFormulaResultNumberValue(IFormulaCalculator formula) {
            RefDM refDM = (RefDM)formula;
            return refDM.int_valueType != 3;
        }

        public void setNotNeedTemplateNumberList(Set notNeedTemplateNumberList) {
            this.notNeedTemplateNumberList = notNeedTemplateNumberList;
        }

        public void setDataType(int dataType) {
            this.dataType = dataType;
        }

        public void setTextValue(String textValue) {
            this.textValue = textValue;
        }

        public void setNumberValue(BigDecimal numberValue) {
            this.numberValue = numberValue;
        }
    }

    class PrepareState
    implements IFormulaCombinationPreparedState {
        private String textValue;
        private BigDecimal numberValue;

        PrepareState() {
        }

        @Override
        public Object getFormulaResultValue(IFormulaCalculator formula) {
            RefDM refDM = (RefDM)formula;
            if (refDM.int_valueType == 3) {
                return this.textValue;
            }
            return this.numberValue;
        }

        @Override
        public boolean isFormulaResultNumberValue(IFormulaCalculator formula) {
            RefDM refDM = (RefDM)formula;
            return refDM.int_valueType != 3;
        }

        @Override
        public boolean isPrepared(IFormulaCalculator formula) {
            return true;
        }

        public void setTextValue(String textValue) {
            this.textValue = textValue;
        }

        public void setNumberValue(BigDecimal numberValue) {
            this.numberValue = numberValue;
        }
    }
}

