/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acct;

import com.kingdee.eas.fi.rpt.BalanceTypeEnum;
import com.kingdee.eas.fi.rpt.app.AcctCalculaterExt;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.acct.AbstractAcctSortState;
import com.kingdee.eas.fi.rpt.batch.acct.AcctUtils;
import com.kingdee.eas.fi.rpt.batch.acct.IAcctSortState;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;

public class AcctBalanceState
extends AbstractAcctSortState {
    private static Set noDCSet = new HashSet();
    private static Set useDetailBalanceSelectSet = new HashSet();

    @Override
    public void setState(IFormulaCalculator formula) {
        super.setState(formula);
    }

    @Override
    public IAcctSortState getNewInstance() {
        return new AcctBalanceState();
    }

    private boolean isUseDetailBalanceSelect() {
        return useDetailBalanceSelectSet.contains(this.getBalPairType()) && this.isNotLeafAsstAccount();
    }

    public String getSumPart(String currencyNumber, boolean hasA_Acct) {
        if (this.isMultiUnPosted() && "QJL_QDL".equals(this.getBalPairType())) {
            return " SUM(A_Bal.FYearDebitQty/unit.FCoefficient) QJL,SUM(A_Bal.FYearCreditQty/unit.FCoefficient) QDL ";
        }
        if (!this.isNeedAccountTable() || this.isUseDetailBalanceSelect()) {
            if ("GLC".equals(currencyNumber)) {
                return AcctUtils.getDetailBalanceSelectPartForGLC(this.getBalPairType(), hasA_Acct);
            }
            if ("GRC".equals(currencyNumber)) {
                return AcctUtils.getDetailBalanceSelectPartForGRC(this.getBalPairType(), hasA_Acct);
            }
            return AcctUtils.getDetailBalanceSelectPart(this.getBalPairType(), hasA_Acct);
        }
        if ("GLC".equals(currencyNumber)) {
            return AcctUtils.getNotDetailBalanceSelectPartForGLC(this.getBalPairType(), hasA_Acct);
        }
        if ("GRC".equals(currencyNumber)) {
            return AcctUtils.getNotDetailBalanceSelectPartForGRC(this.getBalPairType(), hasA_Acct);
        }
        return AcctUtils.getNotDetailBalanceSelectPart(this.getBalPairType(), hasA_Acct);
    }

    @Override
    public String getSumPart(String currencyNumber) {
        return this.getSumPart(currencyNumber, false);
    }

    @Override
    public boolean isNeedSubAccount() {
        return false;
    }

    @Override
    public Object processReturnValue(IFormulaCalculator formula, Object object) {
        if (object == null) {
            return object;
        }
        AcctCalculaterExt acct = (AcctCalculaterExt)formula;
        if ((!this.isNeedAccountTable() || this.isUseDetailBalanceSelect() || "SY_SL".equals(this.getBalPairType()) || "QSY_QSL".equals(this.getBalPairType())) && !noDCSet.contains(this.getBalPairType())) {
            BigDecimal value = (BigDecimal)object;
            return value.multiply(new BigDecimal(acct.getAccountItem().startAccount.account.dc));
        }
        return object;
    }

    @Override
    public Object processReturnValue(IFormulaCalculator formula, Object object, BigDecimal dc) {
        if (object == null) {
            return object;
        }
        AcctCalculaterExt acct = (AcctCalculaterExt)formula;
        if ((!this.isNeedAccountTable() || this.isUseDetailBalanceSelect() || "SY_SL".equals(this.getBalPairType()) || "QSY_QSL".equals(this.getBalPairType())) && !noDCSet.contains(this.getBalPairType())) {
            if (acct.getBalanceType().getName().equals(BalanceTypeEnum.B.getName()) || acct.getBalanceType().getName().equals(BalanceTypeEnum.TB.getName()) || acct.getBalanceType().getName().equals(BalanceTypeEnum.RB.getName()) || acct.getBalanceType().getName().equals(BalanceTypeEnum.QB.getName())) {
                return object;
            }
            BigDecimal value = (BigDecimal)object;
            return value.multiply(new BigDecimal(acct.getAccountItem().startAccount.account.dc));
        }
        if ((this.isNeedAccountTable() || !this.isUseDetailBalanceSelect()) && (acct.getBalanceType().getName().equals(BalanceTypeEnum.B.getName()) || acct.getBalanceType().getName().equals(BalanceTypeEnum.TB.getName()) || acct.getBalanceType().getName().equals(BalanceTypeEnum.RB.getName()) || acct.getBalanceType().getName().equals(BalanceTypeEnum.QB.getName())) && ("C_Y".equals(this.getBalPairType()) || "TC_TY".equals(this.getBalPairType()) || "RC_RY".equals(this.getBalPairType()) || "QC_QY".equals(this.getBalPairType()))) {
            BigDecimal value = (BigDecimal)object;
            return value.multiply(dc);
        }
        return object;
    }

    @Override
    public String getGroupByPart() {
        return null;
    }

    @Override
    public String getFromPart() {
        if (!(this.isNotLeafAsstAccount() || this.isNeedSubAccount() || this.getAccounts() != null || !this.isBizCompany() || this.isNeedAccountViewForDC() || this.isNeedAccountViewForMeasureUnit() || !"QJL_QDL".equals(this.getBalTypePair()) && !"QB".equals(this.getBalTypePair()))) {
            return "inner join T_BD_AccountView A_AcctLeaf on A_Bal.FAccountID = A_AcctLeaf.FID and A_AcctLeaf.FCompanyID = A_Bal.FOrgUnitID ";
        }
        return null;
    }

    @Override
    public String getUnPostedAccrualSelectPart(String currencyNumber) {
        return AcctUtils.getUnPostedBalanceAccrualSelectPart(this.getBalPairType(), this.getRptOrgType(), currencyNumber);
    }

    @Override
    public String getUnPostedBalanceSelectPart(String currencyNumber) {
        return AcctUtils.getUnPostedBalanceBalanceSelectPart(this.getBalPairType(), this.getRptOrgType(), currencyNumber);
    }

    @Override
    public int getAcctSortType() {
        return 1;
    }

    static {
        noDCSet.add("AC_AY");
        noDCSet.add("B");
        noDCSet.add("TB");
        noDCSet.add("RB");
        noDCSet.add("JL_DL");
        noDCSet.add("TJL_TDL");
        noDCSet.add("RLJ_RDL");
        noDCSet.add("QJL_QDL");
        useDetailBalanceSelectSet.add("C_Y");
        useDetailBalanceSelectSet.add("TC_TY");
        useDetailBalanceSelectSet.add("RC_RY");
        useDetailBalanceSelectSet.add("QC_QY");
        useDetailBalanceSelectSet.add("SY_SL");
        useDetailBalanceSelectSet.add("TSY_TSL");
        useDetailBalanceSelectSet.add("RSY_RSL");
        useDetailBalanceSelectSet.add("QSY_QSL");
    }
}

