/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acct;

import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.rpt.app.AcctCalculaterExt;
import com.kingdee.eas.fi.rpt.app.AssistantGroup;
import com.kingdee.eas.fi.rpt.app.AssistantItem;
import com.kingdee.eas.fi.rpt.app.AsstActType;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSortState;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.IFormulaCombinationPreparedState;
import com.kingdee.eas.fi.rpt.batch.acct.AbstractAcctSortState;
import com.kingdee.eas.fi.rpt.batch.acct.AcctBalanceState;
import com.kingdee.eas.fi.rpt.batch.acct.AcctCombineState;
import com.kingdee.eas.fi.rpt.batch.acct.AcctTempTableValueInsertProcessor;
import com.kingdee.eas.fi.rpt.batch.acct.AcctUtils;
import com.kingdee.eas.fi.rpt.batch.hint.biz.ITableAlias;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.DefaultTempTableValueInsertProcessor;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.ITempTableField;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.ITempTableSQLProcessor;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.ITempTableValue;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.ITempTableValueInsertProcessor;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableField;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableFieldItem;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableJdbcTemplate;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableValue;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableValueItem;
import com.kingdee.eas.fi.rpt.jdbc.SqlParameter;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class AcctBatchProcessor
implements ITempTableSQLProcessor,
ITableAlias {
    private static final String GENERAL_ASST_ACT_TYPE = "T_BD_GeneralAsstActType";
    private static final String NVARCHAR_250 = "nvarchar(250)";
    private static final String NVARCHAR_80 = "nvarchar(80)";
    private int batchSize;
    private AbstractAcctSortState sortState;
    private AcctCombineState combineState;
    private String[] indexFiled;
    private List multiUnpostedParams;
    private boolean isUseTempTableScheme;
    private TempTableField tempTableField;
    private ITempTableValueInsertProcessor tempTableValueInsertProcessor;
    private boolean isA_AcctJoin = false;
    protected Map tableAliases = new HashMap();
    protected boolean isCalcByPriorityAccount = false;
    protected StringBuffer sqlByAsst = new StringBuffer();
    protected StringBuffer groupByAsst = new StringBuffer();
    protected StringBuffer createTmpSqlByAsst = new StringBuffer();
    protected StringBuffer innerSqlByAsst = new StringBuffer();
    protected StringBuffer insertSqlByAsst = new StringBuffer();
    protected String tmpSelectField = null;
    protected String filterTable = null;
    protected Map<String, Set<String>> inFieldMap = new HashMap<String, Set<String>>();
    protected StringBuffer inFilter = new StringBuffer();

    public AcctBatchProcessor(int batchSize, boolean isUseTempTableScheme) {
        this.batchSize = batchSize;
        this.combineState = new AcctCombineState();
        this.isUseTempTableScheme = isUseTempTableScheme;
    }

    @Override
    public void setSortState(IBatchSQLSortState sortState) {
        this.sortState = (AbstractAcctSortState)sortState;
        this.indexFiled = this.innerBuildIndexFiled();
        if (this.isUseTempTableScheme()) {
            this.tempTableField = this.innerGetTempTableField();
            this.tempTableValueInsertProcessor = new DefaultTempTableValueInsertProcessor();
        }
        this.isCalcByPriorityAccount = this.sortState.isCalcByPriorityAccount();
        this.combineState.setSortState(this.sortState);
        this.inFieldMap.clear();
        this.inFilter.setLength(0);
    }

    private String[] innerBuildIndexFiled() {
        ArrayList<String> indexedFields = new ArrayList<String>();
        if (this.sortState.getCompanyID() == null) {
            indexedFields.add("CompanyID");
            if (this.sortState.isNeedAccountTable()) {
                indexedFields.add("AccountTableID");
            }
        }
        if (this.sortState.getAccounts() == null) {
            indexedFields.add("AccountID");
        }
        if (this.sortState.getSingleAsstActItems() != null) {
            for (String[] asstitem : this.sortState.getSingleAsstActItems()) {
                if ((asstitem[1] == "FLongNumber" || this.isItemHasWildcar(asstitem)) && !this.isUseTempTableScheme()) continue;
                String tableAlias = AcctUtils.validateTableAlias(asstitem[0]);
                indexedFields.add("AsstActItem" + tableAlias);
            }
        }
        String[] result = new String[indexedFields.size()];
        indexedFields.toArray(result);
        return result;
    }

    @Override
    public IFormulaCombinationPreparedState getCombineState() {
        return this.combineState;
    }

    @Override
    public Object[][] getIndexFormulaFields(IFormulaCalculator formula) {
        AcctCalculaterExt acct = (AcctCalculaterExt)formula;
        ArrayList<String> fields = new ArrayList<String>();
        if (this.sortState.getCompanyID() == null) {
            fields.add(acct.getCompany().getId().toString());
            if (this.sortState.isNeedAccountTable()) {
                fields.add(acct.getAccountTable().getId().toString());
            }
        }
        if (this.sortState.getAccounts() == null) {
            if (this.sortState.isBizCompany()) {
                fields.add(acct.getAccountItem().startAccount.account.id);
            } else {
                fields.add(acct.getAccountItem().startAccount.account.number);
            }
        }
        if (this.sortState.getSingleAsstActItems() != null) {
            for (String[] asstitem : this.sortState.getSingleAsstActItems()) {
                AssistantItem item = acct.getAccountItem().getItem(asstitem[0]);
                if (asstitem[1] != "FLongNumber" && !this.isItemHasWildcar(asstitem) && !this.isUseTempTableScheme()) {
                    fields.add(item.startItem.number);
                }
                if (!this.isUseTempTableScheme()) continue;
                if (asstitem[1] == "FLongNumber") {
                    if (!item.startItem.isHasWildcar) {
                        fields.add(item.startItem.longNumber);
                        continue;
                    }
                    fields.add(item.startItem.longNumber.replace('*', '_'));
                    continue;
                }
                if (!item.startItem.isHasWildcar) {
                    fields.add(item.startItem.number);
                    continue;
                }
                fields.add(item.startItem.number.replace('*', '_'));
            }
        }
        Object[][] result = new Object[1][fields.size()];
        result[0] = fields.toArray();
        return result;
    }

    @Override
    public String[] getIndexResultSetFields() {
        return this.indexFiled;
    }

    @Override
    public int getMaxSQLVaribleSize() {
        return this.batchSize;
    }

    @Override
    public void prepareStateForCombine(IRowSet rs, IFormulaCombinationPreparedState combineState) throws SQLException {
        AcctCombineState acctCombineState = (AcctCombineState)combineState;
        acctCombineState.refresh();
        ResultSetMetaData metaData = rs.getMetaData();
        acctCombineState.putValue(metaData.getColumnName(1).toUpperCase(Locale.ENGLISH), rs.getObject(1));
        if (metaData.getColumnCount() > 1) {
            acctCombineState.putValue(metaData.getColumnName(2).toUpperCase(Locale.ENGLISH), rs.getObject(2));
        }
        if (metaData.getColumnCount() > 2 && metaData.getColumnName(3).toUpperCase(Locale.ENGLISH).equals("DC")) {
            acctCombineState.putValue(metaData.getColumnName(3).toUpperCase(Locale.ENGLISH), rs.getObject(3));
        }
        if (this.sortState.getSingleAsstActItems() != null) {
            for (String[] asstitem : this.sortState.getSingleAsstActItems()) {
                if (this.isUseTempTableScheme() || !"FLongNumber".equalsIgnoreCase(asstitem[1]) && (!"FNumber".equalsIgnoreCase(asstitem[1]) || !this.isItemHasWildcar(asstitem))) continue;
                String tableAlias = AcctUtils.validateTableAlias(asstitem[0]);
                acctCombineState.putAsstNumber(asstitem[0], rs.getString("AsstActItem" + tableAlias));
                acctCombineState.setAsstSelectField(asstitem[0], asstitem[1]);
            }
        }
    }

    @Override
    public void buildSelectPart(Set nullSet, StringBuffer sql) {
        this.clearIsCalcByPriorityAccount();
        sql.append(" Select ");
        if (this.sortState instanceof AcctBalanceState) {
            sql.append(((AcctBalanceState)this.sortState).getSumPart(this.sortState.getCurrencyNumber(), this.hasA_AcctTable()));
        } else {
            sql.append(this.sortState.getSumPart(this.sortState.getCurrencyNumber()));
        }
        this.buildSelectSumByAsst(sql);
        if (this.sortState.getCompanyID() == null) {
            sql.append(" ,A_Bal.").append(this.sortState.getOrgUnitDBField()).append(" CompanyID ");
            this.buildSelectFieldByAsst("CompanyID", "varchar(44)", null);
            if (this.sortState.isNeedAccountTable()) {
                sql.append(",A_AcctLeaf.FAccountTableID AccountTableID ");
                this.buildSelectFieldByAsst("AccountTableID", "varchar(44)", null);
            }
        }
        if (this.sortState.getAccounts() == null) {
            TempTableFieldItem tempTableFieldItem;
            if (this.sortState.isNotLeafAsstAccount() || this.sortState.isNeedSubAccount()) {
                if (this.sortState.isBizCompany()) {
                    if (!this.isUseTempTableScheme()) {
                        sql.append(",A_Acct.FID AccountID ");
                    } else {
                        tempTableFieldItem = this.tempTableField.getTempTableFieldItem("A_Acct.FID");
                        sql.append(",tempTable.").append(tempTableFieldItem.getTempTableField()).append(" AccountID ");
                        this.buildSelectFieldByAsst("AccountID", "varchar(44)", tempTableFieldItem.getTempTableField());
                        if (this.isCalcByPriorityAccount()) {
                            this.tmpSelectField = tempTableFieldItem.getTempTableField();
                        }
                    }
                } else {
                    sql.append(",A_Acct.FNumber AccountID ");
                    this.buildSelectFieldByAsst("AccountID", "nvarchar(120)", null);
                }
            } else if (this.sortState.isBizCompany()) {
                sql.append(" ,A_Bal.FAccountID AccountID  ");
                this.buildSelectFieldByAsst("AccountID", "varchar(44)", null);
                if (this.isCalcByPriorityAccount() && (tempTableFieldItem = this.tempTableField.getTempTableFieldItem("A_Bal.FAccountID")) != null) {
                    this.tmpSelectField = tempTableFieldItem.getTempTableField();
                }
            } else {
                sql.append(",A_AcctLeaf.FNumber AccountID ");
                this.buildSelectFieldByAsst("AccountID", "nvarchar(120)", null);
            }
        }
        if (this.sortState.getSingleAsstActItems() != null) {
            for (String[] asstitem : this.sortState.getSingleAsstActItems()) {
                String tableAlias = AcctUtils.validateTableAlias(asstitem[0]);
                String asstTypeField = "A_AsstType" + tableAlias + "." + asstitem[1];
                if (!this.isUseTempTableScheme()) {
                    sql.append(" , ").append(asstTypeField);
                } else {
                    TempTableFieldItem tempTableFieldItem = this.tempTableField.getTempTableFieldItem(asstTypeField);
                    if (this.isCalcByPriorityAccount()) {
                        sql.append(" ,").append(asstTypeField);
                        this.buildSelectFieldByAsst("AsstActItem" + tableAlias, "nvarchar(120)", null);
                    } else {
                        sql.append(" , tempTable.").append(tempTableFieldItem.getTempTableField());
                    }
                }
                sql.append(" AsstActItem").append(tableAlias);
            }
        }
    }

    public boolean hasA_AcctTable() {
        return (this.sortState.isNotLeafAsstAccount() || this.sortState.isNeedSubAccount()) && (!this.isUseTempTableScheme() || this.isUseTempTableScheme() && (!this.sortState.isBizCompany() || this.sortState.getAccounts() != null) || this.isUseTempTableScheme() && this.isSubAccount(this.sortState)) || this.isUseTempTableScheme() && this.isNotAcctJoin();
    }

    public boolean isNotAcctJoin() {
        Boolean join;
        TempTableFieldItem tempTableFieldItem = this.tempTableField.getTempTableFieldItem("A_Acct.FID");
        return this.tempTableField.getTempTableFieldItem("A_AcctLeaf.FID") != null && tempTableFieldItem != null && (join = (Boolean)tempTableFieldItem.getProperty("join")) != null && join == false && "B".equals(this.sortState.getBalPairType());
    }

    @Override
    public void buildFromPart(Set nullSet, StringBuffer sql) {
        sql.append(" From ");
        if (this.sortState.isMultiUnPosted()) {
            List multiUnPostedParams = this.innerBuildMultiUnPostedView(sql);
            this.setMultiUnpostedParams(multiUnPostedParams);
        } else {
            sql.append(this.sortState.getBalTableName());
            sql.append(" A_Bal ");
        }
        if (this.sortState.isNotLeafAsstAccount() || this.sortState.isNeedSubAccount()) {
            sql.append(" inner join T_BD_AccountView A_AcctLeaf on A_Bal.FAccountID = A_AcctLeaf.FID ");
            if (!this.isUseTempTableScheme() || this.isUseTempTableScheme() && (!this.sortState.isBizCompany() || this.sortState.getAccounts() != null) || this.isUseTempTableScheme() && this.isSubAccount(this.sortState)) {
                sql.append(" inner join T_BD_AccountView A_Acct on  A_Acct.FCompanyID = A_AcctLeaf.FCompanyID and A_Acct.FAccountTableID = A_AcctLeaf.FAccountTableID ");
                sql.append(" and A_AcctLeaf.FNumber like concat(A_Acct.FNumber,'%') ");
                this.isA_AcctJoin = true;
            }
        } else if (this.sortState.getAccounts() != null || !this.sortState.isBizCompany() || this.sortState.isNeedAccountViewForDC() || this.sortState.isNeedAccountViewForMeasureUnit()) {
            sql.append(" inner join T_BD_AccountView A_AcctLeaf on A_Bal.FAccountID = A_AcctLeaf.FID ");
        }
        if (this.sortState.isForMeasureUnit()) {
            sql.append(" inner join T_BD_MeasureUnit unit on unit.Fid = A_AcctLeaf.FMeasureUnitID ");
        }
        if (!this.sortState.isBizCompany()) {
            sql.append(" inner join ").append(this.sortState.getOrgUnitDBTable()).append(" company on A_Bal.").append(this.sortState.getOrgUnitDBField()).append(" = company.FID ");
        }
        if (this.sortState.getAsstActTypeList() != null) {
            sql.append(" inner join T_BD_AssistantHG A_Hg on A_Bal.FAssistGrpID = A_Hg.fid   \n");
            int aliasIndex = 0;
            for (AsstActType itemType : this.sortState.getAsstActTypeList()) {
                String tableAlias = AcctUtils.validateTableAlias(itemType.number);
                sql.append(" inner join ");
                if (itemType.realtionDataObject.equalsIgnoreCase(GENERAL_ASST_ACT_TYPE)) {
                    sql.append(" (select * from ").append(itemType.realtionDataObject).append(" where FGroupID='");
                    sql.append(itemType.glAsstActTypeGrpID).append("') ");
                } else {
                    sql.append(itemType.realtionDataObject);
                }
                sql.append(" A_AsstType").append(tableAlias).append(" on A_Hg.").append(itemType.mappingFieldName).append("=").append("A_AsstType").append(tableAlias).append(".FID  ");
                this.addTableAlias("A_AsstType" + aliasIndex++, "A_AsstType" + tableAlias);
            }
            if (this.sortState.getGroupMap() != null) {
                for (AsstActType itemType : this.sortState.getAsstActTypeList()) {
                    AssistantGroup[] groups = (AssistantGroup[])this.sortState.getGroupMap().get(itemType.number);
                    if (groups == null || groups.length <= 0) continue;
                    this.buildAssistantGroupFromPart(sql, itemType, groups);
                }
            }
        }
        if (this.sortState.getFromPart() != null) {
            sql.append(this.sortState.getFromPart());
        }
    }

    private List innerBuildMultiUnPostedView(StringBuffer sql) {
        boolean isAsstTable;
        boolean bl = isAsstTable = "T_GL_AssistBalance_1F".equalsIgnoreCase(this.sortState.getBalTableName()) || "T_GL_AssistBalance_1L".equalsIgnoreCase(this.sortState.getBalTableName()) || "T_GL_AssistBalance_1R".equalsIgnoreCase(this.sortState.getBalTableName()) || "T_GL_AssistBalance_5F".equalsIgnoreCase(this.sortState.getBalTableName()) || "T_GL_AssistBalance_5L".equalsIgnoreCase(this.sortState.getBalTableName()) || "T_GL_AssistBalance_5R".equalsIgnoreCase(this.sortState.getBalTableName()) || "".equalsIgnoreCase(this.sortState.getBalTableName());
        if (this.isProfitRpt()) {
            isAsstTable = "T_PCA_PcAssistBalance_1F".equalsIgnoreCase(this.sortState.getBalTableName()) || "T_PCA_PcAssistBalance_1L".equalsIgnoreCase(this.sortState.getBalTableName()) || "T_PCA_PcAssistBalance_1R".equalsIgnoreCase(this.sortState.getBalTableName()) || "T_PCA_PcAssistBalance_5F".equalsIgnoreCase(this.sortState.getBalTableName()) || "T_PCA_PcAssistBalance_5L".equalsIgnoreCase(this.sortState.getBalTableName()) || "T_PCA_PcAssistBalance_5R".equalsIgnoreCase(this.sortState.getBalTableName()) || "".equalsIgnoreCase(this.sortState.getBalTableName());
        }
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append(" ( ");
        if (!AcctUtils.isAccumulateType(this.sortState.getBalType()) || this.sortState.getStartPeriod() != 1) {
            sql.append("Select  ").append(this.sortState.getUnPostedBalanceSelectPart(this.sortState.getCurrencyNumber()));
            if (isAsstTable) {
                sql.append(",BalancePart.FAssistGrpID FAssistGrpID ");
            }
            sql.append(" From ").append(this.sortState.getBalTableName()).append(" BalancePart ");
            if ("QJL_QDL".equals(this.sortState.getBalPairType())) {
                if (this.isFIRpt()) {
                    sql.append(" inner join T_BD_AccountView A_AcctLeaf on BalancePart.FAccountID = A_AcctLeaf.FID and A_AcctLeaf.FCompanyID = BalancePart.").append(this.sortState.getOrgUnitDBField()).append("  ");
                } else {
                    sql.append(" inner join T_BD_AccountView A_AcctLeaf on BalancePart.FAccountID = A_AcctLeaf.FID and A_AcctLeaf.FCompanyID = BalancePart.FOrgUnitId  ");
                }
            }
            if (this.sortState.getCompanyID() != null && !this.sortState.isBizCompany()) {
                sql.append(" inner join ").append(this.sortState.getOrgUnitDBTable()).append(" inner_comp ");
                sql.append(" on inner_comp.fid = BalancePart.").append(this.sortState.getOrgUnitDBField()).append(" ");
            }
            sql.append(" where BalancePart.FPeriod = ? ");
            params.add(Integer.valueOf(RptUtil.getYearPeriod(this.sortState.getCurrentPeriod().getPeriodYear(), this.sortState.getCurrentPeriod().getPeriodNumber(), this.sortState.getCurrentPeriod().getPeriodYear(), this.sortState.getCurrentPeriod().getPeriodNumber())));
            if (!"GLC".equals(this.sortState.getCurrencyNumber()) && !"GRC".equals(this.sortState.getCurrencyNumber())) {
                sql.append(" and BalancePart.FCurrencyId = ? \n");
                params.add(this.sortState.getCurrencyID());
            }
            if (this.sortState.getCompanyID() != null && !this.sortState.isBizCompany()) {
                sql.append(" and inner_comp.FLongNumber like ? and inner_comp.FIsbizunit = 1 ");
                params.add(this.sortState.getCompanyID() + "!%");
            } else if (this.sortState.getCompanyID() != null) {
                sql.append(" and BalancePart.").append(this.sortState.getOrgUnitDBField()).append(" = ? ");
                params.add(this.sortState.getCompanyID());
            }
            sql.append(" Union All ");
        }
        sql.append(" Select  ").append(this.sortState.getUnPostedAccrualSelectPart(this.sortState.getCurrencyNumber()));
        if ("SY_SL".equals(this.sortState.getBalPairType())) {
            // empty if block
        }
        if (isAsstTable) {
            sql.append(",AccrualPart.FAssistGrpID FAssistGrpID ");
        }
        sql.append(" From ").append(this.sortState.getBalTableName()).append(" AccrualPart ");
        if (AcctUtils.getPairType(this.sortState.getBalType()) == "QJL_QDL" || AcctUtils.getPairType(this.sortState.getBalType()) == "QB") {
            if (this.isFIRpt()) {
                sql.append(" inner join T_BD_AccountView A_AcctLeaf on AccrualPart.FAccountID = A_AcctLeaf.FID and A_AcctLeaf.FCompanyID = AccrualPart.").append(this.sortState.getOrgUnitDBField()).append("  ");
            } else {
                sql.append(" inner join T_BD_AccountView A_AcctLeaf on AccrualPart.FAccountID = A_AcctLeaf.FID and A_AcctLeaf.FCompanyID = AccrualPart.FOrgUnitId  ");
            }
        }
        if (this.sortState.getCompanyID() != null && !this.sortState.isBizCompany()) {
            sql.append(" inner join ").append(this.sortState.getOrgUnitDBTable()).append(" inner_comp ");
            sql.append(" on inner_comp.fid = AccrualPart.").append(this.sortState.getOrgUnitDBField()).append(" ");
        }
        sql.append(" where   ");
        if (!"GLC".equals(this.sortState.getCurrencyNumber()) && !"GRC".equals(this.sortState.getCurrencyNumber())) {
            sql.append(" AccrualPart.FCurrencyId = ? \n");
            params.add(this.sortState.getCurrencyID());
            sql.append(" and ");
        }
        if (this.sortState.getCompanyID() != null && !this.sortState.isBizCompany()) {
            sql.append(" inner_comp.FLongNumber like ? and inner_comp.FIsbizunit = 1 ");
            params.add(this.sortState.getCompanyID() + "!%");
        } else if (this.sortState.getCompanyID() != null) {
            sql.append(" AccrualPart.").append(this.sortState.getOrgUnitDBField()).append(" = ? ");
            params.add(this.sortState.getCompanyID());
        }
        this.innerBuildPeriodCondition(sql, params, "AccrualPart");
        sql.append(" ) A_Bal ");
        return params;
    }

    private void buildAssistantGroupFromPart(StringBuffer sql, AsstActType itemType, AssistantGroup[] groups) {
        String tableAlias = AcctUtils.validateTableAlias(itemType.number);
        if ("T_BD_CUSTOMER".equalsIgnoreCase(itemType.realtionDataObject) || "T_BD_SUPPLIER".equalsIgnoreCase(itemType.realtionDataObject) || "T_BD_Material".equalsIgnoreCase(itemType.realtionDataObject)) {
            String group = null;
            String groupTable = null;
            String groupDetail = null;
            if ("T_BD_CUSTOMER".equalsIgnoreCase(itemType.realtionDataObject)) {
                group = "Customer";
                groupTable = "T_BD_CSSPGroup";
                groupDetail = "GroupDetail";
            } else if ("T_BD_Material".equalsIgnoreCase(itemType.realtionDataObject)) {
                group = "Material";
                groupTable = "T_BD_MaterialGroup";
                groupDetail = "GroupDetial";
            } else {
                group = "Supplier";
                groupTable = "T_BD_CSSPGroup";
                groupDetail = "GroupDetail";
            }
            for (int gi = 0; gi < groups.length; ++gi) {
                AssistantGroup g = groups[gi];
                sql.append(" inner join T_BD_").append(group).append(groupDetail);
                sql.append(" groupDtl").append(gi).append(" on groupDtl").append(gi).append(".F").append(group).append("ID = A_AsstType").append(tableAlias).append(".FID ");
                String groupTableAlias = AcctUtils.limitTableAliasLength("group" + tableAlias + "_" + g.standardNumber);
                sql.append(" inner join ").append(groupTable).append(" ").append(groupTableAlias);
                sql.append(" on groupDtl").append(gi).append(".F").append(group).append("GroupID = ").append(groupTableAlias).append(".FID ");
            }
        } else {
            sql.append(" inner join ").append(itemType.groupTableName).append(" Group").append(tableAlias);
            sql.append(" on ").append("A_AsstType").append(tableAlias).append(itemType.groupMappingFieldName);
            sql.append(" = ").append(" Group").append(tableAlias).append(".FID ");
        }
    }

    @Override
    public void builderConstantWherePart(Set nullSet, StringBuffer sql, List params) {
        String tableAlias;
        if (this.sortState.isMultiUnPosted()) {
            params.addAll(this.getMultiUnpostedParams());
        }
        if ("GLC".equals(this.sortState.getCurrencyNumber()) || "GRC".equals(this.sortState.getCurrencyNumber())) {
            sql.append(" Where ");
        } else {
            sql.append(" Where A_Bal.FCurrencyID = ? ");
            params.add(this.sortState.getCurrencyID());
            sql.append(" and ");
        }
        if (this.sortState.getCompanyID() != null && !this.sortState.isBizCompany()) {
            sql.append(" company.FLongNumber like ? and company.FIsbizunit = 1 ");
            params.add(this.sortState.getCompanyID() + "!%");
            if (this.isFIRpt()) {
                sql.append(" and A_AcctLeaf.FCompanyID = company.FID ");
            } else if (this.sortState.getDelegetedCompanyId() != null) {
                // empty if block
            }
            if (this.sortState.isNeedAccountTable()) {
                sql.append(" and A_AcctLeaf.FAccountTableID = ? ");
                params.add(this.sortState.getAccountTableID());
            }
        } else if (this.sortState.getCompanyID() != null) {
            sql.append(" A_Bal.").append(this.sortState.getOrgUnitDBField()).append(" = ? ");
            params.add(this.sortState.getCompanyID());
            if (this.sortState.isNeedAccountTable()) {
                sql.append(" and A_AcctLeaf.FAccountTableID = ? ");
                params.add(this.sortState.getAccountTableID());
            }
        }
        if (!this.sortState.isMultiUnPosted()) {
            this.innerBuildPeriodCondition(sql, params, "A_Bal");
        }
        if (this.isSubAccount(this.sortState)) {
            sql.append(" and A_AcctLeaf.FLevel = A_Acct.FLevel + 1 ");
        } else if (this.isLeafAccount(this.sortState)) {
            sql.append(" and A_AcctLeaf.FIsLeaf = 1 ");
        }
        if (this.sortState.getAccounts() != null) {
            String[] accounts = this.sortState.getAccounts();
            String accountTableName = "A_AcctLeaf";
            if (this.sortState.isNotLeafAsstAccount() || this.sortState.isNeedSubAccount()) {
                accountTableName = "A_Acct";
                sql.append(" and A_Acct.FNumber >= ? and A_Acct.FNumber <= ? and A_Acct.FLevel = ? ");
                params.add(accounts[0]);
                params.add(accounts[1]);
                params.add(new Integer(accounts[2]));
            } else if (this.sortState.getAsstActTypeList() != null && this.sortState.getAsstActTypeList().size() > 0) {
                sql.append(" and (A_AcctLeaf.FNumber >= ? and A_AcctLeaf.FNumber <= ? or A_AcctLeaf.FNumber like ?) and A_AcctLeaf.FIsLeaf = 1 ");
                params.add(accounts[0]);
                params.add(accounts[1]);
                params.add(accounts[1] + "%");
            } else {
                sql.append(" and A_AcctLeaf.FNumber >= ? and A_AcctLeaf.FNumber <= ? and A_AcctLeaf.FLevel = ? ");
                params.add(accounts[0]);
                params.add(accounts[1]);
                params.add(new Integer(accounts[2]));
            }
            if (this.sortState.getCompanyID() != null && this.sortState.isBizCompany()) {
                sql.append(" and ").append(accountTableName).append(".fcompanyid = ? ");
                params.add(this.sortState.getCompanyID());
            }
        }
        if (this.sortState.getAsstActTypeList() != null) {
            for (int i = 0; i < this.sortState.getAsstActTypeList().size(); ++i) {
                AsstActType item = (AsstActType)this.sortState.getAsstActTypeList().get(i);
                tableAlias = AcctUtils.validateTableAlias(item.number);
                if (!item.realtionDataObject.equalsIgnoreCase(GENERAL_ASST_ACT_TYPE)) continue;
                sql.append(" and A_AsstType").append(tableAlias).append(".FGroupID=? ");
                params.add(item.glAsstActTypeGrpID);
            }
        }
        if (this.sortState.getAsstActItems() != null) {
            for (String[] asstActItem : this.sortState.getAsstActItems()) {
                tableAlias = AcctUtils.validateTableAlias(asstActItem[0]);
                sql.append(" and (A_AsstType").append(tableAlias).append(".").append(asstActItem[3]).append(" >= ? and A_AsstType").append(tableAlias).append(".").append(asstActItem[3]).append(" <= ?");
                params.add(asstActItem[1]);
                if (Boolean.valueOf(asstActItem[4]).booleanValue() && "FNumber".equalsIgnoreCase(asstActItem[3])) {
                    params.add(asstActItem[2] + "~");
                } else {
                    params.add(asstActItem[2]);
                }
                if ("FLongNumber".equalsIgnoreCase(asstActItem[3])) {
                    sql.append(" or A_AsstType").append(tableAlias).append(".").append(asstActItem[3]).append(" like ?)");
                    params.add(asstActItem[2] + "!%");
                    continue;
                }
                sql.append(")");
            }
        }
        if (this.sortState.getAsstActTypeList() != null && this.sortState.getGroupMap() != null) {
            for (AsstActType itemType : this.sortState.getAsstActTypeList()) {
                AssistantGroup[] groups = (AssistantGroup[])this.sortState.getGroupMap().get(itemType.number);
                if (groups == null || groups.length <= 0) continue;
                this.buildAssistanGroupWherePart(sql, params, itemType, groups);
            }
        }
        if (!this.isUseTempTableScheme()) {
            sql.append(" and ( ");
        }
    }

    private void innerBuildPeriodCondition(StringBuffer sql, List params, String balTableAlias) {
        String periodAlias = null;
        periodAlias = !this.isUseTempTableScheme() && !this.sortState.isMultiUnPosted() ? "A_Bal" : (this.sortState.isMultiUnPosted() ? "AccrualPart" : "A_Bal");
        sql.append(" and ").append(periodAlias).append(".FPeriod in (").append(RptUtil.getYearPeriod(this.sortState.getStartYear(), this.sortState.getStartPeriod(), this.sortState.getEndYear(), this.sortState.getEndPeriod())).append(")");
    }

    protected boolean isProfitRpt() {
        return OrgType.ProfitCenter.equals((Object)this.sortState.getRptOrgType());
    }

    protected boolean isFIRpt() {
        return OrgType.Company.equals((Object)this.sortState.getRptOrgType());
    }

    private void buildAssistanGroupWherePart(StringBuffer sql, List params, AsstActType itemType, AssistantGroup[] groups) {
        String tableAlias = AcctUtils.validateTableAlias(itemType.number);
        if ("T_BD_CUSTOMER".equalsIgnoreCase(itemType.realtionDataObject) || "T_BD_SUPPLIER".equalsIgnoreCase(itemType.realtionDataObject) || "T_BD_Material".equalsIgnoreCase(itemType.realtionDataObject)) {
            for (int gi = 0; gi < groups.length; ++gi) {
                AssistantGroup g = groups[gi];
                String gp = AcctUtils.limitTableAliasLength("group" + tableAlias + "_" + g.standardNumber);
                if (groups[gi].isSingleGroup()) {
                    sql.append(" and (").append(gp).append(".FLongNumber = ? or ").append(gp).append(".FLongNumber like ?)");
                    params.add(g.getStartGroup().longNumber);
                    params.add(g.getStartGroup().longNumber + "!%");
                } else {
                    sql.append("and (").append(gp).append(".FLongNumber >= ? and (").append(gp).append(".FLongNumber <= ? or ").append(gp).append(".FLongNumber like ? ))");
                    params.add(g.getStartGroup().longNumber);
                    params.add(g.getEndGroup().longNumber);
                    params.add(g.getEndGroup().longNumber + "!%");
                }
                if ("T_BD_Material".equalsIgnoreCase(itemType.realtionDataObject)) {
                    sql.append(" AND ").append(gp).append(".FGroupStandard = ? ");
                } else {
                    sql.append(" AND ").append(gp).append(".FCSSPGroupStandardID = ? ");
                }
                params.add(g.standardID);
            }
        } else {
            AssistantGroup g = groups[0];
            if (g.isSingleGroup()) {
                sql.append(" and ( Group").append(tableAlias).append(".FLongNumber = ? or Group").append(tableAlias).append(".FLongNumber like ? )");
                params.add(g.getStartGroup().longNumber);
                params.add(g.getStartGroup().longNumber + "!%");
            } else {
                if (g.getStartGroup().longNumber.length() > 0) {
                    sql.append(" and  Group").append(tableAlias).append(".FLongNumber >= ? ");
                    params.add(g.getStartGroup().longNumber);
                }
                if (g.getEndGroup().longNumber.length() > 0) {
                    sql.append(" and  (Group").append(tableAlias).append(".FLongNumber <= ? or Group").append(tableAlias).append(".FLongNumber like ? )");
                    params.add(g.getEndGroup().longNumber);
                    params.add(g.getEndGroup().longNumber + "!%");
                }
            }
        }
    }

    @Override
    public void buildVariableWherePart(StringBuffer sql, List params, IFormulaCalculator formula) {
        AcctCalculaterExt acct = (AcctCalculaterExt)formula;
        boolean isFirst = true;
        sql.append("(");
        if (this.sortState.getCompanyID() == null) {
            if (isFirst) {
                isFirst = false;
            } else {
                sql.append(" and ");
            }
            sql.append("  A_Bal.").append(this.sortState.getOrgUnitDBField()).append(" = ? ");
            params.add(acct.getCompany().getId().toString());
            if (this.sortState.isNeedAccountTable()) {
                sql.append(" and A_AcctLeaf.FAccountTableID = ? ");
                params.add(acct.getAccountTable().getId().toString());
            }
        }
        if (this.sortState.getAccounts() == null) {
            if (isFirst) {
                isFirst = false;
            } else {
                sql.append(" and ");
            }
            if (this.sortState.isNotLeafAsstAccount() || this.sortState.isNeedSubAccount()) {
                if (this.sortState.isBizCompany()) {
                    sql.append(" A_Acct.FID = ? ");
                    params.add(acct.getAccountItem().startAccount.account.id);
                } else {
                    sql.append(" A_Acct.FNumber = ? ");
                    params.add(acct.getAccountItem().startAccount.account.number);
                }
            } else if (this.sortState.isBizCompany()) {
                sql.append(" A_Bal.FAccountID = ? ");
                params.add(acct.getAccountItem().startAccount.account.id);
            } else {
                sql.append(" A_AcctLeaf.FNumber = ? ");
                params.add(acct.getAccountItem().startAccount.account.number);
            }
        }
        if (this.sortState.getSingleAsstActItems() != null) {
            Iterator iterator = this.sortState.getSingleAsstActItems().iterator();
            while (iterator.hasNext()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sql.append(" and ");
                }
                String[] assistantItem = (String[])iterator.next();
                AssistantItem asstItem = acct.getAccountItem().getItem(assistantItem[0]);
                String tableAlias = AcctUtils.validateTableAlias(assistantItem[0]);
                if (assistantItem[1] == "FLongNumber") {
                    if (asstItem.startItem.isHasWildcar) {
                        sql.append(" (A_AsstType").append(tableAlias).append(".FLongNumber like ? or A_AsstType").append(tableAlias).append(".FLongNumber like ? ) ");
                        params.add(asstItem.startItem.longNumber.replace('*', '_'));
                        params.add(asstItem.startItem.longNumber.replace('*', '_') + "!%");
                        continue;
                    }
                    sql.append(" (A_AsstType").append(tableAlias).append(".FLongNumber = ? or A_AsstType").append(tableAlias).append(".FLongNumber like ? ) ");
                    params.add(asstItem.startItem.longNumber);
                    params.add(asstItem.startItem.longNumber + "!%");
                    continue;
                }
                if (asstItem.startItem.isHasWildcar) {
                    sql.append(" (A_AsstType").append(tableAlias).append(".FNumber like ?) ");
                    params.add(asstItem.startItem.number.replace('*', '_'));
                    continue;
                }
                sql.append("  A_AsstType").append(tableAlias).append(".FNumber = ? ");
                params.add(asstItem.startItem.number);
            }
        }
        if (isFirst) {
            sql.append(" 0 = ? ");
            params.add(CslConstant.BGZERO);
        }
        sql.append(")");
    }

    private boolean isItemHasWildcar(String[] assistantItem) {
        return Boolean.valueOf(assistantItem[2]);
    }

    @Override
    public void buildGroupByPart(Set nullSet, StringBuffer sql) {
        if (!this.isUseTempTableScheme()) {
            sql.append(") ");
        }
        boolean isFirst = true;
        StringBuffer groupBy = new StringBuffer();
        if (this.sortState.getCompanyID() == null) {
            if (isFirst) {
                isFirst = false;
            } else {
                groupBy.append(",");
            }
            groupBy.append(" A_Bal.").append(this.sortState.getOrgUnitDBField()).append(" ");
            if (this.sortState.isNeedAccountTable()) {
                groupBy.append(",A_AcctLeaf.FAccountTableID ");
            }
        }
        if (this.sortState.getAccounts() == null) {
            if (isFirst) {
                isFirst = false;
            } else {
                groupBy.append(",");
            }
            if (this.sortState.isNotLeafAsstAccount() || this.sortState.isNeedSubAccount()) {
                if (this.sortState.isBizCompany()) {
                    if (!this.isUseTempTableScheme()) {
                        groupBy.append("A_Acct.FID ");
                    } else {
                        TempTableFieldItem tempTableFieldItem = this.tempTableField.getTempTableFieldItem("A_Acct.FID");
                        groupBy.append("tempTable.").append(tempTableFieldItem.getTempTableField());
                    }
                } else {
                    groupBy.append("A_Acct.FNumber ");
                }
            } else if (this.sortState.isBizCompany()) {
                groupBy.append("A_Bal.FAccountID  ");
            } else {
                groupBy.append("A_AcctLeaf.FNumber ");
            }
        }
        if (this.sortState.getSingleAsstActItems() != null) {
            Iterator iterator = this.sortState.getSingleAsstActItems().iterator();
            while (iterator.hasNext()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    groupBy.append(",");
                }
                String[] asstitem = (String[])iterator.next();
                String tableAlias = AcctUtils.validateTableAlias(asstitem[0]);
                String asstTypeField = "A_AsstType" + tableAlias + "." + asstitem[1];
                if (!this.isUseTempTableScheme()) {
                    groupBy.append(asstTypeField);
                    continue;
                }
                TempTableFieldItem tempTableFieldItem = this.tempTableField.getTempTableFieldItem(asstTypeField);
                if (this.isCalcByPriorityAccount()) {
                    groupBy.append(asstTypeField);
                    continue;
                }
                groupBy.append("tempTable.").append(tempTableFieldItem.getTempTableField());
            }
        }
        if (this.sortState.isNeedAccountViewForDC() || this.sortState.isAccountsForDC() || this.sortState.isNeedAccountViewForDCByQB() || this.sortState.isAccountsForDCByisNotLeafAsstAccount() || "QB".equals(this.sortState.getBalType())) {
            if (isFirst) {
                isFirst = false;
            } else {
                groupBy.append(",");
            }
            if ("B".equals(this.sortState.getBalType()) && this.hasA_AcctTable()) {
                groupBy.append("A_Acct.FDC ");
            } else {
                groupBy.append("A_AcctLeaf.FDC ");
            }
        }
        if (this.sortState.getGroupByPart() != null) {
            if (isFirst) {
                isFirst = false;
            } else {
                groupBy.append(",");
            }
            groupBy.append(this.sortState.getGroupByPart());
        }
        if (!isFirst) {
            sql.append(" Group by ").append(groupBy);
        }
    }

    @Override
    public Set getAllowedNullFields() {
        return null;
    }

    @Override
    public List getFormulaCalculators() {
        return this.sortState.getFormulaList();
    }

    public List getMultiUnpostedParams() {
        return this.multiUnpostedParams;
    }

    public void setMultiUnpostedParams(List multiUnpostedParams) {
        this.multiUnpostedParams = multiUnpostedParams;
    }

    @Override
    public boolean isUseTempTableScheme() {
        return this.isUseTempTableScheme && this.sortState.isUseTempTableScheme();
    }

    public void setUseTempTableScheme(boolean isUseTempTableScheme) {
        this.isUseTempTableScheme = isUseTempTableScheme;
    }

    private boolean isSubAccount(AbstractAcctSortState sortState) {
        return sortState.isNeedSubAccount() && (sortState.isIncludeSubAccount() && sortState.getAsstActTypeList() == null || sortState.isIncludeSubAsstItem() && sortState.getAsstActTypeList() == null || !sortState.isGroupByAccount() && !sortState.isNeedSubAccountBySheetParam() && sortState.getAcctSortType() == 2);
    }

    private boolean isLeafAccount(AbstractAcctSortState sortState) {
        return sortState.isNotLeafAsstAccount() || sortState.isNeedSubAccount() && (sortState.isIncludeLeafAccount() || sortState.isIncludeLeafAsstItem() || sortState.isIncludeSubAccount() && sortState.getAsstActTypeList() != null || sortState.isIncludeSubAsstItem() && sortState.getAsstActTypeList() != null);
    }

    @Override
    public ITempTableValue insertTempTableValues(IFormulaCalculator formula) {
        AcctCalculaterExt acct = (AcctCalculaterExt)formula;
        TempTableValue tempTableValue = new TempTableValue();
        if (this.sortState.getCompanyID() == null) {
            tempTableValue.addTempTableItem(new TempTableValueItem("A_Bal." + this.sortState.getOrgUnitDBField(), acct.getCompany().getId().toString()));
            if (this.sortState.isNeedAccountTable()) {
                tempTableValue.addTempTableItem(new TempTableValueItem("A_AcctLeaf.FAccountTableID", acct.getAccountTable().getId().toString()));
            }
        }
        if (this.sortState.getAccounts() == null) {
            if (this.sortState.isNotLeafAsstAccount() || this.sortState.isNeedSubAccount()) {
                if (this.sortState.isBizCompany()) {
                    if (this.isSubAccount(this.sortState)) {
                        tempTableValue.addTempTableItem(new TempTableValueItem("A_Acct.FID", acct.getAccountItem().startAccount.account.id));
                    } else {
                        tempTableValue.addTempTableItem(new TempTableValueItem("A_Acct.FID", acct.getAccountItem().startAccount.account.id));
                        tempTableValue.addTempTableItem(new TempTableValueItem("A_AcctLeaf.FID", ""));
                    }
                    this.putField("A_Acct.FID", acct.getAccountItem().startAccount.account.id);
                } else {
                    tempTableValue.addTempTableItem(new TempTableValueItem("A_Acct.FNumber", acct.getAccountItem().startAccount.account.number));
                    this.putField("A_Acct.FNumber", acct.getAccountItem().startAccount.account.number);
                }
            } else if (this.sortState.isBizCompany()) {
                tempTableValue.addTempTableItem(new TempTableValueItem("A_Bal.FAccountID", acct.getAccountItem().startAccount.account.id));
                this.putField("A_Bal.FAccountID", acct.getAccountItem().startAccount.account.id);
            } else {
                tempTableValue.addTempTableItem(new TempTableValueItem("A_AcctLeaf.FNumber", acct.getAccountItem().startAccount.account.number));
                this.putField("A_AcctLeaf.FNumber", acct.getAccountItem().startAccount.account.number);
            }
        }
        if (this.sortState.getSingleAsstActItems() != null) {
            for (String[] assistantItem : this.sortState.getSingleAsstActItems()) {
                AssistantItem asstItem = acct.getAccountItem().getItem(assistantItem[0]);
                String tableAlias = AcctUtils.validateTableAlias(assistantItem[0]);
                if (assistantItem[1] == "FLongNumber") {
                    if (asstItem.startItem.isHasWildcar) {
                        tempTableValue.addTempTableItem(new TempTableValueItem("A_AsstType" + tableAlias + ".FLongNumber", asstItem.startItem.longNumber.replace('*', '_')));
                        continue;
                    }
                    tempTableValue.addTempTableItem(new TempTableValueItem("A_AsstType" + tableAlias + ".FLongNumber", asstItem.startItem.longNumber));
                    continue;
                }
                if (asstItem.startItem.isHasWildcar) {
                    tempTableValue.addTempTableItem(new TempTableValueItem("A_AsstType" + tableAlias + ".FNumber", asstItem.startItem.number.replace('*', '_')));
                    continue;
                }
                tempTableValue.addTempTableItem(new TempTableValueItem("A_AsstType" + tableAlias + ".FNumber", asstItem.startItem.number));
            }
        }
        return tempTableValue;
    }

    private TempTableField innerGetTempTableField() {
        TempTableField tempTableField = new TempTableField();
        if (this.sortState.getCompanyID() == null) {
            tempTableField.addTempTableItem(new TempTableFieldItem("A_Bal." + this.sortState.getOrgUnitDBField()));
            if (this.sortState.isNeedAccountTable()) {
                tempTableField.addTempTableItem(new TempTableFieldItem("A_AcctLeaf.FAccountTableID"));
            }
        }
        if (this.sortState.getAccounts() == null) {
            if (this.sortState.isNotLeafAsstAccount() || this.sortState.isNeedSubAccount()) {
                if (this.sortState.isBizCompany()) {
                    if (this.isSubAccount(this.sortState)) {
                        tempTableField.addTempTableItem(new TempTableFieldItem("A_Acct.FID"));
                    } else {
                        TempTableFieldItem tempTableFieldItem = new TempTableFieldItem("A_Acct.FID");
                        tempTableFieldItem.setProperty("join", new Boolean(false));
                        tempTableField.addTempTableItem(tempTableFieldItem);
                        tempTableField.addTempTableItem(new TempTableFieldItem("A_AcctLeaf.FID"));
                        this.tempTableValueInsertProcessor = new AcctTempTableValueInsertProcessor(this.sortState.getAccountTableID(), this.sortState.getCompanyID());
                    }
                } else {
                    tempTableField.addTempTableItem(new TempTableFieldItem("A_Acct.FNumber", new SqlParameter("FNumber", 12, NVARCHAR_80)));
                }
            } else if (this.sortState.isBizCompany()) {
                tempTableField.addTempTableItem(new TempTableFieldItem("A_Bal.FAccountID"));
            } else {
                tempTableField.addTempTableItem(new TempTableFieldItem("A_AcctLeaf.FNumber", new SqlParameter("FNumber", 12, NVARCHAR_80)));
            }
        }
        if (this.sortState.getSingleAsstActItems() != null) {
            for (String[] assistantItem : this.sortState.getSingleAsstActItems()) {
                String tableAlias = AcctUtils.validateTableAlias(assistantItem[0]);
                TempTableFieldItem fieldItem = null;
                if (assistantItem[1] == "FLongNumber") {
                    fieldItem = new TempTableFieldItem("A_AsstType" + tableAlias + ".FLongNumber", new SqlParameter("FLongNumber", 12, NVARCHAR_250));
                    tempTableField.addTempTableItem(fieldItem);
                } else {
                    fieldItem = new TempTableFieldItem("A_AsstType" + tableAlias + ".FNumber", new SqlParameter("FNumber", 12, NVARCHAR_80));
                    tempTableField.addTempTableItem(fieldItem);
                }
                if (!this.isItemHasWildcar(assistantItem)) continue;
                fieldItem.setProperty("isHasWildcar", Boolean.TRUE);
            }
        }
        return tempTableField;
    }

    @Override
    public ITempTableField getTempTableField() {
        return this.innerGetTempTableField();
    }

    @Override
    public void buildDivisionalVariableWherePart(Set nullSet, StringBuffer sql, List params) {
        if (this.inFilter.length() > 0) {
            sql.append(" ").append(this.inFilter);
        }
    }

    @Override
    public void buildInnerJoinTempTable(StringBuffer sql, String tempTableName, ITempTableField tempTableField) {
        TempTableFieldItem tempTableFieldItem;
        sql.append("\n inner join ");
        if (this.isCalcByPriorityAccount()) {
            this.filterTable = tempTableName;
        }
        StringBuffer curSql = new StringBuffer();
        StringBuffer distinctSql = new StringBuffer();
        StringBuffer tmpTableJoinAssistTableAliases = new StringBuffer();
        Iterator it = tempTableField.getTempTableFieldItems().iterator();
        while (it.hasNext()) {
            tempTableFieldItem = (TempTableFieldItem)it.next();
            Boolean join = (Boolean)tempTableFieldItem.getProperty("join");
            if (join != null && !join.booleanValue()) continue;
            String fieldName = tempTableFieldItem.getField();
            String tempTableFieldName = tempTableFieldItem.getTempTableField();
            tempTableFieldName = "tempTable." + tempTableFieldName;
            Boolean isHasWildcar = (Boolean)tempTableFieldItem.getProperty("isHasWildcar");
            if (this.isCalcByPriorityAccount() && this.buildInnerByAsst(fieldName, tempTableFieldName, isHasWildcar)) continue;
            curSql.append("(");
            if (isHasWildcar != null && isHasWildcar.booleanValue()) {
                curSql.append(fieldName).append(" like to_char(").append(tempTableFieldName).append(")");
                if (fieldName.matches("A_AsstType.+\\.FLongNumber")) {
                    curSql.append(" or ").append(fieldName).append(" like to_char(concat(").append(tempTableFieldName).append(",'!%'))");
                }
            } else {
                curSql.append(fieldName).append(" = ").append(tempTableFieldName);
                if (fieldName.matches("A_AsstType.+\\.FLongNumber")) {
                    curSql.append(" or ").append(fieldName).append(" like to_char(concat(").append(tempTableFieldName).append(",'!%'))");
                } else {
                    Set<String> fieldValues = this.inFieldMap.get(fieldName);
                    if (fieldValues != null && fieldValues.size() < 31) {
                        this.inFilter.append(" and ").append(fieldName).append(" in (").append(CslRptUtil.collection2String(fieldValues, (String)",", (boolean)true)).append(")");
                    } else if (!this.sortState.isMultiUnPosted()) {
                        this.inFilter.append(" and ").append(fieldName).append(" in (select distinct ").append(tempTableFieldItem.getTempTableField()).append(" from ").append(tempTableName).append(")");
                    }
                }
            }
            if (this.isCalcByPriorityAccount() && (this.tmpSelectField == null || this.tmpSelectField != null && !this.tmpSelectField.equalsIgnoreCase(tempTableFieldItem.getTempTableField()))) {
                distinctSql.append(tempTableFieldItem.getTempTableField()).append(",");
            }
            curSql.append(")");
            if (it.hasNext()) {
                curSql.append(" and ");
            }
            if (!fieldName.startsWith("A_AsstType")) continue;
            tmpTableJoinAssistTableAliases.append(fieldName.replaceAll("\\.[a-zA-Z0-9_]+", ""));
            tmpTableJoinAssistTableAliases.append(' ');
        }
        if (curSql.length() >= 4 && "and ".equals(curSql.substring(curSql.length() - 4))) {
            curSql.delete(curSql.length() - 4, curSql.length());
        }
        boolean isInnered = false;
        if (this.isCalcByPriorityAccount()) {
            if (this.tmpSelectField != null) {
                distinctSql.append(this.tmpSelectField);
            } else if (distinctSql.lastIndexOf(",") > 0) {
                distinctSql = distinctSql.deleteCharAt(distinctSql.lastIndexOf(","));
            }
            if (distinctSql.length() > 0) {
                sql.append("(select distinct ").append(distinctSql).append(" from ").append(tempTableName).append(") tempTable");
                sql.append(" on ").append(curSql);
                isInnered = true;
            }
        }
        if (!isInnered) {
            sql.append(tempTableName).append(" tempTable");
            sql.append(" on ").append(curSql);
        }
        if (this.isNotAcctJoin() && !this.isA_AcctJoin) {
            tempTableFieldItem = tempTableField.getTempTableFieldItem("A_Acct.FID");
            String tempTableFieldName = tempTableFieldItem.getTempTableField();
            tempTableFieldName = "tempTable." + tempTableFieldName;
            sql.append(" inner join T_BD_AccountView A_Acct on A_Acct.fid=").append(tempTableFieldName);
        }
        if (tmpTableJoinAssistTableAliases.length() > 0) {
            this.addTableAlias("A_AsstType", tmpTableJoinAssistTableAliases.toString());
        }
    }

    @Override
    public ITempTableValueInsertProcessor getTempTableValueInsertProcessor() {
        return this.tempTableValueInsertProcessor;
    }

    @Override
    public Map collectTableAlias() {
        return this.tableAliases;
    }

    protected void addTableAlias(String tableAlias, String tableName) {
        this.tableAliases.put(tableAlias.toUpperCase(), tableName.toUpperCase());
    }

    private void clearIsCalcByPriorityAccount() {
        this.sqlByAsst.setLength(0);
        this.groupByAsst.setLength(0);
        this.createTmpSqlByAsst.setLength(0);
        this.innerSqlByAsst.setLength(0);
        this.insertSqlByAsst.setLength(0);
        this.filterTable = null;
        this.tmpSelectField = null;
    }

    public void buildSelectSumByAsst(StringBuffer sql) {
        if (this.isCalcByPriorityAccount()) {
            String[] fields;
            this.sqlByAsst.append(" select ");
            this.createTmpSqlByAsst.append(" create table t_csl_Account(");
            for (String field : fields = sql.toString().split(",")) {
                String curField = field.substring(field.trim().lastIndexOf(" ") + 1);
                if (StringUtils.isEmpty((String)curField)) continue;
                curField = curField.trim();
                if (field.indexOf("SUM") >= 0) {
                    this.sqlByAsst.append(" SUM(ACCOUNTTMP.").append(curField).append(") ").append(curField);
                    this.createTmpSqlByAsst.append(curField).append(" NUMERIC(21,6)");
                } else {
                    this.sqlByAsst.append("ACCOUNTTMP.").append(curField);
                    this.createTmpSqlByAsst.append(curField).append(" int ");
                    this.groupByAsst.append("ACCOUNTTMP.").append(curField).append(",");
                }
                this.insertSqlByAsst.append(curField);
                this.sqlByAsst.append(",");
                this.createTmpSqlByAsst.append(",");
                this.insertSqlByAsst.append(",");
            }
        }
    }

    public boolean isCalcByPriorityAccount() {
        return this.isCalcByPriorityAccount && this.isUseTempTableScheme() && this.sortState.getSingleAsstActItems() != null && this.sortState.isBizCompany() && this.sortState.getAccounts() == null;
    }

    public void buildSelectFieldByAsst(String field, String type, String srcTmpField) {
        if (this.isCalcByPriorityAccount()) {
            this.sqlByAsst.append("ACCOUNTTMP.").append(field).append(",");
            this.createTmpSqlByAsst.append(field).append(" ").append(type).append(",");
            this.groupByAsst.append("ACCOUNTTMP.").append(field).append(",");
            this.insertSqlByAsst.append(field).append(",");
            if (!StringUtils.isEmpty((String)srcTmpField)) {
                if (this.innerSqlByAsst.length() > 0) {
                    this.innerSqlByAsst.append(" and ");
                }
                this.innerSqlByAsst.append("ACCOUNTTMP.").append(field).append("=tempTable.").append(srcTmpField);
            }
        }
    }

    protected boolean buildInnerByAsst(String fieldName, String tempTableFieldName, Boolean isHasWildcar) {
        boolean isAsstType = false;
        if (this.innerSqlByAsst.length() > 0) {
            this.innerSqlByAsst.append(" and ");
        }
        this.innerSqlByAsst.append("(");
        String curFieldName = null;
        if (fieldName.indexOf("A_AsstType") >= 0) {
            curFieldName = "ACCOUNTTMP.AsstActItem" + fieldName.substring("A_AsstType".length(), fieldName.indexOf("."));
            if (isHasWildcar != null && isHasWildcar.booleanValue()) {
                this.innerSqlByAsst.append(curFieldName).append(" like to_char(").append(tempTableFieldName).append(")");
                if (fieldName.matches("A_AsstType.+\\.FLongNumber")) {
                    this.innerSqlByAsst.append(" or ").append(curFieldName).append(" like to_char(concat(").append(tempTableFieldName).append(",'!%'))");
                }
            } else {
                this.innerSqlByAsst.append(curFieldName).append(" = ").append(tempTableFieldName);
                if (fieldName.matches("A_AsstType.+\\.FLongNumber")) {
                    this.innerSqlByAsst.append(" or ").append(curFieldName).append(" like to_char(concat(").append(tempTableFieldName).append(",'!%'))");
                }
            }
            isAsstType = true;
        } else {
            curFieldName = "ACCOUNTTMP.AccountID";
            if (isHasWildcar != null && isHasWildcar.booleanValue()) {
                this.innerSqlByAsst.append(curFieldName).append(" like to_char(").append(tempTableFieldName).append(")");
            } else {
                this.innerSqlByAsst.append(curFieldName).append(" = ").append(tempTableFieldName);
            }
        }
        this.innerSqlByAsst.append(")");
        return isAsstType;
    }

    public String preHandle(StringBuffer sql, List params, TempTableJdbcTemplate tempTableJdbcTemplate, boolean isTempTableSchemeDebug) throws Exception {
        String accountTable = null;
        if (this.isCalcByPriorityAccount() && this.createTmpSqlByAsst != null && this.createTmpSqlByAsst.length() > 0) {
            this.createTmpSqlByAsst.deleteCharAt(this.createTmpSqlByAsst.lastIndexOf(","));
            this.createTmpSqlByAsst.append(")");
            accountTable = isTempTableSchemeDebug ? tempTableJdbcTemplate.createTempTable(this.createTmpSqlByAsst.toString()) : tempTableJdbcTemplate.createDBSystemTempTable(this.createTmpSqlByAsst.toString());
            StringBuffer curSql = new StringBuffer();
            this.insertSqlByAsst.deleteCharAt(this.insertSqlByAsst.lastIndexOf(","));
            curSql.append(" insert into ").append(accountTable).append("(").append(this.insertSqlByAsst).append(") ");
            curSql.append(sql);
            tempTableJdbcTemplate.update(curSql.toString(), params.toArray());
            params.clear();
            sql.setLength(0);
            this.groupByAsst.deleteCharAt(this.groupByAsst.lastIndexOf(","));
            this.sqlByAsst.deleteCharAt(this.sqlByAsst.lastIndexOf(","));
            sql.append(this.sqlByAsst).append(" from ").append(accountTable).append(" ACCOUNTTMP ");
            sql.append(" inner join ").append(this.filterTable).append(" tempTable on ").append(this.innerSqlByAsst);
            sql.append(" group by ").append(this.groupByAsst);
        }
        return accountTable;
    }

    protected void putField(String field, String value) {
        Set<String> values = this.inFieldMap.get(field);
        if (values == null) {
            values = new HashSet<String>();
            this.inFieldMap.put(field, values);
        }
        if (values.size() <= 31) {
            values.add(value);
        }
    }
}

