/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acct;

import com.kingdee.eas.fi.rpt.app.AcctCalculaterExt;
import com.kingdee.eas.fi.rpt.app.AsstActType;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.acct.AbstractAcctSortState;
import com.kingdee.eas.fi.rpt.batch.acct.AcctUtils;
import com.kingdee.eas.fi.rpt.batch.acct.IAcctSortState;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import java.math.BigDecimal;
import java.util.HashSet;

public class AcctJDBalanceState
extends AbstractAcctSortState
implements Cloneable {
    private boolean isDetailItem;
    private boolean isDetailAccount;
    private StringBuffer temp = new StringBuffer();

    @Override
    public String generateKey() {
        String key = super.generateKey();
        this.temp.setLength(0);
        this.temp.append(key);
        this.temp.append("[").append(this.isDetailItem ? "1" : "0").append("]");
        this.temp.append("[").append(this.isDetailAccount ? "1" : "0").append("]");
        return this.temp.toString();
    }

    @Override
    public void reset() {
        super.reset();
        this.isDetailItem = false;
        this.isDetailAccount = false;
    }

    @Override
    public void setState(IFormulaCalculator formula) {
        super.setState(formula);
        AcctCalculaterExt acct = (AcctCalculaterExt)formula;
        this.setIncludeSubAccount(acct.getIsIncludeSubAccount());
        this.setIncludeSubAsstItem(acct.getIsIncludeSubAsstItem());
        this.setIncludeLeafAccount(acct.getIsIncludeLeafAccount());
        this.setIncludeLeafAsstItem(acct.getIsIncludeLeafAsstItem());
        this.setDetailItem(acct.getAccountItem().isDetailItem());
        this.setDetailAccount(acct.getAccountItem().isDetailAccount());
    }

    @Override
    public Object clone() {
        AcctJDBalanceState newOne = (AcctJDBalanceState)super.clone();
        newOne.isDetailItem = this.isDetailItem;
        newOne.isDetailAccount = this.isDetailAccount;
        return newOne;
    }

    @Override
    public IAcctSortState getNewInstance() {
        return new AcctJDBalanceState();
    }

    @Override
    public String getSumPart(String currencyNumber) {
        if (this.isMultiUnPosted() || this.isNotLeafAsstAccount() || !this.isDetailItem()) {
            if ("GLC".equals(currencyNumber)) {
                return AcctUtils.getNotDetailJDSelectPartForGLC(this.getBalPairType());
            }
            if ("GRC".equals(currencyNumber)) {
                return AcctUtils.getNotDetailJDSelectPartForGRC(this.getBalPairType());
            }
            return AcctUtils.getNotDetailJDSelectPart(this.getBalPairType());
        }
        if ("GLC".equals(currencyNumber)) {
            return AcctUtils.getNormalJDSelectPartForGLC(this.getBalPairType());
        }
        if ("GRC".equals(currencyNumber)) {
            return AcctUtils.getNormalJDSelectPartForGRC(this.getBalPairType());
        }
        return AcctUtils.getNormalJDSelectPart(this.getBalPairType());
    }

    @Override
    public boolean isNeedSubAccount() {
        return !this.isDetailAccount() && (this.isNeedSubAccountBySheetParam() || !this.isNotLeafAsstAccount() && !this.isGroupByAccount());
    }

    @Override
    public Object processReturnValue(IFormulaCalculator formula, Object object) {
        return object;
    }

    @Override
    public String getGroupByPart() {
        this.temp.setLength(0);
        boolean isFirst = true;
        if (this.getAccounts() != null) {
            if (isFirst) {
                isFirst = false;
            } else {
                this.temp.append(",");
            }
            if (this.isNotLeafAsstAccount() || this.isNeedSubAccount()) {
                this.temp.append("A_Acct.FNumber");
                if (this.isNeedSubAccount() || this.isNotLeafAsstAccount() && this.isGroupByAccount()) {
                    this.temp.append(", A_AcctLeaf.FNumber ");
                }
            } else {
                this.temp.append("A_AcctLeaf.FNumber ");
            }
        } else if (this.isNeedSubAccount() || this.isNotLeafAsstAccount() && this.isGroupByAccount()) {
            if (isFirst) {
                isFirst = false;
            } else {
                this.temp.append(",");
            }
            this.temp.append("A_AcctLeaf.FNumber ");
        }
        if (this.hasItem() && (this.isNotLeafAsstAccount() || !this.isDetailItem() || this.isIncludeLeafAsstItem() || this.isIncludeSubAsstItem())) {
            HashSet<String> usedNumberSet = new HashSet<String>();
            if (this.getSingleAsstActItems() != null) {
                for (String[] asstitem : this.getSingleAsstActItems()) {
                    usedNumberSet.add(asstitem[0]);
                }
            }
            for (AsstActType asstActType : this.getAsstActTypeList()) {
                if (usedNumberSet.contains(asstActType.number)) continue;
                if (isFirst) {
                    isFirst = false;
                } else {
                    this.temp.append(",");
                }
                String tableAlias = AcctUtils.validateTableAlias(asstActType.number);
                this.temp.append(" A_AsstType").append(tableAlias).append(".").append(RptUtil.isUseLongNumber(asstActType.useLongNumber, asstActType.realtionDataObject) ? "FLongNumber" : "FNumber");
            }
        } else if (this.isNotDetailNoAsstSingleAccount()) {
            for (AsstActType asstActType : this.getSynedDetailAsstActTypeList()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    this.temp.append(",");
                }
                this.temp.append("A_Hg.").append(asstActType.mappingFieldName);
            }
        }
        if (this.temp.length() > 0) {
            return this.temp.toString();
        }
        return null;
    }

    public boolean isDetailItem() {
        return this.isDetailItem;
    }

    public void setDetailItem(boolean isLeafAccount) {
        this.isDetailItem = isLeafAccount;
    }

    public boolean isDetailAccount() {
        return this.isDetailAccount;
    }

    public void setDetailAccount(boolean isDetailAccount) {
        this.isDetailAccount = isDetailAccount;
    }

    @Override
    public String getFromPart() {
        if (this.isNotDetailNoAsstSingleAccount()) {
            this.temp.setLength(0);
            this.temp.append("  inner join T_BD_AssistantHG A_Hg on A_Bal.FAssistGrpID = A_Hg.fid    ");
            return this.temp.toString();
        }
        return null;
    }

    private boolean isNotDetailNoAsstSingleAccount() {
        return !this.hasItem() && this.getSynedDetailAsstActTypeList() != null && (this.isIncludeLeafAsstItem() || this.isIncludeSubAsstItem()) && !this.isDetailAccount() && this.getAccounts() == null;
    }

    @Override
    public String getUnPostedAccrualSelectPart(String currencyNumber) {
        return AcctUtils.getUnPostedJDAccrualSelectPart(this.getBalPairType(), this.getRptOrgType(), currencyNumber);
    }

    @Override
    public String getUnPostedBalanceSelectPart(String currencyNumber) {
        return AcctUtils.getUnPostedJDBalanceSelectPart(this.getBalPairType(), this.getRptOrgType(), currencyNumber);
    }

    @Override
    public int getAcctSortType() {
        return 2;
    }

    @Override
    public Object processReturnValue(IFormulaCalculator formula, Object object, BigDecimal dc) {
        return object;
    }
}

