/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acct.quantity;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.BalanceTypeEnum;
import com.kingdee.eas.fi.rpt.IBackfillHandler;
import com.kingdee.eas.fi.rpt.app.AcctCalculaterExt;
import com.kingdee.eas.fi.rpt.app.AssistantItemExt;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fi.rpt.batch.BatchSQLSorterRegister;
import com.kingdee.eas.fi.rpt.batch.acct.quantity.AddValueHandler;
import com.kingdee.eas.fi.rpt.batch.acct.quantity.ParameterForSubValue;
import com.kingdee.eas.fi.rpt.batch.acct.quantity.QuantityTypeEnum;
import com.kingdee.eas.fi.rpt.batch.acct.quantity.SubValueHandler;
import com.kingdee.eas.fi.rpt.batch.acct.quantity.VouchQuantityFormula;
import com.kingdee.eas.fi.rpt.batch.acct.quantity.VouchQuantityFormulaExcelRef;
import com.kingdee.eas.fi.rpt.batch.acct.quantity.VouchQuantityProcessor;
import com.kingdee.eas.fi.rpt.batch.acct.quantity.VouchQuantitySort;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class VouchQuantityCalculator {
    private Context serverCtx;
    private Collection quantityFormulas = new HashSet(1);

    public VouchQuantityCalculator(Context serverCtx) {
        this.serverCtx = serverCtx;
    }

    public void calculate() throws BOSException, EASBizException {
        HashMap context = new HashMap();
        BatchSQLSorterRegister register = new BatchSQLSorterRegister(context);
        for (VouchQuantityFormula formula : this.quantityFormulas) {
            formula.reverseByFrom();
            if (formula.isException() || formula.getCompany() == null || formula.getAccount() == null || formula.getCurrency() == null || formula.getStartYear() == 0 || formula.getStartPeriod() == 0 || formula.getEndYear() == 0 || formula.getEndPeriod() == 0) {
                formula.setException(new Exception(""));
                continue;
            }
            register.setSortState(new VouchQuantitySort());
            register.register(formula);
        }
        BatchHelper batchHelper = new BatchHelper(this.serverCtx);
        batchHelper.setTempTableSchemeDebug(false);
        batchHelper.setBatchSize(100);
        VouchQuantityProcessor sqlBuilder = new VouchQuantityProcessor();
        batchHelper.batchCalculateBigDecimalBySorter(sqlBuilder, register);
    }

    public boolean need(BalanceTypeEnum balanceType) {
        return QuantityTypeEnum.need(balanceType);
    }

    public Collection register(List formulas) {
        AcctCalculaterExt formula = null;
        ArrayList<AcctCalculaterExt> replacedFormulas = new ArrayList<AcctCalculaterExt>(formulas.size());
        for (int i = 0; i < formulas.size(); ++i) {
            AcctCalculaterExt dfFormula;
            AcctCalculaterExt jfFormula;
            formula = (AcctCalculaterExt)formulas.get(i);
            if (formula.isException()) continue;
            VouchQuantityFormulaExcelRef excelRef = new VouchQuantityFormulaExcelRef(new ParameterForSubValue(formula.getParameter()), formula.getSheetName(), formula.getException());
            QuantityTypeEnum type = QuantityTypeEnum.convert(formula.getBalanceType());
            VouchQuantityFormula quantityFormula = new VouchQuantityFormula(formula.getCompany(), formula.getAccountItem(), type, formula.getIStartYear(), formula.getIStartPeriod(), formula.getIEndYear(), formula.getIEndPeriod(), formula.getCurrency(), excelRef);
            this.quantityFormulas.add(quantityFormula);
            if (type == QuantityTypeEnum.PNL_QUANTITY_YEAR) {
                jfFormula = this.newAcctCalculaterExt(formula, new AddValueHandler(formula.getStruct().getBackFiller()));
                jfFormula.setBalanceType(BalanceTypeEnum.QJL);
                dfFormula = this.newAcctCalculaterExt(formula, new SubValueHandler(formula.getStruct().getBackFiller()));
                dfFormula.setBalanceType(BalanceTypeEnum.QDL);
                replacedFormulas.add(jfFormula);
                replacedFormulas.add(dfFormula);
                quantityFormula.setFrom(jfFormula);
                continue;
            }
            if (type != QuantityTypeEnum.PNL_QUANTITY_PERIOD) continue;
            jfFormula = this.newAcctCalculaterExt(formula, new AddValueHandler(formula.getStruct().getBackFiller()));
            jfFormula.setBalanceType(BalanceTypeEnum.QJF);
            dfFormula = this.newAcctCalculaterExt(formula, new SubValueHandler(formula.getStruct().getBackFiller()));
            dfFormula.setBalanceType(BalanceTypeEnum.QDF);
            replacedFormulas.add(jfFormula);
            replacedFormulas.add(dfFormula);
            quantityFormula.setFrom(jfFormula);
        }
        return replacedFormulas;
    }

    private AcctCalculaterExt newAcctCalculaterExt(AcctCalculaterExt acctExt, IBackfillHandler valueHandler) {
        AcctCalculaterExt expandAcctExt = new AcctCalculaterExt(acctExt.getStruct(), valueHandler);
        for (AssistantItemExt assistantItem : acctExt.getAccountItem().itemValues()) {
            expandAcctExt.getAccountItem().setItemType(assistantItem.itemType);
        }
        expandAcctExt.setItemHasWildcar(acctExt.isItemHasWildcar());
        expandAcctExt.setCurrency(acctExt.getCurrency());
        expandAcctExt.setCompany(acctExt.getCompany());
        expandAcctExt.setAcctBatchQueryService(acctExt.getAcctBatchQueryService());
        expandAcctExt.setContext(acctExt.getContext());
        expandAcctExt.setAccountTable(acctExt.getAccountTable());
        expandAcctExt.setCorrectAccountTable(acctExt.isCorrectAccountTable());
        return expandAcctExt;
    }
}

