/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acct.quantity;

import com.kingdee.eas.fi.rpt.app.AssistantItemExt;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSortState;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.acct.quantity.AsstField;
import com.kingdee.eas.fi.rpt.batch.acct.quantity.VouchQuantityFormula;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class VouchQuantitySort
implements IBatchSQLSortState,
Cloneable {
    private Collection asstFields = new HashSet();
    private List formulas = new ArrayList(8);
    private boolean debit = true;

    @Override
    public List getFormulaList() {
        return this.formulas;
    }

    @Override
    public String generateKey() {
        StringBuffer sortKey = new StringBuffer();
        sortKey.append("Key_");
        sortKey.append('|').append(this.debit ? 1 : 0).append('|');
        for (AsstField type : this.asstFields) {
            sortKey.append('|');
            sortKey.append(type.getType());
            sortKey.append('|');
        }
        return sortKey.toString();
    }

    @Override
    public void setState(IFormulaCalculator formulaParam) {
        this.reset();
        VouchQuantityFormula formula = (VouchQuantityFormula)formulaParam;
        if (!formula.getAccount().getItemTypes().isEmpty()) {
            Collection types = formula.getAccount().itemValues();
            int asstIndex = 0;
            for (AssistantItemExt asstType : types) {
                this.asstFields.add(new AsstField(asstType.itemType.number, "asst" + asstIndex, asstType.itemType.useLongNumber, asstType.itemType.realtionDataObject, "asst" + asstIndex + "_" + (asstType.itemType.useLongNumber ? "longNumber" : "number"), asstType.itemType.mappingFieldName));
                ++asstIndex;
            }
        }
        this.debit = formula.getAccount().startAccount.account.dc == 1;
    }

    @Override
    public void addFormula(IFormulaCalculator formula) {
        this.formulas.add(formula);
    }

    @Override
    public void reset() {
        this.asstFields.clear();
        this.formulas.clear();
    }

    @Override
    public void setContext(Map context) {
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            VouchQuantitySort sort = new VouchQuantitySort();
            sort.asstFields = new HashSet(this.asstFields);
            sort.formulas = new ArrayList(this.formulas);
            return sort;
        }
    }

    public Collection getAssistantFieldNames() {
        return this.asstFields;
    }

    public boolean isDebit() {
        return this.debit;
    }
}

