/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acctcash;

import com.kingdee.eas.fi.rpt.batch.CalculatorCombiner;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLProcessor;
import com.kingdee.eas.fi.rpt.batch.ICombineHandler;
import com.kingdee.eas.fi.rpt.batch.ICompareStyle;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class AcctCashCombineHandler
implements ICombineHandler {
    private static final Logger logger = Logger.getLogger(AcctCashCombineHandler.class);
    private static final String SINGLE_REGEX_FOR_ANY_REGEX_KEY = "[\\.\\*\\[\\]\\(\\)\\+\\?\\-\\^\\$\\,\\{\\}\\\\/\\&\\|]";

    @Override
    public void processCombine(List usedDyItemList, IRowSet rs, CalculatorCombiner combiner, IBatchSQLProcessor sqlBuilder, StringBuffer rowIndexValue) throws SQLException {
        block6: {
            block4: {
                Object formulas;
                block5: {
                    if (combiner.getPrepareState() == null) {
                        return;
                    }
                    sqlBuilder.prepareStateForCombine(rs, combiner.getPrepareState());
                    if (rowIndexValue.length() <= 0) break block4;
                    formulas = this.searchFormula(sqlBuilder, combiner.getPropertyToCalculatorMap(), rowIndexValue);
                    if (formulas == null) {
                        logger.info((Object)("formulas not be found!property=" + rowIndexValue));
                        return;
                    }
                    if (!(formulas instanceof IFormulaCalculator)) break block5;
                    IFormulaCalculator formula = (IFormulaCalculator)formulas;
                    combiner.combineEachValue(formula, true, sqlBuilder);
                    break block6;
                }
                if (!(formulas instanceof Collection)) break block6;
                Collection formulaList = (Collection)formulas;
                for (IFormulaCalculator formula : formulaList) {
                    combiner.combineEachValue(formula, true, sqlBuilder);
                }
                break block6;
            }
            for (IFormulaCalculator formula : usedDyItemList) {
                combiner.combineEachValue(formula, true, sqlBuilder);
            }
        }
    }

    private Object searchFormula(IBatchSQLProcessor sqlBuilder, Map index2Formulas, StringBuffer rowIndexValue) {
        if (sqlBuilder instanceof ICompareStyle) {
            ICompareStyle compareStyle = (ICompareStyle)((Object)sqlBuilder);
            String regexIndex = null;
            if (2 == compareStyle.getIndexCompareStyle()) {
                String index2 = null;
                ArrayList formulas = new ArrayList();
                for (String index2 : index2Formulas.keySet()) {
                    if (!index2.matches(".*((@_REGEX@_)|(_@REGEX_@)).*")) continue;
                    regexIndex = AcctCashCombineHandler.convertValByWhetherRegex(index2, true, new String[]{"@_REGEX@_", "_@REGEX_@"});
                    if (!rowIndexValue.toString().matches(regexIndex)) continue;
                    Object formula = index2Formulas.get(index2);
                    if (formula instanceof IFormulaCalculator) {
                        formulas.add(formula);
                        continue;
                    }
                    if (!(formula instanceof Collection)) continue;
                    formulas.addAll((Collection)formula);
                }
                if (!formulas.isEmpty()) {
                    return formulas;
                }
            }
        }
        return index2Formulas.get(rowIndexValue.toString());
    }

    public static String convertValByWhetherRegex(String fieldValue, boolean isUseRegex, String[] excludeArea) {
        boolean haveExcludeArea;
        if (!isUseRegex) {
            return fieldValue;
        }
        String matchRegexKeyWithoutExcludeArea = "([\\.\\*\\[\\]\\(\\)\\+\\?\\-\\^\\$\\,\\{\\}\\\\/\\&\\|])+";
        boolean bl = haveExcludeArea = excludeArea != null && excludeArea.length == 2;
        if (haveExcludeArea) {
            matchRegexKeyWithoutExcludeArea = "(((.(?<!" + excludeArea[0] + "|" + excludeArea[1] + "))+(?=" + excludeArea[0] + "|$)))";
        }
        Matcher matcher = Pattern.compile(matchRegexKeyWithoutExcludeArea).matcher(fieldValue);
        String oneMatcher = null;
        while (matcher.find()) {
            if (matcher.groupCount() <= 0) continue;
            oneMatcher = matcher.group(0).replaceAll("([\\.\\*\\[\\]\\(\\)\\+\\?\\-\\^\\$\\,\\{\\}\\\\/\\&\\|])", "\\\\$0");
            fieldValue = fieldValue.replaceFirst("(((" + oneMatcher + "(?<!" + excludeArea[0] + "|" + excludeArea[1] + "))+(?=" + excludeArea[0] + "|$)))", oneMatcher.replaceAll("[\\\\]", "\\\\\\\\"));
        }
        if (haveExcludeArea) {
            fieldValue = fieldValue.replaceAll("(" + excludeArea[0] + ")|(" + excludeArea[1] + ")", "");
        }
        return fieldValue;
    }
}

