/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acctcash;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.batch.acctcash.AcctCash;
import com.kingdee.eas.fi.rpt.batch.acctcash.AcctCashExtTimeCondition;
import com.kingdee.eas.fi.rpt.batch.acctcash.IBaseAcctCashHandler;
import com.kingdee.eas.fi.rpt.batch.acctcash.ITimeCondition;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AcctCashExtHandler
implements IBaseAcctCashHandler {
    @Override
    public ITimeCondition getTimeConditionInstance() {
        return new AcctCashExtTimeCondition();
    }

    @Override
    public void checkIsNeedInitValue(Context ctx, Map companyNumber2StartPeriodMap, AcctCash acctCash) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)acctCash.oppAccountString)) {
            return;
        }
        PeriodInfo startPeriod = (PeriodInfo)companyNumber2StartPeriodMap.get(acctCash.fiOrgUnit);
        if (startPeriod == null) {
            return;
        }
        ITimeCondition timeCondition = acctCash.getTimeCondition();
        AcctCashExtTimeCondition acctCashExtTC = (AcctCashExtTimeCondition)timeCondition;
        if (acctCashExtTC.getStartTime().after(acctCashExtTC.getEndTime())) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"30_AcctCashBatchCalculator", (Locale)ctx.getOriginLocale())});
        }
        acctCash.needCombineInitValue = false;
    }

    @Override
    public boolean dealTimeConditionForFillAcctCash(AcctCash acctCash, Map maxPeriodMap, ICalculateContextProvider contextProvider) throws ReportException {
        return true;
    }

    @Override
    public int getTimeConditionType() {
        return 2;
    }

    @Override
    public StringBuffer getTimeConditionSQL(ITimeCondition timeCondition, Map tcFieldNames, List params) {
        String dataFieldName = (String)tcFieldNames.get("FBOOKEDDATE");
        StringBuffer sql = new StringBuffer();
        AcctCashExtTimeCondition extTimeCondition = (AcctCashExtTimeCondition)timeCondition;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        sql.append(" ( ");
        sql.append(dataFieldName).append(" >= {");
        sql.append(sdf.format(extTimeCondition.getStartTime())).append("} ");
        sql.append("and ");
        sql.append(dataFieldName).append(" <= {");
        sql.append(sdf.format(extTimeCondition.getEndTime())).append("} ");
        sql.append(") ");
        return sql;
    }
}

