/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acctcash;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.rpt.batch.acctcash.AcctCashExtHandler;
import com.kingdee.eas.fi.rpt.batch.acctcash.IBaseAcctCashHandler;
import com.kingdee.eas.fi.rpt.batch.acctcash.ITimeCondition;
import com.kingdee.util.StringUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class AcctCashExtTimeCondition
implements ITimeCondition {
    public static final String DEFAULT_FORMULAS_DATE_FORMAT = "yyyy-MM-dd";
    private static final Logger log = Logger.getLogger(AcctCashExtTimeCondition.class);
    private Date startTime;
    private Date endTime;
    private final IBaseAcctCashHandler conditionHandler = new AcctCashExtHandler();

    @Override
    public boolean isExistAnyNull() {
        return this.startTime == null || this.endTime == null;
    }

    private Date initDateParam(Variant variant, String format, Context ctx) {
        Object paramVal;
        if (StringUtils.isEmpty((String)format)) {
            format = DEFAULT_FORMULAS_DATE_FORMAT;
        }
        if ((paramVal = variant.getValue()) instanceof Date) {
            return (Date)paramVal;
        }
        try {
            String value = paramVal.toString();
            if (StringUtils.isEmpty((String)value)) {
                return null;
            }
            SimpleDateFormat sf = new SimpleDateFormat(format);
            DateFormat dateFormat = CslRptUtil.getNationalDateFormat((Context)ctx);
            Date date = null;
            if (dateFormat != null) {
                date = sf.parse(sf.format(dateFormat.parse(value)));
            }
            return date;
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            return null;
        }
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public void init(Map timeVals) {
        Variant startTime = (Variant)timeVals.get("name.startTime");
        Variant endTime = (Variant)timeVals.get("name.endTime");
        Context ctx = (Context)timeVals.get("Context");
        this.startTime = this.initDateParam(startTime, DEFAULT_FORMULAS_DATE_FORMAT, ctx);
        this.endTime = this.initDateParam(endTime, DEFAULT_FORMULAS_DATE_FORMAT, ctx);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AcctCashExtTimeCondition newInst = new AcctCashExtTimeCondition();
        if (this.startTime != null) {
            newInst.setStartTime(new Date(this.startTime.getTime()));
        }
        if (this.endTime != null) {
            newInst.setEndTime(new Date(this.endTime.getTime()));
        }
        return newInst;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    @Override
    public void reset() {
        this.startTime = new Date();
        this.endTime = new Date();
    }

    @Override
    public int whatSame() {
        return -1;
    }

    @Override
    public ITimeCondition getNewInstance() {
        return new AcctCashExtTimeCondition();
    }

    @Override
    public IBaseAcctCashHandler getConditionHandler() {
        return this.conditionHandler;
    }
}

