/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acctcash;

import com.kingdee.eas.basedata.assistant.CashFlowDirection;
import com.kingdee.eas.fi.rpt.app.AssistantGroup;
import com.kingdee.eas.fi.rpt.app.AssistantItem;
import com.kingdee.eas.fi.rpt.app.AsstActType;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSortState;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSorterProcessor;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.IFormulaCombinationPreparedState;
import com.kingdee.eas.fi.rpt.batch.SQLStringWrapper;
import com.kingdee.eas.fi.rpt.batch.acctcash.AcctCash;
import com.kingdee.eas.fi.rpt.batch.acctcash.AcctCashCombineState;
import com.kingdee.eas.fi.rpt.batch.acctcash.AcctCashInitSortState;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class AcctCashInitProccessor
implements IBatchSQLSorterProcessor {
    private static final String NULL_STRING_PARAM = "";
    private static final int ORACLE_IDENTIFIER_LIMIT = 30;
    private int batchSize;
    private AcctCashInitSortState sortState;
    private String selectPart;
    private String fromPart;
    private SQLStringWrapper constantWherePart;
    private String groupByPart;
    private IFormulaCombinationPreparedState combineState;
    private String[] IndexResultSetFields;

    public AcctCashInitProccessor(int batchSize) {
        this.batchSize = batchSize;
        this.combineState = new AcctCashCombineState();
    }

    @Override
    public void buildSelectPart(Set nullSet, StringBuffer sql) {
        sql.append(this.getSelectPart());
    }

    private String innerBuildSelectPart() {
        String tableName;
        StringBuffer sql = new StringBuffer();
        String string = tableName = this.sortState.getCashFlowAsstActTypeList() == null ? "Init" : "CashAsst";
        if (this.sortState.isLeafCashFlowItem() || !this.sortState.isLeafCashFlowItem() && this.sortState.getCashFlowDirection() != CashFlowDirection.IN_OR_OUT) {
            sql.append(" Select sum(").append(tableName).append(".FOriginalAmount)  OriginalAmount ");
            sql.append(" , sum(").append(tableName).append(".FLocalAmount)  LocalAmount ");
            sql.append(" , sum( ").append(tableName).append(".FReportingAmount)  ReportingAmount ");
        } else {
            sql.append(" Select sum((case CashItem.FDirection when 2 then -1 else 1 end) * ").append(tableName).append(".FOriginalAmount)  OriginalAmount ");
            sql.append(" , sum((case CashItem.FDirection when 2 then -1 else 1 end) * ").append(tableName).append(".FLocalAmount)  LocalAmount ");
            sql.append(" , sum((case CashItem.FDirection when 2 then -1 else 1 end) * ").append(tableName).append(".FReportingAmount)  ReportingAmount ");
        }
        if (this.sortState.getCompanyNumber() == null) {
            sql.append(" , Init.FCompanyID OrgID ");
        }
        sql.append(" , CashItem.FID CashItemID ");
        if (!this.sortState.isForIncashFlow()) {
            if (this.sortState.getSingleCashFlowAsstActItem() != null) {
                for (String[] itemType : this.sortState.getSingleCashFlowAsstActItem()) {
                    String tableAlias = this.validateTableAlias(itemType[0]);
                    sql.append(" , A_AsstType").append(tableAlias).append(".");
                    if (itemType[1] == "FLongNumber") {
                        sql.append("FLongNumber").append(" AsstActItem").append(tableAlias).append(" ");
                        continue;
                    }
                    sql.append("FNumber").append(" AsstActItem").append(tableAlias).append(" ");
                }
            }
        } else {
            sql.append(" , InnerCompany.FNumber CashFlowItemAsstNumber ");
        }
        if (this.sortState.isNeedCurrency()) {
            sql.append(" , Currency.FNumber CurrencyNumber ");
        }
        return sql.toString();
    }

    public String validateTableAlias(String alias) {
        alias = alias.replaceAll("-", "_");
        alias = alias.replaceAll("\\.", "_");
        return alias;
    }

    public String limitTableAliasLength(String alias) {
        if (alias.length() > 30) {
            alias = alias.substring(0, 30);
        }
        return alias;
    }

    private void buildAssistantGroupFromPart(StringBuffer sql, AsstActType itemType, AssistantGroup[] groups, String alias) {
        String tableAlias = alias + this.validateTableAlias(itemType.number);
        if ("T_BD_CUSTOMER".equalsIgnoreCase(itemType.realtionDataObject) || "T_BD_SUPPLIER".equalsIgnoreCase(itemType.realtionDataObject) || "T_BD_Material".equalsIgnoreCase(itemType.realtionDataObject)) {
            String group = null;
            String groupTable = null;
            String groupDetail = null;
            if ("T_BD_CUSTOMER".equalsIgnoreCase(itemType.realtionDataObject)) {
                group = "Customer";
                groupTable = "T_BD_CSSPGroup";
                groupDetail = "GroupDetail";
            } else if ("T_BD_Material".equalsIgnoreCase(itemType.realtionDataObject)) {
                group = "Material";
                groupTable = "T_BD_MaterialGroup";
                groupDetail = "GroupDetial";
            } else {
                group = "Supplier";
                groupTable = "T_BD_CSSPGroup";
                groupDetail = "GroupDetail";
            }
            for (int gi = 0; gi < groups.length; ++gi) {
                AssistantGroup g = groups[gi];
                sql.append(" inner join T_BD_").append(group).append(groupDetail);
                sql.append(" groupDtl").append(tableAlias).append(gi).append(" on groupDtl").append(tableAlias).append(gi).append(".F").append(group).append("ID = A_AsstType").append(tableAlias).append(".FID ");
                String groupTableAlias = this.limitTableAliasLength("group" + tableAlias + "_" + g.standardNumber);
                sql.append(" inner join ").append(groupTable).append(" ").append(groupTableAlias);
                sql.append(" on groupDtl").append(tableAlias).append(gi).append(".F").append(group).append("GroupID = ").append(groupTableAlias).append(".FID ");
            }
        } else {
            sql.append(" inner join ").append(itemType.groupTableName).append(" Group").append(tableAlias);
            sql.append(" on ").append("A_AsstType").append(tableAlias).append(itemType.groupMappingFieldName);
            sql.append(" = ").append(" Group").append(tableAlias).append(".FID ");
        }
    }

    private void buildAssistanGroupWherePart(StringBuffer sql, List params, AsstActType itemType, AssistantGroup[] groups, String alias) {
        String tableAlias = alias + this.validateTableAlias(itemType.number);
        if ("T_BD_CUSTOMER".equalsIgnoreCase(itemType.realtionDataObject) || "T_BD_SUPPLIER".equalsIgnoreCase(itemType.realtionDataObject) || "T_BD_Material".equalsIgnoreCase(itemType.realtionDataObject)) {
            for (int gi = 0; gi < groups.length; ++gi) {
                AssistantGroup group = groups[gi];
                String gp = this.limitTableAliasLength("group" + tableAlias + "_" + group.standardNumber);
                if (groups[gi].isSingleGroup()) {
                    sql.append(" and (").append(gp).append(".FLongNumber = ? or ").append(gp).append(".FLongNumber like ?)");
                    params.add(group.getStartGroup().longNumber);
                    params.add(group.getStartGroup().longNumber + "!%");
                } else {
                    sql.append("and (").append(gp).append(".FLongNumber >= ? and ").append(gp).append(".FLongNumber <= ?)");
                    params.add(group.getStartGroup().longNumber);
                    params.add(group.getEndGroup().longNumber);
                }
                if ("T_BD_Material".equalsIgnoreCase(itemType.realtionDataObject)) {
                    sql.append(" AND ").append(gp).append(".FGroupStandard = ? ");
                } else {
                    sql.append(" AND ").append(gp).append(".FCSSPGroupStandardID = ? ");
                }
                params.add(group.standardID);
            }
        } else {
            AssistantGroup group = groups[0];
            if (group.isSingleGroup()) {
                sql.append(" and ( Group").append(tableAlias).append(".FLongNumber = ? or Group").append(tableAlias).append(".FLongNumber like ? )");
                params.add(group.getStartGroup().longNumber);
                params.add(group.getStartGroup().longNumber + "!%");
            } else {
                if (group.getStartGroup().longNumber.length() > 0) {
                    sql.append(" and  Group").append(tableAlias).append(".FLongNumber >= ? ");
                    params.add(group.getStartGroup().longNumber);
                }
                if (group.getEndGroup().longNumber.length() > 0) {
                    sql.append(" and  Group").append(tableAlias).append(".FLongNumber <= ? ");
                    params.add(group.getEndGroup().longNumber);
                }
            }
        }
    }

    @Override
    public void buildFromPart(Set nullSet, StringBuffer sql) {
        sql.append(this.getFromPart());
    }

    private String innerBuildFromPart() {
        StringBuffer sql = new StringBuffer();
        sql.append(" From T_GL_CashFlowInit Init ");
        sql.append(" inner join T_BD_CashFlowItem CashItem on Init.FCashflowItemID = CashItem.FID ");
        if (this.sortState.isNeedCurrency() || this.sortState.getCurrencyNumber() != null) {
            sql.append(" inner join T_BD_Currency Currency on Init.FCurrencyID = Currency.FID");
        }
        if (this.sortState.getCashFlowAsstActTypeList() != null) {
            sql.append(" inner join T_GL_CashflowGrpAsst CashAsst on CashAsst.FCflowInitID = Init.FID ");
            sql.append(" inner join t_bd_assistanthg c on CashAsst.FAssistGrpID = c.fid  ");
            for (int i = 0; i < this.sortState.getCashFlowAsstActTypeList().size(); ++i) {
                AssistantGroup[] groups;
                AsstActType item = (AsstActType)this.sortState.getCashFlowAsstActTypeList().get(i);
                if (this.sortState.isForIncashFlow()) {
                    if (item.realtionDataObject.equalsIgnoreCase("t_bd_supplier") || item.realtionDataObject.equalsIgnoreCase("t_bd_customer")) {
                        sql.append(" inner join ").append(item.realtionDataObject).append(" CashFlowItemAsstActType on CashFlowItemAsstActType.fid = c.").append(item.mappingFieldName).append(" ");
                        sql.append(" inner join t_org_company InnerCompany  on InnerCompany.fid = CashFlowItemAsstActType.FInternalCompanyID ");
                        continue;
                    }
                    sql.append(" inner join ").append(item.realtionDataObject).append(" InnerCompany on InnerCompany.fid = c.").append(item.mappingFieldName).append(" ");
                    continue;
                }
                String tableAlias = this.validateTableAlias(item.number);
                sql.append(" inner join ").append(item.realtionDataObject).append(" A_AsstType").append(tableAlias).append(" on A_AsstType").append(tableAlias).append(".fid = c.").append(item.mappingFieldName).append(" ");
                if (this.sortState.getCashFlowGroupMap() == null || (groups = (AssistantGroup[])this.sortState.getCashFlowGroupMap().get(item.number)) == null || groups.length <= 0) continue;
                this.buildAssistantGroupFromPart(sql, item, groups, NULL_STRING_PARAM);
            }
        }
        return sql.toString();
    }

    @Override
    public void builderConstantWherePart(Set nullSet, StringBuffer sql, List params) {
        sql.append(this.constantWherePart.getSQLString());
        params.addAll(this.constantWherePart.getParams());
    }

    private SQLStringWrapper innerBuildConstantWherePart() {
        String tableAlias;
        StringBuffer sql = new StringBuffer();
        ArrayList params = new ArrayList();
        if (this.sortState.getCompanyNumber() != null) {
            if (this.sortState.getCompanyIDList().size() == 1) {
                sql.append(" WHERE Init.FCompanyID = ? ");
                params.add(this.sortState.getCompanyIDList().get(0));
            } else {
                sql.append(" and Init.FCompanyID in ( ");
                for (int i = 0; i < this.sortState.getCompanyIDList().size(); ++i) {
                    if (i != 0) {
                        sql.append(" , ");
                    }
                    sql.append(" ? ");
                    params.add(this.sortState.getCompanyIDList().get(i));
                }
                sql.append(" ) ");
            }
        }
        if (!this.sortState.isNeedCurrency() && this.sortState.getCurrencyNumber() != null) {
            sql.append(" and Currency.FNumber = ? ");
            params.add(this.sortState.getCurrencyNumber());
        }
        HashSet<String> nullLongNumberSet = null;
        if (this.sortState.getCashFlowAsstActTypeList() != null) {
            for (int i = 0; i < this.sortState.getCashFlowAsstActTypeList().size(); ++i) {
                AsstActType item = (AsstActType)this.sortState.getCashFlowAsstActTypeList().get(i);
                tableAlias = this.validateTableAlias(item.number);
                if (item.realtionDataObject.equalsIgnoreCase("T_BD_GeneralAsstActType")) {
                    if (nullLongNumberSet == null) {
                        nullLongNumberSet = new HashSet<String>();
                    }
                    nullLongNumberSet.add(item.number);
                    sql.append(" and A_AsstType").append(tableAlias).append(".FGroupID=? ");
                    params.add(item.glAsstActTypeGrpID);
                    continue;
                }
                if (!item.realtionDataObject.equalsIgnoreCase("T_ORG_Admin") && !item.realtionDataObject.equalsIgnoreCase("T_BD_CashFlowItem") && !item.realtionDataObject.equalsIgnoreCase("T_ORG_CostCenter")) continue;
                if (nullLongNumberSet == null) {
                    nullLongNumberSet = new HashSet();
                }
                nullLongNumberSet.add(item.number);
            }
        }
        if (this.sortState.getCashFlowAsstActItems() != null) {
            for (String[] asstActItem : this.sortState.getCashFlowAsstActItems()) {
                tableAlias = this.validateTableAlias(asstActItem[0]);
                if (nullLongNumberSet != null && nullLongNumberSet.contains(asstActItem[0])) {
                    if (asstActItem[1].equals(asstActItem[2])) {
                        sql.append(" and (A_AsstType").append(tableAlias).append(".FLongNumber = ? or A_AsstType").append(tableAlias).append(".FLongNumber like ? ) ");
                        params.add(asstActItem[1]);
                        params.add(asstActItem[1] + "!%");
                        continue;
                    }
                    sql.append(" and A_AsstType").append(tableAlias).append(".FLongNumber >= ? and A_AsstType").append(tableAlias).append(".FLongNumber <= ?  ");
                    params.add(asstActItem[1]);
                    params.add(asstActItem[2]);
                    continue;
                }
                if (asstActItem[1].equals(asstActItem[2])) {
                    sql.append(" and A_AsstType").append(tableAlias).append(".FNumber = ? ");
                    params.add(asstActItem[1]);
                    continue;
                }
                sql.append(" and A_AsstType").append(tableAlias).append(".FNumber >= ? and A_AsstType").append(tableAlias).append(".FNumber <= ?  ");
                params.add(asstActItem[1]);
                params.add(asstActItem[2]);
            }
        }
        if (this.sortState.getCashFlowAsstActTypeList() != null && this.sortState.getCashFlowGroupMap() != null) {
            for (AsstActType itemType : this.sortState.getCashFlowAsstActTypeList()) {
                AssistantGroup[] groups = (AssistantGroup[])this.sortState.getCashFlowGroupMap().get(itemType.number);
                if (groups == null || groups.length <= 0) continue;
                this.buildAssistanGroupWherePart(sql, params, itemType, groups, NULL_STRING_PARAM);
            }
        }
        sql.append(" and ( ");
        return new SQLStringWrapper(sql.toString(), params);
    }

    @Override
    public void buildVariableWherePart(StringBuffer sql, List params, IFormulaCalculator formula) {
        int i;
        sql.append(" ( ");
        AcctCash acctCash = (AcctCash)formula;
        if (this.sortState.getMaxCashItemLevel() == 1) {
            sql.append("  CashItem.FID = ? ");
            params.add(acctCash.cashFlowItemList.get(0));
        } else {
            sql.append("  CashItem.FID in ( ");
            for (i = 0; i < this.sortState.getMaxCashItemLevel(); ++i) {
                if (i != 0) {
                    sql.append(" , ");
                }
                sql.append(" ? ");
                if (i < acctCash.cashFlowItemList.size()) {
                    params.add(acctCash.cashFlowItemList.get(i));
                    continue;
                }
                params.add(NULL_STRING_PARAM);
            }
            sql.append(" ) ");
        }
        if (this.sortState.getCompanyNumber() == null) {
            sql.append(" and Init.FCompanyID in ( ");
            for (i = 0; i < this.sortState.getMaxCompanyLevel(); ++i) {
                if (i != 0) {
                    sql.append(" , ");
                }
                sql.append(" ? ");
                if (i < acctCash.initCompanyList.size()) {
                    params.add(acctCash.initCompanyList.get(i));
                    continue;
                }
                params.add(NULL_STRING_PARAM);
            }
            sql.append(" ) ");
        }
        if (this.sortState.getSingleCashFlowAsstActItem() != null) {
            for (String[] itemType : this.sortState.getSingleCashFlowAsstActItem()) {
                String tableAlias = this.validateTableAlias(itemType[0]);
                AssistantItem assistantItem = acctCash.cashFlowItem.getItem(itemType[0]);
                if (!this.sortState.isForIncashFlow()) {
                    if (assistantItem == null || StringUtils.isEmpty((String)assistantItem.startItem.number)) continue;
                    if (itemType[1] == "FLongNumber") {
                        sql.append(" and  (A_AsstType").append(tableAlias).append(".").append("FLongNumber").append(" = ? ");
                        sql.append(" or  A_AsstType").append(tableAlias).append(".").append("FLongNumber").append(" like ? )");
                        params.add(assistantItem.startItem.longNumber);
                        params.add(assistantItem.startItem.longNumber + "!%");
                        continue;
                    }
                    sql.append(" and A_AsstType").append(tableAlias).append(".FNumber = ? ");
                    params.add(assistantItem.startItem.number);
                    continue;
                }
                if (assistantItem == null || StringUtils.isEmpty((String)assistantItem.startItem.number)) continue;
                sql.append(" and InnerCompany.FNumber = ? ");
                params.add(assistantItem.startItem.number);
            }
        }
        if (this.sortState.isNeedCurrency()) {
            sql.append(" and Currency.FNumber = ? ");
            params.add(acctCash.currencyNumber);
        }
        sql.append(" ) ");
    }

    @Override
    public void buildGroupByPart(Set nullSet, StringBuffer sql) {
        sql.append(this.getGroupByPart());
    }

    private String innerBuildGroupByPart() {
        StringBuffer sql = new StringBuffer();
        sql.append(" ) Group by CashItem.FID ");
        if (this.sortState.getCompanyNumber() == null) {
            sql.append(" , Init.FCompanyID   ");
        }
        if (!this.sortState.isForIncashFlow()) {
            if (this.sortState.getSingleCashFlowAsstActItem() != null) {
                for (String[] itemType : this.sortState.getSingleCashFlowAsstActItem()) {
                    String tableAlias = this.validateTableAlias(itemType[0]);
                    sql.append(" , A_AsstType").append(tableAlias).append(".");
                    if (itemType[1] == "FLongNumber") {
                        sql.append("FLongNumber");
                        continue;
                    }
                    sql.append("FNumber");
                }
            }
        } else {
            sql.append(" , InnerCompany.FNumber  ");
        }
        if (this.sortState.isNeedCurrency()) {
            sql.append(" , Currency.FNumber  ");
        }
        return sql.toString();
    }

    @Override
    public IFormulaCombinationPreparedState getCombineState() {
        return this.combineState;
    }

    @Override
    public Object[][] getIndexFormulaFields(IFormulaCalculator formula) {
        AcctCash acctCash = (AcctCash)formula;
        List companyList = acctCash.initCompanyList;
        List cashList = acctCash.cashFlowItemList;
        ArrayList<String> condition = new ArrayList<String>();
        int index = 0;
        boolean isUseCompany = this.sortState.getCompanyNumber() == null;
        int count = isUseCompany ? companyList.size() : 1;
        Object[][] result = new Object[count * cashList.size()][];
        String companyID = null;
        for (int i = 0; i < count; ++i) {
            if (isUseCompany) {
                companyID = (String)companyList.get(i);
            }
            for (int j = 0; j < cashList.size(); ++j) {
                String cashItemID = (String)cashList.get(j);
                if (isUseCompany) {
                    condition.add(companyID);
                }
                condition.add(cashItemID);
                if (this.sortState.getSingleCashFlowAsstActItem() != null) {
                    for (String[] itemType : this.sortState.getSingleCashFlowAsstActItem()) {
                        AssistantItem assistantItem = acctCash.cashFlowItem.getItem(itemType[0]);
                        if (assistantItem == null || StringUtils.isEmpty((String)assistantItem.startItem.number) || itemType[1] == "FLongNumber") continue;
                        condition.add(assistantItem.startItem.number);
                    }
                }
                if (this.sortState.isNeedCurrency()) {
                    condition.add(acctCash.currencyNumber);
                }
                result[index++] = condition.toArray();
                condition.clear();
            }
        }
        return result;
    }

    @Override
    public String[] getIndexResultSetFields() {
        return this.IndexResultSetFields;
    }

    @Override
    public void prepareStateForCombine(IRowSet rs, IFormulaCombinationPreparedState combineState) throws SQLException {
        AcctCashCombineState acctCashState = (AcctCashCombineState)combineState;
        acctCashState.refresh();
        acctCashState.setLocal(rs.getBigDecimal("LocalAmount"));
        acctCashState.setReporting(rs.getBigDecimal("ReportingAmount"));
        acctCashState.setOriginal(rs.getBigDecimal("OriginalAmount"));
        if (this.sortState.getSingleCashFlowAsstActItem() != null) {
            Iterator iterator = this.sortState.getSingleCashFlowAsstActItem().iterator();
            while (iterator.hasNext()) {
                StringBuffer sb = new StringBuffer();
                String[] itemType = (String[])iterator.next();
                String tableAlias = this.validateTableAlias(itemType[0]);
                if (itemType[1] != "FLongNumber") continue;
                sb.append("ASSTACTITEM").append(tableAlias);
                acctCashState.putAsstNumber(itemType[0], rs.getString(sb.toString()));
            }
        }
    }

    @Override
    public int getMaxSQLVaribleSize() {
        return this.batchSize;
    }

    @Override
    public Set getAllowedNullFields() {
        return null;
    }

    @Override
    public List getFormulaCalculators() {
        return this.sortState.getFormulaList();
    }

    public IBatchSQLSortState getSortState() {
        return this.sortState;
    }

    @Override
    public void setSortState(IBatchSQLSortState sortState) {
        this.sortState = (AcctCashInitSortState)sortState;
        this.refreshSQLBySortState();
    }

    private void refreshSQLBySortState() {
        this.initIndexResultSetFields();
        this.setSelectPart(this.innerBuildSelectPart());
        this.setFromPart(this.innerBuildFromPart());
        this.setConstantWherePart(this.innerBuildConstantWherePart());
        this.setGroupByPart(this.innerBuildGroupByPart());
    }

    private void initIndexResultSetFields() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.sortState.getCompanyNumber() == null) {
            result.add("OrgID");
        }
        result.add("CashItemID");
        if (this.sortState.getSingleCashFlowAsstActItem() != null) {
            for (String[] itemType : this.sortState.getSingleCashFlowAsstActItem()) {
                String tableAlias = this.validateTableAlias(itemType[0]);
                if (!this.sortState.isForIncashFlow()) {
                    if (itemType[1] == "FLongNumber") continue;
                    result.add("AsstActItem" + tableAlias);
                    continue;
                }
                if (itemType[1] == "FLongNumber") continue;
                result.add("CashFlowItemAsstNumber");
            }
        }
        if (this.sortState.isNeedCurrency()) {
            result.add("CurrencyNumber");
        }
        this.IndexResultSetFields = new String[result.size()];
        result.toArray(this.IndexResultSetFields);
    }

    public String getSelectPart() {
        return this.selectPart;
    }

    public void setSelectPart(String selectPart) {
        this.selectPart = selectPart;
    }

    public String getFromPart() {
        return this.fromPart;
    }

    public void setFromPart(String fromPart) {
        this.fromPart = fromPart;
    }

    public SQLStringWrapper getConstantWherePart() {
        return this.constantWherePart;
    }

    public void setConstantWherePart(SQLStringWrapper constantWherePart) {
        this.constantWherePart = constantWherePart;
    }

    public String getGroupByPart() {
        return this.groupByPart;
    }

    public void setGroupByPart(String groupByPart) {
        this.groupByPart = groupByPart;
    }

    public void setIndexResultSetFields(String[] indexResultSetFields) {
        this.IndexResultSetFields = indexResultSetFields;
    }
}

