/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acctcash;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.app.AssistantGroup;
import com.kingdee.eas.fi.rpt.app.AssistantItem;
import com.kingdee.eas.fi.rpt.app.AssistantItemExt;
import com.kingdee.eas.fi.rpt.app.AsstActType;
import com.kingdee.eas.fi.rpt.app.GroupTreeNode;
import com.kingdee.eas.fi.rpt.app.RptCalculaterDAO;
import com.kingdee.eas.fi.rpt.batch.acctcash.AcctCash;
import com.kingdee.eas.fi.rpt.util.AcctountAsstItemParser;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class CashFlowItem {
    AcctountAsstItemParser.AccountAsstItem acctitem;
    String number;
    private Context ctx;
    private Map items;

    public CashFlowItem(Context ctx, String param, AcctCash acctCash) throws ParseException, ReportException, BOSException {
        AcctountAsstItemParser.AsstItem[] asstItems;
        this.ctx = ctx;
        this.acctitem = AcctountAsstItemParser.parse(param);
        this.number = this.acctitem.startNumber;
        RptCalculaterDAO calcDAO = new RptCalculaterDAO(ctx);
        this.items = new HashMap(2);
        if (this.acctitem.asstItems != null && (asstItems = this.acctitem.asstItems) != null) {
            acctCash.assistantItemExtList = new ArrayList();
            for (int i = 0; i < asstItems.length; ++i) {
                AssistantItemExt assistItem = new AssistantItemExt(asstItems[i].asstTypeNumber);
                assistItem.itemType = calcDAO.getAsstActTypeByNumber(this.acctitem.asstItems[i].asstTypeNumber);
                if (assistItem.startItem == null) {
                    assistItem.startItem = new GroupTreeNode();
                }
                if (assistItem.endItem == null) {
                    assistItem.endItem = new GroupTreeNode();
                }
                this.items.put(assistItem.itemType.number, assistItem);
                assistItem.startItem.number = this.acctitem.asstItems[i].startNumber;
                assistItem.endItem.number = this.acctitem.asstItems[i].endNumber;
                if (assistItem.itemType.realtionDataObject != null && assistItem.itemType.realtionDataObject.equalsIgnoreCase("t_bd_generalasstacttype")) {
                    assistItem.startItem.number = assistItem.startItem.number == null ? null : assistItem.startItem.number.replaceAll("\\.", "\\!");
                    assistItem.startItem.longNumber = assistItem.startItem.number;
                    assistItem.endItem.number = assistItem.endItem.number == null ? null : assistItem.endItem.number.replaceAll("\\.", "\\!");
                    assistItem.endItem.longNumber = assistItem.endItem.number;
                    if (assistItem.startItem.number != null && assistItem.endItem.number != null && assistItem.startItem.number != assistItem.endItem.number && assistItem.startItem.number.split("\\!").length != assistItem.endItem.number.split("\\!").length) {
                        throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"AssistantItemMustbeTheSameLevel", (Locale)ctx.getLocale())});
                    }
                } else if (assistItem.itemType.realtionDataObject != null && (assistItem.itemType.realtionDataObject.equalsIgnoreCase("T_ORG_Admin") || assistItem.itemType.realtionDataObject.equalsIgnoreCase("T_BD_CashFlowItem") || assistItem.itemType.realtionDataObject.equalsIgnoreCase("T_ORG_CostCenter"))) {
                    this.createAssistantInfo(calcDAO, assistItem, false);
                    if (!assistItem.isSameLevel()) {
                        throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"AssistantItemMustbeTheSameLevel", (Locale)ctx.getLocale())});
                    }
                }
                if (asstItems[i].group != null) {
                    assistItem.groups = new AssistantGroup[asstItems[i].group.length];
                    for (int groupCount = 0; groupCount < asstItems[i].group.length; ++groupCount) {
                        AcctountAsstItemParser.Group groupParser = asstItems[i].group[groupCount];
                        AssistantGroup group = new AssistantGroup();
                        if (groupParser.startNumber.equals(groupParser.endNumber)) {
                            if (!StringUtils.isEmpty((String)groupParser.startNumber)) {
                                group.startGroup = group.endGroup = new GroupTreeNode();
                                group.startGroup.number = groupParser.startNumber;
                            }
                        } else {
                            if (!StringUtils.isEmpty((String)groupParser.startNumber)) {
                                group.startGroup = new GroupTreeNode();
                                group.startGroup.number = groupParser.startNumber;
                            }
                            if (!StringUtils.isEmpty((String)groupParser.endNumber)) {
                                group.endGroup = new GroupTreeNode();
                                group.endGroup.number = groupParser.endNumber;
                            }
                        }
                        group.standardNumber = groupParser.standardNumber;
                        assistItem.groups[groupCount] = group;
                    }
                    assistItem.setGroups(assistItem.groups);
                }
                acctCash.assistantItemExtList.add(assistItem);
            }
        }
    }

    private void createAssistantInfo(RptCalculaterDAO calcDAO, AssistantItemExt item, boolean fillGroupNumber) throws ReportException, BOSException {
        Map map = null;
        GroupTreeNode node = null;
        if (!fillGroupNumber) {
            map = calcDAO.getGroupLongNumber(new String[]{item.startItem.number, item.endItem.number}, item.itemType.realtionDataObject);
            node = (GroupTreeNode)map.get(item.startItem.number);
            if (node == null) {
                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"1_AccountItem", (Locale)this.ctx.getOriginLocale()) + "\"" + item.startItem.number + "\""});
            }
            item.startItem.longNumber = node.longNumber;
            node = (GroupTreeNode)map.get(item.endItem.number);
            if (node == null) {
                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"1_AccountItem", (Locale)this.ctx.getOriginLocale()) + "\"" + item.endItem.number + "\""});
            }
            item.endItem.longNumber = node.longNumber;
        }
    }

    public AcctountAsstItemParser.AccountAsstItem getAccountAsstItem() {
        return this.acctitem;
    }

    public int itemSize() {
        return this.items.size();
    }

    public Map getItemTypes() {
        return this.items;
    }

    public void setItemTypes(Map items) {
        this.items = items;
    }

    public boolean hasItem() {
        return this.items.size() > 0;
    }

    public AssistantItem getItem(String itemTypeNumber) {
        return (AssistantItem)this.items.get(itemTypeNumber);
    }

    public AsstActType getItemType(String itemTypeNumber) {
        return this.getItem((String)itemTypeNumber).itemType;
    }

    public Set itemSet() {
        return this.items.keySet();
    }
}

