/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acctext;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.VoucherColumnNameEnum;
import com.kingdee.eas.fi.rpt.VoucherGetTypeEnum;
import com.kingdee.eas.fi.rpt.app.AccountItem;
import com.kingdee.eas.fi.rpt.batch.AbstractFormulaCalculatorParameter;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class Acctext
extends AbstractFormulaCalculatorParameter {
    private static final Logger log = Logger.getLogger((String)Acctext.class.getName());
    private SimpleDateFormat dateFormat = null;
    private BatchHelper batchHelper;
    String fiOrgUnit;
    String account;
    String opposingAccount;
    String userDefineFiter;
    String voucherGetType;
    String currencyString;
    String startDateString;
    boolean isStartDateFromRpt;
    String endDateString;
    OrgType orgType;
    boolean isEndDateFromRpt;
    Set companys;
    boolean isincludingUnPosted;
    VoucherGetTypeEnum vchGetType;
    GregorianCalendar endDate;
    GregorianCalendar startDate;
    CurrencyInfo currency;
    CompanyOrgUnitInfo company;
    PeriodInfo startPeriod;
    PeriodInfo endPeriod;
    AccountItem accountItem;
    AccountItem oppAccountItem;
    Integer accountLevel;
    boolean hasDetailAsstact;
    boolean isAsstActNeedLongNumber;
    boolean hasGeneralAsstActType;
    Integer DC;
    Map accountDC;
    List accountNumbers;

    public Acctext(Parameter param, BatchHelper batchHelper) {
        this();
        this.batchHelper = batchHelper;
        this.setParameter(param);
        try {
            this.initArgs();
            this.verifyArgs();
        }
        catch (Exception e) {
            this.setException(e);
        }
    }

    @Override
    protected void initArgs() throws BOSException, EASBizException {
        int i;
        Object[] args = this.getParameter().getArgs();
        this.fiOrgUnit = ((Variant)args[i = 0]).getValue() == null ? null : ((Variant)args[i]).getValue().toString();
        this.account = ((Variant)args[++i]).getValue() == null ? null : ((Variant)args[i]).getValue().toString();
        this.opposingAccount = ((Variant)args[++i]).getValue() == null ? null : ((Variant)args[i]).getValue().toString();
        this.userDefineFiter = ((Variant)args[++i]).getValue() == null ? null : ((Variant)args[i]).getValue().toString();
        this.voucherGetType = ((Variant)args[++i]).getValue() == null ? null : ((Variant)args[i]).getValue().toString();
        this.currencyString = ((Variant)args[++i]).getValue() == null ? null : ((Variant)args[i]).getValue().toString();
        this.startDateString = ((Variant)args[++i]).getValue() == null ? null : ((Variant)args[i]).getValue().toString();
        this.endDateString = ((Variant)args[++i]).getValue() == null ? null : ((Variant)args[i]).getValue().toString();
        ++i;
        if (args.length > 8) {
            String orgTypeString = ((Variant)args[i]).getValue() == null ? null : ((Variant)args[i]).getValue().toString();
            ++i;
            if (StringUtils.isEmpty(orgTypeString)) {
                this.orgType = OrgType.Company;
            } else {
                this.orgType = OrgType.getEnum((String)orgTypeString);
                if (this.orgType == null) {
                    this.orgType = OrgType.Company;
                }
            }
        } else {
            this.orgType = OrgType.Company;
        }
        this.setNullFields(new HashSet());
    }

    @Override
    protected void verifyArgs() throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)this.fiOrgUnit)) {
            this.fiOrgUnit = this.batchHelper.getCompany_Number();
        }
        if (StringUtils.isEmpty((String)this.fiOrgUnit)) {
            throw new ReportException(ReportException.FIND_COMPANY_ERROR);
        }
        String[] companyNumber = this.fiOrgUnit.split(";\\s*");
        if (companyNumber.length > 1) {
            this.companys = new HashSet();
            this.companys.addAll(Arrays.asList(companyNumber));
        } else {
            this.batchHelper.checkCompanyPermision(this.orgType, this.fiOrgUnit);
        }
        if (this.account.matches(".*[^#]\\*.*")) {
            throw new ReportException(ReportException.ACCTEXT_NOT_SUPPORT_WILDCAR);
        }
        try {
            DateFormat format = CslRptUtil.getNationalDateFormat((Context)this.batchHelper.getServerContext());
            if (!StringUtils.isEmpty((String)this.startDateString) && format != null) {
                this.startDateString = BatchHelper.dateFormat.format(format.parse(this.startDateString));
            }
            if (!StringUtils.isEmpty((String)this.endDateString) && format != null) {
                this.endDateString = BatchHelper.dateFormat.format(format.parse(this.endDateString));
            }
        }
        catch (ParseException e1) {
            log.error((Object)"ParseException", (Throwable)e1);
        }
        if (this.startDateString == null || this.startDateString.length() <= 0) {
            Date sheet_StartDate = this.batchHelper.getSheet_StartDate(this.getSheetName());
            if (sheet_StartDate != null) {
                try {
                    this.startDateString = BatchHelper.dateFormat.format(sheet_StartDate);
                }
                catch (Exception ex) {
                    log.debug((Object)ex.getMessage());
                }
            }
            if (sheet_StartDate == null && (sheet_StartDate = this.batchHelper.getReport_StartDate()) != null) {
                this.startDateString = sheet_StartDate.toString();
                this.isStartDateFromRpt = true;
            }
        }
        if (this.endDateString == null || this.endDateString.length() <= 0) {
            Date sheet_endDate = this.batchHelper.getSheet_EndDate(this.getSheetName());
            if (sheet_endDate != null) {
                try {
                    this.endDateString = BatchHelper.dateFormat.format(sheet_endDate);
                }
                catch (Exception ex) {
                    log.debug((Object)ex.getMessage());
                }
            }
            if (sheet_endDate == null && (sheet_endDate = this.batchHelper.getReport_EndDate()) != null) {
                this.endDateString = sheet_endDate.toString();
                this.isEndDateFromRpt = true;
            }
        }
        if (this.currencyString == null || this.currencyString.length() <= 0) {
            this.currencyString = this.batchHelper.getCorrect_Currency_Number(this.getSheetName());
        }
        this.isincludingUnPosted = this.batchHelper.isSheet_IncludePosted(this.getSheetName());
        if (this.voucherGetType == null || this.voucherGetType.trim().length() == 0) {
            throw new BOSException(RptUtil.getResourceSince51("NeedFetchType"));
        }
        this.vchGetType = VoucherGetTypeEnum.getEnum(this.voucherGetType.toUpperCase());
        if (this.vchGetType == null) {
            throw new ReportException(ReportException.EXECP_ACCTEXT_VOUTYPE_INVALID);
        }
        if ((this.currencyString.toUpperCase().equalsIgnoreCase("GLC") || this.currencyString.toUpperCase().equalsIgnoreCase("GRC")) && (this.voucherGetType.substring(0, 1).toUpperCase().equalsIgnoreCase("T") || this.voucherGetType.substring(0, 1).toUpperCase().equalsIgnoreCase("Z"))) {
            throw new ReportException(ReportException.CURRENCY_TYPE_CONFLICT);
        }
        if (StringUtils.isEmpty((String)this.account)) {
            throw new ReportException(ReportException.NOT_FOUND_ACCOUNT);
        }
        if (StringUtils.isEmpty((String)this.startDateString) || StringUtils.isEmpty((String)this.endDateString)) {
            throw new ReportException(ReportException.EXECP_ACCTEXT_DATEERROR);
        }
        if (!StringUtils.isEmpty((String)this.userDefineFiter)) {
            this.verifyUserDefineFiter();
        }
        try {
            this.dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            this.dateFormat.setLenient(false);
            this.startDate = new GregorianCalendar();
            this.startDate.setTime(this.dateFormat.parse(this.startDateString));
            this.dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            this.dateFormat.setLenient(false);
            this.endDate = new GregorianCalendar();
            this.endDate.setTime(this.dateFormat.parse(this.endDateString));
        }
        catch (ParseException e) {
            throw new ReportException(ReportException.EXECP_ACCTEXT_DATEERROR, (Throwable)e);
        }
        if ("GLC".equals(this.currencyString) || "GRC".equals(this.currencyString) || StringUtils.isEmpty((String)this.currencyString)) {
            this.getNullFields().add("currency");
        }
        if (this.isincludingUnPosted) {
            this.getNullFields().add("isincludingUnPosted");
        }
        if (this.isGetInitialAmount()) {
            this.endDate = this.startDate;
        } else if (this.isGetBalance()) {
            this.startDate = this.endDate;
        }
        if (this.vchGetType == VoucherGetTypeEnum.JF || this.vchGetType == VoucherGetTypeEnum.TJF || this.vchGetType == VoucherGetTypeEnum.ZJF) {
            this.DC = new Integer(1);
        } else if (this.vchGetType == VoucherGetTypeEnum.DF || this.vchGetType == VoucherGetTypeEnum.TDF || this.vchGetType == VoucherGetTypeEnum.ZDF) {
            this.DC = new Integer(0);
        }
    }

    private Acctext() {
    }

    public Acctext cloneForSplit() throws ParseException {
        Acctext newAcctext = new Acctext();
        newAcctext.fiOrgUnit = this.fiOrgUnit;
        newAcctext.account = this.account;
        newAcctext.opposingAccount = this.opposingAccount;
        newAcctext.userDefineFiter = this.userDefineFiter;
        newAcctext.voucherGetType = this.voucherGetType;
        newAcctext.currencyString = this.currencyString;
        newAcctext.startDateString = this.startDateString;
        newAcctext.endDateString = this.endDateString;
        newAcctext.isincludingUnPosted = this.isincludingUnPosted;
        newAcctext.vchGetType = this.vchGetType;
        newAcctext.DC = this.DC;
        newAcctext.endDate = new GregorianCalendar();
        newAcctext.endDate.setTime(this.endDate.getTime());
        newAcctext.startDate = new GregorianCalendar();
        newAcctext.startDate.setTime(this.startDate.getTime());
        if (this.isGetInitialAmount()) {
            newAcctext.endDate = newAcctext.startDate;
        } else if (this.isGetBalance()) {
            newAcctext.startDate = newAcctext.endDate;
        }
        newAcctext.currency = this.currency;
        newAcctext.setNullFields(this.getNullFields());
        if (this.accountItem != null) {
            newAcctext.accountItem = new AccountItem(this.accountItem.getAccountAsstItem());
        }
        if (this.oppAccountItem != null) {
            newAcctext.oppAccountItem = new AccountItem(this.oppAccountItem.getAccountAsstItem());
        }
        newAcctext.companys = this.companys;
        newAcctext.batchHelper = this.batchHelper;
        newAcctext.setParameter(this.getParameter());
        newAcctext.isStartDateFromRpt = this.isStartDateFromRpt;
        newAcctext.isEndDateFromRpt = this.isEndDateFromRpt;
        newAcctext.orgType = this.orgType;
        return newAcctext;
    }

    public boolean isGetInitialAmount() {
        switch (this.vchGetType.getValue()) {
            case 1: {
                return true;
            }
            case 5: {
                return true;
            }
            case 7: {
                return true;
            }
        }
        return false;
    }

    public boolean isGetBalance() {
        switch (this.vchGetType.getValue()) {
            case 2: {
                return true;
            }
            case 6: {
                return true;
            }
            case 8: {
                return true;
            }
        }
        return false;
    }

    private void verifyUserDefineFiter() throws EASBizException {
        boolean ispass = false;
        String[] filter = this.reviseFilter(this.userDefineFiter);
        String regex = this.buildRegexString();
        String regex1 = "\\s*(And|Or)" + regex;
        try {
            for (int i = 0; i < filter.length; ++i) {
                String filterRegex = null;
                filterRegex = i > 0 ? regex1 : regex;
                if (!filter[i].matches(filterRegex)) {
                    ispass = false;
                    break;
                }
                ispass = true;
            }
        }
        catch (Exception ex) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"276_Acctext")));
        }
        if (!ispass) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"276_Acctext")));
        }
    }

    private String buildRegexString() {
        StringBuffer regex = new StringBuffer();
        regex.append("\\s*(");
        List voucherColumnNameList = VoucherColumnNameEnum.getEnumList();
        Iterator it = voucherColumnNameList.iterator();
        while (it.hasNext()) {
            VoucherColumnNameEnum voucherColumnNameEnum = (VoucherColumnNameEnum)((Object)it.next());
            String name = voucherColumnNameEnum.getName();
            regex.append(name);
            if (!it.hasNext()) continue;
            regex.append("|");
        }
        regex.append(")\\s*(=|<>|>|<|>=|<=|like)\\s*((['].*['])|-?\\d+)\\s*");
        return regex.toString();
    }

    private String[] reviseFilter(String filterLine) {
        filterLine = filterLine.replaceAll("(?i)and\\s", "\\|And ").replaceAll("(?i)or\\s", "\\|Or ");
        String[] split = filterLine.split("\\|");
        return split;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return this.isincludingUnPosted == ((Acctext)obj).isincludingUnPosted;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + new Boolean(this.isincludingUnPosted).hashCode();
    }
}

