/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acctext;

import com.kingdee.eas.fi.rpt.app.AssistantItem;
import com.kingdee.eas.fi.rpt.app.AsstActType;
import com.kingdee.eas.fi.rpt.batch.AsstActTypeComarator;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSorterRegister;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.acctext.Acctext;
import com.kingdee.eas.fi.rpt.batch.acctext.AcctextAccrualSortState;
import com.kingdee.eas.fi.rpt.batch.acctext.AcctextRootBuilder;
import com.kingdee.eas.fi.rpt.util.AcctountAsstItemParser;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AcctextAccrualRegister
implements IBatchSQLSorterRegister {
    private List sortStateList = new LinkedList();
    private Map sortMap = new HashMap();
    private boolean isCompanyChanges;
    private boolean isCurrencyChanges;
    private AcctextAccrualSortState acctExtSortState = new AcctextAccrualSortState();
    private Comparator itemComparator = new AsstActTypeComarator();

    public AcctextAccrualRegister(boolean isCompanyChanges, boolean isCurrencyChanges) {
        this.isCompanyChanges = isCompanyChanges;
        this.isCurrencyChanges = isCurrencyChanges;
    }

    @Override
    public List getSortStates() {
        return this.sortStateList;
    }

    @Override
    public void register(IFormulaCalculator formula) {
        Acctext acctext = (Acctext)formula;
        this.setSortState(acctext);
        String key = this.acctExtSortState.generateKey();
        AcctextAccrualSortState state = (AcctextAccrualSortState)this.sortMap.get(key);
        if (state == null) {
            state = (AcctextAccrualSortState)this.acctExtSortState.clone();
            this.sortStateList.add(state);
            this.sortMap.put(key, state);
        }
        state.addFormula(formula);
    }

    private void setSortState(Acctext acctext) {
        this.acctExtSortState.reset();
        if (AcctextRootBuilder.isGetAccrualAmount(acctext.vchGetType)) {
            this.acctExtSortState.setAccrual(true);
        }
        this.acctExtSortState.setIncludingUnPosted(acctext.isincludingUnPosted);
        this.acctExtSortState.setNeedCurrency(!acctext.getNullFields().contains("currency"));
        this.acctExtSortState.setDC(acctext.DC);
        this.acctExtSortState.setStartDate(acctext.startDate);
        this.acctExtSortState.setEndDate(acctext.endDate);
        this.acctExtSortState.setEndPeriod(acctext.endPeriod);
        this.acctExtSortState.setRptOrgType(acctext.orgType);
        if (acctext.company.isIsBizUnit()) {
            this.acctExtSortState.setSingleCompanyID(this.isCompanyChanges ? null : acctext.company.getId().toString());
        } else {
            this.acctExtSortState.setUnionCompanyLongNumber(acctext.company.getLongNumber());
        }
        if (this.acctExtSortState.getSingleCompanyID() != null) {
            this.acctExtSortState.setAccountTableID(acctext.company.getAccountTable().getId().toString());
        }
        this.acctExtSortState.setSingleCurrencyID(this.isCurrencyChanges ? null : acctext.currency.getId().toString());
        this.acctExtSortState.setUserDefineFilter(StringUtils.isEmpty((String)acctext.userDefineFiter) ? null : acctext.userDefineFiter);
        if (!acctext.accountItem.getAccountAsstItem().startNumber.equals(acctext.accountItem.getAccountAsstItem().endNumber)) {
            this.acctExtSortState.setAccounts(new String[]{acctext.accountItem.getAccountAsstItem().startNumber, acctext.accountItem.getAccountAsstItem().endNumber});
        }
        if (acctext.accountItem.hasItem()) {
            ArrayList<AsstActType> items = new ArrayList<AsstActType>();
            for (AssistantItem asst : acctext.accountItem.getItemTypes().values()) {
                items.add(asst.itemType);
            }
            Collections.sort(items, this.itemComparator);
            this.acctExtSortState.setAsstActTypeList(items);
            ArrayList<String[]> singleNumberList = null;
            ArrayList<String[]> doubleNumberList = null;
            AcctountAsstItemParser.AccountAsstItem asstItem = acctext.accountItem.getAccountAsstItem();
            if (asstItem != null && asstItem.asstItems.length > 0 && asstItem.asstItems[0].startNumber != null) {
                for (AsstActType itemType : items) {
                    String endNumber;
                    AssistantItem assistantItem = acctext.accountItem.getItem(itemType.number);
                    if (assistantItem == null || StringUtils.isEmpty((String)assistantItem.startItem.number) || StringUtils.isEmpty((String)assistantItem.endItem.number)) continue;
                    boolean isGeneralasstacttype = itemType.useLongNumber || itemType.realtionDataObject.equalsIgnoreCase("t_bd_generalasstacttype");
                    String startNumber = isGeneralasstacttype ? assistantItem.startItem.longNumber : assistantItem.startItem.number;
                    String string = endNumber = isGeneralasstacttype ? assistantItem.endItem.longNumber : assistantItem.endItem.number;
                    if (startNumber.equals(endNumber)) {
                        if (singleNumberList == null) {
                            singleNumberList = new ArrayList<String[]>();
                        }
                        singleNumberList.add(new String[]{itemType.number, isGeneralasstacttype ? "FLongNumber" : "FNumber"});
                        continue;
                    }
                    if (doubleNumberList == null) {
                        doubleNumberList = new ArrayList<String[]>();
                    }
                    doubleNumberList.add(new String[]{itemType.number, startNumber, endNumber, isGeneralasstacttype ? "FLongNumber" : "FNumber"});
                }
                this.acctExtSortState.setSingleAsstActItem(singleNumberList);
                this.acctExtSortState.setAsstActItems(doubleNumberList);
            }
        }
    }
}

