/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acctitem;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.FormulaAdapter;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLPermissionUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.gr.fast.util.FastMergeUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.batch.AbstractFormulaCalculatorParameter;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fi.rpt.batch.IFormulaCombinationPreparedState;
import com.kingdee.eas.fi.rpt.batch.IFormulaMutiReturnValue;
import com.kingdee.eas.fi.rpt.batch.acctitem.AcctItemCombinestate;
import com.kingdee.eas.fi.rpt.util.CachingMap;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.ma.budget.BgRptReportPropertyAdapter;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AcctItem
extends AbstractFormulaCalculatorParameter
implements IFormulaMutiReturnValue {
    public static final Logger logger = Logger.getLogger(AcctItem.class);
    private static final String BEFOREADJUST = "BEFOREADJUST";
    private static final String ADJUSTING = "ADJUSTING";
    private static final String ADJUSTED = "ADJUSTED";
    private static final String CALIADJUSTTING = "CALIADJUSTTING";
    private static final String CALIADJUSTED = "CALIADJUSTED";
    private BatchHelper batchHelper;
    Context serverContext;
    String orgBoundNumber;
    String orgUnitNumbers;
    String sourceCurrencyNumber;
    String convertCurrencyNumber;
    String startItemNumber;
    String endItemNumber;
    String rptPeriodType;
    int yearOffset;
    int startPeriodOffset;
    int endPeriodOffset;
    String dataSource;
    String dataElement;
    String valueType;
    String dataCollectNumber;
    boolean isAdjusted;
    boolean isGroupUnCommited;
    int int_periodType;
    int int_dataSource;
    int int_dataElement;
    int startYear;
    int endYear;
    int startPeriod;
    int endPeriod;
    int int_valueType;
    Set orgBoundIDSet;
    int commitStatus;
    int itemNumberLevelStart = 0;
    int itemNumberLevelEnd = 5;
    List itemFromToList;
    String baseOrgTreeId;
    Set baseOrgTreeIdSet;
    int[] dataSourceArray;
    int calcType;
    boolean calcOnceMore;
    boolean isNeedCalculate = true;
    boolean isConvertedCompany;
    Map dataCollectPermissionMap;
    Map orgTreeMap;
    boolean isSupportOtherDS = false;
    boolean isCaliber = false;
    private Map valueMap = new HashMap();
    private boolean isSupport13Period = false;
    public PeriodCollection currPeriodColls = null;
    public boolean isMergeByFiscalPeriod = false;
    private boolean isCheckPermission = true;
    String mergeSchmNum;
    private boolean isParamadjustSeparate = false;

    public AcctItem(Parameter param, BatchHelper batchHelper, int calcType, PeriodCollection currPeriodColls, boolean isMergeByFiscalPeriod) {
        this.orgBoundIDSet = new HashSet();
        this.baseOrgTreeIdSet = new HashSet();
        this.itemFromToList = new ArrayList();
        this.batchHelper = batchHelper;
        this.serverContext = batchHelper.getServerContext();
        this.calcType = calcType;
        this.currPeriodColls = currPeriodColls;
        this.isMergeByFiscalPeriod = isMergeByFiscalPeriod;
        this.setParameter(param);
    }

    public void initFormulaParam() {
        try {
            this.initArgs();
            this.verifyArgs();
        }
        catch (EASBizException e) {
            logger.error((Object)"acctItem initFormulaParam ERROR", (Throwable)e);
            this.setException((Exception)((Object)e));
        }
        catch (BOSException e) {
            logger.error((Object)"acctItem initFormulaParam ERROR", (Throwable)e);
            this.setException((Exception)((Object)e));
        }
        catch (Exception e) {
            logger.error((Object)"acctItem initFormulaParam ERROR", (Throwable)e);
            this.setException((Exception)((Object)new ReportException(ReportException.FORMULA_PARAM_ERROR)));
        }
    }

    public BatchHelper getBatchHelper() {
        return this.batchHelper;
    }

    private String[] getBgUnit_Number() throws EASBizException, BOSException {
        String number = (String)this.batchHelper.getCalCulateContext().getReportAdapter().getReportProperty("BgCostCenterNum");
        Map<String, String[]> bgOrgCache = (HashMap)this.batchHelper.getCacheContainer().get("bgOrgCache");
        if (bgOrgCache == null) {
            bgOrgCache = new CachingMap();
            this.batchHelper.getCacheContainer().put("bgOrgCache", bgOrgCache);
        }
        if (bgOrgCache.get(number) != null) {
            return (String[])bgOrgCache.get(number);
        }
        FullOrgUnitInfo unit = null;
        FullOrgUnitCollection fullOrgUnitCollection = FullOrgUnitFactory.getLocalInstance((Context)this.batchHelper.getServerContext()).getFullOrgUnitCollection(" where number = '" + number + "'");
        if (fullOrgUnitCollection != null && fullOrgUnitCollection.size() > 0) {
            unit = fullOrgUnitCollection.get(0);
        }
        if (unit != null && unit.isIsCompanyOrgUnit()) {
            CompanyOrgUnitInfo companyOrgUnit = null;
            CompanyOrgUnitCollection companyOrgUnitCollection = CompanyOrgUnitFactory.getLocalInstance((Context)this.batchHelper.getServerContext()).getCompanyOrgUnitCollection(" where number = '" + number + "'");
            if (companyOrgUnitCollection != null && companyOrgUnitCollection.size() > 0) {
                companyOrgUnit = companyOrgUnitCollection.get(0);
            }
            if (companyOrgUnit != null && companyOrgUnit.isIsBizUnit()) {
                String[] result = new String[]{number, this.orgBoundNumber, null};
                bgOrgCache.put(number, result);
                return result;
            }
        }
        if (unit != null) {
            StringBuffer sql = new StringBuffer();
            Timestamp startTime = new Timestamp(FiscalPeriodHelper.getPeriodFirstDate((int)this.startYear, (int)this.startPeriod, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)this.int_periodType), (PeriodCollection)this.currPeriodColls, (boolean)this.isMergeByFiscalPeriod).getTime());
            Timestamp endTimestamp = new Timestamp(FiscalPeriodHelper.getPeriodLastDate((PeriodCollection)this.currPeriodColls, (int)this.endYear, (int)this.endPeriod, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)this.int_periodType), (boolean)this.isMergeByFiscalPeriod).getTime());
            sql.append("select distinct t.FNumber treenumber, u.FNumber unitnumber,t.FStartDate \n");
            sql.append(" from T_BG_BgJCArea b join t_org_tree t on b.FareaId = t.FId            \n");
            sql.append(" join t_org_baseunit u on b.FUnitId = u.FId                             \n");
            sql.append(" where b.FOrgUnitId = ? and ((t.FStartDate >= ? and t.FStartDate<= ?)   \n");
            sql.append(" or ( t.FEndDate >=? and t.FEndDate <= ? ) or ( t.FStartDate <=? and t.FEndDate >= ? ) \n");
            sql.append(" or (t.FStartDate <= ? and t.FEndDate is null) ) order by t.FStartDate desc");
            IRowSet rowSet = DbUtil.executeQuery((Context)this.batchHelper.getServerContext(), (String)sql.toString(), (Object[])new Object[]{unit.getId().toString(), startTime, endTimestamp, startTime, endTimestamp, startTime, endTimestamp, startTime});
            try {
                if (rowSet.next()) {
                    String[] result = new String[]{rowSet.getString("unitnumber"), rowSet.getString("treenumber"), "converted"};
                    bgOrgCache.put(number, result);
                    return result;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        throw new ReportException(ReportException.COMMON_EXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"45_AcctItemCalcuter", (Locale)this.serverContext.getLocale())});
    }

    @Override
    protected void initArgs() throws BOSException, EASBizException {
        int argsIndex;
        Object[] args = this.getParameter().getArgs();
        if (args[0] instanceof Object[]) {
            args = (Object[])args[0];
        }
        this.orgBoundNumber = ((Variant)args[argsIndex = 0]).getValue() == null ? null : ((Variant)args[argsIndex]).getValue().toString();
        this.orgUnitNumbers = ((Variant)args[++argsIndex]).getValue() == null ? null : ((Variant)args[argsIndex]).getValue().toString();
        this.sourceCurrencyNumber = ((Variant)args[++argsIndex]).getValue() == null ? null : ((Variant)args[argsIndex]).getValue().toString();
        this.convertCurrencyNumber = ((Variant)args[++argsIndex]).getValue() == null ? null : ((Variant)args[argsIndex]).getValue().toString();
        this.startItemNumber = ((Variant)args[++argsIndex]).getValue() == null ? null : ((Variant)args[argsIndex]).getValue().toString();
        this.endItemNumber = ((Variant)args[++argsIndex]).getValue() == null ? null : ((Variant)args[argsIndex]).getValue().toString();
        this.rptPeriodType = ((Variant)args[++argsIndex]).getValue() == null ? null : ((Variant)args[argsIndex]).getValue().toString();
        this.yearOffset = this.batchHelper.initNumberParam((Variant)args[++argsIndex]);
        this.startPeriodOffset = this.batchHelper.initNumberParam((Variant)args[++argsIndex]);
        this.endPeriodOffset = this.batchHelper.initNumberParam((Variant)args[++argsIndex]);
        this.dataSource = ((Variant)args[++argsIndex]).getValue() == null ? null : ((Variant)args[argsIndex]).getValue().toString();
        this.dataElement = ((Variant)args[++argsIndex]).getValue() == null ? null : ((Variant)args[argsIndex]).getValue().toString();
        this.valueType = ((Variant)args[++argsIndex]).getValue() == null ? null : ((Variant)args[argsIndex]).getValue().toString();
        boolean bl = this.isAdjusted = ((Variant)args[++argsIndex]).getValue() == null ? false : (Boolean)((Variant)args[argsIndex]).getValue();
        if (args.length > 14) {
            if (args.length == 15) {
                if (((Variant)args[++argsIndex]).getValue() != null && ((Variant)args[argsIndex]).getValue().toString().equalsIgnoreCase("ACTUALDATA") || ((Variant)args[argsIndex]).getValue().toString().equalsIgnoreCase("BUDGETDATA")) {
                    this.dataCollectNumber = ((Variant)args[argsIndex]).getValue().toString();
                } else if (((Variant)args[argsIndex]).getValue() != null && ((Variant)args[argsIndex]).getValue().toString().equalsIgnoreCase("true") || ((Variant)args[argsIndex]).getValue().toString().equalsIgnoreCase("false")) {
                    if (((Variant)args[argsIndex]).getValue() instanceof Boolean) {
                        this.isGroupUnCommited = (Boolean)((Variant)args[argsIndex]).getValue();
                    } else if (((Variant)args[argsIndex]).getValue() instanceof String) {
                        this.isGroupUnCommited = Boolean.valueOf((String)((Variant)args[argsIndex]).getValue());
                    }
                }
            } else {
                if (((Variant)args[++argsIndex]).getValue() != null && ((Variant)args[argsIndex]).getValue().toString().equalsIgnoreCase("ACTUALDATA") || ((Variant)args[argsIndex]).getValue().toString().equalsIgnoreCase("BUDGETDATA")) {
                    this.dataCollectNumber = ((Variant)args[argsIndex]).getValue().toString();
                } else if (((Variant)args[argsIndex]).getValue() != null && ((Variant)args[argsIndex]).getValue().toString().equalsIgnoreCase("true") || ((Variant)args[argsIndex]).getValue().toString().equalsIgnoreCase("false")) {
                    if (((Variant)args[argsIndex]).getValue() instanceof Boolean) {
                        this.isGroupUnCommited = (Boolean)((Variant)args[argsIndex]).getValue();
                    } else if (((Variant)args[argsIndex]).getValue() instanceof String) {
                        this.isGroupUnCommited = Boolean.valueOf((String)((Variant)args[argsIndex]).getValue());
                    }
                }
                if (((Variant)args[++argsIndex]).getValue() != null && ((Variant)args[argsIndex]).getValue().toString().equalsIgnoreCase("true") || ((Variant)args[argsIndex]).getValue().toString().equalsIgnoreCase("false")) {
                    if (((Variant)args[argsIndex]).getValue() instanceof Boolean) {
                        this.isGroupUnCommited = (Boolean)((Variant)args[argsIndex]).getValue();
                    } else if (((Variant)args[argsIndex]).getValue() instanceof String) {
                        this.isGroupUnCommited = Boolean.valueOf((String)((Variant)args[argsIndex]).getValue());
                    }
                } else if (((Variant)args[argsIndex]).getValue() != null && ((Variant)args[argsIndex]).getValue().toString().equalsIgnoreCase("ACTUALDATA") || ((Variant)args[argsIndex]).getValue().toString().equalsIgnoreCase("BUDGETDATA")) {
                    this.dataCollectNumber = ((Variant)args[argsIndex]).getValue().toString();
                }
                if (args.length >= 17) {
                    boolean bl2 = this.isCaliber = ((Variant)args[++argsIndex]).getValue() == null ? false : (Boolean)((Variant)args[argsIndex]).getValue();
                }
                if (args.length >= 18) {
                    this.mergeSchmNum = (String)((Variant)args[++argsIndex]).getValue();
                }
            }
        }
        if (this.calcType == 2) {
            this.isGroupUnCommited = true;
        }
    }

    public void setBatchHelper(BatchHelper batchHelper) {
        this.batchHelper = batchHelper;
    }

    public void setCalcType(int calcType) {
        this.calcType = calcType;
    }

    public void setDataCollectPermissionMap(Map dataCollectPermissionMap) {
        this.dataCollectPermissionMap = dataCollectPermissionMap;
    }

    public void setSupportOtherDS(boolean isSupportOtherDS) {
        this.isSupportOtherDS = isSupportOtherDS;
    }

    public void setOrgTreeMap(Map orgTreeMap) {
        this.orgTreeMap = orgTreeMap;
    }

    @Override
    protected void verifyArgs() throws BOSException, EASBizException {
        int[] yd;
        boolean isOrgUnitNumberEmpty = false;
        if (StringUtils.isEmpty((String)this.orgUnitNumbers)) {
            if (this.batchHelper.getCalCulateContext().getReportAdapter() instanceof BgRptReportPropertyAdapter) {
                String[] bgUnit_Number = this.getBgUnit_Number();
                this.orgUnitNumbers = bgUnit_Number[0];
                this.orgBoundNumber = bgUnit_Number[1];
                if (bgUnit_Number[2] != null) {
                    this.isConvertedCompany = true;
                }
            } else {
                isOrgUnitNumberEmpty = true;
                this.orgUnitNumbers = this.batchHelper.getOrgUnit_Number();
                if (StringUtils.isEmpty((String)this.orgUnitNumbers)) {
                    this.orgUnitNumbers = this.batchHelper.getCompany_Number();
                }
            }
        }
        if (this.convertCurrencyNumber == null || this.convertCurrencyNumber.trim().equals("")) {
            this.convertCurrencyNumber = this.getBatchHelper().getCorrect_Currency_Number(this.getSheetName());
            if ("GLC".equalsIgnoreCase(this.convertCurrencyNumber) || "GRC".equalsIgnoreCase(this.convertCurrencyNumber)) {
                this.convertCurrencyNumber = this.batchHelper.getCorrect_Currency_Number();
            }
        }
        this.int_periodType = StringUtils.isEmpty((String)this.rptPeriodType) ? this.batchHelper.getReport_PeriodType() : FormulaAdapter.getRptPeriodType((String)this.rptPeriodType);
        if (-1 == this.int_periodType) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"49_AdjustDataCalculator", (Locale)this.serverContext.getLocale())});
        }
        if (this.yearOffset == -9999 || this.startPeriodOffset == -9999 || this.endPeriodOffset == -9999) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"0_AcctStruct", (Locale)this.serverContext.getLocale())});
        }
        int rptYear = this.batchHelper.getReport_Year();
        int rptPeriod = this.batchHelper.getReport_Period();
        if (this.batchHelper.getCalCulateContext().getReportAdapter() instanceof BgRptReportPropertyAdapter) {
            String bfperiodNumber = (String)this.batchHelper.getCalCulateContext().getReportAdapter().getReportProperty("BG_PERIOD_NUMBER");
            yd = null;
            try {
                yd = RptUtil.transYearAndPeriodFromBgNumber2(bfperiodNumber);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            rptYear = yd[0];
            rptPeriod = yd[1];
        }
        if (this.int_periodType != this.batchHelper.getReport_PeriodType() && rptYear > 0 && rptPeriod > 0) {
            Date date = FiscalPeriodHelper.getPeriodLastDate((PeriodCollection)this.currPeriodColls, (int)rptYear, (int)rptPeriod, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)this.batchHelper.getReport_PeriodType()), (boolean)this.isMergeByFiscalPeriod);
            yd = FiscalPeriodHelper.getYearAndPeriod((PeriodCollection)this.currPeriodColls, (Date)date, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)this.int_periodType), (boolean)this.isMergeByFiscalPeriod);
            rptYear = yd[0];
            rptPeriod = yd[1];
        }
        int[] start = FiscalPeriodHelper.getRptFormualYearAndPeriod((boolean)this.isSupport13Period, (PeriodCollection)this.currPeriodColls, (int)rptYear, (int)rptPeriod, (int)this.int_periodType, (int)this.yearOffset, (int)this.startPeriodOffset, (boolean)this.isMergeByFiscalPeriod);
        int[] end = FiscalPeriodHelper.getRptFormualYearAndPeriod((boolean)this.isSupport13Period, (PeriodCollection)this.currPeriodColls, (int)rptYear, (int)rptPeriod, (int)this.int_periodType, (int)this.yearOffset, (int)this.endPeriodOffset, (boolean)this.isMergeByFiscalPeriod);
        if (start == null) {
            this.startYear = rptYear;
            this.startPeriod = rptPeriod;
        } else {
            this.startYear = start[0];
            this.startPeriod = start[1];
        }
        if (end == null) {
            this.endYear = rptYear;
            this.endPeriod = rptPeriod;
        } else {
            this.endYear = end[0];
            this.endPeriod = end[1];
        }
        if (this.orgBoundNumber == null || this.orgBoundNumber.trim().equals("")) {
            this.orgBoundNumber = this.getBatchHelper().getOrgTreeNumber();
            int rptDataSource = this.getBatchHelper().getReport_SourceType();
            int datasource = FormulaAdapter.getDataSource((String)this.dataSource);
            if (this.orgBoundNumber == null && (datasource == 7 || datasource == 1 || rptDataSource == 7 || rptDataSource == 1)) {
                this.orgBoundNumber = this.getBatchHelper().getOrgTreeNumber(this.startYear, this.startPeriod, this.endYear, this.endPeriod, this.int_periodType, this.orgUnitNumbers, this.orgTreeMap, this.currPeriodColls, this.isMergeByFiscalPeriod);
            }
            if (this.orgBoundNumber == null) {
                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"42_AcctItemCalcuter", (Locale)this.serverContext.getLocale())});
            }
        }
        if (this.isCheckPermission) {
            int datasource = FormulaAdapter.getDataSource((String)this.dataSource);
            if (datasource == 7 || datasource == 1) {
                this.getBatchHelper().checkCommitRepotPermision(this.orgBoundNumber, this.orgUnitNumbers);
            } else if (!this.orgBoundNumber.equals(this.getBatchHelper().getOrgTreeNumber())) {
                this.getBatchHelper().checkOrgTreePremision(this.orgBoundNumber);
            }
        }
        this.int_dataSource = FormulaAdapter.getDataSource((String)this.dataSource);
        if (-1 == this.int_dataSource) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"61_DyItemCalculator", (Locale)this.serverContext.getLocale())});
        }
        this.dataSourceArray = new int[]{this.int_dataSource};
        this.int_dataElement = -1;
        if (this.serverContext == null && !StringUtils.isEmpty((String)this.dataElement)) {
            this.int_dataElement = DataElementProvider.getDataElementInnerValue((String)this.dataElement);
        } else if (!StringUtils.isEmpty((String)this.dataElement)) {
            this.int_dataElement = DataElementProvider.getDataElementInnerValue((Context)this.serverContext, (String)this.dataElement);
        }
        this.int_valueType = FormulaAdapter.getValueType((String)this.valueType);
        if (-1 == this.int_valueType) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"51_AdjustDataCalculator", (Locale)this.serverContext.getLocale())});
        }
        if (StringUtils.isEmpty((String)this.dataCollectNumber)) {
            this.dataCollectNumber = this.batchHelper.getDataCollectNumber();
        }
        if (this.isSupportOtherDS) {
            CSLPermissionUtil.checkDataCollectPermissionForFormula((Context)this.serverContext, (String)this.serverContext.getCaller().toString(), (String)this.dataCollectNumber, (Map)this.dataCollectPermissionMap);
        }
        this.commitStatus = 3;
        boolean isFastMergeRpt = FastMergeUtil.isFastMergeRpt((int)this.int_dataSource);
        if (StringUtils.isEmpty((String)this.mergeSchmNum) && isFastMergeRpt) {
            this.mergeSchmNum = (String)this.batchHelper.getCalCulateContext().getReportAdapter().getReportProperty("MergeSchmNum");
        }
        if (!isFastMergeRpt) {
            this.mergeSchmNum = null;
        }
    }

    @Override
    public Object getMutiReturnValue() {
        BigDecimal returnValue = new BigDecimal("0");
        if (this.isCaliber) {
            if (this.valueMap.get(CALIADJUSTED) != null && this.valueMap.get(CALIADJUSTED) instanceof BigDecimal) {
                return (BigDecimal)this.valueMap.get(CALIADJUSTED);
            }
            returnValue = returnValue.add(this.getAdjustedValue());
            Object caliAdjustting = this.valueMap.get(CALIADJUSTTING);
            if (caliAdjustting instanceof BigDecimal && this.calcType != 2) {
                returnValue = returnValue.add((BigDecimal)caliAdjustting);
            }
            return returnValue;
        }
        if (this.isAdjusted) {
            return this.getAdjustedValue();
        }
        return returnValue;
    }

    private BigDecimal getAdjustedValue() {
        Object adjusting;
        BigDecimal returnValue = new BigDecimal("0");
        Object beforeAdjust = this.valueMap.get(BEFOREADJUST);
        if (beforeAdjust instanceof BigDecimal) {
            returnValue = returnValue.add((BigDecimal)beforeAdjust);
        }
        if ((adjusting = this.valueMap.get(ADJUSTING)) instanceof BigDecimal && this.calcType != 2) {
            returnValue = returnValue.add((BigDecimal)adjusting);
        }
        return returnValue;
    }

    @Override
    public void processMutiReturnValue(IFormulaCombinationPreparedState combineState) {
        AcctItemCombinestate acctItemCombinestate = (AcctItemCombinestate)combineState;
        int adjustStatus = acctItemCombinestate.getAdjustStatus();
        if (adjustStatus == 0) {
            this.processReturnValue(combineState, BEFOREADJUST);
        } else if (adjustStatus == 1) {
            this.processReturnValue(combineState, ADJUSTING);
        } else if (adjustStatus == 2) {
            this.processReturnValue(combineState, ADJUSTED);
        } else if (adjustStatus == 11) {
            this.processReturnValue(combineState, CALIADJUSTTING);
        } else if (adjustStatus == 12) {
            this.processReturnValue(combineState, CALIADJUSTED);
        }
    }

    private void processReturnValue(IFormulaCombinationPreparedState combineState, String adjustStatus) {
        BigDecimal value = (BigDecimal)this.valueMap.get(adjustStatus);
        Object returnVal = combineState.getFormulaResultValue(this);
        if (returnVal instanceof BigDecimal) {
            value = value != null && value instanceof BigDecimal ? value.add((BigDecimal)returnVal) : (BigDecimal)returnVal;
            this.valueMap.put(adjustStatus, value);
        }
    }

    public boolean isSupport13Period() {
        return this.isSupport13Period;
    }

    public void setSupport13Period(boolean isSupport13Period) {
        this.isSupport13Period = isSupport13Period;
    }

    public void setCheckPermission(boolean isCheckPermission) {
        this.isCheckPermission = isCheckPermission;
    }

    public boolean isParamadjustSeparate() {
        return this.isParamadjustSeparate;
    }

    public void setParamadjustSeparate(boolean isParamadjustSeparate) {
        this.isParamadjustSeparate = isParamadjustSeparate;
    }

    public AcctItem copy() {
        AcctItem copyAcctItem = new AcctItem(this.getParameter(), this.batchHelper, this.calcType, this.currPeriodColls, this.isMergeByFiscalPeriod);
        copyAcctItem.setDataCollectPermissionMap(this.dataCollectPermissionMap);
        copyAcctItem.setSupportOtherDS(this.isSupportOtherDS);
        copyAcctItem.setOrgTreeMap(this.orgTreeMap);
        copyAcctItem.setSupport13Period(this.isSupport13Period);
        copyAcctItem.setCheckPermission(this.isCheckPermission);
        copyAcctItem.setParamadjustSeparate(this.isParamadjustSeparate);
        copyAcctItem.orgBoundNumber = this.orgBoundNumber;
        copyAcctItem.orgUnitNumbers = this.orgUnitNumbers;
        copyAcctItem.sourceCurrencyNumber = this.sourceCurrencyNumber;
        copyAcctItem.convertCurrencyNumber = this.convertCurrencyNumber;
        copyAcctItem.startItemNumber = this.startItemNumber;
        copyAcctItem.endItemNumber = this.endItemNumber;
        copyAcctItem.rptPeriodType = this.rptPeriodType;
        copyAcctItem.yearOffset = this.yearOffset;
        copyAcctItem.startPeriodOffset = this.startPeriodOffset;
        copyAcctItem.endPeriodOffset = this.endPeriodOffset;
        copyAcctItem.dataSource = this.dataSource;
        copyAcctItem.dataElement = this.dataElement;
        copyAcctItem.valueType = this.valueType;
        copyAcctItem.isAdjusted = this.isAdjusted;
        copyAcctItem.dataCollectNumber = this.dataCollectNumber;
        copyAcctItem.isGroupUnCommited = this.isGroupUnCommited;
        copyAcctItem.isCaliber = this.isCaliber;
        copyAcctItem.mergeSchmNum = this.mergeSchmNum;
        copyAcctItem.isConvertedCompany = this.isConvertedCompany;
        copyAcctItem.int_periodType = this.int_periodType;
        copyAcctItem.startYear = this.startYear;
        copyAcctItem.startPeriod = this.startPeriod;
        copyAcctItem.endYear = this.endYear;
        copyAcctItem.endPeriod = this.endPeriod;
        copyAcctItem.int_dataSource = this.int_dataSource;
        copyAcctItem.dataSourceArray = this.dataSourceArray;
        copyAcctItem.int_dataElement = this.int_dataElement;
        copyAcctItem.int_valueType = this.int_valueType;
        copyAcctItem.commitStatus = this.commitStatus;
        return copyAcctItem;
    }

    class ItemFieldMapped {
        String number;
        String tableName;
        String fieldName;

        ItemFieldMapped() {
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ItemFieldMapped)) {
                return false;
            }
            ItemFieldMapped itemFieldMapped = (ItemFieldMapped)obj;
            if (obj == null) {
                return false;
            }
            if (!this.number.equals(itemFieldMapped.number)) {
                return false;
            }
            if (!this.tableName.equals(itemFieldMapped.tableName)) {
                return false;
            }
            return this.fieldName.equals(itemFieldMapped.fieldName);
        }
    }
}

