/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.age;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.param.ParamMutiLangFieldInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ColumnInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.TableInfo;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.app.AccountItemExt;
import com.kingdee.eas.fi.rpt.app.AssistantItemExt;
import com.kingdee.eas.fi.rpt.batch.AbstractCalculator;
import com.kingdee.eas.fi.rpt.batch.BatchSQLSorterRegister;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSorterRegister;
import com.kingdee.eas.fi.rpt.batch.age.Age;
import com.kingdee.eas.fi.rpt.batch.age.AgeBatchHistoryProcessor;
import com.kingdee.eas.fi.rpt.batch.age.AgeBatchProcessor;
import com.kingdee.eas.fi.rpt.batch.age.BalanceCalcProcessor;
import com.kingdee.eas.fi.rpt.batch.age.BalanceCalcSortRegister;
import com.kingdee.eas.fi.rpt.batch.age.balance.gl.QuerySubOrgByGLRule;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AgeBatchCalculator
extends AbstractCalculator {
    public static final Logger logger = Logger.getLogger(AgeBatchCalculator.class);
    private static final int BATCH_IN_SIZE = 1000;
    private static final String AGE_SORT_STATE = "com.kingdee.eas.fi.rpt.batch.age.AgeSortState";
    private static final String HISTORY_AGE_SORT_STATE = "com.kingdee.eas.fi.rpt.batch.age.AgeHistorySortState";
    public static final String MULTI_COMPANY_SEPARATOR_REGEX = "\\,|\\;";
    private Set asstActTypeNumberSet;
    private Map companyNumber2IDMap;
    private Map<String, String> companyID2BaseCurrencyIDMap;
    private Map<String, Map<AccountViewInfo, List<HashMap<String, Object>>>> asstActTypeMap;
    private Set<List<String>> accountTempTblParam = null;
    private Map<String, String> companyNumber2AccountTableIDMap = null;
    private Map currencyNumber2IDMap;
    private Map companyIdsForOnlyUnionCacheMap;
    private Set exchangeTmpTableParams = new HashSet(0);
    private IBatchSQLSorterRegister sortRegister;
    private IBatchSQLSorterRegister historySortRegister;
    private BalanceCalcSortRegister balanceCalcSortRegister;
    private AgeBatchProcessor ageBatchProcessor;
    private AgeBatchHistoryProcessor ageHistoryProcessor;
    private BalanceCalcProcessor balanceCalcProcessor;
    private String exchangeTmpTableName;
    private boolean isMergeByFiscalPeriod;
    PeriodCollection periods;

    public AgeBatchCalculator(ICalculateContextProvider context, Context serverCtx) {
        super(context, serverCtx);
        this.isMergeByFiscalPeriod = FiscalPeriodHelper.isMergeByFiscalPeriod((Context)serverCtx);
        RptPeriodTypeEnum periodTypeEnum = RptPeriodTypeEnum.getEnum((int)this.batchHelper.getReport_PeriodType());
        if (FiscalPeriodHelper.isMergeByFiscalPeriod((boolean)this.isMergeByFiscalPeriod, (RptPeriodTypeEnum)periodTypeEnum)) {
            try {
                this.periods = FiscalPeriodHelper.getPeriodCollection((Context)this.serverContext, (String)this.batchHelper.getCompany_ID());
            }
            catch (Exception e) {
                this.handleException(this.formulaCalculatorList, e);
                this.handleAllException();
            }
        }
    }

    @Override
    protected void init(SortedParameterArray params) throws BOSException, EASBizException {
        this.initSortRegister();
        this.initAges(params);
        this.initCompanyOrgUnit();
        this.initAsstActType();
        this.initCurrency();
        this.companyID2BaseCurrencyIDMap = null;
        this.accountTempTblParam = null;
        this.companyNumber2AccountTableIDMap = null;
        this.createExchangeTmpTable();
        this.initVerifyMode();
        this.submitFormula();
    }

    private void initSortRegister() {
        this.sortRegister = new BatchSQLSorterRegister(new HashMap(), AGE_SORT_STATE);
        this.historySortRegister = new BatchSQLSorterRegister(new HashMap(), HISTORY_AGE_SORT_STATE);
        this.balanceCalcSortRegister = new BalanceCalcSortRegister();
    }

    private void initAges(SortedParameterArray params) {
        this.asstActTypeNumberSet = new HashSet();
        this.companyNumber2IDMap = new HashMap();
        this.currencyNumber2IDMap = new HashMap();
        this.accountTempTblParam = new HashSet<List<String>>();
        HashMap companyPermissionMap = new HashMap();
        boolean isPass = false;
        AccountItemExt accountItem = null;
        CslRptUtil.initNationMapCatch((Context)this.batchHelper.getServerContext());
        for (int count = 0; count < params.size(); ++count) {
            Parameter parameter = params.getParameter(count);
            Age age = new Age(parameter, this.batchHelper, this.isMergeByFiscalPeriod, this.periods);
            age.initFormulaParam();
            if (age.isException()) {
                this.addToErrorList(age);
                continue;
            }
            String companyNumber = age.orgUnit;
            String acctItem = age.acctItem;
            if (companyNumber.contains(",") || companyNumber.contains(";")) {
                String[] numbers = companyNumber.split(MULTI_COMPANY_SEPARATOR_REGEX);
                for (int i = 0; i < numbers.length; ++i) {
                    String number = numbers[i];
                    if (acctItem.contains(",") || acctItem.contains(";")) {
                        String[] items = acctItem.split(MULTI_COMPANY_SEPARATOR_REGEX);
                        for (int j = 0; j < items.length; ++j) {
                            String item = items[j];
                            Age newAge = age.clone(parameter, this.batchHelper, this.isMergeByFiscalPeriod, this.periods);
                            if (newAge.isException()) {
                                this.addToErrorList(newAge);
                                continue;
                            }
                            newAge.orgUnit = number;
                            newAge.fiOrgUnit = number;
                            if (!(isPass = this.checkCompanyPermission(companyPermissionMap, newAge, number, isPass))) continue;
                            try {
                                if (item == null || item.length() < 1) {
                                    this.addToErrorList(newAge, (Exception)((Object)new ReportException(ReportException.PARAM_IS_NOT_INTEGRATED)));
                                    continue;
                                }
                                accountItem = new AccountItemExt(item);
                            }
                            catch (Exception ex) {
                                this.addToErrorList(newAge, (Exception)((Object)new ReportException(ReportException.ACCOUNT_PARSE_ERROR)));
                                continue;
                            }
                            newAge.acctItem = item;
                            newAge.accountItem = accountItem;
                            if (newAge.accountItem.hasItem()) {
                                for (AssistantItemExt asst : newAge.accountItem.getItemTypes().values()) {
                                    this.asstActTypeNumberSet.add(asst.itemType.number);
                                }
                            }
                            this.getFormulaCalculatorParameterList().add(newAge);
                            this.putValueToAccountTempTblParam(accountItem);
                            this.companyNumber2IDMap.put(newAge.fiOrgUnit, null);
                            this.currencyNumber2IDMap.put(newAge.currency, null);
                        }
                        continue;
                    }
                    Age newAge = age.clone(parameter, this.batchHelper, this.isMergeByFiscalPeriod, this.periods);
                    if (newAge.isException()) {
                        this.addToErrorList(newAge);
                        continue;
                    }
                    newAge.orgUnit = number;
                    newAge.fiOrgUnit = number;
                    if (!(isPass = this.checkCompanyPermission(companyPermissionMap, newAge, number, isPass))) continue;
                    try {
                        if (acctItem == null || acctItem.length() < 1) {
                            this.addToErrorList(newAge, (Exception)((Object)new ReportException(ReportException.PARAM_IS_NOT_INTEGRATED)));
                            continue;
                        }
                        accountItem = new AccountItemExt(acctItem);
                    }
                    catch (Exception ex) {
                        this.addToErrorList(newAge, (Exception)((Object)new ReportException(ReportException.ACCOUNT_PARSE_ERROR)));
                        continue;
                    }
                    newAge.acctItem = acctItem;
                    newAge.accountItem = accountItem;
                    if (newAge.accountItem.hasItem()) {
                        for (AssistantItemExt asst : newAge.accountItem.getItemTypes().values()) {
                            this.asstActTypeNumberSet.add(asst.itemType.number);
                        }
                    }
                    this.getFormulaCalculatorParameterList().add(newAge);
                    this.putValueToAccountTempTblParam(accountItem);
                    this.companyNumber2IDMap.put(newAge.fiOrgUnit, null);
                    this.currencyNumber2IDMap.put(newAge.currency, null);
                }
                continue;
            }
            isPass = this.checkCompanyPermission(companyPermissionMap, age, companyNumber, isPass);
            this.companyNumber2IDMap.put(age.fiOrgUnit, null);
            this.currencyNumber2IDMap.put(age.currency, null);
            if (!isPass) continue;
            if (acctItem.contains(";") || acctItem.contains(",")) {
                String[] items = acctItem.split(MULTI_COMPANY_SEPARATOR_REGEX);
                for (int j = 0; j < items.length; ++j) {
                    Age newAge = age.clone(parameter, this.batchHelper, this.isMergeByFiscalPeriod, this.periods);
                    if (newAge.isException()) {
                        this.addToErrorList(newAge);
                        continue;
                    }
                    newAge.fiOrgUnit = companyNumber;
                    String item = items[j];
                    try {
                        if (item == null || item.length() < 1) {
                            this.addToErrorList(newAge, (Exception)((Object)new ReportException(ReportException.PARAM_IS_NOT_INTEGRATED)));
                            continue;
                        }
                        accountItem = new AccountItemExt(item);
                    }
                    catch (Exception ex) {
                        this.addToErrorList(newAge, (Exception)((Object)new ReportException(ReportException.ACCOUNT_PARSE_ERROR)));
                        continue;
                    }
                    newAge.acctItem = item;
                    newAge.accountItem = accountItem;
                    if (newAge.accountItem.hasItem()) {
                        for (AssistantItemExt asst : newAge.accountItem.getItemTypes().values()) {
                            this.asstActTypeNumberSet.add(asst.itemType.number);
                        }
                    }
                    this.getFormulaCalculatorParameterList().add(newAge);
                    this.putValueToAccountTempTblParam(accountItem);
                }
                continue;
            }
            try {
                if (acctItem == null || acctItem.length() < 1) {
                    this.addToErrorList(age, (Exception)((Object)new ReportException(ReportException.PARAM_IS_NOT_INTEGRATED)));
                    continue;
                }
                accountItem = new AccountItemExt(acctItem);
            }
            catch (Exception ex) {
                this.addToErrorList(age, (Exception)((Object)new ReportException(ReportException.ACCOUNT_PARSE_ERROR)));
                continue;
            }
            age.acctItem = acctItem;
            age.accountItem = accountItem;
            if (age.accountItem.hasItem()) {
                for (AssistantItemExt asst : age.accountItem.getItemTypes().values()) {
                    this.asstActTypeNumberSet.add(asst.itemType.number);
                }
            }
            this.getFormulaCalculatorParameterList().add(age);
            this.putValueToAccountTempTblParam(accountItem);
        }
        CslRptUtil.clearNationmapCatch((Context)this.batchHelper.getServerContext());
    }

    private void putValueToAccountTempTblParam(AccountItemExt accountItem) {
        ArrayList<String> accountParam = new ArrayList<String>();
        accountParam.add(accountItem.startAccount.getAccountNumber());
        accountParam.add(accountItem.endAccount.getAccountNumber());
        this.accountTempTblParam.add(accountParam);
    }

    private boolean checkCompanyPermission(Map companyPermissionMap, Age age, String number, boolean isPass) {
        try {
            if (!companyPermissionMap.containsKey(number)) {
                this.batchHelper.checkCompanyPermision(number);
                age.fiOrgUnit = number;
                companyPermissionMap.put(number, true);
            } else {
                age.fiOrgUnit = number;
            }
            isPass = true;
        }
        catch (Exception e) {
            age.setException(e);
            this.addToErrorList(age);
            companyPermissionMap.put(number, false);
            isPass = false;
        }
        return isPass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAsstActType() throws BOSException {
        if (this.asstActTypeNumberSet.size() == 0) {
            return;
        }
        ParamTempTblService tempService = null;
        try {
            TableInfo table = new TableInfo("t_temp_account");
            table.addColumn(new ColumnInfo("faccountStartNum", "varchar(200)"));
            table.addColumn(new ColumnInfo("faccountEndNum", "varchar(200)"));
            tempService = ParamTempTblService.getInstance((Context)this.serverContext, (TableInfo)table, this.accountTempTblParam, null);
            String tblName = tempService.getTmpTableName();
            StringBuffer sql = new StringBuffer();
            sql.append("select distinct rel.fid relid,item.fnumber typeNumber,item.fid typeId,item.fisforcompany isforcompany,\n");
            sql.append("item.fdefaultqueryname queryname,item.frealtiondataobject tablename, item.fassthgattribute propname, \n");
            sql.append("item.fmappingfieldname fieldname,item.fname_").append(this.serverContext.getLocale()).append(" typeName, \n");
            sql.append("account.fnumber accountNumber,account.faccounttableid accounttableid,account.fcompanyid accountOrgId, \n");
            sql.append(" item.FGLAsstActTypeGrpID,item.FUseLongNumber useLongNUmber from T_BD_AccountView account \n");
            sql.append(" inner join ").append(tblName).append(" accountTemp on (account.fnumber>=accountTemp.faccountStartNum and account.fnumber<=accountTemp.faccountEndNum) ");
            sql.append(" or account.fnumber like concat(accountTemp.faccountEndNum,'%') \n");
            sql.append(" inner join T_BD_AsstAccount book on account.fcaa = book.fid \n");
            sql.append(" inner join T_BD_AsstActGroupDetail rel on book.fid = rel.fasstaccountid \n");
            sql.append(" inner join T_BD_AsstActType item on item.fid = rel.fasstacttypeid \n");
            sql.append(" where account.fisleaf=1 and account.fac=1 and item.fnumber in ").append(this.batchHelper.createInSql(this.asstActTypeNumberSet.iterator()));
            sql.append(" and account.faccounttableid in ").append(this.batchHelper.createInSql(this.companyNumber2AccountTableIDMap.values().iterator()));
            sql.append(" and account.fcompanyId in ").append(this.batchHelper.createInSql(this.companyNumber2IDMap.values().iterator()));
            HashMap<String, AsstActTypeInfo> asstActTypeNumberMap = new HashMap<String, AsstActTypeInfo>();
            this.asstActTypeMap = new HashMap<String, Map<AccountViewInfo, List<HashMap<String, Object>>>>();
            try {
                IRowSet rs = DbUtil.executeQuery((Context)this.serverContext, (String)sql.toString());
                AsstActTypeInfo asstActTypeInfo = null;
                String mappingFieldName = null;
                String realtionDataObject = null;
                String asstActTypeNumber = null;
                MyAccountViewInfo accountViewInfo = null;
                Map<AccountViewInfo, List<HashMap<String, Object>>> accountViewAcctTypeMap = null;
                List<HashMap<String, Object>> oneAccountViewList = null;
                HashMap<String, Object> item = null;
                while (rs.next()) {
                    asstActTypeInfo = new AsstActTypeInfo();
                    mappingFieldName = rs.getString("fieldname");
                    realtionDataObject = rs.getString("tablename");
                    asstActTypeNumber = rs.getString("typeNumber");
                    asstActTypeInfo.setNumber(asstActTypeNumber);
                    asstActTypeInfo.setMappingFieldName(mappingFieldName);
                    asstActTypeInfo.setRealtionDataObject(realtionDataObject);
                    asstActTypeNumberMap.put(asstActTypeNumber, asstActTypeInfo);
                    accountViewAcctTypeMap = this.asstActTypeMap.get(asstActTypeNumber);
                    if (accountViewAcctTypeMap == null) {
                        accountViewAcctTypeMap = new HashMap<AccountViewInfo, List<HashMap<String, Object>>>();
                        this.asstActTypeMap.put(asstActTypeNumber, accountViewAcctTypeMap);
                    }
                    accountViewInfo = new MyAccountViewInfo();
                    accountViewInfo.setNumber(rs.getString("accountNumber"));
                    accountViewInfo.put("accounttableid", rs.getString("accounttableid"));
                    accountViewInfo.put("accountOrgId", rs.getString("accountOrgId"));
                    oneAccountViewList = accountViewAcctTypeMap.get((Object)accountViewInfo);
                    if (oneAccountViewList == null) {
                        oneAccountViewList = new ArrayList<HashMap<String, Object>>();
                        accountViewAcctTypeMap.put(accountViewInfo, oneAccountViewList);
                    }
                    item = new HashMap<String, Object>();
                    item.put("relid", rs.getString("relid"));
                    String id = rs.getString("typeId");
                    item.put("id", id);
                    item.put("isforcompany", rs.getBoolean("isforcompany"));
                    item.put("number", asstActTypeNumber);
                    item.put("name", rs.getString("typeName"));
                    item.put("queryname", rs.getString("queryname"));
                    item.put("propname", rs.getString("propname"));
                    item.put("fieldname", rs.getString("fieldname"));
                    item.put("tablename", rs.getString("tablename"));
                    item.put("FGLAsstActTypeGrpID", rs.getString("FGLAsstActTypeGrpID"));
                    item.put("useLongNUmber", rs.getBoolean("useLongNUmber"));
                    oneAccountViewList.add(item);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            AsstActTypeInfo asstActTypeInfo = null;
            for (Age age : this.getFormulaCalculatorParameterList()) {
                if (!age.accountItem.hasItem()) continue;
                for (AssistantItemExt asst : age.accountItem.getItemTypes().values()) {
                    asstActTypeInfo = (AsstActTypeInfo)asstActTypeNumberMap.get(asst.getItemTypeNumber());
                    if (asstActTypeInfo == null) continue;
                    asst.itemType.realtionDataObject = asstActTypeInfo.getRealtionDataObject();
                    asst.itemType.mappingFieldName = asstActTypeInfo.getMappingFieldName();
                    asst.itemType.number = asstActTypeInfo.getNumber();
                }
            }
        }
        finally {
            if (tempService != null && !DebugLogger.isDebug) {
                tempService.release();
            }
        }
    }

    private void initCompanyOrgUnit() throws BOSException {
        if (this.companyNumber2IDMap.size() == 0) {
            return;
        }
        this.companyNumber2AccountTableIDMap = new HashMap<String, String>();
        HashMap<String, Boolean> companyNumber2IsBizUnit = new HashMap<String, Boolean>();
        StringBuffer sql = new StringBuffer();
        sql.append("Select FID,FNumber,FAccountTableID,FisBizunit,FBaseCurrencyID from T_ORG_Company where FNumber in ");
        sql.append(this.batchHelper.createInSql(this.companyNumber2IDMap.keySet().iterator()));
        IRowSet rowSet = DbUtil.executeQuery((Context)this.serverContext, (String)sql.toString());
        try {
            this.companyID2BaseCurrencyIDMap = new HashMap<String, String>();
            String companyId = null;
            while (rowSet.next()) {
                companyId = rowSet.getString("FID");
                this.companyNumber2IDMap.put(rowSet.getString("FNumber"), companyId);
                this.companyNumber2AccountTableIDMap.put(rowSet.getString("FNumber"), rowSet.getString("FAccountTableID"));
                companyNumber2IsBizUnit.put(rowSet.getString("FNumber"), rowSet.getInt("FisBizunit") == 1 ? Boolean.TRUE : Boolean.FALSE);
                this.companyID2BaseCurrencyIDMap.put(companyId, rowSet.getString("FBaseCurrencyID"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)"initCompanyOrgUnit error ", (Throwable)e);
            throw new SQLDataException(e);
        }
        for (Age age : this.getFormulaCalculatorParameterList()) {
            age.companyId = (String)this.companyNumber2IDMap.get(age.fiOrgUnit);
            age.accountTableId = this.companyNumber2AccountTableIDMap.get(age.fiOrgUnit);
            if (companyNumber2IsBizUnit.get(age.fiOrgUnit) instanceof Boolean) {
                age.isBizunit = (Boolean)companyNumber2IsBizUnit.get(age.fiOrgUnit);
            }
            if (age.companyId == null) {
                this.addToErrorList(age, (Exception)((Object)new ReportException(ReportException.CMPNULL)));
                continue;
            }
            if (age.isBizunit.booleanValue()) continue;
            if (this.companyIdsForOnlyUnionCacheMap == null) {
                this.companyIdsForOnlyUnionCacheMap = new HashMap();
            }
            if (this.companyIdsForOnlyUnionCacheMap.containsKey(age.companyId)) {
                age.companyIdsForOnlyUnion = this.companyIdsForOnlyUnionCacheMap.get(age.companyId).toString();
                continue;
            }
            try {
                String subOrgIds;
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("accountPeriodType.id"));
                selector.add(new SelectorItemInfo("accountTable.id"));
                selector.add(new SelectorItemInfo("longNumber"));
                CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.serverContext).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(age.companyId), selector);
                age.companyIdsForOnlyUnion = subOrgIds = new QuerySubOrgByGLRule().exec(this.serverContext, companyInfo);
                this.companyIdsForOnlyUnionCacheMap.put(age.companyId, subOrgIds);
            }
            catch (EASBizException e) {
                this.handleException(this.formulaCalculatorList, (Exception)((Object)e));
            }
        }
    }

    private void initCurrency() throws BOSException, EASBizException {
        if (this.currencyNumber2IDMap.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("Select FID,FNumber from T_BD_Currency where FNumber in ");
        sql.append(this.batchHelper.createInSql(this.currencyNumber2IDMap.keySet().iterator()));
        IRowSet rowSet = DbUtil.executeQuery((Context)this.serverContext, (String)sql.toString());
        try {
            while (rowSet.next()) {
                this.currencyNumber2IDMap.put(rowSet.getString("FNumber"), rowSet.getString("FID"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        for (Age age : this.getFormulaCalculatorParameterList()) {
            age.currencyid = (String)this.currencyNumber2IDMap.get(age.currency);
            if (age.currencyid == null) {
                this.addToErrorList(age, (Exception)((Object)new ReportException(ReportException.CRYNULL)));
                continue;
            }
            if (CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(age.currencyid)) {
                String noGeneralCurrencyId = this.companyID2BaseCurrencyIDMap.get(age.companyId);
                this.exchangeTmpTableParams.add(new ExchangeTmpTableParam(age.companyId, age.fromDate, noGeneralCurrencyId));
                age.noGeneralCurrencyId = noGeneralCurrencyId;
                age.isGeneralCurrency = false;
                continue;
            }
            if (CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(age.currencyid)) {
                this.exchangeTmpTableParams.add(new ExchangeTmpTableParam(age.companyId, age.fromDate, age.currencyid));
                age.isGeneralCurrency = false;
                continue;
            }
            age.isGeneralCurrency = true;
        }
    }

    private void releaseExchangeTmpTable(String tmpTableName) {
        if (tmpTableName == null) {
            tmpTableName = this.exchangeTmpTableName;
        }
        if (tmpTableName == null) {
            return;
        }
        TempTablePool.getInstance((Context)this.batchHelper.getServerContext()).releaseTable(tmpTableName);
    }

    private void createExchangeTmpTable() throws BOSException {
        String initTempTableName;
        if (this.exchangeTmpTableParams.isEmpty()) {
            return;
        }
        String tempateTable = initTempTableName = "AgeBatchCalculator";
        JdbcRowSet result = null;
        try {
            result = new JdbcRowSet();
            StringBuffer craeteTableSQL = new StringBuffer();
            craeteTableSQL.append("CREATE TABLE " + tempateTable + " ( ");
            craeteTableSQL.append("\t\tFCompanyID \t\tVARCHAR (44) NOT NULL, ");
            craeteTableSQL.append("\t\tFSrcCurrencyID \tVARCHAR (44) NOT NULL, ");
            craeteTableSQL.append("\t\tFTrgCurrencyID \tVARCHAR (44) NOT NULL, ");
            craeteTableSQL.append("\t\tFConvertRateA  \tNUMERIC(28,10),");
            craeteTableSQL.append("\t\tFAvailTime  \tTIMESTAMP ");
            craeteTableSQL.append(")");
            tempateTable = TempTablePool.getInstance((Context)this.serverContext).createTempTable(craeteTableSQL.toString());
            StringBuffer searchSql = new StringBuffer();
            int size = 1000;
            if (this.exchangeTmpTableParams.size() < 1000) {
                size = this.exchangeTmpTableParams.size();
            }
            ArrayList<Object> sqlParams = new ArrayList<Object>(size * 3);
            searchSql.append(" SELECT DISTINCT company.Fid COMP_ID ,\t\n");
            searchSql.append(" \t\taux.FSourceCurrencyID,  \t\t\t\n");
            searchSql.append(" \t\taux.FTargetCurrencyID,  \t\t\t\n");
            searchSql.append(" \t\texch.FConvertRate, \t\t\t\t\t\n");
            searchSql.append(" \t\texch.FAvailTime \t\t\t\t\t\n");
            searchSql.append(" \t\t,CASE\texch.FQuotePrice   \t\t\t\n");
            searchSql.append(" \t\t\tWHEN\t1 THEN 1  \t\t\t\t\n");
            searchSql.append(" \t\t\tWHEN\t2 THEN 3  \t\t\t\t\n");
            searchSql.append(" \t\t\tWHEN\t3 THEN 2  \t\t\t\t\n");
            searchSql.append(" \t\t\tELSE\texch.FQuotePrice\t\t\n");
            searchSql.append(" \t\tEND\tMIN_FQUOTE_PRICE_LEVEL\t\t\t\n");
            searchSql.append(" FROM T_BD_ExchangeAux aux  \t\t\t\t\n");
            searchSql.append(" INNER JOIN T_ORG_Company company on company.FAdjustExgTableID = aux.FExchangeTableId \t\n");
            searchSql.append(" INNER JOIN T_BD_ExchangeRate exch on exch.FExchangeAuxID = aux.FID \t\n");
            searchSql.append(" WHERE exch.FIsUsedBG = 0 \t\n");
            searchSql.append(" AND ( \t\n");
            String headSql = searchSql.toString();
            String orStr = " OR ";
            int i = -1;
            StringBuffer conBuffer = new StringBuffer(10000);
            Iterator it = this.exchangeTmpTableParams.iterator();
            while (it.hasNext()) {
                ++i;
                ExchangeTmpTableParam paramVal = (ExchangeTmpTableParam)it.next();
                conBuffer.append(" ( company.FId = ? ");
                conBuffer.append(" and exch.FAvailTime <= ?  ");
                conBuffer.append(" and aux.FTargetCurrencyID = ? )  \n");
                conBuffer.append(orStr);
                sqlParams.add(paramVal.getCompanyId());
                sqlParams.add(new Timestamp(paramVal.getToDate().getTime()));
                sqlParams.add(paramVal.getTargetCurrencyId());
                if (i < 1000) continue;
                this.constructTailSql(orStr, conBuffer);
                IRowSet rows = DbUtil.executeQuery((Context)this.serverContext, (String)(headSql + conBuffer.toString()), (Object[])sqlParams.toArray());
                result.populate((ResultSet)rows);
                i = -1;
                conBuffer = new StringBuffer(10000);
                sqlParams.clear();
            }
            if (i > -1) {
                this.constructTailSql(orStr, conBuffer);
                IRowSet rows = DbUtil.executeQuery((Context)this.serverContext, (String)(headSql + conBuffer.toString()), (Object[])sqlParams.toArray());
                result.populate((ResultSet)rows);
            }
            sqlParams = null;
            HashSet<Object[]> insertData = new HashSet<Object[]>();
            HashSet repeatSet = new HashSet();
            while (result.next()) {
                String compId = result.getString("COMP_ID");
                String srcCurrId = result.getString("FSourceCurrencyID");
                String trgCurrId = result.getString("FTargetCurrencyID");
                double exchangeVal = result.getDouble("FConvertRate");
                for (ExchangeTmpTableParam paramVal : this.exchangeTmpTableParams) {
                    if (!this.checkCanInsert(paramVal, (IRowSet)result, repeatSet)) continue;
                    insertData.add(new Object[]{compId, srcCurrId, trgCurrId, new Double(exchangeVal), paramVal.toDate});
                }
            }
            repeatSet = null;
            String insertSql = "insert into " + tempateTable + " VALUES (?,?,?,?,?)";
            DbUtil.executeBatch((Context)this.batchHelper.getServerContext(), (String)insertSql, new ArrayList(insertData));
            insertData = null;
            this.exchangeTmpTableName = tempateTable;
        }
        catch (Exception e) {
            if (tempateTable != null && !initTempTableName.equals(tempateTable)) {
                this.exchangeTmpTableName = null;
                this.releaseExchangeTmpTable(tempateTable);
            }
            throw new BOSException((Throwable)e);
        }
    }

    private void constructTailSql(String orStr, StringBuffer conBuffer) {
        conBuffer.delete(conBuffer.length() - orStr.length(), conBuffer.length());
        conBuffer.append(" ) \t\n");
        conBuffer.append(" ORDER BY company.Fid, \t\t\t\n");
        conBuffer.append(" aux.FSourceCurrencyID , \t\t\t\n");
        conBuffer.append(" aux.FTargetCurrencyID, \t\t\t\n");
        conBuffer.append(" exch.FAvailTime desc, \t\t\t\n");
        conBuffer.append(" MIN_FQUOTE_PRICE_LEVEL asc \t\t\n");
    }

    private boolean checkCanInsert(ExchangeTmpTableParam paramVal, IRowSet rows, Set repeatSet) throws SQLException {
        String compId = rows.getString("COMP_ID");
        String srcCurrId = rows.getString("FSourceCurrencyID");
        String trgCurrId = rows.getString("FTargetCurrencyID");
        Date effectDate = rows.getDate("FAvailTime");
        if (!paramVal.getCompanyId().equals(compId) || !paramVal.getTargetCurrencyId().equals(trgCurrId) || paramVal.getToDate().before(effectDate)) {
            return false;
        }
        Object[] data = new Object[]{compId, srcCurrId, trgCurrId, paramVal.getToDate()};
        if (repeatSet.contains(Arrays.toString(data))) {
            return false;
        }
        repeatSet.add(Arrays.toString(data));
        return true;
    }

    private void initVerifyMode() throws BOSException {
        Map verifyModeMap = this.getVerifyMode(this.companyNumber2IDMap.values());
        for (Age age : this.getFormulaCalculatorParameterList()) {
            StringBuffer amountField;
            if (verifyModeMap.get(age.companyId) == null) {
                age.setException((Exception)((Object)new ReportException(ReportException.COMMON_EXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"53_AgeCalculator", (Locale)this.serverContext.getLocale())})));
                continue;
            }
            int verifyMode = (Integer)verifyModeMap.get(age.companyId);
            boolean bl = age.isInTimeVerify = verifyMode == 0;
            if (verifyMode == 2) {
                age.includingUnPosted = true;
            } else if (verifyMode == 0) {
                age.includingUnPosted = false;
            }
            if (age.includingUnPosted && age.isInTimeVerify) {
                age.amountField = "cussent.FUnholdedAmtFor";
                if (age.isGeneralCurrency) continue;
                amountField = new StringBuffer();
                amountField.append(age.amountField);
                amountField.append(" * ");
                amountField.append("( case when ");
                amountField.append(this.exchangeTmpTableName + ".FConvertRateA is null ");
                amountField.append("then 1 ");
                amountField.append("else ");
                amountField.append(this.exchangeTmpTableName + ".FConvertRateA ");
                amountField.append(" end ) ");
                age.amountField = amountField.toString();
                continue;
            }
            age.amountField = "cussent.FUnVerifiedAmtFor";
            if (age.isGeneralCurrency) continue;
            amountField = new StringBuffer();
            amountField.append(age.amountField);
            amountField.append(" * ");
            amountField.append("( case when ");
            amountField.append(this.exchangeTmpTableName + ".FConvertRateA is null ");
            amountField.append("then 1 ");
            amountField.append("else ");
            amountField.append(this.exchangeTmpTableName + ".FConvertRateA ");
            amountField.append(" end ) ");
            age.amountField = amountField.toString();
        }
    }

    private Map getVerifyMode(Collection orgUnitIds) throws BOSException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        if (orgUnitIds.size() == 0) {
            return result;
        }
        StringBuffer sql = new StringBuffer();
        ArrayList<String> params = new ArrayList<String>();
        ParamMutiLangFieldInfo mutiFieldInfo = new ParamMutiLangFieldInfo(this.serverContext.getLocale());
        sql.append("select param.").append(mutiFieldInfo.getParamDefValue()).append(" defaultval  \n");
        sql.append(", item.").append(mutiFieldInfo.getParamItemValue()).append(" itemvalue");
        sql.append(",item.forgunitid orgunitid\t\t\n");
        sql.append("from T_BAS_Param param \t\n");
        sql.append("left outer join T_BAS_ParamItem item on param.fid = item.fkeyid ");
        sql.append("Where item.forgunitid in \t\t\n");
        String orgIdInString = this.batchHelper.createInSql(orgUnitIds.iterator());
        sql.append(orgIdInString).append("\n");
        sql.append("and param.fnumber = ? \t\t\n");
        params.add("GL_052");
        sql.append("and item.forgunitid in   \t\n");
        sql.append(orgIdInString).append("\n");
        IRowSet rs = DbUtil.executeQuery((Context)this.serverContext, (String)sql.toString(), (Object[])params.toArray());
        try {
            while (rs.next()) {
                String defaultVal = rs.getString("defaultval");
                String itemValue = rs.getString("itemvalue");
                String orgUnitId = rs.getString("orgunitid");
                int verifyMode = 0;
                if (itemValue != null) {
                    verifyMode = Integer.parseInt(itemValue);
                } else if (defaultVal != null) {
                    verifyMode = Integer.parseInt(defaultVal);
                }
                result.put(orgUnitId, new Integer(verifyMode));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    @Override
    protected void calculate() throws BOSException, EASBizException {
        logger.info((Object)("age formula size: " + this.getFormulaCalculatorParameterList().size()));
        this.balanceCalcProcessor = new BalanceCalcProcessor(this.getServerContext(), this.asstActTypeMap);
        this.balanceCalcProcessor.exec(this.balanceCalcSortRegister);
    }

    private void submitFormula() {
        for (Age age : this.getFormulaCalculatorParameterList()) {
            if (!this.balanceCalcSortRegister.register(age)) continue;
        }
    }

    @Override
    protected void clear() {
        this.releaseExchangeTmpTable(null);
    }

    private static class ExchangeTmpTableParam {
        String companyId;
        Timestamp toDate;
        String targetCurrencyId;

        public ExchangeTmpTableParam(String companyId, java.util.Date toDate, String targetCurrencyId) {
            this.companyId = companyId;
            if (toDate != null) {
                this.toDate = new Timestamp(toDate.getTime());
            }
            this.targetCurrencyId = targetCurrencyId;
        }

        public ExchangeTmpTableParam(String companyId, Timestamp toDate, String targetCurrencyId) {
            this.companyId = companyId;
            this.toDate = toDate;
            this.targetCurrencyId = targetCurrencyId;
        }

        public String getCompanyId() {
            return this.companyId;
        }

        public java.util.Date getToDate() {
            return this.toDate;
        }

        public String getTargetCurrencyId() {
            return this.targetCurrencyId;
        }

        public int hashCode() {
            int result = 17;
            result = this.companyId.hashCode() * result + this.toDate.hashCode() + this.targetCurrencyId.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            ExchangeTmpTableParam objParm = (ExchangeTmpTableParam)obj;
            return this.getCompanyId().equals(objParm.getCompanyId()) && this.getToDate().getTime() == objParm.getToDate().getTime() && this.getTargetCurrencyId().equals(objParm.getTargetCurrencyId());
        }
    }

    public class MyAccountViewInfo
    extends AccountViewInfo {
        public String toString() {
            StringBuffer thisStr = new StringBuffer();
            thisStr.append(this.getNumber()).append(this.get("accounttableid")).append(this.get("accountOrgId"));
            return thisStr.toString();
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object that) {
            return this.toString().equals(that.toString());
        }
    }
}

