/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.age;

import com.kingdee.eas.fi.rpt.CTypeEnum;
import com.kingdee.eas.fi.rpt.app.AssistantItem;
import com.kingdee.eas.fi.rpt.app.AsstActType;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSortState;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.IFormulaCombinationPreparedState;
import com.kingdee.eas.fi.rpt.batch.acct.AcctUtils;
import com.kingdee.eas.fi.rpt.batch.age.Age;
import com.kingdee.eas.fi.rpt.batch.age.AgeComBineState;
import com.kingdee.eas.fi.rpt.batch.age.AgeSortState;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.ITempTableField;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.ITempTableSQLProcessor;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.ITempTableValue;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.ITempTableValueInsertProcessor;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class AgeBatchProcessor
implements ITempTableSQLProcessor {
    private int batchSize;
    private AgeSortState sortState;
    private AgeComBineState ageComBineState;
    private String exchangeTmpTableName;

    public AgeBatchProcessor(int batchSize) {
        this.batchSize = batchSize;
        this.ageComBineState = new AgeComBineState();
    }

    @Override
    public void setSortState(IBatchSQLSortState sortState) {
        this.sortState = (AgeSortState)sortState;
    }

    @Override
    public IFormulaCombinationPreparedState getCombineState() {
        return this.ageComBineState;
    }

    @Override
    public Object[][] getIndexFormulaFields(IFormulaCalculator formula) {
        Age age = (Age)formula;
        ArrayList fields = new ArrayList();
        Object[][] result = new Object[1][fields.size()];
        result[0] = fields.toArray();
        return result;
    }

    @Override
    public String[] getIndexResultSetFields() {
        ArrayList indexedFields = new ArrayList();
        String[] result = new String[indexedFields.size()];
        indexedFields.toArray(result);
        return result;
    }

    @Override
    public int getMaxSQLVaribleSize() {
        return this.batchSize;
    }

    @Override
    public void prepareStateForCombine(IRowSet rs, IFormulaCombinationPreparedState combineState) throws SQLException {
        AgeComBineState ageComBineState = (AgeComBineState)combineState;
        ageComBineState.clearValue();
        ageComBineState.setAmount(rs.getBigDecimal("amount"));
        ageComBineState.setAccountNumber(rs.getString("accountNumber"));
        if (this.sortState.getAsstActTypeList() != null) {
            for (AsstActType itemType : this.sortState.getAsstActTypeList()) {
                ageComBineState.addAsstItem(itemType.number, rs.getObject("AsstActItem" + itemType.number));
            }
        }
    }

    @Override
    public void buildSelectPart(Set nullSet, StringBuffer sql) {
        sql.append("Select sum(case when entry.FEntryDC is not null  \n").append(" then (entry.FEntryDC * 2 - 1) * account.FDC * ").append(this.sortState.getAmountField()).append("\n").append(" else ").append(this.sortState.getAmountField()).append(" end ) amount \n");
        sql.append(",account.FNumber accountNumber");
        if (this.sortState.getAsstActTypeList() != null) {
            for (AsstActType itemType : this.sortState.getAsstActTypeList()) {
                String tableAlias = AcctUtils.validateTableAlias(itemType.number);
                sql.append(" ,A_AsstType").append(tableAlias).append(".FNumber AsstActItem").append(itemType.number).append(" ");
            }
        }
    }

    @Override
    public void buildFromPart(Set nullSet, StringBuffer sql) {
        sql.append(" from T_GL_VoucherAssistRecord assist                                               \n");
        sql.append(" inner join T_GL_AcctCussent cussent on assist.FID = cussent.FVchAssistRecordid     \n");
        if (this.sortState.getAsstActTypeList() != null) {
            sql.append(" inner join T_BD_AssistantHG hg on assist.FAssgrpID = hg.FID   \n");
            for (AsstActType itemType : this.sortState.getAsstActTypeList()) {
                String tableAlias = AcctUtils.validateTableAlias(itemType.number);
                sql.append(" inner join ").append(itemType.realtionDataObject).append(" A_AsstType").append(tableAlias).append(" on hg.").append(itemType.mappingFieldName).append(" = ").append("A_AsstType").append(tableAlias).append(".FID  \n");
            }
        }
        sql.append(" inner join T_BD_AccountView account on cussent.FAccountID = account.FID            \n");
        if (!this.sortState.isGeneralCurrency() && this.exchangeTmpTableName != null) {
            sql.append(" LEFT JOIN " + this.exchangeTmpTableName);
            sql.append(" ON (" + this.exchangeTmpTableName + ".FCompanyID = cussent.FCompanyID \t\t\t\n");
            sql.append(" AND " + this.exchangeTmpTableName + ".FSrcCurrencyID = cussent.FCurrencyID \t\n");
            sql.append(" ) ");
        }
        sql.append(" left join T_GL_VoucherEntry entry on entry.FID = assist.FEntryID                   \n");
        sql.append(" left join T_GL_Voucher voucher on voucher.FID = entry.FBillID                     \n");
    }

    @Override
    public void builderConstantWherePart(Set nullSet, StringBuffer sql, List params) {
        sql.append(" Where (cussent.FIsinit <> 1    \n");
        if (this.sortState.isIncludingUnPosted()) {
            sql.append(" and voucher.FBizstatus <> 0 and voucher.FBizstatus <> 2                        \n");
        } else {
            sql.append(" and voucher.FBizStatus = 5 \n");
        }
        sql.append(" and voucher.FBookedDate <= ?   \n");
        params.add(new Timestamp(this.sortState.getAccountDate().getTime()));
        sql.append(" or assist.FEntryID is null and cussent.FIsinit = 1 and cussent.FIsInitClosed = 1)  \n");
        if (this.sortState.isBizUnit()) {
            sql.append(" and cussent.FCompanyID = ?     \n");
            params.add(this.sortState.getCompanyId());
        } else {
            sql.append(" and cussent.FCompanyID in (" + this.sortState.getCompanyIdsForOnlyUnion() + ")     \n");
        }
        if (this.sortState.isGeneralCurrency()) {
            sql.append(" and cussent.FCurrencyID = ?    \n");
            params.add(this.sortState.getCurrencyId());
        }
        if (this.sortState.isBizUnit()) {
            sql.append(" and account.FCompanyID = ?     \n");
            params.add(this.sortState.getCompanyId());
        } else {
            sql.append(" and account.FCompanyID in (" + this.sortState.getCompanyIdsForOnlyUnion() + ")     \n");
        }
        sql.append(" and account.FAccountTableID = ?\n");
        params.add(this.sortState.getAccountTableId());
        if (!this.sortState.isCalcAll()) {
            if (CTypeEnum.E.getName().equalsIgnoreCase(this.sortState.getBalType())) {
                if (this.sortState.getToDate() != null) {
                    sql.append(" and assist.FEndDate >= ? \n");
                    params.add(new Timestamp(this.sortState.getToDate().getTime()));
                }
                sql.append(" and assist.FEndDate <= ?    \n");
            } else {
                if (this.sortState.getToDate() != null) {
                    sql.append(" and assist.FBizDate >= ? \n");
                    params.add(new Timestamp(this.sortState.getToDate().getTime()));
                }
                sql.append(" and assist.FBizDate <= ?    \n");
            }
            params.add(new Timestamp(this.sortState.getFromDate().getTime()));
        } else {
            if (CTypeEnum.E.getName().equalsIgnoreCase(this.sortState.getBalType())) {
                sql.append(" and assist.FEndDate >= ?    \n");
            } else {
                sql.append(" and assist.FbizDate >= ?    \n");
            }
            params.add(new Timestamp(this.sortState.getEndDate().getTime()));
        }
        if (this.sortState.getAccounts() != null) {
            sql.append(" and (account.FNumber >= ? and account.FNumber <= ?)  \n");
            params.add(this.sortState.getAccounts()[0]);
            params.add(this.sortState.getAccounts()[1] + "~");
        }
        sql.append(" and (");
    }

    @Override
    public void buildVariableWherePart(StringBuffer sql, List params, IFormulaCalculator formula) {
        Age age = (Age)formula;
        sql.append(" ( ");
        boolean isFirst = true;
        if (this.sortState.isSingleAccount()) {
            sql.append(" account.FNumber like ? ");
            params.add(age.accountItem.startAccount.getAccountNumber() + "%");
            isFirst = false;
        }
        if (this.sortState.getAsstActTypeList() != null) {
            for (AsstActType itemType : this.sortState.getAsstActTypeList()) {
                AssistantItem asstItem = age.accountItem.getItem(itemType.number);
                if (asstItem == null) continue;
                if (asstItem.startItem != null && asstItem.startItem.number != null) {
                    if (!isFirst) {
                        sql.append(" and ");
                    }
                    sql.append(" A_AsstType").append(itemType.number).append(".FNumber >= ? ");
                    params.add(asstItem.startItem.number);
                    isFirst = false;
                }
                if (asstItem.endItem == null || asstItem.endItem.number == null) continue;
                if (!isFirst) {
                    sql.append(" and ");
                }
                sql.append(" A_AsstType").append(itemType.number).append(".FNumber <= ? ");
                params.add(asstItem.endItem.number);
                isFirst = false;
            }
        }
        if (isFirst) {
            sql.append("1 = 1");
        }
        if (!this.sortState.isGeneralCurrency() && this.exchangeTmpTableName != null) {
            sql.append(" AND ((" + this.exchangeTmpTableName + ".FAVAILTIME = ? ");
            params.add(new Timestamp(this.sortState.getFromDate().getTime()));
            sql.append(" AND " + this.exchangeTmpTableName + ".FTrgCurrencyID = ? ");
            params.add(this.sortState.getNoGeneralCurrencyId());
            sql.append(" ) OR\t");
            sql.append(" " + this.exchangeTmpTableName + ".FAVAILTIME IS NULL ");
            sql.append(" )\t");
        }
        sql.append(" ) ");
    }

    @Override
    public void buildGroupByPart(Set nullSet, StringBuffer sql) {
        sql.append(")");
        StringBuffer groupBy = new StringBuffer();
        groupBy.append("account.FNumber");
        if (this.sortState.getAsstActTypeList() != null) {
            for (AsstActType itemType : this.sortState.getAsstActTypeList()) {
                String tableAlias = AcctUtils.validateTableAlias(itemType.number);
                groupBy.append(" ,A_AsstType").append(tableAlias).append(".FNumber");
            }
        }
        sql.append(" Group by ").append(groupBy);
    }

    @Override
    public List getFormulaCalculators() {
        return this.sortState.getFormulaList();
    }

    @Override
    public Set getAllowedNullFields() {
        return null;
    }

    @Override
    public void buildDivisionalVariableWherePart(Set nullSet, StringBuffer sql, List params) {
    }

    @Override
    public boolean isUseTempTableScheme() {
        return false;
    }

    @Override
    public void buildInnerJoinTempTable(StringBuffer sql, String tempTableName, ITempTableField tempTableField) {
    }

    @Override
    public ITempTableField getTempTableField() {
        return null;
    }

    @Override
    public ITempTableValue insertTempTableValues(IFormulaCalculator formula) {
        return null;
    }

    public void setExchangeTmpTableName(String exchangeTmpTableName) {
        this.exchangeTmpTableName = exchangeTmpTableName;
    }

    public String getExchangeTmpTableName() {
        return this.exchangeTmpTableName;
    }

    @Override
    public ITempTableValueInsertProcessor getTempTableValueInsertProcessor() {
        return null;
    }
}

