/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.age;

import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.sql.DbType;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.AgeType;
import com.kingdee.eas.fi.rpt.CTypeEnum;
import com.kingdee.eas.fi.rpt.app.AssistantItem;
import com.kingdee.eas.fi.rpt.app.AsstActType;
import com.kingdee.eas.fi.rpt.batch.AsstActTypeComarator;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fi.rpt.batch.age.Age;
import com.kingdee.eas.fi.rpt.batch.age.balance.AgeQueryParam;
import com.kingdee.eas.fi.rpt.batch.age.balance.facade.BalanceMergeToAge;
import com.kingdee.eas.fi.rpt.util.AcctountAsstItemParser;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BalanceCalcSort {
    private static final Comparator ITEM_COMPARATOR = new AsstActTypeComarator();
    private String key;
    private List formulas = new ArrayList();
    private static Logger logger = Logger.getLogger((String)BalanceCalcSort.class.getClass().getName());

    protected String generateKey(Age age) {
        AcctountAsstItemParser.AccountAsstItem asstItem;
        StringBuffer sortKey = new StringBuffer();
        sortKey.append("[").append(age.companyId).append("]");
        sortKey.append("[").append(age.accountTableId).append("]");
        sortKey.append("[").append(age.currencyid).append("]");
        sortKey.append("[").append(age.includingUnPosted ? "1" : "0").append("]");
        sortKey.append("[").append(age.balType).append("]");
        sortKey.append("[").append(age.ageType).append("]");
        sortKey.append("[").append(age.calcType).append("]");
        sortKey.append("[").append(age.endDate != null ? BatchHelper.dateFormat.format(age.endDate) : "").append("]");
        sortKey.append("[").append(age.from).append("]");
        sortKey.append("[").append(age.to).append("]");
        if (!age.isCalcAll) {
            sortKey.append("[").append(age.fromDate != null ? BatchHelper.dateFormat.format(age.fromDate) : "").append("]");
            sortKey.append("[").append(age.toDate != null ? BatchHelper.dateFormat.format(age.toDate) : "").append("]");
        }
        sortKey.append("[").append(age.accountDate != null ? BatchHelper.dateFormat.format(age.accountDate) : "").append("]");
        sortKey.append("[").append(age.amountField).append("]");
        sortKey.append("[").append(age.isCalcAll ? "1" : "0").append("]");
        sortKey.append("[").append(this.isSingleAccount(age) ? "1" : "0").append("]");
        sortKey.append("[").append(age.accountItem.startAccount.getAccountNumber()).append("|").append(age.accountItem.endAccount.getAccountNumber()).append("]");
        List asstActTypeList = this.buildAsstActTypeList(age);
        if (asstActTypeList != null) {
            for (AsstActType itemType : asstActTypeList) {
                sortKey.append("[").append(itemType.number).append("]");
            }
        }
        if ((asstItem = age.accountItem.getAccountAsstItem()) != null && asstItem.asstItems != null && asstItem.asstItems.length > 0 && asstItem.asstItems[0].startNumber != null) {
            for (AsstActType itemType : asstActTypeList) {
                AssistantItem assistantItem = age.accountItem.getItem(itemType.number);
                if (assistantItem == null || assistantItem.startItem == null || StringUtils.isEmpty((String)assistantItem.startItem.number) || assistantItem.endItem == null || StringUtils.isEmpty((String)assistantItem.endItem.number)) continue;
                String asstItemStartNumber = assistantItem.startItem.number;
                String asstItemEndNumber = assistantItem.endItem.number;
                sortKey.append("[").append(asstItemStartNumber).append("|").append(asstItemEndNumber).append("]");
            }
        }
        return sortKey.toString();
    }

    public List buildAsstActTypeList(Age age) {
        if (!age.accountItem.hasItem()) {
            return null;
        }
        ArrayList<AsstActType> asstActTypeList = new ArrayList<AsstActType>();
        for (AssistantItem asst : age.accountItem.getItemTypes().values()) {
            asstActTypeList.add(asst.itemType);
        }
        Collections.sort(asstActTypeList, ITEM_COMPARATOR);
        return asstActTypeList;
    }

    private boolean isSingleAccount(Age age) {
        return age.accountItem.startAccount.getAccountNumber().equals(age.accountItem.endAccount.getAccountNumber());
    }

    public String merge(Age age) {
        String ageKey = this.generateKey(age);
        if (this.key == null) {
            this.key = ageKey;
        } else if (!this.key.equals(ageKey)) {
            return null;
        }
        this.formulas.add(age);
        return this.key;
    }

    public String key() {
        return this.key;
    }

    public AgeQueryParam buildAgeQueryParam(Context ctx) {
        AgeQueryParam queryParam = null;
        Age age = null;
        HashMap asstNumbers = new HashMap();
        Object asstValues = null;
        StringBuffer asstExprStr = new StringBuffer();
        Object asstValuesBeforeMerge = null;
        boolean isSameStartAndEnd = false;
        ArrayList asst_Params = new ArrayList();
        String dbType = ContextUtil.getDbType((Context)ctx);
        boolean isMsServer = dbType.equals(DbType.getName((int)3));
        int size = this.formulas.size();
        for (int i = 0; i < size; ++i) {
            age = (Age)this.formulas.get(i);
            isSameStartAndEnd = false;
            if (queryParam != null) continue;
            queryParam = new AgeQueryParam();
            queryParam.setBusinessDate(age.accountDate);
            queryParam.setByBusinessDate(CTypeEnum.B.getName().equalsIgnoreCase(age.balType));
            queryParam.setByOverDue(AgeType.O.getName().equalsIgnoreCase(age.ageType));
            queryParam.setCompany(age.companyId);
            queryParam.setCurrency(age.currencyid);
            queryParam.setEndDate(age.endDate);
            queryParam.setIncludeUnPosted(age.includingUnPosted);
            queryParam.setAccountStartNumber(age.accountItem.startAccount.getAccountNumber());
            queryParam.setAccountEndNumber(age.accountItem.endAccount.getAccountNumber());
            queryParam.setAgeRange(age.getAgeArea());
            if ("BALANCE".equals(age.calcType)) {
                queryParam.setIncludeVerifyVch(true);
            } else {
                queryParam.setIncludeVerifyVch(false);
            }
            if (age.accountItem.hasItem()) {
                ArrayList ageAsstTypes = age.getAccountItem().getItemNumbers();
                String[] assts = new String[ageAsstTypes.size()];
                Object asstItems = null;
                int asstSize = ageAsstTypes.size();
                for (int asstIndex = 0; asstIndex < asstSize; ++asstIndex) {
                    Object ageAsstType = ageAsstTypes.get(asstIndex);
                    asstExprStr.setLength(0);
                    if (age.getAccountItem().getItem((String)((String)ageAsstType)).startItem != null) {
                        asstExprStr.append(age.getAccountItem().getItem((String)((String)ageAsstType)).startItem.number);
                        asstExprStr.append(':');
                        if (age.getAccountItem().getItem((String)((String)ageAsstType)).endItem.number != null) {
                            asstExprStr.append(age.getAccountItem().getItem((String)((String)ageAsstType)).endItem.number);
                        } else {
                            asstExprStr.append(age.getAccountItem().getItem((String)((String)ageAsstType)).startItem.number);
                        }
                        if (queryParam.isSameStartAndEnd && age.getAccountItem().getItem((String)((String)ageAsstType)).startItem.number.equals(age.getAccountItem().getItem((String)((String)ageAsstType)).endItem.number)) {
                            isSameStartAndEnd = true;
                            queryParam.putAsstType_AsstItems((String)ageAsstType, age.getAccountItem().getItem((String)((String)ageAsstType)).startItem.number);
                        }
                    }
                    asstNumbers.put(ageAsstType, asstExprStr.toString());
                }
                queryParam.setAsstItems(assts);
            }
            queryParam.isSameStartAndEnd = isSameStartAndEnd;
            if (age.isBizunit.booleanValue()) continue;
            queryParam.setCompanyIdsForOnlyUnion(age.companyIdsForOnlyUnion);
        }
        if (!asstNumbers.isEmpty()) {
            String[] assts = new String[asstNumbers.size()];
            int index = 0;
            for (String asstType : asstNumbers.keySet()) {
                assts[index] = asstNumbers.get(asstType) != null ? asstType + "|" + asstNumbers.get(asstType) : asstType;
                ++index;
            }
            queryParam.setAsstItems(assts);
        }
        return queryParam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void correctNumberCompare(Context ctx, List<Object[]> asst_Params, Map asstNumbers) {
        block14: {
            try {
                String tmpTableName;
                TempTablePool pool;
                block15: {
                    if (asst_Params.isEmpty()) break block14;
                    if (DebugLogger.isDebug) {
                        StringBuffer sb = new StringBuffer();
                        for (Object[] obj : asst_Params) {
                            if (obj.length <= 2) continue;
                            sb.append(obj[0]).append(";").append(obj[1]).append(";").append(obj[2]).append(",,,,");
                        }
                        logger.error((Object)("asst_Params before:" + sb.toString()));
                    }
                    pool = TempTablePool.getInstance((Context)ctx);
                    tmpTableName = null;
                    try {
                        StringBuffer sql = new StringBuffer();
                        sql.append("create table t_csl_Compare(asstType NVARCHAR(120),startNumber NVARCHAR(120),endNumber NVARCHAR(120))");
                        tmpTableName = pool.createTempTable(sql.toString());
                        sql.setLength(0);
                        sql.append(" insert into ").append(tmpTableName).append("(asstType,startNumber,endNumber) values(?,?,?)");
                        DbUtil.executeBatch((Context)ctx, (String)sql.toString(), asst_Params);
                        sql.setLength(0);
                        sql.append("select asstType,min(startNumber) fstartNumber, max(endNumber) fendNumber from ").append(tmpTableName).append(" group by asstType");
                        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                        if (rowSet != null) {
                            while (rowSet.next()) {
                                asstNumbers.put(rowSet.getString("asstType"), rowSet.getString("fstartNumber") + ":" + rowSet.getString("fendNumber"));
                            }
                        }
                        if (!DebugLogger.isDebug) break block15;
                        StringBuffer sb = new StringBuffer();
                        for (Object obj : asstNumbers.keySet()) {
                            if (((Object[])obj).length <= 2) continue;
                            sb.append(obj).append(";").append(asstNumbers.get(obj)).append(",,,,");
                        }
                        logger.error((Object)("asst_Params before:" + sb.toString()));
                    }
                    catch (Exception e) {
                        try {
                            logger.error((Object)"correctNumberCompare error.", (Throwable)e);
                        }
                        catch (Throwable throwable) {
                            if (!StringUtils.isEmpty(tmpTableName) && !DebugLogger.isDebug) {
                                pool.releaseTable(tmpTableName);
                            }
                            throw throwable;
                        }
                        if (!StringUtils.isEmpty(tmpTableName) && !DebugLogger.isDebug) {
                            pool.releaseTable(tmpTableName);
                        }
                        break block14;
                    }
                }
                if (!StringUtils.isEmpty((String)tmpTableName) && !DebugLogger.isDebug) {
                    pool.releaseTable(tmpTableName);
                }
            }
            catch (Exception ex) {
                logger.error((Object)"correctNumberCompare error.", (Throwable)ex);
            }
        }
    }

    public void fillValue(List accountBalance, List formulas) {
        new BalanceMergeToAge().exec(accountBalance, formulas);
    }

    public List getFormulas() {
        return this.formulas;
    }
}

