/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.age.newbalance;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.fi.gl.AccountAgeFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IAccountAgeFacade;
import com.kingdee.eas.fi.gl.app.AccountAgeParam;
import com.kingdee.eas.fi.gl.app.GLAcctAgeUtils;
import com.kingdee.eas.fi.gl.app.InitHelp;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.batch.age.DebugModel;
import com.kingdee.eas.fi.rpt.batch.age.balance.AgeQueryParam;
import com.kingdee.eas.fi.rpt.batch.age.balance.facade.AgeQueryParamConvertor;
import com.kingdee.eas.fi.rpt.batch.age.balance.facade.BalanceInfoByAge;
import com.kingdee.eas.fi.rpt.batch.age.balance.facade.ConvertAssistHGID2Number;
import com.kingdee.eas.fi.rpt.batch.age.balance.facade.SimpleAssistantHG;
import com.kingdee.eas.fi.rpt.batch.age.balance.gl.QueryAsstItems;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class QueryAgeBalance {
    private static Logger logger = Logger.getLogger((String)QueryAgeBalance.class.getClass().getName());
    private DebugModel debugModel;
    private AgeQueryParam ageQueryParam;

    public List exec(Context ctx, AgeQueryParam param) throws EASBizException, BOSException {
        this.ageQueryParam = param;
        Map params = new AgeQueryParamConvertor(ctx).exec(param);
        int[] days = (int[])params.get("days");
        AccountAgeParam accoutAgeParam = this.getAccountAgeParam(ctx, params);
        ArrayList balances = this.queryAgeByAcctBal(accoutAgeParam, days);
        Set hgs = this.togetherAssistantHG(balances);
        ConvertAssistHGID2Number convertHg = new ConvertAssistHGID2Number(ctx);
        convertHg.exec(hgs);
        return balances;
    }

    private void setAsstActItemFilter(AccountAgeParam accoutAgeParam, StringBuffer whereStr) {
        HashMap hmItems;
        if (this.ageQueryParam.isSameStartAndEnd && (hmItems = accoutAgeParam.getHmItems()) != null && !hmItems.isEmpty() && this.ageQueryParam.getAsstType_asstItmes().size() == 1 && hmItems.size() == 1) {
            HashMap item = (HashMap)hmItems.keySet().iterator().next();
            boolean isUseLongNumber = (Boolean)item.get("useLongNUmber");
            String numberFieldNumber = "fnumber";
            StringBuffer numberInStr = new StringBuffer();
            if (isUseLongNumber) {
                numberFieldNumber = "flongnumber";
            }
            Map<String, Set<String>> asstItems = this.ageQueryParam.getAsstType_asstItmes();
            Set<String> items = null;
            for (String key : asstItems.keySet()) {
                items = asstItems.get(key);
                for (String number : items) {
                    if (number == null) continue;
                    if (isUseLongNumber) {
                        number = number.replace(".", "!");
                    }
                    if (numberInStr.length() > 0) {
                        numberInStr.append(",");
                    }
                    numberInStr.append("'").append(number).append("'");
                }
            }
            whereStr.append(" and T0.").append(numberFieldNumber).append(" in(").append(numberInStr).append(")");
        }
    }

    private Set togetherAssistantHG(List balances) {
        BalanceInfoByAge balance = null;
        HashSet<SimpleAssistantHG> hgs = new HashSet<SimpleAssistantHG>(balances.size());
        HashMap<String, SimpleAssistantHG> noDuplicatHG = new HashMap<String, SimpleAssistantHG>();
        int size = balances.size();
        for (int i = 0; i < size; ++i) {
            balance = (BalanceInfoByAge)balances.get(i);
            if (balance.getCurrentHG() == null || balance.getCurrentHG().getHgId() == null) continue;
            if (!noDuplicatHG.containsKey(balance.getCurrentHG().getHgId())) {
                hgs.add(balance.getCurrentHG());
                noDuplicatHG.put(balance.getCurrentHG().getHgId(), balance.getCurrentHG());
                continue;
            }
            balance.setCurrentHG((SimpleAssistantHG)noDuplicatHG.get(balance.getCurrentHG().getHgId()));
        }
        return hgs;
    }

    private ArrayList queryAgeByAcctBal(AccountAgeParam paramAge, int[] days) throws BOSException, EASBizException {
        if (paramAge.getDays() == null || paramAge.getDays().length < 1) {
            return null;
        }
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList alAcResult = new ArrayList();
        try {
            int iAdjust;
            con = EJBFactory.getConnection((Context)paramAge.getCtx());
            GLAcctAgeUtils.dealwith_Param((AccountAgeParam)paramAge);
            GLAcctAgeUtils.prepareTempTableAdjExch((AccountAgeParam)paramAge);
            GLAcctAgeUtils.prepareTempTableCompanyVerifyMode((Connection)con, (AccountAgeParam)paramAge);
            GLAcctAgeUtils.getSql_ByAcctBal_AmountField((AccountAgeParam)paramAge);
            GLAcctAgeUtils.getSql_ByAcctBal_Param_AlDates((AccountAgeParam)paramAge);
            GLAcctAgeUtils.getSql_ByAcctBal_SelectHgJoin((AccountAgeParam)paramAge);
            this.createTempTable_ByBal_AcSum(paramAge);
            String tempTableHistory = GLAcctAgeUtils.createTempTable4QueryHistory4InTime((AccountAgeParam)paramAge);
            StringBuffer sql0InsertAcTemp = this.getSql_InsertAcTemp(paramAge, false, false);
            StringBuffer sql1NotInit = this.getSql_ByAcctBal_AcNotInit(paramAge);
            StringBuffer sql2Init = this.getSql_ByAcctBal_AcInit(paramAge);
            StringBuffer sql5HistorySql = new StringBuffer();
            sql5HistorySql = paramAge.isInTimeVerify() ? this.getHistorySql4InTime(con, paramAge) : this.getHistorySql4NotInTime(con, paramAge);
            StringBuffer merge = new StringBuffer();
            merge = this.getSql_ByAcctBal_InsertAcTempUnion(paramAge, sql0InsertAcTemp, sql1NotInit, sql2Init, sql5HistorySql);
            ArrayList params = new ArrayList();
            SqlParams spp = new SqlParams();
            ps = con.prepareStatement(merge.toString());
            int index = 1;
            if (paramAge.isIsOnlyUnion()) {
                index = QueryAgeBalance.setupParams_ByAcctBal_InsertSum(true, false, paramAge.getAccountid(), paramAge, paramAge.getHistoryDate(), paramAge.getAlDates(), ps, params, index, paramAge.getAccountViewNumber(), spp, paramAge.getLastPhaseBeginDate());
                if (paramAge.isIncludeInit()) {
                    index = QueryAgeBalance.setupParams_ByAcctBal_InsertSum(true, true, paramAge.getAccountid(), paramAge, paramAge.getHistoryDate(), paramAge.getAlDates(), ps, params, index, paramAge.getAccountViewNumber(), spp, null);
                }
            } else {
                index = GLAcctAgeUtils.setupParams_ByAcctBal_InsertSum((boolean)false, (boolean)false, null, (AccountAgeParam)paramAge, (java.util.Date)paramAge.getHistoryDate(), (ArrayList)paramAge.getAlDates(), (PreparedStatement)ps, params, (int)index, null, (SqlParams)spp, (java.util.Date)paramAge.getLastPhaseBeginDate());
                if (paramAge.isIncludeInit()) {
                    index = GLAcctAgeUtils.setupParams_ByAcctBal_InsertSum((boolean)false, (boolean)true, null, (AccountAgeParam)paramAge, (java.util.Date)paramAge.getHistoryDate(), (ArrayList)paramAge.getAlDates(), (PreparedStatement)ps, params, (int)index, null, (SqlParams)spp, null);
                }
            }
            DbUtil.execute((Context)paramAge.getCtx(), (PreparedStatement)ps);
            if (paramAge.isIncludeVerifyVch()) {
                this.createTempTable4SumVerify(paramAge);
                StringBuffer sql6VeriSum = this.getSql_ByBal_AcVeriSum(paramAge);
                this.insertIntoTempTable_ByBal_SumVeri(paramAge, con, sql6VeriSum);
                this.createTempTable4SumVerified(paramAge);
                StringBuffer sql7HistorySql4Verified = this.getHistorySql4Verified(paramAge);
                this.insertIntoTempTable_ByBal_SumVerified(paramAge, con, sql7HistorySql4Verified);
                this.updateTempTable_ByBal_SumVeriFromSumVerified_PreInsertLine(paramAge, con);
                this.updateTempTable_ByBal_SumVeriFromSumVerified(paramAge, con);
                this.updateTempTable_ByBal_AcSumFromBal_PreInsertLine(paramAge, con);
                this.updateTempTable_ByBal_AcSumFromSumVeri(paramAge, con);
                if (paramAge.isAddFieldHgid()) {
                    this.calculateSumallSumOverduePre(paramAge, con, ps);
                }
            }
            if (paramAge.isGeneralCy()) {
                this.calculateLocalAmt4GeneralCy(con, paramAge);
            }
            int daylen = paramAge.getDaylen();
            this.calculateSumallSumOverdue(con, ps, paramAge.getTempTableAcSum(), daylen, true, paramAge);
            if (paramAge.isGeneralCy() && !paramAge.isAccountList() && (iAdjust = this.calculateLocalAmt4Deviation(paramAge)) != 0) {
                this.calculateSumallSumOverdue(con, ps, paramAge.getTempTableAcSum(), daylen, true, paramAge);
            }
            merge.setLength(0);
            merge = this.getSql_ByAcctBal_LastResult_FromTempAcSum(paramAge);
            ps = con.prepareStatement(merge.toString());
            rs = ps.executeQuery();
            alAcResult = this.create_LastResult_ByAcctBal(paramAge, rs, days);
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
        }
        catch (SQLException sqle) {
            try {
                logger.error((Object)sqle);
                throw new SQLAccessException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                if (!DebugLogger.isDebug) {
                    GLAcctAgeUtils.dropTempTable((AccountAgeParam)paramAge, (Logger)logger);
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        if (!DebugLogger.isDebug) {
            GLAcctAgeUtils.dropTempTable((AccountAgeParam)paramAge, (Logger)logger);
        }
        return alAcResult;
    }

    private ArrayList create_LastResult_ByAcctBal(AccountAgeParam paramAge, ResultSet rs, int[] days) throws SQLException {
        ArrayList<BalanceInfoByAge> result = new ArrayList<BalanceInfoByAge>();
        while (rs.next()) {
            int length;
            int i;
            String maxChar = GlUtils.getMaxChar();
            BalanceInfoByAge balance = new BalanceInfoByAge();
            int daylen = paramAge.getDaylen();
            BigDecimal[] itemBigdecimal = new BigDecimal[daylen + 1];
            for (i = 0; i < daylen + 1; ++i) {
                itemBigdecimal[i] = rs.getBigDecimal("sum" + i);
            }
            i = 0;
            int innerlength = length = itemBigdecimal.length;
            while (i < length) {
                innerlength = length - 1;
                BigDecimal tempate = itemBigdecimal[length - 1];
                BigDecimal sumoverdue = rs.getBigDecimal("sumoverdue");
                BigDecimal zero = new BigDecimal("0");
                if (sumoverdue != null && tempate != null && tempate.compareTo(zero) != 0) {
                    for (int j = 0; j < innerlength; ++j) {
                        itemBigdecimal[length - 1] = j == 0 ? sumoverdue.subtract(itemBigdecimal[j]) : itemBigdecimal[length - 1].subtract(itemBigdecimal[j]);
                    }
                    break;
                }
                --length;
            }
            balance.setBalance(rs.getBigDecimal("sumall"));
            balance.setUnOverDueBalance(rs.getBigDecimal("sumunoverdue"));
            balance.setOverDueBalance(rs.getBigDecimal("sumoverdue"));
            balance.setAgeBalances(itemBigdecimal);
            balance.setCurrentHG(rs.getString("hgid"));
            balance.setAcctId(rs.getString("acctId"));
            balance.setAcctNumber(rs.getString("acctNumber"));
            balance.setAgeArea(days);
            result.add(balance);
        }
        return result;
    }

    private StringBuffer getSql_ByAcctBal_LastResult_FromTempAcSum(AccountAgeParam paramAge) {
        int j;
        StringBuffer sql = new StringBuffer();
        StringBuffer accountParam = new StringBuffer(",acctId,acctNumber,hgid");
        if (paramAge.isIncludeVerifyVch()) {
            sql.append("select ").append(paramAge.getSqlSelecthgoutsideReal()).append(accountParam);
        } else {
            sql.append("select ").append(paramAge.getSqlSelecthgoutside()).append(accountParam);
        }
        sql.append("\r\n ,leftamount as sumall");
        sql.append(",sumunoverdue");
        sql.append(",sumoverdue");
        int index = 0;
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j <= paramAge.getUndaylen(); ++j) {
                sql.append(",sum" + j);
            }
        }
        for (int i = 0; i <= paramAge.getDaylen(); ++i) {
            index = i + j;
            sql.append(",sum" + index);
        }
        sql.append("\r\n from ").append(paramAge.getTempTableAcSum());
        StringBuffer orderby = paramAge.getSqlOrderby();
        if (orderby != null && orderby.length() > 0) {
            sql.append(orderby);
        }
        return sql;
    }

    private int calculateLocalAmt4Deviation(AccountAgeParam paramAge) throws BOSException, SQLException {
        int i;
        int iAdjust = 0;
        IRowSet rs = null;
        StringBuffer sql = new StringBuffer();
        int generalCyScale = paramAge.getGeneralCurrency().getPrecision();
        String tempTableAcSum = paramAge.getTempTableAcSum();
        int daylen = paramAge.getDaylen();
        BigDecimal sumunoverdue = GlUtils.zero;
        BigDecimal leftamount = GlUtils.zero;
        BigDecimal sumall = GlUtils.zero;
        BigDecimal sumoverdue = GlUtils.zero;
        BigDecimal sumallAdd = GlUtils.zero;
        BigDecimal delta = GlUtils.zero;
        String strFieldNameMaxAmount = "";
        String sumStr = "";
        String sumStrRound = "";
        int ide = 0;
        if (paramAge.isShowUmexpired()) {
            ide = paramAge.getUndaylen() + 1;
        }
        BigDecimal[] sum = new BigDecimal[daylen + ide + 1];
        for (i = 0; i <= daylen + ide; ++i) {
            sumStr = sumStr + "sum" + i + ",";
        }
        for (i = 0; i <= daylen + ide; ++i) {
            sumStrRound = sumStrRound + "sum" + i + "=round(sum" + i + "," + generalCyScale + "),";
        }
        sql.setLength(0);
        sql.append("Update ").append(tempTableAcSum);
        sql.append(" set ");
        sql.append(sumStrRound);
        sql.append("sumunoverdue=round(sumunoverdue," + generalCyScale + "),");
        sql.append("leftamount=round(leftamount," + generalCyScale + "),");
        sql.append("sumall=round(sumall," + generalCyScale + "),");
        sql.append("sumoverdue=round(sumoverdue," + generalCyScale + ")");
        DbUtil.execute((Context)paramAge.getCtx(), (String)sql.toString());
        boolean isIsOnlyUnionAdj = false;
        if (paramAge.isIsOnlyUnion() && !paramAge.isIsfirstload() && paramAge.getOtherInfo() != null && paramAge.getOtherInfo().get("sumall") != null) {
            isIsOnlyUnionAdj = true;
            leftamount = (BigDecimal)paramAge.getOtherInfo().get("sumall");
        }
        sql.setLength(0);
        sql.append(" select ");
        sql.append(sumStr);
        sql.append(" sumunoverdue,leftamount,sumall,sumoverdue");
        sql.append(" from ");
        sql.append(tempTableAcSum);
        if (!isIsOnlyUnionAdj) {
            sql.append(" where fcurrid = '").append(paramAge.getMaxChar()).append("'");
        }
        if ((rs = DbUtil.executeQuery((Context)paramAge.getCtx(), (String)sql.toString())).next()) {
            for (int i2 = 0; i2 <= daylen + ide; ++i2) {
                sum[i2] = rs.getBigDecimal("sum" + i2);
                sumallAdd = sumallAdd.add(sum[i2]);
            }
            sumunoverdue = rs.getBigDecimal("sumunoverdue");
            if (!isIsOnlyUnionAdj) {
                leftamount = rs.getBigDecimal("leftamount");
            }
            sumall = rs.getBigDecimal("sumall");
            sumoverdue = rs.getBigDecimal("sumoverdue");
            if (!paramAge.isShowUmexpired()) {
                sumallAdd = sumallAdd.add(sumunoverdue);
            }
        }
        rs.close();
        if (leftamount.compareTo(sumallAdd) != 0) {
            StringBuffer updateFilterRow;
            iAdjust = -1;
            delta = leftamount.subtract(sumallAdd);
            int iMaxCol = GLAcctAgeUtils.findMaxInSumArray((BigDecimal[])sum);
            strFieldNameMaxAmount = sumunoverdue.abs().compareTo(sum[iMaxCol].abs()) >= 0 ? "sumunoverdue" : "sum" + iMaxCol;
            if (!isIsOnlyUnionAdj) {
                sql.setLength(0);
                sql.append("Update ").append(tempTableAcSum);
                sql.append(" set ");
                sql.append(strFieldNameMaxAmount);
                sql.append(" = ");
                sql.append("  ? ");
                sql.append(" where fcurrid = ?");
                DbUtil.execute((Context)paramAge.getCtx(), (String)sql.toString(), (Object[])new Object[]{strFieldNameMaxAmount + delta, paramAge.getMaxChar()});
            }
            if ((updateFilterRow = this.findMaxRowInTempTable(paramAge, strFieldNameMaxAmount)).length() > 0) {
                sql.setLength(0);
                sql.append("Update ").append(tempTableAcSum);
                sql.append(" set ");
                sql.append(strFieldNameMaxAmount);
                sql.append(" = ");
                sql.append(" ? ");
                sql.append(" where fcurrid <> ?");
                sql.append(updateFilterRow);
                DbUtil.execute((Context)paramAge.getCtx(), (String)sql.toString(), (Object[])new Object[]{strFieldNameMaxAmount + delta, paramAge.getMaxChar()});
            }
        }
        rs.close();
        return iAdjust;
    }

    private StringBuffer findMaxRowInTempTable(AccountAgeParam paramAge, String filedName) throws BOSException, SQLException {
        IRowSet rs = null;
        boolean index = true;
        StringBuffer sql = new StringBuffer();
        StringBuffer sqlWhere = new StringBuffer();
        String tempTableAcSum = paramAge.getTempTableAcSum();
        sql.append(" select * from ").append(tempTableAcSum).append(" tmp   \r\n");
        sql.append(" where abs(tmp.").append(filedName).append(") =                               \r\n");
        sql.append(" (                                              \r\n");
        sql.append("  select max(abs(tmp2.").append(filedName).append("))                    \r\n");
        sql.append("  from ").append(tempTableAcSum).append(" tmp2          \r\n");
        sql.append("  where tmp2.fcurrid <> '").append(paramAge.getMaxChar()).append("' \r\n");
        sql.append(" )                                              \r\n");
        sql.append(" and tmp.fcurrid <> '").append(paramAge.getMaxChar()).append("' \r\n");
        rs = DbUtil.executeQuery((Context)paramAge.getCtx(), (String)sql.toString());
        if (rs.next()) {
            String keyField = "";
            sqlWhere.append(" ");
            for (int i = 0; i < paramAge.getLstHgOutSide().size(); ++i) {
                keyField = (String)paramAge.getLstHgOutSide().get(i);
                if (keyField.indexOf("number") >= 0 || keyField.indexOf("name") >= 0 || paramAge.isGeneralCy() && keyField.indexOf("hgid") >= 0) continue;
                sqlWhere.append(" AND ");
                sqlWhere.append(keyField).append(" = ");
                sqlWhere.append("'").append(rs.getString(keyField)).append("'  \r\n");
            }
        }
        rs.close();
        return sqlWhere;
    }

    private void insertTotalSumLines(Connection con, AccountAgeParam paramAge) throws SQLException {
        int index;
        PreparedStatement ps = null;
        StringBuffer totalSum = new StringBuffer();
        String sql = " select top 1 1 from " + paramAge.getTempTableAcSum();
        ps = con.prepareStatement(sql);
        ResultSet rs = ps.executeQuery();
        if (!rs.next()) {
            DbUtil.execute((Context)paramAge.getCtx(), (PreparedStatement)ps);
            return;
        }
        rs.close();
        String sqlSelect = this.getSql_InsertAcTemp(paramAge, true, paramAge.isIncludeVerifyVch()).toString();
        if (sqlSelect.indexOf(",hgid") > 0) {
            sqlSelect = sqlSelect.replace(",hgid", "");
        }
        totalSum.append(sqlSelect);
        if (paramAge.isIsOnlyUnion()) {
            // empty if block
        }
        totalSum.append("\r\n select  ");
        for (int i = 0; i < paramAge.getAlAstFields().size(); ++i) {
            totalSum.append(" '").append(paramAge.getMaxChar()).append("' ");
            totalSum.append("T" + i + paramAge.getAlAstFields().get(i).toString());
            totalSum.append(",");
            totalSum.append(" N'").append(paramAge.getMaxChar()).append("' ");
            totalSum.append("T" + i + "fnumber ");
            totalSum.append(",");
            totalSum.append(" N'").append(paramAge.getMaxChar()).append("' ");
            totalSum.append("T" + i + "fname ");
            totalSum.append(",");
            if (paramAge.isAccountList()) break;
        }
        if (paramAge.isBizCode() && !paramAge.isAccountBCNoType()) {
            totalSum.append(" '").append(paramAge.getMaxChar()).append("' ");
            totalSum.append("Taccountid");
            totalSum.append(",");
            totalSum.append(" N'").append(paramAge.getMaxChar()).append("' ");
            totalSum.append("T0fnumber ");
            totalSum.append(",");
            totalSum.append(" N'").append(paramAge.getMaxChar()).append("' ");
            totalSum.append("T0fname ");
            totalSum.append(",");
        }
        totalSum.append(" '").append(paramAge.getMaxChar()).append("' fcurrid, ");
        if (paramAge.isIsOnlyUnion() && paramAge.isAllCurr()) {
            totalSum.append("fcurrname fcurrname, ");
        } else {
            totalSum.append("N'' fcurrname, ");
        }
        if (paramAge.isIsOnlyUnion()) {
            totalSum.append(" 'total' fsumcompanyid,N'' fsumcompanyname,to_integer(null) fsumcompanylevel,to_integer(null) fsumcompanyisleaf,fsubcompanyid,acctId,acctNumber,");
        }
        StringBuffer _tempSum = new StringBuffer();
        if (paramAge.isAllCurr() || !paramAge.isBizCode() && paramAge.getAlAstFields().size() > 0 || paramAge.isBizCode() && paramAge.isAccountBC() && !paramAge.isAccountBCNoType()) {
            int j;
            _tempSum = new StringBuffer();
            index = 0;
            if (paramAge.isShowUmexpired()) {
                for (j = 0; j <= paramAge.getUndaylen(); ++j) {
                    _tempSum.append(",sum(sum" + (j + 1) + ") as sum" + (j + 1));
                }
            }
            for (int i = index; i < paramAge.getDaylen(); ++i) {
                index = i + j + 1;
                _tempSum.append(",sum(sum" + index + ") as sum" + index);
            }
            totalSum.append("\r\n sum(leftamount) leftamount,sum(sumall) sumall").append("\r\n ,sum(sumoverdue) sumoverdue,sum(sumunoverdue) sumunoverdue").append("\r\n ,sum(sum0) sum0");
        } else {
            int j;
            _tempSum = new StringBuffer();
            index = 0;
            if (paramAge.isShowUmexpired()) {
                for (j = 0; j <= paramAge.getUndaylen(); ++j) {
                    _tempSum.append(",sum" + (j + 1));
                }
            }
            for (int i = index; i < paramAge.getDaylen(); ++i) {
                index = i + j + 1;
                _tempSum.append(",sum" + index);
            }
            totalSum.append("\r\n leftamount,sumall").append("\r\n ,sumoverdue,sumunoverdue").append("\r\n ,sum0");
        }
        totalSum.append(_tempSum);
        totalSum.append("\r\n from ");
        totalSum.append(paramAge.getTempTableAcSum());
        if (paramAge.isIsOnlyUnion()) {
            int rootCompanylevel = 1;
            sql = " select min(fsumcompanylevel) companyLevel from " + paramAge.getTempTableAcSum();
            ps = con.prepareStatement(sql);
            rs = ps.executeQuery();
            if (rs.next()) {
                rootCompanylevel = rs.getInt("companyLevel");
            }
            totalSum.append("\r\n where fsumcompanylevel=").append(rootCompanylevel);
        }
        totalSum.append(" \r\n");
        if (paramAge.isAllCurr()) {
            totalSum.append("  group by fcurrid,fcurrname");
        }
        totalSum.append("\r\n");
        if (paramAge.getSqlOrderby().length() > 0) {
            // empty if block
        }
        if (paramAge.isIsOnlyUnion()) {
            // empty if block
        }
        ps = con.prepareStatement(totalSum.toString());
        DbUtil.execute((Context)paramAge.getCtx(), (PreparedStatement)ps);
    }

    private void calculateSumallSumOverdue(Connection con, PreparedStatement ps, String tempTableAcSum, int daylen, boolean isSumLeft, AccountAgeParam paramAge) throws SQLException {
        StringBuffer sql = new StringBuffer();
        StringBuffer sqlSum = new StringBuffer();
        StringBuffer unSqlSum = new StringBuffer();
        int index = 0;
        if (paramAge.isShowUmexpired()) {
            int i;
            index = paramAge.getUndaylen() + 1;
            for (i = 0; i < index; ++i) {
                unSqlSum.append("sum").append(i);
                if (i >= paramAge.getUndaylen()) continue;
                unSqlSum.append("+");
            }
            for (i = index; i <= daylen + index; ++i) {
                sqlSum.append("sum").append(i);
                if (i >= daylen + index) continue;
                sqlSum.append("+");
            }
            sql.append("Update ").append(tempTableAcSum);
            sql.append(" set ");
            sql.append(" sumunoverdue =").append("(").append(unSqlSum).append(")");
            if (isSumLeft) {
                sql.append(", leftamount=").append("(").append(sqlSum).append("+").append(unSqlSum).append(")");
                sql.append(", sumall=").append("(").append(sqlSum).append("+").append(unSqlSum).append(")");
            }
            sql.append(",sumoverdue=").append("(").append(sqlSum).append(")");
        } else {
            sqlSum.append("(");
            for (int i = 0; i <= daylen; ++i) {
                sqlSum.append("sum").append(i);
                if (i >= daylen) continue;
                sqlSum.append("+");
            }
            sqlSum.append(")");
            sql.append("Update ").append(tempTableAcSum);
            sql.append(" set ");
            if (isSumLeft) {
                sql.append(" leftamount=").append(sqlSum).append("+sumunoverdue,");
                sql.append(" sumall=").append(sqlSum).append("+sumunoverdue,");
            }
            sql.append(" sumoverdue=").append(sqlSum);
        }
        ps = con.prepareStatement(sql.toString());
        DbUtil.execute((Context)paramAge.getCtx(), (PreparedStatement)ps);
    }

    private void insertTotalSumLines4GeneralCurency(Connection con, AccountAgeParam paramAge) throws SQLException {
        String selecthgoutsiderealNoCy;
        StringBuffer sql = new StringBuffer();
        StringBuffer totalSum = new StringBuffer();
        ResultSet rs = null;
        PreparedStatement ps = null;
        int generalCyScale = paramAge.getGeneralCurrency().getPrecision();
        String tempTableAcSum = paramAge.getTempTableAcSum();
        int daylen = paramAge.getDaylen();
        if (paramAge.isAccountList()) {
            int i;
            String sumStr = "";
            String sumStrRound = "";
            int index = 0;
            if (paramAge.isShowUmexpired()) {
                index = paramAge.getUndaylen() + 1;
            }
            for (i = 0; i <= daylen + index; ++i) {
                sumStr = sumStr + "sum" + i + ",";
            }
            for (i = 0; i <= daylen + index; ++i) {
                sumStrRound = sumStrRound + "sum" + i + "=round(sum" + i + "," + generalCyScale + "),";
            }
            sql.setLength(0);
            sql.append("Update ").append(tempTableAcSum);
            sql.append(" set ");
            sql.append(sumStrRound);
            sql.append("sumunoverdue=round(sumunoverdue," + generalCyScale + "),");
            sql.append("leftamount=round(leftamount," + generalCyScale + "),");
            sql.append("sumall=round(sumall," + generalCyScale + "),");
            sql.append("sumoverdue=round(sumoverdue," + generalCyScale + ")");
            ps = con.prepareStatement(sql.toString());
            DbUtil.execute((Context)paramAge.getCtx(), (PreparedStatement)ps);
        }
        totalSum.append("select top 1 1 from ").append(paramAge.getTempTableAcSum());
        ps = con.prepareStatement(totalSum.toString());
        rs = ps.executeQuery();
        if (!rs.next()) {
            rs.close();
            ps.close();
            return;
        }
        rs.close();
        ps.close();
        String selecthgoutsiderealGenCy = selecthgoutsiderealNoCy = paramAge.isIncludeVerifyVch() ? paramAge.getSqlSelecthgoutsideReal().toString().trim() : paramAge.getSqlSelecthgoutside().toString().trim();
        String strCy = "fcurrid,fcurrname,";
        String strGeneralCY = "'" + paramAge.getCurrency().getId().toString() + "' fcurrid,N'" + paramAge.getCurrency().getName() + "' fcurrname";
        int startPosi = selecthgoutsiderealNoCy.indexOf(strCy);
        if (startPosi < 0) {
            strCy = "fcurrid,fcurrname";
            startPosi = selecthgoutsiderealNoCy.indexOf(strCy);
        }
        if (startPosi >= 0) {
            selecthgoutsiderealNoCy = selecthgoutsiderealNoCy.replaceAll(strCy, "");
        }
        strCy = "fcurrid,fcurrname";
        selecthgoutsiderealGenCy = selecthgoutsiderealGenCy.replaceAll(strCy, strGeneralCY);
        if ((selecthgoutsiderealNoCy = selecthgoutsiderealNoCy.trim()).length() > 0 && selecthgoutsiderealNoCy.endsWith(",")) {
            selecthgoutsiderealNoCy = selecthgoutsiderealNoCy.substring(0, selecthgoutsiderealNoCy.length() - 1);
        }
        if ((selecthgoutsiderealGenCy = selecthgoutsiderealGenCy.trim()).length() > 0 && selecthgoutsiderealGenCy.endsWith(",")) {
            selecthgoutsiderealGenCy = selecthgoutsiderealGenCy.substring(0, selecthgoutsiderealGenCy.length() - 1);
        }
        totalSum.setLength(0);
        totalSum.append(this.getSql_InsertAcTemp(paramAge, false, true));
        totalSum.append("\r\n select  ");
        if (selecthgoutsiderealGenCy.length() > 0) {
            totalSum.append(selecthgoutsiderealGenCy).append(",");
        }
        totalSum.append("\r\n sum(sumunoverdue) sumunoverdue");
        StringBuffer _tempSum = new StringBuffer("sum(sum1) sum1");
        int ide = 0;
        if (paramAge.isShowUmexpired()) {
            ide = paramAge.getUndaylen() + 1;
        }
        for (int i = 1; i < paramAge.getDaylen() + ide; ++i) {
            _tempSum.append(",sum(sum" + (i + 1) + ") as sum" + (i + 1));
        }
        totalSum.append("\r\n ,sum(sum0) sum0,").append(_tempSum).append("\r\n from ");
        totalSum.append(paramAge.getTempTableAcSum());
        if (selecthgoutsiderealNoCy.toString().trim().length() > 0) {
            totalSum.append(" group by ").append(selecthgoutsiderealNoCy);
        }
        totalSum.append("\r\n");
        ps = con.prepareStatement(totalSum.toString());
        DbUtil.execute((Context)paramAge.getCtx(), (PreparedStatement)ps);
        totalSum.setLength(0);
        totalSum.append("delete from ").append(paramAge.getTempTableAcSum());
        totalSum.append(" where fcurrid <> ? ");
        ps = con.prepareStatement(totalSum.toString());
        int index = 1;
        DbUtil.prepareVarcharParam((PreparedStatement)ps, (int)index++, (String)paramAge.getCurrency().getId().toString());
        DbUtil.execute((Context)paramAge.getCtx(), (PreparedStatement)ps);
    }

    private void calculateLocalAmt4GeneralCy(Connection con, AccountAgeParam paramAge) throws SQLException {
        int i;
        PreparedStatement ps = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Update ").append(paramAge.getTempTableAcSum());
        sql.append(" tmp set (");
        int index = 0;
        if (paramAge.isShowUmexpired()) {
            index = paramAge.getUndaylen() + 1;
        }
        for (i = 0; i <= paramAge.getDaylen() + index; ++i) {
            sql.append("sum").append(i);
            sql.append(",");
        }
        sql.append("sumunoverdue");
        sql.append(" )");
        sql.append(" = ");
        sql.append(" ( select ");
        for (i = 0; i <= paramAge.getDaylen() + index; ++i) {
            sql.append("sum").append(i);
            sql.append(" * isnull(tmpExch.FCONVERTRATEA,1)");
            sql.append(",");
        }
        sql.append("sumunoverdue");
        sql.append(" * isnull(tmpExch.FCONVERTRATEA,1)");
        sql.append(" from " + paramAge.getTempTableExchRate() + " tmpExch where tmpExch.fid = tmp.fcurrid  \r\n");
        sql.append(" )");
        ps = con.prepareStatement(sql.toString());
        DbUtil.execute((Context)paramAge.getCtx(), (PreparedStatement)ps);
    }

    private void calculateSumallSumOverduePre(AccountAgeParam paramAge, Connection con, PreparedStatement ps) throws SQLException {
        int i;
        StringBuffer totalSum = new StringBuffer();
        StringBuffer _tempSum = new StringBuffer(",sumunoverdue");
        StringBuffer _tempAccountSum = new StringBuffer(",acctId,acctNumber");
        int index = 0;
        if (paramAge.isShowUmexpired()) {
            index = paramAge.getUndaylen() + 1;
        }
        for (i = 0; i <= paramAge.getDaylen() + index; ++i) {
            _tempSum.append(",sum" + i);
        }
        totalSum.append("insert into ").append(paramAge.getTempTableAcSum()).append("  \r\n");
        totalSum.append("(").append(paramAge.getSqlSelecthgoutsideReal()).append(_tempAccountSum).append(_tempSum);
        totalSum.append(")\r\n");
        _tempSum = new StringBuffer(",sum(sumunoverdue) sumunoverdue");
        for (i = 0; i <= paramAge.getDaylen() + index; ++i) {
            _tempSum.append(",sum(sum" + i + ") as sum" + i);
        }
        totalSum.append(" select ").append(paramAge.getSqlSelecthgoutsideReal()).append(_tempAccountSum).append(_tempSum).append("  \r\n");
        totalSum.append(" from ").append(paramAge.getTempTableAcSum()).append("  \r\n");
        totalSum.append(" group by ").append(paramAge.getSqlSelecthgoutsideReal()).append(_tempAccountSum);
        ps = con.prepareStatement(totalSum.toString());
        DbUtil.execute((Context)paramAge.getCtx(), (PreparedStatement)ps);
        totalSum.setLength(0);
        totalSum.append(" delete from ").append(paramAge.getTempTableAcSum()).append(" where hgid is null");
        ps = con.prepareStatement(totalSum.toString());
        DbUtil.execute((Context)paramAge.getCtx(), (PreparedStatement)ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTempTable_ByBal_AcSumFromSumVeri(AccountAgeParam paramAge, Connection con) throws SQLException {
        int j;
        Statement ps = null;
        PreparedStatement psVeri = null;
        PreparedStatement psUpdate = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer sqlUpdate = new StringBuffer();
        ResultSet rsVeri = null;
        ResultSet rsAcSum = null;
        StringBuffer sqlWhere = new StringBuffer();
        ArrayList<String> lstParam = new ArrayList<String>();
        int index = 1;
        try {
            sql.append("create index I").append(paramAge.getTempTableSumVeri()).append("1 on ").append(paramAge.getTempTableSumVeri()).append("(sumVeri) ");
            ps = con.prepareStatement(sql.toString());
            DbUtil.execute((Context)paramAge.getCtx(), (PreparedStatement)ps);
        }
        catch (Exception ex) {
            logger.error((Object)"create index I1 error", (Throwable)ex);
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        sql.setLength(0);
        sql.append(" select * from ").append(paramAge.getTempTableSumVeri());
        sql.append(" where sumVeri <> 0.0 ");
        psVeri = con.prepareStatement(sql.toString());
        rsVeri = psVeri.executeQuery();
        sqlUpdate.setLength(0);
        sqlUpdate.append("update ").append(paramAge.getTempTableAcSum());
        sqlUpdate.append(" set ");
        int im = 0;
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j <= paramAge.getUndaylen(); ++j) {
                sqlUpdate.append("sum" + j).append("=?,");
            }
        }
        for (int i = 0; i <= paramAge.getDaylen(); ++i) {
            im = i + j;
            sqlUpdate.append("sum" + im).append("=?,");
        }
        sqlUpdate.append("sumUnOverDue = ?");
        String keyField = "";
        sqlWhere.append(" Where 1=1");
        for (int i = 0; i < paramAge.getLstHgOutSide().size(); ++i) {
            keyField = (String)paramAge.getLstHgOutSide().get(i);
            if (keyField.indexOf("number") >= 0 || keyField.indexOf("name") >= 0) continue;
            sqlWhere.append(" AND ");
            sqlWhere.append(keyField).append(" = ?");
        }
        sql.setLength(0);
        sql.append(sqlUpdate);
        if (paramAge.isIsOnlyUnion() && !paramAge.isBizCode() && paramAge.isAccountList()) {
            sqlWhere.append(" and T0fnumber = ?");
        }
        sql.append(sqlWhere).append(" AND acctid = ?");
        psUpdate = con.prepareStatement(sql.toString());
        try {
            int iCountPsUpdate = 0;
            String hgID = null;
            String currID = null;
            String acctid = null;
            while (rsVeri.next()) {
                int i;
                BigDecimal sumVeri = rsVeri.getBigDecimal("SumVeri");
                if (sumVeri.compareTo(GlUtils.zero) == 0) continue;
                lstParam.clear();
                for (int i2 = 0; i2 < paramAge.getLstHgOutSide().size(); ++i2) {
                    keyField = (String)paramAge.getLstHgOutSide().get(i2);
                    if (keyField.indexOf("number") >= 0 || keyField.indexOf("name") >= 0) continue;
                    lstParam.add(rsVeri.getString(keyField));
                }
                sql.setLength(0);
                sql.append("select * from ").append(paramAge.getTempTableAcSum()).append(sqlWhere).append(" and acctid = ? ");
                ps = con.prepareStatement(sql.toString());
                index = 1;
                index = GLAcctAgeUtils.setupParams_updateTempTable_ByBal_AcSumFromSumVeri((PreparedStatement)ps, (int)index, lstParam);
                if (paramAge.isIsOnlyUnion() && !paramAge.isBizCode() && paramAge.isAccountList()) {
                    ps.setString(index++, rsVeri.getString("T0fnumber"));
                }
                ps.setString(index++, rsVeri.getString("acctid"));
                rsAcSum = ps.executeQuery();
                if (!rsAcSum.next()) {
                    SQLUtils.cleanup((ResultSet)rsAcSum, (Statement)ps);
                    continue;
                }
                BigDecimal[] acSum = null;
                BigDecimal[] veriSum = null;
                BigDecimal acSumTotal = GlUtils.zero;
                BigDecimal veriSumTotal = GlUtils.zero;
                BigDecimal sumUnOverDue = rsAcSum.getBigDecimal("sumUnOverDue");
                BigDecimal verisumUnOverDue = null;
                if (paramAge.isShowUmexpired()) {
                    acSum = new BigDecimal[paramAge.getDaylen() + paramAge.getUndaylen() + 2];
                    veriSum = new BigDecimal[paramAge.getDaylen() + paramAge.getUndaylen() + 2];
                    for (i = 0; i < acSum.length; ++i) {
                        acSum[i] = GlUtils.zero;
                        veriSum[i] = GlUtils.zero;
                    }
                    for (i = acSum.length - 1; i >= 0; --i) {
                        if (rsAcSum.getBigDecimal("sum" + i) == null) continue;
                        acSum[i] = rsAcSum.getBigDecimal("sum" + i);
                        acSumTotal = acSumTotal.add(acSum[i]);
                    }
                    for (i = veriSum.length - 1; i >= 0; --i) {
                        if (rsVeri.getBigDecimal("sum" + i) == null) continue;
                        veriSum[i] = rsVeri.getBigDecimal("sum" + i);
                        veriSumTotal = veriSumTotal.add(veriSum[i]);
                    }
                    this.beginToEnd(acSum, paramAge.getUndaylen());
                    this.beginToEnd(veriSum, paramAge.getUndaylen());
                } else {
                    acSum = new BigDecimal[paramAge.getDaylen() + 2];
                    veriSum = new BigDecimal[paramAge.getDaylen() + 2];
                    for (i = 0; i < acSum.length; ++i) {
                        acSum[i] = GlUtils.zero;
                        veriSum[i] = GlUtils.zero;
                    }
                    verisumUnOverDue = rsVeri.getBigDecimal("sumVeriUnOverDue");
                    for (i = acSum.length - 1; i >= 1; --i) {
                        if (rsAcSum.getBigDecimal("sum" + (i - 1)) == null) continue;
                        acSum[i] = rsAcSum.getBigDecimal("sum" + (i - 1));
                        acSumTotal = acSumTotal.add(acSum[i]);
                    }
                    acSum[0] = sumUnOverDue;
                    acSumTotal = acSumTotal.add(acSum[0]);
                    for (i = veriSum.length - 1; i >= 1; --i) {
                        if (rsVeri.getBigDecimal("sum" + (i - 1)) == null) continue;
                        veriSum[i] = rsVeri.getBigDecimal("sum" + (i - 1));
                        veriSumTotal = veriSumTotal.add(veriSum[i]);
                    }
                    veriSum[0] = verisumUnOverDue;
                    veriSumTotal = veriSumTotal.add(veriSum[0]);
                }
                SQLUtils.cleanup((ResultSet)rsAcSum, (Statement)ps);
                hgID = rsVeri.getString("hgid");
                currID = rsVeri.getString("fcurrid");
                acctid = rsVeri.getString("acctid");
                acSum = this.simulVeri_New(acSum, veriSum, acSumTotal, veriSumTotal, paramAge, con, hgID, currID, acctid);
                if (paramAge.isShowUmexpired()) {
                    this.beginToEnd(acSum, paramAge.getUndaylen());
                } else {
                    sumUnOverDue = acSum[0];
                }
                index = 1;
                if (paramAge.isShowUmexpired()) {
                    for (i = 0; i < acSum.length; ++i) {
                        psUpdate.setBigDecimal(index++, acSum[i]);
                    }
                } else {
                    for (i = 1; i < acSum.length; ++i) {
                        psUpdate.setBigDecimal(index++, acSum[i]);
                    }
                }
                psUpdate.setBigDecimal(index++, sumUnOverDue);
                index = GLAcctAgeUtils.setupParams_updateTempTable_ByBal_AcSumFromSumVeri((PreparedStatement)psUpdate, (int)index, lstParam);
                if (paramAge.isIsOnlyUnion() && !paramAge.isBizCode() && paramAge.isAccountList()) {
                    psUpdate.setString(index++, rsVeri.getString("T0fnumber"));
                }
                psUpdate.setString(index++, BOSUuid.read((String)acctid).toString());
                psUpdate.addBatch();
                if (++iCountPsUpdate < 2000) continue;
                iCountPsUpdate = 0;
                psUpdate.executeBatch();
                psUpdate.clearBatch();
            }
            if (iCountPsUpdate > 0) {
                iCountPsUpdate = 0;
                psUpdate.executeBatch();
                psUpdate.clearBatch();
            }
            SQLUtils.cleanup((Statement)psUpdate);
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            SQLUtils.cleanup((ResultSet)rsVeri, (Statement)psVeri);
            SQLUtils.cleanup(rsAcSum, (Statement)ps);
            SQLUtils.cleanup((Statement)psUpdate);
        }
    }

    private BigDecimal[] simulVeri_New(BigDecimal[] acSum, BigDecimal[] veriSum, BigDecimal acSumTotal, BigDecimal veriSumTotal, AccountAgeParam paramAge, Connection con, String hgID, String currID, String acctid) throws SQLException {
        if (acSumTotal.compareTo(GlUtils.zero) == 0) {
            boolean isAllZero = true;
            int len = acSum.length - 1;
            for (int i = 0; i <= len; ++i) {
                if (acSum[i].compareTo(GlUtils.zero) == 0) continue;
                isAllZero = false;
            }
            if (isAllZero) {
                veriSum = this.reGetVeriData(paramAge, con, hgID, currID, veriSumTotal, veriSum, acctid);
                acSum = this.showVerifyAge(acSum, veriSum, acSumTotal, veriSumTotal);
            }
        } else {
            acSum = acSumTotal.compareTo(GlUtils.zero) > 0 && veriSumTotal.compareTo(GlUtils.zero) > 0 && acSumTotal.compareTo(veriSumTotal) < 0 || acSumTotal.compareTo(GlUtils.zero) < 0 && veriSumTotal.compareTo(GlUtils.zero) < 0 && acSumTotal.compareTo(veriSumTotal) > 0 ? this.showVerifyAge(acSum, veriSum, acSumTotal, veriSumTotal) : this.showCussentAge(acSum, veriSum, acSumTotal, veriSumTotal);
        }
        return acSum;
    }

    private BigDecimal[] reGetVeriData(AccountAgeParam paramAge, Connection con, String hgID, String currID, BigDecimal veriSumTotal, BigDecimal[] veriSum, String acctid) throws SQLException {
        PreparedStatement psVeri = null;
        PreparedStatement psVerfied = null;
        ResultSet rsVeri = null;
        ResultSet rsVerfied = null;
        try {
            if (veriSumTotal.compareTo(GlUtils.zero) > 0) {
                psVeri = con.prepareStatement(paramAge.getSqlForSumVeriPositive().toString());
                psVerfied = con.prepareStatement(paramAge.getSqlForSumVerifiedPositive().toString());
                System.out.println(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"374_QueryAgeBalance"));
                System.out.println("=====================================getSqlForSumVeriPositive " + paramAge.getSqlForSumVeriPositive().toString());
                System.out.println("=====================================getSqlForSumVerifiedPositive " + paramAge.getSqlForSumVerifiedPositive().toString());
            } else {
                psVeri = con.prepareStatement(paramAge.getSqlForSumVeriNegative().toString());
                psVerfied = con.prepareStatement(paramAge.getSqlForSumVerifiedNegative().toString());
                System.out.println("=====================================getSqlForSumVeriNegative " + paramAge.getSqlForSumVeriNegative().toString());
                System.out.println("=====================================getSqlForSumVerifiedNegative " + paramAge.getSqlForSumVerifiedNegative().toString());
                System.out.println(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"375_QueryAgeBalance"));
            }
            this.setupParams_ByBal_InsertSumVeriAndSumVeri(paramAge, psVeri, psVerfied, hgID, currID, acctid);
            rsVeri = psVeri.executeQuery();
            rsVerfied = psVerfied.executeQuery();
            while (rsVeri.next()) {
                System.out.println(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"376_QueryAgeBalance"));
                veriSum = this.getVeriData(paramAge, rsVeri, rsVerfied, hgID, currID, acctid);
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rsVeri, psVeri);
                SQLUtils.cleanup(rsVerfied, psVerfied);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rsVeri, (Statement)psVeri);
        SQLUtils.cleanup((ResultSet)rsVerfied, (Statement)psVerfied);
        System.out.println(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"377_QueryAgeBalance"));
        return veriSum;
    }

    private BigDecimal[] getVeriData(AccountAgeParam paramAge, ResultSet rsVeri, ResultSet rsVerfied, String hgID, String currID, String acctid) throws SQLException {
        int i;
        BigDecimal[] veriSum = null;
        boolean hasVerfiedRecord = false;
        while (rsVerfied.next()) {
            hasVerfiedRecord = true;
            System.out.println(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"378_QueryAgeBalance"));
            if (paramAge.isShowUmexpired()) {
                veriSum = new BigDecimal[paramAge.getDaylen() + paramAge.getUndaylen() + 2];
                for (i = veriSum.length - 1; i >= 0; --i) {
                    veriSum[i] = (rsVeri.getBigDecimal("sum" + i) != null ? rsVeri.getBigDecimal("sum" + i) : GlUtils.zero).subtract(rsVerfied.getBigDecimal("sum" + i) != null ? rsVerfied.getBigDecimal("sum" + i) : GlUtils.zero);
                }
                this.beginToEnd(veriSum, paramAge.getUndaylen());
                continue;
            }
            System.out.println(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"379_QueryAgeBalance"));
            veriSum = new BigDecimal[paramAge.getDaylen() + 2];
            for (i = veriSum.length - 1; i >= 1; --i) {
                veriSum[i] = (rsVeri.getBigDecimal("sum" + (i - 1)) != null ? rsVeri.getBigDecimal("sum" + (i - 1)) : GlUtils.zero).subtract(rsVerfied.getBigDecimal("sum" + (i - 1)) != null ? rsVerfied.getBigDecimal("sum" + (i - 1)) : GlUtils.zero);
            }
            veriSum[0] = (rsVeri.getBigDecimal("sumVeriUnOverDue") != null ? rsVeri.getBigDecimal("sumVeriUnOverDue") : GlUtils.zero).subtract(rsVerfied.getBigDecimal("sumVeriUnOverDue") != null ? rsVerfied.getBigDecimal("sumVeriUnOverDue") : GlUtils.zero);
        }
        if (!hasVerfiedRecord) {
            if (paramAge.isShowUmexpired()) {
                System.out.println(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"380_QueryAgeBalance"));
                veriSum = new BigDecimal[paramAge.getDaylen() + paramAge.getUndaylen() + 2];
                for (i = veriSum.length - 1; i >= 0; --i) {
                    veriSum[i] = rsVeri.getBigDecimal("sum" + i) != null ? rsVeri.getBigDecimal("sum" + i) : GlUtils.zero;
                }
                this.beginToEnd(veriSum, paramAge.getUndaylen());
            } else {
                System.out.println(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"381_QueryAgeBalance"));
                veriSum = new BigDecimal[paramAge.getDaylen() + 2];
                for (i = veriSum.length - 1; i >= 1; --i) {
                    veriSum[i] = rsVeri.getBigDecimal("sum" + (i - 1)) != null ? rsVeri.getBigDecimal("sum" + (i - 1)) : GlUtils.zero;
                }
                veriSum[0] = rsVeri.getBigDecimal("sumVeriUnOverDue") != null ? rsVeri.getBigDecimal("sumVeriUnOverDue") : GlUtils.zero;
            }
        }
        return veriSum;
    }

    private void setupParams_ByBal_InsertSumVeriAndSumVeri(AccountAgeParam paramAge, PreparedStatement psVeri, PreparedStatement psVerfied, String hgID, String currID, String acctid) throws SQLException {
        int index = 1;
        String companyID = paramAge.getCurCompanyid();
        if (paramAge.getDisplayMode() == 4 && !paramAge.isDisplayLeafCompany() && !paramAge.isIsfirstload()) {
            paramAge.setCurCompanyid(null);
        }
        HashMap<Integer, String> map1 = new HashMap<Integer, String>();
        index = QueryAgeBalance.setupParams_ByBal_InsertSumVeri(paramAge, psVeri, index, false, map1);
        map1.put(index, hgID);
        psVeri.setString(index++, BOSUuid.read((String)hgID).toString());
        map1.put(index, currID);
        psVeri.setString(index++, BOSUuid.read((String)currID).toString());
        map1.put(index, acctid);
        psVeri.setString(index++, BOSUuid.read((String)acctid).toString());
        System.out.println("====================================map1:" + map1);
        HashMap<Integer, Object> map2 = new HashMap<Integer, Object>();
        index = 1;
        index = QueryAgeBalance.setupParams_ByBal_InsertSumVeri(paramAge, psVerfied, index, false, map2);
        Calendar cal = Calendar.getInstance();
        cal.setTime(paramAge.getHistoryDate());
        map2.put(index, new Date(cal.getTimeInMillis()));
        psVerfied.setDate(index++, new Date(cal.getTimeInMillis()));
        map2.put(index, hgID);
        psVerfied.setString(index++, BOSUuid.read((String)hgID).toString());
        map2.put(index, currID);
        psVerfied.setString(index++, BOSUuid.read((String)currID).toString());
        map2.put(index, acctid);
        psVerfied.setString(index++, BOSUuid.read((String)acctid).toString());
        if (paramAge.isIncludeInit()) {
            index = QueryAgeBalance.setupParams_ByBal_InsertSumVeri(paramAge, psVerfied, index, true, map2);
            cal.setTime(paramAge.getHistoryDate());
            map2.put(index, new Date(cal.getTimeInMillis()));
            psVerfied.setDate(index++, new Date(cal.getTimeInMillis()));
            map2.put(index, hgID);
            psVerfied.setString(index++, BOSUuid.read((String)hgID).toString());
            map2.put(index, currID);
            psVerfied.setString(index++, BOSUuid.read((String)currID).toString());
            map2.put(index, acctid);
            psVerfied.setString(index++, BOSUuid.read((String)acctid).toString());
        }
        paramAge.setCurCompanyid(companyID);
        System.out.println("====================================map2:" + map2);
    }

    public static int setupParams_ByBal_InsertSumVeri(AccountAgeParam paramAge, PreparedStatement ps, int index, boolean isInit, Map map) throws SQLException {
        for (String number : paramAge.getAlAstNumbers()) {
            map.put(index, number);
            ps.setString(index++, number);
        }
        Calendar cal = Calendar.getInstance();
        if (!isInit) {
            cal.setTime(paramAge.getHistoryDate());
            map.put(index, new Date(cal.getTimeInMillis()));
            ps.setDate(index++, new Date(cal.getTimeInMillis()));
        }
        if (paramAge.isAccountList() || paramAge.getAccountViewNumber() != null || paramAge.getAccountid() != null) {
            // empty if block
        }
        if (!StringUtils.isEmpty((String)paramAge.getCurCompanyid())) {
            map.put(index, paramAge.getCurCompanyid());
            ps.setString(index++, paramAge.getCurCompanyid());
        }
        if (!isInit && paramAge.getLastPhaseBeginDate() != null) {
            cal.setTime(paramAge.getLastPhaseBeginDate());
            map.put(index, new Date(cal.getTimeInMillis()));
            ps.setDate(index++, new Date(cal.getTimeInMillis()));
        }
        if (paramAge.isSetCurrency()) {
            map.put(index, paramAge.getCurrencyid());
            ps.setString(index++, paramAge.getCurrencyid());
        }
        if (paramAge.isAccountList()) {
            if (!StringUtils.isEmpty((String)paramAge.getAccountFromNumber())) {
                map.put(index, paramAge.getAccountFromNumber());
                ps.setString(index++, paramAge.getAccountFromNumber());
            }
            if (!StringUtils.isEmpty((String)paramAge.getAccountToNumber())) {
                map.put(index, paramAge.getAccountToNumber() + "zzzzzz");
                ps.setString(index++, paramAge.getAccountToNumber() + "zzzzzz");
            }
        }
        return index;
    }

    private BigDecimal[] showVerifyAge(BigDecimal[] acSum, BigDecimal[] veriSum, BigDecimal acSumTotal, BigDecimal veriSumTotal) {
        this.dealSimulVeri_for_showVerifyAge(veriSum, veriSumTotal);
        BigDecimal veriLeftamount = veriSumTotal.subtract(acSumTotal);
        BigDecimal nagetiveOne = new BigDecimal(-1);
        if (veriLeftamount.compareTo(GlUtils.zero) > 0) {
            int len = veriSum.length - 1;
            for (int i = 0; i <= len; ++i) {
                if (veriSum[i].compareTo(GlUtils.zero) > 0 && veriSum[i].compareTo(veriLeftamount) >= 0) {
                    acSum[i] = veriLeftamount.multiply(nagetiveOne);
                    ++i;
                    while (i <= len) {
                        acSum[i] = GlUtils.zero;
                        ++i;
                    }
                    continue;
                }
                if (veriSum[i].compareTo(GlUtils.zero) > 0 && veriSum[i].compareTo(veriLeftamount) < 0) {
                    acSum[i] = veriSum[i].multiply(nagetiveOne);
                    veriLeftamount = veriLeftamount.subtract(veriSum[i]);
                    continue;
                }
                if (veriSum[i].compareTo(GlUtils.zero) > 0) continue;
                acSum[i] = GlUtils.zero;
            }
        } else {
            int len = veriSum.length - 1;
            for (int i = 0; i <= len; ++i) {
                if (veriSum[i].compareTo(GlUtils.zero) < 0 && veriSum[i].compareTo(veriLeftamount) <= 0) {
                    acSum[i] = veriLeftamount.multiply(nagetiveOne);
                    ++i;
                    while (i <= len) {
                        acSum[i] = GlUtils.zero;
                        ++i;
                    }
                    continue;
                }
                if (veriSum[i].compareTo(GlUtils.zero) < 0 && veriSum[i].compareTo(veriLeftamount) > 0) {
                    acSum[i] = veriSum[i].multiply(nagetiveOne);
                    veriLeftamount = veriLeftamount.subtract(veriSum[i]);
                    continue;
                }
                if (veriSum[i].compareTo(GlUtils.zero) < 0) continue;
                acSum[i] = GlUtils.zero;
            }
        }
        return acSum;
    }

    /*
     * Enabled aggressive block sorting
     */
    private BigDecimal[] showCussentAge(BigDecimal[] acSum, BigDecimal[] veriSum, BigDecimal acSumTotal, BigDecimal veriSumTotal) {
        if (veriSumTotal.compareTo(GlUtils.zero) > 0) {
            int i = acSum.length - 1;
            while (i >= 0) {
                if (acSum[i].compareTo(GlUtils.zero) != 0) {
                    if (acSum[i].compareTo(GlUtils.zero) <= 0) {
                        acSum[i] = acSum[i].subtract(veriSumTotal);
                        veriSumTotal = GlUtils.zero;
                        return acSum;
                    }
                    if (acSum[i].compareTo(veriSumTotal) > 0) {
                        acSum[i] = acSum[i].subtract(veriSumTotal);
                        veriSumTotal = GlUtils.zero;
                        return acSum;
                    }
                    veriSumTotal = veriSumTotal.subtract(acSum[i]);
                    acSum[i] = GlUtils.zero;
                }
                --i;
            }
            return acSum;
        }
        if (veriSumTotal.compareTo(GlUtils.zero) >= 0) return acSum;
        int i = acSum.length - 1;
        while (i >= 0) {
            if (acSum[i].compareTo(GlUtils.zero) != 0) {
                if (acSum[i].compareTo(GlUtils.zero) > 0) {
                    acSum[i] = acSum[i].subtract(veriSumTotal);
                    veriSumTotal = GlUtils.zero;
                    return acSum;
                }
                if (acSum[i].compareTo(veriSumTotal) <= 0) {
                    acSum[i] = acSum[i].subtract(veriSumTotal);
                    veriSumTotal = GlUtils.zero;
                    return acSum;
                }
                veriSumTotal = veriSumTotal.subtract(acSum[i]);
                acSum[i] = GlUtils.zero;
            }
            --i;
        }
        return acSum;
    }

    private BigDecimal[] dealSimulVeri_for_showVerifyAge(BigDecimal[] veriSum, BigDecimal veriSumTotal) {
        BigDecimal oneSideSum = GlUtils.zero;
        if (veriSumTotal.compareTo(GlUtils.zero) > 0) {
            for (int i = veriSum.length - 1; i >= 0; --i) {
                if (veriSum[i].compareTo(GlUtils.zero) >= 0) continue;
                oneSideSum = oneSideSum.add(veriSum[i]);
                veriSum[i] = GlUtils.zero;
            }
        } else {
            for (int i = veriSum.length - 1; i >= 0; --i) {
                if (veriSum[i].compareTo(GlUtils.zero) <= 0) continue;
                oneSideSum = oneSideSum.add(veriSum[i]);
                veriSum[i] = GlUtils.zero;
            }
        }
        veriSum = this.simulVeri_for_showVerifyAge(veriSum, oneSideSum);
        return veriSum;
    }

    private BigDecimal[] simulVeri_for_showVerifyAge(BigDecimal[] veriSum, BigDecimal oneSideSum) {
        int positiveOrNagetive_old = oneSideSum.signum();
        int positiveOrNagetive_new = 0;
        boolean isOver = false;
        for (int i = veriSum.length - 1; i >= 0; --i) {
            if (veriSum[i].compareTo(GlUtils.zero) == 0) continue;
            positiveOrNagetive_new = (oneSideSum = oneSideSum.add(veriSum[i])).signum();
            if (positiveOrNagetive_new != positiveOrNagetive_old) {
                veriSum[i] = oneSideSum;
                isOver = true;
            } else {
                veriSum[i] = GlUtils.zero;
            }
            if (isOver) break;
        }
        return veriSum;
    }

    private void beginToEnd(BigDecimal[] decs, int index) {
        BigDecimal temp = null;
        for (int i = 0; i <= index / 2; ++i) {
            temp = decs[i];
            decs[i] = decs[index - i];
            decs[index - i] = temp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTempTable_ByBal_AcSumFromBal_PreInsertLine(AccountAgeParam paramAge, Connection con) throws SQLException {
        Statement ps = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer sqlInsertFields = new StringBuffer();
        StringBuffer sqlSelectFields = new StringBuffer();
        StringBuffer sqlWhereUpdate = new StringBuffer();
        StringBuffer sqlIndexField = new StringBuffer();
        String accountJoin = " AND  bal.acctId = tmp.acctId ";
        String keyField2 = "";
        for (String keyField2 : paramAge.getLstHgOutSide()) {
            sqlInsertFields.append(",").append(keyField2);
            sqlSelectFields.append(",").append(" bal.").append(keyField2);
            if (keyField2.indexOf("number") >= 0 || keyField2.indexOf("name") >= 0) continue;
            sqlWhereUpdate.append(" AND bal.").append(keyField2).append(" = tmp.").append(keyField2);
            sqlIndexField.append(keyField2).append(",");
        }
        sqlIndexField.append("acctId");
        try {
            sql.setLength(0);
            sql.append("create index I").append(paramAge.getTempTableAcSum()).append(" on ").append(paramAge.getTempTableAcSum()).append("(").append(sqlIndexField).append(") ");
            ps = con.prepareStatement(sql.toString());
            DbUtil.execute((Context)paramAge.getCtx(), (PreparedStatement)ps);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        sql.setLength(0);
        sql.append(" Insert Into ").append(paramAge.getTempTableAcSum());
        sql.append("( ");
        sql.append(sqlInsertFields.substring(1, sqlInsertFields.length()));
        sql.append(",acctId,acctNumber ");
        sql.append(") \r\n");
        sql.append(" select ");
        sql.append(sqlSelectFields.substring(1, sqlSelectFields.length()));
        sql.append(",bal.acctId,bal.acctNumber ");
        sql.append("\r\n from ").append(paramAge.getTempTableSumVeri()).append(" bal    \r\n");
        sql.append(" left outer join ").append(paramAge.getTempTableAcSum()).append(" tmp \r\n");
        sql.append(" on ").append(sqlWhereUpdate.substring(4, sqlWhereUpdate.length())).append(accountJoin);
        if (paramAge.isIsOnlyUnion() && !paramAge.isBizCode() && paramAge.isAccountList()) {
            sql.append(" and  bal.T0fnumber = tmp.T0fnumber");
        }
        sql.append(" \r\n Where tmp.fcurrid is null ");
        ps = con.prepareStatement(sql.toString());
        DbUtil.execute((Context)paramAge.getCtx(), (PreparedStatement)ps);
    }

    private void updateTempTable_ByBal_SumVeriFromSumVerified(AccountAgeParam paramAge, Connection con) throws SQLException {
        int i;
        int j;
        PreparedStatement ps = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer sqlUpdate = new StringBuffer();
        StringBuffer sqlWhereUpdate = new StringBuffer();
        String accountidJoin = " AND bal.acctid = tmp.acctid ";
        String keyField2 = "";
        for (String keyField2 : paramAge.getLstHgOutSide()) {
            if (keyField2.indexOf("number") >= 0 || keyField2.indexOf("name") >= 0) continue;
            sqlWhereUpdate.append(" AND bal.").append(keyField2).append(" = tmp.").append(keyField2);
        }
        sqlUpdate.setLength(0);
        sqlUpdate.append("update ").append(paramAge.getTempTableSumVeri()).append(" tmp \r\n");
        sqlUpdate.append(" set (SumVeri    \r\n");
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j < paramAge.getUndaylen() + 1; ++j) {
                sqlUpdate.append(",sum" + j);
            }
        } else {
            sqlUpdate.append(",SumVeriUnOverDue   \r\n");
        }
        int index = 0;
        for (i = 0; i < paramAge.getDaylen() + 1; ++i) {
            index = j + i;
            sqlUpdate.append(",sum" + index);
        }
        sqlUpdate.append(" ) \r\n");
        sqlUpdate.append(" =                \r\n");
        sqlUpdate.append("(select tmp.SumVeri - bal.SumVeri                \r\n");
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j < paramAge.getUndaylen() + 1; ++j) {
                sqlUpdate.append(" ,tmp.sum" + j + "-bal.sum" + j);
            }
        } else {
            sqlUpdate.append(",tmp.SumVeriUnOverDue - bal.SumVeriUnOverDue \r\n");
        }
        index = 0;
        for (i = 0; i < paramAge.getDaylen() + 1; ++i) {
            index = j + i;
            sqlUpdate.append(" ,tmp.sum" + index + "-bal.sum" + index);
        }
        sqlUpdate.append(" from ").append(paramAge.getTempTableSumVerified()).append(" bal \r\n");
        sqlUpdate.append(" where 1=1               \r\n");
        sqlUpdate.append(sqlWhereUpdate).append(accountidJoin).append(" )                \r\n");
        ps = con.prepareStatement(sqlUpdate.toString());
        DbUtil.execute((Context)paramAge.getCtx(), (PreparedStatement)ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTempTable_ByBal_SumVeriFromSumVerified_PreInsertLine(AccountAgeParam paramAge, Connection con) throws SQLException {
        Statement ps = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer sqlInsertFields = new StringBuffer();
        StringBuffer sqlSelectFields = new StringBuffer();
        StringBuffer sqlWhereUpdate = new StringBuffer();
        StringBuffer sqlIndexField = new StringBuffer();
        String keyField2 = "";
        for (String keyField2 : paramAge.getLstHgOutSide()) {
            sqlInsertFields.append(",").append(keyField2);
            sqlSelectFields.append(",").append(" bal.").append(keyField2);
            if (keyField2.indexOf("number") >= 0 || keyField2.indexOf("name") >= 0) continue;
            sqlWhereUpdate.append(" AND bal.").append(keyField2).append(" = tmp.").append(keyField2);
            sqlIndexField.append(keyField2).append(",");
        }
        sqlIndexField.append("acctId");
        try {
            sql.setLength(0);
            sql.append("create index I").append(paramAge.getTempTableSumVeri()).append(" on ").append(paramAge.getTempTableSumVeri()).append("(").append(sqlIndexField).append(") ");
            ps = con.prepareStatement(sql.toString());
            DbUtil.execute((Context)paramAge.getCtx(), (PreparedStatement)ps);
            sql.setLength(0);
            sql.append("create index I").append(paramAge.getTempTableSumVerified()).append(" on ").append(paramAge.getTempTableSumVerified()).append("(").append(sqlIndexField).append(") ");
            ps = con.prepareStatement(sql.toString());
            DbUtil.execute((Context)paramAge.getCtx(), (PreparedStatement)ps);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        sql.setLength(0);
        sql.append(" Insert Into ").append(paramAge.getTempTableSumVeri());
        sql.append("( ");
        sql.append(sqlInsertFields.substring(1, sqlInsertFields.length()));
        sql.append(",acctId,acctNumber");
        sql.append(") \r\n");
        sql.append(" select ");
        sql.append(sqlSelectFields.substring(1, sqlSelectFields.length()));
        sql.append(",bal.acctId,bal.acctNumber");
        sql.append("\r\n from ").append(paramAge.getTempTableSumVerified()).append(" bal    \r\n");
        sql.append(" left outer join ").append(paramAge.getTempTableSumVeri()).append(" tmp \r\n");
        sql.append(" on ").append(sqlWhereUpdate.substring(4, sqlWhereUpdate.length()));
        sql.append("\r\n Where tmp.fcurrid is null ");
        ps = con.prepareStatement(sql.toString());
        DbUtil.execute((Context)paramAge.getCtx(), (PreparedStatement)ps);
    }

    private void insertIntoTempTable_ByBal_SumVerified(AccountAgeParam paramAge, Connection con, StringBuffer sqlSumVeri) throws SQLException {
        int j;
        PreparedStatement ps = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer accountsb = new StringBuffer(" ,acctId, acctNumber ");
        sql.append("Insert Into ").append(paramAge.getTempTableSumVerified()).append("\r\n (").append(paramAge.getSqlSelecthgoutside()).append(accountsb).append(",SumVeri \r\n");
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j < paramAge.getUndaylen() + 1; ++j) {
                sql.append(",sum" + j);
            }
        } else {
            sql.append(",SumVeriUnOverDue \r\n");
        }
        int index = 0;
        for (int i = 0; i < paramAge.getDaylen() + 1; ++i) {
            index = j + i;
            sql.append(",sum" + index);
        }
        sql.append(") ");
        sql.append(sqlSumVeri);
        ps = con.prepareStatement(sql.toString());
        String companyID = paramAge.getCurCompanyid();
        if (paramAge.getDisplayMode() == 4 && !paramAge.isDisplayLeafCompany() && !paramAge.isIsfirstload()) {
            paramAge.setCurCompanyid(null);
        }
        index = 1;
        index = GLAcctAgeUtils.setupParams_ByBal_InsertSumVeri((AccountAgeParam)paramAge, (PreparedStatement)ps, (int)index, (boolean)false);
        Calendar cal = Calendar.getInstance();
        cal.setTime(paramAge.getHistoryDate());
        ps.setDate(index++, new Date(cal.getTimeInMillis()));
        if (paramAge.isIncludeInit()) {
            index = GLAcctAgeUtils.setupParams_ByBal_InsertSumVeri((AccountAgeParam)paramAge, (PreparedStatement)ps, (int)index, (boolean)true);
            cal.setTime(paramAge.getHistoryDate());
            ps.setDate(index++, new Date(cal.getTimeInMillis()));
        }
        paramAge.setCurCompanyid(companyID);
        DbUtil.execute((Context)paramAge.getCtx(), (PreparedStatement)ps);
    }

    private StringBuffer getHistorySql4Verified(AccountAgeParam paramAge) throws BOSException, EASBizException {
        int j;
        StringBuffer historySql = new StringBuffer();
        GLAcctAgeUtils.getSql_ByBal_VerifiedSum_NotInit_From((AccountAgeParam)paramAge);
        GLAcctAgeUtils.getSql_ByBal_VerifiedSum_Init_From((AccountAgeParam)paramAge);
        GLAcctAgeUtils.getSql_ByBal_VerifiedSum_NotInit_Where((AccountAgeParam)paramAge);
        GLAcctAgeUtils.getSql_ByBal_VerifiedSum_Init_Where((AccountAgeParam)paramAge);
        String amountField = null;
        amountField = "khis.FOroginalAmount";
        String accountCol = " account.fid as acctId, account.fnumber as acctNumber, ";
        StringBuffer sum = new StringBuffer("\r\n isnull(sum(" + amountField + "),0) SumVeri  \r\n");
        String accountSum = "\r\n ,acctId, acctNumber ";
        String accountGroup = ",account.fid,account.fnumber ";
        String accountSumGroup = ",acctId,acctNumber ";
        String dateField = paramAge.getStrDateType_AC();
        if (!dateField.equalsIgnoreCase("fenddate")) {
            dateField = "fbizdate";
        }
        ArrayList allPhaseDates = GLAcctAgeUtils.getAllPhaseDates((AccountAgeParam)paramAge);
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j < paramAge.getUndaylen() + 1; ++j) {
                if (j == 0) {
                    sum.append(",sum(case when cussent.").append(dateField).append(">=to_date('" + QueryAgeBalance.getFormateDate((java.util.Date)allPhaseDates.get(j * 2)) + "') and cussent.").append(dateField).append("<=to_date('" + QueryAgeBalance.getFormateDate((java.util.Date)allPhaseDates.get(j * 2 + 1)) + "') then " + paramAge.getAmountField_veri() + " else 0 end) as sum" + j + "  \r\n");
                    continue;
                }
                sum.append(",sum(case when cussent.").append(dateField).append(">to_date('" + QueryAgeBalance.getFormateDate((java.util.Date)allPhaseDates.get(j * 2)) + "')  and cussent.").append(dateField).append("<=to_date('" + QueryAgeBalance.getFormateDate((java.util.Date)allPhaseDates.get(j * 2 + 1)) + "') then " + paramAge.getAmountField_veri() + " else 0 end) as sum" + j + "  \r\n");
            }
        } else {
            sum.append(",sum(case when cussent.").append(dateField).append(">=to_date('" + QueryAgeBalance.getFormateDate(paramAge.getEndDate()) + "') then " + amountField + " else 0 end) as SumVeriUnOverDue  \r\n");
        }
        int index = 0;
        for (int i = 0; i < paramAge.getDaylen() + 1; ++i) {
            index = j + i;
            sum.append(",sum(case when cussent.").append(dateField).append(">=to_date('" + QueryAgeBalance.getFormateDate((java.util.Date)allPhaseDates.get(index * 2)) + "')  and cussent.").append(dateField).append("<to_date('" + QueryAgeBalance.getFormateDate((java.util.Date)allPhaseDates.get(index * 2 + 1)) + "') then " + amountField + " else 0 end) as sum" + index + "  \r\n");
        }
        StringBuffer sumstr = new StringBuffer("\r\n ,sum(SumVeri) SumVeri  \r\n");
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j < paramAge.getUndaylen() + 1; ++j) {
                sumstr.append(",sum(sum" + j + ") as sum" + j);
            }
        } else {
            sumstr.append("\r\n ,sum(SumVeriUnOverDue) SumVeriUnOverDue  \r\n");
        }
        index = 0;
        for (int i = 0; i < paramAge.getDaylen() + 1; ++i) {
            index = j + i;
            sumstr.append(",sum(sum" + index + ") as sum" + index);
        }
        historySql.append("select ").append(paramAge.getSqlSelecthgoutside()).append(accountSum).append(sumstr).append(" from ( \r\n");
        historySql.append("select ").append(paramAge.getSqlSelecthg()).append(accountCol).append(sum).append(paramAge.getSqlFromVerifiedSum_NotInit()).append(" \r\n").append(paramAge.getSqlInnerJoin()).append(" \r\n").append(paramAge.getSqlWhereVerifiedSum_NotInit());
        historySql.append(paramAge.getSqlGroupby()).append(accountGroup).append(" \r\n");
        if (paramAge.isIncludeInit()) {
            historySql.append("\r\n UNION ALL \r\n");
            historySql.append("select ").append(paramAge.getSqlSelecthg()).append(accountCol).append(sum).append(paramAge.getSqlFromVerifiedSum_Init()).append(" \r\n").append(paramAge.getSqlInnerJoin()).append(" \r\n").append(paramAge.getSqlWhereVerifiedSum_Init()).append(" \r\n");
            historySql.append(paramAge.getSqlGroupby()).append(accountGroup);
        }
        historySql.append("\r\n )t  \r\n");
        historySql.append("group by ").append(paramAge.getSqlSelecthgoutside()).append(accountSumGroup).append(" \r\n");
        if (paramAge.isIsOnlyUnion() && !paramAge.isBizCode()) {
            if (paramAge.isAccountList()) {
                historySql.append(" order by T0fnumber,fsumcompanylevel,fsumcompanyname");
            } else {
                historySql.append(" order by hgid,fsumcompanylevel,fsumcompanyname");
            }
        }
        this.getSimulVeriSql(paramAge, sumstr, sum, paramAge.getSqlForSumVerifiedPositive(), ">", accountSum, accountCol, accountGroup, accountSumGroup);
        this.getSimulVeriSql(paramAge, sumstr, sum, paramAge.getSqlForSumVerifiedNegative(), "<", accountSum, accountCol, accountGroup, accountSumGroup);
        return historySql;
    }

    private void getSimulVeriSql(AccountAgeParam paramAge, StringBuffer sumstr, StringBuffer sum, StringBuffer sql, String moreOrless, String accountSum, String accountCol, String accountGroup, String accountSumGroup) {
        sql.append("select ").append(paramAge.getSqlSelecthgoutside()).append(accountSum).append(sumstr).append(" from ( \r\n");
        sql.append("select ").append(paramAge.getSqlSelecthg()).append(accountCol).append(sum).append(paramAge.getSqlFromVerifiedSum_NotInit()).append(" \r\n").append(paramAge.getSqlInnerJoin()).append(" \r\n").append(QueryAgeBalance.getSql_ByBal_VerifiedSum_NotInit_Where(paramAge));
        if (paramAge.isBizCode()) {
            sql.append(" and T_Hgid.bacid = ?");
        } else {
            sql.append(" and cussent.fassgrpid = ?");
        }
        sql.append("  and khis.fcurrencyid = ? and account.fid = ? and ").append(paramAge.getAmountField_veri()).append(moreOrless).append("0.0 ");
        sql.append(paramAge.getSqlGroupby()).append(accountGroup).append(" \r\n");
        if (paramAge.isIncludeInit()) {
            sql.append("\r\n UNION ALL \r\n");
            sql.append("select ").append(paramAge.getSqlSelecthg()).append(accountCol).append(sum).append(paramAge.getSqlFromVerifiedSum_Init()).append(" \r\n").append(paramAge.getSqlInnerJoin()).append(" \r\n").append(QueryAgeBalance.getSql_ByBal_VerifiedSum_Init_Where(paramAge)).append(" \r\n");
            if (paramAge.isBizCode()) {
                sql.append(" and T_Hgid.bacid = ?");
            } else {
                sql.append(" and cussent.fassgrpid = ?");
            }
            sql.append("  and khis.fcurrencyid = ? and account.fid = ? and ").append(paramAge.getAmountField_veri()).append(moreOrless).append("0.0 ");
            sql.append(paramAge.getSqlGroupby()).append(accountGroup);
        }
        sql.append("\r\n )t  \r\n");
        sql.append("group by ").append(paramAge.getSqlSelecthgoutside()).append(accountSumGroup).append(" \r\n");
        if (paramAge.isIsOnlyUnion() && !paramAge.isBizCode()) {
            if (paramAge.isAccountList()) {
                sql.append(" order by T0fnumber,fsumcompanylevel,fsumcompanyname");
            } else {
                sql.append(" order by hgid,fsumcompanylevel,fsumcompanyname");
            }
        }
    }

    public static StringBuffer getSql_ByBal_VerifiedSum_NotInit_Where(AccountAgeParam paramAge) {
        String accountNumberParam;
        StringBuffer whereSumVeri = new StringBuffer();
        whereSumVeri.setLength(0);
        whereSumVeri.append(" where khis.fdc IN (0, 2) AND khis.fvchdate <= ?                        \r\n");
        if (paramAge.getHgid() != null) {
            if (paramAge.isBizCode()) {
                whereSumVeri.append(" and T_Hgid.bacid ='").append(paramAge.getHgid()).append("' ");
            } else {
                whereSumVeri.append(" and cussent.fassgrpid = '").append(paramAge.getHgid()).append("' ");
            }
        }
        if (!paramAge.isIsOnlyUnion()) {
            whereSumVeri.append(" and account.fcompanyid='" + paramAge.getCompanyId() + "'   \r\n");
        } else {
            whereSumVeri.append(" and account.fcompanyid in ( ").append(paramAge.getCompanyId()).append(" )  \r\n");
        }
        whereSumVeri.append(" and account.FAccountTableID='" + paramAge.getAcctTableId() + "'   \r\n");
        if (paramAge.isAccountList()) {
            if (!paramAge.isBizCode()) {
                whereSumVeri.append(" and hg.FID in (" + paramAge.getAccountid() + ")  \r\n");
            }
        } else if (paramAge.getAccountViewNumber() != null && !(accountNumberParam = GLAcctAgeUtils.getNumberForAccountSum((AccountAgeParam)paramAge)).trim().equals("") && accountNumberParam != null) {
            whereSumVeri.append(" and account.Fnumber in (" + accountNumberParam + ")   \r\n");
        }
        if (paramAge.isIsOnlyUnion()) {
            whereSumVeri.append(" \r\n and khis.fcompanyid in ( ").append(paramAge.getCompanyId()).append(" ) ");
            whereSumVeri.append(" \r\n and company.fid in ( ").append(paramAge.getCompanyId()).append(" ) and ");
            if (paramAge.getDisplayMode() == 4 && paramAge.isDisplayLeafCompany()) {
                whereSumVeri.append(" (");
            }
            whereSumVeri.append(" sumcompany");
            if (paramAge.isIsfirstload()) {
                whereSumVeri.append(".fid = ?");
                if (paramAge.getDisplayMode() == 4 && paramAge.isDisplayLeafCompany()) {
                    whereSumVeri.append(" or sumcompany.fisleaf = 1 )");
                }
            } else if (paramAge.getDisplayMode() == 4) {
                whereSumVeri.append(".fisleaf = 1");
            } else {
                whereSumVeri.append(".fparentid = ?");
            }
        } else {
            whereSumVeri.append(" and khis.fcompanyid=?   \r\n");
        }
        whereSumVeri.append(" and voucher.fbookeddate >= ?   \r\n");
        if (!paramAge.isIncludeUnPosted()) {
            whereSumVeri.append(" and voucher.FBizStatus=5  \r\n");
        } else {
            whereSumVeri.append(" and voucher.fbizstatus <> 0 and voucher.fbizstatus<>2   \r\n");
        }
        if (paramAge.isSetCurrency()) {
            whereSumVeri.append(" and khis.fcurrencyid=?   \r\n");
        }
        if (paramAge.isAccountList()) {
            GLAcctAgeUtils.buildAccountSql((StringBuffer)whereSumVeri, (Map)paramAge.getAccountParams(), (String)"account.fnumber");
        }
        whereSumVeri.append("   AND voucher.fbookeddate <=  ?  \r\n");
        return whereSumVeri;
    }

    public static StringBuffer getSql_ByBal_VerifiedSum_Init_Where(AccountAgeParam paramAge) {
        String accountNumberParam;
        StringBuffer whereSumVeri = new StringBuffer();
        whereSumVeri.setLength(0);
        whereSumVeri.append(" where khis.fdc IN (0, 2) AND khis.fvchdate is null                       \r\n");
        if (paramAge.getHgid() != null) {
            if (paramAge.isBizCode()) {
                whereSumVeri.append(" and T_Hgid.bacid ='").append(paramAge.getHgid()).append("' ");
            } else {
                whereSumVeri.append(" and cussent.fassgrpid = '").append(paramAge.getHgid()).append("' ");
            }
        }
        if (!paramAge.isIsOnlyUnion()) {
            whereSumVeri.append(" and account.fcompanyid='" + paramAge.getCompanyId() + "'   \r\n");
        } else {
            whereSumVeri.append(" and account.fcompanyid in ( ").append(paramAge.getCompanyId()).append(" )  \r\n");
        }
        whereSumVeri.append(" and account.FAccountTableID='" + paramAge.getAcctTableId() + "'   \r\n");
        if (paramAge.isAccountList()) {
            if (!paramAge.isBizCode()) {
                whereSumVeri.append(" and hg.FID in (" + paramAge.getAccountid() + ")  \r\n");
            }
        } else if (paramAge.getAccountViewNumber() != null && !(accountNumberParam = GLAcctAgeUtils.getNumberForAccountSum((AccountAgeParam)paramAge)).trim().equals("") && accountNumberParam != null) {
            whereSumVeri.append(" and account.Fnumber in (" + accountNumberParam + ")   \r\n");
        }
        if (paramAge.isIsOnlyUnion()) {
            whereSumVeri.append(" \r\n and khis.fcompanyid in ( ").append(paramAge.getCompanyId()).append(" ) ");
            whereSumVeri.append(" \r\n and company.fid in ( ").append(paramAge.getCompanyId()).append(" ) and ");
            if (paramAge.getDisplayMode() == 4 && paramAge.isDisplayLeafCompany()) {
                whereSumVeri.append(" (");
            }
            whereSumVeri.append(" sumcompany");
            if (paramAge.isIsfirstload()) {
                whereSumVeri.append(".fid = ?");
                if (paramAge.getDisplayMode() == 4 && paramAge.isDisplayLeafCompany()) {
                    whereSumVeri.append(" or sumcompany.fisleaf = 1 )");
                }
            } else if (paramAge.getDisplayMode() == 4) {
                whereSumVeri.append(".fisleaf = 1");
            } else {
                whereSumVeri.append(".fparentid = ?");
            }
        } else {
            whereSumVeri.append(" and khis.fcompanyid=?   \r\n");
        }
        if (paramAge.isSetCurrency()) {
            whereSumVeri.append(" and khis.fcurrencyid=?   \r\n");
        }
        if (paramAge.isAccountList()) {
            GLAcctAgeUtils.buildAccountSql((StringBuffer)whereSumVeri, (Map)paramAge.getAccountParams(), (String)"account.fnumber");
        }
        whereSumVeri.append(" and voucher.fbookeddate <= ?     \r\n");
        return whereSumVeri;
    }

    private void createTempTable4SumVerified(AccountAgeParam paramAge) throws BOSException, EASBizException {
        int j;
        StringBuffer sql = new StringBuffer();
        sql.append("(");
        sql.append(paramAge.getSqlCreateHgTbl());
        sql.append("acctId varchar(44) not null, acctNumber nvarchar(80) not null,");
        sql.append("SumVeri numeric(28,10) not null default 0 ");
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j < paramAge.getUndaylen() + 1; ++j) {
                sql.append(",sum" + j + " numeric(28,10) not null default 0");
            }
        } else {
            sql.append(",SumVeriUnOverDue numeric(28,10) not null default 0 ");
        }
        int index = 0;
        for (int i = 0; i < paramAge.getDaylen() + 1; ++i) {
            index = j + i;
            sql.append(",sum" + index + " numeric(28,10) not null default 0");
        }
        sql.append(")");
        String tempTable = GLAcctAgeUtils.createTempTableByDDL((Context)paramAge.getCtx(), (String)"gl_act_age", (StringBuffer)sql);
        paramAge.setTempTableSumVerified(tempTable);
    }

    private void insertIntoTempTable_ByBal_SumVeri(AccountAgeParam paramAge, Connection con, StringBuffer sqlSumVeri) throws SQLException {
        int j;
        PreparedStatement ps = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer accountSb = new StringBuffer(",acctId, acctNumber");
        sql.append("Insert Into ").append(paramAge.getTempTableSumVeri()).append("\r\n (").append(paramAge.getSqlSelecthgoutside()).append(accountSb).append(",SumVeri \r\n");
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j < paramAge.getUndaylen() + 1; ++j) {
                sql.append(",sum" + j);
            }
        } else {
            sql.append(",SumVeriUnOverDue \r\n");
        }
        int index = 0;
        for (int i = 0; i < paramAge.getDaylen() + 1; ++i) {
            index = j + i;
            sql.append(",sum" + index);
        }
        sql.append(") ");
        sql.append(sqlSumVeri);
        ps = con.prepareStatement(sql.toString());
        index = 1;
        String companyID = paramAge.getCurCompanyid();
        if (paramAge.getDisplayMode() == 4 && !paramAge.isDisplayLeafCompany() && !paramAge.isIsfirstload()) {
            paramAge.setCurCompanyid(null);
        }
        index = QueryAgeBalance.setupParams_ByBal_InsertSumVeri(paramAge, ps, index, false);
        paramAge.setCurCompanyid(companyID);
        DbUtil.execute((Context)paramAge.getCtx(), (PreparedStatement)ps);
    }

    public static int setupParams_ByBal_InsertSumVeri(AccountAgeParam paramAge, PreparedStatement ps, int index, boolean isInit) throws SQLException {
        for (String number : paramAge.getAlAstNumbers()) {
            ps.setString(index++, number);
        }
        Calendar cal = Calendar.getInstance();
        if (!isInit) {
            cal.setTime(paramAge.getHistoryDate());
            ps.setDate(index++, new Date(cal.getTimeInMillis()));
        }
        if (paramAge.isAccountList() || paramAge.getAccountViewNumber() != null || paramAge.getAccountid() != null) {
            // empty if block
        }
        if (!StringUtils.isEmpty((String)paramAge.getCurCompanyid())) {
            ps.setString(index++, paramAge.getCurCompanyid());
        }
        if (!isInit && paramAge.getLastPhaseBeginDate() != null) {
            cal.setTime(paramAge.getLastPhaseBeginDate());
            ps.setDate(index++, new Date(cal.getTimeInMillis()));
        }
        if (paramAge.isSetCurrency()) {
            ps.setString(index++, paramAge.getCurrencyid());
        }
        if (paramAge.isAccountList()) {
            if (!StringUtils.isEmpty((String)paramAge.getAccountFromNumber())) {
                ps.setString(index++, paramAge.getAccountFromNumber());
            }
            if (!StringUtils.isEmpty((String)paramAge.getAccountToNumber())) {
                ps.setString(index++, paramAge.getAccountToNumber() + "zzzzzz");
            }
        }
        return index;
    }

    private StringBuffer getSql_ByBal_AcVeriSum(AccountAgeParam paramAge) {
        int j;
        String dateField = paramAge.getStrDateType_AC();
        if (!dateField.equalsIgnoreCase("fenddate")) {
            dateField = "fbizDate";
        }
        StringBuffer sql = new StringBuffer();
        StringBuffer accountSb = new StringBuffer(" account.fid as acctId, account.fnumber as acctNumber,");
        StringBuffer accountGroupBy = new StringBuffer(",account.fid, account.fnumber ");
        StringBuffer sum = new StringBuffer(" isnull(sum(").append(paramAge.getAmountField_veri()).append("),0) SumVeri  \r\n");
        ArrayList allPhaseDates = GLAcctAgeUtils.getAllPhaseDates((AccountAgeParam)paramAge);
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j < paramAge.getUndaylen() + 1; ++j) {
                if (j == 0) {
                    sum.append(",sum(case when cussent.").append(dateField).append(">=to_date('" + QueryAgeBalance.getFormateDate((java.util.Date)allPhaseDates.get(j * 2)) + "')  and cussent.").append(dateField).append("<=to_date('" + QueryAgeBalance.getFormateDate((java.util.Date)allPhaseDates.get(j * 2 + 1)) + "') then " + paramAge.getAmountField_veri() + " else 0 end) as sum" + j + "  \r\n");
                    continue;
                }
                sum.append(",sum(case when cussent.").append(dateField).append(">to_date('" + QueryAgeBalance.getFormateDate((java.util.Date)allPhaseDates.get(j * 2)) + "')  and cussent.").append(dateField).append("<=to_date('" + QueryAgeBalance.getFormateDate((java.util.Date)allPhaseDates.get(j * 2 + 1)) + "') then " + paramAge.getAmountField_veri() + " else 0 end) as sum" + j + "  \r\n");
            }
        } else {
            sum.append(",sum(CASE WHEN cussent.").append(dateField).append(" >= to_date('" + QueryAgeBalance.getFormateDate(paramAge.getEndDate()) + "') THEN " + paramAge.getAmountField_veri() + " ELSE 0 END) AS SumVeriUnOverDue   \r\n");
        }
        int index = 0;
        for (int i = 0; i < paramAge.getDaylen() + 1; ++i) {
            index = j + i;
            sum.append(",sum(case when cussent.").append(dateField).append(">=to_date('" + QueryAgeBalance.getFormateDate((java.util.Date)allPhaseDates.get(index * 2)) + "') and cussent.").append(dateField).append("<to_date('" + QueryAgeBalance.getFormateDate((java.util.Date)allPhaseDates.get(index * 2 + 1)) + "') then " + paramAge.getAmountField_veri() + " else 0 end) as sum" + index + "  \r\n");
        }
        GLAcctAgeUtils.getSql_ByBal_AcVeriSum_From((AccountAgeParam)paramAge);
        GLAcctAgeUtils.getSql_ByBal_AcVeriSum_Where((AccountAgeParam)paramAge);
        StringBuffer sqlForSumVeriWhere = this.getSql_ByBal_AcVeriSum_Where(paramAge);
        sql.append("select ").append(paramAge.getSqlSelecthg()).append(accountSb).append(sum).append(paramAge.getSqlFromVeriSum()).append(paramAge.getSqlInnerJoin()).append(sqlForSumVeriWhere).append(paramAge.getSqlGroupby()).append(accountGroupBy);
        if (paramAge.isIsOnlyUnion() && !paramAge.isBizCode()) {
            if (paramAge.isAccountList()) {
                sql.append(" order by T0fnumber,fsumcompanylevel,fsumcompanyname");
            } else {
                sql.append(" order by hgid,fsumcompanylevel,fsumcompanyname");
            }
        }
        StringBuffer sqlForSumVeriPositive = paramAge.getSqlForSumVeriPositive();
        sqlForSumVeriPositive.append("select ").append(paramAge.getSqlSelecthg()).append(accountSb).append(sum).append(paramAge.getSqlFromVeriSum()).append(paramAge.getSqlInnerJoin()).append(sqlForSumVeriWhere);
        if (paramAge.isBizCode()) {
            sqlForSumVeriPositive.append(" and T_Hgid.bacid = ?");
        } else {
            sqlForSumVeriPositive.append(" and cussent.fassgrpid = ?");
        }
        sqlForSumVeriPositive.append(" and entry.fcurrencyid = ? and entry.faccountid = ? and ").append(paramAge.getAmountField_veri()).append(">0.0 ").append(paramAge.getSqlGroupby()).append(accountGroupBy);
        if (paramAge.isIsOnlyUnion() && !paramAge.isBizCode()) {
            if (paramAge.isAccountList()) {
                sqlForSumVeriPositive.append(" order by T0fnumber,fsumcompanylevel,fsumcompanyname");
            } else {
                sqlForSumVeriPositive.append(" order by hgid,fsumcompanylevel,fsumcompanyname");
            }
        }
        StringBuffer sqlForSumVeriNegative = paramAge.getSqlForSumVeriNegative();
        sqlForSumVeriNegative.append("select ").append(paramAge.getSqlSelecthg()).append(accountSb).append(sum).append(paramAge.getSqlFromVeriSum()).append(paramAge.getSqlInnerJoin()).append(sqlForSumVeriWhere);
        if (paramAge.isBizCode()) {
            sqlForSumVeriNegative.append(" and T_Hgid.bacid = ?");
        } else {
            sqlForSumVeriNegative.append(" and cussent.fassgrpid = ?");
        }
        sqlForSumVeriNegative.append(" and entry.fcurrencyid = ? and entry.faccountid = ? and ").append(paramAge.getAmountField_veri()).append("<0.0 ").append(paramAge.getSqlGroupby()).append(accountGroupBy);
        if (paramAge.isIsOnlyUnion() && !paramAge.isBizCode()) {
            if (paramAge.isAccountList()) {
                sqlForSumVeriNegative.append(" order by T0fnumber,fsumcompanylevel,fsumcompanyname");
            } else {
                sqlForSumVeriNegative.append(" order by hgid,fsumcompanylevel,fsumcompanyname");
            }
        }
        return sql;
    }

    public StringBuffer getSql_ByBal_AcVeriSum_Where(AccountAgeParam paramAge) {
        String accountNumberParam;
        StringBuffer whereSumVeri = new StringBuffer();
        whereSumVeri.append(" where voucher.fbookeddate <= ?   \r\n");
        if (paramAge.getHgid() != null) {
            if (paramAge.isBizCode()) {
                whereSumVeri.append(" and T_Hgid.bacid ='").append(paramAge.getHgid()).append("' ");
            } else {
                whereSumVeri.append(" and cussent.fassgrpid = '").append(paramAge.getHgid()).append("' ");
            }
        }
        if (!paramAge.isIsOnlyUnion()) {
            whereSumVeri.append(" and account.fcompanyid='" + paramAge.getCompanyId() + "'   \r\n");
        } else {
            whereSumVeri.append(" and account.fcompanyid in ( ").append(paramAge.getCompanyId()).append(" )  \r\n");
        }
        whereSumVeri.append(" and account.FAccountTableID='" + paramAge.getAcctTableId() + "'   \r\n");
        if (!StringUtils.isEmpty((String)paramAge.getAccountid())) {
            whereSumVeri.append(" and account.fid in(" + paramAge.getAccountid() + ")");
        }
        whereSumVeri.append(" and account.FAC = 1   \r\n");
        if (paramAge.isAccountList()) {
            if (!paramAge.isBizCode()) {
                whereSumVeri.append(" and hg.FID in (" + paramAge.getAccountid() + ")  \r\n");
            }
        } else if (paramAge.getAccountViewNumber() != null && !(accountNumberParam = GLAcctAgeUtils.getNumberForAccountSum((AccountAgeParam)paramAge)).trim().equals("") && accountNumberParam != null) {
            whereSumVeri.append(" and account.Fnumber in (" + accountNumberParam + ")   \r\n");
        }
        if (paramAge.isIsOnlyUnion()) {
            whereSumVeri.append(" \r\n and voucher.fcompanyid in ( ").append(paramAge.getCompanyId()).append(" ) ");
            whereSumVeri.append(" \r\n and company.fid in ( ").append(paramAge.getCompanyId()).append(" ) and ");
            if (paramAge.getDisplayMode() == 4 && paramAge.isDisplayLeafCompany()) {
                whereSumVeri.append(" (");
            }
            whereSumVeri.append(" sumcompany");
            if (paramAge.isIsfirstload()) {
                whereSumVeri.append(".fid = ?");
                if (paramAge.getDisplayMode() == 4 && paramAge.isDisplayLeafCompany()) {
                    whereSumVeri.append(" or sumcompany.fisleaf = 1 )");
                }
            } else if (paramAge.getDisplayMode() == 4) {
                whereSumVeri.append(".fisleaf = 1");
            } else {
                whereSumVeri.append(".fparentid = ?");
            }
        } else {
            whereSumVeri.append(" and voucher.fcompanyid=?   \r\n");
        }
        if (paramAge.isIsOnlyUnion()) {
            whereSumVeri.append(" and voucher.fperiodid in (select fperiodid from v_gl_acperiod where fcompanyid=voucher.fcompanyid) \r\n");
        }
        whereSumVeri.append(" and voucher.fbookeddate >= ?   \r\n");
        if (!paramAge.isIncludeUnPosted() && paramAge.isIncludeVerifyVch()) {
            whereSumVeri.append(" and voucher.FBizStatus=5  \r\n");
        } else {
            whereSumVeri.append(" and voucher.fbizstatus <> 0 and voucher.fbizstatus<>2   \r\n");
        }
        if (paramAge.isSetCurrency()) {
            whereSumVeri.append(" and entry.fcurrencyid=?   \r\n");
        }
        if (paramAge.isAccountList()) {
            GLAcctAgeUtils.buildAccountSql((StringBuffer)whereSumVeri, (Map)paramAge.getAccountParams(), (String)"account.fnumber");
        }
        whereSumVeri.append("  \r\n and ((entry.fentrydc * 2) - 1) <> account.fdc  \r\n");
        return whereSumVeri;
    }

    private static String getFormateDate(java.util.Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(date);
    }

    private void createTempTable4SumVerify(AccountAgeParam paramAge) throws BOSException, EASBizException {
        int j;
        StringBuffer sql = new StringBuffer();
        sql.append("(");
        sql.append(paramAge.getSqlCreateHgTbl());
        sql.append("acctId varchar(44) not null, acctNumber nvarchar(80) not null,");
        sql.append("SumVeri numeric(28,10) not null default 0");
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j < paramAge.getUndaylen() + 1; ++j) {
                sql.append(",sum" + j + " numeric(28,10) not null default 0");
            }
        } else {
            sql.append(",SumVeriUnOverDue numeric(28,10) not null default 0");
        }
        int index = 0;
        for (int i = 0; i < paramAge.getDaylen() + 1; ++i) {
            index = j + i;
            sql.append(",sum" + index + " numeric(28,10) not null default 0");
        }
        sql.append(")");
        String tempTable = GLAcctAgeUtils.createTempTableByDDL((Context)paramAge.getCtx(), (String)"gl_act_age", (StringBuffer)sql);
        paramAge.setTempTableSumVeri(tempTable);
    }

    private StringBuffer getSql_ByAcctBal_InsertAcTempUnion(AccountAgeParam paramAge, StringBuffer sql0InsertAcTemp, StringBuffer sql1NotInit, StringBuffer sql2Init, StringBuffer sql5HistorySql) {
        int i;
        int j;
        StringBuffer merge = new StringBuffer();
        merge.append(sql0InsertAcTemp);
        StringBuffer sum = new StringBuffer();
        StringBuffer orderby = new StringBuffer();
        sum.append("acctId,acctNumber,");
        sum.append("isnull(sum(sumunoverdue),0) as sumunoverdue ");
        String _whereCause = "t.sum0";
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j < paramAge.getUndaylen() + 1; ++j) {
                sum.append(",isnull(sum(sum" + j + "),0) as sum" + j);
                if (j == 0) continue;
                _whereCause = _whereCause + "+t.sum" + j;
            }
        }
        int index = 0;
        for (i = 0; i < paramAge.getDaylen() + 1; ++i) {
            index = i + j;
            sum.append(",isnull(sum(sum" + index + "),0) as sum" + index);
            if (i == 0) continue;
            _whereCause = _whereCause + "+t.sum" + index;
        }
        for (i = 0; i < paramAge.getAlAstTables().size(); ++i) {
            String numkey = "T" + i + "fnumber";
            String namekey = "T" + i + "fname";
            if (paramAge.isAccountList() && i != 0) continue;
            orderby.append(numkey).append(",");
        }
        merge.append("\r\n select ").append(paramAge.getSqlSelecthgoutside()).append(",").append(sum).append("\r\n from (\r\n").append(sql1NotInit);
        if (paramAge.isIncludeInit()) {
            merge.append("\r\n union all \r\n").append(sql2Init);
        }
        merge.append(sql5HistorySql);
        merge.append("\r\n ) t   group by " + paramAge.getSqlSelecthgoutside() + ",acctId,acctNumber ");
        orderby = new StringBuffer("\r\n order by ").append(orderby);
        orderby.append(" fcurrid,fcurrname");
        if (paramAge.isAccountList() || paramAge.isAllCurr()) {
            merge.append(orderby);
        }
        paramAge.setSqlOrderby(orderby);
        return merge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer getHistorySql4NotInTime(Connection con, AccountAgeParam paramAge) throws BOSException, EASBizException {
        String querySql;
        int j;
        StringBuffer historySql = new StringBuffer();
        String tempTableHistory = this.createTempTable4QueryHistory(paramAge);
        String tempTable4SumPhase = this.createTempTable4SumPhase(paramAge);
        String tempTableHistory2 = this.createTempTable4QueryHistory(paramAge);
        String selectHgString = paramAge.getSqlSelecthg().substring(0, paramAge.getSqlSelecthg().length() - 1);
        String sql = "";
        String amountField = null;
        amountField = "khis.FOroginalAmount";
        String sumstr = "";
        sumstr = sumstr + "account.fid as acctId, account.fnumber as acctNumber,";
        sumstr = sumstr + "0 as sumUnOverDue,";
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j <= paramAge.getUndaylen(); ++j) {
                sumstr = sumstr + "0 sum" + j + ",";
            }
        }
        int index = 0;
        for (int i = 0; i <= paramAge.getDaylen(); ++i) {
            index = i + j;
            sumstr = sumstr + "0 sum" + index + ",";
        }
        String tSql = querySql = "insert into " + tempTableHistory + "\r\n SELECT distinct cussent.fid fcussentid,1 fdc," + sumstr + selectHgString + paramAge.getSqlFromTable() + paramAge.getSqlInnerJoin() + paramAge.getSqlWhereNotInit();
        String querySqlNew = null;
        if (!paramAge.isIsOnlyUnion()) {
            StringBuffer fromInner = new StringBuffer();
            fromInner.append(" \r\n inner join t_bd_accountview account on account.fid=cussent.faccountid \r\n");
            if (paramAge.isAllCurr() || paramAge.isGeneralCy()) {
                fromInner.append(" \r\n inner join t_bd_Currency currency on cussent.fcurrencyid=currency.fid");
            }
            if (paramAge.isJoinHgTable()) {
                fromInner.append(" \r\n inner join t_bd_assistanthg hg on cussent.fassgrpid=hg.fid \r\n");
            }
            if (paramAge.getSqlBizCodeHgid().length() > 0) {
                fromInner.append("\r\n inner join ").append(paramAge.getSqlBizCodeHgid()).append(" on hg.fid = T_Hgid.fid ");
            }
            String sqlInnerJoin = paramAge.getSqlInnerJoin().toString();
            for (String number : paramAge.getAlAstNumbers()) {
                sqlInnerJoin = sqlInnerJoin.replaceFirst("\\?", "'" + number + "'");
            }
            tSql = querySqlNew = "insert into " + tempTableHistory + "\r\n  SELECT cussent.fid fcussentid,1 fdc," + sumstr + selectHgString + " \r\n  FROM t_gl_acctcussent cussent \r\n" + fromInner + sqlInnerJoin + QueryAgeBalance.getSqlWhereNotInit(paramAge);
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        boolean isDbTypeOracleDB2 = GLAcctAgeUtils.checkDbTypeIsOracleDB2((Context)paramAge.getCtx());
        try {
            int i;
            ps = con.prepareStatement(tSql);
            Calendar hiscal = Calendar.getInstance();
            hiscal.setTime(paramAge.getHistoryDate());
            if (paramAge.isIsOnlyUnion()) {
                QueryAgeBalance.setupParams_ByAcctBal_InsertSum(true, false, paramAge.getAccountid(), paramAge, hiscal.getTime(), new ArrayList(), ps, new ArrayList(), 1, null, new SqlParams(), paramAge.getLastPhaseBeginDate());
            } else {
                GLAcctAgeUtils.setupParams_ByAcctBal_InsertSum((boolean)false, (boolean)false, null, (AccountAgeParam)paramAge, (java.util.Date)hiscal.getTime(), new ArrayList(), (PreparedStatement)con.prepareStatement(querySql), new ArrayList(), (int)1, null, (SqlParams)new SqlParams(), (java.util.Date)paramAge.getLastPhaseBeginDate());
            }
            DbUtil.execute((Context)paramAge.getCtx(), (PreparedStatement)ps);
            Statement psIndex = null;
            try {
                StringBuffer indexSql = new StringBuffer("create index C").append(tempTableHistory).append(" on ").append(tempTableHistory).append("(").append("fcussentid").append(") ");
                psIndex = con.prepareStatement(indexSql.toString());
                psIndex.execute();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (psIndex != null) {
                        psIndex.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            querySql = "insert into " + tempTableHistory + "\r\n SELECT distinct cussent.fid fcussentid,1 fdc," + sumstr + selectHgString + paramAge.getSqlFromInit() + paramAge.getSqlInnerJoin() + paramAge.getSqlWhereInit();
            ps = con.prepareStatement(querySql);
            if (paramAge.isIsOnlyUnion()) {
                QueryAgeBalance.setupParams_ByAcctBal_InsertSum(true, true, paramAge.getAccountid(), paramAge, hiscal.getTime(), new ArrayList(), ps, new ArrayList(), 1, null, new SqlParams(), null);
            } else {
                GLAcctAgeUtils.setupParams_ByAcctBal_InsertSum((boolean)false, (boolean)true, null, (AccountAgeParam)paramAge, (java.util.Date)hiscal.getTime(), new ArrayList(), (PreparedStatement)ps, new ArrayList(), (int)1, null, (SqlParams)new SqlParams(), null);
            }
            DbUtil.execute((Context)paramAge.getCtx(), (PreparedStatement)ps);
            Calendar _cal = Calendar.getInstance();
            _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)paramAge.getHistoryDate()));
            Date _dayIndex = new Date(_cal.getTimeInMillis());
            Date _day1 = null;
            Date _day2 = new Date(_cal.getTime().getTime());
            java.util.Date endDate = paramAge.getEndDate();
            StringBuffer sqlSumUnion = new StringBuffer();
            sqlSumUnion.append("select \r\n");
            index = 0;
            if (paramAge.isShowUmexpired()) {
                for (j = 0; j <= paramAge.getUndaylen(); ++j) {
                    _cal = Calendar.getInstance();
                    if (j == 0) {
                        _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
                        _day1 = new Date(_cal.getTime().getTime());
                        _cal.add(5, -1 * paramAge.getUndays()[0]);
                        _day2 = new Date(_cal.getTime().getTime());
                        sqlSumUnion.append("sum(case when ac." + paramAge.getStrDateType_AC() + " >= to_date('" + QueryAgeBalance.getFormateDate(_day1) + "')  and ac." + paramAge.getStrDateType_AC() + " <= to_date('" + QueryAgeBalance.getFormateDate(_day2) + "')  then " + amountField + " else 0 end) as sum" + j + ", \r\n");
                        continue;
                    }
                    if (j == paramAge.getDaylen()) {
                        _cal.set(2949, 0, 1);
                        _day2 = new Date(_cal.getTime().getTime());
                        _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
                        _cal.add(5, -1 * paramAge.getUndays()[j - 1]);
                        _day1 = new Date(_cal.getTime().getTime());
                        sqlSumUnion.append("sum(case when ac." + paramAge.getStrDateType_AC() + " > to_date('" + QueryAgeBalance.getFormateDate(_day1) + "')  and ac." + paramAge.getStrDateType_AC() + " <= to_date('" + QueryAgeBalance.getFormateDate(_day2) + "')  then " + amountField + " else 0 end) as sum" + j + ", \r\n");
                        continue;
                    }
                    _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
                    _cal.add(5, -1 * paramAge.getUndays()[j - 1]);
                    _day1 = new Date(_cal.getTime().getTime());
                    _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
                    if (j < paramAge.getUndays().length) {
                        _cal.add(5, -1 * paramAge.getUndays()[j]);
                        _day2 = new Date(_cal.getTime().getTime());
                    }
                    sqlSumUnion.append("sum(case when ac." + paramAge.getStrDateType_AC() + " > to_date('" + QueryAgeBalance.getFormateDate(_day1) + "')  and ac." + paramAge.getStrDateType_AC() + " <= to_date('" + QueryAgeBalance.getFormateDate(_day2) + "')  then " + amountField + " else 0 end) as sum" + j + ", \r\n");
                }
            }
            for (i = 0; i <= paramAge.getDaylen(); ++i) {
                index = i + j;
                _cal = Calendar.getInstance();
                if (i == 0) {
                    _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
                    _cal.add(5, -1 * paramAge.getDays()[0]);
                    _day1 = new Date(_cal.getTime().getTime());
                    _day2 = new Date(DateTimeUtils.truncateDate((java.util.Date)endDate).getTime());
                } else if (i == paramAge.getDaylen()) {
                    _cal.set(1900, 0, 1);
                    _day1 = new Date(_cal.getTime().getTime());
                    _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
                    _cal.add(5, -1 * paramAge.getDays()[i - 1]);
                    _day2 = new Date(_cal.getTime().getTime());
                } else {
                    _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
                    _cal.add(5, -1 * paramAge.getDays()[i]);
                    _day1 = new Date(_cal.getTime().getTime());
                    _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
                    _cal.add(5, -1 * paramAge.getDays()[i - 1]);
                    _day2 = new Date(_cal.getTime().getTime());
                }
                sqlSumUnion.append("sum(case when ac." + paramAge.getStrDateType_AC() + " >= to_date('" + QueryAgeBalance.getFormateDate(_day1) + "')  and ac." + paramAge.getStrDateType_AC() + " < to_date('" + QueryAgeBalance.getFormateDate(_day2) + "')  then " + amountField + " else 0 end) as sum" + index + ", \r\n");
            }
            _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
            _day1 = new Date(_cal.getTime().getTime());
            _cal.add(1, 100);
            _day2 = new Date(_cal.getTime().getTime());
            sqlSumUnion.append("sum(case when ac." + paramAge.getStrDateType_AC() + " >= to_date('" + QueryAgeBalance.getFormateDate(_day1) + "')  and ac." + paramAge.getStrDateType_AC() + " < to_date('" + QueryAgeBalance.getFormateDate(_day2) + "')  then " + amountField + " else 0 end) as sumunoverdue, \r\n");
            sqlSumUnion.append("khis.fcussentidid as fcussentidid \r\n");
            sqlSumUnion.append(" from t_gl_acctcussenthistory khis INNER JOIN t_gl_acctcussent ac ON khis.FCussentidID = ac.fid AND khis.fcompanyid = ac.fcompanyid \r\n");
            sqlSumUnion.append(" inner join " + tempTableHistory + " tmp on tmp.fcussentid = khis.FCussentidID \r\n");
            if (!paramAge.isIsOnlyUnion() && paramAge.isBizCode() && paramAge.isAccountList()) {
                sqlSumUnion.append(" inner join t_bd_assistanthg hg\ton ac.fassgrpid = hg.fid \r\n");
                sqlSumUnion.append(" inner join ").append(paramAge.getSqlBizCodeHgid()).append(" on hg.fid = T_Hgid.fid ");
            }
            if (paramAge.isSetCurrency()) {
                sqlSumUnion.append(" where ac.fcurrencyid = '" + paramAge.getCurrencyid() + "' \r\n");
            }
            if (!paramAge.isIsOnlyUnion() && paramAge.getAccountid() != null) {
                if (paramAge.isAccountList()) {
                    if (paramAge.isBizCode() && !paramAge.isIsOnlyUnion()) {
                        String accountid = paramAge.getAccountid();
                        String[] accountids = accountid == null ? null : accountid.split(",");
                        String id = "";
                        String curCuid = paramAge.getCompany().getCU().getId().toString();
                        if (accountids != null) {
                            for (int i2 = 0; i2 < accountids.length; ++i2) {
                                id = id + "'" + accountids[i2] + "',";
                            }
                            id = id.substring(0, id.length() - 1);
                        }
                        sqlSumUnion.append(" and T_Hgid.bacid in (" + id + ") \r\n");
                    } else {
                        sqlSumUnion.append(" and ac.fassgrpid in (" + paramAge.getAccountid() + ") \r\n");
                    }
                } else {
                    sqlSumUnion.append(" and ac.faccountid in (" + paramAge.getAccountid() + ") \r\n");
                }
            }
            sqlSumUnion.append(" and ac." + paramAge.getStrDateType_AC() + " is not null \r\n");
            if (!paramAge.isIsOnlyUnion()) {
                sqlSumUnion.append(" and ac.fcompanyid = '" + paramAge.getCompanyId() + "' \r\n");
                sqlSumUnion.append(" and khis.fcompanyid = '" + paramAge.getCompanyId() + "' \r\n");
            } else {
                sqlSumUnion.append(" and ac.fcompanyid in ( ").append(paramAge.getCompanyId()).append(" )  \r\n");
                sqlSumUnion.append(" and khis.fcompanyid in ( ").append(paramAge.getCompanyId()).append(" )  \r\n");
            }
            sqlSumUnion.append(" and ((khis.fdc IN (0, 2) AND EXISTS \r\n");
            sqlSumUnion.append(" (select 1 from t_gl_voucher voucher \r\n");
            sqlSumUnion.append(" where khis.fverivchid = voucher.fid \r\n");
            sqlSumUnion.append(" and voucher.fbookeddate > to_date('" + QueryAgeBalance.getFormateDate(_dayIndex) + "') " + paramAge.getSqlWhereHistoryVeriVchBizstas() + ")) \r\n");
            sqlSumUnion.append(" OR (khis.fdc = 1 AND EXISTS \r\n");
            sqlSumUnion.append(" (select 1 from t_gl_acctcussenthistory k2 \r\n");
            sqlSumUnion.append(" where k2.fvoucherasstidid = khis.fcussentidid \r\n");
            sqlSumUnion.append(" and k2.fcussentidid = khis.fvoucherasstidid and k2.fvchdate > to_date('" + QueryAgeBalance.getFormateDate(_dayIndex) + "'))))\r\n");
            sqlSumUnion.append(" group by khis.fcussentidid");
            if (paramAge.getDisplayMode() == 4 && paramAge.isDisplayLeafCompany()) {
                sqlSumUnion.append(",tmp.fsumcompanyid");
            }
            sql = "insert into " + tempTable4SumPhase + " select ";
            if (paramAge.getDisplayMode() == 4 && paramAge.isDisplayLeafCompany()) {
                sql = sql + " distinct ";
            }
            sql = sql + this.getSumi("t.", "", index, 0) + ", sumunoverdue,t.fcussentidid from (" + sqlSumUnion.toString() + ") t";
            ps = con.prepareStatement(sql);
            DbUtil.execute((Context)paramAge.getCtx(), (PreparedStatement)ps);
            sql = "insert into " + tempTableHistory2 + " select t1.fcussentid, t1.fdc, acctid,acctNumber,isnull(t2.sumunoverdue, 0), " + this.getSumi("isnull(t2.", ", 0)", index, 0) + ", " + this.preAdd(paramAge.getSqlSelecthgoutside().toString(), "t1.") + " from " + tempTableHistory + " t1 left join " + tempTable4SumPhase + " t2 \r\n on t1.fcussentid = t2.fcussentid";
            ps = con.prepareStatement(sql);
            DbUtil.execute((Context)paramAge.getCtx(), (PreparedStatement)ps);
            sumstr = "sumUnOverDue,";
            for (i = 0; i <= index - 1; ++i) {
                sumstr = sumstr + "sum" + i + ",";
            }
            sumstr = sumstr + "sum" + index;
            sumstr = sumstr + ",acctid,acctnumber";
            historySql.append("\r\n union all \r\n SELECT " + (paramAge.getSqlSelecthgoutside().length() > 0 ? paramAge.getSqlSelecthgoutside().toString() + "," : "") + sumstr + " from " + tempTableHistory2);
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            InitHelp.dropTempTable((Context)paramAge.getCtx(), (String)tempTableHistory);
            InitHelp.dropTempTable((Context)paramAge.getCtx(), (String)tempTable4SumPhase);
            SQLUtils.cleanup(rs, (Statement)ps);
        }
        return historySql;
    }

    private String getSumi(String preStr, String nextStr, int len, int type) {
        StringBuffer sumBuffer = new StringBuffer();
        for (int i = 0; i <= len; ++i) {
            if (type == 0) {
                if (i == len) {
                    sumBuffer.append(preStr + "sum" + i + nextStr);
                    continue;
                }
                sumBuffer.append(preStr + "sum" + i + nextStr + ", ");
                continue;
            }
            if (i == len) {
                sumBuffer.append("sum(" + preStr + "sum" + i + ") sum" + i + nextStr);
                continue;
            }
            sumBuffer.append("sum(" + preStr + "sum" + i + ") sum" + i + nextStr + ", ");
        }
        return sumBuffer.toString();
    }

    private String preAdd(String des, String pre) {
        StringBuffer add = new StringBuffer();
        String[] dess = des.trim().split(",");
        int len = dess.length;
        for (int i = 0; i < len; ++i) {
            if (i == len - 1) {
                add.append(pre + dess[i] + " as " + dess[i]);
                continue;
            }
            add.append(pre + dess[i] + " as " + dess[i] + ", ");
        }
        return add.toString();
    }

    private String createTempTable4SumPhase(AccountAgeParam paramAge) throws BOSException, EASBizException {
        int j;
        String tempateTable = TableManagerFacadeFactory.getLocalInstance((Context)paramAge.getCtx()).getTableName("gl_temp");
        StringBuffer createTable = new StringBuffer();
        createTable.append("CREATE TABLE ").append(tempateTable).append("(  \r\n");
        int index = 0;
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j < paramAge.getUndaylen() + 1; ++j) {
                createTable.append("sum" + j + " numeric(28,10) not null default 0, ");
            }
        }
        for (int i = 0; i < paramAge.getDaylen() + 1; ++i) {
            index = j + i;
            createTable.append("sum" + index + " numeric(28,10) not null default 0, ");
        }
        createTable.append("sumunoverdue numeric(28,10) not null default 0, ");
        createTable.append("FCUSSENTID varchar (44) NOT NULL)");
        ITableManagerFacade tableManagerFacade = TableManagerFacadeFactory.getLocalInstance((Context)paramAge.getCtx());
        tableManagerFacade.createTable(createTable.toString());
        return tempateTable;
    }

    private static StringBuffer getSqlWhereNotInit(AccountAgeParam paramAge) {
        StringBuffer whereNotInit = new StringBuffer();
        StringBuffer whereCussent = new StringBuffer();
        StringBuffer wherePeriod = new StringBuffer();
        StringBuffer whereVch = new StringBuffer();
        StringBuffer whereAH = new StringBuffer();
        StringBuffer whereCurr = new StringBuffer();
        StringBuffer whereKhis = new StringBuffer();
        whereNotInit.append(" WHERE \r\n");
        whereCussent.append(" cussent.fisinit<>1   \r\n");
        if (paramAge.isAccountList()) {
            if (paramAge.isBizCode() && !paramAge.isIsOnlyUnion()) {
                String accountid = paramAge.getAccountid();
                String[] accountids = accountid == null ? null : accountid.split(",");
                String id = "";
                String curCuid = paramAge.getCompany().getCU().getId().toString();
                if (accountids != null) {
                    for (int i = 0; i < accountids.length; ++i) {
                        id = id + "'" + accountids[i] + "',";
                    }
                    id = id.substring(0, id.length() - 1);
                }
                whereAH.append(" and T_Hgid.bacid in (" + id + ") \r\n");
            } else {
                whereAH.append(" and hg.FID in (" + paramAge.getAccountid() + ") \r\n");
            }
        } else if (paramAge.getAccountViewNumber() == null) {
            whereAH.append(" and cussent.faccountid in (" + paramAge.getAccountid() + ")   \r\n");
            whereAH.append(" and account.fid in (" + paramAge.getAccountid() + ")   \r\n");
        } else if (paramAge.getIndexType() != 0) {
            whereAH.append(" and account.fcompanyid='" + paramAge.getCompanyId() + "'   \r\n");
            whereAH.append(" and account.FAccountTableID='" + paramAge.getAcctTableId() + "'   \r\n");
            String accountNumberParam = GLAcctAgeUtils.getNumberForAccountSum((AccountAgeParam)paramAge);
            if (!accountNumberParam.trim().equals("") && accountNumberParam != null) {
                whereAH.append(" and account.Fnumber in (" + accountNumberParam + ")   \r\n");
            }
        }
        if (!paramAge.isIsOnlyUnion()) {
            whereCussent.append(" and cussent.fcompanyid='" + paramAge.getCompanyId() + "'  \r\n");
        }
        if (paramAge.isSetCurrency()) {
            whereCussent.append(" and cussent.fcurrencyid='" + paramAge.getCurrencyid() + "'   \r\n");
        }
        wherePeriod.append(" and exists (select 1 from v_gl_acperiod acp where acp.fcompanyid=cussent.fcompanyid and cussent.fperiodid = acp.fperiodid)  \r\n");
        whereVch.append(" and exists (select 1 from t_gl_voucher voucher where cussent.fvoucherid = voucher.fid \r\n");
        if (paramAge.isIncludeVerifyVch()) {
            whereVch.append(" and voucher.fbookeddate >= to_date('" + QueryAgeBalance.getFormateDate(paramAge.getLastPhaseBeginDate()) + "')   \r\n");
        }
        whereVch.append(" and voucher.fbookeddate <= to_date('" + QueryAgeBalance.getFormateDate(paramAge.getHistoryDate()) + "')  \r\n");
        if (!paramAge.isIsOnlyUnion()) {
            whereVch.append(" and voucher.fcompanyid='" + paramAge.getCompanyId() + "'  \r\n");
        }
        if (!paramAge.isIncludeUnPosted()) {
            whereVch.append(" and voucher.FBizStatus=5  \r\n");
        } else {
            whereVch.append(" and voucher.fbizstatus <> 0 and voucher.fbizstatus<>2   \r\n");
        }
        whereVch.append(" )  \r\n");
        whereKhis.append(" and (cussent.funverifiedamtfor <> 0 or exists (\r\n");
        whereKhis.append(" select 1 from t_gl_acctcussenthistory khis where khis.fcussentidid = cussent.fid \r\n");
        whereKhis.append(" and khis.fverifydate > to_date('" + QueryAgeBalance.getFormateDate(paramAge.getHistoryDate()) + "') \r\n");
        whereKhis.append(" and khis.fvchdate <= to_date('" + QueryAgeBalance.getFormateDate(paramAge.getHistoryDate()) + "') \r\n");
        whereKhis.append("\r\n))");
        whereNotInit.append(whereCussent).append(whereAH).append(wherePeriod).append(whereVch).append(whereKhis);
        return whereNotInit;
    }

    public static int setupParams_ByAcctBal_InsertSum(boolean isOnlyUnion, boolean isInitParam, String accountid, AccountAgeParam paramAge, java.util.Date historyDate, ArrayList alDates, PreparedStatement ps, List params, int index, String accountViewNumber, SqlParams spp, java.util.Date lastPhaseBeginDate) throws SQLException {
        String currencyid = paramAge.getCurrencyid();
        String companyid = paramAge.getCompanyId();
        if (paramAge.isIsOnlyUnion()) {
            companyid = paramAge.getCurCompanyid();
        }
        boolean isAccountList = paramAge.isAccountList();
        String accountFromNumber = paramAge.getAccountFromNumber();
        String accountToNumber = paramAge.getAccountToNumber();
        boolean isSetCurrency = paramAge.isSetCurrency();
        ArrayList alAstNumbers = paramAge.getAlAstNumbers();
        for (Date date : alDates) {
            ps.setDate(index++, date);
            spp.setDate(index, date);
            params.add(date);
        }
        for (String number : alAstNumbers) {
            ps.setString(index++, number);
            spp.setString(index, number);
            params.add(number);
        }
        Calendar cal = Calendar.getInstance();
        if (!isInitParam) {
            cal.setTime(historyDate);
            ps.setDate(index++, new Date(cal.getTimeInMillis()));
            spp.setDate(index, new Date(cal.getTimeInMillis()));
            params.add(new Date(cal.getTimeInMillis()));
        }
        if (!paramAge.isIsOnlyUnion() && !isAccountList && StringUtils.isEmpty((String)accountViewNumber) && !StringUtils.isEmpty((String)accountid)) {
            ps.setString(index++, accountid);
            spp.setString(index, accountid);
            params.add(accountid);
        }
        if (!StringUtils.isEmpty((String)companyid)) {
            ps.setString(index++, companyid);
            spp.setString(index, companyid);
            params.add(companyid);
            if (!isOnlyUnion && !isInitParam) {
                ps.setString(index++, companyid);
                spp.setString(index, companyid);
                params.add(companyid);
            }
        }
        if (lastPhaseBeginDate != null) {
            cal.setTime(lastPhaseBeginDate);
            ps.setDate(index++, new Date(cal.getTimeInMillis()));
            spp.setDate(index, new Date(cal.getTimeInMillis()));
            params.add(new Date(cal.getTimeInMillis()));
        }
        if (isSetCurrency) {
            ps.setString(index++, currencyid);
            spp.setString(index, currencyid);
            params.add(currencyid);
        }
        if (isAccountList) {
            if (accountFromNumber != null) {
                ps.setString(index++, accountFromNumber);
                spp.setString(index, accountFromNumber);
                params.add(accountFromNumber);
            }
            if (accountToNumber != null) {
                ps.setString(index++, accountToNumber + "zzzzzz");
                spp.setString(index, accountToNumber + "zzzzzz");
                params.add(accountToNumber + "zzzzzz");
            }
        }
        return index;
    }

    private void setParams_getHistorySql_update(boolean isUnion, boolean isDbTypeOracleDB2, PreparedStatement ps, List lstDates, String companyid) throws SQLException {
        int index = 1;
        Iterator it = null;
        int paramCount = 1;
        if (isDbTypeOracleDB2) {
            // empty if block
        }
        paramCount *= 2;
        ps.setDate(index++, (Date)lstDates.get(0));
        ps.setDate(index++, (Date)lstDates.get(1));
        ps.setDate(index++, (Date)lstDates.get(2));
        ps.setDate(index++, (Date)lstDates.get(3));
        it = lstDates.iterator();
        while (it.hasNext()) {
            ps.setDate(index++, (Date)it.next());
        }
    }

    private String createTempTable4QueryHistory(AccountAgeParam paramAge) throws BOSException, EASBizException {
        int j;
        String tempateTable = TableManagerFacadeFactory.getLocalInstance((Context)paramAge.getCtx()).getTableName("gl_temp");
        StringBuffer createTable = new StringBuffer();
        createTable.append("CREATE TABLE ").append(tempateTable);
        createTable.append("( FCUSSENTID varchar (44) NOT NULL,fdc int");
        createTable.append(", acctId varchar(44) not null, acctNumber nvarchar(80) not null");
        createTable.append(",sumunoverdue numeric(28,10) not null default 0");
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j < paramAge.getUndaylen() + 1; ++j) {
                createTable.append(",sum" + j + " numeric(28,10) not null default 0");
            }
        }
        int index = 0;
        for (int i = 0; i < paramAge.getDaylen() + 1; ++i) {
            index = j + i;
            createTable.append(",sum" + index + " numeric(28,10) not null default 0");
        }
        createTable.append((paramAge.getSqlCreateHgTbl().length() > 0 ? "," + paramAge.getSqlCreateHgTbl().substring(0, paramAge.getSqlCreateHgTbl().length() - 1) : "") + ")");
        ITableManagerFacade tableManagerFacade = TableManagerFacadeFactory.getLocalInstance((Context)paramAge.getCtx());
        tableManagerFacade.createTable(createTable.toString());
        paramAge.setTempTableHistory(tempateTable);
        return tempateTable;
    }

    private StringBuffer getHistorySql4InTime(Connection con, AccountAgeParam paramAge) throws BOSException, EASBizException {
        StringBuffer hisAgeTableSql = new StringBuffer();
        String amountField = null;
        amountField = "his.FOroginalAmount";
        String tempTableHistory = paramAge.getTempTableHistory();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sumstr = "";
            sumstr = sumstr + "0 as sumoro";
            StringBuffer querySql = new StringBuffer();
            querySql.append("insert into ").append(tempTableHistory);
            querySql.append("(fcussentid,SUMORO) SELECT distinct cussent.fid fcussentid,");
            querySql.append(sumstr).append(paramAge.getSqlFromTable());
            querySql.append(paramAge.getSqlInnerJoin());
            querySql.append(paramAge.getSqlWhereNotInit());
            ps = con.prepareStatement(querySql.toString());
            Calendar hiscal = Calendar.getInstance();
            hiscal.setTime(paramAge.getHistoryDate());
            hiscal.add(1, 100);
            if (paramAge.isIsOnlyUnion()) {
                GLAcctAgeUtils.setupParams_ByAcctBal_InsertSum((boolean)true, (boolean)false, (String)paramAge.getAccountid(), (AccountAgeParam)paramAge, (java.util.Date)hiscal.getTime(), new ArrayList(), (PreparedStatement)ps, new ArrayList(), (int)1, null, (SqlParams)new SqlParams(), (java.util.Date)paramAge.getLastPhaseBeginDate());
            } else {
                GLAcctAgeUtils.setupParams_ByAcctBal_InsertSum((boolean)false, (boolean)false, null, (AccountAgeParam)paramAge, (java.util.Date)hiscal.getTime(), new ArrayList(), (PreparedStatement)ps, new ArrayList(), (int)1, null, (SqlParams)new SqlParams(), (java.util.Date)paramAge.getLastPhaseBeginDate());
            }
            DbUtil.execute((Context)paramAge.getCtx(), (PreparedStatement)ps);
            querySql.setLength(0);
            querySql.append("insert into ").append(tempTableHistory);
            querySql.append("(fcussentid,SUMORO) SELECT distinct cussent.fid fcussentid,");
            querySql.append(sumstr).append(paramAge.getSqlFromInit());
            querySql.append(paramAge.getSqlInnerJoin());
            querySql.append(paramAge.getSqlWhereInit());
            ps = con.prepareStatement(querySql.toString());
            if (paramAge.isIsOnlyUnion()) {
                GLAcctAgeUtils.setupParams_ByAcctBal_InsertSum((boolean)true, (boolean)true, (String)paramAge.getAccountid(), (AccountAgeParam)paramAge, (java.util.Date)hiscal.getTime(), new ArrayList(), (PreparedStatement)ps, new ArrayList(), (int)1, null, (SqlParams)new SqlParams(), null);
            } else {
                GLAcctAgeUtils.setupParams_ByAcctBal_InsertSum((boolean)false, (boolean)true, null, (AccountAgeParam)paramAge, (java.util.Date)hiscal.getTime(), new ArrayList(), (PreparedStatement)ps, new ArrayList(), (int)1, null, (SqlParams)new SqlParams(), null);
            }
            DbUtil.execute((Context)paramAge.getCtx(), (PreparedStatement)ps);
            Calendar _cal = Calendar.getInstance();
            _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)paramAge.getHistoryDate()));
            Date _dayIndex = new Date(_cal.getTimeInMillis());
            Object _day1 = null;
            Date _day2 = new Date(_cal.getTime().getTime());
            hisAgeTableSql.append("update ").append(tempTableHistory).append(" tmp \r\n");
            hisAgeTableSql.append("set (sumoro) = \r\n");
            hisAgeTableSql.append("(select sumhis.sumoro from \r\n");
            hisAgeTableSql.append("(select his.FCussentIDID,isnull(sum( \r\n");
            hisAgeTableSql.append(amountField);
            hisAgeTableSql.append("),0) as sumoro \r\n");
            hisAgeTableSql.append("from t_gl_acctcussenthistory his  \r\n");
            hisAgeTableSql.append("inner join t_gl_voucher voucher on his.FVeriVchID=voucher.FID  \r\n");
            hisAgeTableSql.append("where 1=1  \r\n");
            if (!paramAge.isIsOnlyUnion()) {
                hisAgeTableSql.append(" and his.fcompanyid = ?  \r\n");
            } else {
                hisAgeTableSql.append(" and his.fcompanyid in ( ").append(paramAge.getCompanyId()).append(" )  \r\n");
            }
            hisAgeTableSql.append(" and voucher.FBookedDate>? ");
            if (!paramAge.isIncludeUnPosted()) {
                hisAgeTableSql.append(" and voucher.FBizStatus=5 ");
            } else {
                hisAgeTableSql.append(" and voucher.fbizstatus <> 0 and voucher.fbizstatus<>2 ");
            }
            hisAgeTableSql.append("\r\n group by his.fcussentidid  \r\n");
            hisAgeTableSql.append(") sumhis ");
            hisAgeTableSql.append("where sumhis.FCussentIDID=tmp.fcussentid  \r\n");
            hisAgeTableSql.append(")  \r\n");
            ps = con.prepareStatement(hisAgeTableSql.toString());
            int index = 1;
            if (!paramAge.isIsOnlyUnion()) {
                ps.setString(index++, paramAge.getCompanyId());
            }
            ps.setDate(index++, _dayIndex);
            DbUtil.execute((Context)paramAge.getCtx(), (PreparedStatement)ps);
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)ps);
        return new StringBuffer();
    }

    private StringBuffer getSql_ByAcctBal_AcInit(AccountAgeParam paramAge) {
        StringBuffer sql = new StringBuffer();
        this.getSql_ByAcctBal_AcInit_Select(paramAge);
        GLAcctAgeUtils.getSql_ByAcctBal_AcInit_From((AccountAgeParam)paramAge);
        GLAcctAgeUtils.getSql_ByAcctBal_AcInit_Where((AccountAgeParam)paramAge);
        this.setAsstActItemFilter(paramAge, paramAge.getSqlWhereInitBalNotZero());
        StringBuffer accountSb = new StringBuffer();
        accountSb.append(", account.fid as acctId, account.fnumber as acctNumber");
        StringBuffer accountGroup = new StringBuffer();
        accountGroup.append(",account.fid,account.fnumber");
        if (!paramAge.isAccountList() && paramAge.getAccountViewNumber() == null && !StringUtils.isEmpty((String)paramAge.getAccountid())) {
            paramAge.getSqlWhereInitBalNotZero().append(" and account.fid in (" + paramAge.getAccountid() + ")   \r\n");
            paramAge.getSqlWhereInit().append("and account.fid in (" + paramAge.getAccountid() + ")   \r\n");
        }
        sql.append("select ").append(paramAge.getSqlSelecthg()).append(paramAge.getSqlSelectInit()).append(accountSb).append(paramAge.getSqlFromInit()).append(paramAge.getSqlInnerJoin()).append(paramAge.getSqlWhereInitBalNotZero()).append(paramAge.getSqlGroupby()).append(accountGroup);
        return sql;
    }

    private void getSql_ByAcctBal_AcInit_Select(AccountAgeParam paramAge) {
        int j;
        StringBuffer sqlSelect = paramAge.getSqlSelectInit();
        StringBuffer sumOnePhase = new StringBuffer(" ,sum(case when cussent.").append(paramAge.getStrDateType_AC()).append("<? and cussent.").append(paramAge.getStrDateType_AC()).append(">=? then ").append(paramAge.getAmountField()).append(" else 0 end) as sum");
        sqlSelect.append("\r\n sum(case when cussent." + paramAge.getStrDateType_AC() + ">=? then ").append(paramAge.getAmountField()).append(" else 0 end) as sumUnOverDue  \r\n");
        if (paramAge.isShowUmexpired()) {
            StringBuffer sumUnOnePhase = new StringBuffer(" ,sum(case when cussent.").append(paramAge.getStrDateType_AC()).append(">=? and cussent.").append(paramAge.getStrDateType_AC()).append("<? then ").append(paramAge.getAmountField()).append(" else 0 end) as sum");
            for (j = 0; j < paramAge.getUndaylen(); ++j) {
                sqlSelect.append(sumUnOnePhase).append(j).append("  \r\n");
            }
            sqlSelect.append("\r\n ,sum(case when cussent." + paramAge.getStrDateType_AC() + ">=? then ").append(paramAge.getAmountField()).append(" else 0 end) as sum" + j + "\r\n");
            ++j;
        }
        int index = 0;
        sqlSelect.append(sumOnePhase).append(j + " \r\n");
        for (int i = 1; i < paramAge.getDaylen(); ++i) {
            index = i + j;
            sqlSelect.append(sumOnePhase).append(index).append("  \r\n");
        }
        index = paramAge.getDaylen() + j;
        sqlSelect.append(sumOnePhase).append(index).append("  \r\n");
    }

    private StringBuffer getSql_ByAcctBal_AcNotInit(AccountAgeParam paramAge) {
        StringBuffer sql = new StringBuffer();
        this.getSql_ByAcctBal_AcNotInit_Select(paramAge);
        GLAcctAgeUtils.getSql_ByAcctBal_AcNotInit_From((AccountAgeParam)paramAge);
        GLAcctAgeUtils.getSql_ByAcctBal_AcNotInit_Where((AccountAgeParam)paramAge);
        this.setAsstActItemFilter(paramAge, paramAge.getSqlWhereNotInitBalNotZero());
        StringBuffer accountSb = new StringBuffer();
        accountSb.append(", account.fid as acctId,account.fnumber as acctNumber");
        StringBuffer accountGroup = new StringBuffer();
        accountGroup.append(",account.fid,account.fnumber");
        if (!paramAge.isAccountList() && paramAge.getAccountViewNumber() == null && !StringUtils.isEmpty((String)paramAge.getAccountid())) {
            paramAge.getSqlWhereNotInitBalNotZero().append(" and account.fid in (" + paramAge.getAccountid() + ")   \r\n");
        }
        sql.append("select ").append(paramAge.getSqlSelecthg()).append(paramAge.getSqlSelectNotInit()).append(accountSb).append(paramAge.getSqlFromTable()).append(paramAge.getSqlInnerJoin()).append(paramAge.getSqlWhereNotInitBalNotZero()).append(paramAge.getSqlGroupby()).append(accountGroup);
        return sql;
    }

    private void getSql_ByAcctBal_AcNotInit_Select(AccountAgeParam paramAge) {
        int j;
        StringBuffer sqlSelect = paramAge.getSqlSelectNotInit();
        StringBuffer sumOnePhase = new StringBuffer(" ,sum(case when cussent.").append(paramAge.getStrDateType_AC()).append("<? and cussent.").append(paramAge.getStrDateType_AC()).append(">=? then ").append(paramAge.getAmountField()).append(" else 0 end) as sum");
        sqlSelect.append("\r\n sum(case when cussent." + paramAge.getStrDateType_AC() + ">=? then ").append(paramAge.getAmountField()).append(" else 0 end) as sumUnOverDue  \r\n");
        if (paramAge.isShowUmexpired()) {
            StringBuffer sumUnOnePhase = new StringBuffer(" ,sum(case when cussent.").append(paramAge.getStrDateType_AC()).append(">=? and cussent.").append(paramAge.getStrDateType_AC()).append("<? then ").append(paramAge.getAmountField()).append(" else 0 end) as sum");
            for (j = 0; j < paramAge.getUndaylen(); ++j) {
                sqlSelect.append(sumUnOnePhase).append(j).append("  \r\n");
            }
            sqlSelect.append("\r\n ,sum(case when cussent." + paramAge.getStrDateType_AC() + ">=? then ").append(paramAge.getAmountField()).append(" else 0 end) as sum" + j + "\r\n");
            ++j;
        }
        int index = 0;
        sqlSelect.append(sumOnePhase).append(j + " \r\n");
        for (int i = 1; i < paramAge.getDaylen(); ++i) {
            index = i + j;
            sqlSelect.append(sumOnePhase).append(index).append("  \r\n");
        }
        index = paramAge.getDaylen() + j;
        sqlSelect.append(sumOnePhase).append(index).append("  \r\n");
    }

    private StringBuffer getSql_InsertAcTemp(AccountAgeParam paramAge, boolean isInclude3SumOverDue, boolean isUseHgOutSideReal) {
        int j;
        StringBuffer sql = new StringBuffer();
        sql.append(" Insert Into ").append(paramAge.getTempTableAcSum());
        sql.append("( ");
        if (paramAge.isIncludeVerifyVch() && isUseHgOutSideReal) {
            sql.append(paramAge.getSqlSelecthgoutsideReal());
        } else {
            sql.append(paramAge.getSqlSelecthgoutside());
        }
        sql.append(",acctId,acctNumber");
        if (isInclude3SumOverDue) {
            sql.append(",leftamount,sumall");
            sql.append(",sumoverdue");
        }
        sql.append(",sumunoverdue");
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j <= paramAge.getUndaylen(); ++j) {
                sql.append(",sum" + j);
            }
        }
        int index = 0;
        for (int i = 0; i <= paramAge.getDaylen(); ++i) {
            index = j + i;
            sql.append(",sum" + index);
        }
        sql.append(") ");
        return sql;
    }

    private void createTempTable_ByBal_AcSum(AccountAgeParam paramAge) throws BOSException, EASBizException {
        int j;
        String tempTableAcSum = null;
        StringBuffer createTable = new StringBuffer();
        createTable.append("( ");
        if (paramAge.getSqlCreateHgTbl().length() > 0) {
            createTable.append(paramAge.getSqlCreateHgTbl());
        }
        createTable.append(" acctId varchar(44) not null, acctNumber nvarchar(80) not null,");
        createTable.append(" leftamount numeric(28,10) not null default 0,sumall numeric(28,10) not null default 0");
        createTable.append(",sumunoverdue numeric(28,10) not null default 0,sumoverdue numeric(28,10) not null default 0");
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j < paramAge.getUndaylen() + 1; ++j) {
                createTable.append(",sum" + j + " numeric(28,10) not null default 0");
            }
        }
        int index = 0;
        for (int i = 0; i < paramAge.getDaylen() + 1; ++i) {
            index = j + i;
            createTable.append(",sum" + index + " numeric(28,10) not null default 0");
        }
        createTable.append(" )");
        tempTableAcSum = GLAcctAgeUtils.createTempTableByDDL((Context)paramAge.getCtx(), (String)"gl_act_age", (StringBuffer)createTable);
        paramAge.setTempTableAcSum(tempTableAcSum);
    }

    private AccountAgeParam getAccountAgeParam(Context ctx, Map param) throws EASBizException, BOSException {
        AccountAgeParam paramAge = new AccountAgeParam();
        paramAge.setCtx(ctx);
        String accountid = (String)param.get("accountid");
        paramAge.setAccountid(accountid);
        String currencyid = (String)param.get("currencyid");
        paramAge.setCurrencyid(currencyid);
        int[] days = (int[])param.get("days");
        paramAge.setDays(this.getDays(days));
        int[] undays = new int[]{};
        paramAge.setUndays(undays);
        paramAge.setUndaylen(0);
        boolean isShowUmexpired = false;
        paramAge.setShowUmexpired(isShowUmexpired);
        java.util.Date endDate = (java.util.Date)param.get("endDate");
        paramAge.setEndDate(endDate);
        java.util.Date historyDate = (java.util.Date)param.get("historyDate");
        paramAge.setHistoryDate(historyDate);
        boolean isIncludeUnPosted = (Boolean)param.get("includeUnPosted");
        paramAge.setIncludeUnPosted(isIncludeUnPosted);
        boolean isIncludeInit = (Boolean)param.get("includeInit");
        paramAge.setIncludeInit(isIncludeInit);
        boolean isIncludeVerifyVch = param.get("includeVerifyVch") == null ? false : (Boolean)param.get("includeVerifyVch");
        paramAge.setIncludeVerifyVch(isIncludeVerifyVch);
        boolean isBizCode = param.get("isBizCode") != null && (Boolean)param.get("isBizCode") != false;
        paramAge.setBizCode(isBizCode);
        String companyId = (String)param.get("companyid");
        paramAge.setCompanyId(companyId);
        int dateType = (Integer)param.get("dateType");
        dateType = dateType == 0 ? 1 : 0;
        paramAge.setDateType(dateType);
        int indexType = (Integer)param.get("indexType");
        Object accountFrom = param.get("accountFrom");
        paramAge.setAccountFrom(accountFrom);
        Object accountTo = param.get("accountTo");
        paramAge.setAccountTo(accountTo);
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        paramAge.setCompany(company);
        boolean isIsOnlyUnion = GlUtils.isCompanyUnion((CompanyOrgUnitInfo)company);
        paramAge.setIsOnlyUnion(isIsOnlyUnion);
        String acctTableId = null;
        if (param.get("accountTable") instanceof String) {
            acctTableId = (String)param.get("accountTable");
        } else if (param.get("accountTable") instanceof BOSUuid) {
            acctTableId = ((BOSUuid)param.get("accountTable")).toString();
        }
        if (acctTableId == null) {
            acctTableId = company.getAccountTable().getId().toString();
        }
        paramAge.setAcctTableId(acctTableId);
        String companyIdsForOnlyUnion = (String)param.get("companyIdsForOnlyUnion");
        HashMap hmItems = (HashMap)param.get("hmItems");
        String[] asstTypes = (String[])param.get("asstTypes");
        if (asstTypes != null) {
            indexType = 0;
            HashMap<String, String> othersParam = null;
            if (isIsOnlyUnion) {
                othersParam = new HashMap<String, String>();
                othersParam.put("companyIds", companyIdsForOnlyUnion);
                othersParam.put("accountTableid", acctTableId);
            }
            IAccountAgeFacade facade = AccountAgeFacadeFactory.getLocalInstance((Context)ctx);
            hmItems = QueryAsstItems.exec(ctx, (String)accountFrom, (String)accountTo, companyId, indexType, historyDate, othersParam, asstTypes);
        } else {
            indexType = 0;
        }
        paramAge.setIndexType(indexType);
        paramAge.setHmItems(hmItems);
        accountid = isIsOnlyUnion ? this.getAccountids(ctx, accountFrom, accountTo, acctTableId, companyIdsForOnlyUnion, isIsOnlyUnion) : this.getAccountids(ctx, accountFrom, accountTo, acctTableId, companyId, isIsOnlyUnion);
        paramAge.setAccountid(accountid);
        if (isIsOnlyUnion) {
            paramAge.setCompanyId(companyIdsForOnlyUnion);
            int companyLevel = (Integer)param.get("curLevel");
            paramAge.setCompanyLevel(companyLevel);
            String curCompanyid = (String)param.get("curCompanyid");
            if (param.get("companyIds") != null) {
                curCompanyid = (String)param.get("companyIds");
            }
            paramAge.setCurCompanyid(curCompanyid);
            HashMap otherInfo = (HashMap)param.get("otherInfo");
            paramAge.setOtherInfo(otherInfo);
            boolean isfirstload = param.get("firstLoad").toString().equals("true");
            paramAge.setIsfirstload(isfirstload);
            String accountViewNumber = null;
            if (param.get("accountViewNumber") != null) {
                accountViewNumber = (String)param.get("accountViewNumber");
                accountid = null;
                paramAge.setAccountid(accountid);
            } else {
                if (otherInfo != null && otherInfo.get("accountViewNumber") != null) {
                    accountViewNumber = otherInfo.get("accountViewNumber").toString();
                }
                otherInfo = null;
            }
            paramAge.setAccountViewNumber(accountViewNumber);
        } else {
            if (!isBizCode || indexType != 1) {
                accountid = accountid != null && accountid.indexOf("'") == -1 ? "'" + accountid + "'" : accountid;
            }
            String accountViewNumber = null;
            if (indexType == 0 && param.get("accountViewNumber") != null) {
                accountViewNumber = (String)param.get("accountViewNumber");
                accountid = null;
            }
            paramAge.setAccountid(accountid);
            paramAge.setAccountViewNumber(accountViewNumber);
            CompanyOrgUnitInfo curCompany = null;
            curCompany = companyId != null ? GlUtils.getCompanyById((Context)ctx, (String)companyId) : company;
            paramAge.setCurCompanyid(companyId);
            paramAge.setCompany(curCompany);
        }
        return paramAge;
    }

    private String getAccountids(Context ctx, Object accountFrom, Object accountTo, String accountTableid, String companyid, boolean isUnion) throws BOSException {
        StringBuffer sqlIdsParam = new StringBuffer();
        Map accountNumbermap = this.getAccountParam((String)accountFrom, (String)accountTo);
        StringBuffer sql = new StringBuffer();
        String sqlAccountParams = null;
        if (accountNumbermap.get("accountIns") != null && accountNumbermap.get("accountIns") != "") {
            sqlAccountParams = (String)accountNumbermap.get("accountIns");
        }
        sql.append("select Fid id \r\n");
        sql.append("from T_BD_ACCOUNTVIEW \r\n");
        sql.append("where FAccountTableid = '" + accountTableid + "' \r\n");
        if (isUnion) {
            sql.append("and FCompanyid in (" + companyid + ") \r\n");
        } else {
            sql.append("and FCompanyid = '" + companyid + "' \r\n");
        }
        if (accountNumbermap.get("accountIns") != null && accountNumbermap.get("accountIns") != "" && !StringUtils.isEmpty((String)sqlAccountParams)) {
            sql.append(" and (");
            String[] nums = sqlAccountParams.split(",");
            for (int i = 0; i < nums.length; ++i) {
                sql.append(" FNumber like " + nums[i] + " \n");
                if (i >= nums.length - 1) continue;
                sql.append(" or \n");
            }
            sql.append(" ) \n");
        } else if (accountFrom.equals(accountTo)) {
            String from = accountFrom + "%";
            sql.append(" and FNumber like '").append(from).append("' \n");
        } else {
            String to = accountTo + "%";
            sql.append(" and FNumber >= '" + accountFrom + "'").append(" and (FNumber <= '" + accountTo + "'").append(" or FNumber like '" + to + "') \n");
        }
        sql.append(" and FISLEAF = 1 \n");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                String id = rs.getString("id");
                sqlIdsParam.append("'").append(id).append("'").append(",");
            }
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (sqlIdsParam.length() > 0) {
            sqlIdsParam.deleteCharAt(sqlIdsParam.length() - 1);
        }
        return sqlIdsParam.toString();
    }

    private Map getAccountParam(String accountFrom, String accountTo) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] acctFroms = new String[]{};
        if (accountFrom != null) {
            acctFroms = accountFrom.split(";");
        }
        String[] acctTos = new String[]{};
        if (accountTo != null) {
            acctTos = accountTo.split(";");
        }
        String acctIns = "";
        if (acctFroms.length > 0 && acctTos.length > 0) {
            if (acctFroms[acctFroms.length - 1].compareTo(acctTos[0]) > 0) {
                int i;
                for (i = 0; i < acctFroms.length; ++i) {
                    String from = acctFroms[i] + "%";
                    acctIns = acctIns + "'" + from + "',";
                }
                for (i = 0; i < acctTos.length; ++i) {
                    String to = acctTos[i] + "%";
                    acctIns = acctIns + "'" + to + "',";
                }
                accountFrom = null;
                accountTo = null;
            } else {
                int i;
                for (i = 0; i < acctFroms.length - 1; ++i) {
                    String from = acctFroms[i] + "%";
                    acctIns = acctIns + "'" + from + "',";
                }
                for (i = 1; i < acctTos.length; ++i) {
                    String to = acctTos[i] + "%";
                    acctIns = acctIns + "'" + to + "',";
                }
                accountFrom = acctFroms[acctFroms.length - 1];
                accountTo = acctTos[0];
            }
        } else if (acctFroms.length > 0) {
            for (int i = 0; i < acctFroms.length - 1; ++i) {
                String from = acctFroms[i] + "%";
                acctIns = acctIns + "'" + from + "',";
            }
            accountFrom = acctFroms[acctFroms.length - 1];
        } else if (acctTos.length > 0) {
            for (int i = 1; i < acctTos.length; ++i) {
                String to = acctTos[i] + "%";
                acctIns = acctIns + "'" + to + "',";
            }
            accountTo = acctTos[0];
        }
        result.put("accountFrom", accountFrom);
        result.put("accountTo", accountTo);
        result.put("accountIns", acctIns.length() > 0 ? acctIns.substring(0, acctIns.length() - 1) : "");
        return result;
    }

    private int[] getDays(int[] days) {
        if (days != null && days.length > 0 && days[days.length - 1] == Integer.MAX_VALUE) {
            int[] daysForRemoveMaxNumber = new int[days.length - 1];
            System.arraycopy(days, 0, daysForRemoveMaxNumber, 0, days.length - 1);
            days = daysForRemoveMaxNumber;
        } else if (days.length == 2) {
            int from = days[0];
            if (from <= 0) {
                from = 0;
            }
            int to = days[1];
            days = new int[days.length];
            days[0] = --from;
            days[1] = to;
        }
        return days;
    }

    public void setDebugModel(DebugModel debugModel) {
        this.debugModel = debugModel;
    }
}

