/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.dyitem;

import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSortState;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSorterProcessor;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.IFormulaCombinationPreparedState;
import com.kingdee.eas.fi.rpt.batch.dyitem.DyItemCalculator;
import com.kingdee.eas.fi.rpt.batch.dyitem.MultiDyItemSortState;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.RptUtilForServer;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class MultiDyItemProccessor
implements IBatchSQLSorterProcessor {
    private static Logger logger = Logger.getLogger(MultiDyItemProccessor.class);
    private int batchSize;
    private MultiDyItemSortState sortState;
    private String[] IndexResultSetFields;
    private String selectPart;
    private String fromPart;
    private String groupByPart;
    private boolean isIncludeUnCommit = false;
    private MultiDynaCombinState combineState = new MultiDynaCombinState();

    @Override
    public void buildSelectPart(Set nullSet, StringBuffer sql) {
        sql.append(this.selectPart);
    }

    private String doBuildSelectPart() {
        StringBuffer sql = new StringBuffer();
        if (this.sortState.getValueType() == 3) {
            sql.append(" select ItemDataEntry.FTextValue Value ");
        } else {
            sql.append(" select sum(ItemDataEntry.FValue) Value ");
        }
        if (this.sortState.getCompanyNumber() == null) {
            sql.append(" ,BaseUnit.FNumber CompanyNumber\t ");
        }
        if (this.sortState.getDataElement() == -257) {
            sql.append(" ,ItemDataEntry.FDataElement DataElement\t ");
        }
        sql.append(" ,ItemDataEntry.FItemID ItemNumber ");
        if (this.sortState.getAsstActTypeList() != null) {
            for (AsstActTypeInfo asstActTypeInfo : this.sortState.getAsstActTypeList()) {
                String numberOrLongNumber = RptUtil.isUseLongNumber(asstActTypeInfo) && !this.sortState.getIsShortNum() ? ".FLongNumber" : ".FNumber";
                String asstActTypeNumber = asstActTypeInfo.getNumber();
                if (!this.sortState.getAsstItemSign().contains(asstActTypeNumber) || this.sortState.getRangeAsstSet().contains(asstActTypeNumber)) continue;
                asstActTypeNumber = this.replaceCharForAsstActTypeNumber(asstActTypeNumber);
                sql.append(",AsstActType").append(asstActTypeNumber).append(numberOrLongNumber).append(" Number").append(asstActTypeNumber);
            }
        }
        return sql.toString();
    }

    @Override
    public void buildFromPart(Set nullSet, StringBuffer sql) {
        sql.append(this.fromPart);
    }

    private String doBuildFromPart() {
        StringBuffer sql = new StringBuffer();
        sql.append(" from T_CSL_MultiDynaItemData ItemData ");
        sql.append(" inner join T_CSL_MultiDynaItemDataEntry ItemDataEntry on ItemData.FID=ItemDataEntry.FItemDataID ");
        sql.append(" inner join T_CSL_RptReceived RptReceived\ton ItemData.FReportID=RptReceived.FReportID  ");
        sql.append(" inner join T_ORG_Tree OrgTree on OrgTree.FID = RptReceived.FOrgTreeId ");
        sql.append(" inner join T_Org_BaseUnit BaseUnit on ItemData.FOrgUnitID=BaseUnit.FID ");
        sql.append(" inner join T_BD_Currency SrcCurrency on ItemData.FSourceCurrencyId = SrcCurrency.FId ");
        sql.append(" inner join T_BD_Currency Currency on ItemData.FCurrencyID=Currency.FID\t ");
        if (this.sortState.getAsstActTypeList() != null && this.sortState.getAsstActTypeList().size() > 0) {
            sql.append(" inner join T_CSL_CslRptAssistantHG hg on hg.FID = ItemDataEntry.FCslRptAssistantHGId ");
            String asstActTypeNumber = null;
            for (AsstActTypeInfo asstActTypeInfo : this.sortState.getAsstActTypeList()) {
                asstActTypeNumber = this.replaceCharForAsstActTypeNumber(asstActTypeInfo.getNumber());
                sql.append(" inner join ").append(asstActTypeInfo.getRealtionDataObject()).append(" AsstActType").append(asstActTypeNumber);
                sql.append(" on hg.").append(asstActTypeInfo.getMappingFieldName()).append(" = AsstActType").append(asstActTypeNumber).append(".FID");
            }
        }
        return sql.toString();
    }

    @Override
    public void builderConstantWherePart(Set nullSet, StringBuffer sql, List params) {
        sql.append(" Where  OrgTree.FNumber = ? ");
        params.add(this.sortState.getOrgTreeNumber());
        if (!StringUtils.isEmpty((String)this.sortState.getSourceCurrency())) {
            sql.append(" and  SrcCurrency.FNumber = ? ");
            params.add(this.sortState.getSourceCurrency());
        }
        sql.append(" and Currency.FNumber = ? ");
        params.add(this.sortState.getCurrency());
        sql.append(" and ItemData.FPeriodType = ? ");
        params.add(new Integer(this.sortState.getPeriodType()));
        sql.append(" and ItemData.FDataSource = ? ");
        params.add(new Integer(this.sortState.getDataSource()));
        sql.append(" and ItemDataEntry.FValueType = ? ");
        params.add(new Integer(this.sortState.getValueType()));
        if (!StringUtils.isEmpty((String)this.sortState.getCompanyNumber())) {
            sql.append(" and BaseUnit.FNumber = ? ");
            params.add(this.sortState.getCompanyNumber());
        } else {
            try {
                sql.append(" and BaseUnit.FNumber in ");
                sql.append(RptUtilForServer.createInSql(this.sortState.getMultiCompanySet().iterator(), params));
            }
            catch (SQLDataException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (this.sortState.getDataElement() != -257) {
            sql.append(" and ItemDataEntry.FDataElement = ? ");
            params.add(new Integer(this.sortState.getDataElement()));
        } else {
            try {
                sql.append(" and ItemDataEntry.FDataElement in ");
                sql.append(RptUtilForServer.createInSql(this.sortState.getMultiDataElementSet().iterator(), params));
            }
            catch (SQLDataException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (!this.isIncludeUnCommit && this.sortState.isNeedCommitStatus()) {
            sql.append(" and ItemData.FCommitStatus = 3 ");
        }
        if (this.sortState.isSamePeriod()) {
            sql.append(" and ItemData.FYear = ? ");
            sql.append(" and ItemData.FPeriod = ? ");
            params.add(new Integer(this.sortState.getStartYear()));
            params.add(new Integer(this.sortState.getStartPeriod()));
        } else if (this.sortState.isSameYear()) {
            sql.append(" and ItemData.FYear = ? ");
            params.add(new Integer(this.sortState.getStartYear()));
            sql.append(" and ItemData.FPeriod >= ? ");
            sql.append(" and ItemData.FPeriod <= ? ");
            params.add(new Integer(this.sortState.getStartPeriod()));
            params.add(new Integer(this.sortState.getEndPeriod()));
        } else {
            sql.append(" and (  (ItemData.FYear = ? and ItemData.FPeriod >=  ? )  or ");
            params.add(new Integer(this.sortState.getStartYear()));
            params.add(new Integer(this.sortState.getStartPeriod()));
            sql.append("   ( ItemData.FYear > ?  and ItemData.FYear < ?  ) or ");
            params.add(new Integer(this.sortState.getStartYear()));
            params.add(new Integer(this.sortState.getEndYear()));
            sql.append(" (ItemData.FYear = ? and ItemData.FPeriod <=  ? ) )");
            params.add(new Integer(this.sortState.getEndYear()));
            params.add(new Integer(this.sortState.getEndPeriod()));
        }
        if (this.sortState.getAsstItemList() != null) {
            String asstActTypeNumber = null;
            for (String[] asst : this.sortState.getAsstItemList()) {
                asstActTypeNumber = this.replaceCharForAsstActTypeNumber(asst[0]);
                sql.append(" and AsstActType").append(asstActTypeNumber).append(asst[3]).append(" >= ? ");
                sql.append(" and AsstActType").append(asstActTypeNumber).append(asst[3]).append(" <= ? ");
                params.add(asst[1]);
                params.add(asst[2]);
            }
        }
        sql.append(" and (");
    }

    private String replaceCharForAsstActTypeNumber(String asstActTypeNumber) {
        if (StringUtils.isEmpty((String)asstActTypeNumber)) {
            return asstActTypeNumber;
        }
        asstActTypeNumber = asstActTypeNumber.replace("-", "aa");
        asstActTypeNumber = asstActTypeNumber.replace("$", "bb");
        asstActTypeNumber = asstActTypeNumber.replace(".", "cc");
        return asstActTypeNumber;
    }

    @Override
    public void buildVariableWherePart(StringBuffer sql, List params, IFormulaCalculator formula) {
        sql.append("(");
        DyItemCalculator.DyItem dyItem = (DyItemCalculator.DyItem)formula;
        sql.append(" ItemDataEntry.FItemID = ? ");
        params.add(dyItem.itemNumber);
        if (this.sortState.getAsstActTypeList() != null) {
            for (AsstActTypeInfo asstActTypeInfo : this.sortState.getAsstActTypeList()) {
                String numberOrLongNumber;
                String asstActTypeNumber = asstActTypeInfo.getNumber();
                String string = numberOrLongNumber = RptUtil.isUseLongNumber(asstActTypeInfo) && !dyItem.isShortNum ? ".FLongNumber" : ".FNumber";
                if (!this.sortState.getAsstItemSign().contains(asstActTypeNumber) || this.sortState.getRangeAsstSet().contains(asstActTypeNumber)) continue;
                params.add(dyItem.dynaItem.getAsstItemNumber(asstActTypeNumber));
                asstActTypeNumber = this.replaceCharForAsstActTypeNumber(asstActTypeNumber);
                sql.append(" and AsstActType").append(asstActTypeNumber).append(numberOrLongNumber).append(" = ? ");
            }
        }
        if (StringUtils.isEmpty((String)this.sortState.getCompanyNumber())) {
            sql.append(" and BaseUnit.FNumber = ? ");
            params.add(dyItem.orgUnitNumber);
        }
        if (this.sortState.getDataElement() == -257) {
            sql.append(" and ItemDataEntry.FDataElement = ? ");
            params.add(new Integer(dyItem.int_dataElement));
        }
        sql.append(")");
    }

    @Override
    public void buildGroupByPart(Set nullSet, StringBuffer sql) {
        sql.append(this.groupByPart);
    }

    private String doBuildGroupByPart() {
        StringBuffer sql = new StringBuffer();
        sql.append(")");
        if (this.sortState.getValueType() == 3) {
            return sql.toString();
        }
        sql.append("group by ItemDataEntry.FItemID ");
        if (StringUtils.isEmpty((String)this.sortState.getCompanyNumber())) {
            sql.append(" ,BaseUnit.FNumber  ");
        }
        if (this.sortState.getDataElement() == -257) {
            sql.append(" ,ItemDataEntry.FDataElement ");
        }
        if (this.sortState.getAsstActTypeList() != null) {
            for (AsstActTypeInfo asstActTypeInfo : this.sortState.getAsstActTypeList()) {
                String numberOrLongNumber;
                String asstActTypeNumber = asstActTypeInfo.getNumber();
                String string = numberOrLongNumber = RptUtil.isUseLongNumber(asstActTypeInfo) && !this.sortState.getIsShortNum() ? ".FLongNumber" : ".FNumber";
                if (!this.sortState.getAsstItemSign().contains(asstActTypeNumber) || this.sortState.getRangeAsstSet().contains(asstActTypeNumber)) continue;
                asstActTypeNumber = this.replaceCharForAsstActTypeNumber(asstActTypeNumber);
                sql.append(" , AsstActType").append(asstActTypeNumber).append(numberOrLongNumber);
            }
        }
        return sql.toString();
    }

    public MultiDyItemProccessor(int batchSize, boolean isIncludeUnCommit) {
        this.batchSize = batchSize;
        this.isIncludeUnCommit = isIncludeUnCommit;
    }

    @Override
    public void setSortState(IBatchSQLSortState sortState) {
        this.sortState = (MultiDyItemSortState)sortState;
        this.IndexResultSetFields = this.initIndexFields();
        this.selectPart = this.doBuildSelectPart();
        this.fromPart = this.doBuildFromPart();
        this.groupByPart = this.doBuildGroupByPart();
    }

    @Override
    public IFormulaCombinationPreparedState getCombineState() {
        return this.combineState;
    }

    @Override
    public Object[][] getIndexFormulaFields(IFormulaCalculator formula) {
        DyItemCalculator.DyItem dyItem = (DyItemCalculator.DyItem)formula;
        ArrayList<Object> fieldList = new ArrayList<Object>();
        fieldList.add(dyItem.itemNumber);
        if (this.sortState.getAsstActTypeList() != null) {
            for (AsstActTypeInfo asstActTypeInfo : this.sortState.getAsstActTypeList()) {
                String asstActTypeNumber = asstActTypeInfo.getNumber();
                if (!this.sortState.getAsstItemSign().contains(asstActTypeNumber) || this.sortState.getRangeAsstSet().contains(asstActTypeNumber)) continue;
                fieldList.add(dyItem.dynaItem.getAsstItemNumber(asstActTypeNumber));
            }
        }
        if (StringUtils.isEmpty((String)this.sortState.getCompanyNumber())) {
            fieldList.add(dyItem.orgUnitNumber);
        }
        if (this.sortState.getDataElement() == -257) {
            fieldList.add(new Integer(dyItem.int_dataElement));
        }
        Object[][] result = new Object[1][fieldList.size()];
        result[0] = fieldList.toArray();
        return result;
    }

    @Override
    public String[] getIndexResultSetFields() {
        return this.IndexResultSetFields;
    }

    private String[] initIndexFields() {
        ArrayList<String> indexedFields = new ArrayList<String>();
        indexedFields.add("ItemNumber");
        if (this.sortState.getAsstActTypeList() != null) {
            for (AsstActTypeInfo asstActTypeInfo : this.sortState.getAsstActTypeList()) {
                String asstActTypeNumber = asstActTypeInfo.getNumber();
                if (!this.sortState.getAsstItemSign().contains(asstActTypeNumber) || this.sortState.getRangeAsstSet().contains(asstActTypeNumber)) continue;
                asstActTypeNumber = this.replaceCharForAsstActTypeNumber(asstActTypeNumber);
                indexedFields.add("Number" + asstActTypeNumber);
            }
        }
        if (StringUtils.isEmpty((String)this.sortState.getCompanyNumber())) {
            indexedFields.add("CompanyNumber");
        }
        if (this.sortState.getDataElement() == -257) {
            indexedFields.add("DataElement");
        }
        String[] result = new String[indexedFields.size()];
        indexedFields.toArray(result);
        return result;
    }

    @Override
    public int getMaxSQLVaribleSize() {
        return this.batchSize;
    }

    @Override
    public void prepareStateForCombine(IRowSet rs, IFormulaCombinationPreparedState combineState) throws SQLException {
        MultiDynaCombinState state = (MultiDynaCombinState)combineState;
        state.setValue(rs.getObject("Value"));
    }

    @Override
    public Set getAllowedNullFields() {
        return null;
    }

    @Override
    public List getFormulaCalculators() {
        return this.sortState.getFormulaList();
    }

    private class MultiDynaCombinState
    implements IFormulaCombinationPreparedState {
        private Object value;

        private MultiDynaCombinState() {
        }

        @Override
        public Object getFormulaResultValue(IFormulaCalculator formula) {
            return this.value;
        }

        @Override
        public boolean isFormulaResultNumberValue(IFormulaCalculator formula) {
            DyItemCalculator.DyItem dyItem = (DyItemCalculator.DyItem)formula;
            return dyItem.int_valueType != 3;
        }

        @Override
        public boolean isPrepared(IFormulaCalculator formula) {
            return true;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

